# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCockpitSourceResult',
    'AwaitableGetCockpitSourceResult',
    'get_cockpit_source',
    'get_cockpit_source_output',
]

warnings.warn("""scaleway.index/getcockpitsource.getCockpitSource has been deprecated in favor of scaleway.observability/getsource.getSource""", DeprecationWarning)

@pulumi.output_type
class GetCockpitSourceResult:
    """
    A collection of values returned by getCockpitSource.
    """
    def __init__(__self__, created_at=None, id=None, name=None, origin=None, project_id=None, push_url=None, region=None, retention_days=None, synchronized_with_grafana=None, type=None, updated_at=None, url=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if origin and not isinstance(origin, str):
            raise TypeError("Expected argument 'origin' to be a str")
        pulumi.set(__self__, "origin", origin)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if push_url and not isinstance(push_url, str):
            raise TypeError("Expected argument 'push_url' to be a str")
        pulumi.set(__self__, "push_url", push_url)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if retention_days and not isinstance(retention_days, int):
            raise TypeError("Expected argument 'retention_days' to be a int")
        pulumi.set(__self__, "retention_days", retention_days)
        if synchronized_with_grafana and not isinstance(synchronized_with_grafana, bool):
            raise TypeError("Expected argument 'synchronized_with_grafana' to be a bool")
        pulumi.set(__self__, "synchronized_with_grafana", synchronized_with_grafana)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date and time the data source was created (in RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the data source in the `{region}/{id}` format.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def origin(self) -> Optional[builtins.str]:
        """
        The origin of the data source.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="pushUrl")
    def push_url(self) -> builtins.str:
        return pulumi.get(self, "push_url")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> builtins.int:
        """
        The number of days the data is retained in the data source.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter(name="synchronizedWithGrafana")
    def synchronized_with_grafana(self) -> builtins.bool:
        """
        Indicates whether the data source is synchronized with Grafana.
        """
        return pulumi.get(self, "synchronized_with_grafana")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date and time the data source was last updated (in RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL of the Cockpit data source.
        """
        return pulumi.get(self, "url")


class AwaitableGetCockpitSourceResult(GetCockpitSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCockpitSourceResult(
            created_at=self.created_at,
            id=self.id,
            name=self.name,
            origin=self.origin,
            project_id=self.project_id,
            push_url=self.push_url,
            region=self.region,
            retention_days=self.retention_days,
            synchronized_with_grafana=self.synchronized_with_grafana,
            type=self.type,
            updated_at=self.updated_at,
            url=self.url)


def get_cockpit_source(id: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       origin: Optional[builtins.str] = None,
                       project_id: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       type: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCockpitSourceResult:
    """
    The `observability.Source` data source allows you to retrieve information about a specific [data source](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#data-sources) in Scaleway's Cockpit.

    Refer to Cockpit's [product documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/) and [API documentation](https://www.scaleway.com/en/developers/api/cockpit/regional-api) for more information.

    ## Example Usage

    ### Retrieve a specific data source by ID

    The following example retrieves a Cockpit data source by its unique ID.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    example = scaleway.observability.get_source(id="fr-par/11111111-1111-1111-1111-111111111111")
    ```

    ### Retrieve a data source by filters

    You can also retrieve a data source by specifying filtering criteria such as `name`, `type`, and `origin`.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    filtered = scaleway.observability.get_source(project_id="11111111-1111-1111-1111-111111111111",
        region="fr-par",
        name="my-data-source")
    ```


    :param builtins.str id: The unique identifier of the Cockpit data source in the `{region}/{id}` format. If specified, other filters are ignored.
    :param builtins.str name: The name of the data source.
    :param builtins.str origin: The origin of the data source. Possible values are:
    :param builtins.str project_id: The ID of the Project the data source is associated with. Defaults to the Project ID specified in the provider configuration.
    :param builtins.str region: The region where the data source is located. Defaults to the region specified in the provider configuration.
    :param builtins.str type: The [type](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#data-types) of data source. Possible values are: `metrics`, `logs`, or `traces`.
    """
    pulumi.log.warn("""get_cockpit_source is deprecated: scaleway.index/getcockpitsource.getCockpitSource has been deprecated in favor of scaleway.observability/getsource.getSource""")
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['origin'] = origin
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getCockpitSource:getCockpitSource', __args__, opts=opts, typ=GetCockpitSourceResult).value

    return AwaitableGetCockpitSourceResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        origin=pulumi.get(__ret__, 'origin'),
        project_id=pulumi.get(__ret__, 'project_id'),
        push_url=pulumi.get(__ret__, 'push_url'),
        region=pulumi.get(__ret__, 'region'),
        retention_days=pulumi.get(__ret__, 'retention_days'),
        synchronized_with_grafana=pulumi.get(__ret__, 'synchronized_with_grafana'),
        type=pulumi.get(__ret__, 'type'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        url=pulumi.get(__ret__, 'url'))
def get_cockpit_source_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              origin: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCockpitSourceResult]:
    """
    The `observability.Source` data source allows you to retrieve information about a specific [data source](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#data-sources) in Scaleway's Cockpit.

    Refer to Cockpit's [product documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/) and [API documentation](https://www.scaleway.com/en/developers/api/cockpit/regional-api) for more information.

    ## Example Usage

    ### Retrieve a specific data source by ID

    The following example retrieves a Cockpit data source by its unique ID.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    example = scaleway.observability.get_source(id="fr-par/11111111-1111-1111-1111-111111111111")
    ```

    ### Retrieve a data source by filters

    You can also retrieve a data source by specifying filtering criteria such as `name`, `type`, and `origin`.

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    filtered = scaleway.observability.get_source(project_id="11111111-1111-1111-1111-111111111111",
        region="fr-par",
        name="my-data-source")
    ```


    :param builtins.str id: The unique identifier of the Cockpit data source in the `{region}/{id}` format. If specified, other filters are ignored.
    :param builtins.str name: The name of the data source.
    :param builtins.str origin: The origin of the data source. Possible values are:
    :param builtins.str project_id: The ID of the Project the data source is associated with. Defaults to the Project ID specified in the provider configuration.
    :param builtins.str region: The region where the data source is located. Defaults to the region specified in the provider configuration.
    :param builtins.str type: The [type](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#data-types) of data source. Possible values are: `metrics`, `logs`, or `traces`.
    """
    pulumi.log.warn("""get_cockpit_source is deprecated: scaleway.index/getcockpitsource.getCockpitSource has been deprecated in favor of scaleway.observability/getsource.getSource""")
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['origin'] = origin
    __args__['projectId'] = project_id
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getCockpitSource:getCockpitSource', __args__, opts=opts, typ=GetCockpitSourceResult)
    return __ret__.apply(lambda __response__: GetCockpitSourceResult(
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        origin=pulumi.get(__response__, 'origin'),
        project_id=pulumi.get(__response__, 'project_id'),
        push_url=pulumi.get(__response__, 'push_url'),
        region=pulumi.get(__response__, 'region'),
        retention_days=pulumi.get(__response__, 'retention_days'),
        synchronized_with_grafana=pulumi.get(__response__, 'synchronized_with_grafana'),
        type=pulumi.get(__response__, 'type'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        url=pulumi.get(__response__, 'url')))
