# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'HostingCpanelUrlArgs',
    'HostingCpanelUrlArgsDict',
    'HostingNameServerArgs',
    'HostingNameServerArgsDict',
    'HostingOptionArgs',
    'HostingOptionArgsDict',
    'HostingRecordArgs',
    'HostingRecordArgsDict',
]

MYPY = False

if not MYPY:
    class HostingCpanelUrlArgsDict(TypedDict):
        dashboard: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL of the Dashboard.
        """
        webmail: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL of the Webmail interface.
        """
elif False:
    HostingCpanelUrlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HostingCpanelUrlArgs:
    def __init__(__self__, *,
                 dashboard: Optional[pulumi.Input[builtins.str]] = None,
                 webmail: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] dashboard: The URL of the Dashboard.
        :param pulumi.Input[builtins.str] webmail: The URL of the Webmail interface.
        """
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if webmail is not None:
            pulumi.set(__self__, "webmail", webmail)

    @property
    @pulumi.getter
    def dashboard(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the Dashboard.
        """
        return pulumi.get(self, "dashboard")

    @dashboard.setter
    def dashboard(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dashboard", value)

    @property
    @pulumi.getter
    def webmail(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the Webmail interface.
        """
        return pulumi.get(self, "webmail")

    @webmail.setter
    def webmail(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webmail", value)


if not MYPY:
    class HostingNameServerArgsDict(TypedDict):
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        Hostname of the server
        """
        is_default: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not the webhosting is the default one
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        The hosting status.
        """
elif False:
    HostingNameServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HostingNameServerArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] hostname: Hostname of the server
        :param pulumi.Input[builtins.bool] is_default: Whether or not the webhosting is the default one
        :param pulumi.Input[builtins.str] status: The hosting status.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname of the server
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the webhosting is the default one
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hosting status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class HostingOptionArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The option ID.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The option name.
        """
elif False:
    HostingOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HostingOptionArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: The option ID.
        :param pulumi.Input[builtins.str] name: The option name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The option ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The option name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class HostingRecordArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The option name.
        """
        priority: NotRequired[pulumi.Input[builtins.int]]
        """
        Priority of DNS records associated with the webhosting.
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        The hosting status.
        """
        ttl: NotRequired[pulumi.Input[builtins.int]]
        """
        Time to live in seconds of the record
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of the DNS record
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        Value of the DNS record
        """
elif False:
    HostingRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HostingRecordArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The option name.
        :param pulumi.Input[builtins.int] priority: Priority of DNS records associated with the webhosting.
        :param pulumi.Input[builtins.str] status: The hosting status.
        :param pulumi.Input[builtins.int] ttl: Time to live in seconds of the record
        :param pulumi.Input[builtins.str] type: Type of the DNS record
        :param pulumi.Input[builtins.str] value: Value of the DNS record
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The option name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Priority of DNS records associated with the webhosting.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hosting status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time to live in seconds of the record
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the DNS record
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value of the DNS record
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


