# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSnapshotResult',
    'AwaitableGetSnapshotResult',
    'get_snapshot',
    'get_snapshot_output',
]

@pulumi.output_type
class GetSnapshotResult:
    """
    A collection of values returned by getSnapshot.
    """
    def __init__(__self__, created_at=None, id=None, imports=None, name=None, organization_id=None, project_id=None, size_in_gb=None, snapshot_id=None, tags=None, type=None, volume_id=None, zone=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if imports and not isinstance(imports, list):
            raise TypeError("Expected argument 'imports' to be a list")
        pulumi.set(__self__, "imports", imports)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if size_in_gb and not isinstance(size_in_gb, int):
            raise TypeError("Expected argument 'size_in_gb' to be a int")
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        if snapshot_id and not isinstance(snapshot_id, str):
            raise TypeError("Expected argument 'snapshot_id' to be a str")
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if volume_id and not isinstance(volume_id, str):
            raise TypeError("Expected argument 'volume_id' to be a str")
        pulumi.set(__self__, "volume_id", volume_id)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def imports(self) -> Sequence['outputs.GetSnapshotImportResult']:
        return pulumi.get(self, "imports")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> builtins.int:
        return pulumi.get(self, "size_in_gb")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> builtins.str:
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetSnapshotResult(GetSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotResult(
            created_at=self.created_at,
            id=self.id,
            imports=self.imports,
            name=self.name,
            organization_id=self.organization_id,
            project_id=self.project_id,
            size_in_gb=self.size_in_gb,
            snapshot_id=self.snapshot_id,
            tags=self.tags,
            type=self.type,
            volume_id=self.volume_id,
            zone=self.zone)


def get_snapshot(name: Optional[builtins.str] = None,
                 project_id: Optional[builtins.str] = None,
                 snapshot_id: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotResult:
    """
    Gets information about an instance snapshot.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by snapshot name
    by_name = scaleway.instance.get_snapshot(name="my-snapshot-name")
    # Get info by snapshot ID
    by_id = scaleway.instance.get_snapshot(snapshot_id="11111111-1111-1111-1111-111111111111")
    ```


    :param builtins.str name: The snapshot name.
           Only one of `name` and `snapshot_id` should be specified.
    :param builtins.str project_id: `project_id`) The ID of the project the snapshot is associated with.
    :param builtins.str snapshot_id: The snapshot id.
           Only one of `name` and `snapshot_id` should be specified.
    :param builtins.str zone: `zone`) The zone in which the snapshot exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['snapshotId'] = snapshot_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:instance/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult).value

    return AwaitableGetSnapshotResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        imports=pulumi.get(__ret__, 'imports'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        size_in_gb=pulumi.get(__ret__, 'size_in_gb'),
        snapshot_id=pulumi.get(__ret__, 'snapshot_id'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        volume_id=pulumi.get(__ret__, 'volume_id'),
        zone=pulumi.get(__ret__, 'zone'))
def get_snapshot_output(name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        snapshot_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSnapshotResult]:
    """
    Gets information about an instance snapshot.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by snapshot name
    by_name = scaleway.instance.get_snapshot(name="my-snapshot-name")
    # Get info by snapshot ID
    by_id = scaleway.instance.get_snapshot(snapshot_id="11111111-1111-1111-1111-111111111111")
    ```


    :param builtins.str name: The snapshot name.
           Only one of `name` and `snapshot_id` should be specified.
    :param builtins.str project_id: `project_id`) The ID of the project the snapshot is associated with.
    :param builtins.str snapshot_id: The snapshot id.
           Only one of `name` and `snapshot_id` should be specified.
    :param builtins.str zone: `zone`) The zone in which the snapshot exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['snapshotId'] = snapshot_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:instance/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult)
    return __ret__.apply(lambda __response__: GetSnapshotResult(
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        imports=pulumi.get(__response__, 'imports'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        size_in_gb=pulumi.get(__response__, 'size_in_gb'),
        snapshot_id=pulumi.get(__response__, 'snapshot_id'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        volume_id=pulumi.get(__response__, 'volume_id'),
        zone=pulumi.get(__response__, 'zone')))
