# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IpArgs', 'Ip']

@pulumi.input_type
class IpArgs:
    def __init__(__self__, *,
                 sources: pulumi.Input[Sequence[pulumi.Input['IpSourceArgs']]],
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 custom_resources: Optional[pulumi.Input[Sequence[pulumi.Input['IpCustomResourceArgs']]]] = None,
                 is_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Ip resource.
        :param pulumi.Input[Sequence[pulumi.Input['IpSourceArgs']]] sources: The source in which to book the IP.
        :param pulumi.Input[builtins.str] address: Request a specific IP in the requested source pool
        :param pulumi.Input[Sequence[pulumi.Input['IpCustomResourceArgs']]] custom_resources: The custom resource in which to book the IP
        :param pulumi.Input[builtins.bool] is_ipv6: Defines whether to request an IPv6 address instead of IPv4.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the IP is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region of the IP.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the IP.
        """
        pulumi.set(__self__, "sources", sources)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if custom_resources is not None:
            pulumi.set(__self__, "custom_resources", custom_resources)
        if is_ipv6 is not None:
            pulumi.set(__self__, "is_ipv6", is_ipv6)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input['IpSourceArgs']]]:
        """
        The source in which to book the IP.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input['IpSourceArgs']]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Request a specific IP in the requested source pool
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="customResources")
    def custom_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpCustomResourceArgs']]]]:
        """
        The custom resource in which to book the IP
        """
        return pulumi.get(self, "custom_resources")

    @custom_resources.setter
    def custom_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpCustomResourceArgs']]]]):
        pulumi.set(self, "custom_resources", value)

    @property
    @pulumi.getter(name="isIpv6")
    def is_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether to request an IPv6 address instead of IPv4.
        """
        return pulumi.get(self, "is_ipv6")

    @is_ipv6.setter
    def is_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_ipv6", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the IP is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region of the IP.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the IP.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IpState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 custom_resources: Optional[pulumi.Input[Sequence[pulumi.Input['IpCustomResourceArgs']]]] = None,
                 is_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['IpResourceArgs']]]] = None,
                 reverses: Optional[pulumi.Input[Sequence[pulumi.Input['IpReverseArgs']]]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['IpSourceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ip resources.
        :param pulumi.Input[builtins.str] address: Request a specific IP in the requested source pool
        :param pulumi.Input[builtins.str] created_at: Date and time of IP's creation (RFC 3339 format).
        :param pulumi.Input[Sequence[pulumi.Input['IpCustomResourceArgs']]] custom_resources: The custom resource in which to book the IP
        :param pulumi.Input[builtins.bool] is_ipv6: Defines whether to request an IPv6 address instead of IPv4.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the IP is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region of the IP.
        :param pulumi.Input[Sequence[pulumi.Input['IpResourceArgs']]] resources: The IP resource.
        :param pulumi.Input[Sequence[pulumi.Input['IpReverseArgs']]] reverses: The reverse DNS for this IP.
        :param pulumi.Input[Sequence[pulumi.Input['IpSourceArgs']]] sources: The source in which to book the IP.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the IP.
        :param pulumi.Input[builtins.str] updated_at: Date and time of IP's last update (RFC 3339 format).
        :param pulumi.Input[builtins.str] zone: The zone of the IP.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_resources is not None:
            pulumi.set(__self__, "custom_resources", custom_resources)
        if is_ipv6 is not None:
            pulumi.set(__self__, "is_ipv6", is_ipv6)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if reverses is not None:
            pulumi.set(__self__, "reverses", reverses)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Request a specific IP in the requested source pool
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time of IP's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="customResources")
    def custom_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpCustomResourceArgs']]]]:
        """
        The custom resource in which to book the IP
        """
        return pulumi.get(self, "custom_resources")

    @custom_resources.setter
    def custom_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpCustomResourceArgs']]]]):
        pulumi.set(self, "custom_resources", value)

    @property
    @pulumi.getter(name="isIpv6")
    def is_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether to request an IPv6 address instead of IPv4.
        """
        return pulumi.get(self, "is_ipv6")

    @is_ipv6.setter
    def is_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_ipv6", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the IP is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region of the IP.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpResourceArgs']]]]:
        """
        The IP resource.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def reverses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpReverseArgs']]]]:
        """
        The reverse DNS for this IP.
        """
        return pulumi.get(self, "reverses")

    @reverses.setter
    def reverses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpReverseArgs']]]]):
        pulumi.set(self, "reverses", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpSourceArgs']]]]:
        """
        The source in which to book the IP.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the IP.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time of IP's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone of the IP.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:ipam/ip:Ip")
class Ip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 custom_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpCustomResourceArgs', 'IpCustomResourceArgsDict']]]]] = None,
                 is_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpSourceArgs', 'IpSourceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Books and manages IPAM IPs.

        For more information about IPAM, see the main [documentation](https://www.scaleway.com/en/docs/vpc/concepts/#ipam).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01", sources=[{
            "private_network_id": pn01.id,
        }])
        ```

        ### Request a specific IPv4 address

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        ```

        ### Request an IPv6 address

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv6_subnets=[{
                "subnet": "fd46:78ab:30b8:177c::/64",
            }])
        ip01 = scaleway.ipam.Ip("ip01",
            is_ipv6=True,
            sources=[{
                "private_network_id": pn01.id,
            }])
        ```

        ### Book an IP for a custom resource

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }],
            custom_resources=[{
                "mac_address": "bc:24:11:74:d0:6a",
            }])
        ```

        ## Import

        IPAM IPs can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:ipam/ip:Ip ip_demo fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: Request a specific IP in the requested source pool
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpCustomResourceArgs', 'IpCustomResourceArgsDict']]]] custom_resources: The custom resource in which to book the IP
        :param pulumi.Input[builtins.bool] is_ipv6: Defines whether to request an IPv6 address instead of IPv4.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the IP is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region of the IP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpSourceArgs', 'IpSourceArgsDict']]]] sources: The source in which to book the IP.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the IP.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Books and manages IPAM IPs.

        For more information about IPAM, see the main [documentation](https://www.scaleway.com/en/docs/vpc/concepts/#ipam).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01", sources=[{
            "private_network_id": pn01.id,
        }])
        ```

        ### Request a specific IPv4 address

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        ```

        ### Request an IPv6 address

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv6_subnets=[{
                "subnet": "fd46:78ab:30b8:177c::/64",
            }])
        ip01 = scaleway.ipam.Ip("ip01",
            is_ipv6=True,
            sources=[{
                "private_network_id": pn01.id,
            }])
        ```

        ### Book an IP for a custom resource

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }],
            custom_resources=[{
                "mac_address": "bc:24:11:74:d0:6a",
            }])
        ```

        ## Import

        IPAM IPs can be imported using `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:ipam/ip:Ip ip_demo fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param IpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 custom_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpCustomResourceArgs', 'IpCustomResourceArgsDict']]]]] = None,
                 is_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpSourceArgs', 'IpSourceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpArgs.__new__(IpArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["custom_resources"] = custom_resources
            __props__.__dict__["is_ipv6"] = is_ipv6
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["resources"] = None
            __props__.__dict__["reverses"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["zone"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/ipamIp:IpamIp")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Ip, __self__).__init__(
            'scaleway:ipam/ip:Ip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            custom_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpCustomResourceArgs', 'IpCustomResourceArgsDict']]]]] = None,
            is_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpResourceArgs', 'IpResourceArgsDict']]]]] = None,
            reverses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpReverseArgs', 'IpReverseArgsDict']]]]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpSourceArgs', 'IpSourceArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Ip':
        """
        Get an existing Ip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: Request a specific IP in the requested source pool
        :param pulumi.Input[builtins.str] created_at: Date and time of IP's creation (RFC 3339 format).
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpCustomResourceArgs', 'IpCustomResourceArgsDict']]]] custom_resources: The custom resource in which to book the IP
        :param pulumi.Input[builtins.bool] is_ipv6: Defines whether to request an IPv6 address instead of IPv4.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the IP is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region of the IP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpResourceArgs', 'IpResourceArgsDict']]]] resources: The IP resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpReverseArgs', 'IpReverseArgsDict']]]] reverses: The reverse DNS for this IP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpSourceArgs', 'IpSourceArgsDict']]]] sources: The source in which to book the IP.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the IP.
        :param pulumi.Input[builtins.str] updated_at: Date and time of IP's last update (RFC 3339 format).
        :param pulumi.Input[builtins.str] zone: The zone of the IP.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpState.__new__(_IpState)

        __props__.__dict__["address"] = address
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_resources"] = custom_resources
        __props__.__dict__["is_ipv6"] = is_ipv6
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["resources"] = resources
        __props__.__dict__["reverses"] = reverses
        __props__.__dict__["sources"] = sources
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone"] = zone
        return Ip(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[builtins.str]:
        """
        Request a specific IP in the requested source pool
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Date and time of IP's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customResources")
    def custom_resources(self) -> pulumi.Output[Optional[Sequence['outputs.IpCustomResource']]]:
        """
        The custom resource in which to book the IP
        """
        return pulumi.get(self, "custom_resources")

    @property
    @pulumi.getter(name="isIpv6")
    def is_ipv6(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether to request an IPv6 address instead of IPv4.
        """
        return pulumi.get(self, "is_ipv6")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the Project the IP is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region of the IP.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence['outputs.IpResource']]:
        """
        The IP resource.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def reverses(self) -> pulumi.Output[Sequence['outputs.IpReverse']]:
        """
        The reverse DNS for this IP.
        """
        return pulumi.get(self, "reverses")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence['outputs.IpSource']]:
        """
        The source in which to book the IP.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the IP.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Date and time of IP's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The zone of the IP.
        """
        return pulumi.get(self, "zone")

