# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cni: pulumi.Input[builtins.str],
                 delete_additional_resources: pulumi.Input[builtins.bool],
                 version: pulumi.Input[builtins.str],
                 admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 auto_upgrade: Optional[pulumi.Input['ClusterAutoUpgradeArgs']] = None,
                 autoscaler_config: Optional[pulumi.Input['ClusterAutoscalerConfigArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_id_connect_config: Optional[pulumi.Input['ClusterOpenIdConnectConfigArgs']] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[builtins.str] cni: The Container Network Interface (CNI) for the Kubernetes cluster.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[builtins.bool] delete_additional_resources: Delete additional resources like block volumes, load-balancers and the cluster's private network (if empty) that were created in Kubernetes on cluster deletion.
               > **Important:** Setting this field to `true` means that you will lose all your cluster data and network configuration when you delete your cluster.
               If you prefer keeping it, you should instead set it as `false`.
        :param pulumi.Input[builtins.str] version: The version of the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admission_plugins: The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] apiserver_cert_sans: Additional Subject Alternative Names for the Kubernetes API server certificate
        :param pulumi.Input['ClusterAutoUpgradeArgs'] auto_upgrade: The auto upgrade configuration.
        :param pulumi.Input['ClusterAutoscalerConfigArgs'] autoscaler_config: The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        :param pulumi.Input[builtins.str] description: A description for the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] feature_gates: The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        :param pulumi.Input[builtins.str] name: The name for the Kubernetes cluster.
        :param pulumi.Input['ClusterOpenIdConnectConfigArgs'] open_id_connect_config: The OpenID Connect configuration of the cluster
        :param pulumi.Input[builtins.str] private_network_id: The ID of the private network of the cluster.
               
               > **Important:** Changes to this field will recreate a new resource.
               
               > **Important:** Private Networks are now mandatory with Kapsule Clusters. If you have a legacy cluster (no `private_network_id` set),
               you can still set it now. In this case it will not destroy and recreate your cluster but migrate it to the Private Network.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the cluster is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the cluster should be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Kubernetes cluster.
        :param pulumi.Input[builtins.str] type: The type of Kubernetes cluster. Possible values are:
               
               - for mutualized clusters: `kapsule` or `multicloud`
               
               - for dedicated Kapsule clusters: `kapsule-dedicated-4`, `kapsule-dedicated-8` or `kapsule-dedicated-16`.
               
               - for dedicated Kosmos clusters: `multicloud-dedicated-4`, `multicloud-dedicated-8` or `multicloud-dedicated-16`.
        """
        pulumi.set(__self__, "cni", cni)
        pulumi.set(__self__, "delete_additional_resources", delete_additional_resources)
        pulumi.set(__self__, "version", version)
        if admission_plugins is not None:
            pulumi.set(__self__, "admission_plugins", admission_plugins)
        if apiserver_cert_sans is not None:
            pulumi.set(__self__, "apiserver_cert_sans", apiserver_cert_sans)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if autoscaler_config is not None:
            pulumi.set(__self__, "autoscaler_config", autoscaler_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_gates is not None:
            pulumi.set(__self__, "feature_gates", feature_gates)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def cni(self) -> pulumi.Input[builtins.str]:
        """
        The Container Network Interface (CNI) for the Kubernetes cluster.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "cni")

    @cni.setter
    def cni(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cni", value)

    @property
    @pulumi.getter(name="deleteAdditionalResources")
    def delete_additional_resources(self) -> pulumi.Input[builtins.bool]:
        """
        Delete additional resources like block volumes, load-balancers and the cluster's private network (if empty) that were created in Kubernetes on cluster deletion.
        > **Important:** Setting this field to `true` means that you will lose all your cluster data and network configuration when you delete your cluster.
        If you prefer keeping it, you should instead set it as `false`.
        """
        return pulumi.get(self, "delete_additional_resources")

    @delete_additional_resources.setter
    def delete_additional_resources(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "delete_additional_resources", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        The version of the Kubernetes cluster.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="admissionPlugins")
    def admission_plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        """
        return pulumi.get(self, "admission_plugins")

    @admission_plugins.setter
    def admission_plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "admission_plugins", value)

    @property
    @pulumi.getter(name="apiserverCertSans")
    def apiserver_cert_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Additional Subject Alternative Names for the Kubernetes API server certificate
        """
        return pulumi.get(self, "apiserver_cert_sans")

    @apiserver_cert_sans.setter
    def apiserver_cert_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "apiserver_cert_sans", value)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input['ClusterAutoUpgradeArgs']]:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input['ClusterAutoUpgradeArgs']]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter(name="autoscalerConfig")
    def autoscaler_config(self) -> Optional[pulumi.Input['ClusterAutoscalerConfigArgs']]:
        """
        The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        """
        return pulumi.get(self, "autoscaler_config")

    @autoscaler_config.setter
    def autoscaler_config(self, value: Optional[pulumi.Input['ClusterAutoscalerConfigArgs']]):
        pulumi.set(self, "autoscaler_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the Kubernetes cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        """
        return pulumi.get(self, "feature_gates")

    @feature_gates.setter
    def feature_gates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "feature_gates", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional[pulumi.Input['ClusterOpenIdConnectConfigArgs']]:
        """
        The OpenID Connect configuration of the cluster
        """
        return pulumi.get(self, "open_id_connect_config")

    @open_id_connect_config.setter
    def open_id_connect_config(self, value: Optional[pulumi.Input['ClusterOpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_config", value)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the private network of the cluster.

        > **Important:** Changes to this field will recreate a new resource.

        > **Important:** Private Networks are now mandatory with Kapsule Clusters. If you have a legacy cluster (no `private_network_id` set),
        you can still set it now. In this case it will not destroy and recreate your cluster but migrate it to the Private Network.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the cluster is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the cluster should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of Kubernetes cluster. Possible values are:

        - for mutualized clusters: `kapsule` or `multicloud`

        - for dedicated Kapsule clusters: `kapsule-dedicated-4`, `kapsule-dedicated-8` or `kapsule-dedicated-16`.

        - for dedicated Kosmos clusters: `multicloud-dedicated-4`, `multicloud-dedicated-8` or `multicloud-dedicated-16`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 apiserver_url: Optional[pulumi.Input[builtins.str]] = None,
                 auto_upgrade: Optional[pulumi.Input['ClusterAutoUpgradeArgs']] = None,
                 autoscaler_config: Optional[pulumi.Input['ClusterAutoscalerConfigArgs']] = None,
                 cni: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 delete_additional_resources: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 kubeconfigs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterKubeconfigArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_id_connect_config: Optional[pulumi.Input['ClusterOpenIdConnectConfigArgs']] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_available: Optional[pulumi.Input[builtins.bool]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 wildcard_dns: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admission_plugins: The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] apiserver_cert_sans: Additional Subject Alternative Names for the Kubernetes API server certificate
        :param pulumi.Input[builtins.str] apiserver_url: The URL of the Kubernetes API server.
        :param pulumi.Input['ClusterAutoUpgradeArgs'] auto_upgrade: The auto upgrade configuration.
        :param pulumi.Input['ClusterAutoscalerConfigArgs'] autoscaler_config: The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        :param pulumi.Input[builtins.str] cni: The Container Network Interface (CNI) for the Kubernetes cluster.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[builtins.str] created_at: The creation date of the cluster.
        :param pulumi.Input[builtins.bool] delete_additional_resources: Delete additional resources like block volumes, load-balancers and the cluster's private network (if empty) that were created in Kubernetes on cluster deletion.
               > **Important:** Setting this field to `true` means that you will lose all your cluster data and network configuration when you delete your cluster.
               If you prefer keeping it, you should instead set it as `false`.
        :param pulumi.Input[builtins.str] description: A description for the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] feature_gates: The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterKubeconfigArgs']]] kubeconfigs: The kubeconfig configuration file of the Kubernetes cluster
        :param pulumi.Input[builtins.str] name: The name for the Kubernetes cluster.
        :param pulumi.Input['ClusterOpenIdConnectConfigArgs'] open_id_connect_config: The OpenID Connect configuration of the cluster
        :param pulumi.Input[builtins.str] organization_id: The organization ID the cluster is associated with.
        :param pulumi.Input[builtins.str] private_network_id: The ID of the private network of the cluster.
               
               > **Important:** Changes to this field will recreate a new resource.
               
               > **Important:** Private Networks are now mandatory with Kapsule Clusters. If you have a legacy cluster (no `private_network_id` set),
               you can still set it now. In this case it will not destroy and recreate your cluster but migrate it to the Private Network.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the cluster is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the cluster should be created.
        :param pulumi.Input[builtins.str] status: The status of the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Kubernetes cluster.
        :param pulumi.Input[builtins.str] type: The type of Kubernetes cluster. Possible values are:
               
               - for mutualized clusters: `kapsule` or `multicloud`
               
               - for dedicated Kapsule clusters: `kapsule-dedicated-4`, `kapsule-dedicated-8` or `kapsule-dedicated-16`.
               
               - for dedicated Kosmos clusters: `multicloud-dedicated-4`, `multicloud-dedicated-8` or `multicloud-dedicated-16`.
        :param pulumi.Input[builtins.str] updated_at: The last update date of the cluster.
        :param pulumi.Input[builtins.bool] upgrade_available: Set to `true` if a newer Kubernetes version is available.
        :param pulumi.Input[builtins.str] version: The version of the Kubernetes cluster.
        :param pulumi.Input[builtins.str] wildcard_dns: The DNS wildcard that points to all ready nodes.
        """
        if admission_plugins is not None:
            pulumi.set(__self__, "admission_plugins", admission_plugins)
        if apiserver_cert_sans is not None:
            pulumi.set(__self__, "apiserver_cert_sans", apiserver_cert_sans)
        if apiserver_url is not None:
            pulumi.set(__self__, "apiserver_url", apiserver_url)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if autoscaler_config is not None:
            pulumi.set(__self__, "autoscaler_config", autoscaler_config)
        if cni is not None:
            pulumi.set(__self__, "cni", cni)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_additional_resources is not None:
            pulumi.set(__self__, "delete_additional_resources", delete_additional_resources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_gates is not None:
            pulumi.set(__self__, "feature_gates", feature_gates)
        if kubeconfigs is not None:
            pulumi.set(__self__, "kubeconfigs", kubeconfigs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_id_connect_config is not None:
            pulumi.set(__self__, "open_id_connect_config", open_id_connect_config)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wildcard_dns is not None:
            pulumi.set(__self__, "wildcard_dns", wildcard_dns)

    @property
    @pulumi.getter(name="admissionPlugins")
    def admission_plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        """
        return pulumi.get(self, "admission_plugins")

    @admission_plugins.setter
    def admission_plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "admission_plugins", value)

    @property
    @pulumi.getter(name="apiserverCertSans")
    def apiserver_cert_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Additional Subject Alternative Names for the Kubernetes API server certificate
        """
        return pulumi.get(self, "apiserver_cert_sans")

    @apiserver_cert_sans.setter
    def apiserver_cert_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "apiserver_cert_sans", value)

    @property
    @pulumi.getter(name="apiserverUrl")
    def apiserver_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "apiserver_url")

    @apiserver_url.setter
    def apiserver_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "apiserver_url", value)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input['ClusterAutoUpgradeArgs']]:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input['ClusterAutoUpgradeArgs']]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter(name="autoscalerConfig")
    def autoscaler_config(self) -> Optional[pulumi.Input['ClusterAutoscalerConfigArgs']]:
        """
        The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        """
        return pulumi.get(self, "autoscaler_config")

    @autoscaler_config.setter
    def autoscaler_config(self, value: Optional[pulumi.Input['ClusterAutoscalerConfigArgs']]):
        pulumi.set(self, "autoscaler_config", value)

    @property
    @pulumi.getter
    def cni(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Container Network Interface (CNI) for the Kubernetes cluster.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "cni")

    @cni.setter
    def cni(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cni", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation date of the cluster.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deleteAdditionalResources")
    def delete_additional_resources(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Delete additional resources like block volumes, load-balancers and the cluster's private network (if empty) that were created in Kubernetes on cluster deletion.
        > **Important:** Setting this field to `true` means that you will lose all your cluster data and network configuration when you delete your cluster.
        If you prefer keeping it, you should instead set it as `false`.
        """
        return pulumi.get(self, "delete_additional_resources")

    @delete_additional_resources.setter
    def delete_additional_resources(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_additional_resources", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the Kubernetes cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        """
        return pulumi.get(self, "feature_gates")

    @feature_gates.setter
    def feature_gates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "feature_gates", value)

    @property
    @pulumi.getter
    def kubeconfigs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterKubeconfigArgs']]]]:
        """
        The kubeconfig configuration file of the Kubernetes cluster
        """
        return pulumi.get(self, "kubeconfigs")

    @kubeconfigs.setter
    def kubeconfigs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterKubeconfigArgs']]]]):
        pulumi.set(self, "kubeconfigs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> Optional[pulumi.Input['ClusterOpenIdConnectConfigArgs']]:
        """
        The OpenID Connect configuration of the cluster
        """
        return pulumi.get(self, "open_id_connect_config")

    @open_id_connect_config.setter
    def open_id_connect_config(self, value: Optional[pulumi.Input['ClusterOpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_config", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization ID the cluster is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the private network of the cluster.

        > **Important:** Changes to this field will recreate a new resource.

        > **Important:** Private Networks are now mandatory with Kapsule Clusters. If you have a legacy cluster (no `private_network_id` set),
        you can still set it now. In this case it will not destroy and recreate your cluster but migrate it to the Private Network.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the cluster is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the cluster should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the Kubernetes cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of Kubernetes cluster. Possible values are:

        - for mutualized clusters: `kapsule` or `multicloud`

        - for dedicated Kapsule clusters: `kapsule-dedicated-4`, `kapsule-dedicated-8` or `kapsule-dedicated-16`.

        - for dedicated Kosmos clusters: `multicloud-dedicated-4`, `multicloud-dedicated-8` or `multicloud-dedicated-16`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The last update date of the cluster.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to `true` if a newer Kubernetes version is available.
        """
        return pulumi.get(self, "upgrade_available")

    @upgrade_available.setter
    def upgrade_available(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "upgrade_available", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the Kubernetes cluster.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="wildcardDns")
    def wildcard_dns(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS wildcard that points to all ready nodes.
        """
        return pulumi.get(self, "wildcard_dns")

    @wildcard_dns.setter
    def wildcard_dns(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wildcard_dns", value)


@pulumi.type_token("scaleway:kubernetes/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 auto_upgrade: Optional[pulumi.Input[Union['ClusterAutoUpgradeArgs', 'ClusterAutoUpgradeArgsDict']]] = None,
                 autoscaler_config: Optional[pulumi.Input[Union['ClusterAutoscalerConfigArgs', 'ClusterAutoscalerConfigArgsDict']]] = None,
                 cni: Optional[pulumi.Input[builtins.str]] = None,
                 delete_additional_resources: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_id_connect_config: Optional[pulumi.Input[Union['ClusterOpenIdConnectConfigArgs', 'ClusterOpenIdConnectConfigArgsDict']]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Kubernetes clusters. For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/kubernetes/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            version="1.32.3",
            cni="cilium",
            private_network_id=pn.id,
            delete_additional_resources=False)
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="DEV1-M",
            size=1)
        ```

        ### Multicloud

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            type="multicloud",
            version="1.32.3",
            cni="kilo",
            delete_additional_resources=False)
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="external",
            size=0,
            min_size=0)
        ```

        For a detailed example of how to add or run Elastic Metal servers instead of Instances on your cluster, please refer to this guide.

        ### With additional configuration

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            description="cluster made in terraform",
            version="1.32.3",
            cni="calico",
            tags=["terraform"],
            private_network_id=pn.id,
            delete_additional_resources=False,
            autoscaler_config={
                "disable_scale_down": False,
                "scale_down_delay_after_add": "5m",
                "estimator": "binpacking",
                "expander": "random",
                "ignore_daemonsets_utilization": True,
                "balance_similar_node_groups": True,
                "expendable_pods_priority_cutoff": -5,
            })
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="DEV1-M",
            size=3,
            autoscaling=True,
            autohealing=True,
            min_size=1,
            max_size=5)
        ```

        ### With the kubernetes provider

        ```python
        import pulumi
        import pulumi_null as null
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            version="1.29.1",
            cni="cilium",
            private_network_id=pn.id,
            delete_additional_resources=False)
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="DEV1-M",
            size=1)
        kubeconfig = null.Resource("kubeconfig", triggers={
            "host": cluster.kubeconfigs[0].host,
            "token": cluster.kubeconfigs[0].token,
            "cluster_ca_certificate": cluster.kubeconfigs[0].cluster_ca_certificate,
        },
        opts = pulumi.ResourceOptions(depends_on=[pool]))
        ```

        The `null_resource` is needed because when the cluster is created, its status is `pool_required`, but the kubeconfig can already be downloaded.
        It leads the `kubernetes` provider to start creating its objects, but the DNS entry for the Kubernetes master is not yet ready, that's why it's needed to wait for at least a pool.

        ### With the Helm provider

        ```python
        import pulumi
        import pulumi_helm as helm
        import pulumi_null as null
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            version="1.29.1",
            cni="cilium",
            delete_additional_resources=False,
            private_network_id=pn.id)
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="DEV1-M",
            size=1)
        kubeconfig = null.Resource("kubeconfig", triggers={
            "host": cluster.kubeconfigs[0].host,
            "token": cluster.kubeconfigs[0].token,
            "cluster_ca_certificate": cluster.kubeconfigs[0].cluster_ca_certificate,
        },
        opts = pulumi.ResourceOptions(depends_on=[pool]))
        nginx_ip = scaleway.loadbalancers.Ip("nginx_ip",
            zone="fr-par-1",
            project_id=cluster.project_id)
        nginx_ingress = helm.index.Release("nginx_ingress",
            name=nginx-ingress,
            namespace=kube-system,
            repository=https://kubernetes.github.io/ingress-nginx,
            chart=ingress-nginx,
            set=[
                {
                    name: controller.service.loadBalancerIP,
                    value: nginx_ip.ip_address,
                },
                {
                    name: controller.config.use-proxy-protocol,
                    value: true,
                },
                {
                    name: controller.service.annotations.service\\.beta\\.kubernetes\\.io/scw-loadbalancer-proxy-protocol-v2,
                    value: true,
                },
                {
                    name: controller.service.annotations.service\\.beta\\.kubernetes\\.io/scw-loadbalancer-zone,
                    value: nginx_ip.zone,
                },
                {
                    name: controller.service.externalTrafficPolicy,
                    value: Local,
                },
            ])
        ```

        ## Import

        Kubernetes clusters can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:kubernetes/cluster:Cluster mycluster fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admission_plugins: The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] apiserver_cert_sans: Additional Subject Alternative Names for the Kubernetes API server certificate
        :param pulumi.Input[Union['ClusterAutoUpgradeArgs', 'ClusterAutoUpgradeArgsDict']] auto_upgrade: The auto upgrade configuration.
        :param pulumi.Input[Union['ClusterAutoscalerConfigArgs', 'ClusterAutoscalerConfigArgsDict']] autoscaler_config: The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        :param pulumi.Input[builtins.str] cni: The Container Network Interface (CNI) for the Kubernetes cluster.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[builtins.bool] delete_additional_resources: Delete additional resources like block volumes, load-balancers and the cluster's private network (if empty) that were created in Kubernetes on cluster deletion.
               > **Important:** Setting this field to `true` means that you will lose all your cluster data and network configuration when you delete your cluster.
               If you prefer keeping it, you should instead set it as `false`.
        :param pulumi.Input[builtins.str] description: A description for the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] feature_gates: The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        :param pulumi.Input[builtins.str] name: The name for the Kubernetes cluster.
        :param pulumi.Input[Union['ClusterOpenIdConnectConfigArgs', 'ClusterOpenIdConnectConfigArgsDict']] open_id_connect_config: The OpenID Connect configuration of the cluster
        :param pulumi.Input[builtins.str] private_network_id: The ID of the private network of the cluster.
               
               > **Important:** Changes to this field will recreate a new resource.
               
               > **Important:** Private Networks are now mandatory with Kapsule Clusters. If you have a legacy cluster (no `private_network_id` set),
               you can still set it now. In this case it will not destroy and recreate your cluster but migrate it to the Private Network.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the cluster is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the cluster should be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Kubernetes cluster.
        :param pulumi.Input[builtins.str] type: The type of Kubernetes cluster. Possible values are:
               
               - for mutualized clusters: `kapsule` or `multicloud`
               
               - for dedicated Kapsule clusters: `kapsule-dedicated-4`, `kapsule-dedicated-8` or `kapsule-dedicated-16`.
               
               - for dedicated Kosmos clusters: `multicloud-dedicated-4`, `multicloud-dedicated-8` or `multicloud-dedicated-16`.
        :param pulumi.Input[builtins.str] version: The version of the Kubernetes cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Kubernetes clusters. For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/kubernetes/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            version="1.32.3",
            cni="cilium",
            private_network_id=pn.id,
            delete_additional_resources=False)
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="DEV1-M",
            size=1)
        ```

        ### Multicloud

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            type="multicloud",
            version="1.32.3",
            cni="kilo",
            delete_additional_resources=False)
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="external",
            size=0,
            min_size=0)
        ```

        For a detailed example of how to add or run Elastic Metal servers instead of Instances on your cluster, please refer to this guide.

        ### With additional configuration

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            description="cluster made in terraform",
            version="1.32.3",
            cni="calico",
            tags=["terraform"],
            private_network_id=pn.id,
            delete_additional_resources=False,
            autoscaler_config={
                "disable_scale_down": False,
                "scale_down_delay_after_add": "5m",
                "estimator": "binpacking",
                "expander": "random",
                "ignore_daemonsets_utilization": True,
                "balance_similar_node_groups": True,
                "expendable_pods_priority_cutoff": -5,
            })
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="DEV1-M",
            size=3,
            autoscaling=True,
            autohealing=True,
            min_size=1,
            max_size=5)
        ```

        ### With the kubernetes provider

        ```python
        import pulumi
        import pulumi_null as null
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            version="1.29.1",
            cni="cilium",
            private_network_id=pn.id,
            delete_additional_resources=False)
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="DEV1-M",
            size=1)
        kubeconfig = null.Resource("kubeconfig", triggers={
            "host": cluster.kubeconfigs[0].host,
            "token": cluster.kubeconfigs[0].token,
            "cluster_ca_certificate": cluster.kubeconfigs[0].cluster_ca_certificate,
        },
        opts = pulumi.ResourceOptions(depends_on=[pool]))
        ```

        The `null_resource` is needed because when the cluster is created, its status is `pool_required`, but the kubeconfig can already be downloaded.
        It leads the `kubernetes` provider to start creating its objects, but the DNS entry for the Kubernetes master is not yet ready, that's why it's needed to wait for at least a pool.

        ### With the Helm provider

        ```python
        import pulumi
        import pulumi_helm as helm
        import pulumi_null as null
        import pulumiverse_scaleway as scaleway

        pn = scaleway.network.PrivateNetwork("pn")
        cluster = scaleway.kubernetes.Cluster("cluster",
            name="tf-cluster",
            version="1.29.1",
            cni="cilium",
            delete_additional_resources=False,
            private_network_id=pn.id)
        pool = scaleway.kubernetes.Pool("pool",
            cluster_id=cluster.id,
            name="tf-pool",
            node_type="DEV1-M",
            size=1)
        kubeconfig = null.Resource("kubeconfig", triggers={
            "host": cluster.kubeconfigs[0].host,
            "token": cluster.kubeconfigs[0].token,
            "cluster_ca_certificate": cluster.kubeconfigs[0].cluster_ca_certificate,
        },
        opts = pulumi.ResourceOptions(depends_on=[pool]))
        nginx_ip = scaleway.loadbalancers.Ip("nginx_ip",
            zone="fr-par-1",
            project_id=cluster.project_id)
        nginx_ingress = helm.index.Release("nginx_ingress",
            name=nginx-ingress,
            namespace=kube-system,
            repository=https://kubernetes.github.io/ingress-nginx,
            chart=ingress-nginx,
            set=[
                {
                    name: controller.service.loadBalancerIP,
                    value: nginx_ip.ip_address,
                },
                {
                    name: controller.config.use-proxy-protocol,
                    value: true,
                },
                {
                    name: controller.service.annotations.service\\.beta\\.kubernetes\\.io/scw-loadbalancer-proxy-protocol-v2,
                    value: true,
                },
                {
                    name: controller.service.annotations.service\\.beta\\.kubernetes\\.io/scw-loadbalancer-zone,
                    value: nginx_ip.zone,
                },
                {
                    name: controller.service.externalTrafficPolicy,
                    value: Local,
                },
            ])
        ```

        ## Import

        Kubernetes clusters can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:kubernetes/cluster:Cluster mycluster fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 auto_upgrade: Optional[pulumi.Input[Union['ClusterAutoUpgradeArgs', 'ClusterAutoUpgradeArgsDict']]] = None,
                 autoscaler_config: Optional[pulumi.Input[Union['ClusterAutoscalerConfigArgs', 'ClusterAutoscalerConfigArgsDict']]] = None,
                 cni: Optional[pulumi.Input[builtins.str]] = None,
                 delete_additional_resources: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 open_id_connect_config: Optional[pulumi.Input[Union['ClusterOpenIdConnectConfigArgs', 'ClusterOpenIdConnectConfigArgsDict']]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["admission_plugins"] = admission_plugins
            __props__.__dict__["apiserver_cert_sans"] = apiserver_cert_sans
            __props__.__dict__["auto_upgrade"] = auto_upgrade
            __props__.__dict__["autoscaler_config"] = autoscaler_config
            if cni is None and not opts.urn:
                raise TypeError("Missing required property 'cni'")
            __props__.__dict__["cni"] = cni
            if delete_additional_resources is None and not opts.urn:
                raise TypeError("Missing required property 'delete_additional_resources'")
            __props__.__dict__["delete_additional_resources"] = delete_additional_resources
            __props__.__dict__["description"] = description
            __props__.__dict__["feature_gates"] = feature_gates
            __props__.__dict__["name"] = name
            __props__.__dict__["open_id_connect_config"] = open_id_connect_config
            __props__.__dict__["private_network_id"] = private_network_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["apiserver_url"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["kubeconfigs"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["upgrade_available"] = None
            __props__.__dict__["wildcard_dns"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/kubernetesCluster:KubernetesCluster")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kubeconfigs"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'scaleway:kubernetes/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admission_plugins: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            apiserver_cert_sans: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            apiserver_url: Optional[pulumi.Input[builtins.str]] = None,
            auto_upgrade: Optional[pulumi.Input[Union['ClusterAutoUpgradeArgs', 'ClusterAutoUpgradeArgsDict']]] = None,
            autoscaler_config: Optional[pulumi.Input[Union['ClusterAutoscalerConfigArgs', 'ClusterAutoscalerConfigArgsDict']]] = None,
            cni: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            delete_additional_resources: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            feature_gates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            kubeconfigs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterKubeconfigArgs', 'ClusterKubeconfigArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            open_id_connect_config: Optional[pulumi.Input[Union['ClusterOpenIdConnectConfigArgs', 'ClusterOpenIdConnectConfigArgsDict']]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            private_network_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            upgrade_available: Optional[pulumi.Input[builtins.bool]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            wildcard_dns: Optional[pulumi.Input[builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] admission_plugins: The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] apiserver_cert_sans: Additional Subject Alternative Names for the Kubernetes API server certificate
        :param pulumi.Input[builtins.str] apiserver_url: The URL of the Kubernetes API server.
        :param pulumi.Input[Union['ClusterAutoUpgradeArgs', 'ClusterAutoUpgradeArgsDict']] auto_upgrade: The auto upgrade configuration.
        :param pulumi.Input[Union['ClusterAutoscalerConfigArgs', 'ClusterAutoscalerConfigArgsDict']] autoscaler_config: The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        :param pulumi.Input[builtins.str] cni: The Container Network Interface (CNI) for the Kubernetes cluster.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[builtins.str] created_at: The creation date of the cluster.
        :param pulumi.Input[builtins.bool] delete_additional_resources: Delete additional resources like block volumes, load-balancers and the cluster's private network (if empty) that were created in Kubernetes on cluster deletion.
               > **Important:** Setting this field to `true` means that you will lose all your cluster data and network configuration when you delete your cluster.
               If you prefer keeping it, you should instead set it as `false`.
        :param pulumi.Input[builtins.str] description: A description for the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] feature_gates: The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterKubeconfigArgs', 'ClusterKubeconfigArgsDict']]]] kubeconfigs: The kubeconfig configuration file of the Kubernetes cluster
        :param pulumi.Input[builtins.str] name: The name for the Kubernetes cluster.
        :param pulumi.Input[Union['ClusterOpenIdConnectConfigArgs', 'ClusterOpenIdConnectConfigArgsDict']] open_id_connect_config: The OpenID Connect configuration of the cluster
        :param pulumi.Input[builtins.str] organization_id: The organization ID the cluster is associated with.
        :param pulumi.Input[builtins.str] private_network_id: The ID of the private network of the cluster.
               
               > **Important:** Changes to this field will recreate a new resource.
               
               > **Important:** Private Networks are now mandatory with Kapsule Clusters. If you have a legacy cluster (no `private_network_id` set),
               you can still set it now. In this case it will not destroy and recreate your cluster but migrate it to the Private Network.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the cluster is associated with.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the cluster should be created.
        :param pulumi.Input[builtins.str] status: The status of the Kubernetes cluster.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Kubernetes cluster.
        :param pulumi.Input[builtins.str] type: The type of Kubernetes cluster. Possible values are:
               
               - for mutualized clusters: `kapsule` or `multicloud`
               
               - for dedicated Kapsule clusters: `kapsule-dedicated-4`, `kapsule-dedicated-8` or `kapsule-dedicated-16`.
               
               - for dedicated Kosmos clusters: `multicloud-dedicated-4`, `multicloud-dedicated-8` or `multicloud-dedicated-16`.
        :param pulumi.Input[builtins.str] updated_at: The last update date of the cluster.
        :param pulumi.Input[builtins.bool] upgrade_available: Set to `true` if a newer Kubernetes version is available.
        :param pulumi.Input[builtins.str] version: The version of the Kubernetes cluster.
        :param pulumi.Input[builtins.str] wildcard_dns: The DNS wildcard that points to all ready nodes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["admission_plugins"] = admission_plugins
        __props__.__dict__["apiserver_cert_sans"] = apiserver_cert_sans
        __props__.__dict__["apiserver_url"] = apiserver_url
        __props__.__dict__["auto_upgrade"] = auto_upgrade
        __props__.__dict__["autoscaler_config"] = autoscaler_config
        __props__.__dict__["cni"] = cni
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["delete_additional_resources"] = delete_additional_resources
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_gates"] = feature_gates
        __props__.__dict__["kubeconfigs"] = kubeconfigs
        __props__.__dict__["name"] = name
        __props__.__dict__["open_id_connect_config"] = open_id_connect_config
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["private_network_id"] = private_network_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["upgrade_available"] = upgrade_available
        __props__.__dict__["version"] = version
        __props__.__dict__["wildcard_dns"] = wildcard_dns
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="admissionPlugins")
    def admission_plugins(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of [admission plugins](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/) to enable on the cluster.
        """
        return pulumi.get(self, "admission_plugins")

    @property
    @pulumi.getter(name="apiserverCertSans")
    def apiserver_cert_sans(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Additional Subject Alternative Names for the Kubernetes API server certificate
        """
        return pulumi.get(self, "apiserver_cert_sans")

    @property
    @pulumi.getter(name="apiserverUrl")
    def apiserver_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the Kubernetes API server.
        """
        return pulumi.get(self, "apiserver_url")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> pulumi.Output['outputs.ClusterAutoUpgrade']:
        """
        The auto upgrade configuration.
        """
        return pulumi.get(self, "auto_upgrade")

    @property
    @pulumi.getter(name="autoscalerConfig")
    def autoscaler_config(self) -> pulumi.Output['outputs.ClusterAutoscalerConfig']:
        """
        The configuration options for the [Kubernetes cluster autoscaler](https://github.com/kubernetes/autoscaler/tree/master/cluster-autoscaler).
        """
        return pulumi.get(self, "autoscaler_config")

    @property
    @pulumi.getter
    def cni(self) -> pulumi.Output[builtins.str]:
        """
        The Container Network Interface (CNI) for the Kubernetes cluster.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "cni")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The creation date of the cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deleteAdditionalResources")
    def delete_additional_resources(self) -> pulumi.Output[builtins.bool]:
        """
        Delete additional resources like block volumes, load-balancers and the cluster's private network (if empty) that were created in Kubernetes on cluster deletion.
        > **Important:** Setting this field to `true` means that you will lose all your cluster data and network configuration when you delete your cluster.
        If you prefer keeping it, you should instead set it as `false`.
        """
        return pulumi.get(self, "delete_additional_resources")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the Kubernetes cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureGates")
    def feature_gates(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of [feature gates](https://kubernetes.io/docs/reference/command-line-tools-reference/feature-gates/) to enable on the cluster.
        """
        return pulumi.get(self, "feature_gates")

    @property
    @pulumi.getter
    def kubeconfigs(self) -> pulumi.Output[Sequence['outputs.ClusterKubeconfig']]:
        """
        The kubeconfig configuration file of the Kubernetes cluster
        """
        return pulumi.get(self, "kubeconfigs")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openIdConnectConfig")
    def open_id_connect_config(self) -> pulumi.Output['outputs.ClusterOpenIdConnectConfig']:
        """
        The OpenID Connect configuration of the cluster
        """
        return pulumi.get(self, "open_id_connect_config")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The organization ID the cluster is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the private network of the cluster.

        > **Important:** Changes to this field will recreate a new resource.

        > **Important:** Private Networks are now mandatory with Kapsule Clusters. If you have a legacy cluster (no `private_network_id` set),
        you can still set it now. In this case it will not destroy and recreate your cluster but migrate it to the Private Network.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the cluster is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region in which the cluster should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the Kubernetes cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of Kubernetes cluster. Possible values are:

        - for mutualized clusters: `kapsule` or `multicloud`

        - for dedicated Kapsule clusters: `kapsule-dedicated-4`, `kapsule-dedicated-8` or `kapsule-dedicated-16`.

        - for dedicated Kosmos clusters: `multicloud-dedicated-4`, `multicloud-dedicated-8` or `multicloud-dedicated-16`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The last update date of the cluster.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> pulumi.Output[builtins.bool]:
        """
        Set to `true` if a newer Kubernetes version is available.
        """
        return pulumi.get(self, "upgrade_available")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the Kubernetes cluster.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="wildcardDns")
    def wildcard_dns(self) -> pulumi.Output[builtins.str]:
        """
        The DNS wildcard that points to all ready nodes.
        """
        return pulumi.get(self, "wildcard_dns")

