# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadbalancerArgs', 'Loadbalancer']

@pulumi.input_type
class LoadbalancerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 assign_flexible_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 assign_flexible_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 release_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Loadbalancer resource.
        :param pulumi.Input[builtins.str] type: The type of the Load Balancer. Please check the migration section to upgrade the type.
        :param pulumi.Input[builtins.bool] assign_flexible_ip: Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        :param pulumi.Input[builtins.bool] assign_flexible_ipv6: Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        :param pulumi.Input[builtins.str] description: The description of the Load Balancer.
        :param pulumi.Input[builtins.str] ip_id: Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.
               
               > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ids: The List of IP IDs to attach to the Load Balancer.
               
               > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        :param pulumi.Input[builtins.str] name: The name of the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]] private_networks: List of private network to connect with your load balancer.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Load Balancer is associated with.
        :param pulumi.Input[builtins.bool] release_ip: The `release_ip` allow the release of the IP address associated with the Load Balancer.
        :param pulumi.Input[builtins.str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Load Balancer.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        pulumi.set(__self__, "type", type)
        if assign_flexible_ip is not None:
            pulumi.set(__self__, "assign_flexible_ip", assign_flexible_ip)
        if assign_flexible_ipv6 is not None:
            pulumi.set(__self__, "assign_flexible_ipv6", assign_flexible_ipv6)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_id is not None:
            warnings.warn("""Please use ip_ids""", DeprecationWarning)
            pulumi.log.warn("""ip_id is deprecated: Please use ip_ids""")
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if ip_ids is not None:
            pulumi.set(__self__, "ip_ids", ip_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if release_ip is not None:
            warnings.warn("""The resource ip will be destroyed by it's own resource. Please set this to `false`""", DeprecationWarning)
            pulumi.log.warn("""release_ip is deprecated: The resource ip will be destroyed by it's own resource. Please set this to `false`""")
        if release_ip is not None:
            pulumi.set(__self__, "release_ip", release_ip)
        if ssl_compatibility_level is not None:
            pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the Load Balancer. Please check the migration section to upgrade the type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="assignFlexibleIp")
    def assign_flexible_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ip")

    @assign_flexible_ip.setter
    def assign_flexible_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "assign_flexible_ip", value)

    @property
    @pulumi.getter(name="assignFlexibleIpv6")
    def assign_flexible_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ipv6")

    @assign_flexible_ipv6.setter
    def assign_flexible_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "assign_flexible_ipv6", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Load Balancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipId")
    @_utilities.deprecated("""Please use ip_ids""")
    def ip_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.

        > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_id", value)

    @property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The List of IP IDs to attach to the Load Balancer.

        > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        """
        return pulumi.get(self, "ip_ids")

    @ip_ids.setter
    def ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Load Balancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]]:
        """
        List of private network to connect with your load balancer.
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="releaseIp")
    @_utilities.deprecated("""The resource ip will be destroyed by it's own resource. Please set this to `false`""")
    def release_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The `release_ip` allow the release of the IP address associated with the Load Balancer.
        """
        return pulumi.get(self, "release_ip")

    @release_ip.setter
    def release_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "release_ip", value)

    @property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @ssl_compatibility_level.setter
    def ssl_compatibility_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_compatibility_level", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Load Balancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _LoadbalancerState:
    def __init__(__self__, *,
                 assign_flexible_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 assign_flexible_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 release_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Loadbalancer resources.
        :param pulumi.Input[builtins.bool] assign_flexible_ip: Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        :param pulumi.Input[builtins.bool] assign_flexible_ipv6: Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        :param pulumi.Input[builtins.str] description: The description of the Load Balancer.
        :param pulumi.Input[builtins.str] ip_address: The Load Balancer public IPv4 address.
        :param pulumi.Input[builtins.str] ip_id: Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.
               
               > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ids: The List of IP IDs to attach to the Load Balancer.
               
               > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        :param pulumi.Input[builtins.str] ipv6_address: The Load Balancer public IPv6 address.
        :param pulumi.Input[builtins.str] name: The name of the Load Balancer.
        :param pulumi.Input[builtins.str] organization_id: The ID of the Organization ID the Load Balancer is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]] private_networks: List of private network to connect with your load balancer.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Load Balancer is associated with.
        :param pulumi.Input[builtins.str] region: The region of the resource
        :param pulumi.Input[builtins.bool] release_ip: The `release_ip` allow the release of the IP address associated with the Load Balancer.
        :param pulumi.Input[builtins.str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Load Balancer.
        :param pulumi.Input[builtins.str] type: The type of the Load Balancer. Please check the migration section to upgrade the type.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        if assign_flexible_ip is not None:
            pulumi.set(__self__, "assign_flexible_ip", assign_flexible_ip)
        if assign_flexible_ipv6 is not None:
            pulumi.set(__self__, "assign_flexible_ipv6", assign_flexible_ipv6)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_id is not None:
            warnings.warn("""Please use ip_ids""", DeprecationWarning)
            pulumi.log.warn("""ip_id is deprecated: Please use ip_ids""")
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if ip_ids is not None:
            pulumi.set(__self__, "ip_ids", ip_ids)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_ip is not None:
            warnings.warn("""The resource ip will be destroyed by it's own resource. Please set this to `false`""", DeprecationWarning)
            pulumi.log.warn("""release_ip is deprecated: The resource ip will be destroyed by it's own resource. Please set this to `false`""")
        if release_ip is not None:
            pulumi.set(__self__, "release_ip", release_ip)
        if ssl_compatibility_level is not None:
            pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="assignFlexibleIp")
    def assign_flexible_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ip")

    @assign_flexible_ip.setter
    def assign_flexible_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "assign_flexible_ip", value)

    @property
    @pulumi.getter(name="assignFlexibleIpv6")
    def assign_flexible_ipv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ipv6")

    @assign_flexible_ipv6.setter
    def assign_flexible_ipv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "assign_flexible_ipv6", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Load Balancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Load Balancer public IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipId")
    @_utilities.deprecated("""Please use ip_ids""")
    def ip_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.

        > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_id", value)

    @property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The List of IP IDs to attach to the Load Balancer.

        > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        """
        return pulumi.get(self, "ip_ids")

    @ip_ids.setter
    def ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_ids", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Load Balancer public IPv6 address.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Load Balancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Organization ID the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]]:
        """
        List of private network to connect with your load balancer.
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the resource
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="releaseIp")
    @_utilities.deprecated("""The resource ip will be destroyed by it's own resource. Please set this to `false`""")
    def release_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The `release_ip` allow the release of the IP address associated with the Load Balancer.
        """
        return pulumi.get(self, "release_ip")

    @release_ip.setter
    def release_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "release_ip", value)

    @property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @ssl_compatibility_level.setter
    def ssl_compatibility_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_compatibility_level", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Load Balancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the Load Balancer. Please check the migration section to upgrade the type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""scaleway.index/loadbalancer.Loadbalancer has been deprecated in favor of scaleway.loadbalancers/loadbalancer.LoadBalancer""", DeprecationWarning)


@pulumi.type_token("scaleway:index/loadbalancer:Loadbalancer")
class Loadbalancer(pulumi.CustomResource):
    warnings.warn("""scaleway.index/loadbalancer.Loadbalancer has been deprecated in favor of scaleway.loadbalancers/loadbalancer.LoadBalancer""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_flexible_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 assign_flexible_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerPrivateNetworkArgs', 'LoadbalancerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 release_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Load Balancers.

        For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/concepts/#load-balancers) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-list-load-balancers).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.loadbalancers.Ip("main", zone="fr-par-1")
        base = scaleway.loadbalancers.LoadBalancer("base",
            ip_ids=[main.id],
            zone=main.zone,
            type="LB-S")
        ```

        ### Private LB

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        base = scaleway.loadbalancers.LoadBalancer("base",
            name="private-lb",
            type="LB-S",
            assign_flexible_ip=False)
        ```

        ### With IPv6

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        v4 = scaleway.loadbalancers.Ip("v4")
        v6 = scaleway.loadbalancers.Ip("v6", is_ipv6=True)
        main = scaleway.loadbalancers.LoadBalancer("main",
            ip_ids=[
                v4.id,
                v6.id,
            ],
            name="ipv6-lb",
            type="LB-S")
        ```

        ### With IPAM IDs

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        v4 = scaleway.loadbalancers.Ip("v4")
        lb01 = scaleway.loadbalancers.LoadBalancer("lb01",
            ip_ids=[v4.id],
            name="my-lb",
            type="LB-S",
            private_networks=[{
                "private_network_id": pn01.id,
                "ipam_ids": ip01.id,
            }])
        ```

        ## Migration

        In order to migrate to other Load Balancer types, you can check upwards or downwards migration via our CLI `scw lb lb-types list`.
        This change will not recreate your Load Balancer.

        Please check our [documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-migrate-a-load-balancer) for further details.

        ## Import

        Load Balancers can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/loadbalancer:Loadbalancer main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        Be aware that you will also need to import the `scaleway_lb_ip` resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] assign_flexible_ip: Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        :param pulumi.Input[builtins.bool] assign_flexible_ipv6: Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        :param pulumi.Input[builtins.str] description: The description of the Load Balancer.
        :param pulumi.Input[builtins.str] ip_id: Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.
               
               > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ids: The List of IP IDs to attach to the Load Balancer.
               
               > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        :param pulumi.Input[builtins.str] name: The name of the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerPrivateNetworkArgs', 'LoadbalancerPrivateNetworkArgsDict']]]] private_networks: List of private network to connect with your load balancer.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Load Balancer is associated with.
        :param pulumi.Input[builtins.bool] release_ip: The `release_ip` allow the release of the IP address associated with the Load Balancer.
        :param pulumi.Input[builtins.str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Load Balancer.
        :param pulumi.Input[builtins.str] type: The type of the Load Balancer. Please check the migration section to upgrade the type.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Load Balancers.

        For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/concepts/#load-balancers) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-list-load-balancers).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.loadbalancers.Ip("main", zone="fr-par-1")
        base = scaleway.loadbalancers.LoadBalancer("base",
            ip_ids=[main.id],
            zone=main.zone,
            type="LB-S")
        ```

        ### Private LB

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        base = scaleway.loadbalancers.LoadBalancer("base",
            name="private-lb",
            type="LB-S",
            assign_flexible_ip=False)
        ```

        ### With IPv6

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        v4 = scaleway.loadbalancers.Ip("v4")
        v6 = scaleway.loadbalancers.Ip("v6", is_ipv6=True)
        main = scaleway.loadbalancers.LoadBalancer("main",
            ip_ids=[
                v4.id,
                v6.id,
            ],
            name="ipv6-lb",
            type="LB-S")
        ```

        ### With IPAM IDs

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc01 = scaleway.network.Vpc("vpc01", name="my vpc")
        pn01 = scaleway.network.PrivateNetwork("pn01",
            vpc_id=vpc01.id,
            ipv4_subnet={
                "subnet": "172.16.32.0/22",
            })
        ip01 = scaleway.ipam.Ip("ip01",
            address="172.16.32.7",
            sources=[{
                "private_network_id": pn01.id,
            }])
        v4 = scaleway.loadbalancers.Ip("v4")
        lb01 = scaleway.loadbalancers.LoadBalancer("lb01",
            ip_ids=[v4.id],
            name="my-lb",
            type="LB-S",
            private_networks=[{
                "private_network_id": pn01.id,
                "ipam_ids": ip01.id,
            }])
        ```

        ## Migration

        In order to migrate to other Load Balancer types, you can check upwards or downwards migration via our CLI `scw lb lb-types list`.
        This change will not recreate your Load Balancer.

        Please check our [documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-migrate-a-load-balancer) for further details.

        ## Import

        Load Balancers can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/loadbalancer:Loadbalancer main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        Be aware that you will also need to import the `scaleway_lb_ip` resource.

        :param str resource_name: The name of the resource.
        :param LoadbalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_flexible_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 assign_flexible_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_id: Optional[pulumi.Input[builtins.str]] = None,
                 ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerPrivateNetworkArgs', 'LoadbalancerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 release_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""Loadbalancer is deprecated: scaleway.index/loadbalancer.Loadbalancer has been deprecated in favor of scaleway.loadbalancers/loadbalancer.LoadBalancer""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerArgs.__new__(LoadbalancerArgs)

            __props__.__dict__["assign_flexible_ip"] = assign_flexible_ip
            __props__.__dict__["assign_flexible_ipv6"] = assign_flexible_ipv6
            __props__.__dict__["description"] = description
            __props__.__dict__["ip_id"] = ip_id
            __props__.__dict__["ip_ids"] = ip_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["release_ip"] = release_ip
            __props__.__dict__["ssl_compatibility_level"] = ssl_compatibility_level
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["zone"] = zone
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["region"] = None
        super(Loadbalancer, __self__).__init__(
            'scaleway:index/loadbalancer:Loadbalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assign_flexible_ip: Optional[pulumi.Input[builtins.bool]] = None,
            assign_flexible_ipv6: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            ip_id: Optional[pulumi.Input[builtins.str]] = None,
            ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerPrivateIpArgs', 'LoadbalancerPrivateIpArgsDict']]]]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerPrivateNetworkArgs', 'LoadbalancerPrivateNetworkArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            release_ip: Optional[pulumi.Input[builtins.bool]] = None,
            ssl_compatibility_level: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Loadbalancer':
        """
        Get an existing Loadbalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] assign_flexible_ip: Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        :param pulumi.Input[builtins.bool] assign_flexible_ipv6: Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        :param pulumi.Input[builtins.str] description: The description of the Load Balancer.
        :param pulumi.Input[builtins.str] ip_address: The Load Balancer public IPv4 address.
        :param pulumi.Input[builtins.str] ip_id: Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.
               
               > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ip_ids: The List of IP IDs to attach to the Load Balancer.
               
               > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        :param pulumi.Input[builtins.str] ipv6_address: The Load Balancer public IPv6 address.
        :param pulumi.Input[builtins.str] name: The name of the Load Balancer.
        :param pulumi.Input[builtins.str] organization_id: The ID of the Organization ID the Load Balancer is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerPrivateIpArgs', 'LoadbalancerPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadbalancerPrivateNetworkArgs', 'LoadbalancerPrivateNetworkArgsDict']]]] private_networks: List of private network to connect with your load balancer.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Load Balancer is associated with.
        :param pulumi.Input[builtins.str] region: The region of the resource
        :param pulumi.Input[builtins.bool] release_ip: The `release_ip` allow the release of the IP address associated with the Load Balancer.
        :param pulumi.Input[builtins.str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Load Balancer.
        :param pulumi.Input[builtins.str] type: The type of the Load Balancer. Please check the migration section to upgrade the type.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone of the Load Balancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerState.__new__(_LoadbalancerState)

        __props__.__dict__["assign_flexible_ip"] = assign_flexible_ip
        __props__.__dict__["assign_flexible_ipv6"] = assign_flexible_ipv6
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_id"] = ip_id
        __props__.__dict__["ip_ids"] = ip_ids
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["release_ip"] = release_ip
        __props__.__dict__["ssl_compatibility_level"] = ssl_compatibility_level
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["zone"] = zone
        return Loadbalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assignFlexibleIp")
    def assign_flexible_ip(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv4 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ip")

    @property
    @pulumi.getter(name="assignFlexibleIpv6")
    def assign_flexible_ipv6(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Defines whether to automatically assign a flexible public IPv6 to the Load Balancer.
        """
        return pulumi.get(self, "assign_flexible_ipv6")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Load Balancer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[builtins.str]:
        """
        The Load Balancer public IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipId")
    @_utilities.deprecated("""Please use ip_ids""")
    def ip_id(self) -> pulumi.Output[builtins.str]:
        """
        Please use `ip_ids`. The ID of the associated Load Balancer IP. See below.

        > **Important:** Updates to `ip_id` will recreate the Load Balancer.
        """
        return pulumi.get(self, "ip_id")

    @property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The List of IP IDs to attach to the Load Balancer.

        > **Important:** Make sure to use a `loadbalancers.Ip` resource to create the IPs.
        """
        return pulumi.get(self, "ip_ids")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[builtins.str]:
        """
        The Load Balancer public IPv6 address.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Load Balancer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Organization ID the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.LoadbalancerPrivateIp']]:
        """
        The list of private IPv4 and IPv6 addresses associated with the resource.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.LoadbalancerPrivateNetwork']]]:
        """
        List of private network to connect with your load balancer.
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region of the resource
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="releaseIp")
    @_utilities.deprecated("""The resource ip will be destroyed by it's own resource. Please set this to `false`""")
    def release_ip(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The `release_ip` allow the release of the IP address associated with the Load Balancer.
        """
        return pulumi.get(self, "release_ip")

    @property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-load-balancer-create-a-load-balancer).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the Load Balancer.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the Load Balancer. Please check the migration section to upgrade the type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")

