# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AclAction',
    'AclActionRedirect',
    'AclMatch',
    'BackendHealthCheckHttp',
    'BackendHealthCheckHttps',
    'BackendHealthCheckTcp',
    'CertificateCustomCertificate',
    'CertificateLetsencrypt',
    'FrontendAcl',
    'FrontendAclAction',
    'FrontendAclActionRedirect',
    'FrontendAclMatch',
    'LoadBalancerPrivateIp',
    'LoadBalancerPrivateNetwork',
    'GetAclsAclResult',
    'GetAclsAclActionResult',
    'GetAclsAclActionRedirectResult',
    'GetAclsAclMatchResult',
    'GetBackendHealthCheckHttpResult',
    'GetBackendHealthCheckTcpResult',
    'GetBackendsBackendResult',
    'GetBackendsBackendHealthCheckHttpResult',
    'GetBackendsBackendHealthCheckTcpResult',
    'GetCertificateCustomCertificateResult',
    'GetCertificateLetsencryptResult',
    'GetFrontendAclResult',
    'GetFrontendAclActionResult',
    'GetFrontendAclActionRedirectResult',
    'GetFrontendAclMatchResult',
    'GetFrontendsFrontendResult',
    'GetIpsIpResult',
    'GetLoadBalancerPrivateIpResult',
    'GetLoadBalancerPrivateNetworkResult',
    'GetLoadBalancersLbResult',
    'GetLoadBalancersLbInstanceResult',
    'GetLoadBalancersLbIpResult',
    'GetRoutesRouteResult',
]

@pulumi.output_type
class AclAction(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 redirects: Optional[Sequence['outputs.AclActionRedirect']] = None):
        """
        :param builtins.str type: The action type. Possible values are: `allow` or `deny` or `redirect`.
        :param Sequence['AclActionRedirectArgs'] redirects: Redirect parameters when using an ACL with `redirect` action.
        """
        pulumi.set(__self__, "type", type)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def redirects(self) -> Optional[Sequence['outputs.AclActionRedirect']]:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")


@pulumi.output_type
class AclActionRedirect(dict):
    def __init__(__self__, *,
                 code: Optional[builtins.int] = None,
                 target: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.int code: The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        :param builtins.str target: An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        :param builtins.str type: The redirect type. Possible values are: `location` or `scheme`.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.int]:
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        An URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AclMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpFilter":
            suggest = "http_filter"
        elif key == "httpFilterOption":
            suggest = "http_filter_option"
        elif key == "httpFilterValues":
            suggest = "http_filter_values"
        elif key == "ipSubnets":
            suggest = "ip_subnets"
        elif key == "ipsEdgeServices":
            suggest = "ips_edge_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AclMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AclMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AclMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_filter: Optional[builtins.str] = None,
                 http_filter_option: Optional[builtins.str] = None,
                 http_filter_values: Optional[Sequence[builtins.str]] = None,
                 invert: Optional[builtins.bool] = None,
                 ip_subnets: Optional[Sequence[builtins.str]] = None,
                 ips_edge_services: Optional[builtins.bool] = None):
        """
        :param builtins.str http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param builtins.str http_filter_option: If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        :param Sequence[builtins.str] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        :param builtins.bool invert: If set to `true`, the condition will be of type "unless".
        :param Sequence[builtins.str] ip_subnets: A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        :param builtins.bool ips_edge_services: Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)
        if ips_edge_services is not None:
            pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[builtins.str]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[builtins.str]:
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        return pulumi.get(self, "http_filter_option")

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @property
    @pulumi.getter
    def invert(self) -> Optional[builtins.bool]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ip_subnets")

    @property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> Optional[builtins.bool]:
        """
        Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ips_edge_services")


@pulumi.output_type
class BackendHealthCheckHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendHealthCheckHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendHealthCheckHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendHealthCheckHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: builtins.str,
                 code: Optional[builtins.int] = None,
                 host_header: Optional[builtins.str] = None,
                 method: Optional[builtins.str] = None):
        """
        :param builtins.str uri: The HTTP endpoint URL to call for HC requests
        :param builtins.int code: The expected HTTP status code
        :param builtins.str host_header: The HTTP host header to use for HC requests
        :param builtins.str method: The HTTP method to use for HC requests
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The HTTP endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.int]:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[builtins.str]:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def method(self) -> Optional[builtins.str]:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")


@pulumi.output_type
class BackendHealthCheckHttps(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendHealthCheckHttps. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendHealthCheckHttps.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendHealthCheckHttps.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: builtins.str,
                 code: Optional[builtins.int] = None,
                 host_header: Optional[builtins.str] = None,
                 method: Optional[builtins.str] = None,
                 sni: Optional[builtins.str] = None):
        """
        :param builtins.str uri: The HTTPS endpoint URL to call for HC requests
        :param builtins.int code: The expected HTTP status code
        :param builtins.str host_header: The HTTP host header to use for HC requests
        :param builtins.str method: The HTTP method to use for HC requests
        :param builtins.str sni: The SNI to use for HC requests over SSL
        """
        pulumi.set(__self__, "uri", uri)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if sni is not None:
            pulumi.set(__self__, "sni", sni)

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The HTTPS endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.int]:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[builtins.str]:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def method(self) -> Optional[builtins.str]:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def sni(self) -> Optional[builtins.str]:
        """
        The SNI to use for HC requests over SSL
        """
        return pulumi.get(self, "sni")


@pulumi.output_type
class BackendHealthCheckTcp(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class CertificateCustomCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateChain":
            suggest = "certificate_chain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCustomCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCustomCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCustomCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_chain: builtins.str):
        """
        :param builtins.str certificate_chain: The full PEM-formatted certificate chain
        """
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> builtins.str:
        """
        The full PEM-formatted certificate chain
        """
        return pulumi.get(self, "certificate_chain")


@pulumi.output_type
class CertificateLetsencrypt(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateLetsencrypt. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateLetsencrypt.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateLetsencrypt.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: builtins.str,
                 subject_alternative_names: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str common_name: Main domain of the certificate
        :param Sequence[builtins.str] subject_alternative_names: The alternative domain names of the certificate
        """
        pulumi.set(__self__, "common_name", common_name)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> builtins.str:
        """
        Main domain of the certificate
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence[builtins.str]]:
        """
        The alternative domain names of the certificate
        """
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class FrontendAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontendAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontendAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontendAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'outputs.FrontendAclAction',
                 match: 'outputs.FrontendAclMatch',
                 created_at: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 updated_at: Optional[builtins.str] = None):
        """
        :param 'FrontendAclActionArgs' action: Action to undertake when an ACL filter matches.
        :param 'FrontendAclMatchArgs' match: The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        :param builtins.str created_at: The date and time the frontend was created.
        :param builtins.str description: Description of the ACL
        :param builtins.str name: The ACL name. If not provided it will be randomly generated.
        :param builtins.str updated_at: The date and time the frontend resource was updated.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match", match)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.FrontendAclAction':
        """
        Action to undertake when an ACL filter matches.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def match(self) -> 'outputs.FrontendAclMatch':
        """
        The ACL match rule. At least `ip_subnet` or `ips_edge_services` or `http_filter` and `http_filter_value` are required.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The date and time the frontend was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description of the ACL
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The ACL name. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        The date and time the frontend resource was updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class FrontendAclAction(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 redirects: Optional[Sequence['outputs.FrontendAclActionRedirect']] = None):
        """
        :param builtins.str type: The action type. Possible values are: `allow` or `deny` or `redirect`.
        :param Sequence['FrontendAclActionRedirectArgs'] redirects: Redirect parameters when using an ACL with `redirect` action.
        """
        pulumi.set(__self__, "type", type)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The action type. Possible values are: `allow` or `deny` or `redirect`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def redirects(self) -> Optional[Sequence['outputs.FrontendAclActionRedirect']]:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")


@pulumi.output_type
class FrontendAclActionRedirect(dict):
    def __init__(__self__, *,
                 code: Optional[builtins.int] = None,
                 target: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.int code: The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        :param builtins.str target: A URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        :param builtins.str type: The redirect type. Possible values are: `location` or `scheme`.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.int]:
        """
        The HTTP redirect code to use. Valid values are `301`, `302`, `303`, `307` and `308`.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        A URL can be used in case of a location redirect (e.g. `https://scaleway.com` will redirect to this same URL). A scheme name (e.g. `https`, `http`, `ftp`, `git`) will replace the request's original scheme.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The redirect type. Possible values are: `location` or `scheme`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FrontendAclMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpFilter":
            suggest = "http_filter"
        elif key == "httpFilterOption":
            suggest = "http_filter_option"
        elif key == "httpFilterValues":
            suggest = "http_filter_values"
        elif key == "ipSubnets":
            suggest = "ip_subnets"
        elif key == "ipsEdgeServices":
            suggest = "ips_edge_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FrontendAclMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FrontendAclMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FrontendAclMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_filter: Optional[builtins.str] = None,
                 http_filter_option: Optional[builtins.str] = None,
                 http_filter_values: Optional[Sequence[builtins.str]] = None,
                 invert: Optional[builtins.bool] = None,
                 ip_subnets: Optional[Sequence[builtins.str]] = None,
                 ips_edge_services: Optional[builtins.bool] = None):
        """
        :param builtins.str http_filter: The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
               It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
               Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        :param builtins.str http_filter_option: If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        :param Sequence[builtins.str] http_filter_values: A list of possible values to match for the given HTTP filter.
               Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        :param builtins.bool invert: If set to `true`, the condition will be of type "unless".
        :param Sequence[builtins.str] ip_subnets: A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        :param builtins.bool ips_edge_services: Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        if http_filter is not None:
            pulumi.set(__self__, "http_filter", http_filter)
        if http_filter_option is not None:
            pulumi.set(__self__, "http_filter_option", http_filter_option)
        if http_filter_values is not None:
            pulumi.set(__self__, "http_filter_values", http_filter_values)
        if invert is not None:
            pulumi.set(__self__, "invert", invert)
        if ip_subnets is not None:
            pulumi.set(__self__, "ip_subnets", ip_subnets)
        if ips_edge_services is not None:
            pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> Optional[builtins.str]:
        """
        The HTTP filter to match. This filter is supported only if your backend protocol has an HTTP forward protocol.
        It extracts the request's URL path, which starts at the first slash and ends before the question mark (without the host part).
        Possible values are: `acl_http_filter_none`, `path_begin`, `path_end`, `http_header_match` or `regex`.
        """
        return pulumi.get(self, "http_filter")

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> Optional[builtins.str]:
        """
        If you have `http_filter` at `http_header_match`, you can use this field to filter on the HTTP header's value.
        """
        return pulumi.get(self, "http_filter_option")

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of possible values to match for the given HTTP filter.
        Keep in mind that in the case of `http_header_match` the HTTP header field name is case insensitive.
        """
        return pulumi.get(self, "http_filter_values")

    @property
    @pulumi.getter
    def invert(self) -> Optional[builtins.bool]:
        """
        If set to `true`, the condition will be of type "unless".
        """
        return pulumi.get(self, "invert")

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ip_subnets")

    @property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> Optional[builtins.bool]:
        """
        Defines whether Edge Services IPs should be matched. Only one of `ip_subnet` and `ips_edge_services` should be specified.
        """
        return pulumi.get(self, "ips_edge_services")


@pulumi.output_type
class LoadBalancerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None):
        """
        :param builtins.str address: The private IP address.
        :param builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "dhcpConfig":
            suggest = "dhcp_config"
        elif key == "ipamIds":
            suggest = "ipam_ids"
        elif key == "staticConfig":
            suggest = "static_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_network_id: builtins.str,
                 dhcp_config: Optional[builtins.bool] = None,
                 ipam_ids: Optional[builtins.str] = None,
                 static_config: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str private_network_id: The ID of the Private Network to attach to.
               - > **Important:** Updates to `private_network` will recreate the attachment.
        :param builtins.bool dhcp_config: Set to true if you want to let DHCP assign IP addresses
        :param builtins.str ipam_ids: IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        :param builtins.str static_config: Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        :param builtins.str status: The status of the private network connection.
        :param builtins.str zone: `zone`) The zone of the Load Balancer.
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if dhcp_config is not None:
            pulumi.set(__self__, "dhcp_config", dhcp_config)
        if ipam_ids is not None:
            pulumi.set(__self__, "ipam_ids", ipam_ids)
        if static_config is not None:
            pulumi.set(__self__, "static_config", static_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> builtins.str:
        """
        The ID of the Private Network to attach to.
        - > **Important:** Updates to `private_network` will recreate the attachment.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="dhcpConfig")
    @_utilities.deprecated("""dhcp_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""")
    def dhcp_config(self) -> Optional[builtins.bool]:
        """
        Set to true if you want to let DHCP assign IP addresses
        """
        return pulumi.get(self, "dhcp_config")

    @property
    @pulumi.getter(name="ipamIds")
    def ipam_ids(self) -> Optional[builtins.str]:
        """
        IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network.
        """
        return pulumi.get(self, "ipam_ids")

    @property
    @pulumi.getter(name="staticConfig")
    @_utilities.deprecated("""static_config field is deprecated, please use `private_network_id` or `ipam_ids` instead""")
    def static_config(self) -> Optional[builtins.str]:
        """
        Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        """
        return pulumi.get(self, "static_config")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the private network connection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        `zone`) The zone of the Load Balancer.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetAclsAclResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetAclsAclActionResult'],
                 created_at: builtins.str,
                 description: builtins.str,
                 frontend_id: builtins.str,
                 id: builtins.str,
                 index: builtins.int,
                 matches: Sequence['outputs.GetAclsAclMatchResult'],
                 name: builtins.str,
                 update_at: builtins.str):
        """
        :param Sequence['GetAclsAclActionArgs'] actions: The action to be undertaken when an ACL filter matches.
        :param builtins.str created_at: The date on which the ACL was created (RFC 3339 format).
        :param builtins.str description: The description of the ACL resource.
        :param builtins.str frontend_id: The frontend ID this ACL is attached to. ACLs with a matching frontend ID are listed.
               > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param builtins.str id: The associated ACL ID.
               > **Important:** LB ACLs' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param builtins.int index: The priority of this ACL in the ordered list.
        :param Sequence['GetAclsAclMatchArgs'] matches: The ACL match rule.
        :param builtins.str name: The ACL name to filter for. ACLs with a matching name are listed.
        :param builtins.str update_at: The date on which the ACL was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "frontend_id", frontend_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "matches", matches)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "update_at", update_at)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetAclsAclActionResult']:
        """
        The action to be undertaken when an ACL filter matches.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date on which the ACL was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the ACL resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> builtins.str:
        """
        The frontend ID this ACL is attached to. ACLs with a matching frontend ID are listed.
        > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The associated ACL ID.
        > **Important:** LB ACLs' IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def index(self) -> builtins.int:
        """
        The priority of this ACL in the ordered list.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetAclsAclMatchResult']:
        """
        The ACL match rule.
        """
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The ACL name to filter for. ACLs with a matching name are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> builtins.str:
        """
        The date on which the ACL was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetAclsAclActionResult(dict):
    def __init__(__self__, *,
                 redirects: Sequence['outputs.GetAclsAclActionRedirectResult'],
                 type: builtins.str):
        """
        :param Sequence['GetAclsAclActionRedirectArgs'] redirects: Redirect parameters when using an ACL with `redirect` action.
        :param builtins.str type: The redirect type.
        """
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetAclsAclActionRedirectResult']:
        """
        Redirect parameters when using an ACL with `redirect` action.
        """
        return pulumi.get(self, "redirects")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The redirect type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAclsAclActionRedirectResult(dict):
    def __init__(__self__, *,
                 code: builtins.int,
                 target: builtins.str,
                 type: builtins.str):
        """
        :param builtins.int code: The HTTP redirect code to use.
        :param builtins.str target: The URL used in case of a location redirect, or the scheme name that replaces the request's original scheme.
        :param builtins.str type: The redirect type.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def code(self) -> builtins.int:
        """
        The HTTP redirect code to use.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        """
        The URL used in case of a location redirect, or the scheme name that replaces the request's original scheme.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The redirect type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAclsAclMatchResult(dict):
    def __init__(__self__, *,
                 http_filter: builtins.str,
                 http_filter_option: builtins.str,
                 http_filter_values: Sequence[builtins.str],
                 invert: builtins.bool,
                 ip_subnets: Sequence[builtins.str],
                 ips_edge_services: builtins.bool):
        """
        :param builtins.str http_filter: The HTTP filter to match.
        :param builtins.str http_filter_option: A list of possible values for the HTTP filter based on the HTTP header.
        :param Sequence[builtins.str] http_filter_values: The possible values to match for a given HTTP filter.
        :param builtins.bool invert: The condition will be of type "unless" if invert is set to `true`
        :param Sequence[builtins.str] ip_subnets: A list of IPs, or CIDR v4/v6 addresses of the session client, to match.
        :param builtins.bool ips_edge_services: Defines whether Edge Services IPs should be matched.
        """
        pulumi.set(__self__, "http_filter", http_filter)
        pulumi.set(__self__, "http_filter_option", http_filter_option)
        pulumi.set(__self__, "http_filter_values", http_filter_values)
        pulumi.set(__self__, "invert", invert)
        pulumi.set(__self__, "ip_subnets", ip_subnets)
        pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> builtins.str:
        """
        The HTTP filter to match.
        """
        return pulumi.get(self, "http_filter")

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> builtins.str:
        """
        A list of possible values for the HTTP filter based on the HTTP header.
        """
        return pulumi.get(self, "http_filter_option")

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Sequence[builtins.str]:
        """
        The possible values to match for a given HTTP filter.
        """
        return pulumi.get(self, "http_filter_values")

    @property
    @pulumi.getter
    def invert(self) -> builtins.bool:
        """
        The condition will be of type "unless" if invert is set to `true`
        """
        return pulumi.get(self, "invert")

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Sequence[builtins.str]:
        """
        A list of IPs, or CIDR v4/v6 addresses of the session client, to match.
        """
        return pulumi.get(self, "ip_subnets")

    @property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> builtins.bool:
        """
        Defines whether Edge Services IPs should be matched.
        """
        return pulumi.get(self, "ips_edge_services")


@pulumi.output_type
class GetBackendHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 code: builtins.int,
                 host_header: builtins.str,
                 method: builtins.str,
                 sni: builtins.str,
                 uri: builtins.str):
        """
        :param builtins.int code: The expected HTTP status code
        :param builtins.str host_header: The HTTP host header to use for HC requests
        :param builtins.str method: The HTTP method to use for HC requests
        :param builtins.str sni: The SNI to use for HC requests over SSL
        :param builtins.str uri: The HTTPS endpoint URL to call for HC requests
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "sni", sni)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def code(self) -> builtins.int:
        """
        The expected HTTP status code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> builtins.str:
        """
        The HTTP host header to use for HC requests
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def method(self) -> builtins.str:
        """
        The HTTP method to use for HC requests
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def sni(self) -> builtins.str:
        """
        The SNI to use for HC requests over SSL
        """
        return pulumi.get(self, "sni")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The HTTPS endpoint URL to call for HC requests
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetBackendHealthCheckTcpResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetBackendsBackendResult(dict):
    def __init__(__self__, *,
                 created_at: builtins.str,
                 failover_host: builtins.str,
                 forward_port: builtins.int,
                 forward_port_algorithm: builtins.str,
                 forward_protocol: builtins.str,
                 health_check_delay: builtins.str,
                 health_check_http: Sequence['outputs.GetBackendsBackendHealthCheckHttpResult'],
                 health_check_https: Sequence['outputs.GetBackendsBackendHealthCheckHttpResult'],
                 health_check_max_retries: builtins.int,
                 health_check_port: builtins.int,
                 health_check_tcps: Sequence['outputs.GetBackendsBackendHealthCheckTcpResult'],
                 health_check_timeout: builtins.str,
                 id: builtins.str,
                 ignore_ssl_server_verify: builtins.bool,
                 lb_id: builtins.str,
                 name: builtins.str,
                 on_marked_down_action: builtins.str,
                 proxy_protocol: builtins.str,
                 server_ips: Sequence[builtins.str],
                 ssl_bridging: builtins.bool,
                 sticky_sessions: builtins.str,
                 sticky_sessions_cookie_name: builtins.str,
                 timeout_connect: builtins.str,
                 timeout_server: builtins.str,
                 timeout_tunnel: builtins.str,
                 update_at: builtins.str):
        """
        :param builtins.str created_at: The date on which the backend was created (RFC 3339 format).
        :param builtins.str failover_host: Scaleway S3 bucket website to be served if all backend servers are down.
        :param builtins.int forward_port: User sessions will be forwarded to this backend server port.
        :param builtins.str forward_port_algorithm: Load balancing algorithm.
        :param builtins.str forward_protocol: Backend protocol.
        :param builtins.str health_check_delay: Interval between two health check requests.
        :param Sequence['GetBackendsBackendHealthCheckHttpArgs'] health_check_http: This block enables HTTP health checks.
        :param Sequence['GetBackendsBackendHealthCheckHttpArgs'] health_check_https: This block enables HTTPS health checks.
        :param builtins.int health_check_max_retries: Number of allowed failed health check requests before the backend server is marked as down.
        :param builtins.int health_check_port: Port the health check requests will be sent to.
        :param Sequence['GetBackendsBackendHealthCheckTcpArgs'] health_check_tcps: This block enables TCP health checks.
        :param builtins.str health_check_timeout: Timeout before a health check request is considered failed.
        :param builtins.str id: The associated backend ID.
        :param builtins.bool ignore_ssl_server_verify: Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection.
        :param builtins.str lb_id: The Load Balancer ID this backend is attached to. Backends with a matching ID are listed.
        :param builtins.str name: The backend name to filter for. Backends with a matching name are listed.
        :param builtins.str on_marked_down_action: Modify what occurs when a backend server is marked down.
        :param builtins.str proxy_protocol: The type of PROXY protocol.
        :param Sequence[builtins.str] server_ips: List of backend server IP addresses.
        :param builtins.bool ssl_bridging: Enables SSL between Load Balancer and backend servers.
        :param builtins.str sticky_sessions: Enables cookie-based session persistence.
        :param builtins.str sticky_sessions_cookie_name: Cookie name for sticky sessions.
        :param builtins.str timeout_connect: Maximum initial server connection establishment time.
        :param builtins.str timeout_server: Maximum server connection inactivity time.
        :param builtins.str timeout_tunnel: Maximum tunnel inactivity time.
        :param builtins.str update_at: The date on which the backend was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "failover_host", failover_host)
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "forward_port_algorithm", forward_port_algorithm)
        pulumi.set(__self__, "forward_protocol", forward_protocol)
        pulumi.set(__self__, "health_check_delay", health_check_delay)
        pulumi.set(__self__, "health_check_http", health_check_http)
        pulumi.set(__self__, "health_check_https", health_check_https)
        pulumi.set(__self__, "health_check_max_retries", health_check_max_retries)
        pulumi.set(__self__, "health_check_port", health_check_port)
        pulumi.set(__self__, "health_check_tcps", health_check_tcps)
        pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ignore_ssl_server_verify", ignore_ssl_server_verify)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "on_marked_down_action", on_marked_down_action)
        pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        pulumi.set(__self__, "server_ips", server_ips)
        pulumi.set(__self__, "ssl_bridging", ssl_bridging)
        pulumi.set(__self__, "sticky_sessions", sticky_sessions)
        pulumi.set(__self__, "sticky_sessions_cookie_name", sticky_sessions_cookie_name)
        pulumi.set(__self__, "timeout_connect", timeout_connect)
        pulumi.set(__self__, "timeout_server", timeout_server)
        pulumi.set(__self__, "timeout_tunnel", timeout_tunnel)
        pulumi.set(__self__, "update_at", update_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date on which the backend was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="failoverHost")
    def failover_host(self) -> builtins.str:
        """
        Scaleway S3 bucket website to be served if all backend servers are down.
        """
        return pulumi.get(self, "failover_host")

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> builtins.int:
        """
        User sessions will be forwarded to this backend server port.
        """
        return pulumi.get(self, "forward_port")

    @property
    @pulumi.getter(name="forwardPortAlgorithm")
    def forward_port_algorithm(self) -> builtins.str:
        """
        Load balancing algorithm.
        """
        return pulumi.get(self, "forward_port_algorithm")

    @property
    @pulumi.getter(name="forwardProtocol")
    def forward_protocol(self) -> builtins.str:
        """
        Backend protocol.
        """
        return pulumi.get(self, "forward_protocol")

    @property
    @pulumi.getter(name="healthCheckDelay")
    def health_check_delay(self) -> builtins.str:
        """
        Interval between two health check requests.
        """
        return pulumi.get(self, "health_check_delay")

    @property
    @pulumi.getter(name="healthCheckHttp")
    def health_check_http(self) -> Sequence['outputs.GetBackendsBackendHealthCheckHttpResult']:
        """
        This block enables HTTP health checks.
        """
        return pulumi.get(self, "health_check_http")

    @property
    @pulumi.getter(name="healthCheckHttps")
    def health_check_https(self) -> Sequence['outputs.GetBackendsBackendHealthCheckHttpResult']:
        """
        This block enables HTTPS health checks.
        """
        return pulumi.get(self, "health_check_https")

    @property
    @pulumi.getter(name="healthCheckMaxRetries")
    def health_check_max_retries(self) -> builtins.int:
        """
        Number of allowed failed health check requests before the backend server is marked as down.
        """
        return pulumi.get(self, "health_check_max_retries")

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> builtins.int:
        """
        Port the health check requests will be sent to.
        """
        return pulumi.get(self, "health_check_port")

    @property
    @pulumi.getter(name="healthCheckTcps")
    def health_check_tcps(self) -> Sequence['outputs.GetBackendsBackendHealthCheckTcpResult']:
        """
        This block enables TCP health checks.
        """
        return pulumi.get(self, "health_check_tcps")

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> builtins.str:
        """
        Timeout before a health check request is considered failed.
        """
        return pulumi.get(self, "health_check_timeout")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The associated backend ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreSslServerVerify")
    def ignore_ssl_server_verify(self) -> builtins.bool:
        """
        Specifies whether the Load Balancer should check the backend server’s certificate before initiating a connection.
        """
        return pulumi.get(self, "ignore_ssl_server_verify")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> builtins.str:
        """
        The Load Balancer ID this backend is attached to. Backends with a matching ID are listed.
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The backend name to filter for. Backends with a matching name are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onMarkedDownAction")
    def on_marked_down_action(self) -> builtins.str:
        """
        Modify what occurs when a backend server is marked down.
        """
        return pulumi.get(self, "on_marked_down_action")

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> builtins.str:
        """
        The type of PROXY protocol.
        """
        return pulumi.get(self, "proxy_protocol")

    @property
    @pulumi.getter(name="serverIps")
    def server_ips(self) -> Sequence[builtins.str]:
        """
        List of backend server IP addresses.
        """
        return pulumi.get(self, "server_ips")

    @property
    @pulumi.getter(name="sslBridging")
    def ssl_bridging(self) -> builtins.bool:
        """
        Enables SSL between Load Balancer and backend servers.
        """
        return pulumi.get(self, "ssl_bridging")

    @property
    @pulumi.getter(name="stickySessions")
    def sticky_sessions(self) -> builtins.str:
        """
        Enables cookie-based session persistence.
        """
        return pulumi.get(self, "sticky_sessions")

    @property
    @pulumi.getter(name="stickySessionsCookieName")
    def sticky_sessions_cookie_name(self) -> builtins.str:
        """
        Cookie name for sticky sessions.
        """
        return pulumi.get(self, "sticky_sessions_cookie_name")

    @property
    @pulumi.getter(name="timeoutConnect")
    def timeout_connect(self) -> builtins.str:
        """
        Maximum initial server connection establishment time.
        """
        return pulumi.get(self, "timeout_connect")

    @property
    @pulumi.getter(name="timeoutServer")
    def timeout_server(self) -> builtins.str:
        """
        Maximum server connection inactivity time.
        """
        return pulumi.get(self, "timeout_server")

    @property
    @pulumi.getter(name="timeoutTunnel")
    def timeout_tunnel(self) -> builtins.str:
        """
        Maximum tunnel inactivity time.
        """
        return pulumi.get(self, "timeout_tunnel")

    @property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> builtins.str:
        """
        The date on which the backend was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetBackendsBackendHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 code: builtins.int,
                 host_header: builtins.str,
                 method: builtins.str,
                 sni: builtins.str,
                 uri: builtins.str):
        """
        :param builtins.int code: The expected HTTP status code.
        :param builtins.str host_header: The HTTP host header to use for health check requests.
        :param builtins.str method: The HTTP method to use for health check requests.
        :param builtins.str sni: The SNI to use for HC requests over SSL.
        :param builtins.str uri: The path of health check requests.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "host_header", host_header)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "sni", sni)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def code(self) -> builtins.int:
        """
        The expected HTTP status code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> builtins.str:
        """
        The HTTP host header to use for health check requests.
        """
        return pulumi.get(self, "host_header")

    @property
    @pulumi.getter
    def method(self) -> builtins.str:
        """
        The HTTP method to use for health check requests.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def sni(self) -> builtins.str:
        """
        The SNI to use for HC requests over SSL.
        """
        return pulumi.get(self, "sni")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        The path of health check requests.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetBackendsBackendHealthCheckTcpResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetCertificateCustomCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_chain: builtins.str):
        """
        :param builtins.str certificate_chain: The full PEM-formatted certificate chain
        """
        pulumi.set(__self__, "certificate_chain", certificate_chain)

    @property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> builtins.str:
        """
        The full PEM-formatted certificate chain
        """
        return pulumi.get(self, "certificate_chain")


@pulumi.output_type
class GetCertificateLetsencryptResult(dict):
    def __init__(__self__, *,
                 common_name: builtins.str,
                 subject_alternative_names: Sequence[builtins.str]):
        """
        :param builtins.str common_name: The main domain name of the certificate
        :param Sequence[builtins.str] subject_alternative_names: The alternative domain names of the certificate
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> builtins.str:
        """
        The main domain name of the certificate
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence[builtins.str]:
        """
        The alternative domain names of the certificate
        """
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class GetFrontendAclResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetFrontendAclActionResult'],
                 created_at: builtins.str,
                 description: builtins.str,
                 matches: Sequence['outputs.GetFrontendAclMatchResult'],
                 name: builtins.str,
                 updated_at: builtins.str):
        """
        :param Sequence['GetFrontendAclActionArgs'] actions: Action to undertake when an ACL filter matches
        :param builtins.str created_at: IsDate and time of ACL's creation (RFC 3339 format)
        :param builtins.str description: Description of the ACL
        :param Sequence['GetFrontendAclMatchArgs'] matches: The ACL match rule
        :param builtins.str name: The name of the frontend.
               - When using the `name` you should specify the `lb-id`
        :param builtins.str updated_at: IsDate and time of ACL's update (RFC 3339 format)
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "matches", matches)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetFrontendAclActionResult']:
        """
        Action to undertake when an ACL filter matches
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        IsDate and time of ACL's creation (RFC 3339 format)
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the ACL
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def matches(self) -> Sequence['outputs.GetFrontendAclMatchResult']:
        """
        The ACL match rule
        """
        return pulumi.get(self, "matches")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the frontend.
        - When using the `name` you should specify the `lb-id`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        IsDate and time of ACL's update (RFC 3339 format)
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetFrontendAclActionResult(dict):
    def __init__(__self__, *,
                 redirects: Sequence['outputs.GetFrontendAclActionRedirectResult'],
                 type: builtins.str):
        """
        :param Sequence['GetFrontendAclActionRedirectArgs'] redirects: Redirect parameters when using an ACL with `redirect` action
        :param builtins.str type: The action type
        """
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetFrontendAclActionRedirectResult']:
        """
        Redirect parameters when using an ACL with `redirect` action
        """
        return pulumi.get(self, "redirects")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The action type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFrontendAclActionRedirectResult(dict):
    def __init__(__self__, *,
                 code: builtins.int,
                 target: builtins.str,
                 type: builtins.str):
        """
        :param builtins.int code: The HTTP redirect code to use
        :param builtins.str target: An URL can be used in case of a location redirect
        :param builtins.str type: The redirect type
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def code(self) -> builtins.int:
        """
        The HTTP redirect code to use
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        """
        An URL can be used in case of a location redirect
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The redirect type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFrontendAclMatchResult(dict):
    def __init__(__self__, *,
                 http_filter: builtins.str,
                 http_filter_option: builtins.str,
                 http_filter_values: Sequence[builtins.str],
                 invert: builtins.bool,
                 ip_subnets: Sequence[builtins.str],
                 ips_edge_services: builtins.bool):
        """
        :param builtins.str http_filter: The HTTP filter to match
        :param builtins.str http_filter_option: You can use this field with http_header_match acl type to set the header name to filter
        :param Sequence[builtins.str] http_filter_values: A list of possible values to match for the given HTTP filter
        :param builtins.bool invert: If set to true, the condition will be of type "unless"
        :param Sequence[builtins.str] ip_subnets: A list of IPs or CIDR v4/v6 addresses of the client of the session to match
        :param builtins.bool ips_edge_services: Defines whether Edge Services IPs should be matched
        """
        pulumi.set(__self__, "http_filter", http_filter)
        pulumi.set(__self__, "http_filter_option", http_filter_option)
        pulumi.set(__self__, "http_filter_values", http_filter_values)
        pulumi.set(__self__, "invert", invert)
        pulumi.set(__self__, "ip_subnets", ip_subnets)
        pulumi.set(__self__, "ips_edge_services", ips_edge_services)

    @property
    @pulumi.getter(name="httpFilter")
    def http_filter(self) -> builtins.str:
        """
        The HTTP filter to match
        """
        return pulumi.get(self, "http_filter")

    @property
    @pulumi.getter(name="httpFilterOption")
    def http_filter_option(self) -> builtins.str:
        """
        You can use this field with http_header_match acl type to set the header name to filter
        """
        return pulumi.get(self, "http_filter_option")

    @property
    @pulumi.getter(name="httpFilterValues")
    def http_filter_values(self) -> Sequence[builtins.str]:
        """
        A list of possible values to match for the given HTTP filter
        """
        return pulumi.get(self, "http_filter_values")

    @property
    @pulumi.getter
    def invert(self) -> builtins.bool:
        """
        If set to true, the condition will be of type "unless"
        """
        return pulumi.get(self, "invert")

    @property
    @pulumi.getter(name="ipSubnets")
    def ip_subnets(self) -> Sequence[builtins.str]:
        """
        A list of IPs or CIDR v4/v6 addresses of the client of the session to match
        """
        return pulumi.get(self, "ip_subnets")

    @property
    @pulumi.getter(name="ipsEdgeServices")
    def ips_edge_services(self) -> builtins.bool:
        """
        Defines whether Edge Services IPs should be matched
        """
        return pulumi.get(self, "ips_edge_services")


@pulumi.output_type
class GetFrontendsFrontendResult(dict):
    def __init__(__self__, *,
                 backend_id: builtins.str,
                 certificate_ids: Sequence[builtins.str],
                 connection_rate_limit: builtins.int,
                 created_at: builtins.str,
                 enable_access_logs: builtins.bool,
                 enable_http3: builtins.bool,
                 id: builtins.str,
                 inbound_port: builtins.int,
                 lb_id: builtins.str,
                 name: builtins.str,
                 timeout_client: builtins.str,
                 update_at: builtins.str):
        """
        :param builtins.str backend_id: The Load Balancer backend ID this frontend is attached to.
               > **Important:** Load Balancer backend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param Sequence[builtins.str] certificate_ids: List of certificate IDs that are used by the frontend.
        :param builtins.int connection_rate_limit: The rate limit for new connections established on this frontend. Use 0 value to disable, else value is connections per second.
        :param builtins.str created_at: The date on which the frontend was created (RFC 3339 format).
        :param builtins.bool enable_access_logs: Defines whether to enable access logs on the frontend.
        :param builtins.bool enable_http3: Whether HTTP/3 protocol is activated.
        :param builtins.str id: The ID of the associated frontend.
               > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        :param builtins.int inbound_port: TCP port the frontend listens to.
        :param builtins.str lb_id: The Load Balancer ID this frontend is attached to. Frontends with a matching ID are listed.
        :param builtins.str name: The frontend name to filter for. Frontends with a matching name are listed.
        :param builtins.str timeout_client: Maximum inactivity time on the client side.
        :param builtins.str update_at: The date on which the frontend was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        pulumi.set(__self__, "connection_rate_limit", connection_rate_limit)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        pulumi.set(__self__, "enable_http3", enable_http3)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inbound_port", inbound_port)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "timeout_client", timeout_client)
        pulumi.set(__self__, "update_at", update_at)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> builtins.str:
        """
        The Load Balancer backend ID this frontend is attached to.
        > **Important:** Load Balancer backend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "backend_id")

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Sequence[builtins.str]:
        """
        List of certificate IDs that are used by the frontend.
        """
        return pulumi.get(self, "certificate_ids")

    @property
    @pulumi.getter(name="connectionRateLimit")
    def connection_rate_limit(self) -> builtins.int:
        """
        The rate limit for new connections established on this frontend. Use 0 value to disable, else value is connections per second.
        """
        return pulumi.get(self, "connection_rate_limit")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date on which the frontend was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> builtins.bool:
        """
        Defines whether to enable access logs on the frontend.
        """
        return pulumi.get(self, "enable_access_logs")

    @property
    @pulumi.getter(name="enableHttp3")
    def enable_http3(self) -> builtins.bool:
        """
        Whether HTTP/3 protocol is activated.
        """
        return pulumi.get(self, "enable_http3")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the associated frontend.
        > **Important:** LB frontend IDs are zoned, which means they are of the form `{zone}/{id}`, e.g. `fr-par-1/11111111-1111-1111-1111-111111111111`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inboundPort")
    def inbound_port(self) -> builtins.int:
        """
        TCP port the frontend listens to.
        """
        return pulumi.get(self, "inbound_port")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> builtins.str:
        """
        The Load Balancer ID this frontend is attached to. Frontends with a matching ID are listed.
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The frontend name to filter for. Frontends with a matching name are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="timeoutClient")
    def timeout_client(self) -> builtins.str:
        """
        Maximum inactivity time on the client side.
        """
        return pulumi.get(self, "timeout_client")

    @property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> builtins.str:
        """
        The date on which the frontend was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


@pulumi.output_type
class GetIpsIpResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 ip_address: builtins.str,
                 lb_id: builtins.str,
                 organization_id: builtins.str,
                 project_id: builtins.str,
                 reverse: builtins.str,
                 tags: Sequence[builtins.str],
                 zone: builtins.str):
        """
        :param builtins.str id: The ID of the associated IP.
        :param builtins.str ip_address: The IP address
        :param builtins.str lb_id: The ID of the associated Load BalancerD, if any
        :param builtins.str organization_id: The ID of the Organization the Load Balancer is associated with.
        :param builtins.str project_id: The ID of the Project the Load Balancer is associated with.
        :param builtins.str reverse: The reverse domain associated with this IP.
        :param Sequence[builtins.str] tags: List of tags used as filter. IPs with these exact tags are listed.
        :param builtins.str zone: `zone`) The zone in which the IPs exist.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the associated IP.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        The IP address
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> builtins.str:
        """
        The ID of the associated Load BalancerD, if any
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        The ID of the Organization the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def reverse(self) -> builtins.str:
        """
        The reverse domain associated with this IP.
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        List of tags used as filter. IPs with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `zone`) The zone in which the IPs exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLoadBalancerPrivateIpResult(dict):
    def __init__(__self__, *,
                 address: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str address: The private IP address
        :param builtins.str id: The ID of the Load Balancer.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The private IP address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetLoadBalancerPrivateNetworkResult(dict):
    def __init__(__self__, *,
                 dhcp_config: builtins.bool,
                 ipam_ids: Sequence[builtins.str],
                 private_network_id: builtins.str,
                 static_configs: Sequence[builtins.str],
                 status: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.bool dhcp_config: Set to true if you want to let DHCP assign IP addresses
        :param Sequence[builtins.str] ipam_ids: IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network
        :param builtins.str private_network_id: The Private Network ID
        :param Sequence[builtins.str] static_configs: Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        :param builtins.str status: The status of private network connection
        :param builtins.str zone: (Defaults to provider `zone`) The zone in which the Load Balancer exists.
        """
        pulumi.set(__self__, "dhcp_config", dhcp_config)
        pulumi.set(__self__, "ipam_ids", ipam_ids)
        pulumi.set(__self__, "private_network_id", private_network_id)
        pulumi.set(__self__, "static_configs", static_configs)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="dhcpConfig")
    def dhcp_config(self) -> builtins.bool:
        """
        Set to true if you want to let DHCP assign IP addresses
        """
        return pulumi.get(self, "dhcp_config")

    @property
    @pulumi.getter(name="ipamIds")
    def ipam_ids(self) -> Sequence[builtins.str]:
        """
        IPAM ID of a pre-reserved IP address to assign to the Load Balancer on this Private Network
        """
        return pulumi.get(self, "ipam_ids")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> builtins.str:
        """
        The Private Network ID
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="staticConfigs")
    def static_configs(self) -> Sequence[builtins.str]:
        """
        Define an IP address in the subnet of your private network that will be assigned to your load balancer instance
        """
        return pulumi.get(self, "static_configs")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of private network connection
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        (Defaults to provider `zone`) The zone in which the Load Balancer exists.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLoadBalancersLbResult(dict):
    def __init__(__self__, *,
                 backend_count: builtins.int,
                 created_at: builtins.str,
                 description: builtins.str,
                 frontend_count: builtins.int,
                 id: builtins.str,
                 instances: Sequence['outputs.GetLoadBalancersLbInstanceResult'],
                 ips: Sequence['outputs.GetLoadBalancersLbIpResult'],
                 name: builtins.str,
                 organization_id: builtins.str,
                 private_network_count: builtins.int,
                 project_id: builtins.str,
                 route_count: builtins.int,
                 ssl_compatibility_level: builtins.str,
                 status: builtins.str,
                 subscriber: builtins.str,
                 tags: Sequence[builtins.str],
                 type: builtins.str,
                 updated_at: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.int backend_count: Number of backends the Load Balancer has.
        :param builtins.str created_at: Date on which the Load Balancer was created.
        :param builtins.str description: The description of the Load Balancer.
        :param builtins.int frontend_count: Number of frontends the Load Balancer has.
        :param builtins.str id: The ID of the Load Balancer.
        :param Sequence['GetLoadBalancersLbInstanceArgs'] instances: List of underlying Instances.
        :param Sequence['GetLoadBalancersLbIpArgs'] ips: List of IPs attached to the Load Balancer.
        :param builtins.str name: The Load Balancer name to filter for. Load Balancers with a matching name are listed.
        :param builtins.str organization_id: The ID of the Organization the Load Balancer is associated with.
        :param builtins.int private_network_count: Number of Private Networks attached to the Load balancer.
        :param builtins.str project_id: The ID of the Project the Load Balancer is associated with.
        :param builtins.int route_count: Number of routes the Load balancer has.
        :param builtins.str ssl_compatibility_level: Determines the minimal SSL version which needs to be supported on the client side.
        :param builtins.str status: The state of the Load Balancer Instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        :param builtins.str subscriber: The subscriber information.
        :param Sequence[builtins.str] tags: List of tags to filter for. Load Balancers with these exact tags are listed.
        :param builtins.str type: The offer type of the Load Balancer.
        :param builtins.str updated_at: Date on which the Load Balancer was updated.
        :param builtins.str zone: `zone`) The zone in which the Load Balancers exist.
        """
        pulumi.set(__self__, "backend_count", backend_count)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "frontend_count", frontend_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "private_network_count", private_network_count)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "route_count", route_count)
        pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subscriber", subscriber)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="backendCount")
    def backend_count(self) -> builtins.int:
        """
        Number of backends the Load Balancer has.
        """
        return pulumi.get(self, "backend_count")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        Date on which the Load Balancer was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Load Balancer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frontendCount")
    def frontend_count(self) -> builtins.int:
        """
        Number of frontends the Load Balancer has.
        """
        return pulumi.get(self, "frontend_count")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetLoadBalancersLbInstanceResult']:
        """
        List of underlying Instances.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetLoadBalancersLbIpResult']:
        """
        List of IPs attached to the Load Balancer.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The Load Balancer name to filter for. Load Balancers with a matching name are listed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        The ID of the Organization the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="privateNetworkCount")
    def private_network_count(self) -> builtins.int:
        """
        Number of Private Networks attached to the Load balancer.
        """
        return pulumi.get(self, "private_network_count")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="routeCount")
    def route_count(self) -> builtins.int:
        """
        Number of routes the Load balancer has.
        """
        return pulumi.get(self, "route_count")

    @property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> builtins.str:
        """
        Determines the minimal SSL version which needs to be supported on the client side.
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The state of the Load Balancer Instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subscriber(self) -> builtins.str:
        """
        The subscriber information.
        """
        return pulumi.get(self, "subscriber")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        List of tags to filter for. Load Balancers with these exact tags are listed.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The offer type of the Load Balancer.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        Date on which the Load Balancer was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `zone`) The zone in which the Load Balancers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLoadBalancersLbInstanceResult(dict):
    def __init__(__self__, *,
                 created_at: builtins.str,
                 id: builtins.str,
                 ip_address: builtins.str,
                 status: builtins.str,
                 updated_at: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str created_at: Date on which the Load Balancer was created.
        :param builtins.str id: The ID of the Load Balancer.
        :param builtins.str ip_address: IP address of the instance
        :param builtins.str status: The state of the Load Balancer Instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        :param builtins.str updated_at: Date on which the Load Balancer was updated.
        :param builtins.str zone: `zone`) The zone in which the Load Balancers exist.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        Date on which the Load Balancer was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        IP address of the instance
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The state of the Load Balancer Instance. Possible values are: `unknown`, `ready`, `pending`, `stopped`, `error`, `locked` and `migrating`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        Date on which the Load Balancer was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `zone`) The zone in which the Load Balancers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetLoadBalancersLbIpResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 ip_address: builtins.str,
                 lb_id: builtins.str,
                 organization_id: builtins.str,
                 project_id: builtins.str,
                 reverse: builtins.str,
                 zone: builtins.str):
        """
        :param builtins.str id: The ID of the Load Balancer.
        :param builtins.str ip_address: IP address
        :param builtins.str lb_id: UUID of the load balancer attached to the IP
        :param builtins.str organization_id: The ID of the Organization the Load Balancer is associated with.
        :param builtins.str project_id: The ID of the Project the Load Balancer is associated with.
        :param builtins.str reverse: Reverse DNS attached to the IP
        :param builtins.str zone: `zone`) The zone in which the Load Balancers exist.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "lb_id", lb_id)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "reverse", reverse)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        """
        IP address
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> builtins.str:
        """
        UUID of the load balancer attached to the IP
        """
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        The ID of the Organization the Load Balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the Project the Load Balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def reverse(self) -> builtins.str:
        """
        Reverse DNS attached to the IP
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        """
        `zone`) The zone in which the Load Balancers exist.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetRoutesRouteResult(dict):
    def __init__(__self__, *,
                 backend_id: builtins.str,
                 created_at: builtins.str,
                 frontend_id: builtins.str,
                 id: builtins.str,
                 match_host_header: builtins.str,
                 match_sni: builtins.str,
                 match_subdomains: builtins.bool,
                 update_at: builtins.str):
        """
        :param builtins.str backend_id: The backend ID to redirect to
        :param builtins.str created_at: The date on which the route was created (RFC 3339 format).
        :param builtins.str frontend_id: The frontend ID (the origin of the redirection), to filter for. Routes with a matching frontend ID are listed.
        :param builtins.str id: The associated route ID.
        :param builtins.str match_host_header: Specifies the host of the server to which the request is being sent.
        :param builtins.str match_sni: Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        :param builtins.bool match_subdomains: If true, all subdomains will match.
        :param builtins.str update_at: The date on which the route was last updated (RFC 3339 format).
        """
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "frontend_id", frontend_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "match_host_header", match_host_header)
        pulumi.set(__self__, "match_sni", match_sni)
        pulumi.set(__self__, "match_subdomains", match_subdomains)
        pulumi.set(__self__, "update_at", update_at)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> builtins.str:
        """
        The backend ID to redirect to
        """
        return pulumi.get(self, "backend_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date on which the route was created (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> builtins.str:
        """
        The frontend ID (the origin of the redirection), to filter for. Routes with a matching frontend ID are listed.
        """
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The associated route ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="matchHostHeader")
    def match_host_header(self) -> builtins.str:
        """
        Specifies the host of the server to which the request is being sent.
        """
        return pulumi.get(self, "match_host_header")

    @property
    @pulumi.getter(name="matchSni")
    def match_sni(self) -> builtins.str:
        """
        Server Name Indication TLS extension field from an incoming connection made via an SSL/TLS transport layer.
        """
        return pulumi.get(self, "match_sni")

    @property
    @pulumi.getter(name="matchSubdomains")
    def match_subdomains(self) -> builtins.bool:
        """
        If true, all subdomains will match.
        """
        return pulumi.get(self, "match_subdomains")

    @property
    @pulumi.getter(name="updateAt")
    def update_at(self) -> builtins.str:
        """
        The date on which the route was last updated (RFC 3339 format).
        """
        return pulumi.get(self, "update_at")


