# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterAclArgs',
    'ClusterAclArgsDict',
    'ClusterPrivateIpArgs',
    'ClusterPrivateIpArgsDict',
    'ClusterPrivateNetworkArgs',
    'ClusterPrivateNetworkArgsDict',
    'ClusterPublicNetworkArgs',
    'ClusterPublicNetworkArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterAclArgsDict(TypedDict):
        ip: pulumi.Input[builtins.str]
        """
        The IP range to whitelist
        in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        A text describing this rule. Default description: `Allow IP`

        > The `acl` conflict with `private_network`. Only one should be specified.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the IPv4 address resource.
        """
elif False:
    ClusterAclArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAclArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ip: The IP range to whitelist
               in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param pulumi.Input[builtins.str] description: A text describing this rule. Default description: `Allow IP`
               
               > The `acl` conflict with `private_network`. Only one should be specified.
        :param pulumi.Input[builtins.str] id: The ID of the IPv4 address resource.
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[builtins.str]:
        """
        The IP range to whitelist
        in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A text describing this rule. Default description: `Allow IP`

        > The `acl` conflict with `private_network`. Only one should be specified.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class ClusterPrivateIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        The private IPv4 address.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the IPv4 address resource.
        """
elif False:
    ClusterPrivateIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPrivateIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] address: The private IPv4 address.
        :param pulumi.Input[builtins.str] id: The ID of the IPv4 address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class ClusterPrivateNetworkArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The UUID of the Private Network resource.
        """
        endpoint_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the endpoint.
        """
        ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of IPv4 addresses of the endpoint.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        TCP port of the endpoint.
        """
        service_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
        Keep in mind that in cluster mode you cannot edit your Private Network after its creation so if you want to be able to
        scale your cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
        If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        > **Important:** When IPAM is enabled, the IPs specified here will be ignored and should not be provided.

        > The `private_network` conflicts with `acl`. Only one should be specified.

        > **Important:** The way to use Private Networks differs whether you are using Redis™ in Standalone or cluster mode.

        - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
        block). If you detach your only Private Network, your cluster won't be reachable until you define a new Private or
        Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
        by side.

        - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your cluster, you won't be
        able to edit or detach it afterward, unless you create another cluster. This also means that, if you are using a static
        configuration (`service_ips`), you won't be able to scale your cluster horizontally (add more nodes) since it would
        require updating the Private Network to add IPs.
        Your `service_ips` must be listed as follows:
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        `zone`) The zone in which the
        Redis™ cluster should be created.
        """
elif False:
    ClusterPrivateNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPrivateNetworkArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 service_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: The UUID of the Private Network resource.
        :param pulumi.Input[builtins.str] endpoint_id: The ID of the endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ips: List of IPv4 addresses of the endpoint.
        :param pulumi.Input[builtins.int] port: TCP port of the endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] service_ips: Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
               Keep in mind that in cluster mode you cannot edit your Private Network after its creation so if you want to be able to
               scale your cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
               If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               > **Important:** When IPAM is enabled, the IPs specified here will be ignored and should not be provided.
               
               > The `private_network` conflicts with `acl`. Only one should be specified.
               
               > **Important:** The way to use Private Networks differs whether you are using Redis™ in Standalone or cluster mode.
               
               - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
               block). If you detach your only Private Network, your cluster won't be reachable until you define a new Private or
               Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
               by side.
               
               - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your cluster, you won't be
               able to edit or detach it afterward, unless you create another cluster. This also means that, if you are using a static
               configuration (`service_ips`), you won't be able to scale your cluster horizontally (add more nodes) since it would
               require updating the Private Network to add IPs.
               Your `service_ips` must be listed as follows:
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the
               Redis™ cluster should be created.
        """
        pulumi.set(__self__, "id", id)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ips is not None:
            pulumi.set(__self__, "service_ips", service_ips)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The UUID of the Private Network resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serviceIps")
    def service_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Endpoint IPv4 addresses in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). You must provide at least one IP per node.
        Keep in mind that in cluster mode you cannot edit your Private Network after its creation so if you want to be able to
        scale your cluster horizontally (adding nodes) later, you should provide more IPs than nodes.
        If not set, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        > **Important:** When IPAM is enabled, the IPs specified here will be ignored and should not be provided.

        > The `private_network` conflicts with `acl`. Only one should be specified.

        > **Important:** The way to use Private Networks differs whether you are using Redis™ in Standalone or cluster mode.

        - Standalone mode (`cluster_size` = 1) : you can attach as many Private Networks as you want (each must be a separate
        block). If you detach your only Private Network, your cluster won't be reachable until you define a new Private or
        Public Network. You can modify your `private_network` and its specs, you can have both a Private and Public Network side
        by side.

        - Cluster mode (`cluster_size` > 2) : you can define a single Private Network as you create your cluster, you won't be
        able to edit or detach it afterward, unless you create another cluster. This also means that, if you are using a static
        configuration (`service_ips`), you won't be able to scale your cluster horizontally (add more nodes) since it would
        require updating the Private Network to add IPs.
        Your `service_ips` must be listed as follows:
        """
        return pulumi.get(self, "service_ips")

    @service_ips.setter
    def service_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "service_ips", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the
        Redis™ cluster should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class ClusterPublicNetworkArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the IPv4 address resource.
        """
        ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of IPv4 addresses of the endpoint.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        TCP port of the endpoint.
        """
elif False:
    ClusterPublicNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPublicNetworkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] id: The ID of the IPv4 address resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ips: List of IPv4 addresses of the endpoint.
        :param pulumi.Input[builtins.int] port: TCP port of the endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of IPv4 addresses of the endpoint.
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


