# Generated by Django 5.2.7 on 2025-11-04 05:14

import django.db.models.deletion
import django_cfg.apps.integrations.grpc.models.grpc_api_key
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("grpc", "0004_grpcserverstatus_registered_services"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="GrpcApiKey",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "key",
                    models.CharField(
                        db_index=True,
                        default=django_cfg.apps.integrations.grpc.models.grpc_api_key.generate_api_key,
                        help_text="API key (auto-generated)",
                        max_length=64,
                        unique=True,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Descriptive name for this key (e.g., 'Analytics Service')",
                        max_length=255,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Additional details about this key's purpose"
                    ),
                ),
                (
                    "key_type",
                    models.CharField(
                        choices=[
                            ("service", "Service-to-Service"),
                            ("cli", "CLI Tool"),
                            ("webhook", "Webhook"),
                            ("internal", "Internal System"),
                            ("development", "Development"),
                        ],
                        default="service",
                        help_text="Type of API key",
                        max_length=20,
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="Whether this key is currently active (can be used)",
                    ),
                ),
                (
                    "expires_at",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        help_text="When this key expires (null = never expires)",
                        null=True,
                    ),
                ),
                (
                    "last_used_at",
                    models.DateTimeField(
                        blank=True, help_text="When this key was last used", null=True
                    ),
                ),
                (
                    "request_count",
                    models.IntegerField(
                        default=0, help_text="Total number of requests made with this key"
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, help_text="When this key was created"
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, help_text="When this key was last updated"),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="User who created this key",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="created_grpc_api_keys",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="User this key authenticates as",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="grpc_api_keys",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "gRPC API Key",
                "verbose_name_plural": "gRPC API Keys",
                "db_table": "django_cfg_grpc_api_key",
                "ordering": ["-created_at"],
                "indexes": [
                    models.Index(
                        fields=["user", "-created_at"], name="django_cfg__user_id_9c5276_idx"
                    ),
                    models.Index(
                        fields=["is_active", "-created_at"], name="django_cfg__is_acti_26421c_idx"
                    ),
                    models.Index(fields=["expires_at"], name="django_cfg__expires_8f83cf_idx"),
                    models.Index(
                        fields=["key_type", "-created_at"], name="django_cfg__key_typ_6ad1cb_idx"
                    ),
                ],
            },
        ),
    ]
