import pytest
import sys, os
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

from eyetools.validators import ContactLensValidator

validator = ContactLensValidator()

def test_spherical_equivalent():
    result = validator.spherical_equivalent(2, -1)
    assert result == 1.5

def test_round_to_nearest_quarter():
    assert validator.round_to_nearest_quarter(1.12) == 1.0
    assert validator.round_to_nearest_quarter(1.14) == 1.25

def test_is_multiple_of_quarter():
    assert validator.is_multiple_of_quarter(1.25)
    assert not validator.is_multiple_of_quarter(1.22)

def test_spheric_without_vertex_distance():
    val = validator.spheric_without_vertex_distance(5, 12)
    assert round(val, 2) == 5.32  # تقريبًا

def test_convert_to_spheric():
    data = {"SPH": "2", "CY": "-1", "BV": "12"}
    result = validator.convert_to_spheric(data)
    assert isinstance(result, dict)
    assert "SPH" in result
    assert "ADD" in result
    assert "BV" in result

def test_convert_to_toric():
    data = {"SPH": "3.00", "CY": "-1.25", "AX": "90", "BV": "12"}
    result = validator.convert_to_toric(data)
    assert isinstance(result, dict)
    assert "SPH" in result
    assert "CY" in result
    assert "AX" in result
