import pytest
import sys, os
sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

from eyetools.validators import EyeTestValidator

validator = EyeTestValidator()

def test_is_multiple_of_quarter_true():
    assert validator.is_multiple_of_quarter(0.75)
    assert validator.is_multiple_of_quarter(-1.25)

def test_is_multiple_of_quarter_false():
    assert not validator.is_multiple_of_quarter(0.77)
    assert not validator.is_multiple_of_quarter("abc")

def test_valid_eye_test_power():
    assert validator.is_valida_eye_test_power(1.25) == "+01.25"
    assert not validator.is_valida_eye_test_power(1.33)

def test_check_axis_valid():
    assert validator.check_axis(90)
    assert validator.check_axis(180)
    assert not validator.check_axis(0)
    assert not validator.check_axis(190)

def test_check_pd():
    assert validator.check_pd(60)
    assert not validator.check_pd(10)
    assert not validator.check_pd("abc")

def test_remove_sign():
    assert validator.remove_sign("-2.50") == "2.50"
    assert validator.remove_sign("3") == "3.00"
    assert validator.remove_sign("abc") is None

def test_check_add():
    assert validator.check_add(0.25)
    assert validator.check_add(3.75)
    assert not validator.check_add(5)
    assert not validator.check_add(-0.25)

def test_power_format():
    data = {"SPH": "2.00", "CY": "-1.00", "AX": "90"}
    result = validator.power_format(data)
    assert isinstance(result, dict)
    assert "SPH" in result
    assert "CY" in result
    assert "AX" in result

def test_check_SG():
    assert validator.check_SG(10)
    assert not validator.check_SG(5)

def test_Check_vertex_distance():
    assert validator.Check_vertex_distance(12)
    assert not validator.Check_vertex_distance(20)
