# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.61
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AzimIntSettings(BaseModel):
    """
    AzimIntSettings
    """ # noqa: E501
    polarization_corr: StrictBool = Field(description="Apply polarization correction for radial integration (polarization factor must be configured in dataset settings)")
    solid_angle_corr: StrictBool = Field(description="Apply solid angle correction for radial integration")
    high_q_recip_a: Union[StrictFloat, StrictInt] = Field(alias="high_q_recipA")
    low_q_recip_a: Union[StrictFloat, StrictInt] = Field(alias="low_q_recipA")
    q_spacing: Union[StrictFloat, StrictInt]
    azimuthal_bins: Optional[Annotated[int, Field(le=256, strict=True, ge=1)]] = Field(default=1, description="Numer of azimuthal (phi) bins; 1 = standard 1D radial integration")
    __properties: ClassVar[List[str]] = ["polarization_corr", "solid_angle_corr", "high_q_recipA", "low_q_recipA", "q_spacing", "azimuthal_bins"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AzimIntSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AzimIntSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "polarization_corr": obj.get("polarization_corr") if obj.get("polarization_corr") is not None else True,
            "solid_angle_corr": obj.get("solid_angle_corr") if obj.get("solid_angle_corr") is not None else True,
            "high_q_recipA": obj.get("high_q_recipA"),
            "low_q_recipA": obj.get("low_q_recipA"),
            "q_spacing": obj.get("q_spacing"),
            "azimuthal_bins": obj.get("azimuthal_bins") if obj.get("azimuthal_bins") is not None else 1
        })
        return _obj


