# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.61
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class BrokerStatus(BaseModel):
    """
    BrokerStatus
    """ # noqa: E501
    state: StrictStr
    progress: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=None, description="Progress of data collection (only available if receiving is running)")
    message: Optional[StrictStr] = Field(default=None, description="Message to display besides state of the jfjoch_broker; mostly used for errors and warnings This matters especially for async functions (start/initialize), where API won't return reason for the error during async operation. ")
    message_severity: Optional[StrictStr] = Field(default='error', description="Level of the message to display")
    gpu_count: Optional[StrictInt] = Field(default=None, description="Number of installed GPUs")
    ml_resolution_estimation: Optional[StrictBool] = Field(default=None, description="ML resolution estimation available")
    __properties: ClassVar[List[str]] = ["state", "progress", "message", "message_severity", "gpu_count", "ml_resolution_estimation"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Inactive', 'Idle', 'Busy', 'Measuring', 'Pedestal', 'Error']):
            raise ValueError("must be one of enum values ('Inactive', 'Idle', 'Busy', 'Measuring', 'Pedestal', 'Error')")
        return value

    @field_validator('message_severity')
    def message_severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['success', 'info', 'warning', 'error']):
            raise ValueError("must be one of enum values ('success', 'info', 'warning', 'error')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BrokerStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BrokerStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "progress": obj.get("progress"),
            "message": obj.get("message"),
            "message_severity": obj.get("message_severity") if obj.get("message_severity") is not None else 'error',
            "gpu_count": obj.get("gpu_count"),
            "ml_resolution_estimation": obj.get("ml_resolution_estimation")
        })
        return _obj


