# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.61
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from jfjoch_client.models.detector_module import DetectorModule
from jfjoch_client.models.detector_type import DetectorType
from jfjoch_client.models.standard_detector_geometry import StandardDetectorGeometry
from typing import Optional, Set
from typing_extensions import Self

class Detector(BaseModel):
    """
    Detector
    """ # noqa: E501
    description: Annotated[str, Field(min_length=1, strict=True)]
    serial_number: Optional[Annotated[str, Field(min_length=1, strict=True)]] = 'Unknown'
    type: Optional[DetectorType] = None
    high_voltage_v: Optional[Annotated[int, Field(le=200, strict=True, ge=0)]] = Field(default=0, alias="high_voltage_V")
    udp_interface_count: Optional[Annotated[int, Field(le=2, strict=True, ge=1)]] = 1
    module_sync: Optional[StrictBool] = Field(default=True, description="Use module 0 as master for timing. Only applies to JUNGFRAU detector (this cannot be turned off for EIGER).")
    sensor_thickness_um: Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]] = 320
    readout_time_us: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=None, description="Minimum difference between frame time and count time in microseconds Defaults are 3 us for EIGER and 20 us for JUNGFRAU ")
    minimum_count_time_us: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Minimum count time available for the detector.")
    minimum_frame_time_us: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Minimum frame time available for the detector.")
    calibration_file: Optional[List[StrictStr]] = Field(default=None, description="Can be empty for all detectors - default calibration used. For JUNGFRAU: list of gain files, one entry per module. For EIGER: one directory (with detector settings) or list of trim bit files, one entry per half-module. ")
    hostname: Optional[List[StrictStr]] = Field(default=None, description="Hostname for detector module. One entry per module One entry per module. Either empty or number of module entries. ")
    sensor_material: Optional[StrictStr] = 'Si'
    tx_delay: Optional[List[StrictInt]] = None
    base_data_ipv4_address: Optional[StrictStr] = None
    standard_geometry: Optional[StandardDetectorGeometry] = None
    custom_geometry: Optional[List[DetectorModule]] = None
    roi_mode: Optional[StrictStr] = Field(default='', description="ROI setting for DECTRIS detectors")
    mirror_y: Optional[StrictBool] = Field(default=True, description="Mirror detector in Y direction to account for MX convention of (0,0) point in top left corner")
    __properties: ClassVar[List[str]] = ["description", "serial_number", "type", "high_voltage_V", "udp_interface_count", "module_sync", "sensor_thickness_um", "readout_time_us", "minimum_count_time_us", "minimum_frame_time_us", "calibration_file", "hostname", "sensor_material", "tx_delay", "base_data_ipv4_address", "standard_geometry", "custom_geometry", "roi_mode", "mirror_y"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Detector from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of standard_geometry
        if self.standard_geometry:
            _dict['standard_geometry'] = self.standard_geometry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in custom_geometry (list)
        _items = []
        if self.custom_geometry:
            for _item_custom_geometry in self.custom_geometry:
                if _item_custom_geometry:
                    _items.append(_item_custom_geometry.to_dict())
            _dict['custom_geometry'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Detector from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "serial_number": obj.get("serial_number") if obj.get("serial_number") is not None else 'Unknown',
            "type": obj.get("type"),
            "high_voltage_V": obj.get("high_voltage_V") if obj.get("high_voltage_V") is not None else 0,
            "udp_interface_count": obj.get("udp_interface_count") if obj.get("udp_interface_count") is not None else 1,
            "module_sync": obj.get("module_sync") if obj.get("module_sync") is not None else True,
            "sensor_thickness_um": obj.get("sensor_thickness_um") if obj.get("sensor_thickness_um") is not None else 320,
            "readout_time_us": obj.get("readout_time_us"),
            "minimum_count_time_us": obj.get("minimum_count_time_us"),
            "minimum_frame_time_us": obj.get("minimum_frame_time_us"),
            "calibration_file": obj.get("calibration_file"),
            "hostname": obj.get("hostname"),
            "sensor_material": obj.get("sensor_material") if obj.get("sensor_material") is not None else 'Si',
            "tx_delay": obj.get("tx_delay"),
            "base_data_ipv4_address": obj.get("base_data_ipv4_address"),
            "standard_geometry": StandardDetectorGeometry.from_dict(obj["standard_geometry"]) if obj.get("standard_geometry") is not None else None,
            "custom_geometry": [DetectorModule.from_dict(_item) for _item in obj["custom_geometry"]] if obj.get("custom_geometry") is not None else None,
            "roi_mode": obj.get("roi_mode") if obj.get("roi_mode") is not None else '',
            "mirror_y": obj.get("mirror_y") if obj.get("mirror_y") is not None else True
        })
        return _obj


