# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.61
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class FileWriterFormat(str, Enum):
    """
    None - no master file written NXmxLegacy - legacy format with soft links to data files in the master file; necessary for DECTRIS Albula 4.0 and DECTRIS Neggia   NXmxVDS - newer format with virtual dataset linking data files in the master file, also includes better metadata handling 
    """

    """
    allowed enum values
    """
    NONE = 'None'
    NXMXLEGACY = 'NXmxLegacy'
    NXMXVDS = 'NXmxVDS'
    CBF = 'CBF'
    TIFF = 'TIFF'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of FileWriterFormat from a JSON string"""
        return cls(json.loads(json_str))


