# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.61
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Union
from typing_extensions import Annotated
from jfjoch_client.models.indexing_algorithm import IndexingAlgorithm
from typing import Optional, Set
from typing_extensions import Self

class IndexingSettings(BaseModel):
    """
    Settings for crystallography indexing
    """ # noqa: E501
    algorithm: IndexingAlgorithm
    fft_max_unit_cell_a: Union[Annotated[float, Field(le=500, strict=True, ge=50)], Annotated[int, Field(le=500, strict=True, ge=50)]] = Field(description="Largest unit cell to be indexed by FFT algorithm; parameter value affects execution time of FFT", alias="fft_max_unit_cell_A")
    fft_min_unit_cell_a: Union[Annotated[float, Field(le=40, strict=True, ge=5)], Annotated[int, Field(le=40, strict=True, ge=5)]] = Field(description="Smallest unit cell to be indexed by FFT algorithm; parameter value affects execution time of FFT", alias="fft_min_unit_cell_A")
    fft_high_resolution_a: Union[Annotated[float, Field(le=6.0, strict=True, ge=0.5)], Annotated[int, Field(le=6, strict=True, ge=1)]] = Field(description="Highest resolution of spots used for FFT algorithm; parameter value affects execution time of FFT. There is also correlation between smallest unit cell and max resolution, which need to be checked for very small systems. ", alias="fft_high_resolution_A")
    fft_num_vectors: Annotated[int, Field(strict=True, ge=128)] = Field(description="Number of search directions for the FFT algorithm; parameter value affects execution time of FFT.")
    tolerance: Union[Annotated[float, Field(le=0.5, strict=True, ge=0.0)], Annotated[int, Field(le=0, strict=True, ge=0)]] = Field(description="Acceptance tolerance for spots after the indexing run - the larger the number, the more spots will be accepted")
    __properties: ClassVar[List[str]] = ["algorithm", "fft_max_unit_cell_A", "fft_min_unit_cell_A", "fft_high_resolution_A", "fft_num_vectors", "tolerance"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IndexingSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IndexingSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "algorithm": obj.get("algorithm") if obj.get("algorithm") is not None else IndexingAlgorithm.FFBIDX,
            "fft_max_unit_cell_A": obj.get("fft_max_unit_cell_A") if obj.get("fft_max_unit_cell_A") is not None else 250,
            "fft_min_unit_cell_A": obj.get("fft_min_unit_cell_A") if obj.get("fft_min_unit_cell_A") is not None else 10.0,
            "fft_high_resolution_A": obj.get("fft_high_resolution_A") if obj.get("fft_high_resolution_A") is not None else 2.0,
            "fft_num_vectors": obj.get("fft_num_vectors") if obj.get("fft_num_vectors") is not None else 16384,
            "tolerance": obj.get("tolerance")
        })
        return _obj


