# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.61
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from jfjoch_client.models.azim_int_settings import AzimIntSettings
from jfjoch_client.models.broker_status import BrokerStatus
from jfjoch_client.models.calibration_statistics_inner import CalibrationStatisticsInner
from jfjoch_client.models.detector_list import DetectorList
from jfjoch_client.models.detector_settings import DetectorSettings
from jfjoch_client.models.detector_status import DetectorStatus
from jfjoch_client.models.file_writer_settings import FileWriterSettings
from jfjoch_client.models.fpga_status_inner import FpgaStatusInner
from jfjoch_client.models.image_buffer_status import ImageBufferStatus
from jfjoch_client.models.image_format_settings import ImageFormatSettings
from jfjoch_client.models.indexing_settings import IndexingSettings
from jfjoch_client.models.instrument_metadata import InstrumentMetadata
from jfjoch_client.models.measurement_statistics import MeasurementStatistics
from jfjoch_client.models.pixel_mask_statistics import PixelMaskStatistics
from jfjoch_client.models.roi_definitions import RoiDefinitions
from jfjoch_client.models.spot_finding_settings import SpotFindingSettings
from jfjoch_client.models.zeromq_metadata_settings import ZeromqMetadataSettings
from jfjoch_client.models.zeromq_preview_settings import ZeromqPreviewSettings
from typing import Optional, Set
from typing_extensions import Self

class JfjochStatistics(BaseModel):
    """
    Pool statistics for Jungfraujoch to reduce transfers between frontend and jfjoch_broker
    """ # noqa: E501
    detector: Optional[DetectorStatus] = None
    detector_list: Optional[DetectorList] = None
    detector_settings: Optional[DetectorSettings] = None
    image_format_settings: Optional[ImageFormatSettings] = None
    instrument_metadata: Optional[InstrumentMetadata] = None
    file_writer_settings: Optional[FileWriterSettings] = None
    data_processing_settings: Optional[SpotFindingSettings] = None
    measurement: Optional[MeasurementStatistics] = None
    broker: Optional[BrokerStatus] = None
    fpga: Optional[List[FpgaStatusInner]] = None
    calibration: Optional[List[CalibrationStatisticsInner]] = None
    zeromq_preview: Optional[ZeromqPreviewSettings] = None
    zeromq_metadata: Optional[ZeromqMetadataSettings] = None
    pixel_mask: Optional[PixelMaskStatistics] = None
    roi: Optional[RoiDefinitions] = None
    az_int: Optional[AzimIntSettings] = None
    buffer: Optional[ImageBufferStatus] = None
    indexing: Optional[IndexingSettings] = None
    __properties: ClassVar[List[str]] = ["detector", "detector_list", "detector_settings", "image_format_settings", "instrument_metadata", "file_writer_settings", "data_processing_settings", "measurement", "broker", "fpga", "calibration", "zeromq_preview", "zeromq_metadata", "pixel_mask", "roi", "az_int", "buffer", "indexing"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JfjochStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of detector
        if self.detector:
            _dict['detector'] = self.detector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of detector_list
        if self.detector_list:
            _dict['detector_list'] = self.detector_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of detector_settings
        if self.detector_settings:
            _dict['detector_settings'] = self.detector_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of image_format_settings
        if self.image_format_settings:
            _dict['image_format_settings'] = self.image_format_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instrument_metadata
        if self.instrument_metadata:
            _dict['instrument_metadata'] = self.instrument_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_writer_settings
        if self.file_writer_settings:
            _dict['file_writer_settings'] = self.file_writer_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_processing_settings
        if self.data_processing_settings:
            _dict['data_processing_settings'] = self.data_processing_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of measurement
        if self.measurement:
            _dict['measurement'] = self.measurement.to_dict()
        # override the default output from pydantic by calling `to_dict()` of broker
        if self.broker:
            _dict['broker'] = self.broker.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in fpga (list)
        _items = []
        if self.fpga:
            for _item_fpga in self.fpga:
                if _item_fpga:
                    _items.append(_item_fpga.to_dict())
            _dict['fpga'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in calibration (list)
        _items = []
        if self.calibration:
            for _item_calibration in self.calibration:
                if _item_calibration:
                    _items.append(_item_calibration.to_dict())
            _dict['calibration'] = _items
        # override the default output from pydantic by calling `to_dict()` of zeromq_preview
        if self.zeromq_preview:
            _dict['zeromq_preview'] = self.zeromq_preview.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zeromq_metadata
        if self.zeromq_metadata:
            _dict['zeromq_metadata'] = self.zeromq_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pixel_mask
        if self.pixel_mask:
            _dict['pixel_mask'] = self.pixel_mask.to_dict()
        # override the default output from pydantic by calling `to_dict()` of roi
        if self.roi:
            _dict['roi'] = self.roi.to_dict()
        # override the default output from pydantic by calling `to_dict()` of az_int
        if self.az_int:
            _dict['az_int'] = self.az_int.to_dict()
        # override the default output from pydantic by calling `to_dict()` of buffer
        if self.buffer:
            _dict['buffer'] = self.buffer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of indexing
        if self.indexing:
            _dict['indexing'] = self.indexing.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JfjochStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "detector": DetectorStatus.from_dict(obj["detector"]) if obj.get("detector") is not None else None,
            "detector_list": DetectorList.from_dict(obj["detector_list"]) if obj.get("detector_list") is not None else None,
            "detector_settings": DetectorSettings.from_dict(obj["detector_settings"]) if obj.get("detector_settings") is not None else None,
            "image_format_settings": ImageFormatSettings.from_dict(obj["image_format_settings"]) if obj.get("image_format_settings") is not None else None,
            "instrument_metadata": InstrumentMetadata.from_dict(obj["instrument_metadata"]) if obj.get("instrument_metadata") is not None else None,
            "file_writer_settings": FileWriterSettings.from_dict(obj["file_writer_settings"]) if obj.get("file_writer_settings") is not None else None,
            "data_processing_settings": SpotFindingSettings.from_dict(obj["data_processing_settings"]) if obj.get("data_processing_settings") is not None else None,
            "measurement": MeasurementStatistics.from_dict(obj["measurement"]) if obj.get("measurement") is not None else None,
            "broker": BrokerStatus.from_dict(obj["broker"]) if obj.get("broker") is not None else None,
            "fpga": [FpgaStatusInner.from_dict(_item) for _item in obj["fpga"]] if obj.get("fpga") is not None else None,
            "calibration": [CalibrationStatisticsInner.from_dict(_item) for _item in obj["calibration"]] if obj.get("calibration") is not None else None,
            "zeromq_preview": ZeromqPreviewSettings.from_dict(obj["zeromq_preview"]) if obj.get("zeromq_preview") is not None else None,
            "zeromq_metadata": ZeromqMetadataSettings.from_dict(obj["zeromq_metadata"]) if obj.get("zeromq_metadata") is not None else None,
            "pixel_mask": PixelMaskStatistics.from_dict(obj["pixel_mask"]) if obj.get("pixel_mask") is not None else None,
            "roi": RoiDefinitions.from_dict(obj["roi"]) if obj.get("roi") is not None else None,
            "az_int": AzimIntSettings.from_dict(obj["az_int"]) if obj.get("az_int") is not None else None,
            "buffer": ImageBufferStatus.from_dict(obj["buffer"]) if obj.get("buffer") is not None else None,
            "indexing": IndexingSettings.from_dict(obj["indexing"]) if obj.get("indexing") is not None else None
        })
        return _obj


