# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates. 

    The version of the OpenAPI document: 1.0.0-rc.61
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class SpotFindingSettings(BaseModel):
    """
    SpotFindingSettings
    """ # noqa: E501
    enable: StrictBool = Field(description="Enable spot finding. This is temporary setting, i.e. can be changed anytime during data collection.  Even if disabled spot finding information will still be send and written, though always with zero spots. ")
    indexing: StrictBool = Field(description="Enable indexing. This is temporary setting, i.e. can be changed anytime during data collection. ")
    signal_to_noise_threshold: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]
    photon_count_threshold: Annotated[int, Field(strict=True, ge=0)]
    min_pix_per_spot: Annotated[int, Field(strict=True, ge=1)]
    max_pix_per_spot: Annotated[int, Field(strict=True, ge=1)]
    high_resolution_limit: Union[StrictFloat, StrictInt] = Field(description="High resolution limit for spot finding [Angstrom]")
    low_resolution_limit: Union[StrictFloat, StrictInt] = Field(description="Low resolution limit for spot finding [Angstrom]")
    high_resolution_limit_for_spot_count_low_res: Union[Annotated[float, Field(le=8.0, strict=True, ge=2.0)], Annotated[int, Field(le=8, strict=True, ge=2)]] = Field(description="High resolution threshold to consider spot \"low resolution\" [Angstrom]")
    resolution_estimate: Optional[StrictBool] = Field(default=True, description="Diffraction image resolution estimation using ML model from SSRL; `jfjoch_broker` must be compiled with libtorch support and path to .pt file configured in `jfjoch_broker` configuration file. If enabled it will likely reduce performance of Jungfraujoch to below 100 Hz. (experimental feature) ")
    quick_integration: StrictBool = Field(description="Quick integration of Bragg spots in diffraction images. If enabled it will likely reduce performance of Jungfraujoch for datasets with a very high indexing rate. (experimental feature) ")
    __properties: ClassVar[List[str]] = ["enable", "indexing", "signal_to_noise_threshold", "photon_count_threshold", "min_pix_per_spot", "max_pix_per_spot", "high_resolution_limit", "low_resolution_limit", "high_resolution_limit_for_spot_count_low_res", "resolution_estimate", "quick_integration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpotFindingSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpotFindingSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enable": obj.get("enable") if obj.get("enable") is not None else True,
            "indexing": obj.get("indexing") if obj.get("indexing") is not None else True,
            "signal_to_noise_threshold": obj.get("signal_to_noise_threshold"),
            "photon_count_threshold": obj.get("photon_count_threshold"),
            "min_pix_per_spot": obj.get("min_pix_per_spot"),
            "max_pix_per_spot": obj.get("max_pix_per_spot"),
            "high_resolution_limit": obj.get("high_resolution_limit"),
            "low_resolution_limit": obj.get("low_resolution_limit"),
            "high_resolution_limit_for_spot_count_low_res": obj.get("high_resolution_limit_for_spot_count_low_res"),
            "resolution_estimate": obj.get("resolution_estimate") if obj.get("resolution_estimate") is not None else True,
            "quick_integration": obj.get("quick_integration") if obj.get("quick_integration") is not None else False
        })
        return _obj


