"""Class for base embedder."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../src/models/embedding/base_embedder.ipynb.

# %% auto 0
__all__ = ['BaseEmbedder']

# %% ../../../src/models/embedding/base_embedder.ipynb 2
from ...imports import *
from ..config_model import ConfigModel

# %% ../../../src/models/embedding/base_embedder.ipynb 4
class BaseEmbedder(ConfigModel, abc.ABC):
    def __init__(self) -> None: 
        super().__init__()  

        # Note: While using DDP with huggingface-Accelerate we noticed
        # the fixed weights didn't get synced if there is no parameter
        # that requires a gradient. So we add a dummy to make sure
        # all model instances/nodes have the same embedder!
        self.dummy_parameter = torch.tensor(0.0)
        self.dummy_parameter = nn.Parameter(self.dummy_parameter)

    def forward(self, *args, **kwargs): 
        return self.embed(*args, **kwargs)
    
    @abc.abstractmethod
    def embed(self, x): pass
        
    @abc.abstractmethod
    def invert(self, x): pass
