"""Special extension to `DiffusionPipeline`."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../src/pipeline/compilation_diffusion_pipeline.ipynb.

# %% auto 0
__all__ = ['DiffusionPipeline_Compilation']

# %% ../../src/pipeline/compilation_diffusion_pipeline.ipynb 2
from ..imports import *
from .diffusion_pipeline import DiffusionPipeline

# %% ../../src/pipeline/compilation_diffusion_pipeline.ipynb 4
class DiffusionPipeline_Compilation(DiffusionPipeline):   
    """A special `DiffusionPipeline` that accounts for unitary conditions, i.e. compilation."""
    
    #------------------------------------
    
    @torch.no_grad()
    def __call__(self, latents, c, U, g, negative_c=None, negative_u=None, no_bar=False):
        
        latents = latents.to(self.device)
        c       = c.to(self.device)
        U       = U.to(self.device)
        
        return self.denoising(latents, c=c, U=U, negative_c=negative_c, negative_u=negative_u, enable_guidance=True, g=g, no_bar=no_bar)

    #------------------------------------

    def empty_unitary_fn(self, U):
        # U ... [b , 2, n, n]
     
        u = torch.zeros_like(U)
        return u
    
    def get_guidance_U(self, U: torch.Tensor, enable_guidance: bool = True, negative_u: Optional[torch.Tensor] = None):
        if not exists(U): return U      
        U = U.to(self.device)                
        if enable_guidance:             
            if exists(negative_u): u = negative_u.to(self.device)
            else:                  u = self.empty_unitary_fn(U).to(self.device)  
            U = torch.cat([u, U])            
        return U
    
    @torch.no_grad()
    def denoising(self, latents, c, U, negative_c=None, negative_u=None, enable_guidance=True, g=1.0, t_start_index=0, no_bar=False, return_predicted_x0=False):       
        U = self.get_guidance_U(U, enable_guidance, negative_u)  
        return super().denoising(latents, c, negative_c, enable_guidance, g, t_start_index=t_start_index, 
                                 no_bar=no_bar, return_predicted_x0=return_predicted_x0, U=U)

    def denoising_step(self, latents: torch.Tensor, ts: Union[int, torch.IntTensor], c_emb: torch.Tensor=None, enable_guidance=False, g=7.5, U: torch.Tensor=None):    
        if enable_guidance:
            x = torch.cat([latents] * 2)     #uses batch layer combine here
            
            if ts.numel() > 1: chunk_ts = torch.cat([ts] * 2)
            else:              chunk_ts = ts
                
            eps_u, eps_c = self.model(x, chunk_ts, c_emb, U=U).chunk(2) 
            
            eps = self.CFG(eps_u, eps_c, g)
                    
        else:
            eps = self.model(latents, ts, c_emb, U=U)  
                 
        x = self.scheduler.step(eps, ts, latents)      
        return x.prev_sample, x.pred_original_sample
    
    #------------------------------------
  
    def train_step(self, data, train, **kwargs): 
        latents, y, U = data                
        b, s, t = latents.shape          
        
        #start async memcpy
        latents = latents.to(self.device, non_blocking=self.non_blocking)  
        latents = self.embedder.embed(latents)  
         
        #do the cond embedding with CLIP                     
        y = y.to(self.device, non_blocking=self.non_blocking)  
        U = U.to(self.device, non_blocking=self.non_blocking)  
        
        if self.enable_guidance_train and train: 
            rnd_y, rnd_U = torch.empty((2*b,), device=self.device).bernoulli_(p=1.0-self.guidance_train_p).type(torch.int64).chunk(2, dim=0)

            y = self.cfg_drop(y, self.empty_token_fn(y)  , rnd_y) 
            U = self.cfg_drop(U, self.empty_unitary_fn(U), rnd_U) 

        
        y_emb = self.text_encoder(y, pool=False)
              
        #sample timesteps
        timesteps = torch.randint(low=0, high=self.scheduler.num_train_timesteps, size=(b,), device=self.device, dtype=torch.int64)

        #forward noising    
        noise = torch.randn(latents.shape, device=self.device)     
        noisy_latents = self.scheduler.add_noise(latents, noise, timesteps, train=train)

        #predict eps
        eps = self.model(noisy_latents, timesteps, y_emb, U=U)
            
        #comp mse
        loss = self.loss_fn(eps, noise)
        
        #log the loss
        return loss
