"""Base class of corresponding backends."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../src/platform/backends/base_backend.ipynb.

# %% auto 0
__all__ = ['BaseBackend']

# %% ../../../src/platform/backends/base_backend.ipynb 2
from ...imports import *

# %% ../../../src/platform/backends/base_backend.ipynb 3
class BaseBackend(abc.ABC):
    """Backends implement at least these functions."""

    BASIC_BACKEND_TYPE = type[Any]
    
    @abc.abstractmethod
    def backend_to_genqc(self, *args, **kwargs):
        raise NotImplementedError()

    @abc.abstractmethod
    def genqc_to_backend(self, *args, **kwargs):
        raise NotImplementedError()

    @abc.abstractmethod
    def get_unitary(self, *args, **kwargs):
        raise NotImplementedError()

    @abc.abstractmethod
    def draw(self, *args, **kwargs) -> None:
        raise NotImplementedError()
