"""Classes for quantum circuit instructions."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../src/platform/circuits_instructions.ipynb.

# %% auto 0
__all__ = ['CircuitInstruction', 'CircuitInstructions']

# %% ../../src/platform/circuits_instructions.ipynb 2
from ..imports import *

# %% ../../src/platform/circuits_instructions.ipynb 4
@dataclass
class CircuitInstruction():
    """Basic quantum circuit instruction."""
    name: str
    control_nodes: Sequence[int]
    target_nodes: Sequence[int]
    params: Sequence[float]

# %% ../../src/platform/circuits_instructions.ipynb 5
class CircuitInstructions():
    """Basic quantum circuit instruction handler."""
    
    def __init__(self, tensor_shape: torch.Size) -> None:
        assert len(tensor_shape) == 2   # ... [qubits, time]
        self.tensor_shape  = tensor_shape     
        self._instructions = []
        self.instruction_names_set = set()
    
    def add_instruction(self,  
                        name: str, 
                        control_nodes: Sequence[int], 
                        target_nodes: Sequence[int], 
                        params: Sequence[float]) -> None:
        self.instruction_names_set.add(name)
        self._instructions.append(CircuitInstruction(name, control_nodes, target_nodes, params))

    @property
    def data(self) -> List[CircuitInstruction]: return self._instructions

    @property
    def length(self) -> int: return len(self._instructions)

    @property
    def num_qubits(self) -> int: return self.tensor_shape[0]

    @property
    def max_gates(self) -> int: return self.tensor_shape[1]
    
    def __repr__(self) -> str: return str(self._instructions)

    def print(self) -> None:
        for instruction in self.data: 
            print(instruction)        
