"""Class to load and run corresponding backends."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../src/platform/simulation.ipynb.

# %% auto 0
__all__ = ['GenericBackendType', 'CircuitBackendType', 'TensorEncodingType', 'is_circuit_type', 'Simulator']

# %% ../../src/platform/simulation.ipynb 2
from ..imports import *
from .backends.base_backend import BaseBackend

# %% ../../src/platform/simulation.ipynb 4
class CircuitBackendType(enum.Enum): 
    QISKIT    = enum.auto()
    CUDAQ     = enum.auto() 
    PENNYLANE = enum.auto() 

GenericBackendType = Union[CircuitBackendType]

# %% ../../src/platform/simulation.ipynb 5
class TensorEncodingType(enum.Enum): 
    CIRCUIT = enum.auto()

def is_circuit_type(backend_type): return backend_type in CircuitBackendType

# %% ../../src/platform/simulation.ipynb 7
class Simulator():
    """Basic class for handling backend types."""
    
    def __init__(self, backend: GenericBackendType, *args, **kwargs) -> BaseBackend:  
        match backend:        
            case CircuitBackendType.QISKIT:  
                from genQC.platform.backends.circuits_qiskit import CircuitsQiskitBackend    
                backend = CircuitsQiskitBackend(*args, **kwargs)
    
            case CircuitBackendType.CUDAQ:
                from genQC.platform.backends.circuits_cudaq import CircuitsCudaqBackend    
                backend = CircuitsCudaqBackend(*args, **kwargs)

            case CircuitBackendType.PENNYLANE:
                from genQC.platform.backends.circuits_pennylane import CircuitsPennylaneBackend    
                backend = CircuitsPennylaneBackend(*args, **kwargs)

            case _:
                raise NotImplementedError(f"Not implemented given backend: {backend}")
                
        self.backend = backend

    
    def backend_to_genqc(self, *args, **kwargs):
        return self.backend.backend_to_genqc(*args, **kwargs)

    
    def genqc_to_backend(self, *args, **kwargs):
        return self.backend.genqc_to_backend(*args, **kwargs)
