"""Base class of corresponding tokenizers."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../src/platform/tokenizer/base_tokenizer.ipynb.

# %% auto 0
__all__ = ['Vocabulary', 'VocabularyInverse', 'invert_vocabulary', 'BaseTokenizer']

# %% ../../../src/platform/tokenizer/base_tokenizer.ipynb 2
from ...imports import *

# %% ../../../src/platform/tokenizer/base_tokenizer.ipynb 3
Vocabulary        = dict[str, int] | dict[Any, int]
VocabularyInverse = dict[int, str] | dict[int, Any]

def invert_vocabulary(vocabulary: Vocabulary) -> VocabularyInverse:
    vocabulary_inverse = {token:gate for gate, token in vocabulary.items()}
    return vocabulary_inverse  

# %% ../../../src/platform/tokenizer/base_tokenizer.ipynb 4
class BaseTokenizer(abc.ABC):

    def __init__(self, vocabulary: Vocabulary) -> None:
        self.vocabulary         = vocabulary
        self.vocabulary_inverse = invert_vocabulary(vocabulary)

    @abc.abstractmethod
    def tokenize(self, *args, **kwargs):
        raise NotImplementedError()

    @abc.abstractmethod
    def encode(self, *args, **kwargs):
        raise NotImplementedError()

    @abc.abstractmethod
    def decode(self, *args, **kwargs):
        raise NotImplementedError()
