# SPDX-FileCopyrightText: 2025 Florent Rougon
# SPDX-License-Identifier: GPL-2.0-or-later
# SPDX-FileComment: Initialization of the 'flightgear.meta' package

"""Development tools for the FlightGear flight simulator.

This package contains code used to maintain infrastructure and various
things needed for developing FlightGear.

Modules and subpackages:

  aircraft_catalogs -- maintain aircraft catalogs on the mirrors
  exceptions        -- base class for custom exceptions
  i18n              -- support code for FlightGear internationalization
  logging           -- simple logging infrastructure
  misc              -- miscellaneous classes and/or functions
  scripts           -- main body of scripts, not really “API”
  sgprops           -- read and write FlightGear PropertyList files
  strutils          -- convenient string helpers
"""

__version__ = "1.0.0"
