<div align="center">
<a href="https://github.com/aboys-cb/NepTrainKit">
  <img src="./src/NepTrainKit/src/images/logo.svg" width="25%" alt="NepTrainKit Logo">
</a><br>    
<a href="https://pypi.org/project/NepTrainKit"><img src="https://img.shields.io/pypi/dm/NepTrainKit?logo=pypi&logoColor=white&color=blue&label=PyPI" alt="PyPI Downloads"></a>   
<a href="https://python.org/downloads"><img src="https://img.shields.io/badge/Python-3.10+-blue.svg?logo=python&logoColor=white" alt="Python Version"></a>  
<a href="https://codecov.io/github/aboys-cb/NepTrainKit"><img src="https://codecov.io/github/aboys-cb/NepTrainKit/graph/badge.svg?token=HQ5FMLD91F" alt="Codecov"></a>  
<a href="https://doi.org/10.48550/arXiv.2506.01868"><img src="https://img.shields.io/badge/arXiv-2506.01868-b31b1b.svg" alt="arXiv"></a>
<a href="https://github.com/aboys-cb/NepTrainKit/blob/master/LICENSE"><img src="https://img.shields.io/badge/license-GPL--3.0-blue" alt="License"></a>
</div>


---

# NepTrainKit

**NepTrainKit** is a toolkit focused on the operation and visualization of **neuroevolution potential** (NEP) training datasets. It is mainly used to simplify and optimize the NEP model training process, providing an intuitive graphical interface and analysis tools to help users adjust  train dataset.

---

## Community Support

- Join the community chat: [https://qm.qq.com/q/wPDQYHMhyg](https://qm.qq.com/q/wPDQYHMhyg)
- Report issues or contribute via [GitHub Issues](https://github.com/aboys-cb/NepTrainKit/issues)

---

## Installation

> **It is strongly recommended to use pip for installation.**

### Method 1: Install via pip

If you are using Python 3.10 or a later version, you can install `NepTrainKit` using an environment manager like `conda`:

1. Create a new environment:

   ```bash
   conda create -n nepkit python=3.10
   ```

2. Activate the environment:

   ```bash
   conda activate nepkit
   ```

3. For CentOS users, install PySide6 (required for GUI functionality):

   ```bash
   conda install -c conda-forge pyside6
   ```

- Install directly using the `pip install` command:

  ```bash
  pip install NepTrainKit
  ```

  After installation, you can call the program using either `NepTrainKit` or `nepkit`.

- For the **latest version** (from GitHub):

  ```bash
  pip install git+https://github.com/aboys-cb/NepTrainKit.git
  ```

---

### Method 2: Windows Executable

A standalone executable is available for Windows users.

- Visit the [Releases](https://github.com/aboys-cb/NepTrainKit/releases) page
- Download `NepTrainKit.win32.zip`

> Note: Only supported on Windows platforms.

---

## Documentation

For detailed usage documentation and examples, please refer to the official documentation:  
[https://neptrainkit.readthedocs.io/en/latest/index.html](https://neptrainkit.readthedocs.io/en/latest/index.html)

---