# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecurePasswordStoreArgs', 'SecurePasswordStore']

@pulumi.input_type
class SecurePasswordStoreArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 password_field: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 username_field: pulumi.Input[_builtins.str],
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field1: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field1_value: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field2: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field2_value: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field3: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field3_value: Optional[pulumi.Input[_builtins.str]] = None,
                 reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_password: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_username: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecurePasswordStore resource.
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] password_field: Login password field
        :param pulumi.Input[_builtins.str] url: Login URL
        :param pulumi.Input[_builtins.str] username_field: Login username field
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] credentials_scheme: Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] optional_field1: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field1_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] optional_field2: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field2_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] optional_field3: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field3_value: Name of optional value in login form
        :param pulumi.Input[_builtins.bool] reveal_password: Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        :param pulumi.Input[_builtins.str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[_builtins.str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] user_name_template: Username template. Default: `${source.login}`
        :param pulumi.Input[_builtins.str] user_name_template_push_status: Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        :param pulumi.Input[_builtins.str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[_builtins.str] user_name_template_type: Username template type. Default: `BUILT_IN`
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "password_field", password_field)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username_field", username_field)
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if credentials_scheme is not None:
            pulumi.set(__self__, "credentials_scheme", credentials_scheme)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if optional_field1 is not None:
            pulumi.set(__self__, "optional_field1", optional_field1)
        if optional_field1_value is not None:
            pulumi.set(__self__, "optional_field1_value", optional_field1_value)
        if optional_field2 is not None:
            pulumi.set(__self__, "optional_field2", optional_field2)
        if optional_field2_value is not None:
            pulumi.set(__self__, "optional_field2_value", optional_field2_value)
        if optional_field3 is not None:
            pulumi.set(__self__, "optional_field3", optional_field3)
        if optional_field3_value is not None:
            pulumi.set(__self__, "optional_field3_value", optional_field3_value)
        if reveal_password is not None:
            pulumi.set(__self__, "reveal_password", reveal_password)
        if shared_password is not None:
            pulumi.set(__self__, "shared_password", shared_password)
        if shared_username is not None:
            pulumi.set(__self__, "shared_username", shared_username)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="passwordField")
    def password_field(self) -> pulumi.Input[_builtins.str]:
        """
        Login password field
        """
        return pulumi.get(self, "password_field")

    @password_field.setter
    def password_field(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password_field", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="usernameField")
    def username_field(self) -> pulumi.Input[_builtins.str]:
        """
        Login username field
        """
        return pulumi.get(self, "username_field")

    @username_field.setter
    def username_field(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username_field", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_note", value)

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_links_json", value)

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @_builtins.property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        """
        return pulumi.get(self, "credentials_scheme")

    @credentials_scheme.setter
    def credentials_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_scheme", value)

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enduser_note", value)

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_ios", value)

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_web", value)

    @_builtins.property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo", value)

    @_builtins.property
    @pulumi.getter(name="optionalField1")
    def optional_field1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field1")

    @optional_field1.setter
    def optional_field1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field1", value)

    @_builtins.property
    @pulumi.getter(name="optionalField1Value")
    def optional_field1_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field1_value")

    @optional_field1_value.setter
    def optional_field1_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field1_value", value)

    @_builtins.property
    @pulumi.getter(name="optionalField2")
    def optional_field2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field2")

    @optional_field2.setter
    def optional_field2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field2", value)

    @_builtins.property
    @pulumi.getter(name="optionalField2Value")
    def optional_field2_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field2_value")

    @optional_field2_value.setter
    def optional_field2_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field2_value", value)

    @_builtins.property
    @pulumi.getter(name="optionalField3")
    def optional_field3(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field3")

    @optional_field3.setter
    def optional_field3(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field3", value)

    @_builtins.property
    @pulumi.getter(name="optionalField3Value")
    def optional_field3_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field3_value")

    @optional_field3_value.setter
    def optional_field3_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field3_value", value)

    @_builtins.property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        """
        return pulumi.get(self, "reveal_password")

    @reveal_password.setter
    def reveal_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reveal_password", value)

    @_builtins.property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @shared_password.setter
    def shared_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_password", value)

    @_builtins.property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @shared_username.setter
    def shared_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_username", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template. Default: `${source.login}`
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template type. Default: `BUILT_IN`
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_type", value)


@pulumi.input_type
class _SecurePasswordStoreState:
    def __init__(__self__, *,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 logo_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field1: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field1_value: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field2: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field2_value: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field3: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field3_value: Optional[pulumi.Input[_builtins.str]] = None,
                 password_field: Optional[pulumi.Input[_builtins.str]] = None,
                 reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_password: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_username: Optional[pulumi.Input[_builtins.str]] = None,
                 sign_on_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_field: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurePasswordStore resources.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] credentials_scheme: Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] logo_url: URL of the application's logo
        :param pulumi.Input[_builtins.str] name: Name of the app.
        :param pulumi.Input[_builtins.str] optional_field1: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field1_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] optional_field2: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field2_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] optional_field3: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field3_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] password_field: Login password field
        :param pulumi.Input[_builtins.bool] reveal_password: Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        :param pulumi.Input[_builtins.str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[_builtins.str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[_builtins.str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: Login URL
        :param pulumi.Input[_builtins.str] user_name_template: Username template. Default: `${source.login}`
        :param pulumi.Input[_builtins.str] user_name_template_push_status: Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        :param pulumi.Input[_builtins.str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[_builtins.str] user_name_template_type: Username template type. Default: `BUILT_IN`
        :param pulumi.Input[_builtins.str] username_field: Login username field
        """
        if accessibility_error_redirect_url is not None:
            pulumi.set(__self__, "accessibility_error_redirect_url", accessibility_error_redirect_url)
        if accessibility_login_redirect_url is not None:
            pulumi.set(__self__, "accessibility_login_redirect_url", accessibility_login_redirect_url)
        if accessibility_self_service is not None:
            pulumi.set(__self__, "accessibility_self_service", accessibility_self_service)
        if admin_note is not None:
            pulumi.set(__self__, "admin_note", admin_note)
        if app_links_json is not None:
            pulumi.set(__self__, "app_links_json", app_links_json)
        if auto_submit_toolbar is not None:
            pulumi.set(__self__, "auto_submit_toolbar", auto_submit_toolbar)
        if credentials_scheme is not None:
            pulumi.set(__self__, "credentials_scheme", credentials_scheme)
        if enduser_note is not None:
            pulumi.set(__self__, "enduser_note", enduser_note)
        if hide_ios is not None:
            pulumi.set(__self__, "hide_ios", hide_ios)
        if hide_web is not None:
            pulumi.set(__self__, "hide_web", hide_web)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional_field1 is not None:
            pulumi.set(__self__, "optional_field1", optional_field1)
        if optional_field1_value is not None:
            pulumi.set(__self__, "optional_field1_value", optional_field1_value)
        if optional_field2 is not None:
            pulumi.set(__self__, "optional_field2", optional_field2)
        if optional_field2_value is not None:
            pulumi.set(__self__, "optional_field2_value", optional_field2_value)
        if optional_field3 is not None:
            pulumi.set(__self__, "optional_field3", optional_field3)
        if optional_field3_value is not None:
            pulumi.set(__self__, "optional_field3_value", optional_field3_value)
        if password_field is not None:
            pulumi.set(__self__, "password_field", password_field)
        if reveal_password is not None:
            pulumi.set(__self__, "reveal_password", reveal_password)
        if shared_password is not None:
            pulumi.set(__self__, "shared_password", shared_password)
        if shared_username is not None:
            pulumi.set(__self__, "shared_username", shared_username)
        if sign_on_mode is not None:
            pulumi.set(__self__, "sign_on_mode", sign_on_mode)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_name_template is not None:
            pulumi.set(__self__, "user_name_template", user_name_template)
        if user_name_template_push_status is not None:
            pulumi.set(__self__, "user_name_template_push_status", user_name_template_push_status)
        if user_name_template_suffix is not None:
            pulumi.set(__self__, "user_name_template_suffix", user_name_template_suffix)
        if user_name_template_type is not None:
            pulumi.set(__self__, "user_name_template_type", user_name_template_type)
        if username_field is not None:
            pulumi.set(__self__, "username_field", username_field)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @accessibility_error_redirect_url.setter
    def accessibility_error_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_error_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @accessibility_login_redirect_url.setter
    def accessibility_login_redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accessibility_login_redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @accessibility_self_service.setter
    def accessibility_self_service(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accessibility_self_service", value)

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @admin_note.setter
    def admin_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_note", value)

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @app_links_json.setter
    def app_links_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_links_json", value)

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @auto_submit_toolbar.setter
    def auto_submit_toolbar(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_submit_toolbar", value)

    @_builtins.property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        """
        return pulumi.get(self, "credentials_scheme")

    @credentials_scheme.setter
    def credentials_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_scheme", value)

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @enduser_note.setter
    def enduser_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enduser_note", value)

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @hide_ios.setter
    def hide_ios(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_ios", value)

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @hide_web.setter
    def hide_web(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_web", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo", value)

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logo_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optionalField1")
    def optional_field1(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field1")

    @optional_field1.setter
    def optional_field1(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field1", value)

    @_builtins.property
    @pulumi.getter(name="optionalField1Value")
    def optional_field1_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field1_value")

    @optional_field1_value.setter
    def optional_field1_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field1_value", value)

    @_builtins.property
    @pulumi.getter(name="optionalField2")
    def optional_field2(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field2")

    @optional_field2.setter
    def optional_field2(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field2", value)

    @_builtins.property
    @pulumi.getter(name="optionalField2Value")
    def optional_field2_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field2_value")

    @optional_field2_value.setter
    def optional_field2_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field2_value", value)

    @_builtins.property
    @pulumi.getter(name="optionalField3")
    def optional_field3(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field3")

    @optional_field3.setter
    def optional_field3(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field3", value)

    @_builtins.property
    @pulumi.getter(name="optionalField3Value")
    def optional_field3_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field3_value")

    @optional_field3_value.setter
    def optional_field3_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "optional_field3_value", value)

    @_builtins.property
    @pulumi.getter(name="passwordField")
    def password_field(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login password field
        """
        return pulumi.get(self, "password_field")

    @password_field.setter
    def password_field(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_field", value)

    @_builtins.property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        """
        return pulumi.get(self, "reveal_password")

    @reveal_password.setter
    def reveal_password(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reveal_password", value)

    @_builtins.property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @shared_password.setter
    def shared_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_password", value)

    @_builtins.property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @shared_username.setter
    def shared_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_username", value)

    @_builtins.property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @sign_on_mode.setter
    def sign_on_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sign_on_mode", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template. Default: `${source.login}`
        """
        return pulumi.get(self, "user_name_template")

    @user_name_template.setter
    def user_name_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        """
        return pulumi.get(self, "user_name_template_push_status")

    @user_name_template_push_status.setter
    def user_name_template_push_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_push_status", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @user_name_template_suffix.setter
    def user_name_template_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_suffix", value)

    @_builtins.property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username template type. Default: `BUILT_IN`
        """
        return pulumi.get(self, "user_name_template_type")

    @user_name_template_type.setter
    def user_name_template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name_template_type", value)

    @_builtins.property
    @pulumi.getter(name="usernameField")
    def username_field(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Login username field
        """
        return pulumi.get(self, "username_field")

    @username_field.setter
    def username_field(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username_field", value)


@pulumi.type_token("okta:app/securePasswordStore:SecurePasswordStore")
class SecurePasswordStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field1: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field1_value: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field2: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field2_value: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field3: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field3_value: Optional[pulumi.Input[_builtins.str]] = None,
                 password_field: Optional[pulumi.Input[_builtins.str]] = None,
                 reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_password: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_username: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_field: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a Secure Password Store Application.

                This resource allows you to create and configure a Secure Password Store Application.
                > During an apply if there is change in 'status' the app will first be
                activated or deactivated in accordance with the 'status' change. Then, all
                other arguments that changed will be applied.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.app.SecurePasswordStore("example",
            label="example",
            username_field="user",
            password_field="pass",
            url="https://test.com",
            credentials_scheme="ADMIN_SETS_CREDENTIALS")
        ```

        ## Import

        ```sh
        $ pulumi import okta:app/securePasswordStore:SecurePasswordStore example <app_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] credentials_scheme: Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] optional_field1: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field1_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] optional_field2: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field2_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] optional_field3: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field3_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] password_field: Login password field
        :param pulumi.Input[_builtins.bool] reveal_password: Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        :param pulumi.Input[_builtins.str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[_builtins.str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: Login URL
        :param pulumi.Input[_builtins.str] user_name_template: Username template. Default: `${source.login}`
        :param pulumi.Input[_builtins.str] user_name_template_push_status: Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        :param pulumi.Input[_builtins.str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[_builtins.str] user_name_template_type: Username template type. Default: `BUILT_IN`
        :param pulumi.Input[_builtins.str] username_field: Login username field
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurePasswordStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Secure Password Store Application.

                This resource allows you to create and configure a Secure Password Store Application.
                > During an apply if there is change in 'status' the app will first be
                activated or deactivated in accordance with the 'status' change. Then, all
                other arguments that changed will be applied.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.app.SecurePasswordStore("example",
            label="example",
            username_field="user",
            password_field="pass",
            url="https://test.com",
            credentials_scheme="ADMIN_SETS_CREDENTIALS")
        ```

        ## Import

        ```sh
        $ pulumi import okta:app/securePasswordStore:SecurePasswordStore example <app_id>
        ```

        :param str resource_name: The name of the resource.
        :param SecurePasswordStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurePasswordStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
                 admin_note: Optional[pulumi.Input[_builtins.str]] = None,
                 app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
                 credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
                 hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 logo: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field1: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field1_value: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field2: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field2_value: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field3: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_field3_value: Optional[pulumi.Input[_builtins.str]] = None,
                 password_field: Optional[pulumi.Input[_builtins.str]] = None,
                 reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_password: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_username: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username_field: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurePasswordStoreArgs.__new__(SecurePasswordStoreArgs)

            __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
            __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
            __props__.__dict__["accessibility_self_service"] = accessibility_self_service
            __props__.__dict__["admin_note"] = admin_note
            __props__.__dict__["app_links_json"] = app_links_json
            __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
            __props__.__dict__["credentials_scheme"] = credentials_scheme
            __props__.__dict__["enduser_note"] = enduser_note
            __props__.__dict__["hide_ios"] = hide_ios
            __props__.__dict__["hide_web"] = hide_web
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["logo"] = logo
            __props__.__dict__["optional_field1"] = optional_field1
            __props__.__dict__["optional_field1_value"] = optional_field1_value
            __props__.__dict__["optional_field2"] = optional_field2
            __props__.__dict__["optional_field2_value"] = optional_field2_value
            __props__.__dict__["optional_field3"] = optional_field3
            __props__.__dict__["optional_field3_value"] = optional_field3_value
            if password_field is None and not opts.urn:
                raise TypeError("Missing required property 'password_field'")
            __props__.__dict__["password_field"] = password_field
            __props__.__dict__["reveal_password"] = reveal_password
            __props__.__dict__["shared_password"] = shared_password
            __props__.__dict__["shared_username"] = shared_username
            __props__.__dict__["status"] = status
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["user_name_template"] = user_name_template
            __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
            __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
            __props__.__dict__["user_name_template_type"] = user_name_template_type
            if username_field is None and not opts.urn:
                raise TypeError("Missing required property 'username_field'")
            __props__.__dict__["username_field"] = username_field
            __props__.__dict__["logo_url"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["sign_on_mode"] = None
        super(SecurePasswordStore, __self__).__init__(
            'okta:app/securePasswordStore:SecurePasswordStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessibility_error_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            accessibility_login_redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            accessibility_self_service: Optional[pulumi.Input[_builtins.bool]] = None,
            admin_note: Optional[pulumi.Input[_builtins.str]] = None,
            app_links_json: Optional[pulumi.Input[_builtins.str]] = None,
            auto_submit_toolbar: Optional[pulumi.Input[_builtins.bool]] = None,
            credentials_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            enduser_note: Optional[pulumi.Input[_builtins.str]] = None,
            hide_ios: Optional[pulumi.Input[_builtins.bool]] = None,
            hide_web: Optional[pulumi.Input[_builtins.bool]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            logo: Optional[pulumi.Input[_builtins.str]] = None,
            logo_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            optional_field1: Optional[pulumi.Input[_builtins.str]] = None,
            optional_field1_value: Optional[pulumi.Input[_builtins.str]] = None,
            optional_field2: Optional[pulumi.Input[_builtins.str]] = None,
            optional_field2_value: Optional[pulumi.Input[_builtins.str]] = None,
            optional_field3: Optional[pulumi.Input[_builtins.str]] = None,
            optional_field3_value: Optional[pulumi.Input[_builtins.str]] = None,
            password_field: Optional[pulumi.Input[_builtins.str]] = None,
            reveal_password: Optional[pulumi.Input[_builtins.bool]] = None,
            shared_password: Optional[pulumi.Input[_builtins.str]] = None,
            shared_username: Optional[pulumi.Input[_builtins.str]] = None,
            sign_on_mode: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_template: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_template_push_status: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_template_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            user_name_template_type: Optional[pulumi.Input[_builtins.str]] = None,
            username_field: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurePasswordStore':
        """
        Get an existing SecurePasswordStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accessibility_error_redirect_url: Custom error page URL
        :param pulumi.Input[_builtins.str] accessibility_login_redirect_url: Custom login page URL
        :param pulumi.Input[_builtins.bool] accessibility_self_service: Enable self service. Default is `false`
        :param pulumi.Input[_builtins.str] admin_note: Application notes for admins.
        :param pulumi.Input[_builtins.str] app_links_json: Displays specific appLinks for the app. The value for each application link should be boolean.
        :param pulumi.Input[_builtins.bool] auto_submit_toolbar: Display auto submit toolbar
        :param pulumi.Input[_builtins.str] credentials_scheme: Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        :param pulumi.Input[_builtins.str] enduser_note: Application notes for end users.
        :param pulumi.Input[_builtins.bool] hide_ios: Do not display application icon on mobile app
        :param pulumi.Input[_builtins.bool] hide_web: Do not display application icon to users
        :param pulumi.Input[_builtins.str] label: The Application's display name.
        :param pulumi.Input[_builtins.str] logo: Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        :param pulumi.Input[_builtins.str] logo_url: URL of the application's logo
        :param pulumi.Input[_builtins.str] name: Name of the app.
        :param pulumi.Input[_builtins.str] optional_field1: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field1_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] optional_field2: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field2_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] optional_field3: Name of optional param in the login form
        :param pulumi.Input[_builtins.str] optional_field3_value: Name of optional value in login form
        :param pulumi.Input[_builtins.str] password_field: Login password field
        :param pulumi.Input[_builtins.bool] reveal_password: Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        :param pulumi.Input[_builtins.str] shared_password: Shared password, required for certain schemes.
        :param pulumi.Input[_builtins.str] shared_username: Shared username, required for certain schemes.
        :param pulumi.Input[_builtins.str] sign_on_mode: Sign on mode of application.
        :param pulumi.Input[_builtins.str] status: Status of application. By default, it is `ACTIVE`
        :param pulumi.Input[_builtins.str] url: Login URL
        :param pulumi.Input[_builtins.str] user_name_template: Username template. Default: `${source.login}`
        :param pulumi.Input[_builtins.str] user_name_template_push_status: Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        :param pulumi.Input[_builtins.str] user_name_template_suffix: Username template suffix
        :param pulumi.Input[_builtins.str] user_name_template_type: Username template type. Default: `BUILT_IN`
        :param pulumi.Input[_builtins.str] username_field: Login username field
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurePasswordStoreState.__new__(_SecurePasswordStoreState)

        __props__.__dict__["accessibility_error_redirect_url"] = accessibility_error_redirect_url
        __props__.__dict__["accessibility_login_redirect_url"] = accessibility_login_redirect_url
        __props__.__dict__["accessibility_self_service"] = accessibility_self_service
        __props__.__dict__["admin_note"] = admin_note
        __props__.__dict__["app_links_json"] = app_links_json
        __props__.__dict__["auto_submit_toolbar"] = auto_submit_toolbar
        __props__.__dict__["credentials_scheme"] = credentials_scheme
        __props__.__dict__["enduser_note"] = enduser_note
        __props__.__dict__["hide_ios"] = hide_ios
        __props__.__dict__["hide_web"] = hide_web
        __props__.__dict__["label"] = label
        __props__.__dict__["logo"] = logo
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["name"] = name
        __props__.__dict__["optional_field1"] = optional_field1
        __props__.__dict__["optional_field1_value"] = optional_field1_value
        __props__.__dict__["optional_field2"] = optional_field2
        __props__.__dict__["optional_field2_value"] = optional_field2_value
        __props__.__dict__["optional_field3"] = optional_field3
        __props__.__dict__["optional_field3_value"] = optional_field3_value
        __props__.__dict__["password_field"] = password_field
        __props__.__dict__["reveal_password"] = reveal_password
        __props__.__dict__["shared_password"] = shared_password
        __props__.__dict__["shared_username"] = shared_username
        __props__.__dict__["sign_on_mode"] = sign_on_mode
        __props__.__dict__["status"] = status
        __props__.__dict__["url"] = url
        __props__.__dict__["user_name_template"] = user_name_template
        __props__.__dict__["user_name_template_push_status"] = user_name_template_push_status
        __props__.__dict__["user_name_template_suffix"] = user_name_template_suffix
        __props__.__dict__["user_name_template_type"] = user_name_template_type
        __props__.__dict__["username_field"] = username_field
        return SecurePasswordStore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessibilityErrorRedirectUrl")
    def accessibility_error_redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom error page URL
        """
        return pulumi.get(self, "accessibility_error_redirect_url")

    @_builtins.property
    @pulumi.getter(name="accessibilityLoginRedirectUrl")
    def accessibility_login_redirect_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom login page URL
        """
        return pulumi.get(self, "accessibility_login_redirect_url")

    @_builtins.property
    @pulumi.getter(name="accessibilitySelfService")
    def accessibility_self_service(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable self service. Default is `false`
        """
        return pulumi.get(self, "accessibility_self_service")

    @_builtins.property
    @pulumi.getter(name="adminNote")
    def admin_note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application notes for admins.
        """
        return pulumi.get(self, "admin_note")

    @_builtins.property
    @pulumi.getter(name="appLinksJson")
    def app_links_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Displays specific appLinks for the app. The value for each application link should be boolean.
        """
        return pulumi.get(self, "app_links_json")

    @_builtins.property
    @pulumi.getter(name="autoSubmitToolbar")
    def auto_submit_toolbar(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Display auto submit toolbar
        """
        return pulumi.get(self, "auto_submit_toolbar")

    @_builtins.property
    @pulumi.getter(name="credentialsScheme")
    def credentials_scheme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application credentials scheme. One of: `EDIT_USERNAME_AND_PASSWORD`, `ADMIN_SETS_CREDENTIALS`, `EDIT_PASSWORD_ONLY`, `EXTERNAL_PASSWORD_SYNC`, or `SHARED_USERNAME_AND_PASSWORD`
        """
        return pulumi.get(self, "credentials_scheme")

    @_builtins.property
    @pulumi.getter(name="enduserNote")
    def enduser_note(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Application notes for end users.
        """
        return pulumi.get(self, "enduser_note")

    @_builtins.property
    @pulumi.getter(name="hideIos")
    def hide_ios(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Do not display application icon on mobile app
        """
        return pulumi.get(self, "hide_ios")

    @_builtins.property
    @pulumi.getter(name="hideWeb")
    def hide_web(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Do not display application icon to users
        """
        return pulumi.get(self, "hide_web")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The Application's display name.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Local file path to the logo. The file must be in PNG, JPG, or GIF format, and less than 1 MB in size.
        """
        return pulumi.get(self, "logo")

    @_builtins.property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the application's logo
        """
        return pulumi.get(self, "logo_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the app.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="optionalField1")
    def optional_field1(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field1")

    @_builtins.property
    @pulumi.getter(name="optionalField1Value")
    def optional_field1_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field1_value")

    @_builtins.property
    @pulumi.getter(name="optionalField2")
    def optional_field2(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field2")

    @_builtins.property
    @pulumi.getter(name="optionalField2Value")
    def optional_field2_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field2_value")

    @_builtins.property
    @pulumi.getter(name="optionalField3")
    def optional_field3(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of optional param in the login form
        """
        return pulumi.get(self, "optional_field3")

    @_builtins.property
    @pulumi.getter(name="optionalField3Value")
    def optional_field3_value(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of optional value in login form
        """
        return pulumi.get(self, "optional_field3_value")

    @_builtins.property
    @pulumi.getter(name="passwordField")
    def password_field(self) -> pulumi.Output[_builtins.str]:
        """
        Login password field
        """
        return pulumi.get(self, "password_field")

    @_builtins.property
    @pulumi.getter(name="revealPassword")
    def reveal_password(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow user to reveal password. It can not be set to `true` if `credentials_scheme` is `ADMIN_SETS_CREDENTIALS`, `SHARED_USERNAME_AND_PASSWORD` or `EXTERNAL_PASSWORD_SYNC`.
        """
        return pulumi.get(self, "reveal_password")

    @_builtins.property
    @pulumi.getter(name="sharedPassword")
    def shared_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Shared password, required for certain schemes.
        """
        return pulumi.get(self, "shared_password")

    @_builtins.property
    @pulumi.getter(name="sharedUsername")
    def shared_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Shared username, required for certain schemes.
        """
        return pulumi.get(self, "shared_username")

    @_builtins.property
    @pulumi.getter(name="signOnMode")
    def sign_on_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Sign on mode of application.
        """
        return pulumi.get(self, "sign_on_mode")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Status of application. By default, it is `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        Login URL
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userNameTemplate")
    def user_name_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username template. Default: `${source.login}`
        """
        return pulumi.get(self, "user_name_template")

    @_builtins.property
    @pulumi.getter(name="userNameTemplatePushStatus")
    def user_name_template_push_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Push username on update. Valid values: `PUSH` and `DONT_PUSH`
        """
        return pulumi.get(self, "user_name_template_push_status")

    @_builtins.property
    @pulumi.getter(name="userNameTemplateSuffix")
    def user_name_template_suffix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username template suffix
        """
        return pulumi.get(self, "user_name_template_suffix")

    @_builtins.property
    @pulumi.getter(name="userNameTemplateType")
    def user_name_template_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Username template type. Default: `BUILT_IN`
        """
        return pulumi.get(self, "user_name_template_type")

    @_builtins.property
    @pulumi.getter(name="usernameField")
    def username_field(self) -> pulumi.Output[_builtins.str]:
        """
        Login username field
        """
        return pulumi.get(self, "username_field")

