# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppGroupAssignmentsArgs', 'AppGroupAssignments']

@pulumi.input_type
class AppGroupAssignmentsArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]] = None):
        """
        The set of arguments for constructing a AppGroupAssignments resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of the application to assign a group to.
        :param pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]] groups: A group to assign to this application
        """
        pulumi.set(__self__, "app_id", app_id)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the application to assign a group to.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]]:
        """
        A group to assign to this application
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]]):
        pulumi.set(self, "groups", value)


@pulumi.input_type
class _AppGroupAssignmentsState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]] = None):
        """
        Input properties used for looking up and filtering AppGroupAssignments resources.
        :param pulumi.Input[_builtins.str] app_id: The ID of the application to assign a group to.
        :param pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]] groups: A group to assign to this application
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the application to assign a group to.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]]:
        """
        A group to assign to this application
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppGroupAssignmentsGroupArgs']]]]):
        pulumi.set(self, "groups", value)


@pulumi.type_token("okta:index/appGroupAssignments:AppGroupAssignments")
class AppGroupAssignments(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAssignmentsGroupArgs', 'AppGroupAssignmentsGroupArgsDict']]]]] = None,
                 __props__=None):
        """
        Assigns groups to an application. This resource allows you to create multiple App Group assignments.

        **Important**: Do not use in conjunction with for_each

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        example = okta.AppGroupAssignments("example",
            app_id="<app id>",
            groups=[
                {
                    "id": "<group id>",
                    "priority": 1,
                },
                {
                    "id": "<another group id>",
                    "priority": 2,
                    "profile": json.dumps({
                        "application profile field": "application profile value",
                    }),
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/appGroupAssignments:AppGroupAssignments example <app_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of the application to assign a group to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAssignmentsGroupArgs', 'AppGroupAssignmentsGroupArgsDict']]]] groups: A group to assign to this application
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppGroupAssignmentsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Assigns groups to an application. This resource allows you to create multiple App Group assignments.

        **Important**: Do not use in conjunction with for_each

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        example = okta.AppGroupAssignments("example",
            app_id="<app id>",
            groups=[
                {
                    "id": "<group id>",
                    "priority": 1,
                },
                {
                    "id": "<another group id>",
                    "priority": 2,
                    "profile": json.dumps({
                        "application profile field": "application profile value",
                    }),
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/appGroupAssignments:AppGroupAssignments example <app_id>
        ```

        :param str resource_name: The name of the resource.
        :param AppGroupAssignmentsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppGroupAssignmentsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAssignmentsGroupArgs', 'AppGroupAssignmentsGroupArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppGroupAssignmentsArgs.__new__(AppGroupAssignmentsArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["groups"] = groups
        super(AppGroupAssignments, __self__).__init__(
            'okta:index/appGroupAssignments:AppGroupAssignments',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAssignmentsGroupArgs', 'AppGroupAssignmentsGroupArgsDict']]]]] = None) -> 'AppGroupAssignments':
        """
        Get an existing AppGroupAssignments resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of the application to assign a group to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppGroupAssignmentsGroupArgs', 'AppGroupAssignmentsGroupArgsDict']]]] groups: A group to assign to this application
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppGroupAssignmentsState.__new__(_AppGroupAssignmentsState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["groups"] = groups
        return AppGroupAssignments(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the application to assign a group to.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Optional[Sequence['outputs.AppGroupAssignmentsGroup']]]:
        """
        A group to assign to this application
        """
        return pulumi.get(self, "groups")

