# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['BehaviourArgs', 'Behaviour']

@pulumi.input_type
class BehaviourArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 location_granularity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_authentications: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_from_location: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 velocity: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Behaviour resource.
        :param pulumi.Input[_builtins.str] type: Type of the behavior. Can be set to `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE`, `ANOMALOUS_IP` or `VELOCITY`. Resource will be recreated when the type changes.e
        :param pulumi.Input[_builtins.str] location_granularity_type: Determines the method and level of detail used to evaluate the behavior. Required for `ANOMALOUS_LOCATION` behavior type. Can be set to `LAT_LONG`, `CITY`, `COUNTRY` or `SUBDIVISION`.
        :param pulumi.Input[_builtins.str] name: Name of the behavior
        :param pulumi.Input[_builtins.int] number_of_authentications: The number of recent authentications used to evaluate the behavior. Required for `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE` and `ANOMALOUS_IP` behavior types.
        :param pulumi.Input[_builtins.int] radius_from_location: Radius from location (in kilometers). Should be at least 5. Required when `location_granularity_type` is set to `LAT_LONG`.
        :param pulumi.Input[_builtins.str] status: Behavior status: ACTIVE or INACTIVE. Default: `ACTIVE`
        :param pulumi.Input[_builtins.int] velocity: Velocity (in kilometers per hour). Should be at least 1. Required for `VELOCITY` behavior
        """
        pulumi.set(__self__, "type", type)
        if location_granularity_type is not None:
            pulumi.set(__self__, "location_granularity_type", location_granularity_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_authentications is not None:
            pulumi.set(__self__, "number_of_authentications", number_of_authentications)
        if radius_from_location is not None:
            pulumi.set(__self__, "radius_from_location", radius_from_location)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if velocity is not None:
            pulumi.set(__self__, "velocity", velocity)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the behavior. Can be set to `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE`, `ANOMALOUS_IP` or `VELOCITY`. Resource will be recreated when the type changes.e
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="locationGranularityType")
    def location_granularity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the method and level of detail used to evaluate the behavior. Required for `ANOMALOUS_LOCATION` behavior type. Can be set to `LAT_LONG`, `CITY`, `COUNTRY` or `SUBDIVISION`.
        """
        return pulumi.get(self, "location_granularity_type")

    @location_granularity_type.setter
    def location_granularity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location_granularity_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the behavior
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfAuthentications")
    def number_of_authentications(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of recent authentications used to evaluate the behavior. Required for `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE` and `ANOMALOUS_IP` behavior types.
        """
        return pulumi.get(self, "number_of_authentications")

    @number_of_authentications.setter
    def number_of_authentications(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_authentications", value)

    @_builtins.property
    @pulumi.getter(name="radiusFromLocation")
    def radius_from_location(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Radius from location (in kilometers). Should be at least 5. Required when `location_granularity_type` is set to `LAT_LONG`.
        """
        return pulumi.get(self, "radius_from_location")

    @radius_from_location.setter
    def radius_from_location(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_from_location", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Behavior status: ACTIVE or INACTIVE. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def velocity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Velocity (in kilometers per hour). Should be at least 1. Required for `VELOCITY` behavior
        """
        return pulumi.get(self, "velocity")

    @velocity.setter
    def velocity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "velocity", value)


@pulumi.input_type
class _BehaviourState:
    def __init__(__self__, *,
                 location_granularity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_authentications: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_from_location: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 velocity: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Behaviour resources.
        :param pulumi.Input[_builtins.str] location_granularity_type: Determines the method and level of detail used to evaluate the behavior. Required for `ANOMALOUS_LOCATION` behavior type. Can be set to `LAT_LONG`, `CITY`, `COUNTRY` or `SUBDIVISION`.
        :param pulumi.Input[_builtins.str] name: Name of the behavior
        :param pulumi.Input[_builtins.int] number_of_authentications: The number of recent authentications used to evaluate the behavior. Required for `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE` and `ANOMALOUS_IP` behavior types.
        :param pulumi.Input[_builtins.int] radius_from_location: Radius from location (in kilometers). Should be at least 5. Required when `location_granularity_type` is set to `LAT_LONG`.
        :param pulumi.Input[_builtins.str] status: Behavior status: ACTIVE or INACTIVE. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] type: Type of the behavior. Can be set to `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE`, `ANOMALOUS_IP` or `VELOCITY`. Resource will be recreated when the type changes.e
        :param pulumi.Input[_builtins.int] velocity: Velocity (in kilometers per hour). Should be at least 1. Required for `VELOCITY` behavior
        """
        if location_granularity_type is not None:
            pulumi.set(__self__, "location_granularity_type", location_granularity_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_authentications is not None:
            pulumi.set(__self__, "number_of_authentications", number_of_authentications)
        if radius_from_location is not None:
            pulumi.set(__self__, "radius_from_location", radius_from_location)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if velocity is not None:
            pulumi.set(__self__, "velocity", velocity)

    @_builtins.property
    @pulumi.getter(name="locationGranularityType")
    def location_granularity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the method and level of detail used to evaluate the behavior. Required for `ANOMALOUS_LOCATION` behavior type. Can be set to `LAT_LONG`, `CITY`, `COUNTRY` or `SUBDIVISION`.
        """
        return pulumi.get(self, "location_granularity_type")

    @location_granularity_type.setter
    def location_granularity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location_granularity_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the behavior
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfAuthentications")
    def number_of_authentications(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of recent authentications used to evaluate the behavior. Required for `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE` and `ANOMALOUS_IP` behavior types.
        """
        return pulumi.get(self, "number_of_authentications")

    @number_of_authentications.setter
    def number_of_authentications(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_authentications", value)

    @_builtins.property
    @pulumi.getter(name="radiusFromLocation")
    def radius_from_location(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Radius from location (in kilometers). Should be at least 5. Required when `location_granularity_type` is set to `LAT_LONG`.
        """
        return pulumi.get(self, "radius_from_location")

    @radius_from_location.setter
    def radius_from_location(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_from_location", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Behavior status: ACTIVE or INACTIVE. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the behavior. Can be set to `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE`, `ANOMALOUS_IP` or `VELOCITY`. Resource will be recreated when the type changes.e
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def velocity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Velocity (in kilometers per hour). Should be at least 1. Required for `VELOCITY` behavior
        """
        return pulumi.get(self, "velocity")

    @velocity.setter
    def velocity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "velocity", value)


@pulumi.type_token("okta:index/behaviour:Behaviour")
class Behaviour(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location_granularity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_authentications: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_from_location: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 velocity: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource allows you to create and configure a behavior.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        my_location = okta.Behaviour("my_location",
            name="My Location",
            type="ANOMALOUS_LOCATION",
            number_of_authentications=50,
            location_granularity_type="LAT_LONG",
            radius_from_location=20)
        my_city = okta.Behaviour("my_city",
            name="My City",
            type="ANOMALOUS_LOCATION",
            number_of_authentications=50,
            location_granularity_type="CITY")
        my_device = okta.Behaviour("my_device",
            name="My Device",
            type="ANOMALOUS_DEVICE",
            number_of_authentications=50)
        my_ip = okta.Behaviour("my_ip",
            name="My IP",
            type="ANOMALOUS_IP",
            number_of_authentications=50)
        my_velocity = okta.Behaviour("my_velocity",
            name="My Velocity",
            type="VELOCITY",
            velocity=25)
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/behaviour:Behaviour example <behavior_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location_granularity_type: Determines the method and level of detail used to evaluate the behavior. Required for `ANOMALOUS_LOCATION` behavior type. Can be set to `LAT_LONG`, `CITY`, `COUNTRY` or `SUBDIVISION`.
        :param pulumi.Input[_builtins.str] name: Name of the behavior
        :param pulumi.Input[_builtins.int] number_of_authentications: The number of recent authentications used to evaluate the behavior. Required for `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE` and `ANOMALOUS_IP` behavior types.
        :param pulumi.Input[_builtins.int] radius_from_location: Radius from location (in kilometers). Should be at least 5. Required when `location_granularity_type` is set to `LAT_LONG`.
        :param pulumi.Input[_builtins.str] status: Behavior status: ACTIVE or INACTIVE. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] type: Type of the behavior. Can be set to `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE`, `ANOMALOUS_IP` or `VELOCITY`. Resource will be recreated when the type changes.e
        :param pulumi.Input[_builtins.int] velocity: Velocity (in kilometers per hour). Should be at least 1. Required for `VELOCITY` behavior
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BehaviourArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and configure a behavior.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        my_location = okta.Behaviour("my_location",
            name="My Location",
            type="ANOMALOUS_LOCATION",
            number_of_authentications=50,
            location_granularity_type="LAT_LONG",
            radius_from_location=20)
        my_city = okta.Behaviour("my_city",
            name="My City",
            type="ANOMALOUS_LOCATION",
            number_of_authentications=50,
            location_granularity_type="CITY")
        my_device = okta.Behaviour("my_device",
            name="My Device",
            type="ANOMALOUS_DEVICE",
            number_of_authentications=50)
        my_ip = okta.Behaviour("my_ip",
            name="My IP",
            type="ANOMALOUS_IP",
            number_of_authentications=50)
        my_velocity = okta.Behaviour("my_velocity",
            name="My Velocity",
            type="VELOCITY",
            velocity=25)
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/behaviour:Behaviour example <behavior_id>
        ```

        :param str resource_name: The name of the resource.
        :param BehaviourArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BehaviourArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location_granularity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_authentications: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_from_location: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 velocity: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BehaviourArgs.__new__(BehaviourArgs)

            __props__.__dict__["location_granularity_type"] = location_granularity_type
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_authentications"] = number_of_authentications
            __props__.__dict__["radius_from_location"] = radius_from_location
            __props__.__dict__["status"] = status
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["velocity"] = velocity
        super(Behaviour, __self__).__init__(
            'okta:index/behaviour:Behaviour',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location_granularity_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_authentications: Optional[pulumi.Input[_builtins.int]] = None,
            radius_from_location: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            velocity: Optional[pulumi.Input[_builtins.int]] = None) -> 'Behaviour':
        """
        Get an existing Behaviour resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location_granularity_type: Determines the method and level of detail used to evaluate the behavior. Required for `ANOMALOUS_LOCATION` behavior type. Can be set to `LAT_LONG`, `CITY`, `COUNTRY` or `SUBDIVISION`.
        :param pulumi.Input[_builtins.str] name: Name of the behavior
        :param pulumi.Input[_builtins.int] number_of_authentications: The number of recent authentications used to evaluate the behavior. Required for `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE` and `ANOMALOUS_IP` behavior types.
        :param pulumi.Input[_builtins.int] radius_from_location: Radius from location (in kilometers). Should be at least 5. Required when `location_granularity_type` is set to `LAT_LONG`.
        :param pulumi.Input[_builtins.str] status: Behavior status: ACTIVE or INACTIVE. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] type: Type of the behavior. Can be set to `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE`, `ANOMALOUS_IP` or `VELOCITY`. Resource will be recreated when the type changes.e
        :param pulumi.Input[_builtins.int] velocity: Velocity (in kilometers per hour). Should be at least 1. Required for `VELOCITY` behavior
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BehaviourState.__new__(_BehaviourState)

        __props__.__dict__["location_granularity_type"] = location_granularity_type
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_authentications"] = number_of_authentications
        __props__.__dict__["radius_from_location"] = radius_from_location
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["velocity"] = velocity
        return Behaviour(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="locationGranularityType")
    def location_granularity_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines the method and level of detail used to evaluate the behavior. Required for `ANOMALOUS_LOCATION` behavior type. Can be set to `LAT_LONG`, `CITY`, `COUNTRY` or `SUBDIVISION`.
        """
        return pulumi.get(self, "location_granularity_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the behavior
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numberOfAuthentications")
    def number_of_authentications(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of recent authentications used to evaluate the behavior. Required for `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE` and `ANOMALOUS_IP` behavior types.
        """
        return pulumi.get(self, "number_of_authentications")

    @_builtins.property
    @pulumi.getter(name="radiusFromLocation")
    def radius_from_location(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Radius from location (in kilometers). Should be at least 5. Required when `location_granularity_type` is set to `LAT_LONG`.
        """
        return pulumi.get(self, "radius_from_location")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Behavior status: ACTIVE or INACTIVE. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the behavior. Can be set to `ANOMALOUS_LOCATION`, `ANOMALOUS_DEVICE`, `ANOMALOUS_IP` or `VELOCITY`. Resource will be recreated when the type changes.e
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def velocity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Velocity (in kilometers per hour). Should be at least 1. Required for `VELOCITY` behavior
        """
        return pulumi.get(self, "velocity")

