# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    """
    A collection of values returned by getDomain.
    """
    def __init__(__self__, certificate_source_type=None, dns_records=None, domain=None, domain_id_or_name=None, id=None, public_certificate=None, validation_status=None):
        if certificate_source_type and not isinstance(certificate_source_type, str):
            raise TypeError("Expected argument 'certificate_source_type' to be a str")
        pulumi.set(__self__, "certificate_source_type", certificate_source_type)
        if dns_records and not isinstance(dns_records, list):
            raise TypeError("Expected argument 'dns_records' to be a list")
        pulumi.set(__self__, "dns_records", dns_records)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if domain_id_or_name and not isinstance(domain_id_or_name, str):
            raise TypeError("Expected argument 'domain_id_or_name' to be a str")
        pulumi.set(__self__, "domain_id_or_name", domain_id_or_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if public_certificate and not isinstance(public_certificate, dict):
            raise TypeError("Expected argument 'public_certificate' to be a dict")
        pulumi.set(__self__, "public_certificate", public_certificate)
        if validation_status and not isinstance(validation_status, str):
            raise TypeError("Expected argument 'validation_status' to be a str")
        pulumi.set(__self__, "validation_status", validation_status)

    @_builtins.property
    @pulumi.getter(name="certificateSourceType")
    def certificate_source_type(self) -> _builtins.str:
        """
        Certificate source type that indicates whether the certificate is provided by the user or Okta. Values: MANUAL, OKTA_MANAGED
        """
        return pulumi.get(self, "certificate_source_type")

    @_builtins.property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Sequence['outputs.GetDomainDnsRecordResult']:
        """
        TXT and CNAME records to be registered for the Domain
        """
        return pulumi.get(self, "dns_records")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain name
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="domainIdOrName")
    def domain_id_or_name(self) -> _builtins.str:
        """
        Brand ID
        """
        return pulumi.get(self, "domain_id_or_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Domain
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> Mapping[str, _builtins.str]:
        """
        Certificate metadata for the Domain
        """
        return pulumi.get(self, "public_certificate")

    @_builtins.property
    @pulumi.getter(name="validationStatus")
    def validation_status(self) -> _builtins.str:
        """
        Status of the domain. Values: NOT*STARTED, IN*PROGRESS, VERIFIED, COMPLETED
        """
        return pulumi.get(self, "validation_status")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            certificate_source_type=self.certificate_source_type,
            dns_records=self.dns_records,
            domain=self.domain,
            domain_id_or_name=self.domain_id_or_name,
            id=self.id,
            public_certificate=self.public_certificate,
            validation_status=self.validation_status)


def get_domain(domain_id_or_name: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    Get a domain from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.Domain("example", name="www.example.com")
    by_name = okta.get_domain(domain_id_or_name="www.example.com")
    by_id = okta.get_domain_output(domain_id_or_name=example.id)
    ```


    :param _builtins.str domain_id_or_name: Brand ID
    """
    __args__ = dict()
    __args__['domainIdOrName'] = domain_id_or_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getDomain:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        certificate_source_type=pulumi.get(__ret__, 'certificate_source_type'),
        dns_records=pulumi.get(__ret__, 'dns_records'),
        domain=pulumi.get(__ret__, 'domain'),
        domain_id_or_name=pulumi.get(__ret__, 'domain_id_or_name'),
        id=pulumi.get(__ret__, 'id'),
        public_certificate=pulumi.get(__ret__, 'public_certificate'),
        validation_status=pulumi.get(__ret__, 'validation_status'))
def get_domain_output(domain_id_or_name: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainResult]:
    """
    Get a domain from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.Domain("example", name="www.example.com")
    by_name = okta.get_domain(domain_id_or_name="www.example.com")
    by_id = okta.get_domain_output(domain_id_or_name=example.id)
    ```


    :param _builtins.str domain_id_or_name: Brand ID
    """
    __args__ = dict()
    __args__['domainIdOrName'] = domain_id_or_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getDomain:getDomain', __args__, opts=opts, typ=GetDomainResult)
    return __ret__.apply(lambda __response__: GetDomainResult(
        certificate_source_type=pulumi.get(__response__, 'certificate_source_type'),
        dns_records=pulumi.get(__response__, 'dns_records'),
        domain=pulumi.get(__response__, 'domain'),
        domain_id_or_name=pulumi.get(__response__, 'domain_id_or_name'),
        id=pulumi.get(__response__, 'id'),
        public_certificate=pulumi.get(__response__, 'public_certificate'),
        validation_status=pulumi.get(__response__, 'validation_status')))
