# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetEmailCustomizationResult',
    'AwaitableGetEmailCustomizationResult',
    'get_email_customization',
    'get_email_customization_output',
]

@pulumi.output_type
class GetEmailCustomizationResult:
    """
    A collection of values returned by getEmailCustomization.
    """
    def __init__(__self__, body=None, brand_id=None, customization_id=None, id=None, is_default=None, language=None, links=None, subject=None, template_name=None):
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if customization_id and not isinstance(customization_id, str):
            raise TypeError("Expected argument 'customization_id' to be a str")
        pulumi.set(__self__, "customization_id", customization_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if language and not isinstance(language, str):
            raise TypeError("Expected argument 'language' to be a str")
        pulumi.set(__self__, "language", language)
        if links and not isinstance(links, str):
            raise TypeError("Expected argument 'links' to be a str")
        pulumi.set(__self__, "links", links)
        if subject and not isinstance(subject, str):
            raise TypeError("Expected argument 'subject' to be a str")
        pulumi.set(__self__, "subject", subject)
        if template_name and not isinstance(template_name, str):
            raise TypeError("Expected argument 'template_name' to be a str")
        pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter
    def body(self) -> _builtins.str:
        """
        The body of the customization
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> _builtins.str:
        """
        Brand ID
        """
        return pulumi.get(self, "brand_id")

    @_builtins.property
    @pulumi.getter(name="customizationId")
    def customization_id(self) -> _builtins.str:
        """
        The ID of the customization
        """
        return pulumi.get(self, "customization_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the customization
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        Whether the customization is the default
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def language(self) -> _builtins.str:
        """
        The language supported by the customization
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter
    def links(self) -> _builtins.str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The subject of the customization
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        Template Name
        """
        return pulumi.get(self, "template_name")


class AwaitableGetEmailCustomizationResult(GetEmailCustomizationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailCustomizationResult(
            body=self.body,
            brand_id=self.brand_id,
            customization_id=self.customization_id,
            id=self.id,
            is_default=self.is_default,
            language=self.language,
            links=self.links,
            subject=self.subject,
            template_name=self.template_name)


def get_email_customization(brand_id: Optional[_builtins.str] = None,
                            customization_id: Optional[_builtins.str] = None,
                            template_name: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailCustomizationResult:
    """
    Get the email customization of an email template belonging to a brand in an Okta organization.


    :param _builtins.str brand_id: Brand ID
    :param _builtins.str customization_id: The ID of the customization
    :param _builtins.str template_name: Template Name
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['customizationId'] = customization_id
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getEmailCustomization:getEmailCustomization', __args__, opts=opts, typ=GetEmailCustomizationResult).value

    return AwaitableGetEmailCustomizationResult(
        body=pulumi.get(__ret__, 'body'),
        brand_id=pulumi.get(__ret__, 'brand_id'),
        customization_id=pulumi.get(__ret__, 'customization_id'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        language=pulumi.get(__ret__, 'language'),
        links=pulumi.get(__ret__, 'links'),
        subject=pulumi.get(__ret__, 'subject'),
        template_name=pulumi.get(__ret__, 'template_name'))
def get_email_customization_output(brand_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   customization_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   template_name: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEmailCustomizationResult]:
    """
    Get the email customization of an email template belonging to a brand in an Okta organization.


    :param _builtins.str brand_id: Brand ID
    :param _builtins.str customization_id: The ID of the customization
    :param _builtins.str template_name: Template Name
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['customizationId'] = customization_id
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getEmailCustomization:getEmailCustomization', __args__, opts=opts, typ=GetEmailCustomizationResult)
    return __ret__.apply(lambda __response__: GetEmailCustomizationResult(
        body=pulumi.get(__response__, 'body'),
        brand_id=pulumi.get(__response__, 'brand_id'),
        customization_id=pulumi.get(__response__, 'customization_id'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        language=pulumi.get(__response__, 'language'),
        links=pulumi.get(__response__, 'links'),
        subject=pulumi.get(__response__, 'subject'),
        template_name=pulumi.get(__response__, 'template_name')))
