# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetGroupsResult',
    'AwaitableGetGroupsResult',
    'get_groups',
    'get_groups_output',
]

@pulumi.output_type
class GetGroupsResult:
    """
    A collection of values returned by getGroups.
    """
    def __init__(__self__, groups=None, id=None, limit=None, q=None, search=None, type=None):
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if q and not isinstance(q, str):
            raise TypeError("Expected argument 'q' to be a str")
        pulumi.set(__self__, "q", q)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetGroupsGroupResult']:
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        """
        The maximum number of groups returned by the Okta API, between 1 and 10000.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter
    def q(self) -> Optional[_builtins.str]:
        """
        Searches the name property of groups for matching value
        """
        return pulumi.get(self, "q")

    @_builtins.property
    @pulumi.getter
    def search(self) -> Optional[_builtins.str]:
        """
        Searches for groups with a supported filtering expression for all attributes except for '*embedded', '*links', and 'objectClass'
        """
        return pulumi.get(self, "search")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


class AwaitableGetGroupsResult(GetGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupsResult(
            groups=self.groups,
            id=self.id,
            limit=self.limit,
            q=self.q,
            search=self.search,
            type=self.type)


def get_groups(limit: Optional[_builtins.int] = None,
               q: Optional[_builtins.str] = None,
               search: Optional[_builtins.str] = None,
               type: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupsResult:
    """
    Get a list of groups from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_groups(q="Engineering - ")
    ```


    :param _builtins.int limit: The maximum number of groups returned by the Okta API, between 1 and 10000.
    :param _builtins.str q: Searches the name property of groups for matching value
    :param _builtins.str search: Searches for groups with a supported filtering expression for all attributes except for '*embedded', '*links', and 'objectClass'
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['q'] = q
    __args__['search'] = search
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getGroups:getGroups', __args__, opts=opts, typ=GetGroupsResult).value

    return AwaitableGetGroupsResult(
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        q=pulumi.get(__ret__, 'q'),
        search=pulumi.get(__ret__, 'search'),
        type=pulumi.get(__ret__, 'type'))
def get_groups_output(limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      q: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      search: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupsResult]:
    """
    Get a list of groups from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_groups(q="Engineering - ")
    ```


    :param _builtins.int limit: The maximum number of groups returned by the Okta API, between 1 and 10000.
    :param _builtins.str q: Searches the name property of groups for matching value
    :param _builtins.str search: Searches for groups with a supported filtering expression for all attributes except for '*embedded', '*links', and 'objectClass'
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['q'] = q
    __args__['search'] = search
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getGroups:getGroups', __args__, opts=opts, typ=GetGroupsResult)
    return __ret__.apply(lambda __response__: GetGroupsResult(
        groups=pulumi.get(__response__, 'groups'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        q=pulumi.get(__response__, 'q'),
        search=pulumi.get(__response__, 'search'),
        type=pulumi.get(__response__, 'type')))
