# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GroupMembershipsArgs', 'GroupMemberships']

@pulumi.input_type
class GroupMembershipsArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 users: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 track_all_users: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GroupMemberships resource.
        :param pulumi.Input[_builtins.str] group_id: ID of a Okta group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: The list of Okta user IDs which the group should have membership managed for.
        :param pulumi.Input[_builtins.bool] track_all_users: The resource concerns itself with all users added/deleted to the group; even those managed outside of the resource.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "users", users)
        if track_all_users is not None:
            pulumi.set(__self__, "track_all_users", track_all_users)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of a Okta group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of Okta user IDs which the group should have membership managed for.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "users", value)

    @_builtins.property
    @pulumi.getter(name="trackAllUsers")
    def track_all_users(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The resource concerns itself with all users added/deleted to the group; even those managed outside of the resource.
        """
        return pulumi.get(self, "track_all_users")

    @track_all_users.setter
    def track_all_users(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "track_all_users", value)


@pulumi.input_type
class _GroupMembershipsState:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 track_all_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering GroupMemberships resources.
        :param pulumi.Input[_builtins.str] group_id: ID of a Okta group.
        :param pulumi.Input[_builtins.bool] track_all_users: The resource concerns itself with all users added/deleted to the group; even those managed outside of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: The list of Okta user IDs which the group should have membership managed for.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if track_all_users is not None:
            pulumi.set(__self__, "track_all_users", track_all_users)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a Okta group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="trackAllUsers")
    def track_all_users(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The resource concerns itself with all users added/deleted to the group; even those managed outside of the resource.
        """
        return pulumi.get(self, "track_all_users")

    @track_all_users.setter
    def track_all_users(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "track_all_users", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of Okta user IDs which the group should have membership managed for.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("okta:index/groupMemberships:GroupMemberships")
class GroupMemberships(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 track_all_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource to manage a set of memberships for a specific group.
        This resource will allow you to bulk manage group membership in Okta for a given
        group. This offers an interface to pass multiple users into a single resource
        call, for better API resource usage. If you need a relationship of a single
        user to many groups, please use the 'okta_user_group_memberships' resource.
        **Important**: The default behavior of the resource is to only maintain the
        state of user ids that are assigned it. This behavior will signal drift only if
        those users stop being part of the group. If the desired behavior is track all
        users that are added/removed from the group make use of the 'track_all_users'
        argument with this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.group.Group("test",
            name="testAcc_replace_with_uuid",
            description="testing, testing")
        test_group_memberships = okta.GroupMemberships("test",
            group_id=test.id,
            users=[
                test1["id"],
                test2["id"],
            ])
        ```

        ## Import

        an Okta Group's memberships can be imported via the Okta group ID.

        ```sh
        $ pulumi import okta:index/groupMemberships:GroupMemberships test <group_id>
        ```

        optional parameter track all users will also import all user id currently assigned to the group

        ```sh
        $ pulumi import okta:index/groupMemberships:GroupMemberships test <group_id>/<true>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: ID of a Okta group.
        :param pulumi.Input[_builtins.bool] track_all_users: The resource concerns itself with all users added/deleted to the group; even those managed outside of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: The list of Okta user IDs which the group should have membership managed for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupMembershipsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource to manage a set of memberships for a specific group.
        This resource will allow you to bulk manage group membership in Okta for a given
        group. This offers an interface to pass multiple users into a single resource
        call, for better API resource usage. If you need a relationship of a single
        user to many groups, please use the 'okta_user_group_memberships' resource.
        **Important**: The default behavior of the resource is to only maintain the
        state of user ids that are assigned it. This behavior will signal drift only if
        those users stop being part of the group. If the desired behavior is track all
        users that are added/removed from the group make use of the 'track_all_users'
        argument with this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.group.Group("test",
            name="testAcc_replace_with_uuid",
            description="testing, testing")
        test_group_memberships = okta.GroupMemberships("test",
            group_id=test.id,
            users=[
                test1["id"],
                test2["id"],
            ])
        ```

        ## Import

        an Okta Group's memberships can be imported via the Okta group ID.

        ```sh
        $ pulumi import okta:index/groupMemberships:GroupMemberships test <group_id>
        ```

        optional parameter track all users will also import all user id currently assigned to the group

        ```sh
        $ pulumi import okta:index/groupMemberships:GroupMemberships test <group_id>/<true>
        ```

        :param str resource_name: The name of the resource.
        :param GroupMembershipsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupMembershipsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 track_all_users: Optional[pulumi.Input[_builtins.bool]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupMembershipsArgs.__new__(GroupMembershipsArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["track_all_users"] = track_all_users
            if users is None and not opts.urn:
                raise TypeError("Missing required property 'users'")
            __props__.__dict__["users"] = users
        super(GroupMemberships, __self__).__init__(
            'okta:index/groupMemberships:GroupMemberships',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            track_all_users: Optional[pulumi.Input[_builtins.bool]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'GroupMemberships':
        """
        Get an existing GroupMemberships resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: ID of a Okta group.
        :param pulumi.Input[_builtins.bool] track_all_users: The resource concerns itself with all users added/deleted to the group; even those managed outside of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: The list of Okta user IDs which the group should have membership managed for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupMembershipsState.__new__(_GroupMembershipsState)

        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["track_all_users"] = track_all_users
        __props__.__dict__["users"] = users
        return GroupMemberships(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of a Okta group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="trackAllUsers")
    def track_all_users(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The resource concerns itself with all users added/deleted to the group; even those managed outside of the resource.
        """
        return pulumi.get(self, "track_all_users")

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of Okta user IDs which the group should have membership managed for.
        """
        return pulumi.get(self, "users")

