# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'UserPasswordHashArgs',
    'UserPasswordHashArgsDict',
    'GetUserSearchArgs',
    'GetUserSearchArgsDict',
    'GetUsersSearchArgs',
    'GetUsersSearchArgsDict',
]

MYPY = False

if not MYPY:
    class UserPasswordHashArgsDict(TypedDict):
        algorithm: pulumi.Input[_builtins.str]
        """
        The algorithm used to generate the hash using the password
        """
        value: pulumi.Input[_builtins.str]
        """
        For SHA-512, SHA-256, SHA-1, MD5, This is the actual base64-encoded hash of the password (and salt, if used). This is the Base64 encoded value of the SHA-512/SHA-256/SHA-1/MD5 digest that was computed by either pre-fixing or post-fixing the salt to the password, depending on the saltOrder. If a salt was not used in the source system, then this should just be the the Base64 encoded value of the password's SHA-512/SHA-256/SHA-1/MD5 digest. For BCRYPT, This is the actual radix64-encoded hashed password.
        """
        salt: NotRequired[pulumi.Input[_builtins.str]]
        """
        Only required for salted hashes
        """
        salt_order: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies whether salt was pre- or postfixed to the password before hashing
        """
        work_factor: NotRequired[pulumi.Input[_builtins.int]]
        """
        Governs the strength of the hash and the time required to compute it. Only required for BCRYPT algorithm
        """
elif False:
    UserPasswordHashArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserPasswordHashArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str],
                 salt: Optional[pulumi.Input[_builtins.str]] = None,
                 salt_order: Optional[pulumi.Input[_builtins.str]] = None,
                 work_factor: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] algorithm: The algorithm used to generate the hash using the password
        :param pulumi.Input[_builtins.str] value: For SHA-512, SHA-256, SHA-1, MD5, This is the actual base64-encoded hash of the password (and salt, if used). This is the Base64 encoded value of the SHA-512/SHA-256/SHA-1/MD5 digest that was computed by either pre-fixing or post-fixing the salt to the password, depending on the saltOrder. If a salt was not used in the source system, then this should just be the the Base64 encoded value of the password's SHA-512/SHA-256/SHA-1/MD5 digest. For BCRYPT, This is the actual radix64-encoded hashed password.
        :param pulumi.Input[_builtins.str] salt: Only required for salted hashes
        :param pulumi.Input[_builtins.str] salt_order: Specifies whether salt was pre- or postfixed to the password before hashing
        :param pulumi.Input[_builtins.int] work_factor: Governs the strength of the hash and the time required to compute it. Only required for BCRYPT algorithm
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)
        if salt is not None:
            pulumi.set(__self__, "salt", salt)
        if salt_order is not None:
            pulumi.set(__self__, "salt_order", salt_order)
        if work_factor is not None:
            pulumi.set(__self__, "work_factor", work_factor)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        The algorithm used to generate the hash using the password
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        For SHA-512, SHA-256, SHA-1, MD5, This is the actual base64-encoded hash of the password (and salt, if used). This is the Base64 encoded value of the SHA-512/SHA-256/SHA-1/MD5 digest that was computed by either pre-fixing or post-fixing the salt to the password, depending on the saltOrder. If a salt was not used in the source system, then this should just be the the Base64 encoded value of the password's SHA-512/SHA-256/SHA-1/MD5 digest. For BCRYPT, This is the actual radix64-encoded hashed password.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def salt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only required for salted hashes
        """
        return pulumi.get(self, "salt")

    @salt.setter
    def salt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "salt", value)

    @_builtins.property
    @pulumi.getter(name="saltOrder")
    def salt_order(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether salt was pre- or postfixed to the password before hashing
        """
        return pulumi.get(self, "salt_order")

    @salt_order.setter
    def salt_order(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "salt_order", value)

    @_builtins.property
    @pulumi.getter(name="workFactor")
    def work_factor(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Governs the strength of the hash and the time required to compute it. Only required for BCRYPT algorithm
        """
        return pulumi.get(self, "work_factor")

    @work_factor.setter
    def work_factor(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "work_factor", value)


if not MYPY:
    class GetUserSearchArgsDict(TypedDict):
        comparison: NotRequired[_builtins.str]
        expression: NotRequired[_builtins.str]
        """
        A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        name: NotRequired[_builtins.str]
        """
        Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        value: NotRequired[_builtins.str]
elif False:
    GetUserSearchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetUserSearchArgs:
    def __init__(__self__, *,
                 comparison: Optional[_builtins.str] = None,
                 expression: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        :param _builtins.str name: Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        if comparison is not None:
            pulumi.set(__self__, "comparison", comparison)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def comparison(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "comparison")

    @comparison.setter
    def comparison(self, value: Optional[_builtins.str]):
        pulumi.set(self, "comparison", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class GetUsersSearchArgsDict(TypedDict):
        comparison: NotRequired[_builtins.str]
        expression: NotRequired[_builtins.str]
        """
        A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        name: NotRequired[_builtins.str]
        """
        Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        value: NotRequired[_builtins.str]
elif False:
    GetUsersSearchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetUsersSearchArgs:
    def __init__(__self__, *,
                 comparison: Optional[_builtins.str] = None,
                 expression: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        :param _builtins.str name: Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        if comparison is not None:
            pulumi.set(__self__, "comparison", comparison)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def comparison(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "comparison")

    @comparison.setter
    def comparison(self, value: Optional[_builtins.str]):
        pulumi.set(self, "comparison", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        A raw search expression string. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Property name to search for. This requires the search feature be on. Please see Okta documentation on their filter API for users. https://developer.okta.com/docs/api/resources/users#list-users-with-search
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[_builtins.str]):
        pulumi.set(self, "value", value)


