# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str],
                 first_name: pulumi.Input[_builtins.str],
                 last_name: pulumi.Input[_builtins.str],
                 login: pulumi.Input[_builtins.str],
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 cost_center: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_profile_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_profile_attributes_to_ignores: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 department: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 division: Optional[pulumi.Input[_builtins.str]] = None,
                 employee_number: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_password_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 honorific_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 honorific_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 manager: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 middle_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 nick_name: Optional[pulumi.Input[_builtins.str]] = None,
                 old_password: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_hash: Optional[pulumi.Input['UserPasswordHashArgs']] = None,
                 password_inline_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 postal_address: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_url: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_answer: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_question: Optional[pulumi.Input[_builtins.str]] = None,
                 second_email: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_roles: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] email: User primary email address
        :param pulumi.Input[_builtins.str] first_name: User first name
        :param pulumi.Input[_builtins.str] last_name: User last name
        :param pulumi.Input[_builtins.str] login: User Okta login
        :param pulumi.Input[_builtins.str] city: User city
        :param pulumi.Input[_builtins.str] cost_center: User cost center
        :param pulumi.Input[_builtins.str] country_code: User country code
        :param pulumi.Input[_builtins.str] custom_profile_attributes: JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin Console or the [Schemas](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) API to manage schema extensions.
        :param pulumi.Input[_builtins.str] department: User department
        :param pulumi.Input[_builtins.str] display_name: User display name, suitable to show end users
        :param pulumi.Input[_builtins.str] division: User division
        :param pulumi.Input[_builtins.str] employee_number: User employee number
        :param pulumi.Input[_builtins.bool] expire_password_on_create: If set to `true`, the user will have to change the password at the next login. This property will be used when user is being created and works only when `password` field is set. Default: `false`
        :param pulumi.Input[_builtins.str] honorific_prefix: User honorific prefix
        :param pulumi.Input[_builtins.str] honorific_suffix: User honorific suffix
        :param pulumi.Input[_builtins.str] locale: User default location
        :param pulumi.Input[_builtins.str] manager: Manager of User
        :param pulumi.Input[_builtins.str] manager_id: Manager ID of User
        :param pulumi.Input[_builtins.str] middle_name: User middle name
        :param pulumi.Input[_builtins.str] mobile_phone: User mobile phone number
        :param pulumi.Input[_builtins.str] nick_name: User nickname
        :param pulumi.Input[_builtins.str] old_password: Old User Password. Should be only set in case the password was not changed using the provider. fter successful password change this field should be removed and `password` field should be used for further changes.
        :param pulumi.Input[_builtins.str] organization: User organization
        :param pulumi.Input[_builtins.str] password: User Password
        :param pulumi.Input['UserPasswordHashArgs'] password_hash: Specifies a hashed password to import into Okta.
        :param pulumi.Input[_builtins.str] password_inline_hook: Specifies that a Password Import Inline Hook should be triggered to handle verification of the user's password the first time the user logs in. This allows an existing password to be imported into Okta directly from some other store. When updating a user with a password hook the user must be in the `STAGED` status. The `password` field should not be specified when using Password Import Inline Hook.
        :param pulumi.Input[_builtins.str] postal_address: User mailing address
        :param pulumi.Input[_builtins.str] preferred_language: User preferred language
        :param pulumi.Input[_builtins.str] primary_phone: User primary phone number
        :param pulumi.Input[_builtins.str] profile_url: User online profile (web page)
        :param pulumi.Input[_builtins.str] recovery_answer: User Password Recovery Answer
        :param pulumi.Input[_builtins.str] recovery_question: User Password Recovery Question
        :param pulumi.Input[_builtins.str] second_email: User secondary email address, used for account recovery
        :param pulumi.Input[_builtins.bool] skip_roles: Do not populate user roles information (prevents additional API call)
        :param pulumi.Input[_builtins.str] state: User state or region
        :param pulumi.Input[_builtins.str] status: User profile property. Valid values are `ACTIVE`, `DEPROVISIONED`, `STAGED`, `SUSPENDED`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] street_address: User street address
        :param pulumi.Input[_builtins.str] timezone: User default timezone
        :param pulumi.Input[_builtins.str] title: User title
        :param pulumi.Input[_builtins.str] user_type: User employee type
        :param pulumi.Input[_builtins.str] zip_code: User zipcode or postal code
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "login", login)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if cost_center is not None:
            pulumi.set(__self__, "cost_center", cost_center)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if custom_profile_attributes is not None:
            pulumi.set(__self__, "custom_profile_attributes", custom_profile_attributes)
        if custom_profile_attributes_to_ignores is not None:
            pulumi.set(__self__, "custom_profile_attributes_to_ignores", custom_profile_attributes_to_ignores)
        if department is not None:
            pulumi.set(__self__, "department", department)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if division is not None:
            pulumi.set(__self__, "division", division)
        if employee_number is not None:
            pulumi.set(__self__, "employee_number", employee_number)
        if expire_password_on_create is not None:
            pulumi.set(__self__, "expire_password_on_create", expire_password_on_create)
        if honorific_prefix is not None:
            pulumi.set(__self__, "honorific_prefix", honorific_prefix)
        if honorific_suffix is not None:
            pulumi.set(__self__, "honorific_suffix", honorific_suffix)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if manager is not None:
            pulumi.set(__self__, "manager", manager)
        if manager_id is not None:
            pulumi.set(__self__, "manager_id", manager_id)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if nick_name is not None:
            pulumi.set(__self__, "nick_name", nick_name)
        if old_password is not None:
            pulumi.set(__self__, "old_password", old_password)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_hash is not None:
            pulumi.set(__self__, "password_hash", password_hash)
        if password_inline_hook is not None:
            pulumi.set(__self__, "password_inline_hook", password_inline_hook)
        if postal_address is not None:
            pulumi.set(__self__, "postal_address", postal_address)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if primary_phone is not None:
            pulumi.set(__self__, "primary_phone", primary_phone)
        if profile_url is not None:
            pulumi.set(__self__, "profile_url", profile_url)
        if recovery_answer is not None:
            pulumi.set(__self__, "recovery_answer", recovery_answer)
        if recovery_question is not None:
            pulumi.set(__self__, "recovery_question", recovery_question)
        if second_email is not None:
            pulumi.set(__self__, "second_email", second_email)
        if skip_roles is not None:
            warnings.warn("""Because admin_roles has been removed, this attribute is a no op and will be removed""", DeprecationWarning)
            pulumi.log.warn("""skip_roles is deprecated: Because admin_roles has been removed, this attribute is a no op and will be removed""")
        if skip_roles is not None:
            pulumi.set(__self__, "skip_roles", skip_roles)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        User primary email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Input[_builtins.str]:
        """
        User first name
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Input[_builtins.str]:
        """
        User last name
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Input[_builtins.str]:
        """
        User Okta login
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User city
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter(name="costCenter")
    def cost_center(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User cost center
        """
        return pulumi.get(self, "cost_center")

    @cost_center.setter
    def cost_center(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cost_center", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User country code
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin Console or the [Schemas](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) API to manage schema extensions.
        """
        return pulumi.get(self, "custom_profile_attributes")

    @custom_profile_attributes.setter
    def custom_profile_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_profile_attributes", value)

    @_builtins.property
    @pulumi.getter(name="customProfileAttributesToIgnores")
    def custom_profile_attributes_to_ignores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "custom_profile_attributes_to_ignores")

    @custom_profile_attributes_to_ignores.setter
    def custom_profile_attributes_to_ignores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_profile_attributes_to_ignores", value)

    @_builtins.property
    @pulumi.getter
    def department(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User department
        """
        return pulumi.get(self, "department")

    @department.setter
    def department(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "department", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User display name, suitable to show end users
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def division(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User division
        """
        return pulumi.get(self, "division")

    @division.setter
    def division(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "division", value)

    @_builtins.property
    @pulumi.getter(name="employeeNumber")
    def employee_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User employee number
        """
        return pulumi.get(self, "employee_number")

    @employee_number.setter
    def employee_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "employee_number", value)

    @_builtins.property
    @pulumi.getter(name="expirePasswordOnCreate")
    def expire_password_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the user will have to change the password at the next login. This property will be used when user is being created and works only when `password` field is set. Default: `false`
        """
        return pulumi.get(self, "expire_password_on_create")

    @expire_password_on_create.setter
    def expire_password_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "expire_password_on_create", value)

    @_builtins.property
    @pulumi.getter(name="honorificPrefix")
    def honorific_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User honorific prefix
        """
        return pulumi.get(self, "honorific_prefix")

    @honorific_prefix.setter
    def honorific_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honorific_prefix", value)

    @_builtins.property
    @pulumi.getter(name="honorificSuffix")
    def honorific_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User honorific suffix
        """
        return pulumi.get(self, "honorific_suffix")

    @honorific_suffix.setter
    def honorific_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honorific_suffix", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User default location
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter
    def manager(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Manager of User
        """
        return pulumi.get(self, "manager")

    @manager.setter
    def manager(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager", value)

    @_builtins.property
    @pulumi.getter(name="managerId")
    def manager_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Manager ID of User
        """
        return pulumi.get(self, "manager_id")

    @manager_id.setter
    def manager_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_id", value)

    @_builtins.property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User middle name
        """
        return pulumi.get(self, "middle_name")

    @middle_name.setter
    def middle_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "middle_name", value)

    @_builtins.property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User mobile phone number
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile_phone", value)

    @_builtins.property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User nickname
        """
        return pulumi.get(self, "nick_name")

    @nick_name.setter
    def nick_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nick_name", value)

    @_builtins.property
    @pulumi.getter(name="oldPassword")
    def old_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Old User Password. Should be only set in case the password was not changed using the provider. fter successful password change this field should be removed and `password` field should be used for further changes.
        """
        return pulumi.get(self, "old_password")

    @old_password.setter
    def old_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "old_password", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User Password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordHash")
    def password_hash(self) -> Optional[pulumi.Input['UserPasswordHashArgs']]:
        """
        Specifies a hashed password to import into Okta.
        """
        return pulumi.get(self, "password_hash")

    @password_hash.setter
    def password_hash(self, value: Optional[pulumi.Input['UserPasswordHashArgs']]):
        pulumi.set(self, "password_hash", value)

    @_builtins.property
    @pulumi.getter(name="passwordInlineHook")
    def password_inline_hook(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies that a Password Import Inline Hook should be triggered to handle verification of the user's password the first time the user logs in. This allows an existing password to be imported into Okta directly from some other store. When updating a user with a password hook the user must be in the `STAGED` status. The `password` field should not be specified when using Password Import Inline Hook.
        """
        return pulumi.get(self, "password_inline_hook")

    @password_inline_hook.setter
    def password_inline_hook(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_inline_hook", value)

    @_builtins.property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User mailing address
        """
        return pulumi.get(self, "postal_address")

    @postal_address.setter
    def postal_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postal_address", value)

    @_builtins.property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User preferred language
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_language", value)

    @_builtins.property
    @pulumi.getter(name="primaryPhone")
    def primary_phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User primary phone number
        """
        return pulumi.get(self, "primary_phone")

    @primary_phone.setter
    def primary_phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_phone", value)

    @_builtins.property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User online profile (web page)
        """
        return pulumi.get(self, "profile_url")

    @profile_url.setter
    def profile_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_url", value)

    @_builtins.property
    @pulumi.getter(name="recoveryAnswer")
    def recovery_answer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User Password Recovery Answer
        """
        return pulumi.get(self, "recovery_answer")

    @recovery_answer.setter
    def recovery_answer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_answer", value)

    @_builtins.property
    @pulumi.getter(name="recoveryQuestion")
    def recovery_question(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User Password Recovery Question
        """
        return pulumi.get(self, "recovery_question")

    @recovery_question.setter
    def recovery_question(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_question", value)

    @_builtins.property
    @pulumi.getter(name="secondEmail")
    def second_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User secondary email address, used for account recovery
        """
        return pulumi.get(self, "second_email")

    @second_email.setter
    def second_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "second_email", value)

    @_builtins.property
    @pulumi.getter(name="skipRoles")
    @_utilities.deprecated("""Because admin_roles has been removed, this attribute is a no op and will be removed""")
    def skip_roles(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not populate user roles information (prevents additional API call)
        """
        return pulumi.get(self, "skip_roles")

    @skip_roles.setter
    def skip_roles(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_roles", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User state or region
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User profile property. Valid values are `ACTIVE`, `DEPROVISIONED`, `STAGED`, `SUSPENDED`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "street_address", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User default timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User title
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User employee type
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User zipcode or postal code
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zip_code", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 cost_center: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_profile_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_profile_attributes_to_ignores: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 department: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 division: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 employee_number: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_password_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 honorific_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 honorific_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 manager: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 middle_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 nick_name: Optional[pulumi.Input[_builtins.str]] = None,
                 old_password: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_hash: Optional[pulumi.Input['UserPasswordHashArgs']] = None,
                 password_inline_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 postal_address: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_url: Optional[pulumi.Input[_builtins.str]] = None,
                 raw_status: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_answer: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_question: Optional[pulumi.Input[_builtins.str]] = None,
                 second_email: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_roles: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.str] city: User city
        :param pulumi.Input[_builtins.str] cost_center: User cost center
        :param pulumi.Input[_builtins.str] country_code: User country code
        :param pulumi.Input[_builtins.str] custom_profile_attributes: JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin Console or the [Schemas](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) API to manage schema extensions.
        :param pulumi.Input[_builtins.str] department: User department
        :param pulumi.Input[_builtins.str] display_name: User display name, suitable to show end users
        :param pulumi.Input[_builtins.str] division: User division
        :param pulumi.Input[_builtins.str] email: User primary email address
        :param pulumi.Input[_builtins.str] employee_number: User employee number
        :param pulumi.Input[_builtins.bool] expire_password_on_create: If set to `true`, the user will have to change the password at the next login. This property will be used when user is being created and works only when `password` field is set. Default: `false`
        :param pulumi.Input[_builtins.str] first_name: User first name
        :param pulumi.Input[_builtins.str] honorific_prefix: User honorific prefix
        :param pulumi.Input[_builtins.str] honorific_suffix: User honorific suffix
        :param pulumi.Input[_builtins.str] last_name: User last name
        :param pulumi.Input[_builtins.str] locale: User default location
        :param pulumi.Input[_builtins.str] login: User Okta login
        :param pulumi.Input[_builtins.str] manager: Manager of User
        :param pulumi.Input[_builtins.str] manager_id: Manager ID of User
        :param pulumi.Input[_builtins.str] middle_name: User middle name
        :param pulumi.Input[_builtins.str] mobile_phone: User mobile phone number
        :param pulumi.Input[_builtins.str] nick_name: User nickname
        :param pulumi.Input[_builtins.str] old_password: Old User Password. Should be only set in case the password was not changed using the provider. fter successful password change this field should be removed and `password` field should be used for further changes.
        :param pulumi.Input[_builtins.str] organization: User organization
        :param pulumi.Input[_builtins.str] password: User Password
        :param pulumi.Input['UserPasswordHashArgs'] password_hash: Specifies a hashed password to import into Okta.
        :param pulumi.Input[_builtins.str] password_inline_hook: Specifies that a Password Import Inline Hook should be triggered to handle verification of the user's password the first time the user logs in. This allows an existing password to be imported into Okta directly from some other store. When updating a user with a password hook the user must be in the `STAGED` status. The `password` field should not be specified when using Password Import Inline Hook.
        :param pulumi.Input[_builtins.str] postal_address: User mailing address
        :param pulumi.Input[_builtins.str] preferred_language: User preferred language
        :param pulumi.Input[_builtins.str] primary_phone: User primary phone number
        :param pulumi.Input[_builtins.str] profile_url: User online profile (web page)
        :param pulumi.Input[_builtins.str] raw_status: The raw status of the User in Okta - (status is mapped)
        :param pulumi.Input[_builtins.str] recovery_answer: User Password Recovery Answer
        :param pulumi.Input[_builtins.str] recovery_question: User Password Recovery Question
        :param pulumi.Input[_builtins.str] second_email: User secondary email address, used for account recovery
        :param pulumi.Input[_builtins.bool] skip_roles: Do not populate user roles information (prevents additional API call)
        :param pulumi.Input[_builtins.str] state: User state or region
        :param pulumi.Input[_builtins.str] status: User profile property. Valid values are `ACTIVE`, `DEPROVISIONED`, `STAGED`, `SUSPENDED`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] street_address: User street address
        :param pulumi.Input[_builtins.str] timezone: User default timezone
        :param pulumi.Input[_builtins.str] title: User title
        :param pulumi.Input[_builtins.str] user_type: User employee type
        :param pulumi.Input[_builtins.str] zip_code: User zipcode or postal code
        """
        if city is not None:
            pulumi.set(__self__, "city", city)
        if cost_center is not None:
            pulumi.set(__self__, "cost_center", cost_center)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if custom_profile_attributes is not None:
            pulumi.set(__self__, "custom_profile_attributes", custom_profile_attributes)
        if custom_profile_attributes_to_ignores is not None:
            pulumi.set(__self__, "custom_profile_attributes_to_ignores", custom_profile_attributes_to_ignores)
        if department is not None:
            pulumi.set(__self__, "department", department)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if division is not None:
            pulumi.set(__self__, "division", division)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if employee_number is not None:
            pulumi.set(__self__, "employee_number", employee_number)
        if expire_password_on_create is not None:
            pulumi.set(__self__, "expire_password_on_create", expire_password_on_create)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if honorific_prefix is not None:
            pulumi.set(__self__, "honorific_prefix", honorific_prefix)
        if honorific_suffix is not None:
            pulumi.set(__self__, "honorific_suffix", honorific_suffix)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if manager is not None:
            pulumi.set(__self__, "manager", manager)
        if manager_id is not None:
            pulumi.set(__self__, "manager_id", manager_id)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if nick_name is not None:
            pulumi.set(__self__, "nick_name", nick_name)
        if old_password is not None:
            pulumi.set(__self__, "old_password", old_password)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_hash is not None:
            pulumi.set(__self__, "password_hash", password_hash)
        if password_inline_hook is not None:
            pulumi.set(__self__, "password_inline_hook", password_inline_hook)
        if postal_address is not None:
            pulumi.set(__self__, "postal_address", postal_address)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if primary_phone is not None:
            pulumi.set(__self__, "primary_phone", primary_phone)
        if profile_url is not None:
            pulumi.set(__self__, "profile_url", profile_url)
        if raw_status is not None:
            pulumi.set(__self__, "raw_status", raw_status)
        if recovery_answer is not None:
            pulumi.set(__self__, "recovery_answer", recovery_answer)
        if recovery_question is not None:
            pulumi.set(__self__, "recovery_question", recovery_question)
        if second_email is not None:
            pulumi.set(__self__, "second_email", second_email)
        if skip_roles is not None:
            warnings.warn("""Because admin_roles has been removed, this attribute is a no op and will be removed""", DeprecationWarning)
            pulumi.log.warn("""skip_roles is deprecated: Because admin_roles has been removed, this attribute is a no op and will be removed""")
        if skip_roles is not None:
            pulumi.set(__self__, "skip_roles", skip_roles)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if street_address is not None:
            pulumi.set(__self__, "street_address", street_address)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User city
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter(name="costCenter")
    def cost_center(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User cost center
        """
        return pulumi.get(self, "cost_center")

    @cost_center.setter
    def cost_center(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cost_center", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User country code
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin Console or the [Schemas](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) API to manage schema extensions.
        """
        return pulumi.get(self, "custom_profile_attributes")

    @custom_profile_attributes.setter
    def custom_profile_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_profile_attributes", value)

    @_builtins.property
    @pulumi.getter(name="customProfileAttributesToIgnores")
    def custom_profile_attributes_to_ignores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "custom_profile_attributes_to_ignores")

    @custom_profile_attributes_to_ignores.setter
    def custom_profile_attributes_to_ignores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_profile_attributes_to_ignores", value)

    @_builtins.property
    @pulumi.getter
    def department(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User department
        """
        return pulumi.get(self, "department")

    @department.setter
    def department(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "department", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User display name, suitable to show end users
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def division(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User division
        """
        return pulumi.get(self, "division")

    @division.setter
    def division(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "division", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User primary email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="employeeNumber")
    def employee_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User employee number
        """
        return pulumi.get(self, "employee_number")

    @employee_number.setter
    def employee_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "employee_number", value)

    @_builtins.property
    @pulumi.getter(name="expirePasswordOnCreate")
    def expire_password_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, the user will have to change the password at the next login. This property will be used when user is being created and works only when `password` field is set. Default: `false`
        """
        return pulumi.get(self, "expire_password_on_create")

    @expire_password_on_create.setter
    def expire_password_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "expire_password_on_create", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User first name
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="honorificPrefix")
    def honorific_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User honorific prefix
        """
        return pulumi.get(self, "honorific_prefix")

    @honorific_prefix.setter
    def honorific_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honorific_prefix", value)

    @_builtins.property
    @pulumi.getter(name="honorificSuffix")
    def honorific_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User honorific suffix
        """
        return pulumi.get(self, "honorific_suffix")

    @honorific_suffix.setter
    def honorific_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "honorific_suffix", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User last name
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User default location
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "locale", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User Okta login
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def manager(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Manager of User
        """
        return pulumi.get(self, "manager")

    @manager.setter
    def manager(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager", value)

    @_builtins.property
    @pulumi.getter(name="managerId")
    def manager_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Manager ID of User
        """
        return pulumi.get(self, "manager_id")

    @manager_id.setter
    def manager_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_id", value)

    @_builtins.property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User middle name
        """
        return pulumi.get(self, "middle_name")

    @middle_name.setter
    def middle_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "middle_name", value)

    @_builtins.property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User mobile phone number
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile_phone", value)

    @_builtins.property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User nickname
        """
        return pulumi.get(self, "nick_name")

    @nick_name.setter
    def nick_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nick_name", value)

    @_builtins.property
    @pulumi.getter(name="oldPassword")
    def old_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Old User Password. Should be only set in case the password was not changed using the provider. fter successful password change this field should be removed and `password` field should be used for further changes.
        """
        return pulumi.get(self, "old_password")

    @old_password.setter
    def old_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "old_password", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User organization
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User Password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordHash")
    def password_hash(self) -> Optional[pulumi.Input['UserPasswordHashArgs']]:
        """
        Specifies a hashed password to import into Okta.
        """
        return pulumi.get(self, "password_hash")

    @password_hash.setter
    def password_hash(self, value: Optional[pulumi.Input['UserPasswordHashArgs']]):
        pulumi.set(self, "password_hash", value)

    @_builtins.property
    @pulumi.getter(name="passwordInlineHook")
    def password_inline_hook(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies that a Password Import Inline Hook should be triggered to handle verification of the user's password the first time the user logs in. This allows an existing password to be imported into Okta directly from some other store. When updating a user with a password hook the user must be in the `STAGED` status. The `password` field should not be specified when using Password Import Inline Hook.
        """
        return pulumi.get(self, "password_inline_hook")

    @password_inline_hook.setter
    def password_inline_hook(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password_inline_hook", value)

    @_builtins.property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User mailing address
        """
        return pulumi.get(self, "postal_address")

    @postal_address.setter
    def postal_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postal_address", value)

    @_builtins.property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User preferred language
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_language", value)

    @_builtins.property
    @pulumi.getter(name="primaryPhone")
    def primary_phone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User primary phone number
        """
        return pulumi.get(self, "primary_phone")

    @primary_phone.setter
    def primary_phone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_phone", value)

    @_builtins.property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User online profile (web page)
        """
        return pulumi.get(self, "profile_url")

    @profile_url.setter
    def profile_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_url", value)

    @_builtins.property
    @pulumi.getter(name="rawStatus")
    def raw_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The raw status of the User in Okta - (status is mapped)
        """
        return pulumi.get(self, "raw_status")

    @raw_status.setter
    def raw_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "raw_status", value)

    @_builtins.property
    @pulumi.getter(name="recoveryAnswer")
    def recovery_answer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User Password Recovery Answer
        """
        return pulumi.get(self, "recovery_answer")

    @recovery_answer.setter
    def recovery_answer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_answer", value)

    @_builtins.property
    @pulumi.getter(name="recoveryQuestion")
    def recovery_question(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User Password Recovery Question
        """
        return pulumi.get(self, "recovery_question")

    @recovery_question.setter
    def recovery_question(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_question", value)

    @_builtins.property
    @pulumi.getter(name="secondEmail")
    def second_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User secondary email address, used for account recovery
        """
        return pulumi.get(self, "second_email")

    @second_email.setter
    def second_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "second_email", value)

    @_builtins.property
    @pulumi.getter(name="skipRoles")
    @_utilities.deprecated("""Because admin_roles has been removed, this attribute is a no op and will be removed""")
    def skip_roles(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Do not populate user roles information (prevents additional API call)
        """
        return pulumi.get(self, "skip_roles")

    @skip_roles.setter
    def skip_roles(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_roles", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User state or region
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User profile property. Valid values are `ACTIVE`, `DEPROVISIONED`, `STAGED`, `SUSPENDED`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User street address
        """
        return pulumi.get(self, "street_address")

    @street_address.setter
    def street_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "street_address", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User default timezone
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User title
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User employee type
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User zipcode or postal code
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zip_code", value)


@pulumi.type_token("okta:user/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 cost_center: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_profile_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_profile_attributes_to_ignores: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 department: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 division: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 employee_number: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_password_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 honorific_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 honorific_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 manager: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 middle_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 nick_name: Optional[pulumi.Input[_builtins.str]] = None,
                 old_password: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_hash: Optional[pulumi.Input[Union['UserPasswordHashArgs', 'UserPasswordHashArgsDict']]] = None,
                 password_inline_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 postal_address: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_url: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_answer: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_question: Optional[pulumi.Input[_builtins.str]] = None,
                 second_email: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_roles: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an Okta User. This resource allows you to create and configure an Okta User.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        ### Full profile:
        example = okta.user.User("example",
            first_name="John",
            last_name="Smith",
            login="john.smith@example.com",
            email="john.smith@example.com",
            city="New York",
            cost_center="10",
            country_code="US",
            department="IT",
            display_name="Dr. John Smith",
            division="Acquisitions",
            employee_number="111111",
            honorific_prefix="Dr.",
            honorific_suffix="Jr.",
            locale="en_US",
            manager="Jimbo",
            manager_id="222222",
            middle_name="John",
            mobile_phone="1112223333",
            nick_name="Johnny",
            organization="Testing Inc.",
            postal_address="1234 Testing St.",
            preferred_language="en-us",
            primary_phone="4445556666",
            profile_url="https://www.example.com/profile",
            second_email="john.smith.fun@example.com",
            state="NY",
            street_address="5678 Testing Ave.",
            timezone="America/New_York",
            title="Director",
            user_type="Employee",
            zip_code="11111")
        ### With Password Inline Hook:
        test2 = okta.user.User("test2",
            first_name="John",
            last_name="Smith",
            login="example@example.com",
            email="example@example.com",
            password_inline_hook="default")
        ```

        ## Import

        ```sh
        $ pulumi import okta:user/user:User example <user_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] city: User city
        :param pulumi.Input[_builtins.str] cost_center: User cost center
        :param pulumi.Input[_builtins.str] country_code: User country code
        :param pulumi.Input[_builtins.str] custom_profile_attributes: JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin Console or the [Schemas](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) API to manage schema extensions.
        :param pulumi.Input[_builtins.str] department: User department
        :param pulumi.Input[_builtins.str] display_name: User display name, suitable to show end users
        :param pulumi.Input[_builtins.str] division: User division
        :param pulumi.Input[_builtins.str] email: User primary email address
        :param pulumi.Input[_builtins.str] employee_number: User employee number
        :param pulumi.Input[_builtins.bool] expire_password_on_create: If set to `true`, the user will have to change the password at the next login. This property will be used when user is being created and works only when `password` field is set. Default: `false`
        :param pulumi.Input[_builtins.str] first_name: User first name
        :param pulumi.Input[_builtins.str] honorific_prefix: User honorific prefix
        :param pulumi.Input[_builtins.str] honorific_suffix: User honorific suffix
        :param pulumi.Input[_builtins.str] last_name: User last name
        :param pulumi.Input[_builtins.str] locale: User default location
        :param pulumi.Input[_builtins.str] login: User Okta login
        :param pulumi.Input[_builtins.str] manager: Manager of User
        :param pulumi.Input[_builtins.str] manager_id: Manager ID of User
        :param pulumi.Input[_builtins.str] middle_name: User middle name
        :param pulumi.Input[_builtins.str] mobile_phone: User mobile phone number
        :param pulumi.Input[_builtins.str] nick_name: User nickname
        :param pulumi.Input[_builtins.str] old_password: Old User Password. Should be only set in case the password was not changed using the provider. fter successful password change this field should be removed and `password` field should be used for further changes.
        :param pulumi.Input[_builtins.str] organization: User organization
        :param pulumi.Input[_builtins.str] password: User Password
        :param pulumi.Input[Union['UserPasswordHashArgs', 'UserPasswordHashArgsDict']] password_hash: Specifies a hashed password to import into Okta.
        :param pulumi.Input[_builtins.str] password_inline_hook: Specifies that a Password Import Inline Hook should be triggered to handle verification of the user's password the first time the user logs in. This allows an existing password to be imported into Okta directly from some other store. When updating a user with a password hook the user must be in the `STAGED` status. The `password` field should not be specified when using Password Import Inline Hook.
        :param pulumi.Input[_builtins.str] postal_address: User mailing address
        :param pulumi.Input[_builtins.str] preferred_language: User preferred language
        :param pulumi.Input[_builtins.str] primary_phone: User primary phone number
        :param pulumi.Input[_builtins.str] profile_url: User online profile (web page)
        :param pulumi.Input[_builtins.str] recovery_answer: User Password Recovery Answer
        :param pulumi.Input[_builtins.str] recovery_question: User Password Recovery Question
        :param pulumi.Input[_builtins.str] second_email: User secondary email address, used for account recovery
        :param pulumi.Input[_builtins.bool] skip_roles: Do not populate user roles information (prevents additional API call)
        :param pulumi.Input[_builtins.str] state: User state or region
        :param pulumi.Input[_builtins.str] status: User profile property. Valid values are `ACTIVE`, `DEPROVISIONED`, `STAGED`, `SUSPENDED`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] street_address: User street address
        :param pulumi.Input[_builtins.str] timezone: User default timezone
        :param pulumi.Input[_builtins.str] title: User title
        :param pulumi.Input[_builtins.str] user_type: User employee type
        :param pulumi.Input[_builtins.str] zip_code: User zipcode or postal code
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Okta User. This resource allows you to create and configure an Okta User.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        ### Full profile:
        example = okta.user.User("example",
            first_name="John",
            last_name="Smith",
            login="john.smith@example.com",
            email="john.smith@example.com",
            city="New York",
            cost_center="10",
            country_code="US",
            department="IT",
            display_name="Dr. John Smith",
            division="Acquisitions",
            employee_number="111111",
            honorific_prefix="Dr.",
            honorific_suffix="Jr.",
            locale="en_US",
            manager="Jimbo",
            manager_id="222222",
            middle_name="John",
            mobile_phone="1112223333",
            nick_name="Johnny",
            organization="Testing Inc.",
            postal_address="1234 Testing St.",
            preferred_language="en-us",
            primary_phone="4445556666",
            profile_url="https://www.example.com/profile",
            second_email="john.smith.fun@example.com",
            state="NY",
            street_address="5678 Testing Ave.",
            timezone="America/New_York",
            title="Director",
            user_type="Employee",
            zip_code="11111")
        ### With Password Inline Hook:
        test2 = okta.user.User("test2",
            first_name="John",
            last_name="Smith",
            login="example@example.com",
            email="example@example.com",
            password_inline_hook="default")
        ```

        ## Import

        ```sh
        $ pulumi import okta:user/user:User example <user_id>
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 cost_center: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_profile_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_profile_attributes_to_ignores: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 department: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 division: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 employee_number: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_password_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 honorific_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 honorific_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 locale: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 manager: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_id: Optional[pulumi.Input[_builtins.str]] = None,
                 middle_name: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 nick_name: Optional[pulumi.Input[_builtins.str]] = None,
                 old_password: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_hash: Optional[pulumi.Input[Union['UserPasswordHashArgs', 'UserPasswordHashArgsDict']]] = None,
                 password_inline_hook: Optional[pulumi.Input[_builtins.str]] = None,
                 postal_address: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_phone: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_url: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_answer: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_question: Optional[pulumi.Input[_builtins.str]] = None,
                 second_email: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_roles: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 street_address: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["city"] = city
            __props__.__dict__["cost_center"] = cost_center
            __props__.__dict__["country_code"] = country_code
            __props__.__dict__["custom_profile_attributes"] = custom_profile_attributes
            __props__.__dict__["custom_profile_attributes_to_ignores"] = custom_profile_attributes_to_ignores
            __props__.__dict__["department"] = department
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["division"] = division
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["employee_number"] = employee_number
            __props__.__dict__["expire_password_on_create"] = expire_password_on_create
            if first_name is None and not opts.urn:
                raise TypeError("Missing required property 'first_name'")
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["honorific_prefix"] = honorific_prefix
            __props__.__dict__["honorific_suffix"] = honorific_suffix
            if last_name is None and not opts.urn:
                raise TypeError("Missing required property 'last_name'")
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["locale"] = locale
            if login is None and not opts.urn:
                raise TypeError("Missing required property 'login'")
            __props__.__dict__["login"] = login
            __props__.__dict__["manager"] = manager
            __props__.__dict__["manager_id"] = manager_id
            __props__.__dict__["middle_name"] = middle_name
            __props__.__dict__["mobile_phone"] = mobile_phone
            __props__.__dict__["nick_name"] = nick_name
            __props__.__dict__["old_password"] = None if old_password is None else pulumi.Output.secret(old_password)
            __props__.__dict__["organization"] = organization
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["password_hash"] = password_hash
            __props__.__dict__["password_inline_hook"] = password_inline_hook
            __props__.__dict__["postal_address"] = postal_address
            __props__.__dict__["preferred_language"] = preferred_language
            __props__.__dict__["primary_phone"] = primary_phone
            __props__.__dict__["profile_url"] = profile_url
            __props__.__dict__["recovery_answer"] = None if recovery_answer is None else pulumi.Output.secret(recovery_answer)
            __props__.__dict__["recovery_question"] = recovery_question
            __props__.__dict__["second_email"] = second_email
            __props__.__dict__["skip_roles"] = skip_roles
            __props__.__dict__["state"] = state
            __props__.__dict__["status"] = status
            __props__.__dict__["street_address"] = street_address
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["title"] = title
            __props__.__dict__["user_type"] = user_type
            __props__.__dict__["zip_code"] = zip_code
            __props__.__dict__["raw_status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["oldPassword", "password", "recoveryAnswer"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'okta:user/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            city: Optional[pulumi.Input[_builtins.str]] = None,
            cost_center: Optional[pulumi.Input[_builtins.str]] = None,
            country_code: Optional[pulumi.Input[_builtins.str]] = None,
            custom_profile_attributes: Optional[pulumi.Input[_builtins.str]] = None,
            custom_profile_attributes_to_ignores: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            department: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            division: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            employee_number: Optional[pulumi.Input[_builtins.str]] = None,
            expire_password_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
            first_name: Optional[pulumi.Input[_builtins.str]] = None,
            honorific_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            honorific_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            last_name: Optional[pulumi.Input[_builtins.str]] = None,
            locale: Optional[pulumi.Input[_builtins.str]] = None,
            login: Optional[pulumi.Input[_builtins.str]] = None,
            manager: Optional[pulumi.Input[_builtins.str]] = None,
            manager_id: Optional[pulumi.Input[_builtins.str]] = None,
            middle_name: Optional[pulumi.Input[_builtins.str]] = None,
            mobile_phone: Optional[pulumi.Input[_builtins.str]] = None,
            nick_name: Optional[pulumi.Input[_builtins.str]] = None,
            old_password: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            password_hash: Optional[pulumi.Input[Union['UserPasswordHashArgs', 'UserPasswordHashArgsDict']]] = None,
            password_inline_hook: Optional[pulumi.Input[_builtins.str]] = None,
            postal_address: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
            primary_phone: Optional[pulumi.Input[_builtins.str]] = None,
            profile_url: Optional[pulumi.Input[_builtins.str]] = None,
            raw_status: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_answer: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_question: Optional[pulumi.Input[_builtins.str]] = None,
            second_email: Optional[pulumi.Input[_builtins.str]] = None,
            skip_roles: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            street_address: Optional[pulumi.Input[_builtins.str]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None,
            zip_code: Optional[pulumi.Input[_builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] city: User city
        :param pulumi.Input[_builtins.str] cost_center: User cost center
        :param pulumi.Input[_builtins.str] country_code: User country code
        :param pulumi.Input[_builtins.str] custom_profile_attributes: JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin Console or the [Schemas](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) API to manage schema extensions.
        :param pulumi.Input[_builtins.str] department: User department
        :param pulumi.Input[_builtins.str] display_name: User display name, suitable to show end users
        :param pulumi.Input[_builtins.str] division: User division
        :param pulumi.Input[_builtins.str] email: User primary email address
        :param pulumi.Input[_builtins.str] employee_number: User employee number
        :param pulumi.Input[_builtins.bool] expire_password_on_create: If set to `true`, the user will have to change the password at the next login. This property will be used when user is being created and works only when `password` field is set. Default: `false`
        :param pulumi.Input[_builtins.str] first_name: User first name
        :param pulumi.Input[_builtins.str] honorific_prefix: User honorific prefix
        :param pulumi.Input[_builtins.str] honorific_suffix: User honorific suffix
        :param pulumi.Input[_builtins.str] last_name: User last name
        :param pulumi.Input[_builtins.str] locale: User default location
        :param pulumi.Input[_builtins.str] login: User Okta login
        :param pulumi.Input[_builtins.str] manager: Manager of User
        :param pulumi.Input[_builtins.str] manager_id: Manager ID of User
        :param pulumi.Input[_builtins.str] middle_name: User middle name
        :param pulumi.Input[_builtins.str] mobile_phone: User mobile phone number
        :param pulumi.Input[_builtins.str] nick_name: User nickname
        :param pulumi.Input[_builtins.str] old_password: Old User Password. Should be only set in case the password was not changed using the provider. fter successful password change this field should be removed and `password` field should be used for further changes.
        :param pulumi.Input[_builtins.str] organization: User organization
        :param pulumi.Input[_builtins.str] password: User Password
        :param pulumi.Input[Union['UserPasswordHashArgs', 'UserPasswordHashArgsDict']] password_hash: Specifies a hashed password to import into Okta.
        :param pulumi.Input[_builtins.str] password_inline_hook: Specifies that a Password Import Inline Hook should be triggered to handle verification of the user's password the first time the user logs in. This allows an existing password to be imported into Okta directly from some other store. When updating a user with a password hook the user must be in the `STAGED` status. The `password` field should not be specified when using Password Import Inline Hook.
        :param pulumi.Input[_builtins.str] postal_address: User mailing address
        :param pulumi.Input[_builtins.str] preferred_language: User preferred language
        :param pulumi.Input[_builtins.str] primary_phone: User primary phone number
        :param pulumi.Input[_builtins.str] profile_url: User online profile (web page)
        :param pulumi.Input[_builtins.str] raw_status: The raw status of the User in Okta - (status is mapped)
        :param pulumi.Input[_builtins.str] recovery_answer: User Password Recovery Answer
        :param pulumi.Input[_builtins.str] recovery_question: User Password Recovery Question
        :param pulumi.Input[_builtins.str] second_email: User secondary email address, used for account recovery
        :param pulumi.Input[_builtins.bool] skip_roles: Do not populate user roles information (prevents additional API call)
        :param pulumi.Input[_builtins.str] state: User state or region
        :param pulumi.Input[_builtins.str] status: User profile property. Valid values are `ACTIVE`, `DEPROVISIONED`, `STAGED`, `SUSPENDED`. Default: `ACTIVE`
        :param pulumi.Input[_builtins.str] street_address: User street address
        :param pulumi.Input[_builtins.str] timezone: User default timezone
        :param pulumi.Input[_builtins.str] title: User title
        :param pulumi.Input[_builtins.str] user_type: User employee type
        :param pulumi.Input[_builtins.str] zip_code: User zipcode or postal code
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["city"] = city
        __props__.__dict__["cost_center"] = cost_center
        __props__.__dict__["country_code"] = country_code
        __props__.__dict__["custom_profile_attributes"] = custom_profile_attributes
        __props__.__dict__["custom_profile_attributes_to_ignores"] = custom_profile_attributes_to_ignores
        __props__.__dict__["department"] = department
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["division"] = division
        __props__.__dict__["email"] = email
        __props__.__dict__["employee_number"] = employee_number
        __props__.__dict__["expire_password_on_create"] = expire_password_on_create
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["honorific_prefix"] = honorific_prefix
        __props__.__dict__["honorific_suffix"] = honorific_suffix
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["locale"] = locale
        __props__.__dict__["login"] = login
        __props__.__dict__["manager"] = manager
        __props__.__dict__["manager_id"] = manager_id
        __props__.__dict__["middle_name"] = middle_name
        __props__.__dict__["mobile_phone"] = mobile_phone
        __props__.__dict__["nick_name"] = nick_name
        __props__.__dict__["old_password"] = old_password
        __props__.__dict__["organization"] = organization
        __props__.__dict__["password"] = password
        __props__.__dict__["password_hash"] = password_hash
        __props__.__dict__["password_inline_hook"] = password_inline_hook
        __props__.__dict__["postal_address"] = postal_address
        __props__.__dict__["preferred_language"] = preferred_language
        __props__.__dict__["primary_phone"] = primary_phone
        __props__.__dict__["profile_url"] = profile_url
        __props__.__dict__["raw_status"] = raw_status
        __props__.__dict__["recovery_answer"] = recovery_answer
        __props__.__dict__["recovery_question"] = recovery_question
        __props__.__dict__["second_email"] = second_email
        __props__.__dict__["skip_roles"] = skip_roles
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["street_address"] = street_address
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["title"] = title
        __props__.__dict__["user_type"] = user_type
        __props__.__dict__["zip_code"] = zip_code
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def city(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User city
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter(name="costCenter")
    def cost_center(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User cost center
        """
        return pulumi.get(self, "cost_center")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User country code
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter(name="customProfileAttributes")
    def custom_profile_attributes(self) -> pulumi.Output[_builtins.str]:
        """
        JSON formatted custom attributes for a user. It must be JSON due to various types Okta allows. You must first add the custom property to the user profile schema before you reference it. You can use the Profile Editor in the Admin Console or the [Schemas](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UISchema/#tag/UISchema) API to manage schema extensions.
        """
        return pulumi.get(self, "custom_profile_attributes")

    @_builtins.property
    @pulumi.getter(name="customProfileAttributesToIgnores")
    def custom_profile_attributes_to_ignores(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "custom_profile_attributes_to_ignores")

    @_builtins.property
    @pulumi.getter
    def department(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User department
        """
        return pulumi.get(self, "department")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User display name, suitable to show end users
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def division(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User division
        """
        return pulumi.get(self, "division")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        User primary email address
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="employeeNumber")
    def employee_number(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User employee number
        """
        return pulumi.get(self, "employee_number")

    @_builtins.property
    @pulumi.getter(name="expirePasswordOnCreate")
    def expire_password_on_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, the user will have to change the password at the next login. This property will be used when user is being created and works only when `password` field is set. Default: `false`
        """
        return pulumi.get(self, "expire_password_on_create")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[_builtins.str]:
        """
        User first name
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="honorificPrefix")
    def honorific_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User honorific prefix
        """
        return pulumi.get(self, "honorific_prefix")

    @_builtins.property
    @pulumi.getter(name="honorificSuffix")
    def honorific_suffix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User honorific suffix
        """
        return pulumi.get(self, "honorific_suffix")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[_builtins.str]:
        """
        User last name
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter
    def locale(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User default location
        """
        return pulumi.get(self, "locale")

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[_builtins.str]:
        """
        User Okta login
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def manager(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Manager of User
        """
        return pulumi.get(self, "manager")

    @_builtins.property
    @pulumi.getter(name="managerId")
    def manager_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Manager ID of User
        """
        return pulumi.get(self, "manager_id")

    @_builtins.property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User middle name
        """
        return pulumi.get(self, "middle_name")

    @_builtins.property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User mobile phone number
        """
        return pulumi.get(self, "mobile_phone")

    @_builtins.property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User nickname
        """
        return pulumi.get(self, "nick_name")

    @_builtins.property
    @pulumi.getter(name="oldPassword")
    def old_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Old User Password. Should be only set in case the password was not changed using the provider. fter successful password change this field should be removed and `password` field should be used for further changes.
        """
        return pulumi.get(self, "old_password")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User organization
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User Password
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordHash")
    def password_hash(self) -> pulumi.Output[Optional['outputs.UserPasswordHash']]:
        """
        Specifies a hashed password to import into Okta.
        """
        return pulumi.get(self, "password_hash")

    @_builtins.property
    @pulumi.getter(name="passwordInlineHook")
    def password_inline_hook(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies that a Password Import Inline Hook should be triggered to handle verification of the user's password the first time the user logs in. This allows an existing password to be imported into Okta directly from some other store. When updating a user with a password hook the user must be in the `STAGED` status. The `password` field should not be specified when using Password Import Inline Hook.
        """
        return pulumi.get(self, "password_inline_hook")

    @_builtins.property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User mailing address
        """
        return pulumi.get(self, "postal_address")

    @_builtins.property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User preferred language
        """
        return pulumi.get(self, "preferred_language")

    @_builtins.property
    @pulumi.getter(name="primaryPhone")
    def primary_phone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User primary phone number
        """
        return pulumi.get(self, "primary_phone")

    @_builtins.property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User online profile (web page)
        """
        return pulumi.get(self, "profile_url")

    @_builtins.property
    @pulumi.getter(name="rawStatus")
    def raw_status(self) -> pulumi.Output[_builtins.str]:
        """
        The raw status of the User in Okta - (status is mapped)
        """
        return pulumi.get(self, "raw_status")

    @_builtins.property
    @pulumi.getter(name="recoveryAnswer")
    def recovery_answer(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User Password Recovery Answer
        """
        return pulumi.get(self, "recovery_answer")

    @_builtins.property
    @pulumi.getter(name="recoveryQuestion")
    def recovery_question(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User Password Recovery Question
        """
        return pulumi.get(self, "recovery_question")

    @_builtins.property
    @pulumi.getter(name="secondEmail")
    def second_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User secondary email address, used for account recovery
        """
        return pulumi.get(self, "second_email")

    @_builtins.property
    @pulumi.getter(name="skipRoles")
    @_utilities.deprecated("""Because admin_roles has been removed, this attribute is a no op and will be removed""")
    def skip_roles(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Do not populate user roles information (prevents additional API call)
        """
        return pulumi.get(self, "skip_roles")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User state or region
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User profile property. Valid values are `ACTIVE`, `DEPROVISIONED`, `STAGED`, `SUSPENDED`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User street address
        """
        return pulumi.get(self, "street_address")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User default timezone
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User title
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User employee type
        """
        return pulumi.get(self, "user_type")

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User zipcode or postal code
        """
        return pulumi.get(self, "zip_code")

