# generated by datamodel-codegen:
#   filename:  camara-edgecloud-openapi.yaml
#   timestamp: 2025-07-18T11:48:22+00:00

from __future__ import annotations

from enum import Enum
from ipaddress import IPv4Address, IPv6Address
from typing import List, Literal, Optional, Union
from uuid import UUID

from pydantic import BaseModel, Field, RootModel, conint, constr


# FIXME: RootModel should only accept UUID. Limitation coming from i2Edge
class AppId(RootModel[Union[UUID, str]]):
    root: Union[UUID, str] = Field(
        ...,
        description="A globally unique identifier associated with the application.\nEdge Cloud Platform generates this identifier when the\nApplication is submitted.\n",
    )


# FIXME: RootModel should only accept UUID. Limitation coming from i2Edge
class AppInstanceId(RootModel[Union[UUID, str]]):
    root: Union[UUID, str] = Field(
        ...,
        description="A globally unique identifier associated with a running\ninstance of an application.\nEdge Cloud Platform generates this identifier when the\ninstantiation in the Edge Cloud Zone is successful.\n",
    )


class Status(Enum):
    ready = "ready"
    instantiating = "instantiating"
    failed = "failed"
    terminating = "terminating"
    unknown = "unknown"


class AppInstanceName(RootModel[constr(pattern=r"^[A-Za-z][A-Za-z0-9_]{1,63}$")]):  # type: ignore
    root: constr(pattern=r"^[A-Za-z][A-Za-z0-9_]{1,63}$") = Field(
        ..., description="Name of the App instance, scoped to the AppProvider"
    )


class PackageType(Enum):
    QCOW2 = "QCOW2"
    OVA = "OVA"
    CONTAINER = "CONTAINER"
    HELM = "HELM"


class Type(Enum):
    PRIVATEREPO = "PRIVATEREPO"
    PUBLICREPO = "PUBLICREPO"


class AuthType(Enum):
    DOCKER = "DOCKER"
    HTTP_BASIC = "HTTP_BASIC"
    HTTP_BEARER = "HTTP_BEARER"
    NONE = "NONE"


class Protocol(Enum):
    TCP = "TCP"
    UDP = "UDP"
    ANY = "ANY"


class VisibilityType(Enum):
    VISIBILITY_EXTERNAL = "VISIBILITY_EXTERNAL"
    VISIBILITY_INTERNAL = "VISIBILITY_INTERNAL"


class NetworkInterface(BaseModel):
    interfaceId: constr(pattern=r"^[A-Za-z][A-Za-z0-9_]{3,31}$") = Field(
        ...,
        description="Each Port and corresponding traffic protocol\nexposed by the component is identified by a name.\nApplication client on user device requires this to\nuniquley idenify the interface.\n",
    )
    protocol: Protocol = Field(
        ...,
        description="Defines the IP transport communication\nprotocol i.e., TCP, UDP or ANY\n",
    )
    port: conint(ge=1, le=65535) = Field(
        ...,
        description="Port number exposed by the component.\nEdge Cloud Provider may generate a dynamic port\ntowards the component instance which forwards\nexternal traffic to the component port.\n",
    )
    visibilityType: VisibilityType = Field(
        ...,
        description='Defines whether the interface is exposed\nto outer world or not i.e., external, or internal.\nIf this is set to "external", then it is  exposed\nto external applications otherwise it is exposed\ninternally to edge application components within\nedge cloud. When exposed to external world,\nan external dynamic port is assigned for UC traffic\nand mapped to the extPort\n',
    )


class ComponentSpecItem(BaseModel):
    componentName: str = Field(..., description="Component name must be unique with an application")
    networkInterfaces: List[NetworkInterface] = Field(
        ...,
        description='Each application component exposes some ports\neither for external users or for inter component\ncommunication.\nApplication provider is required to specify which ports are\nto be exposed and the type of traffic that will flow through\nthese ports.The underlying platform may assign a dynamic port\nagainst the "extPort" that the application clients will use\nto connect with edge application instance.\n',
        min_length=1,
    )


class AppProvider(RootModel[constr(pattern=r"^[A-Za-z][A-Za-z0-9_]{7,63}$")]):
    root: constr(pattern=r"^[A-Za-z][A-Za-z0-9_]{7,63}$") = Field(
        ..., description="Human readable name of the Application Provider."
    )


class EdgeCloudProvider(RootModel[str]):
    root: str = Field(..., description="Human readable name of the Edge Cloud Provider.")


class EdgeCloudRegion(RootModel[str]):
    root: str = Field(
        ...,
        description="Human readable name of the geographical Edge Cloud Region of\nthe Edge Cloud. Defined by the Edge Cloud Provider.\n",
    )


class EdgeCloudZoneId(RootModel[UUID]):
    root: UUID = Field(
        ...,
        description="Unique identifier created by the Edge Cloud Platform to identify an\nEdge Cloud Zone within an Edge Cloud.\n",
    )


class EdgeCloudZoneName(RootModel[str]):
    root: str = Field(
        ...,
        description="Human readable name of the geographical zone of\nthe Edge Cloud. Defined by the Edge Cloud Provider.\n",
    )


class EdgeCloudZoneStatus(Enum):
    active = "active"
    inactive = "inactive"
    unknown = "unknown"


class ErrorInfo(BaseModel):
    status: int = Field(..., description="HTTP status code returned along with this error response")
    code: str = Field(..., description="Code given to this error")
    message: str = Field(..., description="Detailed error description")


class Fqdn(RootModel[str]):
    root: str = Field(..., description="Full qualified domain name of an application instance\n")


class GpuInfo(BaseModel):
    gpuMemory: int = Field(..., description="GPU memory in mega bytes")
    numGPU: int = Field(..., description="Number of GPUs")


class K8sAddons(BaseModel):
    monitoring: Optional[bool] = Field(
        False, description="Enable monitoring for Kubernetes cluster.", examples=[True]
    )
    ingress: Optional[bool] = Field(
        False, description="Enable ingress for Kubernetes cluster.", examples=[True]
    )


class PrimaryNetwork(BaseModel):
    provider: Optional[str] = Field(None, description="CNI provider name", examples=["cilium"])
    version: Optional[str] = Field(None, description="CNI provider version", examples=["1.13"])


class InterfaceType(Enum):
    netdevice = "netdevice"
    vfio_pci = "vfio-pci"
    interface = "interface"


class AdditionalNetwork(BaseModel):
    name: Optional[str] = Field(None, description="Additional Network Name", examples=["net1"])
    interfaceType: Optional[InterfaceType] = Field(
        None,
        description="Type of additional Interface:\nnetdevice: (SR-IOV) A regular kernel network device in the\n           Network Namespace (netns) of the container\nvfio-pci: (SR-IOV) A PCI network interface directly mounted\n          in the container\ninterface: Additional interface to be used by cni plugins\n           such as macvlan, ipvlan\nNote: The use of SR-IOV interfaces automatically\nconfigure the required kernel parameters for the nodes.\n",
        examples=["vfio-pci"],
    )


class K8sNetworking(BaseModel):
    primaryNetwork: Optional[PrimaryNetwork] = Field(
        None, description="Definition of Kubernetes primary Network"
    )
    additionalNetworks: Optional[List[AdditionalNetwork]] = Field(
        None, description="Additional Networks for the Kubernetes cluster."
    )


class AdditionalStorageItem(BaseModel):
    name: Optional[str] = Field(
        None, description="Name of additional storage resource.", examples=["logs"]
    )
    storageSize: constr(pattern=r"^\d+(GB|MB)$") = Field(
        ...,
        description="Additional persistent volume for the application.",
        examples=["80GB"],
    )
    mountPoint: str = Field(
        ..., description="Location of additional storage resource.", examples=["/logs"]
    )


class AdditionalStorage(RootModel[List[AdditionalStorageItem]]):
    root: List[AdditionalStorageItem] = Field(
        ..., description="Additional storage for the application."
    )


class Vcpu(RootModel[constr(pattern=r"^\d+((\.\d{1,3})|(m))?$")]):
    root: constr(pattern=r"^\d+((\.\d{1,3})|(m))?$") = Field(
        ...,
        description="Number of vcpus in whole (i.e 1), decimal (i.e 0.500) up to\nmillivcpu, or millivcpu (i.e 500m) format.\n",
        examples=["500m"],
    )


class KubernetesClusterRef(RootModel[UUID]):
    root: UUID = Field(
        ...,
        description="A global unique identifier associated with a Kubernetes cluster\ninfrastructure.\n",
        examples=["642f6105-7015-4af1-a4d1-e1ecb8437abc"],
    )


class NodeResources(BaseModel):
    numCPU: int = Field(..., description="Number of whole vcpus for the node.\n", examples=[2])
    memory: int = Field(
        ...,
        description="Amount of system memory in mega bytes for the node.\n",
        examples=[4096],
    )


class KubernetesNodePool(BaseModel):
    name: str = Field(..., description="Human readable name of the Kubernetes Node Pool.")
    numNodes: int = Field(..., description="Number of nodes in the Node Pool.")
    scalable: bool = Field(
        ...,
        description="Indicates if the node pool can be dynamically scaled up by the\nsystem to accomodate more applications, and dynamically scaled\ndown by the system when there are unused resources.\n",
        examples=[False],
    )
    nodeResources: NodeResources = Field(..., description="Resource configuration of a node.")


class InfraKind(Enum):
    kubernetes = "kubernetes"


class Topology(BaseModel):
    minNumberOfNodes: int = Field(
        ...,
        description="Minimum number of worker nodes required by the\napplication.\n",
        examples=[5],
    )
    minNodeCpu: int = Field(
        ...,
        description="Minimum number of vcpus in whole (i.e 1) per cluster\nnode in CPU pool.\n",
        examples=[2],
    )
    minNodeMemory: int = Field(
        ...,
        description="Minimum memory in mega bytes per cluster node in\nCPU pool.\n",
        examples=[1024],
    )


class CpuPool(BaseModel):
    numCPU: int = Field(
        ...,
        description="Total number of vcpus in whole (i.e 1) of CPU pool.\n",
        examples=[1],
    )
    memory: int = Field(..., description="Total memory in mega bytes of CPU pool.", examples=[1024])
    topology: Topology = Field(
        ...,
        description="CPU pool topology defines an application's CPU-based\narchitecture.\nWhen deploying for high availability or redundancy, it\nallows for clustering with a configurable number of nodes\nand minimum CPU/memory resource per Kubernetes node\nrequirements.\n",
    )


class Topology1(BaseModel):
    minNumberOfNodes: int = Field(
        ...,
        description="Minimum number of worker nodes with GPU required by\nthe application.\n",
        examples=[2],
    )
    minNodeCpu: int = Field(
        ...,
        description="Minimum number of vcpus in whole (i.e 1) per cluster\nnode in GPU pool.\n",
        examples=[2],
    )
    minNodeMemory: int = Field(
        ...,
        description="Minimum memory in mega bytes per cluster node in\nGPU pool.\n",
        examples=[1024],
    )
    minNodeGpuMemory: int = Field(
        ...,
        description="Minimum memory in giga bytes per cluster node in GPU pool.",
        examples=[8],
    )


class GpuPool(BaseModel):
    numCPU: int = Field(
        ...,
        description="Total Number of vcpus in whole (i.e 1) of GPU pool.\n",
        examples=[1],
    )
    memory: int = Field(..., description="Total memory in mega bytes of GPU pool.", examples=[1024])
    gpuMemory: int = Field(
        ..., description="Total GPU memory in giga bytes of GPU pool.", examples=[16]
    )
    topology: Topology1 = Field(
        ...,
        description="GPU pool topology defines an application's GPU-based\narchitecture.\nWhen deploying for high availability or redundancy, it\nallows for clustering with a configurable number of nodes\nand minimum CPU/memory/GPU memory resource per Kubernetes\nnode requirements.\n",
    )


class ApplicationResources(BaseModel):
    cpuPool: Optional[CpuPool] = Field(
        None,
        description="CPU Pool refers to the amount of application' resources\nthat is executed in nodes with CPU only. That means the part\nof application that doesn't require GPU or other kind of\nacceleration.\nCPU pool is not mandatory when the application is executed\nexclusively in a GPU pool.\nA CPU pool is composed by CPU and memory.\n",
    )
    gpuPool: Optional[GpuPool] = Field(
        None,
        description="GPU Pool refers to the amount of resources of the application\nthat is executed in nodes with GPU.\nGPU Pool is not mandatory when the application is executed\nexclusively in a CPU pool.\nA GPU pool is composed by memory, CPU and GPU memory\n",
    )


class KubernetesResources(BaseModel):
    infraKind: Literal["kubernetes"] = Field(
        ...,
        description="Type of infrastructure for the application.",
        examples=["kubernetes"],
    )
    applicationResources: ApplicationResources = Field(
        ...,
        description="Application resources define the resources pool required\nby the application to be executed in a Kubernetes clusters.\n",
    )
    isStandalone: bool = Field(
        ...,
        description="Define if the Kubernetes clusters can be reused by other\napplications.\n",
        examples=[False],
    )
    version: Optional[str] = Field(
        None, description="Minimum Kubernetes Version.", examples=["1.29"]
    )
    additionalStorage: Optional[constr(pattern=r"^\d+(GB|MB)$")] = Field(
        None,
        description="Amount of persistent storage allocated to the Kubernetes PVC.\n",
        examples=["80GB"],
    )
    networking: Optional[K8sNetworking] = None
    addons: Optional[K8sAddons] = None


class InfraKind1(Enum):
    virtualMachine = "virtualMachine"


class VmResources(BaseModel):
    infraKind: Literal["virtualMachine"] = Field(
        ...,
        description="Type of infrastructure for the application.",
        examples=["virtualMachine"],
    )
    numCPU: int = Field(..., description="Number of vcpus in whole (i.e 1)\n", examples=[1])
    memory: int = Field(..., description="Memory in mega bytes", examples=[1024])
    additionalStorages: Optional[AdditionalStorage] = None
    gpu: Optional[GpuInfo] = None


class InfraKind2(Enum):
    dockerCompose = "dockerCompose"


class DockerComposeResources(BaseModel):
    infraKind: Literal["dockerCompose"] = Field(
        ...,
        description="Type of infrastructure for the application.",
        examples=["dockerCompose"],
    )
    numCPU: int = Field(..., description="Number of vcpus in whole (i.e 1)\n", examples=[1])
    memory: int = Field(..., description="Memory in mega bytes", examples=[1024])
    storage: Optional[AdditionalStorage] = None
    gpu: Optional[GpuInfo] = None


class InfraKind3(Enum):
    container = "container"


class ContainerResources(BaseModel):
    infraKind: Literal["container"] = Field(
        ...,
        description="Type of infrastructure for the application.",
        examples=["container"],
    )
    numCPU: Vcpu
    memory: int = Field(..., description="Memory in mega bytes", examples=[1024])
    storage: Optional[AdditionalStorage] = None
    gpu: Optional[GpuInfo] = None


class Ipv4Addr(RootModel[IPv4Address]):
    root: IPv4Address = Field(
        ...,
        description="IP of the device. A single IPv4 address may be specified in\ndotted-quad form 1.2.3.4. Only this exact IP number will match the flow\ncontrol rule.\n",
        examples=["192.168.0.1"],
    )


class Ipv6Addr(RootModel[IPv6Address]):
    root: IPv6Address = Field(
        ...,
        description="IP of the device. A single IPv6 address, following IETF 5952\nformat, may be specified like 2001:db8:85a3:8d3:1319:8a2e:370:7344\n",
        examples=["2001:db8:85a3:8d3:1319:8a2e:370:7344"],
    )


class Architecture(Enum):
    x86_64 = "x86_64"
    x86 = "x86"


class Family(Enum):
    RHEL = "RHEL"
    UBUNTU = "UBUNTU"
    COREOS = "COREOS"
    WINDOWS = "WINDOWS"
    OTHER = "OTHER"


class Version(Enum):
    OS_VERSION_UBUNTU_2204_LTS = "OS_VERSION_UBUNTU_2204_LTS"
    OS_VERSION_RHEL_8 = "OS_VERSION_RHEL_8"
    OS_MS_WINDOWS_2022 = "OS_MS_WINDOWS_2022"
    OTHER = "OTHER"


class License(Enum):
    OS_LICENSE_TYPE_FREE = "OS_LICENSE_TYPE_FREE"
    OS_LICENSE_TYPE_ON_DEMAND = "OS_LICENSE_TYPE_ON_DEMAND"
    OTHER = "OTHER"


class OperatingSystem(BaseModel):
    architecture: Architecture = Field(
        ..., description="Type of the OS Architecture", examples=["x86_64"]
    )
    family: Family = Field(..., description="Family to which OS belongs")
    version: Version = Field(..., description="Version of the OS")
    license: License = Field(..., description="License needed to activate the OS")


class Port(RootModel[conint(ge=0)]):
    root: conint(ge=0) = Field(..., description="Port to stablish the connection")


class RequiredResources(
    RootModel[Union[KubernetesResources, VmResources, ContainerResources, DockerComposeResources]]
):
    root: Union[KubernetesResources, VmResources, ContainerResources, DockerComposeResources] = (
        Field(
            ...,
            description="Fundamental hardware requirements to be provisioned by the\nApplication Provider.\n",
            discriminator="infraKind",
        )
    )


class SubmittedApp(BaseModel):
    appId: Optional[AppId] = None


class Uri(RootModel[str]):
    root: str = Field(
        ...,
        description="A Uniform Resource Identifier (URI) as per RFC 3986,\nidentifies the endpoint within an Edge Cloud Zone where the user\nequipment may connect to the selected application instance\n",
        examples=["https://charts.bitnami.com/bitnami/helm/example-chart:0.1.0"],
    )


class AccessEndpoint1(BaseModel):
    port: Port
    fqdn: Fqdn
    ipv4Addresses: Optional[List[Ipv4Addr]] = Field(
        None, description="IP version 4 of an application instance", min_length=1
    )
    ipv6Addresses: Optional[List[Ipv6Addr]] = Field(
        None, description="IP version 6 of an application instance.", min_length=1
    )


class AccessEndpoint2(BaseModel):
    port: Port
    fqdn: Optional[Fqdn] = None
    ipv4Addresses: List[Ipv4Addr] = Field(
        ..., description="IP version 4 of an application instance", min_length=1
    )
    ipv6Addresses: Optional[List[Ipv6Addr]] = Field(
        None, description="IP version 6 of an application instance.", min_length=1
    )


class AccessEndpoint3(BaseModel):
    port: Port
    fqdn: Optional[Fqdn] = None
    ipv4Addresses: Optional[List[Ipv4Addr]] = Field(
        None, description="IP version 4 of an application instance", min_length=1
    )
    ipv6Addresses: List[Ipv6Addr] = Field(
        ..., description="IP version 6 of an application instance.", min_length=1
    )


class AccessEndpoint(RootModel[Union[AccessEndpoint1, AccessEndpoint2, AccessEndpoint3]]):
    root: Union[AccessEndpoint1, AccessEndpoint2, AccessEndpoint3] = Field(
        ...,
        description="Application Endpoint for an especific instance that is\nrunning in an specific Edge Cloud Zone.\n",
    )


class ComponentEndpointInfoItem(BaseModel):
    interfaceId: constr(pattern=r"^[A-Za-z0-9][A-Za-z0-9_]{6,30}[A-Za-z0-9]$") = Field(
        ...,
        description="This is the interface Identifier that Application Provider\ndefines when application is being submitted.\n",
    )
    accessPoints: AccessEndpoint


class AppInstanceInfo(BaseModel):
    name: AppInstanceName
    appId: AppId
    appInstanceId: AppInstanceId
    appProvider: AppProvider
    status: Optional[Status] = Field(
        "unknown",
        description="Status of the application instance (default is 'unknown')",
    )
    componentEndpointInfo: Optional[List[ComponentEndpointInfoItem]] = Field(
        None,
        description="Information about the IP and Port exposed by the\nEdge Cloud Platform.\nApplication Client shall use these access points to reach this\napplication instance\n",
        min_length=1,
    )
    kubernetesClusterRef: Optional[KubernetesClusterRef] = None
    edgeCloudZoneId: EdgeCloudZoneId


class AppRepo(BaseModel):
    type: Type = Field(
        ...,
        description="Application repository and image URI information.\nPUBLICREPO is used of public urls like github, helm repo etc.\nPRIVATEREPO  is used for private repo managed by the application\ndeveloper. Private repo can be accessed by using the app\ndeveloper provided userName and password. Password is\nrecommended to be the personal access token created by developer\ne.g. in Github repo.\n",
    )
    imagePath: Uri
    userName: Optional[str] = Field(
        None,
        description="Username to acces the Helm chart, docker-compose\nfile or VM image repository\n",
    )
    credentials: Optional[constr(max_length=128)] = Field(
        None,
        description="Password or personal access token created by\ndeveloper to acces the app repository. API users can generate\na personal access token e.g. docker clients to use them as\npassword.\n",
    )
    authType: Optional[AuthType] = Field(
        None,
        description='The credentials can also be formatted as a Basic\nauth or Bearer auth in HTTP "Authorization" header.\n',
    )
    checksum: Optional[str] = Field(
        None,
        description="MD5 checksum for VM and file-based images, sha256\ndigest for containers\n",
    )


class AppManifest(BaseModel):
    appId: Optional[AppId] = None
    name: constr(pattern=r"^[A-Za-z][A-Za-z0-9_]{1,63}$") = Field(
        ..., description="Name of the application."
    )
    appProvider: AppProvider
    version: str = Field(..., description="Application version information")
    packageType: PackageType = Field(..., description="Format of the application image package")
    operatingSystem: Optional[OperatingSystem] = None
    appRepo: AppRepo = Field(
        ...,
        description="Repository where Application Provider stores the application image\n",
    )
    requiredResources: RequiredResources
    componentSpec: List[ComponentSpecItem] = Field(
        ...,
        description='Information defined in "appRepo" point to the application\ndescriptor e.g. Helm chart, docker-compose yaml file etc.\nThe descriptor may contain one or more containers and their\nassociated meta-data. A component refers to additional details\nabout these containers to expose the instances of the containers\nto external client applications. App provider can define one or\nmore components (via the associated network port) in componentSpec\ncorresponding to the containers in helm charts or docker-compose\nyaml file as part of app descriptors.\n',
    )


class ClusterInfo(BaseModel):
    name: str = Field(..., description="Name of the Cluster, scoped to the Provider\n")
    provider: AppProvider
    clusterRef: KubernetesClusterRef
    edgeCloudZoneId: EdgeCloudZoneId
    edgeCloudRegion: Optional[EdgeCloudRegion] = None
    version: Optional[str] = Field(None, description="Kubernetes version of the cluster.")
    nodePools: Optional[List[KubernetesNodePool]] = Field(
        None, description="Node Pools in the cluster.", min_length=1
    )


class EdgeCloudZone(BaseModel):
    edgeCloudZoneId: EdgeCloudZoneId
    edgeCloudZoneName: EdgeCloudZoneName
    edgeCloudZoneStatus: Optional[EdgeCloudZoneStatus] = "unknown"
    edgeCloudProvider: EdgeCloudProvider
    edgeCloudRegion: Optional[EdgeCloudRegion] = None


class EdgeCloudZones(RootModel[List[EdgeCloudZone]]):
    root: List[EdgeCloudZone] = Field(
        ...,
        description="A collection of Edge Cloud Zones where the Application Provider can\ninstantiate an Application Instance.\n",
        min_length=1,
    )
