# EyeDentify3D: A Python package for gaze behavior classification of mobile eye-tracking data

<a href="https://opensource.org/licenses/MIT"><img src="https://img.shields.io/badge/license-MIT-success" alt="License"/></a>
[![Build status](https://github.com/EveCharbie/EyeDentify3d/actions/workflows/run_tests.yml/badge.svg)](https://github.com/EveCharbie/EyeDentify3d/actions)
[![codecov](https://codecov.io/gh/EveCharbie/EyeDentify3d/graph/badge.svg?token=BP4B2TCZXI)](https://codecov.io/gh/EveCharbie/EyeDentify3d)

![Animation](docs/figures/animation.gif)

## Installation
The easiest way to install `EyeDentify3D` is to use pip:
```bash
pip install eyedentify3d
```

If you prefer to install from source, you can clone the repository and create a conda environment with the required dependencies:
```bash
conda env create -f environment.yml
```

## Documentation
you can find the paper accompanying our JOSS submission [here](paper/paper.pdf) and a deeper documentation of the 
package features and underlying mathematical choices [here](https://evecharbie.github.io/EyeDentify3d).

## Examples
Examples of usage can be found in the [examples](examples/) directory.

## Citation
If you use `EyeDentify3D` in your research, please cite the following paper:
```bibtex
@article{Charbonneau2025EyeDentify3D,
  title={EyeDentify3D: A Python package for gaze behavior classification of mobile eye-tracking data},
  author={Charbonneau, Eve and Romeas, Thomas and Trempe, Maxime},
  journal={Submitted to Journal of Open Source Software},
}
```

