from dnalib.log import log
from .utils import Utils

class FileUtils:

    @staticmethod
    def load_files_dataframe(file_path, ascending=False):
        files_dataframe = None       
        try:            
            files_dataframe = (
                Utils.spark_instance().createDataFrame(Utils.dbutils().fs.ls(file_path))                
                .select('path', 'name', 'modificationTime')
                .orderBy("modificationTime", ascending=ascending)
                .select('path', 'name')                
            )
        except Exception as e:
            log(__name__).error(f"Unable to load files for path {file_path}: {e}")            
            raise Exception(f"Unable to load files for path {file_path}")

        return files_dataframe

    @staticmethod
    def last_file_by_extension(file_path, extension):
        files_dataframe = FileUtils.load_files_dataframe(file_path)
        files_dataframe = files_dataframe.filter(f"lower(name) like '%{extension}'")
        return files_dataframe.first()["path"]

    @staticmethod
    def export_dataframe(df, file_name, **kwargs):
        # use tmp file path to export dataframe
        tmp_file_path = f'/tmp/{file_name}'
        df.repartition(1).write.mode('overwrite').save(tmp_file_path, **kwargs)
        # determine extension based on filename
        file_extension = file_name[file_name.rfind('.'):]
        # get the file name generated by the export
        file_path = FileUtils.last_file_by_extension(f"{tmp_file_path}/", file_extension)
        return file_path



