# pylint: skip-file
# auto generated, do not modify
from cchdo.params import CFStandardName as CFStandardNameDC
cf_standard_names = dict()
names = [
CFStandardNameDC(
name='acoustic_signal_roundtrip_travel_time_in_sea_water',
canonical_units='s',
grib=None,
amip=None,
description='The quantity with standard name acoustic_signal_roundtrip_travel_time_in_sea_water is the time taken for an acoustic signal to propagate from the emitting instrument to a reflecting surface and back again to the instrument. In the case of an instrument based on the sea floor and measuring the roundtrip time to the sea surface, the data are commonly used as a measure of ocean heat content.',
),
CFStandardNameDC(
name='aerodynamic_particle_diameter',
canonical_units='m',
grib=None,
amip=None,
description='The diameter of a spherical particle with density 1000 kg m-3 having the same aerodynamic properties as the particles in question.',
),
CFStandardNameDC(
name='aerodynamic_resistance',
canonical_units='m-1 s',
grib=None,
amip=None,
description='The "aerodynamic_resistance" is the resistance to mixing through the boundary layer toward the surface by means of the dominant process, turbulent transport. Reference: Wesely, M. L., 1989,  doi:10.1016/0004-6981(89)90153-4.',
),
CFStandardNameDC(
name='age_of_sea_ice',
canonical_units='year',
grib=None,
amip=None,
description='"Age of sea ice" means the length of time elapsed since the ice formed. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='age_of_stratospheric_air',
canonical_units='s',
grib=None,
amip=None,
description='"Age of stratospheric air" means an estimate of the time since a parcel of stratospheric air was last in contact with the troposphere.',
),
CFStandardNameDC(
name='age_of_surface_snow',
canonical_units='day',
grib=None,
amip=None,
description='"Age of surface snow" means the length of time elapsed since the snow accumulated on the earth\'s surface. Surface snow refers to the snow on the solid ground or on surface ice cover, but excludes, for example, falling snowflakes and snow on plants.',
),
CFStandardNameDC(
name='aggregate_quality_flag',
canonical_units='1',
grib=None,
amip=None,
description='This flag is an algorithmic combination of the results of all relevant quality tests run for the related ancillary parent data variable. The linkage between the data variable and this variable is achieved using the ancillary_variables attribute. The aggregate quality flag provides a summary of all quality tests performed on the data variable (both automated and manual) whether present in the dataset as independent ancillary variables to the parent data variable or not.',
),
CFStandardNameDC(
name='air_density',
canonical_units='kg m-3',
grib=None,
amip=None,
description=None,
),
CFStandardNameDC(
name='air_equivalent_potential_temperature',
canonical_units='K',
grib=None,
amip=None,
description='The "equivalent potential temperature" is a thermodynamic quantity, with its natural logarithm proportional to the entropy of moist air, that is conserved in a reversible moist adiabatic process. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Equivalent_potential_temperature. It is the temperature of a parcel of air if all the moisture contained in it were first condensed, releasing latent heat, before moving the parcel dry adiabatically to a standard pressure, typically representative of mean sea level pressure. To specify the standard pressure to which the quantity applies, provide a scalar coordinate variable with standard name reference_pressure.',
),
CFStandardNameDC(
name='air_equivalent_temperature',
canonical_units='K',
grib=None,
amip=None,
description='The equivalent temperature is the temperature that an air parcel would have if all water vapor were condensed at contstant pressure and the enthalpy released from the vapor used to heat the air. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Equivalent_temperature. It is the isobaric equivalent temperature and not the adiabatic equivalent temperature, also known as pseudoequivalent temperature, which has the standard name air_pseudo_equivalent_temperature.',
),
CFStandardNameDC(
name='air_potential_temperature',
canonical_units='K',
grib='13',
amip='theta',
description='Air potential temperature is the temperature a parcel of air would have if moved dry adiabatically to a standard pressure, typically representative of mean sea level pressure. To specify the standard pressure to which the quantity applies, provide a scalar coordinate variable with standard name reference_pressure.',
),
CFStandardNameDC(
name='air_pressure',
canonical_units='Pa',
grib='1',
amip='plev',
description='Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='air_pressure_anomaly',
canonical_units='Pa',
grib='26',
amip=None,
description='The term "anomaly" means difference from climatology. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='air_pressure_at_cloud_base',
canonical_units='Pa',
grib=None,
amip=None,
description='The phrase "cloud_base" refers to the base of the lowest cloud. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='air_pressure_at_cloud_top',
canonical_units='Pa',
grib=None,
amip=None,
description='The phrase "cloud_top" refers to the top of the highest cloud. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='air_pressure_at_convective_cloud_base',
canonical_units='Pa',
grib=None,
amip=None,
description='The phrase "cloud_base" refers to the base of the lowest cloud. Convective cloud is that produced by the convection schemes in an atmosphere model. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='air_pressure_at_convective_cloud_top',
canonical_units='Pa',
grib=None,
amip=None,
description='The phrase "cloud_top" refers to the top of the highest cloud. Convective cloud is that produced by the convection schemes in an atmosphere model. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='air_pressure_at_freezing_level',
canonical_units='Pa',
grib=None,
amip=None,
description='Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='air_pressure_at_mean_sea_level',
canonical_units='Pa',
grib='2 E151',
amip='psl',
description='Air pressure at sea level is the quantity often abbreviated as MSLP or PMSL. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation. "Mean sea level" means the time mean of sea surface elevation at a given location over an arbitrary period sufficient to eliminate the tidal signals.',
),
CFStandardNameDC(
name='air_pressure_at_top_of_atmosphere_model',
canonical_units='Pa',
grib=None,
amip=None,
description='"Top of atmosphere model" means the upper boundary of the top layer of an atmosphere model. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='air_pseudo_equivalent_potential_temperature',
canonical_units='K',
grib='14',
amip=None,
description='The pseudoequivalent potential temperature is the temperature a parcel of air would have if it is expanded by a pseudoadiabatic (irreversible moist-adiabatic) process to zero pressure and afterwards compressed by a dry-adiabatic process to a standard pressure, typically representative of mean sea level pressure. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Pseudoequivalent_potential_temperature. A pseudoadiabatic process means that the liquid water that condenses is assumed to be removed as soon as it is formed. Reference: AMS Glossary http:/glossary.ametsoc.org/wiki/Pseudoadiabatic_process. To specify the standard pressure to which the quantity applies, provide a scalar coordinate variable with the standard name reference_pressure.',
),
CFStandardNameDC(
name='air_pseudo_equivalent_temperature',
canonical_units='K',
grib=None,
amip=None,
description='The pseudoequivalent temperature is also known as the adiabatic equivalent temperature. It is the temperature that an air parcel would have after undergoing the following process: dry-adiabatic expansion until saturated; pseudoadiabatic expansion until all moisture is precipitated out; dry-adiabatic compression to the initial pressure. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Equivalent_temperature. This quantity is distinct from the isobaric equivalent temperature, also known as equivalent temperature, which has the standard name air_equivalent_temperature.',
),
CFStandardNameDC(
name='air_temperature',
canonical_units='K',
grib='11 E130',
amip='ta',
description='Air temperature is the bulk temperature of the air, not the surface (skin) temperature.',
),
CFStandardNameDC(
name='air_temperature_anomaly',
canonical_units='K',
grib='25',
amip=None,
description='"anomaly" means difference from climatology. Air temperature is the bulk temperature of the air, not the surface (skin) temperature.',
),
CFStandardNameDC(
name='air_temperature_at_cloud_top',
canonical_units='K',
grib=None,
amip=None,
description='cloud_top refers to the top of the highest cloud. Air temperature is the bulk temperature of the air, not the surface (skin) temperature.',
),
CFStandardNameDC(
name='air_temperature_at_effective_cloud_top_defined_by_infrared_radiation',
canonical_units='K',
grib=None,
amip=None,
description='The "effective cloud top defined by infrared radiation" is (approximately) the geometric height above the surface that is one optical depth at infrared wavelengths (in the region of 11 micrometers) below the cloud top that would be detected by visible and lidar techniques. Reference: Minnis, P. et al 2011 CERES Edition-2 Cloud Property Retrievals Using TRMM VIRS and Terra and Aqua MODIS Data x2014; Part I: Algorithms IEEE Transactions on Geoscience and Remote Sensing, 49(11), 4374-4400. doi: http://dx.doi.org/10.1109/TGRS.2011.2144601.',
),
CFStandardNameDC(
name='air_temperature_lapse_rate',
canonical_units='K m-1',
grib='19',
amip=None,
description='Air temperature is the bulk temperature of the air, not the surface (skin) temperature. A lapse rate is the negative derivative of a quantity with respect to increasing height above the surface, or the (positive) derivative with respect to increasing depth.',
),
CFStandardNameDC(
name='air_temperature_threshold',
canonical_units='K',
grib=None,
amip=None,
description='Air temperature is the bulk temperature of the air, not the surface (skin) temperature. Air temperature excess and deficit are calculated relative to the air temperature threshold.',
),
CFStandardNameDC(
name='altimeter_range',
canonical_units='m',
grib=None,
amip=None,
description='An altimeter operates by sending out a short pulse of radiation and measuring the time required for the pulse to return from the sea surface; this measurement is used to calculate the distance between the instrument and the sea surface.  That measurement is called the "altimeter range" and does not include any range corrections.',
),
CFStandardNameDC(
name='altimeter_range_correction_due_to_dry_troposphere',
canonical_units='m',
grib=None,
amip=None,
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.   To apply the altimeter range correction it must be added to the quantity with standard name altimeter_range.  "Correction_due_to_dry_troposphere" means a correction for dry gases in the troposphere, i.e. excluding the effect of liquid water.  Additional altimeter range corrections are given by the quantities with standard names altimeter_range_correction_due_to_wet_troposphere, altimeter_range_correction_due_to_ionosphere, sea_surface_height_correction_due_to_air_pressure_at_low_frequency and sea_surface_height_correction_due_to_air_pressure_and_wind_at_high_frequency.',
),
CFStandardNameDC(
name='altimeter_range_correction_due_to_ionosphere',
canonical_units='m',
grib=None,
amip=None,
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.   To apply the altimeter range correction it must be added to the quantity with standard name altimeter_range.  "Correction_due_to_ionosphere" means a correction for the atmosphere\'s electron content in the ionosphere. Additional altimeter range corrections are given by the quantities with standard names altimeter_range_correction_due_to_wet_troposphere, altimeter_range_correction_due_to_dry_troposphere, sea_surface_height_correction_due_to_air_pressure_at_low_frequency and sea_surface_height_correction_due_to_air_pressure_and_wind_at_high_frequency.',
),
CFStandardNameDC(
name='altimeter_range_correction_due_to_wet_troposphere',
canonical_units='m',
grib=None,
amip=None,
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.   To apply the altimeter range correction it must be added to the quantity with standard name altimeter_range.  "Correction_due_to_wet_troposphere" means a correction for the effect of liquid water in the troposphere.  Additional altimeter range corrections are given by the quantities with standard names altimeter_range_correction_due_to_dry_troposphere, altimeter_range_correction_due_to_ionosphere, sea_surface_height_correction_due_to_air_pressure_at_low_frequency and sea_surface_height_correction_due_to_air_pressure_and_wind_at_high_frequency.',
),
CFStandardNameDC(
name='altitude',
canonical_units='m',
grib='8',
amip=None,
description='Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level.',
),
CFStandardNameDC(
name='altitude_at_top_of_atmosphere_model',
canonical_units='m',
grib=None,
amip=None,
description='Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level. "Top of atmosphere model" means the upper boundary of the top layer of an atmosphere model.',
),
CFStandardNameDC(
name='altitude_at_top_of_dry_convection',
canonical_units='m',
grib=None,
amip=None,
description='Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level.',
),
CFStandardNameDC(
name='amplitude_of_global_average_sea_level_change',
canonical_units='m',
grib=None,
amip=None,
description='Global average sea level change is due to change in volume of the water in the ocean, caused by mass and/or density change, or to change in the volume of the ocean basins, caused by tectonics etc. It is sometimes called "eustatic", which is a term that also has other definitions. It differs from the change in the global average sea surface height relative to the centre of the Earth by the global average vertical movement of the ocean floor. Zero sea level change is an arbitrary level. Amplitude is the magnitude of a wave modelled by a sinusoidal function. A coordinate variable of harmonic_period should be used to specify the period of the sinusoidal wave. Because global average sea level change quantifies the change in volume of the world ocean, it is not calculated necessarily by considering local changes in mean sea level.',
),
CFStandardNameDC(
name='angle_of_emergence',
canonical_units='degree',
grib=None,
amip=None,
description='The angle of emergence is that between the direction of a beam of radiation emerging from the surface of a medium and the normal to that surface.',
),
CFStandardNameDC(
name='angle_of_incidence',
canonical_units='degree',
grib=None,
amip=None,
description='The angle of incidence is that between the direction of approach of a beam of radiation toward a surface and the normal to that surface.',
),
CFStandardNameDC(
name='angle_of_rotation_from_east_to_x',
canonical_units='degree',
grib=None,
amip=None,
description='The quantity with standard name angle_of_rotation_from_east_to_x is the angle, anticlockwise reckoned positive, between due East and (dr/di)jk, where r(i,j,k) is the vector 3D position of the point with coordinate indices (i,j,k).  It could be used for rotating vector fields between model space and latitude-longitude space.',
),
CFStandardNameDC(
name='angle_of_rotation_from_east_to_y',
canonical_units='degree',
grib=None,
amip=None,
description='The quantity with standard name angle_of_rotation_from_east_to_y is the angle, anticlockwise reckoned positive, between due East and (dr/dj)ik, where r(i,j,k) is the vector 3D position of the point with coordinate indices (i,j,k).  It could be used for rotating vector fields between model space and latitude-longitude space.',
),
CFStandardNameDC(
name='angle_of_rotation_from_solar_azimuth_to_platform_azimuth',
canonical_units='degree',
grib=None,
amip=None,
description='An angle of rotation is reckoned positive in the anticlockwise direction. The "angle_of_rotation_from_solar_azimuth_to_platform_azimuth" is the angle of rotation between the solar azimuth angle and the platform azimuth angle. Solar azimuth angle is the horizontal angle between the line of sight from the observation point to the sun and a reference direction at the observation point, which is often due north. The angle is measured clockwise, starting from the reference direction. Platform azimuth angle is the horizontal angle between the line of sight from the observation point to the platform and a reference direction at the observation point, which is often due north. The angle is measured clockwise, starting from the reference direction. A "platform" is a structure or vehicle that serves as a base for mounting sensors. Platforms include, but are not limited to, satellites, aeroplanes, ships, buoys, instruments, ground stations, and masts.',
),
CFStandardNameDC(
name='angstrom_exponent_of_ambient_aerosol_in_air',
canonical_units='1',
grib=None,
amip=None,
description='The "Angstrom exponent" appears in the formula relating aerosol optical thickness to the wavelength of incident radiation: T(lambda) = T(lambda0) * [lambda/lambda0] ** (-1 * alpha) where alpha is the Angstrom exponent, lambda is the wavelength of incident radiation, lambda0 is a reference wavelength, T(lambda) and T(lambda0) are the values of aerosol optical thickness at wavelengths lambda and lambda0, respectively. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='apparent_oxygen_utilization',
canonical_units='mol kg-1',
grib=None,
amip=None,
description='Apparent Oxygen Utilization (AOU) is the difference between measured dissolved oxygen concentration in water, and the equilibrium saturation concentration of dissolved oxygen in water with the same physical and chemical properties. Reference: Broecker, W. S. and T. H. Peng (1982), Tracers in the Sea, Lamont-Doherty Earth Observatory, Palisades, N. Y.',
),
CFStandardNameDC(
name='area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. To specify which area is quantified by a variable with standard name area_fraction, provide a coordinate variable or scalar coordinate variable with standard name area_type. Alternatively, if one is defined, use a more specific standard name of X_area_fraction for the fraction of horizontal area occupied by X.',
),
CFStandardNameDC(
name='area_fraction_below_surface',
canonical_units='1',
grib=None,
amip='psbg',
description='The quantity with standard name area_fraction_below_surface is the fraction of horizontal area where a given isobaric surface is below the (ground or sea) surface. "Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. The surface called "surface" means the lower boundary of the atmosphere.',
),
CFStandardNameDC(
name='area_fraction_of_day_defined_by_solar_zenith_angle',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. A coordinate variable of solar_zenith_angle indicating the day extent should be specified. Solar zenith angle is the the angle between the line of sight to the sun and the local vertical.',
),
CFStandardNameDC(
name='area_fraction_of_night_defined_by_solar_zenith_angle',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. A coordinate variable of solar_zenith_angle indicating the day extent should be specified. Solar zenith angle is the the angle between the line of sight to the sun and the local vertical.',
),
CFStandardNameDC(
name='area_fraction_of_twilight_defined_by_solar_zenith_angle',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. A coordinate variable of solar_zenith_angle indicating the day extent should be specified. Solar zenith angle is the the angle between the line of sight to the sun and the local vertical.',
),
CFStandardNameDC(
name='area_type',
canonical_units=None,
grib=None,
amip=None,
description='A variable with the standard_name of area_type contains either strings which indicate the nature of the surface e.g. land, sea, sea_ice, or flags which can be translated to strings using flag_values and flag_meanings attributes. These strings are standardised. Values must be taken from the area_type table.',
),
CFStandardNameDC(
name='asymmetry_factor_of_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The asymmetry factor is the angular integral of the aerosol scattering phase function weighted by the cosine of the angle with the incident radiation flux. The asymmetry coefficient is assumed to be an integral over all wavelengths, unless a coordinate of radiation_wavelength is included to specify the wavelength. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='atmosphere_absorption_optical_thickness_due_to_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Absorption optical thickness" means that part of the atmosphere optical thickness that is caused by the absorption of incident radiation. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_absorption_optical_thickness_due_to_black_carbon_ambient_aerosol',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path.  A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Absorption optical thickness" means that part of the atmosphere optical thickness that is caused by the absorption of incident radiation. "Aerosol" means the suspended liquid or solid particles in air (except cloud droplets).  "Ambient aerosol" is aerosol that has taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the aerosol. The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity  named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_absorption_optical_thickness_due_to_dust_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Absorption optical thickness" means that part of the atmosphere optical thickness that is caused by the absorption of incident radiation. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_absorption_optical_thickness_due_to_particulate_organic_matter_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Absorption optical thickness" means that part of the atmosphere optical thickness that is caused by the absorption of incident radiation. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_absorption_optical_thickness_due_to_sea_salt_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Absorption optical thickness" means that part of the atmosphere optical thickness that is caused by the absorption of incident radiation. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_absorption_optical_thickness_due_to_sulfate_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Absorption optical thickness" means that part of the atmosphere optical thickness that is caused by the absorption of incident radiation. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_boundary_layer_thickness',
canonical_units='m',
grib=None,
amip='zmla',
description='The atmosphere boundary layer thickness is the "depth" or "height" of the (atmosphere) planetary boundary layer.',
),
CFStandardNameDC(
name='atmosphere_convective_available_potential_energy',
canonical_units='J kg-1',
grib=None,
amip=None,
description='Convective(ly) available potential energy (often abbreviated CAPE) is a stability measure calculated by integrating the positive temperature difference between the surrounding atmosphere and a parcel of air lifted adiabatically from a given starting height to its equilibrium level. A coordinate variable of original_air_pressure_of_lifted_parcel should be specified to indicate the starting height of the lifted parcel. CAPE exists under conditions of potential instability, and measures the potential energy per unit mass that would be released by the unstable parcel if it were able to convect upwards to equilibrium.',
),
CFStandardNameDC(
name='atmosphere_convective_available_potential_energy_wrt_surface',
canonical_units='J kg -1',
grib=None,
amip=None,
description='Convective(ly) available potential energy (often abbreviated CAPE) is a stability measure calculated by integrating the positive temperature difference between the surrounding atmosphere and a parcel of air lifted adiabatically from the surface to its equilibrium level. CAPE exists under conditions of potential instability, and measures the potential energy per unit mass that would be released by the unstable parcel if it were able to convect upwards to equilibrium.',
),
CFStandardNameDC(
name='atmosphere_convective_inhibition',
canonical_units='J kg -1',
grib=None,
amip=None,
description='Convective inhibition is the amount of energy per unit mass required to overcome the negatively buoyant energy exerted by the environment on a parcel of air.  Convective inhibition is often abbreviated as "CIN" or "CINH".  It is calculated by integrating the negative temperature difference between the surrounding atmosphere and a parcel of air lifted adiabatically from a given starting height to its equilibrium level. A coordinate variable of original_air_pressure_of_lifted_parcel should be specified to indicate the starting height of the lifted parcel.',
),
CFStandardNameDC(
name='atmosphere_convective_inhibition_wrt_surface',
canonical_units='J kg -1',
grib=None,
amip=None,
description='Convective inhibition is the amount of energy per unit mass required to overcome the negatively buoyant energy exerted by the environment on a parcel of air.  Convective inhibition is often abbreviated as "CIN" or "CINH".  It is calculated by integrating the negative temperature difference between the surrounding atmosphere and a parcel of air lifted adiabatically from the surface to its equilibrium level.',
),
CFStandardNameDC(
name='atmosphere_downdraft_convective_mass_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.  The atmosphere convective mass flux is the vertical transport of mass for a field of cumulus clouds or thermals, given by the product of air density and vertical velocity. For an area-average, cell_methods should specify whether the average is over all the area or the area of updrafts and/or downdrafts only.  "Downdraft" means that the flux is positive in the downward direction (negative upward).',
),
CFStandardNameDC(
name='atmosphere_dry_energy_content',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. Dry energy is the sum of dry static energy and kinetic energy. Dry static energy is the sum of enthalpy and potential energy (itself the sum of gravitational and centripetal potential energy). Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='atmosphere_dry_static_energy_content',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. Dry static energy is the sum of enthalpy and potential energy (itself the sum of gravitational and centripetal potential energy). Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='atmosphere_eastward_stress_due_to_gravity_wave_drag',
canonical_units='Pa',
grib=None,
amip='tauugwd',
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). Atmosphere_Xward_stress is a stress which tends to accelerate the atmosphere in direction X.',
),
CFStandardNameDC(
name='atmosphere_energy_content',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "Atmosphere energy content" has not yet been precisely defined! Please express your views on this quantity on the CF email list.',
),
CFStandardNameDC(
name='atmosphere_enthalpy_content',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='atmosphere_heat_diffusivity',
canonical_units='m2 s-1',
grib=None,
amip=None,
description=None,
),
CFStandardNameDC(
name='atmosphere_horizontal_streamfunction',
canonical_units='m2 s-1',
grib='35',
amip=None,
description='"Horizontal" indicates that the streamfunction applies to a horizontal velocity field on a particular vertical level.',
),
CFStandardNameDC(
name='atmosphere_horizontal_velocity_potential',
canonical_units='m2 s-1',
grib='36',
amip=None,
description='A velocity is a vector quantity. "Horizontal" indicates that the velocity potential applies to a horizontal velocity field on a particular vertical level.',
),
CFStandardNameDC(
name='atmosphere_hybrid_height_coordinate',
canonical_units='m',
grib=None,
amip=None,
description='See Appendix D of the CF convention for information about parametric vertical coordinates.',
),
CFStandardNameDC(
name='atmosphere_hybrid_sigma_pressure_coordinate',
canonical_units='1',
grib=None,
amip=None,
description='See Appendix D of the CF convention for information about parametric vertical coordinates.',
),
CFStandardNameDC(
name='atmosphere_kinetic_energy_content',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.',
),
CFStandardNameDC(
name='atmosphere_level_of_free_convection',
canonical_units='m',
grib=None,
amip=None,
description='The level of free convection is the altitude where the temperature of the environment decreases faster than the moist adiabatic lapse rate of a saturated air parcel at the same level.  It is calculated by lifting a parcel of air dry adiabatically to the LCL (lifted condensation level), then moist adiabatically until the parcel temperature is equal to the ambient temperature. A coordinate variable of original_air_pressure_of_lifted_parcel should be specified to indicate the starting height of the lifted parcel.',
),
CFStandardNameDC(
name='atmosphere_level_of_free_convection_wrt_surface',
canonical_units='m',
grib=None,
amip=None,
description='The level of free convection is the altitude where the temperature of the environment decreases faster than the moist adiabatic lapse rate of a saturated air parcel at the same level.  It is calculated by lifting a parcel of air dry adiabatically from the surface to the LCL (lifting condensation level), then moist adiabatically until the parcel temperature is equal to the ambient temperature.',
),
CFStandardNameDC(
name='atmosphere_lifting_condensation_level',
canonical_units='m',
grib=None,
amip=None,
description='The lifting condensation level is the height at which the relative humidity of an air parcel cooled by dry adiabatic lifting would reach 100%. A coordinate variable of original_air_pressure_of_lifted_parcel should be specified to indicate the starting height of the lifted parcel.',
),
CFStandardNameDC(
name='atmosphere_lifting_condensation_level_wrt_surface',
canonical_units='m',
grib=None,
amip=None,
description='The lifting condensation level is the height at which the relative humidity of an air parcel cooled by dry adiabatic lifting from the surface would reach 100%.',
),
CFStandardNameDC(
name='atmosphere_ln_pressure_coordinate',
canonical_units='1',
grib=None,
amip=None,
description='"ln_X" means natural logarithm of X. X must be dimensionless. See Appendix D of the CF convention for information about parametric vertical coordinates.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_acetic_acid',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for acetic_acid is CH3COOH. The IUPAC name for acetic acid is ethanoic acid.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_aceto_nitrile',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for aceto-nitrile is CH3CN. The IUPAC name for aceto-nitrile is ethanenitrile.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_alkanes',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  Alkanes are saturated hydrocarbons, i.e. they do not contain any chemical double bonds.  Alkanes contain only hydrogen and carbon combined in the general proportions C(n)H(2n+2); "alkanes" is the term used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names exist for some individual alkane species, e.g., methane and ethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_alkenes',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  Alkenes are unsaturated hydrocarbons as they contain chemical double bonds between adjacent carbon atoms.  Alkenes contain only hydrogen and carbon combined in the general proportions C(n)H(2n); "alkenes" is the term used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names exist for some individual alkene species, e.g., ethene and propene.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_alpha_hexachlorocyclohexane',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for alpha_hexachlorocyclohexane is C6H6Cl6.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_alpha_pinene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for alpha_pinene is C10H16. The IUPAC name for alpha-pinene is (1S,5S)-2,6,6-trimethylbicyclo[3.1.1]hept-2-ene.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_ammonia',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for ammonia is NH3.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_ammonium_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for ammonium is NH4.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_anthropogenic_nmvoc_expressed_as_carbon',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Anthropogenic" means influenced, caused, or created by human activity. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_aromatic_compounds',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  Aromatic compounds in organic chemistry are compounds that contain at least one benzene ring of six carbon atoms joined by alternating single and double covalent bonds.  The simplest aromatic compound is benzene itself.  In standard names "aromatic_compounds" is the term used to describe the group of aromatic chemical species that  are represented within a given model.  The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.  Standard names exist for some individual aromatic species, e.g. benzene and xylene.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_atomic_bromine',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical symbol for atomic bromine is Br.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_atomic_chlorine',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical symbol for atomic chlorine is Cl.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_atomic_nitrogen',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical symbol for atomic nitrogen is N.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_benzene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for benzene is C6H6.  Benzene is the simplest aromatic hydrocarbon and has a ring structure consisting of six carbon atoms joined by alternating single and double chemical bonds. Each carbon atom is additionally bonded to one hydrogen atom. There are standard names that refer to aromatic_compounds as a group, as well as those for individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_beta_pinene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for beta_pinene is C10H16.  The IUPAC name for beta-pinene is (1S,5S)-6,6-dimethyl-2-methylenebicyclo[3.1.1]heptane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_biogenic_nmvoc_expressed_as_carbon',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Biogenic" means influenced, caused, or created by natural processes. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_bromine_chloride',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for bromine chloride is BrCl.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_bromine_monoxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for bromine monoxide is BrO.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_bromine_nitrate',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for bromine nitrate is BrONO2. The chemical formula for the nitrate anion is NO3-.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_brox_expressed_as_bromine',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer are used". "Brox"  describes a family of chemical species consisting of inorganic bromine compounds with the exception of hydrogen bromide (HBr) and bromine nitrate (BrONO2). The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Brox" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity with a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Inorganic bromine", sometimes referred to as Bry, describes a family of chemical species which result from the degradation of source gases containing bromine (halons, methyl bromide, VSLS) and natural inorganic bromine sources such as volcanoes, sea salt and other aerosols. Standard names that use the term "inorganic_bromine" are used for quantities that contain all inorganic bromine species including HCl and ClONO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_butane',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for butane is C4H10. Butane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_carbon_dioxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for carbon dioxide is CO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_carbon_monoxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula of carbon monoxide is CO.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_carbon_tetrachloride',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula of carbon tetrachloride is CCl4. The IUPAC name for carbon tetrachloride is tetrachloromethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cfc11',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The mass is the total mass of the molecules. The chemical formula of CFC11 is CFCl3. The IUPAC name for CFC11 is trichloro(fluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cfc113',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including  "content_of_atmosphere_layer" are used. The mass is the total mass of the molecules. The chemical formula of CFC113 is CCl2FCClF2. The IUPAC name for CFC113 is 1,1,2-trichloro-1,2,2-trifluoroethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cfc113a',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The mass is the total mass of the molecules. The chemical formula of CFC113a is CCl3CF3. The IUPAC name for CFC113a is 1,1,1-trichloro-2,2,2-trifluoroethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cfc114',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The mass is the total mass of the molecules. The chemical formula of CFC114 is CClF2CClF2. The IUPAC name for CFC114 is 1,2-dichloro-1,1,2,2-tetrafluoroethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cfc115',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula of CFC115 is CClF2CF3. The IUPAC name for CFC115 is 1-chloro-1,1,2,2,2-pentafluoroethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cfc12',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for CFC12 is CF2Cl2. The IUPAC name for CFC12 is dichloro(difluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_chlorine_dioxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for chlorine dioxide is OClO.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_chlorine_monoxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for chlorine monoxide is ClO.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_chlorine_nitrate',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for chlorine nitrate is ClONO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cloud_condensed_water',
canonical_units='kg m-2',
grib='76',
amip='clwvi',
description='The phrase "condensed_water" means liquid and ice. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cloud_ice',
canonical_units='kg m-2',
grib='58',
amip='clivi',
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_cloud_liquid_water',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_clox_expressed_as_chlorine',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Clox" describes a family of chemical species consisting of inorganic chlorine compounds with the exception of hydrogen chloride (HCl) and chlorine nitrate (ClONO2). The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Clox" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity with a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Inorganic chlorine", sometimes referred to as Cly, describes a family of chemical species which result from the degradation of source gases containing chlorine (CFCs, HCFCs, VSLS) and natural inorganic chlorine sources such as sea salt and other aerosols. Standard names that use the term "inorganic_chlorine" are used for quantities that contain all inorganic chlorine species including HCl and ClONO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_convective_cloud_condensed_water',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "condensed_water" means liquid and ice. Convective cloud is that produced by the convection schemes in an atmosphere model.  "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_convective_cloud_ice',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_convective_cloud_liquid_water',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. Convective cloud is that produced by the convection schemes in an atmosphere model. "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_dichlorine_peroxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for dichlorine peroxide is Cl2O2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_dimethyl_sulfide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for dimethyl sulfide is (CH3)2S.  Dimethyl sulfide is sometimes referred to as DMS.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_dinitrogen_pentoxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for dinitrogen pentoxide is N2O5.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_dust_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. Chemically, "elemental carbon" is the carbonaceous fraction of particulate matter that is thermally stable in an inert atmosphere to high temperatures near 4000K and can only be gasified by oxidation starting at temperatures above 340 C. It is assumed to be inert and non-volatile under atmospheric conditions and insoluble in any solvent (Ogren and Charlson, 1983).',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_ethane',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for ethane is C2H6. Ethane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_ethanol',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for ethanol is C2H5OH.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_ethene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for ethene is C2H4. Ethene is a member of the group of hydrocarbons known as alkenes.  There are standard names for the alkene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_ethyne',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for ethyne is HC2H.  Ethyne is the IUPAC name for this species, which is also commonly known as acetylene.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_formaldehyde',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for formaldehyde is CH2O. The IUPAC name for formaldehyde is methanal.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_formic_acid',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for formic acid is HCOOH.  The IUPAC name for formic acid is methanoic acid.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_gaseous_divalent_mercury',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  "Divalent mercury" means all compounds in which the mercury has two binding sites to other ion(s) in a salt or to other atom(s) in a molecule.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_gaseous_elemental_mercury',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical symbol for mercury is Hg.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_graupel',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. Graupel consists of heavily rimed snow particles, often called snow pellets; often indistinguishable from very small soft hail except when the size convention that hail must have a diameter greater than 5 mm is adopted. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Graupel. There are also separate standard names for hail. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_graupel_and_hail',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. Graupel consists of heavily rimed snow particles, often called snow pellets; often indistinguishable from very small soft hail except when the size convention that hail must have a diameter greater than 5 mm is adopted. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Graupel. Hail is precipitation in the form of balls or irregular lumps of ice, often restricted by a size convention to diameters of 5 mm or more. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Hail. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel. For models that do distinguish between them, separate standard names for hail and graupel are available.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hail',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. Hail is precipitation in the form of balls or irregular lumps of ice, often restricted by a size convention to diameters of 5 mm or more. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Hail. For diameters of less than 5 mm standard names for "graupel" should be used. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_halon1202',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The mass is the total mass of the molecules. The chemical formula for Halon1202 is CBr2F2. The IUPAC name for Halon1202 is dibromo(difluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_halon1211',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The mass is the total mass of the molecules. The chemical formula for Halon1211 is CBrClF2. The IUPAC name for Halon1211 is bromo-chloro-difluoromethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_halon1301',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer are used". The mass is the total mass of the molecules. The chemical formula for Halon1301 is CBrF3. The IUPAC name for Halon1301 is bromo(trifluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_halon2402',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The mass is the total mass of the molecules. The chemical formula for Halon2402 is C2Br2F4. The IUPAC name for Halon2402 is 1,2-dibromo-1,1,2,2-tetrafluoroethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hcc140a',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for HCC140a, also called methyl chloroform, is CH3CCl3. The IUPAC name for HCC140a is 1,1,1-trichloroethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hcfc141b',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The chemical formula for HCFC141b is CH3CCl2F. The IUPAC name for HCFC141b is 1,1-dichloro-1-fluoroethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hcfc142b',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The chemical formula for HCFC142b is CH3CClF2. The IUPAC name for HCFC142b is 1-chloro-1,1-difluoroethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hcfc22',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer are used". The mass is the total mass of the molecules. The chemical formula for HCFC22 is CHClF2. The IUPAC name for HCFC22 is chloro(difluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hexachlorobiphenyl',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the molecules. The chemical formula for hexachlorobiphenyl is C12H4Cl6. The structure of this species consists of two linked benzene rings, each of which is additionally bonded to three chlorine atoms.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hox_expressed_as_hydrogen',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "HOx" means a combination of two radical species containing hydrogen and oxygen: OH and HO2. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hydrogen_bromide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the molecules. The chemical formula for hydrogen bromide is HBr.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hydrogen_chloride',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The chemical formula for hydrogen chloride is HCl.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hydrogen_cyanide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the molecules. The chemical formula for hydrogen cyanide is HCN.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hydrogen_peroxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the molecules. The chemical formula for hydrogen peroxide is H2O2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hydroperoxyl_radical',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The chemical formula for the hydroperoxyl radical is HO2. In chemistry, a \'radical\' is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hydroxyl_radical',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for the hydroxyl radical is OH. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hypobromous_acid',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The chemical formula for hypobromous acid is HOBr.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_hypochlorous_acid',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The chemical formula for hypochlorous acid is HOCl.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_inorganic_bromine',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Inorganic bromine", sometimes referred to as Bry, describes a family of chemical species which result from the degradation of source gases containing bromine (halons, methyl bromide, VSLS) and natural inorganic bromine sources such as volcanoes, sea salt and other aerosols. "Inorganic bromine" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names that use the term "brox" are used for quantities that contain all inorganic bromine species except HBr and BrONO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_inorganic_chlorine',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Inorganic chlorine", sometimes referred to as Cly, describes a family of chemical species which result from the degradation of source gases containing chlorine (CFCs, HCFCs, VSLS) and natural inorganic chlorine sources such as sea salt and other aerosols. "Inorganic chlorine" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names that use the term "clox" are used for quantities that contain all inorganic chlorine species except HCl and ClONO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_isoprene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for isoprene is CH2=C(CH3)CH=CH2. The IUPAC name for isoprene is 2-methylbuta-1,3-diene. Isoprene is a member of the group of hydrocarbons known as terpenes. There are standard names for the terpene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_limonene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for limonene is C10H16. The IUPAC name for limonene is 1-methyl-4-prop-1-en-2-ylcyclohexene. Limonene is a member of the group of hydrocarbons known as terpenes. There are standard names for the terpene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_liquid_precipitation',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Liquid_precipitation" includes both "rain" and "drizzle". "Rain" means drops of water falling through the atmosphere that have a diameter greater than 0.5 mm. "Drizzle" means drops of water falling through the atmosphere that have a diameter typically in the range 0.2-0.5 mm.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_mercury_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_methane',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for methane is CH4. Methane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_methanol',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The chemical formula for methanol is CH3OH.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_methyl_bromide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for methyl bromide is CH3Br. The IUPAC name for methyl bromide is bromomethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_methyl_chloride',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for methyl chloride is CH3Cl. The IUPAC name for methyl chloride is chloromethane.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_methyl_hydroperoxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for methyl hydroperoxide is CH3OOH.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_methyl_peroxy_radical',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for methyl_peroxy_radical is CH3O2. In chemistry, a "radical"is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_molecular_hydrogen',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for molecular hydrogen is H2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nitrate_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for the nitrate anion is NO3-.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nitrate_radical',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for nitrate is NO3. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nitric_acid',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for nitric acid is HNO3.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nitric_acid_trihydrate_ambient_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". Nitric acid trihydrate, sometimes referred to as NAT, is a stable crystalline substance consisting of three molecules of water to one molecule of nitric acid. The chemical formula for nitric acid is HNO3.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nitrogen_monoxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for nitrogen monoxide is NO.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nitrous_acid',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for nitrous acid is HNO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nitrous_oxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for nitrous oxide is N2O.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nmvoc_expressed_as_carbon',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_nox_expressed_as_nitrogen',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  "Nox" means a combination of two radical species containing nitrogen and oxygen: NO+NO2. The phrase \'expressed_as\' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_noy_expressed_as_nitrogen',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  "Noy" describes a family of chemical species. The family usually includes atomic nitrogen (N), nitrogen monoxide (NO), nitrogen dioxide (NO2), dinitrogen pentoxide (N2O5), nitric acid (HNO3), peroxynitric acid (HNO4), bromine nitrate (BrONO2) , chlorine nitrate (ClONO2) and organic nitrates (most notably peroxyacetyl nitrate, sometimes referred to as PAN, (CH3COO2NO2)). The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. The phrase \'expressed_as\' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_oxygenated_hydrocarbons',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.   "Oxygenated" means containing oxygen. "Hydrocarbon" means a compound containing hydrogen and carbon.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_ozone',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for ozone is O3.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. The term "particulate_organic_matter_dry_aerosol" means all particulate organic matter dry aerosol except elemental carbon. It is the sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_peroxyacetyl_nitrate',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The chemical formula for peroxyacetyl nitrate, sometimes referred to as PAN, is CH3COO2NO2.  The IUPAC name for peroxyacetyl_nitrate is nitroethaneperoxoate.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_peroxynitric_acid',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for peroxynitric acid, sometimes referred to as PNA, is HO2NO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_peroxy_radicals',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The term "peroxy_radicals" means all organic and inorganic peroxy radicals. This includes HO2 and all organic peroxy radicals, sometimes referred to as RO2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_primary_particulate_organic_matter_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. "Primary particulate organic matter " means all organic matter emitted directly to the atmosphere as particles except elemental carbon. The sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol is particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_propane',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for propane is C3H8. Propane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_propene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for propene is C3H6. Propene is a member of the group of hydrocarbons known as alkenes.  There are standard names for the alkene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_radon',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical symbol for radon is Rn.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_sea_salt_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_sea_salt_dry_aerosol_particles_expressed_as_cations',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The phrase "sea_salt_cation" is the term used in standard names to describe collectively the group of cationic species that occur in sea salt. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Sea salt cations are mainly sodium (Na+), but also include potassium (K+), magnesium (Mg2+), calcium (Ca2+) and rarer cations. Where possible, the data variable should be accompanied by a complete description of the ions represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_secondary_particulate_organic_matter_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Secondary particulate organic matter " means particulate organic matter formed within the atmosphere from gaseous precursors. The sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol is particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_snow',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Snow" refers to the precipitating part of snow in the atmosphere – the cloud snow content is excluded.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_sulfate',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_sulfate_ambient_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip='trsult',
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_sulfate_dry_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for the sulfate anion is SO4(2-).',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_sulfate_dry_aerosol_particles_expressed_as_sulfur',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for the sulfate anion is SO4(2-).',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_sulfur_dioxide',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for sulfur dioxide is SO2.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_terpenes',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  Terpenes are hydrocarbons, that is, they contain only hydrogen and carbon combined in the general proportions (C5H8)n where n is an integer greater than on equal to one. The term "terpenes" is used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.  Standard names exist for some individual terpene species, e.g., isoprene and limonene.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_toluene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for toluene is C6H5CH3. Toluene has the same structure as benzene, except that one of the hydrogen atoms is replaced by a methyl group. The IUPAC name for toluene is methylbenzene.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_volcanic_ash',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "Volcanic_ash" means the fine-grained products of explosive volcanic eruptions, such as minerals or crystals, older fragmented rock (e.g. andesite), and glass. Particles within a volcanic ash cloud have diameters less than 2 mm. "Volcanic_ash" does not include non-volcanic dust.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_water',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "Water" means water in all phases.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_water_in_ambient_aerosol_particles',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "Water" means water in all phases. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_water_vapor',
canonical_units='kg m-2',
grib='54',
amip='prw',
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. Atmosphere water vapor content is sometimes referred to as "precipitable water", although this term does not imply the water could all be precipitated.',
),
CFStandardNameDC(
name='atmosphere_mass_content_of_xylene',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  The chemical formula for xylene is C6H4C2H6. In chemistry, xylene is a generic term for a group of three isomers of dimethylbenzene. The IUPAC names for the isomers are 1,2-dimethylbenzene, 1,3-dimethylbenzene and 1,4-dimethylbenzene. Xylene is an aromatic hydrocarbon. There are standard names that refer to aromatic_compounds as a group, as well as those for individual species.',
),
CFStandardNameDC(
name='atmosphere_mass_of_air_per_unit_area',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Mass_of_air" means the mass due solely to the gaseous constituents of the atmosphere.  The standard name for the mass including precipitation and aerosol particles is atmosphere_mass_per_unit_area.',
),
CFStandardNameDC(
name='atmosphere_mass_of_carbon_dioxide',
canonical_units='kg',
grib=None,
amip=None,
description='The chemical formula for carbon dioxide is CO2.',
),
CFStandardNameDC(
name='atmosphere_mass_per_unit_area',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"X_area" means the horizontal area occupied by X within the grid cell.',
),
CFStandardNameDC(
name='atmosphere_mole_content_of_carbon_monoxide',
canonical_units='mol m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The construction "atmosphere_mole_content_of_X" means the vertically integrated number of moles of X above a unit area. The chemical formula of carbon monoxide is CO.',
),
CFStandardNameDC(
name='atmosphere_mole_content_of_methane',
canonical_units='mol m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The construction "atmosphere_mole_content_of_X" means the vertically integrated number of moles of X above a unit area. The chemical formula for methane is CH4. Methane is a member of the group of hydrocarbons known as alkanes. There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_mole_content_of_nitrogen_dioxide',
canonical_units='mol m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The construction "atmosphere_mole_content_of_X" means the vertically integrated number of moles of X above a unit area. The chemical formula for nitrogen dioxide is NO2.',
),
CFStandardNameDC(
name='atmosphere_mole_content_of_ozone',
canonical_units='mol m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The construction "atmosphere_mole_content_of_X" means the vertically integrated number of moles of X above a unit area. The chemical formula for ozone is O3. atmosphere_mole_content_of_ozone is usually measured in Dobson Units which are equivalent to 446.2 micromoles m-2. N.B. Data variables containing column content of ozone can be given the standard name of either equivalent_thickness_at_stp_of_atmosphere_ozone_content or atmosphere_mole_content_of_ozone.The latter name is recommended for consistency with mole content names for chemical species other than ozone.',
),
CFStandardNameDC(
name='atmosphere_mole_content_of_water_vapor',
canonical_units='mol m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The construction "atmosphere_mole_content_of_X" means the vertically integrated number of moles of X above a unit area. Atmosphere water vapor content is sometimes referred to as "precipitable water", although this term does not imply the water could all be precipitated. The chemical formula for water is H2O.',
),
CFStandardNameDC(
name='atmosphere_moles_of_acetic_acid',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for acetic_acid is CH3COOH. The IUPAC name for acetic acid is ethanoic acid.',
),
CFStandardNameDC(
name='atmosphere_moles_of_aceto_nitrile',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for aceto-nitrile is CH3CN. The IUPAC name for aceto-nitrile is ethanenitrile.',
),
CFStandardNameDC(
name='atmosphere_moles_of_alpha_hexachlorocyclohexane',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for alpha_hexachlorocyclohexane is C6H6Cl6.',
),
CFStandardNameDC(
name='atmosphere_moles_of_alpha_pinene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for alpha_pinene is C10H16. The IUPAC name for alpha-pinene is (1S,5S)-2,6,6-trimethylbicyclo[3.1.1]hept-2-ene.',
),
CFStandardNameDC(
name='atmosphere_moles_of_ammonia',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for ammonia is NH3.',
),
CFStandardNameDC(
name='atmosphere_moles_of_anthropogenic_nmvoc_expressed_as_carbon',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Anthropogenic" means influenced, caused, or created by human activity.  The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_moles_of_atomic_bromine',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical symbol for atomic bromine is Br.',
),
CFStandardNameDC(
name='atmosphere_moles_of_atomic_chlorine',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical symbol for atomic chlorine is Cl.',
),
CFStandardNameDC(
name='atmosphere_moles_of_atomic_nitrogen',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical symbol for atomic nitrogen is N.',
),
CFStandardNameDC(
name='atmosphere_moles_of_benzene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for benzene is C6H6.  Benzene is the simplest aromatic hydrocarbon and has a ring structure consisting of six carbon atoms joined by alternating single and double chemical bonds. Each carbon atom is additionally bonded to one hydrogen atom. There are standard names that refer to aromatic_compounds as a group, as well as those for individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_beta_pinene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for beta_pinene is C10H16.  The IUPAC name for beta-pinene is (1S,5S)-6,6-dimethyl-2-methylenebicyclo[3.1.1]heptane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_biogenic_nmvoc_expressed_as_carbon',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Biogenic" means influenced, caused, or created by natural processes. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_moles_of_bromine_chloride',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for bromine chloride is BrCl.',
),
CFStandardNameDC(
name='atmosphere_moles_of_bromine_monoxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for bromine monoxide is BrO.',
),
CFStandardNameDC(
name='atmosphere_moles_of_bromine_nitrate',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for bromine nitrate is BrONO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_brox_expressed_as_bromine',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "Brox" describes a family of chemical species consisting of inorganic bromine compounds with the exception of hydrogen bromide (HBr) and bromine nitrate (BrONO2). The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Brox" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity with a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Inorganic bromine", sometimes referred to as Bry, describes a family of chemical species which result from the degradation of source gases containing bromine (halons, methyl bromide, VSLS) and natural inorganic bromine sources such as volcanoes, sea salt and other aerosols. Standard names that use the term "inorganic_bromine" are used for quantities that contain all inorganic bromine species including HCl and ClONO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_butane',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for butane is C4H10. Butane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_carbon_dioxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for carbon dioxide is CO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_carbon_monoxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for carbon monoxide is CO.',
),
CFStandardNameDC(
name='atmosphere_moles_of_carbon_tetrachloride',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for carbon tetrachloride is CCl4. The IUPAC name for carbon tetrachloride is tetrachloromethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_cfc11',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula of CFC11 is CFCl3. The IUPAC name for CFC11 is trichloro(fluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_cfc113',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula of CFC113 is CCl2FCClF2. The IUPAC name for CFC113 is 1,1,2-trichloro-1,2,2-trifluoroethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_cfc113a',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula of CFC113a is CCl3CF3. The IUPAC name for CFC113a is 1,1,1-trichloro-2,2,2-trifluoroethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_cfc114',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula of CFC114 is CClF2CClF2. The IUPAC name for CFC114 is 1,2-dichloro-1,1,2,2-tetrafluoroethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_cfc115',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula of CFC115 is CClF2CF3. The IUPAC name for CFC115 is 1-chloro-1,1,2,2,2-pentafluoroethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_cfc12',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for CFC12 is CF2Cl2. The IUPAC name for CFC12 is dichloro(difluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_chlorine_dioxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for chlorine dioxide is OClO.',
),
CFStandardNameDC(
name='atmosphere_moles_of_chlorine_monoxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for chlorine monoxide is ClO.',
),
CFStandardNameDC(
name='atmosphere_moles_of_chlorine_nitrate',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for chlorine nitrate is ClONO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_clox_expressed_as_chlorine',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "Clox" describes a family of chemical species consisting of inorganic chlorine compounds with the exception of hydrogen chloride (HCl) and chlorine nitrate (ClONO2). The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Clox" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity with a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Inorganic chlorine", sometimes referred to as Cly, describes a family of chemical species which result from the degradation of source gases containing chlorine (CFCs, HCFCs, VSLS) and natural inorganic chlorine sources such as sea salt and other aerosols. Standard names that use the term "inorganic_chlorine" are used for quantities that contain all inorganic chlorine species including HCl and ClONO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_dichlorine_peroxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for dichlorine peroxide is Cl2O2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_dimethyl_sulfide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for dimethyl sulfide is (CH3)2S.  Dimethyl sulfide is sometimes referred to as DMS.',
),
CFStandardNameDC(
name='atmosphere_moles_of_dinitrogen_pentoxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for dinitrogen pentoxide is N2O5.',
),
CFStandardNameDC(
name='atmosphere_moles_of_ethane',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for ethane is C2H6. Ethane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_ethanol',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for ethanol is C2H5OH.',
),
CFStandardNameDC(
name='atmosphere_moles_of_ethene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for ethene is C2H4. Ethene is a member of the group of hydrocarbons known as alkenes.  There are standard names for the alkene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_ethyne',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for ethyne is HC2H.  Ethyne is the IUPAC name for this species, which is also commonly known as acetylene.',
),
CFStandardNameDC(
name='atmosphere_moles_of_formaldehyde',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for formaldehyde is CH2O. The IUPAC name for formaldehyde is methanal.',
),
CFStandardNameDC(
name='atmosphere_moles_of_formic_acid',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for formic acid is HCOOH.  The IUPAC name for formic acid is methanoic acid.',
),
CFStandardNameDC(
name='atmosphere_moles_of_gaseous_divalent_mercury',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "Divalent mercury" means all compounds in which the mercury has two binding sites to other ion(s) in a salt or to other atom(s) in a molecule.',
),
CFStandardNameDC(
name='atmosphere_moles_of_gaseous_elemental_mercury',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical symbol for mercury is Hg.',
),
CFStandardNameDC(
name='atmosphere_moles_of_halon1202',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for Halon1202 is CBr2F2. The IUPAC name for Halon1202 is dibromo(difluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_halon1211',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for Halon1211 is CBrClF2. The IUPAC name for Halon1211 is bromo-chloro-difluoromethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_halon1301',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for Halon1301 is CBrF3. The IUPAC name for Halon1301 is bromo(trifluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_halon2402',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for Halon2402 is C2Br2F4. The IUPAC name for Halon2402 is 1,2-dibromo-1,1,2,2-tetrafluoroethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hcc140a',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for HCC140a, also called methyl chloroform, is CH3CCl3. The IUPAC name for HCC140a is 1,1,1-trichloroethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hcfc141b',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for HCFC141b is CH3CCl2F. The IUPAC name for HCFC141b is 1,1-dichloro-1-fluoroethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hcfc142b',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for HCFC142b is CH3CClF2. The IUPAC name for HCFC142b is 1-chloro-1,1-difluoroethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hcfc22',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for HCFC22 is CHClF2. The IUPAC name for HCFC22 is chloro(difluoro)methane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hexachlorobiphenyl',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for hexachlorobiphenyl is C12H4Cl6.  This structure of this species consists of two linked benzene rings, each of which is additionally bonded to three chlorine atoms.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hox_expressed_as_hydrogen',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "HOx" means a combination of two radical species containing hydrogen and oxygen: OH and HO2. The phrase \'expressed_as\' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hydrogen_bromide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for hydrogen bromide is HBr.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hydrogen_chloride',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for hydrogen chloride is HCl.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hydrogen_cyanide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for hydrogen cyanide is HCN.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hydrogen_peroxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for hydrogen peroxide is H2O2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hydroperoxyl_radical',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for the hydroperoxyl radical is HO2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hydroxyl_radical',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for the hydroxyl radical is OH. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hypobromous_acid',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for hypobromous acid is HOBr.',
),
CFStandardNameDC(
name='atmosphere_moles_of_hypochlorous_acid',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for hypochlorous acid is HOCl.',
),
CFStandardNameDC(
name='atmosphere_moles_of_inorganic_bromine',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "Inorganic bromine", sometimes referred to as Bry, describes a family of chemical species which result from the degradation of source gases containing bromine (halons, methyl bromide, VSLS) and natural inorganic bromine sources such as volcanoes, sea salt and other aerosols. "Inorganic bromine" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names that use the term "brox" are used for quantities that contain all inorganic bromine species except HBr and BrONO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_inorganic_chlorine',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "Inorganic chlorine", sometimes referred to as Cly, describes a family of chemical species which result from the degradation of source gases containing chlorine (CFCs, HCFCs, VSLS) and natural inorganic chlorine sources such as sea salt and other aerosols. "Inorganic chlorine" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names that use the term "clox" are used for quantities that contain all inorganic chlorine species except HCl and ClONO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_isoprene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for isoprene is CH2=C(CH3)CH=CH2. The IUPAC name for isoprene is 2-methylbuta-1,3-diene. Isoprene is a member of the group of hydrocarbons known as terpenes. There are standard names for the terpene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_limonene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for limonene is C10H16. The IUPAC name for limonene is 1-methyl-4-prop-1-en-2-ylcyclohexene. Limonene is a member of the group of hydrocarbons known as terpenes. There are standard names for the terpene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_methane',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for methane is CH4. Methane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_methanol',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for methanol is CH3OH.',
),
CFStandardNameDC(
name='atmosphere_moles_of_methyl_bromide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for methyl bromide is CH3Br. The IUPAC name for methyl bromide is bromomethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_methyl_chloride',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for methyl chloride is CH3Cl. The IUPAC name for methyl chloride is chloromethane.',
),
CFStandardNameDC(
name='atmosphere_moles_of_methyl_hydroperoxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for methyl hydroperoxide is CH3OOH.',
),
CFStandardNameDC(
name='atmosphere_moles_of_methyl_peroxy_radical',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for methyl_peroxy_radical is CH3O2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_molecular_hydrogen',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for molecular hydrogen is H2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nitrate_radical',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nitric_acid',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for nitric acid is HNO3.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nitric_acid_trihydrate_ambient_aerosol_particles',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The chemical formula for nitric acid is HNO3. Nitric acid trihydrate, sometimes referred to as NAT, is a stable crystalline substance consisting of three molecules of water to one molecule of nitric acid.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nitrogen_dioxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for nitrogen dioxide is NO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nitrogen_monoxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for nitrogen monoxide is NO.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nitrous_acid',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for nitrous acid is HNO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nitrous_oxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for nitrous oxide is N2O.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nmvoc_expressed_as_carbon',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_moles_of_nox_expressed_as_nitrogen',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "Nox" means a combination of two radical species containing nitrogen and oxygen: NO+NO2. The phrase \'expressed_as\' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_moles_of_noy_expressed_as_nitrogen',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. "Noy" describes a family of chemical species. The family usually includes atomic nitrogen (N), nitrogen monoxide (NO), nitrogen dioxide (NO2), dinitrogen pentoxide (N2O5), nitric acid (HNO3), peroxynitric acid (HNO4), bromine nitrate (BrONO2) , chlorine nitrate (ClONO2) and organic nitrates (most notably peroxyacetyl nitrate, sometimes referred to as PAN, (CH3COO2NO2)). The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. The phrase \'expressed_as\' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='atmosphere_moles_of_ozone',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for ozone is O3.',
),
CFStandardNameDC(
name='atmosphere_moles_of_peroxyacetyl_nitrate',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for peroxyacetyl nitrate, sometimes referred to as PAN, is CH3COO2NO2.  The IUPAC name for peroxyacetyl_nitrate is nitroethaneperoxoate.',
),
CFStandardNameDC(
name='atmosphere_moles_of_peroxynitric_acid',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for peroxynitric acid, sometimes referred to as PNA, is HO2NO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_propane',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for propane is C3H8. Propane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_propene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for propene is C3H6. Propene is a member of the group of hydrocarbons known as alkenes.  There are standard names for the alkene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='atmosphere_moles_of_radon',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical symbol for radon is Rn.',
),
CFStandardNameDC(
name='atmosphere_moles_of_sulfur_dioxide',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for sulfur dioxide is SO2.',
),
CFStandardNameDC(
name='atmosphere_moles_of_toluene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for toluene is C6H5CH3. Toluene has the same structure as benzene, except that one of the hydrogen atoms is replaced by a methyl group. The IUPAC name for toluene is methylbenzene.',
),
CFStandardNameDC(
name='atmosphere_moles_of_water_vapor',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe.',
),
CFStandardNameDC(
name='atmosphere_moles_of_xylene',
canonical_units='mol',
grib=None,
amip=None,
description='The construction "atmosphere_moles_of_X" means the total number of moles of X in the entire atmosphere, i.e. summed over the atmospheric column and over the entire globe. The chemical formula for xylene is C6H4C2H6. In chemistry, xylene is a generic term for a group of three isomers of dimethylbenzene. The IUPAC names for the isomers are 1,2-dimethylbenzene, 1,3-dimethylbenzene and 1,4-dimethylbenzene. Xylene is an aromatic hydrocarbon. There are standard names that refer to aromatic_compounds as a group, as well as those for individual species.',
),
CFStandardNameDC(
name='atmosphere_momentum_diffusivity',
canonical_units='m2 s-1',
grib=None,
amip=None,
description=None,
),
CFStandardNameDC(
name='atmosphere_net_rate_of_absorption_of_longwave_energy',
canonical_units='W m-2',
grib=None,
amip=None,
description='"longwave" means longwave radiation. Net absorbed radiation is the difference between absorbed and emitted radiation.',
),
CFStandardNameDC(
name='atmosphere_net_rate_of_absorption_of_shortwave_energy',
canonical_units='W m-2',
grib=None,
amip=None,
description='"shortwave" means shortwave radiation. Net absorbed radiation is the difference between absorbed and emitted radiation.',
),
CFStandardNameDC(
name='atmosphere_net_upward_convective_mass_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The atmosphere convective mass flux is the vertical transport of mass for a field of cumulus clouds or thermals, given by the product of air density and vertical velocity. Net upward convective mass flux is the difference between the updraft mass flux and the downdraft mass flux. "Upward" indicates a vector component which is positive when directed upward (negative downward). For an area-average, cell_methods should specify whether the average is over all the area or the area of updrafts and/or downdrafts only.',
),
CFStandardNameDC(
name='atmosphere_net_upward_deep_convective_mass_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Upward" indicates a vector component which is positive when directed upward (negative downward).  In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.  The atmosphere convective mass flux is the vertical transport of mass for a field of cumulus clouds or thermals, given by the product of air density and vertical velocity. For an area-average, cell_methods should specify whether the average is over all the area or the area of updrafts and/or downdrafts only.  Net upward convective mass flux is the difference between the updraft mass flux and the downdraft mass flux.',
),
CFStandardNameDC(
name='atmosphere_net_upward_shallow_convective_mass_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Upward" indicates a vector component which is positive when directed upward (negative downward).  In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.  The atmosphere convective mass flux is the vertical transport of mass for a field of cumulus clouds or thermals, given by the product of air density and vertical velocity. For an area-average, cell_methods should specify whether the average is over all the area or the area of updrafts and/or downdrafts only.  Net upward convective mass flux is the difference between the updraft mass flux and the downdraft mass flux.',
),
CFStandardNameDC(
name='atmosphere_northward_stress_due_to_gravity_wave_drag',
canonical_units='Pa',
grib=None,
amip='tauvgwd',
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Northward" indicates a vector component which is positive when directed northward (negative southward). Atmosphere_Xward_stress is a stress which tends to accelerate the atmosphere in direction X.',
),
CFStandardNameDC(
name='atmosphere_number_content_of_aerosol_particles',
canonical_units='m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself.',
),
CFStandardNameDC(
name='atmosphere_number_content_of_cloud_droplets',
canonical_units='m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.',
),
CFStandardNameDC(
name='atmosphere_number_content_of_ice_crystals',
canonical_units='m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity  named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_ammonium_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-"optical_thickness") on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_black_carbon_ambient_aerosol',
canonical_units='1',
grib=None,
amip=None,
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. "Aerosol" means the suspended liquid or solid particles in air (except cloud droplets).  "Ambient aerosol" is aerosol that has taken up ambient water through hygroscopic growth.  The extent of hygroscopic growth depends on the relative humidity and the composition of the aerosol.  Black carbon aerosol is composed of elemental carbon.  It is strongly light absorbing.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_cloud',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. "Cloud" means the component of extinction owing to the presence of liquid or ice water particles. The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_convective_cloud',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path.  A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. The atmosphere optical thickness applies to radiation passing through the entire atmosphere.  Convective cloud is that produced by the convection schemes in an atmosphere model.  The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity  named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_dust_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_dust_dry_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-"optical_thickness") on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_nitrate_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-"optical_thickness") on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. The chemical formula for the nitrate anion is NO3-.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_particulate_organic_matter_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_pm10_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_pm1_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm1 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 1 micrometer. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_pm2p5_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_sea_salt_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_stratiform_cloud',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path.  A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. The atmosphere optical thickness applies to radiation passing through the entire atmosphere.  In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes).  The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity  named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_sulfate_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-"optical_thickness") on traversing the path. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature". The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_optical_thickness_due_to_water_in_ambient_aerosol_particles',
canonical_units='1',
grib=None,
amip=None,
description='The optical thickness is the integral along the path of radiation of a volume scattering/absorption/attenuation coefficient. The radiative flux is reduced by a factor exp(-optical_thickness) on traversing the path. The atmosphere optical thickness applies to radiation passing through the entire atmosphere. A coordinate variable of radiation_wavelength or radiation_frequency can be specified to indicate that the optical thickness applies at specific wavelengths or frequencies. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "atmosphere_optical_thickness_due_to_water_in_ambient_aerosol" refers to the optical thickness due to the water that is associated with aerosol particles due to hygroscopic growth in ambient air, affecting the radius and refractive index of the particle. It corresponds to the difference between the total dry aerosol optical thickness and the total ambient aerosol optical thickness. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='atmosphere_potential_energy_content',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. Potential energy is the sum of the gravitational potential energy relative to the geoid and the centripetal potential energy. (The geopotential is the specific potential energy.)',
),
CFStandardNameDC(
name='atmosphere_sigma_coordinate',
canonical_units='1',
grib=None,
amip=None,
description='See Appendix D of the CF convention for information about parametric vertical coordinates.',
),
CFStandardNameDC(
name='atmosphere_sleve_coordinate',
canonical_units='1',
grib=None,
amip=None,
description='See Appendix D of the CF convention for information about parametric vertical coordinates.',
),
CFStandardNameDC(
name='atmosphere_stability_k_index',
canonical_units='K',
grib=None,
amip=None,
description='The atmosphere_stability_k_index is an index that indicates the potential of severe convection and is often referred to a simply the k index. The index is derived from the difference in air temperature between 850 and 500 hPa, the dew point temperature at 850 hPa, and the difference between the air temperature and the dew point temperature at 700 hPa.',
),
CFStandardNameDC(
name='atmosphere_stability_showalter_index',
canonical_units='K',
grib=None,
amip=None,
description='The atmosphere_stability_showalter_index is an index used to determine convective and thunderstorm potential and is often referred to as simply the showalter index. The index is defined as the temperature difference between a parcel of air lifted from 850 to 500 hPa (wet adiabatically) and the ambient air temperature at 500 hPa.',
),
CFStandardNameDC(
name='atmosphere_stability_total_totals_index',
canonical_units='K',
grib=None,
amip=None,
description='The atmosphere_stability_total_totals_index indicates thelikelihood of severe convection and is often referred to as simply thetotal totals index. The index is derived from the difference in airtemperature between 850 and 500 hPa (the vertical totals) and thedifference between the dew point temperature at 850 hPa and the airtemperature at 500 hPa (the cross totals). The vertical totals and crosstotals are summed to obtain the index.',
),
CFStandardNameDC(
name='atmosphere_transformed_eulerian_mean_meridional_overturning_mass_streamfunction',
canonical_units='kg s-1',
grib=None,
amip=None,
description='The "meridional mass streamfunction" is a streamfunction of the zonally averaged mass transport in the meridional plane. The "Transformed Eulerian Mean" refers to a formulation of the mean equations which incorporates some eddy terms into the definition of the mean, described in Andrews et al (1987): Middle Atmospheric Dynamics. Academic Press.',
),
CFStandardNameDC(
name='atmosphere_updraft_convective_mass_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The atmosphere convective mass flux is the vertical transport of mass for a field of cumulus clouds or thermals, given by the product of air density and vertical velocity. For an area-average, cell_methods should specify whether the average is over all the area or the area of updrafts and/or downdrafts only. "Updraft" means that the flux is positive in the updward direction (negative downward). upward. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='attenuated_signal_test_quality_flag',
canonical_units='1',
grib=None,
amip=None,
description='A quality flag that reports the result of the Attenuated Signal test, which checks for near-flat-line conditions using a range or standard deviation. The linkage between the data variable and this variable is achieved using the ancillary_variables attribute. There are standard names for other specific quality tests which take the form of X_quality_flag. Quality information that does not match any of the specific quantities should be given the more general standard name of quality_flag.',
),
CFStandardNameDC(
name='automated_tropical_cyclone_forecasting_system_storm_identifier',
canonical_units=None,
grib=None,
amip=None,
description="The Automated Tropical Cyclone Forecasting System (ATCF) storm identifier is an 8 character string which identifies a tropical cyclone. The storm identifier has the form BBCCYYYY, where BB is the ocean basin, specifically: AL - North Atlantic basin, north of the Equator; SL - South Atlantic basin, south of the Equator; EP - North East Pacific basin, eastward of 140 degrees west longitude; CP - North Central Pacific basin, between the dateline and 140 degrees west longitude; WP - North West Pacific basin, westward of the dateline; IO - North Indian Ocean basin, north of the Equator between 40 and 100 degrees east longitude; SH - South Pacific Ocean basin and South Indian Ocean basin. CC is the cyclone number. Numbers 01 through 49 are reserved for tropical and subtropical cyclones. A cyclone number is assigned to each tropical or subtropical cyclone in each basin as it develops. Numbers are assigned in chronological order. Numbers 50 through 79 are reserved for internal use by operational forecast centers. Numbers 80 through 89 are reserved for training, exercises and testing. Numbers 90 through 99 are reserved for tropical disturbances having the potential to become tropical or subtropical cyclones. The 90's are assigned sequentially and reused throughout the calendar year. YYYY is the four-digit year. This is calendar year for the northern hemisphere. For the southern hemisphere, the year begins July 1, with calendar year plus one. Reference: Miller, R.J., Schrader, A.J., Sampson, C.R., & Tsui, T.L. (1990), The Automated Tropical Cyclone Forecasting System (ATCF), American Meteorological Society Computer Techniques, 5, 653 - 660.",
),
CFStandardNameDC(
name='backscattering_ratio_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Scattering of radiation is its deflection from its incident path without loss of energy. Backwards scattering refers to the sum of scattering into all backward angles i.e. scattering_angle exceeding pi/2 radians. A scattering_angle should not be specified with this quantity. "Backscattering ratio" is the ratio of the  quantity with standard name volume_attenuated_backwards_scattering_function_in_air to the quantity with standard name volume_attenuated_backwards_scattering_function_in_air_assuming_no_aerosol_or_cloud.',
),
CFStandardNameDC(
name='baroclinic_eastward_sea_water_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward).',
),
CFStandardNameDC(
name='baroclinic_northward_sea_water_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Northward" indicates a vector component which is positive when directed northward (negative southward).',
),
CFStandardNameDC(
name='barometric_altitude',
canonical_units='m',
grib=None,
amip=None,
description='Barometric altitude is the altitude determined by a pressure measurement which is converted to altitude through interpolation of the International Standard Atmosphere (ICAO, 1976).  A mean sea level pressure of 1013.25 hPa is used for the surface pressure.',
),
CFStandardNameDC(
name='barotropic_eastward_sea_water_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward).',
),
CFStandardNameDC(
name='barotropic_northward_sea_water_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Northward" indicates a vector component which is positive when directed northward (negative southward).',
),
CFStandardNameDC(
name='barotropic_sea_water_x_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity.  "x" indicates a vector component along the grid x-axis, positive with increasing x.',
),
CFStandardNameDC(
name='barotropic_sea_water_y_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity.  "y" indicates a vector component along the grid y-axis, positive with increasing y.',
),
CFStandardNameDC(
name='basal_downward_heat_flux_in_sea_ice',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='baseflow_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Baseflow" is subsurface runoff which takes place below the level of the water table. Runoff is the liquid water which drains from land. "Amount" means mass per unit area.',
),
CFStandardNameDC(
name='beam_consistency_indicator_from_multibeam_acoustic_doppler_velocity_profiler_in_sea_water',
canonical_units='1',
grib=None,
amip=None,
description='The "beam_consistency_indicator" is the degree to which the received acoustic pulse is correlated with the transmitted pulse. It is used as a data quality assessment parameter in ADCP (acoustic doppler current profiler) instruments and is frequently referred to as "correlation magnitude". Convention is that the larger the value, the higher the signal to noise ratio and therefore the better the quality of the current vector measurements; the maximum value of the indicator is 128.',
),
CFStandardNameDC(
name='beaufort_wind_force',
canonical_units='1',
grib=None,
amip=None,
description='"Beaufort wind force" is an index assigned on the Beaufort wind force scale and relates a qualitative description of the degree of disturbance or destruction caused by wind to the speed of the wind.  The Beaufort wind scale varies between 0 (qualitatively described as calm, smoke rises vertically, sea appears glassy) (wind speeds in the range 0 - 0.2 m s-1) and 12 (hurricane, wave heights in excess of 14 m) (wind speeds in excess of 32.7 m s-1).',
),
CFStandardNameDC(
name='bedrock_altitude',
canonical_units='m',
grib=None,
amip=None,
description='Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level. "Bedrock" is the solid Earth surface beneath land ice, ocean water or soil.',
),
CFStandardNameDC(
name='bedrock_altitude_change_due_to_isostatic_adjustment',
canonical_units='m',
grib=None,
amip=None,
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level. "Bedrock" is the solid Earth surface beneath land ice, ocean water or soil. The zero of bedrock altitude change is arbitrary. Isostatic adjustment is the vertical movement of the lithosphere due to changing surface ice and water loads.',
),
CFStandardNameDC(
name='biological_taxon_name',
canonical_units=None,
grib=None,
amip=None,
description='"Biological taxon" is a name or other label identifying an organism or a group of organisms as belonging to a unit of classification in a hierarchical taxonomy. The quantity with standard name biological_taxon_name is the human-readable label for the taxon such as Calanus finmarchicus. The label should be registered in either WoRMS (http://www.marinespecies.org) or ITIS (https://www.itis.gov/) and spelled exactly as registered. See Section 6.1.2 of the CF convention (version 1.8 or later) for information about biological taxon auxiliary coordinate variables.',
),
CFStandardNameDC(
name='bioluminescent_photon_rate_in_sea_water',
canonical_units='s-1 m-3',
grib=None,
amip=None,
description=None,
),
CFStandardNameDC(
name='biomass_burning_carbon_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Biomass burning carbon" refers to the rate at which biomass is burned by forest fires etc., expressed as the mass of carbon which it contains. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='brightness_temperature',
canonical_units='K',
grib='118',
amip=None,
description='The brightness temperature of a body is the temperature of a black body which radiates the same power per unit solid angle per unit area.',
),
CFStandardNameDC(
name='brightness_temperature_anomaly',
canonical_units='K',
grib=None,
amip=None,
description='The brightness temperature of a body is the temperature of a black body which radiates the same power per unit solid angle per unit area. "anomaly" means difference from climatology.',
),
CFStandardNameDC(
name='brightness_temperature_at_cloud_top',
canonical_units='K',
grib=None,
amip=None,
description='cloud_top refers to the top of the highest cloud. brightness_temperature of a body is the temperature of a black body which radiates the same power per unit solid angle per unit area. A coordinate variable of radiation_wavelength, sensor_band_central_radiation_wavelength, or radiation_frequency may be specified to indicate that the brightness temperature applies at specific wavelengths or frequencies.',
),
CFStandardNameDC(
name='brunt_vaisala_frequency_in_air',
canonical_units='s-1',
grib=None,
amip=None,
description='Frequency is the number of oscillations of a wave per unit time. Brunt-Vaisala frequency is also sometimes called "buoyancy frequency" and is a measure of the vertical stratification of the medium.',
),
CFStandardNameDC(
name='burned_area',
canonical_units='m2',
grib=None,
amip=None,
description='"X_area" means the horizontal area occupied by X within the grid cell. The extent of an individual grid cell is defined by the horizontal coordinates and any associated coordinate bounds or by a string valued auxiliary coordinate variable with a standard name of "region". "Burned area" means the area of burned vegetation.',
),
CFStandardNameDC(
name='burned_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. "Burned area" means the area of burned vegetation.',
),
CFStandardNameDC(
name='canopy_albedo',
canonical_units='1',
grib=None,
amip=None,
description='Albedo is the ratio of outgoing to incoming shortwave irradiance, where \'shortwave irradiance\' means that both the incoming and outgoing radiation are integrated across the solar spectrum. "Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy. The surface_albedo restricted to the area type "vegetation" is related to canopy_albedo, but the former also includes the effect of radiation being reflected from the ground underneath the canopy.',
),
CFStandardNameDC(
name='canopy_and_surface_water_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The surface called "surface" means the lower boundary of the atmosphere. "Amount" means mass per unit area. "Water" means water in all phases, including frozen i.e. ice and snow. "Canopy and surface water" means the sum of water on the ground and on the canopy. "Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy.',
),
CFStandardNameDC(
name='canopy_height',
canonical_units='m',
grib=None,
amip=None,
description='Height is the vertical distance above the surface. "Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy.',
),
CFStandardNameDC(
name='canopy_resistance_to_ozone_dry_deposition',
canonical_units='m-1 s',
grib=None,
amip=None,
description='"Canopy" means the plant or vegetation canopy. The "canopy_resistance" is the resistance of a compound to uptake by the vegetation canopy. It varies both with the surface and the chemical species or physical state (gas or particle). Canopy resistance is a function of the canopy stomatal resistance (Rstom), the canopy cuticle resistance (Rcuticle), and the soil resistance (Rsoil). In the case of ozone the uptake by the cuticle is small compared to the uptake through the stomata. Reference: Kerstiens and Lendzian, 1989. This means that the cuticle transfer pathway can be neglected in model parameterizations. Reference: Ganzeveld and Jos Lelieveld , 1995, doi/10.1029/95JD02266/pdf. "Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy. The chemical formula for ozone is O3. The IUPAC name for ozone is trioxygen.',
),
CFStandardNameDC(
name='canopy_snow_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Amount" means mass per unit area. The phrase "canopy_snow" means snow lying on the canopy. "Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy.',
),
CFStandardNameDC(
name='canopy_temperature',
canonical_units='K',
grib=None,
amip=None,
description='"Canopy temperature" is the bulk temperature of the canopy, not the surface (skin) temperature. "Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy.',
),
CFStandardNameDC(
name='canopy_throughfall_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy. "Throughfall" is the part of the precipitation flux that reaches the ground directly through the vegetative canopy, through spaces in the canopy, and as drip from the leaves, twigs, and stems (but not including snowmelt). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='canopy_water_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Amount" means mass per unit area. "Water" means water in all phases, including frozen i.e. ice and snow. The canopy water is the water on the canopy. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy.',
),
CFStandardNameDC(
name='carbon_mass_content_of_forestry_and_agricultural_products',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. Examples of "forestry and agricultural products" are paper, cardboard, furniture, timber for construction, biofuels and food for both humans and livestock. Models that simulate land use changes have one or more pools of carbon that represent these products in order to conserve carbon and allow its eventual release into the atmosphere, for example, when the products decompose in landfill sites.',
),
CFStandardNameDC(
name='carbon_mass_flux_into_forestry_and_agricultural_products_due_to_anthropogenic_land_use_or_land_cover_change',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Anthropogenic" means influenced, caused, or created by human activity. Examples of "forestry and agricultural products" are paper, cardboard, furniture, timber for construction, biofuels and food for both humans and livestock. Models that simulate land use changes have one or more pools of carbon that represent these products in order to conserve carbon and allow its eventual release into the atmosphere, for example, when the products decompose in landfill sites. "Anthropogenic land use change" means human changes to land, excluding forest regrowth. It includes fires ignited by humans for the purpose of land use change and the processes of eventual disposal and decomposition of wood products such as paper, cardboard, furniture and timber for construction.',
),
CFStandardNameDC(
name='carbon_mass_flux_into_litter_and_soil_due_to_anthropogenic_land_use_or_land_cover_change',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Litter" is dead plant material in or above the soil. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Anthropogenic" means influenced, caused, or created by human activity. "Anthropogenic land use change" means human changes to land, excluding forest regrowth. It includes fires ignited by humans for the purpose of land use change and the processes of eventual disposal and decomposition of wood products such as paper, cardboard, furniture and timber for construction.',
),
CFStandardNameDC(
name='carbon_mass_flux_into_soil_from_litter',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Litter" is dead plant material in or above the soil.',
),
CFStandardNameDC(
name='carbon_mass_flux_into_soil_from_vegetation_excluding_litter',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Vegetation" means any plants e.g. trees, shrubs, grass.  "Litter" is dead plant material in or above the soil. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='cell_area',
canonical_units='m2',
grib=None,
amip=None,
description='"Cell_area" is the horizontal area of a gridcell.',
),
CFStandardNameDC(
name='cell_thickness',
canonical_units='m',
grib=None,
amip=None,
description='"Thickness" means the vertical extent of a layer. "Cell" refers to a model grid-cell.',
),
CFStandardNameDC(
name='change_in_atmosphere_energy_content_due_to_change_in_sigma_coordinate_wrt_surface_pressure',
canonical_units='J m-2',
grib=None,
amip=None,
description='The surface called "surface" means the lower boundary of the atmosphere. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "wrt" means with respect to. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. "Atmosphere energy content" has not yet been precisely defined! Please express your views on this quantity on the CF email list. See Appendix D of the CF convention for information about parametric vertical coordinates.',
),
CFStandardNameDC(
name='change_in_energy_content_of_atmosphere_layer_due_to_change_in_sigma_coordinate_wrt_surface_pressure',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. The abbreviation "wrt" means with respect to. The surface called "surface" means the lower boundary of the atmosphere. See Appendix D of the CF convention for information about parametric vertical coordinates.',
),
CFStandardNameDC(
name='change_in_land_ice_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Amount" means mass per unit area. Zero change in land ice amount is an arbitrary level. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='change_over_time_in_amount_of_ice_and_snow_on_land',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. "Amount" means mass per unit area. The phrase "ice_and_snow_on_land" means ice in glaciers, ice caps, ice sheets and shelves, river and lake ice, any other ice on a land surface, such as frozen flood water, and snow lying on such ice or on the land surface.',
),
CFStandardNameDC(
name='change_over_time_in_atmosphere_mass_content_of_water_due_to_advection',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate.  "Content" indicates a quantity per unit area.  The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used.  "Water" means water in all phases.  The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='change_over_time_in_canopy_water_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. Canopy water is the water on the canopy. "Water" means water in all phases, including frozen, i.e. ice and snow. "Amount" means mass per unit area. "Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy.',
),
CFStandardNameDC(
name='change_over_time_in_groundwater_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. "Water" means water in all phases. Groundwater is subsurface water below the depth of the water table. "Amount" means mass per unit area.',
),
CFStandardNameDC(
name='change_over_time_in_land_surface_liquid_water_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. The surface called "surface" means the lower boundary of the atmosphere. "Amount" means mass per unit area. "Land surface liquid water amount" includes water in rivers, wetlands, lakes, reservoirs and liquid precipitation intercepted by the vegetation canopy.',
),
CFStandardNameDC(
name='change_over_time_in_land_water_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. "Amount" means mass per unit area. "Water" means water in all phases. The phrase "land_water_amount", often known as "Terrestrial Water Storage", includes: surface liquid water (water in rivers, wetlands, lakes, reservoirs, rainfall intercepted by the canopy); surface ice and snow (glaciers, ice caps, grounded ice sheets not displacing sea water, river and lake ice, other surface ice such as frozen flood water, snow lying on the surface and intercepted by the canopy); subsurface water (liquid and frozen soil water, groundwater).',
),
CFStandardNameDC(
name='change_over_time_in_mass_content_of_water_in_soil',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. "Content" indicates a quantity per unit area. The mass content of water in soil refers to the vertical integral from the surface down to the bottom of the soil model. For the content between specified levels in the soil, standard names including "content_of_soil_layer" are used. "Water" means water in all phases.',
),
CFStandardNameDC(
name='change_over_time_in_river_water_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. "Water" means water in all phases. "River" refers to the water in the fluvial system (stream and floodplain). "Amount" means mass per unit area.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_absolute_salinity',
canonical_units='g kg-1',
grib=None,
amip=None,
description='"change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. Absolute Salinity, S_A, is defined as part of the Thermodynamic Equation of Seawater 2010 (TEOS-10) which was adopted in 2010 by the Intergovernmental Oceanographic Commission (IOC). It is the mass fraction of dissolved material in sea water. Absolute Salinity incorporates the spatial variations in the composition of sea water. This type of Absolute Salinity is also called "Density Salinity". TEOS-10 estimates Absolute Salinity as the salinity variable that, when used with the TEOS-10 expression for density, yields the correct density of a sea water sample even when the sample is not of Reference Composition. In practice, Absolute Salinity is often calculated from Practical Salinity using a spatial lookup table of pre-defined values of the Absolute Salinity Anomaly. It is recommended that the version of (TEOS-10) software and the associated Absolute Salinity Anomaly climatology be specified within metadata by attaching a comment attribute to the data variable. Reference: www.teos-10.org; Millero et al., 2008 doi: 10.1016/j.dsr.2007.10.001. There are also standard names for the precisely defined salinity quantities sea_water_knudsen_salinity, S_K (used for salinity observations between 1901 and 1966), sea_water_cox_salinity, S_C (used for salinity observations between 1967 and 1977), sea_water_practical_salinity, S_P (used for salinity observations from 1978 onwards), sea_water_preformed_salinity, S_*, and sea_water_reference_salinity. Salinity quantities that do not match any of the precise definitions should be given the more general standard name of sea_water_salinity.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_conservative_temperature',
canonical_units='K',
grib=None,
amip=None,
description='"change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. Conservative Temperature is defined as part of the Thermodynamic Equation of Seawater 2010 (TEOS-10) which was adopted in 2010 by the International Oceanographic Commission (IOC). Conservative Temperature is specific potential enthalpy (which has the standard name sea_water_specific_potential_enthalpy) divided by a fixed value of the specific heat capacity of sea water, namely cp_0 = 3991.86795711963 J kg-1 K-1. Conservative Temperature is a more accurate measure of the "heat content" of sea water, by a factor of one hundred, than is potential temperature. Because of this, it can be regarded as being proportional to the heat content of sea water per unit mass. Reference: www.teos-10.org; McDougall, 2003 doi: 10.1175/1520-0485(2003)033<0945:PEACOV>2.0.CO;2.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_density',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Sea water density is the in-situ density (not the potential density). If 1000 kg m-3 is subtracted, the standard name "sea_water_sigma_t" should be chosen instead. "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_neutral_density',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. "Neutral density" is a variable designed so that a surface of constant neutral density everywhere has a local slope that is close to the local slope of the neutral tangent plane. At the sea surface in the equatorial Pacific neutral density is very close to the potential density anomaly. At other locations, this is not the case. For example, along a neutral density surface there is a difference of up to 0.14 kg/m^3 in the potential density anomaly at the outcrops in the Southern and Northern hemispheres. Refer to Jackett & McDougall (1997; Journal of Physical Oceanography, Vol 27, doi: 10.1175/1520-0485(1997)027<0237:ANDVFT>2.0.CO;2) for more information.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_potential_density',
canonical_units='kg m-3',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time interval, which should be defined by the bounds of the time coordinate. Sea water potential density is the density a parcel of sea water would have if moved adiabatically to a reference pressure, by default assumed to be sea level pressure. To specify the reference pressure to which the quantity applies, provide a scalar coordinate variable with standard name reference_pressure. The density of a substance is its mass per unit volume. For sea water potential density, if 1000 kg m-3 is subtracted, the standard name "sea_water_sigma_theta" should be chosen instead.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_potential_temperature',
canonical_units='K',
grib=None,
amip=None,
description='Potential temperature is the temperature a parcel of air or sea water would have if moved adiabatically to sea level pressure. "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_practical_salinity',
canonical_units='1',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time interval, which should be defined by the bounds of the time coordinate. Practical Salinity, S_P, is a determination of the salinity of sea water, based on its electrical conductance. The measured conductance, corrected for temperature and pressure, is compared to the conductance of a standard potassium chloride solution, producing a value on the Practical Salinity Scale of 1978 (PSS-78). This name should not be used to describe salinity observations made before 1978, or ones not based on conductance measurements. Conversion of Practical Salinity to other precisely defined salinity measures should use the appropriate formulas specified by TEOS-10. Other standard names for precisely defined salinity quantities are sea_water_absolute_salinity (S_A); sea_water_preformed_salinity (S_*), sea_water_reference_salinity (S_R); sea_water_cox_salinity (S_C), used for salinity observations between 1967 and 1977; and sea_water_knudsen_salinity (S_K), used for salinity observations between 1901 and 1966. Salinity quantities that do not match any of the precise definitions should be given the more general standard name of sea_water_salinity. Reference: www.teos-10.org; Lewis, 1980 doi:10.1109/JOE.1980.1145448.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_preformed_salinity',
canonical_units='g kg-1',
grib=None,
amip=None,
description='"change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. Preformed Salinity, S*, is defined as part of the Thermodynamic Equation of Seawater 2010 (TEOS-10) which was adopted in 2010 by the Intergovernmental Oceanographic Commission (IOC). Preformed Salinity is a salinity variable that is designed to be as conservative as possible, by removing the estimated biogeochemical influences on the sea water composition. Preformed Salinity is Absolute Salinity, S_A (which has the standard name sea_water_absolute_salinity), minus all contributions to sea water composition from biogeochemical processes. Preformed Salinity is the mass fraction of dissolved material in sea water. Reference: www.teos-10.org; Pawlowicz et al., 2011 doi: 10.5194/os-7-363-2011; Wright et al., 2011 doi: 10.5194/os-7-1-2011. There are also standard names for the precisely defined salinity quantities sea_water_knudsen_salinity, S_K (used for salinity observations between 1901 and 1966), sea_water_cox_salinity, S_C (used for salinity observations between 1967 and 1977), sea_water_practical_salinity, S_P (used for salinity observations from 1978 onwards), and sea_water_reference_salinity. Salinity quantities that do not match any of the precise definitions should be given the more general standard name of sea_water_salinity.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_salinity',
canonical_units='1e-3',
grib=None,
amip=None,
description='"change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. Sea water salinity is the salt content of sea water, often on the Practical Salinity Scale of 1978. However, the unqualified term \'salinity\' is generic and does not necessarily imply any particular method of calculation. The units of salinity are dimensionless and the units attribute should normally be given as 1e-3 or 0.001 i.e. parts per thousand. There are standard names for the more precisely defined salinity quantities: sea_water_knudsen_salinity, S_K (used for salinity observations between 1901 and 1966), sea_water_cox_salinity, S_C (used for salinity observations between 1967 and 1977), sea_water_practical_salinity, S_P (used for salinity observations from 1978 to the present day), sea_water_absolute_salinity, S_A, sea_water_preformed_salinity, S_*, and sea_water_reference_salinity. Practical Salinity is reported on the Practical Salinity Scale of 1978 (PSS-78), and is usually based on the electrical conductivity of sea water in observations since the 1960s. Conversion of data between the observed scales follows: S_P = (S_K - 0.03) * (1.80655 / 1.805) and S_P = S_C, however the accuracy of the latter is dependent on whether chlorinity or conductivity was used to determine the S_C value, with this inconsistency driving the development of PSS-78. The more precise standard names should be used where appropriate for both modelled and observed salinities. In particular, the use of sea_water_salinity to describe salinity observations made from 1978 onwards is now deprecated in favor of the term sea_water_practical_salinity which is the salinity quantity stored by national data centers for post-1978 observations. The only exception to this is where the observed salinities are definitely known not to be recorded on the Practical Salinity Scale. The unit "parts per thousand" was used for sea_water_knudsen_salinity and sea_water_cox_salinity.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_specific_potential_enthalpy',
canonical_units='J kg-1',
grib=None,
amip=None,
description='"change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. The potential enthalpy of a sea water parcel is the specific enthalpy after an adiabatic and isohaline change in pressure from its in situ pressure to the sea pressure p = 0 dbar. "specific" means per unit mass. Reference: www.teos-10.org; McDougall, 2003 doi: 10.1175/1520-0485(2003)033<0945:PEACOV>2.0.CO;2.',
),
CFStandardNameDC(
name='change_over_time_in_sea_water_temperature',
canonical_units='K',
grib=None,
amip=None,
description='"change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate.Sea water temperature is the in situ temperature of the sea water. To specify the depth at which the temperature applies use a vertical coordinate variable or scalar coordinate variable. There are standard names for sea_surface_temperature, sea_surface_skin_temperature, sea_surface_subskin_temperature and sea_surface_foundation_temperature which can be used to describe data located at the specified surfaces. For observed data, depending on the period during which the observation was made, the measured in situ temperature was recorded against standard "scales". These historical scales include the International Practical Temperature Scale of 1948 (IPTS-48; 1948-1967), the International Practical Temperature Scale of 1968 (IPTS-68, Barber, 1969; 1968-1989) and the International Temperature Scale of 1990 (ITS-90, Saunders 1990; 1990 onwards). Conversion of data between these scales follows t68 = t48 - (4.4 x 10e-6) * t48(100 - t - 48); t90 = 0.99976 * t68. Observations made prior to 1948 (IPTS-48) have not been documented and therefore a conversion cannot be certain. Differences between t90 and t68 can be up to 0.01 at temperatures of 40 C and above; differences of 0.002-0.007 occur across the standard range of ocean temperatures (-10 - 30 C). The International Equation of State of Seawater 1980 (EOS-80, UNESCO, 1981) and the Practical Salinity Scale (PSS-78) were both based on IPTS-68, while the Thermodynamic Equation of Seawater 2010 (TEOS-10) is based on ITS-90. References: Barber, 1969, doi: 10.1088/0026-1394/5/2/001; UNESCO, 1981; Saunders, 1990, WOCE Newsletter, 10, September 1990.',
),
CFStandardNameDC(
name='change_over_time_in_surface_snow_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. "Amount" means mass per unit area. Surface snow amount refers to the amount on the solid ground or on surface ice cover, but excludes, for example, falling snowflakes and snow on plants.',
),
CFStandardNameDC(
name='change_over_time_in_thermal_energy_content_of_ice_and_snow_on_land',
canonical_units='J m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. Thermal energy is the total vibrational energy, kinetic and potential, of all the molecules and atoms in a substance. The phrase "ice_and_snow_on_land" means ice in glaciers, ice caps, ice sheets and shelves, river and lake ice, any other ice on a land surface, such as frozen flood water, and snow lying on such ice or on the land surface.',
),
CFStandardNameDC(
name='change_over_time_in_thermal_energy_content_of_vegetation_and_litter_and_soil',
canonical_units='J m-2',
grib=None,
amip=None,
description='The phrase "change_over_time_in_X" means change in a quantity X over a time-interval, which should be defined by the bounds of the time coordinate. "Content" indicates a quantity per unit area. Thermal energy is the total vibrational energy, kinetic and potential, of all the molecules and atoms in a substance. "Vegetation" means any living plants e.g. trees, shrubs, grass. The term "plants" refers to the kingdom of plants in the modern classification which excludes fungi. Plants are autotrophs i.e. "producers" of biomass using carbon obtained from carbon dioxide. "Litter" is dead plant material in or above the soil. It is distinct from coarse wood debris. The precise distinction between "fine" and "coarse" is model dependent. The "soil content" of a quantity refers to the vertical integral from the surface down to the bottom of the soil model. For the content between specified levels in the soil, standard names including "content_of_soil_layer" are used.',
),
CFStandardNameDC(
name='charnock_coefficient_for_surface_roughness_length_for_momentum_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Coefficient value, based on the Charnock (1955) empirical expression for deriving the quantity with standard name surface_roughness_length_for_momentum_in_air over the ocean. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Charnock%27s_relation. The surface called "surface" means the lower boundary of the atmosphere.',
),
CFStandardNameDC(
name='clear_sky_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. The clear_sky area fraction is for the whole atmosphere column, as seen from the surface or the top of the atmosphere. "Clear sky" means in the absence of clouds.',
),
CFStandardNameDC(
name='climatology_test_quality_flag',
canonical_units='1',
grib=None,
amip=None,
description='A quality flag that reports the result of the Climatology test, which checks that values are within reasonable range bounds for a given time and location. The linkage between the data variable and this variable is achieved using the ancillary_variables attribute. There are standard names for other specific quality tests which take the form of X_quality_flag. Quality information that does not match any of the specific quantities should be given the more general standard name of quality_flag.',
),
CFStandardNameDC(
name='cloud_albedo',
canonical_units='1',
grib=None,
amip=None,
description="The albedo of cloud. Albedo is the ratio of outgoing to incoming shortwave irradiance, where 'shortwave irradiance' means that both the incoming and outgoing radiation are integrated across the solar spectrum.",
),
CFStandardNameDC(
name='cloud_area_fraction',
canonical_units='1',
grib='71 E164',
amip='clt',
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. The cloud area fraction is for the whole atmosphere column, as seen from the surface or the top of the atmosphere. For the cloud area fraction between specified levels in the atmosphere, standard names including "cloud_area_fraction_in_atmosphere_layer" are used. Standard names also exist for high, medium and low cloud types. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='cloud_area_fraction_in_atmosphere_layer',
canonical_units='1',
grib=None,
amip='cl',
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Standard names referring only to "cloud_area_fraction" should be used for quantities for the whole atmosphere column. Standard names also exist for high, medium and low cloud types. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='cloud_base_altitude',
canonical_units='m',
grib=None,
amip=None,
description='cloud_base refers to the base of the lowest cloud. Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level.',
),
CFStandardNameDC(
name='cloud_binary_mask',
canonical_units='1',
grib=None,
amip=None,
description='X_binary_mask has 1 where condition X is met, 0 elsewhere. 1 = cloud present, 0 = cloud absent (clear). If no threshold is supplied, the binary mask is 1 if there is any non-zero amount of cloud. if a threshold is supplied, it should be specified by associating a coordinate variable or scalar coordinate variable with the data variable and giving the coordinate variable a standard name of cloud_area_fraction. The values of the coordinate variable are the threshold values for the corresponding subarrays of the data variable.',
),
CFStandardNameDC(
name='cloud_ice_mixing_ratio',
canonical_units='1',
grib=None,
amip=None,
description='Cloud ice mixing ratio of a parcel of air is the ratio of the mass of ice to the mass of dry air.',
),
CFStandardNameDC(
name='cloud_liquid_water_mixing_ratio',
canonical_units='1',
grib=None,
amip=None,
description='Cloud liquid water mixing ratio of a parcel of air is the ratio of the mass of liquid water to the mass of dry air. "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='cloud_top_altitude',
canonical_units='m',
grib=None,
amip=None,
description='cloud_top refers to the top of the highest cloud. Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level.',
),
CFStandardNameDC(
name='colony_forming_unit_number_concentration_of_biological_taxon_in_sea_water',
canonical_units='m-3',
grib=None,
amip=None,
description='"Colony forming unit" means an estimate of the viable bacterial or fungal numbers determined by counting colonies grown from a sample. "Number concentration" means the number of particles or other specified objects per unit volume. "Biological taxon" is a name or other label identifying an organism or a group of organisms as belonging to a unit of classification in a hierarchical taxonomy. There must be an auxiliary coordinate variable with standard name biological_taxon_name to identify the taxon in human readable format and optionally an auxiliary coordinate variable with standard name biological_taxon_lsid to provide a machine-readable identifier. See Section 6.1.2 of the CF convention (version 1.8 or later) for information about biological taxon auxiliary coordinate variables.',
),
CFStandardNameDC(
name='compressive_strength_of_sea_ice',
canonical_units='Pa m',
grib=None,
amip=None,
description='"Compressive strength" is a measure of the capacity of a material to withstand compressive forces. If compressive forces are exerted on a material in excess of its compressive strength, fracturing will occur. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='concentration_of_colored_dissolved_organic_matter_in_sea_water_expressed_as_equivalent_mass_fraction_of_quinine_sulfate_dihydrate',
canonical_units='1',
grib=None,
amip=None,
description='The quantity with standard name concentration_of_colored_dissolved_organic_matter_in_sea_water_expressed_as_equivalent_mass_fraction_of_quinine_sulfate_dihydrate is also commonly known as Chromophoric Dissolved Organic Matter (CDOM). CDOM plays an important role in the carbon cycling and biogeochemistry of coastal waters. It occurs naturally in aquatic environments primarily as a result of tannins released from decaying plant and animal matter, which can enter coastal areas in river run-off containing organic materials leached from soils. When present in high concentrations, it imparts a brown or yellowish color to water. Its presence can negatively impact fish populations by reducing dissolved oxygen concentrations to harmful levels and by releasing nutrients and metals that contaminate the water. Increased understanding of the role of CDOM will further our ability to manage and protect coastal ecosystems. Sensors are commonly calibrated against a 100 parts per billion (ppb) quinine sulfate dihydrate solution, a fluorescent reference standard commonly used with CDOM sensors. CDOM sensors therefore report in "QSDE" (quinine sulfate dihydrate equivalents). It is important to note, however, that CDOM concentrations in QSDE are not necessarily equivalent to the in situ CDOM concentrations in ppb.',
),
CFStandardNameDC(
name='convection_time_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Time fraction" means a fraction of a time interval. The interval in question must be specified by the values or bounds of the time coordinate variable associated with the data. "X_time_fraction" means the fraction of the time interval during which X occurs.',
),
CFStandardNameDC(
name='convective_cloud_area_fraction',
canonical_units='1',
grib='72 E185',
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. The cloud area fraction is for the whole atmosphere column, as seen from the surface or the top of the atmosphere. For the cloud area fraction between specified levels in the atmosphere, standard names including "cloud_area_fraction_in_atmosphere_layer" are used. Standard names also exist for high, medium and low cloud types. Convective cloud is that produced by the convection schemes in an atmosphere model. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='convective_cloud_area_fraction_in_atmosphere_layer',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Standard names referring only to "cloud_area_fraction" should be used for quantities for the whole atmosphere column. Standard names also exist for high, medium and low cloud types. Convective cloud is that produced by the convection schemes in an atmosphere model. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='convective_cloud_base_altitude',
canonical_units='m',
grib=None,
amip=None,
description='cloud_base refers to the base of the lowest cloud. Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level. Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='convective_cloud_base_height',
canonical_units='m',
grib=None,
amip=None,
description='cloud_base refers to the base of the lowest cloud. Height is the vertical distance above the surface. Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='convective_cloud_longwave_emissivity',
canonical_units='1',
grib=None,
amip=None,
description='Emissivity is the ratio of the power emitted by an object to the power that would be emitted by a perfect black body having the same temperature as the object. The emissivity is assumed to be an integral over all wavelengths, unless a coordinate of radiation_wavelength or radiation_frequency is included to specify either the wavelength or frequency. Convective cloud is that produced by the convection schemes in an atmosphere model.  "longwave" means longwave radiation.',
),
CFStandardNameDC(
name='convective_cloud_top_altitude',
canonical_units='m',
grib=None,
amip=None,
description='cloud_top refers to the top of the highest cloud. Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level. Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='convective_cloud_top_height',
canonical_units='m',
grib=None,
amip=None,
description='cloud_top refers to the top of the highest cloud. Height is the vertical distance above the surface. Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='convective_precipitation_amount',
canonical_units='kg m-2',
grib='63',
amip=None,
description='"Amount" means mass per unit area. "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases. Convective precipitation is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='convective_precipitation_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip='prc',
description='Convective precipitation is that produced by the convection schemes in an atmosphere model. "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='convective_precipitation_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Precipitation rate" means the depth or thickness of the layer formed by precipitation per unit time. Convective precipitation is that produced by the convection schemes in an atmosphere model. "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases.',
),
CFStandardNameDC(
name='convective_rainfall_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Amount" means mass per unit area.',
),
CFStandardNameDC(
name='convective_rainfall_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='convective_rainfall_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description=None,
),
CFStandardNameDC(
name='convective_snowfall_amount',
canonical_units='kg m-2',
grib='78',
amip=None,
description='"Amount" means mass per unit area.',
),
CFStandardNameDC(
name='convective_snowfall_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='coriolis_parameter',
canonical_units='s-1',
grib=None,
amip=None,
description="The Coriolis parameter is twice the component of the earth's angular velocity about the local vertical i.e. 2 W sin L, where L is latitude and W the angular speed of the earth.",
),
CFStandardNameDC(
name='correction_for_model_negative_specific_humidity',
canonical_units='1',
grib=None,
amip=None,
description='A numerical correction which is added to modelled negative specific humidities in order to obtain a value of zero.',
),
CFStandardNameDC(
name='covariance_over_longitude_of_northward_wind_and_air_temperature',
canonical_units='K m s-1',
grib=None,
amip=None,
description='Covariance refers to the sample covariance rather than the population covariance. The quantity with standard name covariance_over_longitude_of_northward_wind_and_air_temperature is the covariance of the deviations of meridional air velocity and air temperature about their respective zonal mean values. The data variable must be accompanied by a vertical coordinate variable or scalar coordinate variable and is calculated on an isosurface of that vertical coordinate. "Northward" indicates a vector component which is positive when directed northward (negative southward). Wind is defined as a two-dimensional (horizontal) air velocity vector, with no vertical component. (Vertical motion in the atmosphere has the standard name "upward_air_velocity"). Air temperature is the bulk temperature of the air, not the surface (skin) temperature.',
),
CFStandardNameDC(
name='depth',
canonical_units='m',
grib=None,
amip=None,
description='Depth is the vertical distance below the surface.',
),
CFStandardNameDC(
name='depth_at_maximum_upward_derivative_of_sea_water_potential_temperature',
canonical_units='m',
grib=None,
amip=None,
description='This quantity, often used to indicate the "thermocline depth", is the depth of the maximum vertical gradient of sea water potential temperature.  Depth is the vertical distance below the surface. Potential temperature is the temperature a parcel of air or sea water would have if moved adiabatically to sea level pressure.',
),
CFStandardNameDC(
name='depth_at_shallowest_isotherm_defined_by_soil_temperature',
canonical_units='m',
grib=None,
amip=None,
description='Depth is the vertical distance below the surface. A soil temperature profile may go through one or more local minima or maxima. The "depth at shallowest isotherm" is the depth of the occurrence closest to the soil surface of an isotherm of the temperature specified by a coordinate variable or scalar coordinate variable with standard name soil_temperature.',
),
CFStandardNameDC(
name='depth_at_shallowest_local_minimum_in_vertical_profile_of_mole_concentration_of_dissolved_molecular_oxygen_in_sea_water',
canonical_units='m',
grib=None,
amip=None,
description='Depth is the vertical distance below the surface.   \'Mole concentration\' means number of moles per unit volume, also called "molarity", and is used in the construction mole_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical or biological species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. The concentration of any chemical species, whether particulate or dissolved, may vary with depth in the ocean.  A depth profile may go through one or more local minima in concentration. The  depth_at_shallowest_local_minimum_in_vertical_profile_of_mole_concentration_of_dissolved_molecular_oxygen_in_sea_water is the depth of the local minimum in the oxygen concentration that occurs closest to the sea surface.',
),
CFStandardNameDC(
name='depth_below_geoid',
canonical_units='m',
grib=None,
amip=None,
description='The geoid is a surface of constant geopotential with which mean sea level would coincide if the ocean were at rest. (The volume enclosed between the geoid and the sea floor equals the mean volume of water in the ocean). In an ocean GCM the geoid is the surface of zero depth, or the rigid lid if the model uses that approximation. To specify which geoid or geopotential datum is being used as a reference level, a grid_mapping variable should be attached to the data variable as described in Chapter 5.6 of the CF Convention. "Depth_below_X" means the vertical distance below the named surface X.',
),
CFStandardNameDC(
name='depth_below_sea_floor',
canonical_units='m',
grib=None,
amip=None,
description='"Depth_below_X" means the vertical distance below the named surface X.',
),
CFStandardNameDC(
name='depth_of_isosurface_of_sea_water_potential_temperature',
canonical_units='m',
grib=None,
amip=None,
description='This quantity, sometimes called the "isotherm depth", is the depth (if it exists) at which the sea water potential temperature equals some specified value. This value should be specified in a scalar coordinate variable. Depth is the vertical distance below the surface. Potential temperature is the temperature a parcel of air or sea water would have if moved adiabatically to sea level pressure.',
),
CFStandardNameDC(
name='dew_point_depression',
canonical_units='K',
grib='18',
amip=None,
description='Dew point depression is also called dew point deficit. It is the amount by which the air temperature exceeds its dew point temperature. Dew point temperature is the temperature at which a parcel of air reaches saturation upon being cooled at constant pressure and specific humidity.',
),
CFStandardNameDC(
name='dew_point_temperature',
canonical_units='K',
grib='17',
amip=None,
description='Dew point temperature is the temperature at which a parcel of air reaches saturation upon being cooled at constant pressure and specific humidity.',
),
CFStandardNameDC(
name='diameter_of_ambient_aerosol_particles',
canonical_units='m',
grib=None,
amip=None,
description='"Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='difference_of_air_pressure_from_model_reference',
canonical_units='Pa',
grib=None,
amip=None,
description='In some atmosphere models, the difference of air pressure from model reference is a prognostic variable, instead of the air pressure itself. The model reference air pressure is a model-dependent constant. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='diffuse_downwelling_shortwave_flux_in_air',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Diffuse" radiation is radiation that has been scattered by gas molecules in the atmosphere and by particles such as cloud droplets and aerosols. Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance".  In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='diffuse_downwelling_shortwave_flux_in_air_assuming_clear_sky',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Diffuse" radiation is radiation that has been scattered by gas molecules in the atmosphere and by particles such as cloud droplets and aerosols. Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. A phrase assuming_condition  indicates that the named quantity is the value which would obtain if all aspects of the system were unaltered except for the assumption of the  circumstances specified by the condition. "Clear sky" means in the absence of clouds.',
),
CFStandardNameDC(
name='dimensionless_exner_function',
canonical_units='1',
grib=None,
amip=None,
description='The term "Exner function" is applied to various quantities in the literature. "Dimensionless Exner function" is the standard name of (p/p0)^(R/Cp), where p is pressure, p0 a reference pressure, R the gas constant and Cp the specific heat at constant pressure. This quantity is also the ratio of in-situ to potential temperature. Standard names for other variants can be defined on request. To specify the reference pressure to which the quantity applies, provide a scalar coordinate variable with standard name reference_pressure.',
),
CFStandardNameDC(
name='direct_downwelling_shortwave_flux_in_air',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Direct" (also known as "beam") radiation is radiation that has followed a direct path from the sun and is alternatively known as "direct insolation". Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='direction_of_radial_vector_away_from_instrument',
canonical_units='degree',
grib=None,
amip=None,
description='The phrase "direction_of_X" means direction of a vector, a bearing. The direction is measured positive clockwise from due north. The direction_of_radial_vector_away_from_instrument is the direction in which the instrument itself is pointing. The "instrument" (examples are radar and lidar) is the device used to make an observation. The standard name direction_of_radial_vector_toward_instrument should be used for a data variable having the opposite sign convention.',
),
CFStandardNameDC(
name='direction_of_radial_vector_toward_instrument',
canonical_units='degree',
grib=None,
amip=None,
description='The phrase "direction_of_X" means direction of a vector, a bearing. The direction is measured positive clockwise from due north. The direction_of_radial_vector_toward_instrument is the direction opposite to that in which the instrument itself is pointing. The "instrument" (examples are radar and lidar) is the device used to make an observation. The standard name direction_of_radial_vector_away_from_instrument should be used for a data variable having the opposite sign convention.',
),
CFStandardNameDC(
name='direction_of_sea_ice_displacement',
canonical_units='degrees',
grib=None,
amip=None,
description='The phrase "direction_of_X" means direction of a vector, a bearing. "Displacement" means the change in geospatial position of an object that has moved over time. If possible, the time interval over which the motion took place should be specified using a bounds variable for the time coordinate variable. A displacement can be represented as a vector. Such a vector should however not be interpreted as describing a rectilinear, constant speed motion but merely as an indication that the start point of the vector is found at the tip of the vector after the time interval associated with the displacement variable. A displacement does not prescribe a trajectory. Sea ice displacement can be defined as a two-dimensional vector, with no vertical component. In that case, "displacement" is also the distance across the earth\'s surface calculated from the change in a moving object\'s geospatial position between the start and end of the time interval associated with the displacement variable. The "direction of displacement" is the angle between due north and the displacement vector. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='direction_of_sea_ice_velocity',
canonical_units='degree',
grib='93',
amip=None,
description='The phrase "direction_of_X" means direction of a vector, a bearing. A velocity is a vector quantity. Sea ice velocity is defined as a two-dimensional vector, with no vertical component. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='distance_from_geocenter',
canonical_units='m',
grib=None,
amip=None,
description="A measure of distance from the Earth's geocenter, commonly used in satellite tracks.",
),
CFStandardNameDC(
name='distance_from_sun',
canonical_units='m',
grib=None,
amip=None,
description='The distance from the sun to the point of observation.',
),
CFStandardNameDC(
name='distance_from_tropical_cyclone_center_to_leading_edge_of_displaced_convection',
canonical_units='m',
grib=None,
amip=None,
description='The great circle distance measured from the tropical cyclone center to the leading edge of displaced convection, which is defined as the closest point that exceeds a threshold brightness temperature at top of atmosphere limit. The threshold applied should be recorded in a coordinate variable having the standard name of toa_brightness_temperature. A coordinate variable with standard name of radiation_wavelength, sensor_band_central_radiation_wavelength, or radiation_frequency may be specified to indicate that the brightness temperature applies at specific wavelengths or frequencies.',
),
CFStandardNameDC(
name='divergence_of_sea_ice_velocity',
canonical_units='s-1',
grib='98',
amip=None,
description='The phrase "[horizontal_]divergence_of_X" means [horizontal] divergence of a vector X; if X does not have a vertical component then "horizontal" should be omitted. A velocity is a vector quantity. Sea ice velocity is defined as a two-dimensional vector, with no vertical component. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='divergence_of_wind',
canonical_units='s-1',
grib='44 E155',
amip=None,
description='"[horizontal_]divergence_of_X" means [horizontal] divergence of a vector X; if X does not have a vertical component then "horizontal" should be omitted. Wind is defined as a two-dimensional (horizontal) air velocity vector, with no vertical component. (Vertical motion in the atmosphere has the standard name upward_air_velocity.)',
),
CFStandardNameDC(
name='downward_air_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity."Downward" indicates a vector component which is positive when directed downward (negative upward). Downward air velocity is the vertical component of the 3D air velocity vector. The standard name upward_air_velocity may be used for a vector component with the opposite sign convention.',
),
CFStandardNameDC(
name='downward_dry_static_energy_flux_due_to_diffusion',
canonical_units='W m-2',
grib=None,
amip=None,
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Downward" indicates a vector component which is positive when directed downward (negative upward). Dry static energy is the sum of enthalpy and potential energy (itself the sum of gravitational and centripetal potential energy). Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downward_eastward_momentum_flux_in_air',
canonical_units='Pa',
grib='124',
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). "Downward" indicates a vector component which is positive when directed downward (negative upward). "Downward eastward" indicates the ZX component of a tensor. Momentum flux is dimensionally equivalent to stress and pressure. It is a tensor quantity. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downward_eastward_momentum_flux_in_air_due_to_diffusion',
canonical_units='Pa',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). "Downward" indicates a vector component which is positive when directed downward (negative upward). "Downward eastward" indicates the ZX component of a tensor. Momentum flux is dimensionally equivalent to stress and pressure. It is a tensor quantity. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='downward_eastward_stress_at_sea_ice_base',
canonical_units='Pa',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). "Downward" indicates a vector component which is positive when directed downward (negative upward). "Downward eastward" indicates the ZX component of a tensor. A downward eastward stress is a downward flux of eastward momentum, which accelerates the lower medium eastward and the upper medium westward. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='downward_heat_flux_at_ground_level_in_snow',
canonical_units='W m-2',
grib=None,
amip=None,
description='ground_level means the land surface (beneath the snow and surface water, if any). "Downward" indicates a vector component which is positive when directed downward (negative upward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downward_heat_flux_at_ground_level_in_soil',
canonical_units='W m-2',
grib=None,
amip=None,
description='ground_level means the land surface (beneath the snow and surface water, if any). "Downward" indicates a vector component which is positive when directed downward (negative upward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downward_heat_flux_in_air',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). The vertical heat flux in air is the sum of all heat fluxes i.e. radiative, latent and sensible. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downward_heat_flux_in_floating_ice',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.  "Floating ice" means any ice that is floating on water, e.g. on a sea or lake surface.',
),
CFStandardNameDC(
name='downward_heat_flux_in_sea_ice',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='downward_heat_flux_in_soil',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downward_liquid_water_mass_flux_into_groundwater',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. Groundwater is subsurface water below the depth of the water table. The quantity with standard name liquid_water_mass_flux_from_soil_to_groundwater is the downward flux of liquid water within soil at the depth of the water table, or downward flux from the base of the soil model if the water table depth is greater.',
),
CFStandardNameDC(
name='downward_northward_momentum_flux_in_air',
canonical_units='Pa',
grib='125',
amip=None,
description='"Northward" indicates a vector component which is positive when directed northward (negative southward). "Downward" indicates a vector component which is positive when directed downward (negative upward). "Downward northward" indicates the ZY component of a tensor. Momentum flux is dimensionally equivalent to stress and pressure. It is a tensor quantity. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downward_northward_momentum_flux_in_air_due_to_diffusion',
canonical_units='Pa',
grib=None,
amip=None,
description='"Northward" indicates a vector component which is positive when directed northward (negative southward).  "Downward" indicates a vector component which is positive when directed downward (negative upward).  "Downward northward" indicates the ZY component of a tensor.  Momentum flux is dimensionally equivalent to stress and pressure. It is a tensor quantity.  In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.  The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity  named by omitting the phrase.',
),
CFStandardNameDC(
name='downward_northward_stress_at_sea_ice_base',
canonical_units='Pa',
grib=None,
amip=None,
description='"Northward" indicates a vector component which is positive when directed northward (negative southward). "Downward" indicates a vector component which is positive when directed downward (negative upward). "Downward northward" indicates the ZY component of a tensor. A downward northward stress is a downward flux of northward momentum, which accelerates the lower medium northward and the upper medium southward. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='downward_sea_ice_basal_salt_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='downward_water_vapor_flux_in_air_due_to_diffusion',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Downward" indicates a vector component which is positive when directed downward (negative upward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downward_x_stress_at_sea_ice_base',
canonical_units='Pa',
grib=None,
amip=None,
description='"x" indicates a vector component along the grid x-axis, positive with increasing x. "Downward" indicates a vector component which is positive when directed downward (negative upward). "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='downward_x_stress_at_sea_water_surface',
canonical_units='Pa',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). "x" indicates a vector component along the grid x-axis, positive with increasing x. A downward x stress is a downward flux of momentum towards the positive direction of the model\'s x-axis. The phrase "sea water surface" means the upper boundary of the liquid portion of an ocean or sea, including the boundary to floating ice if present.',
),
CFStandardNameDC(
name='downward_x_stress_correction_at_sea_water_surface',
canonical_units='Pa',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). "x" indicates a vector component along the grid x-axis, positive with increasing x. A downward x stress is a downward flux of momentum towards the positive direction of the model\'s x-axis. A positive correction is downward i.e. added to the ocean. The phrase "sea water surface" means the upper boundary of the liquid portion of an ocean or sea, including the boundary to floating ice if present.',
),
CFStandardNameDC(
name='downward_y_stress_at_sea_ice_base',
canonical_units='Pa',
grib=None,
amip=None,
description='"y" indicates a vector component along the grid y-axis, positive with increasing y. "Downward" indicates a vector component which is positive when directed downward (negative upward). "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='downward_y_stress_at_sea_water_surface',
canonical_units='Pa',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). "y" indicates a vector component along the grid y-axis, positive with increasing y. A downward y stress is a downward flux of momentum towards the positive direction of the model\'s y-axis. The phrase "sea water surface" means the upper boundary of the liquid portion of an ocean or sea, including the boundary to floating ice if present.',
),
CFStandardNameDC(
name='downward_y_stress_correction_at_sea_water_surface',
canonical_units='Pa',
grib=None,
amip=None,
description='"Downward" indicates a vector component which is positive when directed downward (negative upward). "y" indicates a vector component along the grid y-axis, positive with increasing y. A downward y stress is a downward flux of momentum towards the positive direction of the model\'s y-axis. A positive correction is downward i.e. added to the ocean. The phrase "sea water surface" means the upper boundary of the liquid portion of an ocean or sea, including the boundary to floating ice if present.',
),
CFStandardNameDC(
name='downwelling_longwave_flux_in_air',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "longwave" means longwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downwelling_longwave_flux_in_air_assuming_clear_sky',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "longwave" means longwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. A phrase assuming_condition indicates that the named quantity is the value which would obtain if all  aspects of the system were unaltered except for the assumption of the  circumstances specified by the condition. "Clear sky" means in the absence of clouds.',
),
CFStandardNameDC(
name='downwelling_longwave_radiance_in_air',
canonical_units='W m-2 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "longwave" means longwave radiation. Radiance is the radiative flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead.',
),
CFStandardNameDC(
name='downwelling_photon_flux_in_sea_water',
canonical_units='mol m-2 s-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. A photon flux is specified in terms of numbers of photons expressed in moles. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downwelling_photon_flux_per_unit_wavelength_in_sea_water',
canonical_units='mol m-2 s-1 m-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. A photon flux is specified in terms of numbers of photons expressed in moles. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength.',
),
CFStandardNameDC(
name='downwelling_photon_radiance_in_sea_water',
canonical_units='mol m-2 s-1 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Photon radiance is the photon flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead. A photon flux is specified in terms of numbers of photons expressed in moles.',
),
CFStandardNameDC(
name='downwelling_photon_radiance_per_unit_wavelength_in_sea_water',
canonical_units='mol m-2 s-1 m-1 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Photon radiance is the photon flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead. A photon flux is specified in terms of numbers of photons expressed in moles. A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength.',
),
CFStandardNameDC(
name='downwelling_photon_spherical_irradiance_in_sea_water',
canonical_units='mol m-2 s-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Photon spherical irradiance is the photon flux incident on unit area of a hemispherical (or "2-pi") collector. Radiation incident on a 4-pi collector has a standard name referring to "omnidirectional spherical irradiance". A photon flux is specified in terms of numbers of photons expressed in moles.',
),
CFStandardNameDC(
name='downwelling_photon_spherical_irradiance_per_unit_wavelength_in_sea_water',
canonical_units='mol m-2 s-1 m-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength. Photon spherical irradiance is the photon flux incident on unit area of a hemispherical (or "2-pi") collector. The direction ("up/downwelling") is specified. Radiation incident on a 4-pi collector has a standard name referring to "omnidirectional spherical irradiance". A photon flux is specified in terms of numbers of photons expressed in moles.',
),
CFStandardNameDC(
name='downwelling_photosynthetic_photon_flux_in_sea_water',
canonical_units='mol m-2 s-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. "Photosynthetic" radiation is the part of the spectrum which is used in photosynthesis e.g. 400-700 nm. The range of wavelengths could be specified precisely by the bounds of a coordinate of radiation_wavelength. A photon flux is specified in terms of numbers of photons expressed in moles. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downwelling_photosynthetic_photon_radiance_in_sea_water',
canonical_units='mol m-2 s-1 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Photon radiance is the photon flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead. "Photosynthetic" radiation is the part of the spectrum which is used in photosynthesis e.g. 400-700 nm. The range of wavelengths could be specified precisely by the bounds of a coordinate of radiation_wavelength. A photon flux is specified in terms of numbers of photons expressed in moles.',
),
CFStandardNameDC(
name='downwelling_photosynthetic_photon_spherical_irradiance_in_sea_water',
canonical_units='mol m-2 s-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. "Photosynthetic" radiation is the part of the spectrum which is used in photosynthesis e.g. 400-700 nm. The range of wavelengths could be specified precisely by the bounds of a coordinate of radiation_wavelength. Photon spherical irradiance is the photon flux incident on unit area of a hemispherical (or "2-pi") collector. The direction ("up/downwelling") is specified. Radiation incident on a 4-pi collector has a standard name referring to "omnidirectional spherical irradiance". A photon flux is specified in terms of numbers of photons expressed in moles.',
),
CFStandardNameDC(
name='downwelling_photosynthetic_radiance_in_sea_water',
canonical_units='W m-2 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Radiance is the radiative flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead. "Photosynthetic" radiation is the part of the spectrum which is used in photosynthesis e.g. 400-700 nm. The range of wavelengths could be specified precisely by the bounds of a coordinate of radiation_wavelength.',
),
CFStandardNameDC(
name='downwelling_photosynthetic_radiative_flux_in_sea_water',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. "Photosynthetic" radiation is the part of the spectrum which is used in photosynthesis e.g. 400-700 nm. The range of wavelengths could be specified precisely by the bounds of a coordinate of radiation_wavelength. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downwelling_photosynthetic_spherical_irradiance_in_sea_water',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. "Photosynthetic" radiation is the part of the spectrum which is used in photosynthesis e.g. 400-700 nm. The range of wavelengths could be specified precisely by the bounds of a coordinate of radiation_wavelength. Spherical irradiance is the radiation incident on unit area of a hemispherical (or "2-pi") collector. It is sometimes called "scalar irradiance". The direction (up/downwelling) is specified. Radiation incident on a 4-pi collector has standard names of "omnidirectional spherical irradiance".',
),
CFStandardNameDC(
name='downwelling_radiance_in_sea_water',
canonical_units='W m-2 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Radiance is the radiative flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead.',
),
CFStandardNameDC(
name='downwelling_radiance_per_unit_wavelength_in_air',
canonical_units='W m-2 m-1 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength. Radiance is the radiative flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead.',
),
CFStandardNameDC(
name='downwelling_radiance_per_unit_wavelength_in_sea_water',
canonical_units='W m-2 m-1 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength. Radiance is the radiative flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead.',
),
CFStandardNameDC(
name='downwelling_radiative_flux_in_sea_water',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Radiative flux is the sum of shortwave and longwave radiative fluxes. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downwelling_radiative_flux_per_unit_wavelength_in_air',
canonical_units='W m-2 m-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength.',
),
CFStandardNameDC(
name='downwelling_radiative_flux_per_unit_wavelength_in_sea_water',
canonical_units='W m-2 m-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength.',
),
CFStandardNameDC(
name='downwelling_shortwave_flux_in_air',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downwelling_shortwave_flux_in_air_assuming_clear_sky',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance".  In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. A phrase assuming_condition indicates that the named quantity is the value which would obtain if all  aspects of the system were unaltered except for the assumption of the  circumstances specified by the condition. "Clear sky" means in the absence of clouds.',
),
CFStandardNameDC(
name='downwelling_shortwave_flux_in_air_assuming_clear_sky_and_no_aerosol',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. A phrase "assuming_condition" indicates that the named quantity is the value which would obtain if all aspects of the system were unaltered except for the assumption of the circumstances specified by the condition. "Clear sky" means in the absence of clouds.',
),
CFStandardNameDC(
name='downwelling_shortwave_flux_in_sea_water',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='downwelling_shortwave_flux_in_sea_water_at_sea_ice_base',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='downwelling_shortwave_radiance_in_air',
canonical_units='W m-2 sr-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. Radiance is the radiative flux in a particular direction, per unit of solid angle. The direction from which it is coming must be specified, for instance with a coordinate of zenith_angle. If the radiation does not depend on direction, a standard name of isotropic radiance should be chosen instead.',
),
CFStandardNameDC(
name='downwelling_spherical_irradiance_in_sea_water',
canonical_units='W m-2',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Spherical irradiance is the radiation incident on unit area of a hemispherical (or "2-pi") collector. It is sometimes called "scalar irradiance". The direction (up/downwelling) is specified. Radiation incident on a 4-pi collector has standard names of "omnidirectional spherical irradiance".',
),
CFStandardNameDC(
name='downwelling_spherical_irradiance_per_unit_wavelength_in_sea_water',
canonical_units='W m-2 m-1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. Spherical irradiance is the radiation incident on unit area of a hemispherical (or "2-pi") collector. It is sometimes called "scalar irradiance". The direction (up/downwelling) is specified. Radiation incident on a 4-pi collector has standard names of "omnidirectional spherical irradiance". A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength.',
),
CFStandardNameDC(
name='dry_atmosphere_mole_fraction_of_carbon_dioxide',
canonical_units='1',
grib=None,
amip=None,
description='Mole fraction is used in the construction "mole_fraction_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The construction "dry_atmosphere_mole_fraction" means that the quantity refers to the whole atmospheric column and is calculated as the total number of particles of X in the column divided by the number of dry air particles in the same column, i.e. the effect of water vapor is excluded. For localized values within the atmospheric medium, standard names including "in_air" are used. The chemical formula for carbon dioxide is CO2.',
),
CFStandardNameDC(
name='dry_atmosphere_mole_fraction_of_methane',
canonical_units='1',
grib=None,
amip=None,
description='Mole fraction is used in the construction "mole_fraction_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The construction "dry_atmosphere_mole_fraction" means that the quantity refers to the whole atmospheric column and is calculated as the total number of particles of X in the column divided by the number of dry air particles in the same column, i.e. the effect of water vapor is excluded. For localized values within the atmospheric medium, standard names including "in_air" are used. Methane is a member of the group of hydrocarbons known as alkanes. There are standard names for the alkane group as well as for some of the individual species. The chemical formula for methane is CH4.',
),
CFStandardNameDC(
name='dry_energy_content_of_atmosphere_layer',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Dry energy is the sum of dry static energy and kinetic energy. Dry static energy is the sum of enthalpy and potential energy (itself the sum of gravitational and centripetal potential energy). Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='dry_static_energy_content_of_atmosphere_layer',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Dry static energy is the sum of enthalpy and potential energy (itself the sum of gravitational and centripetal potential energy). Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='duration_of_sunshine',
canonical_units='s',
grib=None,
amip=None,
description='The WMO definition of sunshine is that the surface incident radiative flux from the solar beam (i.e. excluding diffuse skylight) exceeds 120 W m-2. "Duration" is the length of time for which a condition holds.',
),
CFStandardNameDC(
name='dvorak_tropical_cyclone_current_intensity_number',
canonical_units='1',
grib=None,
amip=None,
description='"Dvorak current intensity number" indicates the ranking of tropical cyclone strength (ranging from 1.0 to 8.0, increasing with storm intensity). The current intensity (CI) number is derived using the Advanced Dvorak Technique based on satellite observations over time. The CI number maps to a maximum sustained 1-minute wind speed and is derived by applying a series of intensity constraints to previous Dvorak-calculated trends of the same storm. Reference: Olander, T. L., & Velden, C. S., The Advanced Dvorak Technique: Continued Development of an Objective Scheme to Estimate Tropical Cyclone Intensity Using Geostationary Infrared Satellite Imagery (2007).  American Meteorological Society Weather and Forecasting, 22, 287-298.',
),
CFStandardNameDC(
name='dvorak_tropical_number',
canonical_units='1',
grib=None,
amip=None,
description='The Advanced Dvorak Technique (ADT) is used to derive a set of Dvorak Tropical numbers using an objective pattern recognition algorithm to determine the intensity of a tropical cyclone by matching observed brightness temperature patterns, maximum sustained winds and minimum sea level pressure to a set of pre-defined tropical cyclone structures. Dvorak Tropical numbers range from 1.0 to 8.0, increasing with storm intensity. Reference: Olander, T. L., & Velden, C. S., The Advanced Dvorak Technique: Continued Development of an Objective Scheme to Estimate Tropical Cyclone Intensity Using Geostationary Infrared Satellite Imagery (2007). American Meteorological Society Weather and Forecasting, 22, 287-298.',
),
CFStandardNameDC(
name='dynamic_tropopause_potential_temperature',
canonical_units='K',
grib=None,
amip=None,
description='The dynamical tropopause used in interpreting the dynamics of the upper troposphere and lower stratosphere.  There are various definitions of dynamical tropopause in the scientific literature.',
),
CFStandardNameDC(
name='eastward_atmosphere_dry_static_energy_transport_across_unit_distance',
canonical_units='W m-1',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). Transport across_unit_distance means expressed per unit distance normal to the direction of transport. Dry static energy is the sum of enthalpy and potential energy (itself the sum of gravitational and centripetal potential energy). Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='eastward_atmosphere_water_transport_across_unit_distance',
canonical_units='kg s-1 m-1',
grib=None,
amip=None,
description='"Water" means water in all phases. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). Transport across_unit_distance means expressed per unit distance normal to the direction of transport.',
),
CFStandardNameDC(
name='eastward_atmosphere_water_vapor_transport_across_unit_distance',
canonical_units='kg m-1 s-1',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). Transport across_unit_distance means expressed per unit distance normal to the direction of transport.',
),
CFStandardNameDC(
name='eastward_derivative_of_northward_sea_ice_velocity',
canonical_units='s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). "Northward" indicates a vector component which is positive when directed northward (negative southward). Sea ice velocity is defined as a two-dimensional vector, with no vertical component. "component_derivative_of_X" means derivative of X with respect to distance in the component direction, which may be northward, southward, eastward, westward, x or y. The last two indicate derivatives along the axes of the grid, in the case where they are not true longitude and latitude. The named quantity is a component of the strain rate tensor for sea ice. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='eastward_flood_water_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). Flood water is water that covers land which is normally not covered by water.',
),
CFStandardNameDC(
name='eastward_land_ice_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). Land ice velocity is defined as a two-dimensional vector, with no vertical component. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='eastward_mass_flux_of_air',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='eastward_momentum_flux_correction',
canonical_units='Pa',
grib=None,
amip='tauucorr',
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). Momentum flux is dimensionally equivalent to stress and pressure. It is a tensor quantity. Flux correction is also called "flux adjustment". A positive flux correction is downward i.e. added to the ocean. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='eastward_sea_ice_displacement',
canonical_units='m',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). "Displacement" means the change in geospatial position of an object that has moved over time. If possible, the time interval over which the motion took place should be specified using a bounds variable for the time coordinate variable. A displacement can be represented as a vector. Such a vector should however not be interpreted as describing a rectilinear, constant speed motion but merely as an indication that the start point of the vector is found at the tip of the vector after the time interval associated with the displacement variable. A displacement does not prescribe a trajectory. Sea ice displacement can be defined as a two-dimensional vector, with no vertical component. An eastward displacement is the distance calculated from the change in a moving object\'s longitude between the start and end of the time interval associated with the displacement variable. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='eastward_sea_ice_velocity',
canonical_units='m s-1',
grib='95',
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). Sea ice velocity is defined as a two-dimensional vector, with no vertical component. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='eastward_sea_water_velocity',
canonical_units='m s-1',
grib='49',
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward).',
),
CFStandardNameDC(
name='eastward_sea_water_velocity_assuming_no_tide',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity.  "Eastward" indicates a vector component which is positive when directed eastward (negative westward).  A phrase assuming_condition  indicates that the named quantity is the value which would obtain if all  aspects of the system were unaltered except for the assumption of the  circumstances specified by the condition.',
),
CFStandardNameDC(
name='eastward_sea_water_velocity_at_sea_floor',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). The velocity at the sea floor is that adjacent to the ocean bottom, which would be the deepest grid cell in an ocean model and within the benthic boundary layer for measurements.',
),
CFStandardNameDC(
name='eastward_sea_water_velocity_due_to_parameterized_mesoscale_eddies',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. Parameterized mesoscale eddies occur on a spatial scale of many tens of kilometres and an evolutionary time of weeks. Reference: James C. McWilliams 2016, Submesoscale currents in the ocean, Proceedings of the Royal Society A: Mathematical, Physical and Engineering Sciences, volume 472, issue 2189. DOI: 10.1098/rspa.2016.0117. Parameterized mesoscale eddies are represented in ocean models using schemes such as the Gent-McWilliams scheme.',
),
CFStandardNameDC(
name='eastward_sea_water_velocity_due_to_tides',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Due to tides" means due to all astronomical gravity changes which manifest as tides. No distinction is made between different tidal components.',
),
CFStandardNameDC(
name='eastward_transformed_eulerian_mean_air_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). The "Transformed Eulerian Mean" refers to a formulation of the mean equations which incorporates some eddy terms into the definition of the mean, described in Andrews et al (1987): Middle Atmospheric Dynamics. Academic Press.',
),
CFStandardNameDC(
name='eastward_water_vapor_flux_in_air',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward).  In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='eastward_water_vapor_transport_across_unit_distance_in_atmosphere_layer',
canonical_units='kg m-1 s-1',
grib=None,
amip=None,
description='"Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). Transport across_unit_distance means expressed per unit distance normal to the direction of transport.',
),
CFStandardNameDC(
name='eastward_wind',
canonical_units='m s-1',
grib='33 E131',
amip='ua',
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). Wind is defined as a two-dimensional (horizontal) air velocity vector, with no vertical component. (Vertical motion in the atmosphere has the standard name upward_air_velocity.)',
),
CFStandardNameDC(
name='eastward_wind_shear',
canonical_units='s-1',
grib='45',
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). Wind is defined as a two-dimensional (horizontal) air velocity vector, with no vertical component. (Vertical motion in the atmosphere has the standard name upward_air_velocity.) Wind shear is the derivative of wind with respect to height.',
),
CFStandardNameDC(
name='effective_radius_of_cloud_condensed_water_particles_at_cloud_top',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals,is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. "cloud_top" refers to the top of the  highest cloud. "condensed_water" means liquid and ice.',
),
CFStandardNameDC(
name='effective_radius_of_cloud_liquid_water_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='effective_radius_of_cloud_liquid_water_particles_at_liquid_water_cloud_top',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution.  "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop. The phrase "cloud_top" refers to the top of the highest cloud.',
),
CFStandardNameDC(
name='effective_radius_of_convective_cloud_ice_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='effective_radius_of_convective_cloud_liquid_water_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. Convective cloud is that produced by the convection schemes in an atmosphere model. "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='effective_radius_of_convective_cloud_liquid_water_particles_at_convective_liquid_water_cloud_top',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. The phrase "convective_liquid_water_cloud_top" refers to the top of the highest convective liquid water cloud. Convective cloud is that produced by the convection schemes in an atmosphere model. "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='effective_radius_of_convective_cloud_rain_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='effective_radius_of_convective_cloud_snow_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='effective_radius_of_stratiform_cloud_graupel_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes).',
),
CFStandardNameDC(
name='effective_radius_of_stratiform_cloud_ice_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes).',
),
CFStandardNameDC(
name='effective_radius_of_stratiform_cloud_liquid_water_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes). "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='effective_radius_of_stratiform_cloud_liquid_water_particles_at_stratiform_liquid_water_cloud_top',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. The phrase "stratiform_liquid_water_cloud_top" refers to the top of the highest stratiform liquid water cloud. In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes). "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='effective_radius_of_stratiform_cloud_rain_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes).',
),
CFStandardNameDC(
name='effective_radius_of_stratiform_cloud_snow_particles',
canonical_units='m',
grib=None,
amip=None,
description='The effective radius of a size distribution of particles, such as aerosols, cloud droplets or ice crystals, is the area weighted mean radius of particle size. It is calculated as the ratio of the third to the second moment of the particle size distribution. In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes).',
),
CFStandardNameDC(
name='electrical_mobility_diameter_of_ambient_aerosol_particles',
canonical_units='m',
grib=None,
amip=None,
description='The diameter of an aerosol particle as selected by its electrical mobility. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='enrichment_of_14C_in_carbon_dioxide_in_air_expressed_as_uppercase_delta_14C',
canonical_units='1e-3',
grib=None,
amip=None,
description='Isotopic enrichment of 14C, often called d14C or delta14C (lower case delta), is used to calculate the fossil fuel contribution to atmospheric carbon dioxide using isotopic ratios of carbon. It is a parameterisation of the 14C/12C isotopic ratio in the sample with respect to the isotopic ratio in a reference standard. It is computed using the formula (((14C/12C)sample / (14C/12C)standard) - 1) * 1000. The quantity called D14C, or Delta14C (upper case delta) is d14C corrected for isotopic fractionation using the 13C/12C ratio as follows: D14C = d14C - 2(dC13 + 25)(1+d14C/1000). If the sample is enriched in 14C relative to the standard, then the data value is positive. Reference: Stuiver, M. and H.A. Polach, 1977, Discussion reporting of 14C data, Radiocarbon, Volume 19, No. 3, 355-363, doi: 10.1017/S0033822200003672. The reference standard used in the calculation of delta14C should be specified by attaching a long_name attribute to the data variable. "C" means the element carbon and "14C" is the radioactive isotope "carbon-14", having six protons and eight neutrons and used in radiocarbon dating.',
),
CFStandardNameDC(
name='enthalpy_content_of_atmosphere_layer',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='equilibrium_line_altitude',
canonical_units='m',
grib=None,
amip=None,
description='Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level. The equilibrium line is the locus of points on a land ice surface at which ice accumulation balances ice ablation over the year.',
),
CFStandardNameDC(
name='equivalent_pressure_of_atmosphere_ozone_content',
canonical_units='Pa',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The equivalent pressure of a particular constituent of the atmosphere is the surface pressure exerted by the weight of that constituent alone.',
),
CFStandardNameDC(
name='equivalent_reflectivity_factor',
canonical_units='dBZ',
grib=None,
amip=None,
description='"Equivalent reflectivity factor"  is the radar reflectivity factor that is calculated from the measured radar return power assuming the target is composed of liquid water droplets whose diameter is less than one tenth of the radar wavelength, i.e., treating the droplets as Rayleigh scatterers.  The actual radar reflectivity factor would depend on the size distribution and composition of the particles within the target volume and these are  often unknown.',
),
CFStandardNameDC(
name='equivalent_thickness_at_stp_of_atmosphere_ozone_content',
canonical_units='m',
grib='10',
amip=None,
description='"stp" means standard temperature (0 degC) and pressure (101325 Pa). "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. The equivalent thickness at STP of a particular constituent of the atmosphere is the thickness of the layer that the gas would occupy if it was separated from the other constituents and gathered together at STP. equivalent_thickness_at_stp_of_atmosphere_ozone_content is usually measured in Dobson Units which are equivalent to 446.2 micromoles m-2 or an equivalent thickness at STP of 10 micrometers. N.B. Data variables containing column content of ozone can be given the standard name of either equivalent_thickness_at_stp_of_atmosphere_ozone_content or atmosphere_mole_content_of_ozone. The latter name is recommended for consistency with mole content names for chemical species other than ozone.',
),
CFStandardNameDC(
name='ertel_potential_vorticity',
canonical_units='K m2 kg-1 s-1',
grib=None,
amip='vorpot',
description='The Ertel potential vorticity is the scalar product of the atmospheric absolute vorticity vector and the gradient of potential temperature. It is a conserved quantity in the absence of friction and heat sources [AMS Glossary, http://glossary.ametsoc.org/wiki/Ertel_potential_vorticity]. A frequently used simplification of the general Ertel potential vorticity considers the Earth rotation vector to have only a vertical component. Then, only the vertical contribution of the scalar product is calculated.',
),
CFStandardNameDC(
name='fast_soil_pool_mass_content_of_carbon',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "soil content" of a quantity refers to the vertical integral from the surface down to the bottom of the soil model. For the content between specified levels in the soil, standard names including content_of_soil_layer are used. Soil carbon is returned to the atmosphere as the organic matter decays. The decay process takes varying amounts of time depending on the composition of the organic matter, the temperature and the availability of moisture. A carbon "soil pool" means the carbon contained in organic matter which has a characteristic period over which it decays and releases carbon into the atmosphere. "Fast soil pool" refers to the decay of organic matter in soil with a characteristic period of less than ten years under reference climate conditions of a temperature of 20 degrees Celsius and no water limitations.',
),
CFStandardNameDC(
name='final_air_pressure_of_lifted_parcel',
canonical_units='Pa',
grib=None,
amip=None,
description='Various stability and convective potential indices are calculated by "lifting" a parcel of air: moving it dry adiabatically from a starting height (often the surface) to the Lifting Condensation Level, and then wet adiabatically from there to an ending height (often the top of the data/model/atmosphere). The quantities with standard names original_air_pressure_of_lifted_parcel and final_air_pressure_of_lifted_parcel are the ambient air pressure at the start and end of lifting, respectively. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='fire_area',
canonical_units='m2',
grib=None,
amip=None,
description='"X_area" means the horizontal area occupied by X within the grid cell. The extent of an individual grid cell is defined by the horizontal coordinates and any associated coordinate bounds or by a string valued auxiliary coordinate variable with a standard name of "region". "Fire area" means the area of detected biomass fire.',
),
CFStandardNameDC(
name='fire_radiative_power',
canonical_units='W',
grib=None,
amip=None,
description='The product of the irradiance (the power per unit area) of a biomass fire and the corresponding fire area. A data variable containing the area affected by fire should be given the standard name fire_area.',
),
CFStandardNameDC(
name='fire_temperature',
canonical_units='K',
grib=None,
amip=None,
description='The overall temperature of a fire area due to contributions from smoldering and flaming biomass. A data variable containing the area affected by fire should be given the standard name fire_area.',
),
CFStandardNameDC(
name='flat_line_test_quality_flag',
canonical_units='1',
grib=None,
amip=None,
description='A quality flag that reports the result of the Flat Line test, which checks for consecutively repeated values within a tolerance. The linkage between the data variable and this variable is achieved using the ancillary_variables attribute. There are standard names for other specific quality tests which take the form of X_quality_flag. Quality information that does not match any of the specific quantities should be given the more general standard name of quality_flag.',
),
CFStandardNameDC(
name='floating_ice_shelf_area',
canonical_units='m2',
grib=None,
amip=None,
description='"X_area" means the horizontal area occupied by X within the grid cell. The extent of an individual grid cell is defined by the horizontal coordinates and any associated coordinate bounds or by a string valued auxiliary coordinate variable with a standard name of "region". A "floating ice shelf", sometimes called a "floating ice sheet", indicates where an ice sheet extending from a land area flows over sea water.',
),
CFStandardNameDC(
name='floating_ice_shelf_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. A "floating ice shelf", sometimes called a "floating ice sheet", indicates where an ice sheet extending from a land area flows over sea water.',
),
CFStandardNameDC(
name='floating_ice_thickness',
canonical_units='m',
grib=None,
amip=None,
description='"Floating ice" means any ice that is floating on water, e.g. on a sea or lake surface.  "Thickness" means the vertical extent of the ice.',
),
CFStandardNameDC(
name='flood_water_duration_above_threshold',
canonical_units='s',
grib=None,
amip=None,
description='The  quantity with standard name flood_water_duration_above_threshold is the time elapsed between the instant when the flood depth first rises above a given threshold until the time falls below the same threshold for the last time at a given point in space. If a threshold is supplied, it should be specified by associating a coordinate variable or scalar coordinate variable with the data variable and giving the coordinate variable a standard name of flood_water_thickness. The values of the coordinate variable are the threshold values for the corresponding subarrays of the data variable. If no threshold is specified, its value is taken to be zero. Flood water is water that covers land which is normally not covered by water.',
),
CFStandardNameDC(
name='flood_water_speed',
canonical_units='m s-1',
grib=None,
amip=None,
description='Speed is the magnitude of velocity. Flood water is water that covers land which is normally not covered by water.',
),
CFStandardNameDC(
name='flood_water_thickness',
canonical_units='m',
grib=None,
amip=None,
description='The flood_water_thickness is the vertical distance between the surface of the flood water and the surface of the solid ground, as measured at a given point in space. The standard name ground_level_altitude is used for a data variable giving the geometric height of the ground surface above the geoid. "Flood water" is water that covers land which is normally not covered by water.',
),
CFStandardNameDC(
name='fog_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. Fog means water droplets or minute ice crystals close to the surface which reduce visibility in air to less than 1000m.',
),
CFStandardNameDC(
name='forecast_period',
canonical_units='s',
grib=None,
amip=None,
description='Forecast period is the time interval between the forecast reference time and the validity time. A period is an interval of time, or the time-period of an oscillation.',
),
CFStandardNameDC(
name='forecast_reference_time',
canonical_units='s',
grib=None,
amip=None,
description='The forecast reference time in NWP is the "data time", the time of the analysis from which the forecast was made. It is not the time for which the forecast is valid; the standard name of time should be used for that time.',
),
CFStandardNameDC(
name='fractional_saturation_of_oxygen_in_sea_water',
canonical_units='1',
grib=None,
amip=None,
description='Fractional saturation is the ratio of some measure of concentration to the saturated value of the same quantity.',
),
CFStandardNameDC(
name='fraction_of_surface_downwelling_photosynthetic_radiative_flux_absorbed_by_vegetation',
canonical_units='1',
grib=None,
amip=None,
description='Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The surface called "surface" means the lower boundary of the atmosphere. The quantity with standard name fraction_of_surface_downwelling_photosynthetic_radiative_flux_absorbed_by_vegetation, often called Fraction of Absorbed Photosynthetically Active Radiation (FAPAR), is the fraction of incoming solar radiation in the photosynthetically active radiation spectral region that is absorbed by a vegetation canopy. "Photosynthetic" radiation is the part of the spectrum which is used in photosynthesis e.g. 400-700 nm. The range of wavelengths could be specified precisely by the bounds of a coordinate of "radiation_wavelength". When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Vegetation" means any plants e.g. trees, shrubs, grass. The term "plants" refers to the kingdom of plants in the modern classification which excludes fungi. Plants are autotrophs i.e. "producers" of biomass using carbon obtained from carbon dioxide.',
),
CFStandardNameDC(
name='fraction_of_time_with_sea_ice_area_fraction_above_threshold',
canonical_units='1',
grib=None,
amip=None,
description='"Fraction of time" is the fraction of a time period defined by the bounds of the time coordinate variable for which a characteristic of interest exists. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. "Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. Sea ice area fraction is area of the sea surface occupied by sea ice. The area threshold value must be specified by supplying a coordinate variable or scalar coordinate variable with the standard name of sea_ice_area_fraction. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='freezing_level_altitude',
canonical_units='m',
grib=None,
amip=None,
description='Altitude is the (geometric) height above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level.',
),
CFStandardNameDC(
name='freezing_temperature_of_sea_water',
canonical_units='K',
grib=None,
amip=None,
description=None,
),
CFStandardNameDC(
name='frequency_of_lightning_flashes_per_unit_area',
canonical_units='m-2 s-1',
grib=None,
amip=None,
description='A lightning flash is a compound event, usually consisting of several discharges. Frequency is the number of oscillations of a wave, or the number of occurrences of an event, per unit time.',
),
CFStandardNameDC(
name='frozen_water_content_of_soil_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"frozen_water" means ice. "Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Quantities defined for a soil layer must have a vertical coordinate variable with boundaries indicating the extent of the layer(s).',
),
CFStandardNameDC(
name='fugacity_of_carbon_dioxide_in_sea_water',
canonical_units='Pa',
grib=None,
amip=None,
description='The fugacity is the measured pressure (or partial pressure) of a real gas corrected for the intermolecular forces of that gas, which allows that corrected quantity to be treated like the pressure of an ideal gas in the ideal gas equation PV = nRT. The partial pressure of a dissolved gas in sea water is the partial pressure in air with which it would be in equilibrium. The partial pressure of a gaseous constituent of air is the pressure that it would exert if all other gaseous constituents were removed, assuming the volume, the temperature, and its number of moles remain unchanged. The chemical formula for carbon dioxide is CO2.',
),
CFStandardNameDC(
name='gap_test_quality_flag',
canonical_units='1',
grib=None,
amip=None,
description='A quality flag that reports the result of the Timing/Gap test, which checks that data have been received within the expected time window and have the correct time stamp. The linkage between the data variable and this variable is achieved using the ancillary_variables attribute. There are standard names for other specific quality tests which take the form of X_quality_flag. Quality information that does not match any of the specific quantities should be given the more general standard name of quality_flag.',
),
CFStandardNameDC(
name='geoid_height_above_reference_ellipsoid',
canonical_units='m',
grib=None,
amip=None,
description='The geoid is a surface of constant geopotential with which mean sea level would coincide if the ocean were at rest. (The volume enclosed between the geoid and the sea floor equals the mean volume of water in the ocean). In an ocean GCM the geoid is the surface of zero depth, or the rigid lid if the model uses that approximation. A reference ellipsoid is a regular mathematical figure that approximates the irregular shape of the geoid. A number of reference ellipsoids are defined for use in the field of geodesy. To specify which reference ellipsoid is being used, a grid_mapping variable should be attached to the data variable as described in Chapter 5.6 of the CF Convention.',
),
CFStandardNameDC(
name='geopotential',
canonical_units='m2 s-2',
grib='6 E129',
amip=None,
description='Geopotential is the sum of the specific gravitational potential energy relative to the geoid and the specific centripetal potential energy.',
),
CFStandardNameDC(
name='geopotential_height',
canonical_units='m',
grib='7 E156',
amip='zg',
description='Geopotential is the sum of the specific gravitational potential energy relative to the geoid and the specific centripetal potential energy. Geopotential height is the geopotential divided by the standard acceleration due to gravity. It is numerically similar to the altitude (or geometric height) and not to the quantity with standard name height, which is relative to the surface.',
),
CFStandardNameDC(
name='geopotential_height_anomaly',
canonical_units='m',
grib='27',
amip=None,
description='"anomaly" means difference from climatology. Geopotential is the sum of the specific gravitational potential energy relative to the geoid and the specific centripetal potential energy. Geopotential height is the geopotential divided by the standard acceleration due to gravity. It is numerically similar to the altitude (or geometric height) and not to the quantity with standard name height, which is relative to the surface.',
),
CFStandardNameDC(
name='geopotential_height_at_cloud_top',
canonical_units='m',
grib=None,
amip=None,
description='Cloud_top refers to the top of the highest cloud. Geopotential is the sum of the specific gravitational potential energy relative to the geoid and the specific centripetal potential energy. Geopotential height is the geopotential divided by the standard acceleration due to gravity. It is numerically similar to the altitude (or geometric height) and not to the quantity with standard name "height", which is relative to the surface.',
),
CFStandardNameDC(
name='geopotential_height_at_volcanic_ash_cloud_top',
canonical_units='m',
grib=None,
amip=None,
description='Geopotential is the sum of the specific gravitational potential energy relative to the geoid and the specific centripetal potential energy. Geopotential height is the geopotential divided by the standard acceleration due to gravity. It is numerically similar to the altitude (or geometric height) and not to the quantity with standard name "height", which is relative to the surface. "Volcanic_ash" means the fine-grained products of explosive volcanic eruptions, such as minerals or crystals, older fragmented rock (e.g. andesite), and glass. Particles within a volcanic ash cloud have diameters less than 2 mm. "Volcanic_ash" does not include non-volcanic dust.',
),
CFStandardNameDC(
name='geostrophic_eastward_sea_water_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Eastward" indicates a vector component which is positive when directed eastward (negative westward). "Geostrophic" indicates that geostrophic balance is assumed, i.e. that the pressure gradient force and the Coriolis force are balanced and the large scale fluid flow is parallel to the isobars.',
),
CFStandardNameDC(
name='geostrophic_eastward_wind',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Eastward" indicates a vector component which is positive when directed eastward (negative westward). Wind is defined as a two-dimensional (horizontal) air velocity vector, with no vertical component. (Vertical motion in the atmosphere has the standard name upward_air_velocity.) "Geostrophic" indicates that geostrophic balance is assumed, i.e. that the pressure gradient force and the Coriolis force are balanced and the large scale fluid flow is parallel to the isobars.',
),
CFStandardNameDC(
name='geostrophic_northward_sea_water_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "Northward" indicates a vector component which is positive when directed northward (negative southward). "Geostrophic" indicates that geostrophic balance is assumed, i.e. that the pressure gradient force and the Coriolis force are balanced and the large scale fluid flow is parallel to the isobars.',
),
CFStandardNameDC(
name='geostrophic_northward_wind',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Northward" indicates a vector component which is positive when directed northward (negative southward). Wind is defined as a two-dimensional (horizontal) air velocity vector, with no vertical component. (Vertical motion in the atmosphere has the standard name upward_air_velocity.) "Geostrophic" indicates that geostrophic balance is assumed, i.e. that the pressure gradient force and the Coriolis force are balanced and the large scale fluid flow is parallel to the isobars.',
),
CFStandardNameDC(
name='global_average_sea_level_change',
canonical_units='m',
grib=None,
amip=None,
description='Global average sea level change is due to change in volume of the water in the ocean, caused by mass and/or density change, or to change in the volume of the ocean basins, caused by tectonics etc. It is sometimes called "eustatic", which is a term that also has other definitions. It differs from the change in the global average sea surface height relative to the centre of the Earth by the global average vertical movement of the ocean floor. Zero sea level change is an arbitrary level. Because global average sea level change quantifies the change in volume of the world ocean, it is not calculated necessarily by considering local changes in mean sea level.',
),
CFStandardNameDC(
name='global_average_steric_sea_level_change',
canonical_units='m',
grib=None,
amip=None,
description='Global average steric sea level change is caused by changes in sea water density due to changes in temperature (thermosteric) and salinity (halosteric). This in turn results in a change in volume of the world ocean. Zero sea level change is an arbitrary level. Because global average sea level change quantifies the change in volume of the world ocean, it is not calculated necessarily by considering local changes in mean sea level.',
),
CFStandardNameDC(
name='global_average_thermosteric_sea_level_change',
canonical_units='m',
grib=None,
amip=None,
description='Global average thermosteric sea level change is the part caused by change in density due to change in temperature i.e. thermal expansion. This in turn results in a change in volume of the world ocean. Zero sea level change is an arbitrary level. Because global average sea level change quantifies the change in volume of the world ocean, it is not calculated necessarily by considering local changes in mean sea level.',
),
CFStandardNameDC(
name='graupel_and_hail_fall_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Amount" means mass per unit area. Graupel consists of heavily rimed snow particles, often called snow pellets; often indistinguishable from very small soft hail except when the size convention that hail must have a diameter greater than 5 mm is adopted. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Graupel. Hail is precipitation in the form of balls or irregular lumps of ice, often restricted by a size convention to diameters of 5 mm or more. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Hail. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel. For models that do distinguish between them, separate standard names for hail and graupel are available.',
),
CFStandardNameDC(
name='graupel_and_hail_fall_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. Graupel consists of heavily rimed snow particles, often called snow pellets; often indistinguishable from very small soft hail except when the size convention that hail must have a diameter greater than 5 mm is adopted. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Graupel. Hail is precipitation in the form of balls or irregular lumps of ice, often restricted by a size convention to diameters of 5 mm or more. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Hail. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel. For models that do distinguish between them, separate standard names for hail and graupel are available.',
),
CFStandardNameDC(
name='graupel_fall_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Amount" means mass per unit area. Graupel consists of heavily rimed snow particles, often called snow pellets; often indistinguishable from very small soft hail except for the size convention that hail must have a diameter greater than 5 mm. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Graupel.',
),
CFStandardNameDC(
name='graupel_fall_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. Graupel consists of heavily rimed snow particles, often called snow pellets; often indistinguishable from very small soft hail except when the size convention that hail must have a diameter greater than 5 mm is adopted. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Graupel. There are also separate standard names for hail. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel.',
),
CFStandardNameDC(
name='grid_latitude',
canonical_units='degree',
grib=None,
amip=None,
description='Latitude is positive northward; its units of degree_north (or equivalent) indicate this explicitly. In a latitude-longitude system defined with respect to a rotated North Pole, the standard name of grid_latitude should be used instead of latitude. Grid latitude is positive in the grid-northward direction, but its units should be plain degree.',
),
CFStandardNameDC(
name='grid_longitude',
canonical_units='degree',
grib=None,
amip=None,
description='Longitude is positive eastward; its units of degree_east (or equivalent) indicate this explicitly. In a latitude-longitude system defined with respect to a rotated North Pole, the standard name of grid_longitude should be used instead of longitude. Grid longitude is positive in the grid-eastward direction, but its units should be plain degree.',
),
CFStandardNameDC(
name='gross_primary_productivity_of_biomass_expressed_as_13C',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Production of carbon" means the production of biomass expressed as the mass of carbon which it contains. Gross primary production is the rate of synthesis of biomass from inorganic precursors by autotrophs ("producers"), for example, photosynthesis in plants or phytoplankton. The producers also respire some of this biomass and the difference is "net_primary_production". "Productivity" means production per unit area. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "C" means the element carbon and "13C" is the stable isotope "carbon-13", having six protons and seven neutrons.',
),
CFStandardNameDC(
name='gross_primary_productivity_of_biomass_expressed_as_14C',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Production of carbon" means the production of biomass expressed as the mass of carbon which it contains. Gross primary production is the rate of synthesis of biomass from inorganic precursors by autotrophs ("producers"), for example, photosynthesis in plants or phytoplankton. The producers also respire some of this biomass and the difference is "net_primary_production". "Productivity" means production per unit area. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "C" means the element carbon and "14C" is the radioactive isotope "carbon-14", having six protons and eight neutrons and used in radiocarbon dating.',
),
CFStandardNameDC(
name='gross_primary_productivity_of_biomass_expressed_as_carbon',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Production of carbon" means the production of biomass expressed as the mass of carbon which it contains. Gross primary production is the rate of synthesis of biomass from inorganic precursors by autotrophs ("producers"), for example, photosynthesis in plants or phytoplankton. The producers also respire some of this biomass and the difference is "net_primary_production". "Productivity" means production per unit area. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='gross_range_test_quality_flag',
canonical_units='1',
grib=None,
amip=None,
description='A quality flag that reports the result of the Gross Range test, which checks that values are within reasonable range bounds. The linkage between the data variable and this variable is achieved using the ancillary_variables attribute. There are standard names for other specific quality tests which take the form of X_quality_flag. Quality information that does not match any of the specific quantities should be given the more general standard name of quality_flag.',
),
CFStandardNameDC(
name='gross_rate_of_decrease_in_area_fraction',
canonical_units='s-1',
grib=None,
amip=None,
description='The "gross rate of decrease in area fraction" is the fraction of a grid cell that transitions from a given area type per unit time, for example, as a result of land use changes. The quantity described by this standard name is a gross decrease because it includes only land where the use transitions away from the given area type and excludes land that transitions to that area type during the same period. The area type should be specified using a coordinate of scalar coordinate variable with standard name area_type. There is also a standard name for gross_rate_of_increase_in_area_fraction. "Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area',
),
CFStandardNameDC(
name='gross_rate_of_increase_in_area_fraction',
canonical_units='s-1',
grib=None,
amip=None,
description='The "rate of increase in area fraction" is the fraction of a grid cell that transitions to a given area type per unit time, for example, as a result of land use changes. The quantity described by this standard name is a gross increase because it includes only land where the use transitions to the given area type and excludes land that transitions away from that area type during the same period. The area type should be specified using a coordinate or scalar coordinate variable with standard name area_type. There is also a standard name for gross_rate_of_decrease_in_area_fraction. "Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area.',
),
CFStandardNameDC(
name='grounded_ice_sheet_area',
canonical_units='m2',
grib=None,
amip=None,
description='"X_area" means the horizontal area occupied by X within the grid cell. The extent of an individual grid cell is defined by the horizontal coordinates and any associated coordinate bounds or by a string valued auxiliary coordinate variable with a standard name of "region". "Grounded ice sheet" indicates where the ice sheet rests over bedrock and is thus grounded. It excludes ice-caps, glaciers and floating ice shelves.',
),
CFStandardNameDC(
name='grounded_ice_sheet_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. "Grounded ice sheet" indicates where the ice sheet rests over bedrock and is thus grounded. It excludes ice-caps, glaciers and floating ice shelves.',
),
CFStandardNameDC(
name='ground_level_altitude',
canonical_units='m',
grib=None,
amip=None,
description='The ground_level_altitude is the geometric height of the upper boundary of the solid Earth above the geoid, which is the reference geopotential surface. The geoid is similar to mean sea level.',
),
CFStandardNameDC(
name='growth_limitation_of_calcareous_phytoplankton_due_to_solar_irradiance',
canonical_units='1',
grib=None,
amip=None,
description='"Calcareous phytoplankton" are phytoplankton that produce calcite.  Calcite is a mineral that is a polymorph of calcium carbonate. The chemical formula of calcite is CaCO3. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Irradiance" means the power per unit area (called radiative flux in other standard names), the area being normal to the direction of flow of the radiant energy. Solar irradiance is essential to the photosynthesis reaction and its presence promotes the growth of phytoplankton populations. "Growth limitation due to solar irradiance" means the ratio of the growth rate of a species population in the environment (where the amount of sunlight reaching a location may be limited) to the theoretical growth rate if there were no such limit on solar irradiance.',
),
CFStandardNameDC(
name='growth_limitation_of_diatoms_due_to_solar_irradiance',
canonical_units='1',
grib=None,
amip=None,
description='Diatoms are phytoplankton with an external skeleton made of silica. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Irradiance" means the power per unit area (called radiative flux in other standard names), the area being normal to the direction of flow of the radiant energy. Solar irradiance is essential to the photosynthesis reaction and its presence promotes the growth of phytoplankton populations. "Growth limitation due to solar irradiance" means the ratio of the growth rate of a species population in the environment (where the amount of sunlight reaching a location may be limited) to the theoretical growth rate if there were no such limit on solar irradiance.',
),
CFStandardNameDC(
name='growth_limitation_of_diazotrophic_phytoplankton_due_to_solar_irradiance',
canonical_units='1',
grib=None,
amip=None,
description='"Growth limitation due to solar irradiance" means the ratio of the growth rate of a biological population in the environment (where the amount of sunlight reaching a location may be limited) to the theoretical growth rate if there were no such limit on solar irradiance. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Irradiance" means the power per unit area (called radiative flux in other standard names), the area being normal to the direction of flow of the radiant energy. Solar irradiance is essential to the photosynthesis reaction and its presence promotes the growth of phytoplankton populations. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. Diazotrophic phytoplankton are phytoplankton (predominantly from Phylum Cyanobacteria) that are able to fix molecular nitrogen (gas or solute) in addition to nitrate and ammonium.',
),
CFStandardNameDC(
name='growth_limitation_of_miscellaneous_phytoplankton_due_to_solar_irradiance',
canonical_units='1',
grib=None,
amip=None,
description='Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. "Miscellaneous phytoplankton" are all those phytoplankton that are not diatoms, diazotrophs, calcareous phytoplankton, picophytoplankton or other separately named components of the phytoplankton population. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Irradiance" means the power per unit area (called radiative flux in other standard names), the area being normal to the direction of flow of the radiant energy. Solar irradiance is essential to the photosynthesis reaction and its presence promotes the growth of phytoplankton populations. "Growth limitation due to solar irradiance" means the ratio of the growth rate of a species population in the environment (where the amount of sunlight reaching a location may be limited) to the theoretical growth rate if there were no such limit on solar irradiance.',
),
CFStandardNameDC(
name='growth_limitation_of_picophytoplankton_due_to_solar_irradiance',
canonical_units='1',
grib=None,
amip=None,
description='Picophytoplankton are phytoplankton of less than 2 micrometers in size. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Irradiance" means the power per unit area (called radiative flux in other standard names), the area being normal to the direction of flow of the radiant energy. Solar irradiance is essential to the photosynthesis reaction and its presence promotes the growth of phytoplankton populations. "Growth limitation due to solar irradiance" means the ratio of the growth rate of a species population in the environment (where the amount of sunlight reaching a location may be limited) to the theoretical growth rate if there were no such limit on solar irradiance.',
),
CFStandardNameDC(
name='hail_fall_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Amount" means mass per unit area. Hail is precipitation in the form of balls or irregular lumps of ice, often restricted by a size convention to diameters of 5 mm or more. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Hail. For diameters of less than 5 mm standard names for "graupel" should be used. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel.',
),
CFStandardNameDC(
name='hail_fall_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. Hail is precipitation in the form of balls or irregular lumps of ice, often restricted by a size convention to diameters of 5 mm or more. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Hail. For diameters of less than 5 mm standard names for "graupel" should be used. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel.',
),
CFStandardNameDC(
name='halosteric_change_in_mean_sea_level',
canonical_units='m',
grib=None,
amip=None,
description='Halosteric sea level change is the part caused by change in sea water density due to change in salinity. "Mean sea level" means the time mean of sea surface elevation at a given location over an arbitrary period sufficient to eliminate the tidal signals. Zero mean sea level change is an arbitrary level. The sum of the quantities with standard names thermosteric_change_in_mean_sea_level and halosteric_change_in_mean_sea_level has the standard name steric_change_in_mean_sea_level.',
),
CFStandardNameDC(
name='halosteric_change_in_sea_surface_height',
canonical_units='m',
grib=None,
amip=None,
description='"Sea surface height" is a time-varying quantity. The halosteric change in sea surface height is the change in height that a water column of standard practical salinity S=35.0 would undergo when its salinity is changed to the observed value. The sum of the quantities with standard names thermosteric_change_in_sea_surface_height and halosteric_change_in_sea_surface_height is the total steric change in the water column height, which has the standard name of steric_change_in_sea_surface_height.',
),
CFStandardNameDC(
name='harmonic_period',
canonical_units='s',
grib=None,
amip=None,
description='A period is an interval of time, or the time-period of an oscillation.',
),
CFStandardNameDC(
name='heat_flux_correction',
canonical_units='W m-2',
grib=None,
amip='hfcorr',
description='Flux correction is also called "flux adjustment". A positive flux correction is downward i.e. added to the ocean. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='heat_flux_into_sea_water_due_to_freezing_of_frazil_ice',
canonical_units='W m-2',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Frazil" consists of needle like crystals of ice, typically between three and four millimeters in diameter, which form as sea water begins to freeze. Salt is expelled during the freezing process and frazil ice consists of nearly pure fresh water.',
),
CFStandardNameDC(
name='heat_flux_into_sea_water_due_to_iceberg_thermodynamics',
canonical_units='W m-2',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.  The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity  named by omitting the phrase.  " Iceberg thermodynamics" refers to the addition or subtraction of mass due to surface and basal fluxes, i.e., due to melting, sublimation and fusion.',
),
CFStandardNameDC(
name='heat_flux_into_sea_water_due_to_newtonian_relaxation',
canonical_units='W m-2',
grib=None,
amip=None,
description='The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.  The heat_flux_into_sea_water_due_to_newtonian_relaxation is the heat flux resulting from the Newtonian relaxation of the sea surface temperature. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='heat_flux_into_sea_water_due_to_sea_ice_thermodynamics',
canonical_units='W m-2',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Sea ice thermodynamics" refers to the addition or subtraction of mass due to surface and basal fluxes, i.e., due to melting, sublimation and fusion. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='heat_flux_into_sea_water_due_to_snow_thermodynamics',
canonical_units='W m-2',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.  The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity  named by omitting the phrase.  "Snow thermodynamics" refers to the addition or subtraction of mass due to surface and basal fluxes, i.e., due to melting, sublimation and fusion.',
),
CFStandardNameDC(
name='height',
canonical_units='m',
grib=None,
amip='zh',
description='Height is the vertical distance above the surface.',
),
CFStandardNameDC(
name='height_above_geopotential_datum',
canonical_units='m',
grib=None,
amip=None,
description='"Height_above_X" means the vertical distance above the named surface X. The "geopotential datum" is any estimated surface of constant geopotential used as a datum i.e. a reference level; for the geoid as a datum, specific standard names are available. To specify which geoid or geopotential datum is being used as a reference level, a grid_mapping variable should be attached to the data variable as described in Chapter 5.6 of the CF Convention.',
),
CFStandardNameDC(
name='height_above_geopotential_datum_at_top_of_atmosphere_model',
canonical_units='m',
grib=None,
amip=None,
description='"Height_above_X" means the vertical distance above the named surface X. The "geopotential datum" is any estimated surface of constant geopotential used as a datum i.e. a reference level; for the geoid as a datum, specific standard names are available. To specify which geoid or geopotential datum is being used as a reference level, a grid_mapping variable should be attached to the data variable as described in Chapter 5.6 of the CF Convention. "Top of atmosphere model" means the upper boundary of the top layer of an atmosphere model.',
),
CFStandardNameDC(
name='height_above_mean_sea_level',
canonical_units='m',
grib=None,
amip=None,
description='"Height_above_X" means the vertical distance above the named surface X. "Mean sea level" means the time mean of sea surface elevation at a given location over an arbitrary period sufficient to eliminate the tidal signals.',
),
CFStandardNameDC(
name='height_above_reference_ellipsoid',
canonical_units='m',
grib=None,
amip=None,
description='"Height_above_X" means the vertical distance above the named surface X. A reference ellipsoid is a mathematical figure that approximates the geoid. The geoid is a surface of constant geopotential with which mean sea level would coincide if the ocean were at rest. The ellipsoid is an approximation because the geoid is an irregular shape. A number of reference ellipsoids are defined for use in the field of geodesy. To specify which reference ellipsoid is being used, a grid_mapping variable should be attached to the data variable as described in Chapter 5.6 of the CF Convention.',
),
CFStandardNameDC(
name='height_above_sea_floor',
canonical_units='m',
grib=None,
amip=None,
description=None,
),
CFStandardNameDC(
name='height_at_cloud_top',
canonical_units='m',
grib=None,
amip=None,
description='cloud_top refers to the top of the highest cloud. Height is the vertical distance above the surface.',
),
CFStandardNameDC(
name='height_at_effective_cloud_top_defined_by_infrared_radiation',
canonical_units='m',
grib=None,
amip=None,
description='The "effective cloud top defined by infrared radiation" is (approximately) the geometric height above the surface that is one optical depth at infrared wavelengths (in the region of 11 micrometers) below the cloud top that would be detected by visible and lidar techniques. Reference: Minnis, P. et al 2011 CERES Edition-2 Cloud Property Retrievals Using TRMM VIRS and Terra and Aqua MODIS Data x2014; Part I: Algorithms IEEE Transactions on Geoscience and Remote Sensing, 49(11), 4374-4400. doi: http://dx.doi.org/10.1109/TGRS.2011.2144601.',
),
CFStandardNameDC(
name='high_type_cloud_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. High type clouds are: Cirrus, Cirrostratus, Cirrocumulus. X_type_cloud_area_fraction is generally determined on the basis of cloud type, though Numerical Weather Prediction (NWP) models often calculate them based on the vertical location of the cloud. For the cloud area fraction between specified levels in the atmosphere, standard names including "cloud_area_fraction_in_atmosphere_layer" are used. Standard names referring only to "cloud_area_fraction" should be used for quantities for the whole atmosphere column. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='histogram_of_backscattering_ratio_in_air_over_height_above_reference_ellipsoid',
canonical_units='1',
grib=None,
amip=None,
description='Scattering of radiation is its deflection from its incident path without loss of energy.  Backwards scattering refers to the sum of scattering into all backward angles i.e. scattering_angle exceeding pi/2 radians. A scattering_angle should not be specified with this quantity. "Backscattering ratio" is the ratio of the quantity with standard name volume_attenuated_backwards_scattering_function_in_air to the quantity with standard name volume_attenuated_backwards_scattering_function_in_air_assuming_no_aerosol_or_cloud. "histogram_of_X[_over_Z]" means histogram (i.e. number of counts for each range of X) of variations (over Z) of X. The data variable should have an axis for X. A reference ellipsoid is a regular mathematical figure that approximates the irregular shape of the geoid. A number of reference ellipsoids are defined for use in the field of geodesy. The geoid is a surface of constant geopotential with which mean sea level would coincide if the ocean were at rest. To specify which reference ellipsoid is being used, a grid_mapping variable should be attached to the data variable as described in Chapter 5.6 of the CF Convention.',
),
CFStandardNameDC(
name='histogram_of_equivalent_reflectivity_factor_over_height_above_reference_ellipsoid',
canonical_units='1',
grib=None,
amip=None,
description='"Equivalent reflectivity factor" is the radar reflectivity factor that is calculated from the measured radar return power assuming the target is composed of liquid water droplets whose diameter is less than one tenth of the radar wavelength, i.e., treating the droplets as Rayleigh scatterers. The actual radar reflectivity factor would depend on the size distribution and composition of the particles within the target volume and these are often unknown. "histogram_of_X[_over_Z]" means histogram (i.e. number of counts for each  range of X) of variations (over Z) of X. The data variable should have an axis for X. A reference ellipsoid is a regular mathematical figure that approximates the irregular shape of the geoid. A number of reference ellipsoids are defined for use in the field of geodesy. The geoid is a surface of constant geopotential with which mean sea level would coincide if the ocean were at rest. To specify which reference ellipsoid is being used, a grid_mapping variable should be attached to the data variable as described in Chapter 5.6 of the CF Convention.',
),
CFStandardNameDC(
name='horizontal_atmosphere_dry_energy_transport',
canonical_units='W m-2',
grib=None,
amip=None,
description='Dry energy is the sum of dry static energy and kinetic energy. Dry static energy is the sum of enthalpy and potential energy (itself the sum of gravitational and centripetal potential energy). Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='horizontal_dry_energy_transport_in_atmosphere_layer',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Dry energy is the sum of dry static energy and kinetic energy. Dry static energy is the sum of enthalpy and potential energy (itself the sum of gravitational and centripetal potential energy). Enthalpy can be written either as (1) CpT, where Cp is heat capacity at constant pressure, T is absolute temperature, or (2) U+pV, where U is internal energy, p is pressure and V is volume.',
),
CFStandardNameDC(
name='humidity_mixing_ratio',
canonical_units='1',
grib='53',
amip=None,
description='Humidity mixing ratio of a parcel of moist air is the ratio of the mass of water vapor to the mass of dry air.',
),
CFStandardNameDC(
name='ice_cloud_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. The cloud area fraction is for the whole atmosphere column, as seen from the surface or the top of the atmosphere. For the cloud area fraction between specified levels in the atmosphere, standard names including "cloud_area_fraction_in_atmosphere_layer" are used. Standard names also exist for high, medium and low cloud types. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='ice_cloud_area_fraction_in_atmosphere_layer',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be "model_level_number", but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Standard names also exist for high, medium and low cloud types. Standard names referring only to "cloud_area_fraction" should be used for quantities for the whole atmosphere column. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='incoming_water_volume_transport_along_river_channel',
canonical_units='m3 s-1',
grib=None,
amip=None,
description='"Water" means water in all phases. "River" refers to water in the fluvial system (stream and floodplain).',
),
CFStandardNameDC(
name='indicative_error_from_multibeam_acoustic_doppler_velocity_profiler_in_sea_water',
canonical_units='m s-1',
grib=None,
amip=None,
description='Sea water velocity is a vector quantity that is the speed at which water travels in a specified direction. The "indicative error" is an estimate of the quality of a sea water velocity profile measured using an ADCP (acoustic doppler current profiler). It is determined by the difference between the vertical velocity calculated from two 3-beam solutions. The parameter is frequently referred to as the "error velocity".',
),
CFStandardNameDC(
name='institution',
canonical_units=None,
grib=None,
amip=None,
description='An auxiliary coordinate variable with a standard name of institution contains string values which specify where the original data, with which the coordinate variable is associated, were produced. The use of institution as the standard name for an auxiliary coordinate variable permits the aggregation of data from multiple institutions within a single data file.',
),
CFStandardNameDC(
name='integral_wrt_depth_of_product_of_conservative_temperature_and_sea_water_density',
canonical_units='kg degree_C m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. The phrase "wrt" means "with respect to". Depth is the vertical distance below the surface. The phrase "product_of_X_and_Y" means X*Y. Conservative Temperature is defined as part of the Thermodynamic Equation of Seawater 2010 (TEOS-10) which was adopted in 2010 by the International Oceanographic Commission (IOC). Conservative Temperature is specific potential enthalpy (which has the standard name sea_water_specific_potential_enthalpy) divided by a fixed value of the specific heat capacity of sea water, namely cp_0 = 3991.86795711963 J kg-1 K-1. Conservative Temperature is a more accurate measure of the "heat content" of sea water, by a factor of one hundred, than is potential temperature. Because of this, it can be regarded as being proportional to the heat content of sea water per unit mass. Reference: www.teos-10.org; McDougall, 2003 doi: 10.1175/1520-0485(2003)033<0945:PEACOV>2.0.CO;2. Sea water density is the in-situ density (not the potential density). For Boussinesq models, density is the constant Boussinesq reference density, a quantity which has the standard name reference_sea_water_density_for_boussinesq_approximation.',
),
CFStandardNameDC(
name='integral_wrt_depth_of_product_of_potential_temperature_and_sea_water_density',
canonical_units='kg degree_C m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. The phrase "wrt" means "with respect to". The phrase "product_of_X_and_Y" means X*Y. Depth is the vertical distance below the surface. Potential temperature is the temperature a parcel of air or sea water would have if moved adiabatically to sea level pressure. Sea water density is the in-situ density (not the potential density). For Boussinesq models, density is the constant Boussinesq reference density, a quantity which has the standard name reference_sea_water_density_for_boussinesq_approximation.',
),
CFStandardNameDC(
name='integral_wrt_depth_of_product_of_salinity_and_sea_water_density',
canonical_units='1e-3 kg m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. The phrase "wrt" means "with respect to". The phrase "product_of_X_and_Y" means X*Y. Depth is the vertical distance below the surface. Sea water salinity is the salt content of sea water, often on the Practical Salinity Scale of 1978. However, the unqualified term \'salinity\' is generic and does not necessarily imply any particular method of calculation. The units of salinity are dimensionless and the units attribute should normally be given as 1e-3 or 0.001 i.e. parts per thousand. There are standard names for the more precisely defined salinity quantities sea_water_knudsen_salinity, S_K (used for salinity observations between 1901 and 1966), sea_water_cox_salinity, S_C (used for salinity observations between 1967 and 1977), sea_water_practical_salinity, S_P (used for salinity observations from 1978 to the present day), sea_water_absolute_salinity, S_A, sea_water_preformed_salinity, S_*, and sea_water_reference_salinity. Practical Salinity is reported on the Practical Salinity Scale of 1978 (PSS-78), and is usually based on the electrical conductivity of sea water in observations since the 1960s. Conversion of data between the observed scales follows S_P = (S_K - 0.03) * (1.80655 / 1.805) and S_P = S_C, however the accuracy of the latter is dependent on whether chlorinity or conductivity was used to determine the S_C value, with this inconsistency driving the development of PSS-78. The more precise standard names should be used where appropriate for both modelled and observed salinities. In particular, the use of sea_water_salinity to describe salinity observations made from 1978 onwards is now deprecated in favor of the term sea_water_practical_salinity which is the salinity quantity stored by national data centers for post-1978 observations. The only exception to this is where the observed salinities are definitely known not to be recorded on the Practical Salinity Scale. Practical salinity units are dimensionless. The unit "parts per thousand" was used for sea_water_knudsen_salinity and sea_water_cox_salinity. Sea water density is the in-situ density (not the potential density). For Boussinesq models, density is the constant Boussinesq reference density, a quantity which has the standard name reference_sea_water_density_for_boussinesq_approximation.',
),
CFStandardNameDC(
name='integral_wrt_depth_of_sea_water_practical_salinity',
canonical_units='m',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. "wrt" means with respect to. Depth is the vertical distance below the surface. Practical Salinity, S_P, is a determination of the salinity of sea water, based on its electrical conductance. The measured conductance, corrected for temperature and pressure, is compared to the conductance of a standard  potassium chloride solution, producing a value on the Practical Salinity Scale of 1978 (PSS-78). This name should not be used to describe salinity observations made before 1978, or ones not based on conductance measurements. Conversion of Practical Salinity to other precisely defined salinity measures should use the appropriate formulas specified by TEOS-10. Other standard names for precisely defined salinity quantities are sea_water_absolute_salinity (S_A); sea_water_preformed_salinity (S_*), sea_water_reference_salinity (S_R); sea_water_cox_salinity (S_C), used for salinity observations between 1967 and 1977; and sea_water_knudsen_salinity (S_K), used for salinity observations between 1901 and 1966. Salinity quantities that do not match any of the precise definitions should be given the more general standard name of sea_water_salinity. Reference: www.teos-10.org; Lewis, 1980 doi:10.1109/JOE.1980.1145448.',
),
CFStandardNameDC(
name='integral_wrt_depth_of_sea_water_temperature',
canonical_units='K m',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. "wrt" means with respect to. Depth is the vertical distance below the surface. Sea water temperature is the in situ temperature of the sea water. For observed data, depending on the period during which the observation was made, the measured in situ temperature was recorded against standard "scales". These historical scales include the International Practical Temperature Scale of 1948 (IPTS-48; 1948-1967), the International Practical Temperature Scale of 1968 (IPTS-68, Barber, 1969; 1968-1989) and the International Temperature Scale of 1990 (ITS-90, Saunders 1990; 1990 onwards). Conversion of data between these scales follows t68 = t48 - (4.4 x 10e-6) * t48(100 - t - 48); t90 = 0.99976 * t68. Observations made prior to 1948 (IPTS-48) have not been documented and therefore a conversion cannot be certain. Differences between t90 and t68 can be up to 0.01 at temperatures of 40 C and above; differences of 0.002-0.007 occur across the standard range of ocean temperatures (-10 - 30 C). The International Equation of State of Seawater 1980 (EOS-80, UNESCO, 1981) and the Practical Salinity Scale (PSS-78) were both based on IPTS-68, while the Thermodynamic Equation of Seawater 2010 (TEOS-10) is based on ITS-90. References: Barber, 1969, doi: 10.1088/0026-1394/5/2/001; UNESCO, 1981; Saunders, 1990, WOCE Newsletter, 10, September 1990.',
),
CFStandardNameDC(
name='integral_wrt_depth_of_tendency_of_sea_water_alkalinity_expressed_as_mole_equivalent',
canonical_units='mol m-2 s-1',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. "wrt" means with respect to. Depth is the vertical distance below the surface."tendency_of_X" means derivative of X with respect to time. \'sea_water_alkalinity_expressed_as_mole_equivalent\' is the total alkalinity equivalent concentration (including carbonate, nitrogen, silicate, and borate components).',
),
CFStandardNameDC(
name='integral_wrt_depth_of_tendency_of_sea_water_alkalinity_expressed_as_mole_equivalent_due_to_biological_processes',
canonical_units='mol m-2 s-1',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. "wrt" means with respect to. "tendency_of_X" means derivative of X with respect to time. Depth is the vertical distance below the surface.   \'sea_water_alkalinity_expressed_as_mole_equivalent\' is the total alkalinity equivalent concentration (including carbonate, nitrogen, silicate, and borate components). The specification of a physical process by the phrase due_to_process means that the quantity named is a  single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='integral_wrt_height_of_product_of_eastward_wind_and_specific_humidity',
canonical_units='m2 s-1',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. The phrase "wrt" means "with respect to". Height is the vertical distance above the surface. The phrase "product_of_X_and_Y" means X*Y. Wind is defined as a two-dimensional (horizontal) air velocity vector, with no vertical component. (Vertical motion in the atmosphere has the standard name "upward_air_velocity".) "Eastward" indicates a vector component which is positive when directed eastward (negative westward). Specific humidity is the mass fraction of water vapor in (moist) air.',
),
CFStandardNameDC(
name='integral_wrt_height_of_product_of_northward_wind_and_specific_humidity',
canonical_units='m2 s-1',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. To specify the limits of the integral the data variable should have an axis for X and associated coordinate bounds. If no axis for X is associated with the data variable, or no coordinate bounds are specified, it is assumed that the integral is calculated over the entire vertical extent of the medium, e.g, if the medium is air the integral is assumed to be calculated over the full depth of the atmosphere. The phrase "wrt" means "with respect to". Height is the vertical distance above the surface. The phrase "product_of_X_and_Y" means X*Y. Wind is defined as a two-dimensional (horizontal) air velocity vector, with no vertical component. (Vertical motion in the atmosphere has the standard name "upward_air_velocity".) "Northward" indicates a vector component which is positive when directed northward (negative southward). Specific humidity is the mass fraction of water vapor in (moist) air.',
),
CFStandardNameDC(
name='integral_wrt_time_of_air_temperature_deficit',
canonical_units='K s',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. "wrt" means with respect to. Air temperature is the bulk temperature of the air, not the surface (skin) temperature. The air temperature deficit is the air temperature threshold minus the air temperature, where only positive values are included in the integral. Its integral with respect to time is often called after its units of "degree-days". The air_temperature variable, which is the data variable of the integral should have a scalar coordinate variable or a size-one coordinate variable with the standard name of air_temperature_threshold, to indicate the threshold.',
),
CFStandardNameDC(
name='integral_wrt_time_of_air_temperature_excess',
canonical_units='K s',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. "wrt" means with respect to. Air temperature is the bulk temperature of the air, not the surface (skin) temperature. The air temperature excess is the air temperature minus the air temperature threshold, where only positive values are included in the integral. Its integral with respect to time is often called after its units of "degree-days". The air_temperature variable, which is the data variable of the integral should have a scalar coordinate variable or a size-one coordinate variable with the standard name of air_temperature_threshold, to indicate the threshold.',
),
CFStandardNameDC(
name='integral_wrt_time_of_mole_stomatal_uptake_of_ozone',
canonical_units='mol m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". The stomatal ozone uptake is the net amount of ozone transferred into the plant during the time period over which the integral is calculated. This parameter is often called the "phytotoxic ozone dose (POD)". The chemical formula for ozone is O3. The IUPAC name for ozone is trioxygen.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_101Mo_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Mo" means the element "molybdenum" and "101Mo" is the isotope "molybdenum-101" with a half-life of 1.01e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_101Tc_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tc" means the element "technetium" and "101Tc" is the isotope "technetium-101" with a half-life of 9.86e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_102Mo_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Mo" means the element "molybdenum" and "102Mo" is the isotope "molybdenum-102" with a half-life of 7.71e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_102mTc_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tc" means the element "technetium" and "102mTc" is the metastable state of the isotope "technetium-102" with a half-life of 2.98e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_102Tc_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tc" means the element "technetium" and "102Tc" is the isotope "technetium-102" with a half-life of 6.12e-05 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_103mRh_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rh" means the element "rhodium" and "103mRh" is the metastable state of the isotope "rhodium-103" with a half-life of 3.89e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_103Ru_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ru" means the element "ruthenium" and "103Ru" is the isotope "ruthenium-103" with a half-life of 3.95e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_104Tc_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tc" means the element "technetium" and "104Tc" is the isotope "technetium-104" with a half-life of 1.25e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_105mRh_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rh" means the element "rhodium" and "105mRh" is the metastable state of the isotope "rhodium-105" with a half-life of 4.41e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_105Rh_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rh" means the element "rhodium" and "105Rh" is the isotope "rhodium-105" with a half-life of 1.48e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_105Ru_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ru" means the element "ruthenium" and "105Ru" is the isotope "ruthenium-105" with a half-life of 1.85e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_106mRh_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rh" means the element "rhodium" and "106mRh" is the metastable state of the isotope "rhodium-106" with a half-life of 9.09e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_106Rh_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rh" means the element "rhodium" and "106Rh" is the isotope "rhodium-106" with a half-life of 3.46e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_106Ru_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ru" means the element "ruthenium" and "106Ru" is the isotope "ruthenium-106" with a half-life of 3.66e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_107mPd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pd" means the element "palladium" and "107mPd" is the metastable state of the isotope "palladium-107" with a half-life of 2.47e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_107Pd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pd" means the element "palladium" and "107Pd" is the isotope "palladium-107" with a half-life of 2.37e+09 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_107Rh_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rh" means the element "rhodium" and "107Rh" is the isotope "rhodium-107" with a half-life of 1.51e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_109mAg_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "109mAg" is the metastable state of the isotope "silver-109" with a half-life of 4.58e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_109Pd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pd" means the element "palladium" and "109Pd" is the isotope "palladium-109" with a half-life of 5.61e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_110mAg_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "110mAg" is the metastable state of the isotope "silver-110" with a half-life of 2.70e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_111Ag_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "111Ag" is the isotope "silver-111" with a half-life of 7.50e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_111mAg_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "111mAg" is the metastable state of the isotope "silver-111" with a half-life of 8.56e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_111mCd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cd" means the element "cadmium" and "111mCd" is the metastable state of the isotope "cadmium-111" with a half-life of 3.39e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_111mPd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pd" means the element "palladium" and "111mPd" is the metastable state of the isotope "palladium-111" with a half-life of 2.29e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_111Pd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pd" means the element "palladium" and "111Pd" is the isotope "palladium-111" with a half-life of 1.53e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_112Ag_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "112Ag" is the isotope "silver-112" with a half-life of 1.30e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_112Pd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pd" means the element "palladium" and "112Pd" is the isotope "palladium-112" with a half-life of 8.37e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_113Ag_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "113Ag" is the isotope "silver-113" with a half-life of 2.21e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_113Cd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cd" means the element "cadmium" and "113Cd" is the isotope "cadmium-113" with a half-life of 3.29e+18 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_113mAg_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "113mAg" is the metastable state of the isotope "silver-113" with a half-life of 7.64e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_113mCd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cd" means the element "cadmium" and "113mCd" is the metastable state of the isotope "cadmium-113" with a half-life of 5.31e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_113mIn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "113mIn" is the metastable state of the isotope "indium-113" with a half-life of 6.92e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_115Ag_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "115Ag" is the isotope "silver-115" with a half-life of 1.46e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_115Cd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cd" means the element "cadmium" and "115Cd" is the isotope "cadmium-115" with a half-life of 2.23e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_115In_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "115In" is the isotope "indium-115" with a half-life of 1.86e+18 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_115mAg_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ag" means the element "silver" and "115mAg" is the metastable state of the isotope "silver-115" with a half-life of 1.97e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_115mCd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cd" means the element "cadmium" and "115mCd" is the metastable state of the isotope "cadmium-115" with a half-life of 4.46e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_115mIn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "115mIn" is the metastable state of the isotope "indium-115" with a half-life of 1.87e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_116In_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "116In" is the isotope "indium-116" with a half-life of 1.64e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_116mIn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "116mIn" is the metastable state of the isotope "indium-116" with a half-life of 3.77e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_117Cd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cd" means the element "cadmium" and "117Cd" is the isotope "cadmium-117" with a half-life of 1.08e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_117In_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "117In" is the isotope "indium-117" with a half-life of 3.05e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_117mCd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cd" means the element "cadmium" and "117mCd" is the metastable state of the isotope "cadmium-117" with a half-life of 1.42e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_117mIn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "117mIn" is the metastable state of the isotope "indium-117" with a half-life of 8.08e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_117mSn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "117mSn" is the metastable state of the isotope "tin-117" with a half-life of 1.40e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_118Cd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cd" means the element "cadmium" and "118Cd" is the isotope "cadmium-118" with a half-life of 3.49e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_118In_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "118In" is the isotope "indium-118" with a half-life of 5.77e-05 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_118mIn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "118mIn" is the metastable state of the isotope "indium-118" with a half-life of 3.05e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_119In_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "119In" is the isotope "indium-119" with a half-life of 1.74e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_119mIn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "In" means the element "indium" and "119mIn" is the metastable state of the isotope "indium-119" with a half-life of 1.25e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_119mSn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "119mSn" is the metastable state of the isotope "tin-119" with a half-life of 2.45e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_11C_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "C" means the element "carbon" and "11C" is the isotope "carbon-11" with a half-life of 1.41e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_121mSn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "121mSn" is the metastable state of the isotope "tin-121" with a half-life of 1.82e+04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_121Sn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "121Sn" is the isotope "tin-121" with a half-life of 1.12e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_123mSn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "123mSn" is the metastable state of the isotope "tin-123" with a half-life of 2.78e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_123Sn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "123Sn" is the isotope "tin-123" with a half-life of 1.29e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_124mSb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "124mSb" is the metastable state of the isotope "antimony-124" with a half-life of 1.41e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_124Sb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "124Sb" is the isotope "antimony-124" with a half-life of 6.03e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_125mTe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "125mTe" is the metastable state of the isotope "tellurium-125" with a half-life of 5.81e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_125Sb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "125Sb" is the isotope "antimony-125" with a half-life of 9.97e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_125Sn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "125Sn" is the isotope "tin-125" with a half-life of 9.65e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_126mSb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "126mSb" is the metastable state of the isotope "antimony-126" with a half-life of 1.32e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_126Sb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "126Sb" is the isotope "antimony-126" with a half-life of 1.24e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_126Sn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "126Sn" is the isotope "tin-126" with a half-life of 3.65e+07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_127mTe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "127mTe" is the metastable state of the isotope "tellurium-127" with a half-life of 1.09e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_127Sb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "127Sb" is the isotope "antimony-127" with a half-life of 3.80e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_127Sn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "127Sn" is the isotope "tin-127" with a half-life of 8.84e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_127Te_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "127Te" is the isotope "tellurium-127" with a half-life of 3.91e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_128mSb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "128mSb" is the metastable state of the isotope "antimony-128" with a half-life of 7.23e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_128Sb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "128Sb" is the isotope "antimony-128" with a half-life of 3.75e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_128Sn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "128Sn" is the isotope "tin-128" with a half-life of 4.09e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_129I_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "129I" is the isotope "iodine-129" with a half-life of 5.81e+09 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_129mTe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "129mTe" is the metastable state of the isotope "tellurium-129" with a half-life of 3.34e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_129mXe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "129mXe" is the metastable state of the isotope "xenon-129" with a half-life of 8.02e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_129Sb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "129Sb" is the isotope "antimony-129" with a half-life of 1.81e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_129Te_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "129Te" is the isotope "tellurium-129" with a half-life of 4.86e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_130I_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "130I" is the isotope "iodine-130" with a half-life of 5.18e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_130mI_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "130mI" is the metastable state of the isotope "iodine-130" with a half-life of 6.17e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_130mSb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "130mSb" is the metastable state of the isotope "antimony-130" with a half-life of 4.58e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_130Sb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "130Sb" is the isotope "antimony-130" with a half-life of 2.57e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_130Sn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sn" means the element "tin" and "130Sn" is the isotope "tin-130" with a half-life of 2.57e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_131I_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "131I" is the isotope "iodine-131" with a half-life of 8.07e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_131mTe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "131mTe" is the metastable state of the isotope "tellurium-131" with a half-life of 1.25e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_131mXe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "131mXe" is the metastable state of the isotope "xenon-131" with a half-life of 1.18e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_131Sb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sb" means the element "antimony" and "131Sb" is the isotope "antimony-131" with a half-life of 1.60e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_131Te_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "131Te" is the isotope "tellurium-131" with a half-life of 1.74e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_132I_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "132I" is the isotope "iodine-132" with a half-life of 9.60e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_132Te_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "132Te" is the isotope "tellurium-132" with a half-life of 3.25e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_133I_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "133I" is the isotope "iodine-133" with a half-life of 8.71e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_133mI_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "133mI" is the metastable state of the isotope "iodine-133" with a half-life of 1.04e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_133mTe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "133mTe" is the metastable state of the isotope "tellurium-133" with a half-life of 3.84e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_133mXe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "133mXe" is the metastable state of the isotope "xenon-133" with a half-life of 2.26e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_133Te_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "133Te" is the isotope "tellurium-133" with a half-life of 8.68e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_133Xe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "133Xe" is the isotope "xenon-133" with a half-life of 5.28e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_134Cs_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cs" means the element "cesium" and "134Cs" is the isotope "cesium-134" with a half-life of 7.50e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_134I_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "134I" is the isotope "iodine-134" with a half-life of 3.61e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_134mCs_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cs" means the element "cesium" and "134mCs" is the metastable state of the isotope "cesium-134" with a half-life of 1.21e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_134mI_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "134mI" is the metastable state of the isotope "iodine-134" with a half-life of 2.50e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_134mXe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "134mXe" is the metastable state of the isotope "xenon-134" with a half-life of 3.36e-06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_134Te_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Te" means the element "tellurium" and "134Te" is the isotope "tellurium-134" with a half-life of 2.92e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_135Cs_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cs" means the element "cesium" and "135Cs" is the isotope "cesium-135" with a half-life of 8.39e+08 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_135I_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "I" means the element "iodine" and "135I" is the isotope "iodine-135" with a half-life of 2.79e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_135mBa_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ba" means the element "barium" and "135mBa" is the metastable state of the isotope "barium-135" with a half-life of 1.20e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_135mCs_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cs" means the element "cesium" and "135mCs" is the metastable state of the isotope "cesium-135" with a half-life of 3.68e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_135mXe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "135mXe" is the metastable state of the isotope "xenon-135" with a half-life of 1.08e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_135Xe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "135Xe" is the isotope "xenon-135" with a half-life of 3.82e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_136Cs_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cs" means the element "cesium" and "136Cs" is the isotope "cesium-136" with a half-life of 1.30e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_137Cs_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cs" means the element "cesium" and "137Cs" is the isotope "cesium-137" with a half-life of 1.10e+04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_137mBa_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ba" means the element "barium" and "137mBa" is the metastable state of the isotope "barium-137" with a half-life of 1.77e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_137Xe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "137Xe" is the isotope "xenon-137" with a half-life of 2.71e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_138Cs_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cs" means the element "cesium" and "138Cs" is the isotope "cesium-138" with a half-life of 2.23e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_138Xe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Xe" means the element "xenon" and "138Xe" is the isotope "xenon-138" with a half-life of 9.84e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_139Ba_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ba" means the element "barium" and "139Ba" is the isotope "barium-139" with a half-life of 5.77e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_13N_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "N" means the element "nitrogen" and "13N" is the isotope "nitrogen-13" with a half-life of 6.92e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_140Ba_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ba" means the element "barium" and "140Ba" is the isotope "barium-140" with a half-life of 1.28e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_140La_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "La" means the element "lanthanum" and "140La" is the isotope "lanthanum-140" with a half-life of 1.76e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_141Ce_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ce" means the element "cerium" and "141Ce" is the isotope "cerium-141" with a half-life of 3.30e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_141La_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "La" means the element "lanthanum" and "141La" is the isotope "lanthanum-141" with a half-life of 1.61e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_142Ce_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ce" means the element "cerium" and "142Ce" is the isotope "cerium-142" with a half-life of 1.82e+19 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_142La_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "La" means the element "lanthanum" and "142La" is the isotope "lanthanum-142" with a half-life of 6.42e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_142mPr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pr" means the element "praseodymium" and "142mPr" is the metastable state of the isotope "praseodymium-142" with a half-life of 1.01e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_142Pr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pr" means the element "praseodymium" and "142Pr" is the isotope "praseodymium-142" with a half-life of 7.94e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_143Ce_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ce" means the element "cerium" and "143Ce" is the isotope "cerium-143" with a half-life of 1.37e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_143La_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "La" means the element "lanthanum" and "143La" is the isotope "lanthanum-143" with a half-life of 9.72e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_143Pr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pr" means the element "praseodymium" and "143Pr" is the isotope "praseodymium-143" with a half-life of 1.36e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_144Ce_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ce" means the element "cerium" and "144Ce" is the isotope "cerium-144" with a half-life of 2.84e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_144mPr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pr" means the element "praseodymium" and "144mPr" is the metastable state of the isotope "praseodymium-144" with a half-life of 4.98e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_144Nd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nd" means the element "neodymium" and "144Nd" is the isotope "neodymium-144" with a half-life of 7.64e+17 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_144Pr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pr" means the element "praseodymium" and "144Pr" is the isotope "praseodymium-144" with a half-life of 1.20e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_145Pr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pr" means the element "praseodymium" and "145Pr" is the isotope "praseodymium-145" with a half-life of 2.49e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_146Ce_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ce" means the element "cerium" and "146Ce" is the isotope "cerium-146" with a half-life of 9.86e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_146Pr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pr" means the element "praseodymium" and "146Pr" is the isotope "praseodymium-146" with a half-life of 1.68e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_147Nd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nd" means the element "neodymium" and "147Nd" is the isotope "neodymium-147" with a half-life of 1.10e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_147Pm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pm" means the element "promethium" and "147Pm" is the isotope "promethium-147" with a half-life of 9.57e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_147Pr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pr" means the element "praseodymium" and "147Pr" is the isotope "praseodymium-147" with a half-life of 8.33e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_147Sm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sm" means the element "samarium" and "147Sm" is the isotope "samarium-147" with a half-life of 3.91e+13 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_148mPm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pm" means the element "promethium" and "148mPm" is the metastable state of the isotope "promethium-148" with a half-life of 4.14e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_148Pm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pm" means the element "promethium" and "148Pm" is the isotope "promethium-148" with a half-life of 5.38e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_148Sm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sm" means the element "samarium" and "148Sm" is the isotope "samarium-148" with a half-life of 2.92e+18 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_149Nd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nd" means the element "neodymium" and "149Nd" is the isotope "neodymium-149" with a half-life of 7.23e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_149Pm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pm" means the element "promethium" and "149Pm" is the isotope "promethium-149" with a half-life of 2.21e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_149Sm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sm" means the element "samarium" and "149Sm" is the isotope "samarium-149" with a half-life of 3.65e+18 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_150Pm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pm" means the element "promethium" and "150Pm" is the isotope "promethium-150" with a half-life of 1.12e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_151Nd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nd" means the element "neodymium" and "151Nd" is the isotope "neodymium-151" with a half-life of 8.61e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_151Pm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pm" means the element "promethium" and "151Pm" is the isotope "promethium-151" with a half-life of 1.18e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_151Sm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sm" means the element "samarium" and "151Sm" is the isotope "samarium-151" with a half-life of 3.40e+04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_152mPm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pm" means the element "promethium" and "152mPm" is the metastable state of the isotope "promethium-152" with a half-life of 1.25e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_152Nd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nd" means the element "neodymium" and "152Nd" is the isotope "neodymium-152" with a half-life of 7.94e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_152Pm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pm" means the element "promethium" and "152Pm" is the isotope "promethium-152" with a half-life of 2.84e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_153Sm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sm" means the element "samarium" and "153Sm" is the isotope "samarium-153" with a half-life of 1.94e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_154Eu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Eu" means the element "europium" and "154Eu" is the isotope "europium-154" with a half-life of 3.13e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_155Eu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Eu" means the element "europium" and "155Eu" is the isotope "europium-155" with a half-life of 1.75e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_155Sm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sm" means the element "samarium" and "155Sm" is the isotope "samarium-155" with a half-life of 1.54e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_156Eu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Eu" means the element "europium" and "156Eu" is the isotope "europium-156" with a half-life of 1.52e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_156Sm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sm" means the element "samarium" and "156Sm" is the isotope "samarium-156" with a half-life of 3.91e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_157Eu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Eu" means the element "europium" and "157Eu" is the isotope "europium-157" with a half-life of 6.32e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_158Eu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Eu" means the element "europium" and "158Eu" is the isotope "europium-158" with a half-life of 3.18e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_159Eu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Eu" means the element "europium" and "159Eu" is the isotope "europium-159" with a half-life of 1.26e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_159Gd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Gd" means the element "gadolinium" and "159Gd" is the isotope "gadolinium-159" with a half-life of 7.71e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_15O_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "O" means the element "oxygen" and "15O" is the isotope "oxygen-15" with a half-life of 1.41e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_160Tb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tb" means the element "terbium" and "160Tb" is the isotope "terbium-160" with a half-life of 7.23e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_161Tb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tb" means the element "terbium" and "161Tb" is the isotope "terbium-161" with a half-life of 6.92e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_162Gd_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Gd" means the element "gadolinium" and "162Gd" is the isotope "gadolinium-162" with a half-life of 6.92e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_162mTb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tb" means the element "terbium" and "162mTb" is the metastable state of the isotope "terbium-162" with a half-life of 9.30e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_162Tb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tb" means the element "terbium" and "162Tb" is the isotope "terbium-162" with a half-life of 5.18e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_163Tb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tb" means the element "terbium" and "163Tb" is the isotope "terbium-163" with a half-life of 1.36e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_165Dy_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Dy" means the element "dysprosium" and "165Dy" is the isotope "dysprosium-165" with a half-life of 9.80e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_18F_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "F" means the element "fluorine" and "18F" is the isotope "fluorine-18" with a half-life of 6.98e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_206Hg_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Hg" means the element "mercury" and "206Hg" is the isotope "mercury-206" with a half-life of 5.57e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_206Tl_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tl" means the element "thallium" and "206Tl" is the isotope "thallium-206" with a half-life of 2.91e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_207mPb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pb" means the element "lead" and "207mPb" is the metastable state of the isotope "lead-207" with a half-life of 9.26e-06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_207Tl_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tl" means the element "thallium" and "207Tl" is the isotope "thallium-207" with a half-life of 3.33e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_208Tl_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tl" means the element "thallium" and "208Tl" is the isotope "thallium-208" with a half-life of 2.15e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_209Bi_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bi" means the element "bismuth" and "209Bi" is the isotope "bismuth-209" with a half-life of 7.29e+20 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_209Pb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pb" means the element "lead" and "209Pb" is the isotope "lead-209" with a half-life of 1.38e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_209Tl_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tl" means the element "thallium" and "209Tl" is the isotope "thallium-209" with a half-life of 1.53e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_210Bi_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bi" means the element "bismuth" and "210Bi" is the isotope "bismuth-210" with a half-life of 5.01e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_210Pb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pb" means the element "lead" and "210Pb" is the isotope "lead-210" with a half-life of 7.64e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_210Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "210Po" is the isotope "polonium-210" with a half-life of 1.38e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_210Tl_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tl" means the element "thallium" and "210Tl" is the isotope "thallium-210" with a half-life of 9.02e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_211Bi_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bi" means the element "bismuth" and "211Bi" is the isotope "bismuth-211" with a half-life of 1.49e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_211Pb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pb" means the element "lead" and "211Pb" is the isotope "lead-211" with a half-life of 2.51e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_211Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "211Po" is the isotope "polonium-211" with a half-life of 6.03e-06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_212Bi_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bi" means the element "bismuth" and "212Bi" is the isotope "bismuth-212" with a half-life of 4.20e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_212Pb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pb" means the element "lead" and "212Pb" is the isotope "lead-212" with a half-life of 4.43e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_212Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "212Po" is the isotope "polonium-212" with a half-life of 3.52e-12 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_213Bi_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bi" means the element "bismuth" and "213Bi" is the isotope "bismuth-213" with a half-life of 3.26e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_213Pb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pb" means the element "lead" and "213Pb" is the isotope "lead-213" with a half-life of 6.92e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_213Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "213Po" is the isotope "polonium-213" with a half-life of 4.86e-11 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_214Bi_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bi" means the element "bismuth" and "214Bi" is the isotope "bismuth-214" with a half-life of 1.37e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_214Pb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pb" means the element "lead" and "214Pb" is the isotope "lead-214" with a half-life of 1.86e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_214Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "214Po" is the isotope "polonium-214" with a half-life of 1.90e-09 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_215At_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "At" means the element "astatine" and "215At" is the isotope "astatine-215" with a half-life of 1.16e-09 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_215Bi_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bi" means the element "bismuth" and "215Bi" is the isotope "bismuth-215" with a half-life of 4.86e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_215Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "215Po" is the isotope "polonium-215" with a half-life of 2.06e-08 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_216At_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "At" means the element "astatine" and "216At" is the isotope "astatine-216" with a half-life of 3.47e-09 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_216Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "216Po" is the isotope "polonium-216" with a half-life of 1.74e-06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_217At_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "At" means the element "astatine" and "217At" is the isotope "astatine-217" with a half-life of 3.70e-07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_217Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "217Po" is the isotope "polonium-217" with a half-life of 1.16e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_218At_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "At" means the element "astatine" and "218At" is the isotope "astatine-218" with a half-life of 2.31e-05 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_218Po_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Po" means the element "polonium" and "218Po" is the isotope "polonium-218" with a half-life of 2.12e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_218Rn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rn" means the element "radon" and "218Rn" is the isotope "radon-218" with a half-life of 4.05e-07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_219At_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "At" means the element "astatine" and "219At" is the isotope "astatine-219" with a half-life of 6.27e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_219Rn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rn" means the element "radon" and "219Rn" is the isotope "radon-219" with a half-life of 4.64e-05 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_220Rn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rn" means the element "radon" and "220Rn" is the isotope "radon-220" with a half-life of 6.37e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_221Fr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Fr" means the element "francium" and "221Fr" is the isotope "francium-221" with a half-life of 3.33e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_221Rn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rn" means the element "radon" and "221Rn" is the isotope "radon-221" with a half-life of 1.74e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_222Fr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Fr" means the element "francium" and "222Fr" is the isotope "francium-222" with a half-life of 1.03e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_222Ra_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ra" means the element "radium" and "222Ra" is the isotope "radium-222" with a half-life of 4.41e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_222Rn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rn" means the element "radon" and "222Rn" is the isotope "radon-222" with a half-life of 3.82e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_223Fr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Fr" means the element "francium" and "223Fr" is the isotope "francium-223" with a half-life of 1.53e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_223Ra_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ra" means the element "radium" and "223Ra" is the isotope "radium-223" with a half-life of 1.14e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_223Rn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rn" means the element "radon" and "223Rn" is the isotope "radon-223" with a half-life of 2.98e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_224Ra_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ra" means the element "radium" and "224Ra" is the isotope "radium-224" with a half-life of 3.65e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_225Ac_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ac" means the element "actinium" and "225Ac" is the isotope "actinium-225" with a half-life of 1.00e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_225Ra_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ra" means the element "radium" and "225Ra" is the isotope "radium-225" with a half-life of 1.48e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_226Ac_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ac" means the element "actinium" and "226Ac" is the isotope "actinium-226" with a half-life of 1.21e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_226Ra_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ra" means the element "radium" and "226Ra" is the isotope "radium-226" with a half-life of 5.86e+05 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_226Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "226Th" is the isotope "thorium-226" with a half-life of 2.15e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_227Ac_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ac" means the element "actinium" and "227Ac" is the isotope "actinium-227" with a half-life of 7.87e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_227Ra_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ra" means the element "radium" and "227Ra" is the isotope "radium-227" with a half-life of 2.87e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_227Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "227Th" is the isotope "thorium-227" with a half-life of 1.82e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_228Ac_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ac" means the element "actinium" and "228Ac" is the isotope "actinium-228" with a half-life of 2.55e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_228Ra_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ra" means the element "radium" and "228Ra" is the isotope "radium-228" with a half-life of 2.45e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_228Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "228Th" is the isotope "thorium-228" with a half-life of 6.98e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_229Ac_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ac" means the element "actinium" and "229Ac" is the isotope "actinium-229" with a half-life of 4.58e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_229Ra_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ra" means the element "radium" and "229Ra" is the isotope "radium-229" with a half-life of 1.16e-17 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_229Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "229Th" is the isotope "thorium-229" with a half-life of 2.68e+06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_230Pa_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pa" means the element "protactinium" and "230Pa" is the isotope "protactinium-230" with a half-life of 1.77e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_230Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "230Th" is the isotope "thorium-230" with a half-life of 2.92e+07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_230U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "230U" is the isotope "uranium-230" with a half-life of 2.08e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_231Pa_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pa" means the element "protactinium" and "231Pa" is the isotope "protactinium-231" with a half-life of 1.19e+07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_231Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "231Th" is the isotope "thorium-231" with a half-life of 1.06e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_231U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "231U" is the isotope "uranium-231" with a half-life of 4.29e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_232Pa_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pa" means the element "protactinium" and "232Pa" is the isotope "protactinium-232" with a half-life of 1.31e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_232Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "232Th" is the isotope "thorium-232" with a half-life of 5.14e+12 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_232U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "232U" is the isotope "uranium-232" with a half-life of 2.63e+04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_233Pa_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pa" means the element "protactinium" and "233Pa" is the isotope "protactinium-233" with a half-life of 2.70e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_233Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "233Th" is the isotope "thorium-233" with a half-life of 1.54e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_233U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "233U" is the isotope "uranium-233" with a half-life of 5.90e+07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_234mPa_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pa" means the element "protactinium" and "234mPa" is the metastable state of the isotope "protactinium-234" with a half-life of 8.13e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_234Pa_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pa" means the element "protactinium" and "234Pa" is the isotope "protactinium-234" with a half-life of 2.81e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_234Th_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Th" means the element "thorium" and "234Th" is the isotope "thorium-234" with a half-life of 2.41e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_234U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "234U" is the isotope "uranium-234" with a half-life of 9.02e+07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_235Np_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Np" means the element "neptunium" and "235Np" is the isotope "neptunium-235" with a half-life of 4.09e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_235Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "235Pu" is the isotope "plutonium-235" with a half-life of 1.81e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_235U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "235U" is the isotope "uranium-235" with a half-life of 2.60e+11 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_236mNp_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Np" means the element "neptunium" and "236mNp" is the metastable state of the isotope "neptunium-236" with a half-life of 4.72e+10 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_236Np_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Np" means the element "neptunium" and "236Np" is the isotope "neptunium-236" with a half-life of 9.17e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_236Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "236Pu" is the isotope "plutonium-236" with a half-life of 1.04e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_236U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "236U" is the isotope "uranium-236" with a half-life of 8.73e+09 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_237Np_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Np" means the element "neptunium" and "237Np" is the isotope "neptunium-237" with a half-life of 7.79e+08 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_237Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "237Pu" is the isotope "plutonium-237" with a half-life of 4.56e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_237U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "237U" is the isotope "uranium-237" with a half-life of 6.74e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_238Np_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Np" means the element "neptunium" and "238Np" is the isotope "neptunium-238" with a half-life of 2.10e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_238Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "238Pu" is the isotope "plutonium-238" with a half-life of 3.15e+04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_238U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "238U" is the isotope "uranium-238" with a half-life of 1.65e+12 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_239Np_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Np" means the element "neptunium" and "239Np" is the isotope "neptunium-239" with a half-life of 2.35e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_239Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "239Pu" is the isotope "plutonium-239" with a half-life of 8.91e+06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_239U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "239U" is the isotope "uranium-239" with a half-life of 1.63e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_240Am_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "240Am" is the isotope "americium-240" with a half-life of 2.12e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_240mNp_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Np" means the element "neptunium" and "240mNp" is the metastable state of the isotope "neptunium-240" with a half-life of 5.08e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_240Np_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Np" means the element "neptunium" and "240Np" is the isotope "neptunium-240" with a half-life of 4.38e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_240Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "240Pu" is the isotope "plutonium-240" with a half-life of 2.40e+06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_240U_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "U" means the element "uranium" and "240U" is the isotope "uranium-240" with a half-life of 5.99e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_241Am_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "241Am" is the isotope "americium-241" with a half-life of 1.67e+05 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_241Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "241Cm" is the isotope "curium-241" with a half-life of 3.50e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_241Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "241Pu" is the isotope "plutonium-241" with a half-life of 4.83e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_242Am_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "242Am" is the isotope "americium-242" with a half-life of 6.69e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_242Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "242Cm" is the isotope "curium-242" with a half-life of 1.63e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_242m1Am_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "242m1Am" is the metastable state of the isotope "americium-242" with a half-life of 5.53e+04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_242m2Am_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "242m2Am" is the metastable state of the isotope "americium-242" with a half-life of 1.62e-07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_242Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "242Pu" is the isotope "plutonium-242" with a half-life of 1.38e+08 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_243Am_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "243Am" is the isotope "americium-243" with a half-life of 2.91e+06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_243Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "243Cm" is the isotope "curium-243" with a half-life of 1.17e+04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_243Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "243Pu" is the isotope "plutonium-243" with a half-life of 2.07e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_244Am_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "244Am" is the isotope "americium-244" with a half-life of 4.20e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_244Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "244Cm" is the isotope "curium-244" with a half-life of 6.42e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_244mAm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "244mAm" is the metastable state of the isotope "americium-244" with a half-life of 1.81e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_244Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "244Pu" is the isotope "plutonium-244" with a half-life of 2.92e+10 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_245Am_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Am" means the element "americium" and "245Am" is the isotope "americium-245" with a half-life of 8.75e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_245Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "245Cm" is the isotope "curium-245" with a half-life of 3.40e+06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_245Pu_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Pu" means the element "plutonium" and "245Pu" is the isotope "plutonium-245" with a half-life of 4.16e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_246Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "246Cm" is the isotope "curium-246" with a half-life of 2.01e+06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_247Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "247Cm" is the isotope "curium-247" with a half-life of 5.86e+09 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_248Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "248Cm" is the isotope "curium-248" with a half-life of 1.72e+08 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_249Bk_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bk" means the element "berkelium" and "249Bk" is the isotope "berkelium-249" with a half-life of 3.15e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_249Cf_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cf" means the element "californium" and "249Cf" is the isotope "californium-249" with a half-life of 1.32e+05 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_249Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "249Cm" is the isotope "curium-249" with a half-life of 4.43e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_24Na_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Na" means the element "sodium" and "24Na" is the isotope "sodium-24" with a half-life of 6.27e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_250Bk_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Bk" means the element "berkelium" and "250Bk" is the isotope "berkelium-250" with a half-life of 1.34e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_250Cf_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cf" means the element "californium" and "250Cf" is the isotope "californium-250" with a half-life of 4.75e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_250Cm_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cm" means the element "curium" and "250Cm" is the isotope "curium-250" with a half-life of 2.52e+06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_251Cf_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cf" means the element "californium" and "251Cf" is the isotope "californium-251" with a half-life of 2.92e+05 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_252Cf_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cf" means the element "californium" and "252Cf" is the isotope "californium-252" with a half-life of 9.68e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_253Cf_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cf" means the element "californium" and "253Cf" is the isotope "californium-253" with a half-life of 1.76e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_253Es_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Es" means the element "einsteinium" and "253Es" is the isotope "einsteinium-253" with a half-life of 2.05e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_254Cf_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Cf" means the element "californium" and "254Cf" is the isotope "californium-254" with a half-life of 6.03e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_254Es_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Es" means the element "einsteinium" and "254Es" is the isotope "einsteinium-254" with a half-life of 2.76e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_254mEs_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Es" means the element "einsteinium" and "254mEs" is the metastable state of the isotope "einsteinium-254" with a half-life of 1.63e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_255Es_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Es" means the element "einsteinium" and "255Es" is the isotope "einsteinium-255" with a half-life of 3.84e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_3H_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "H" means the element "hydrogen" and "3H" is the isotope "hydrogen-3" with a half-life of 4.51e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_41Ar_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ar" means the element "argon" and "41Ar" is the isotope "argon-41" with a half-life of 7.64e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_54Mn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Mn" means the element "manganese" and "54Mn" is the isotope "manganese-54" with a half-life of 3.12e+02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_58Co_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Co" means the element "cobalt" and "58Co" is the isotope "cobalt-58" with a half-life of 7.10e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_60Co_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Co" means the element "cobalt" and "60Co" is the isotope "cobalt-60" with a half-life of 1.93e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_72Ga_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ga" means the element "gallium" and "72Ga" is the isotope "gallium-72" with a half-life of 5.86e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_72Zn_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Zn" means the element "zinc" and "72Zn" is the isotope "zinc-72" with a half-life of 1.94e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_73Ga_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ga" means the element "gallium" and "73Ga" is the isotope "gallium-73" with a half-life of 2.03e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_75Ge_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ge" means the element "germanium" and "75Ge" is the isotope "germanium-75" with a half-life of 5.73e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_77As_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "As" means the element "arsenic" and "77As" is the isotope "arsenic-77" with a half-life of 1.62e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_77Ge_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ge" means the element "germanium" and "77Ge" is the isotope "germanium-77" with a half-life of 4.72e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_77mGe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ge" means the element "germanium" and "77mGe" is the metastable state of the isotope "germanium-77" with a half-life of 6.27e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_78As_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "As" means the element "arsenic" and "78As" is the isotope "arsenic-78" with a half-life of 6.32e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_78Ge_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Ge" means the element "germanium" and "78Ge" is the isotope "germanium-78" with a half-life of 6.03e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_79Se_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Se" means the element "selenium" and "79Se" is the isotope "selenium-79" with a half-life of 2.37e+07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_81mSe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Se" means the element "selenium" and "81mSe" is the metastable state of the isotope "selenium-81" with a half-life of 3.97e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_81Se_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Se" means the element "selenium" and "81Se" is the isotope "selenium-81" with a half-life of 1.28e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_82Br_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Br" means the element "bromine" and "82Br" is the isotope "bromine-82" with a half-life of 1.47e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_82mBr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Br" means the element "bromine" and "82mBr" is the metastable state of the isotope "bromine-82" with a half-life of 4.24e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_83Br_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Br" means the element "bromine" and "83Br" is the isotope "bromine-83" with a half-life of 1.00e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_83mKr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Kr" means the element "krypton" and "83mKr" is the metastable state of the isotope "krypton-83" with a half-life of 7.71e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_83mSe_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Se" means the element "selenium" and "83mSe" is the metastable state of the isotope "selenium-83" with a half-life of 8.10e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_83Se_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Se" means the element "selenium" and "83Se" is the isotope "selenium-83" with a half-life of 1.56e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_84Br_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Br" means the element "bromine" and "84Br" is the isotope "bromine-84" with a half-life of 2.21e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_84mBr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Br" means the element "bromine" and "84mBr" is the metastable state of the isotope "bromine-84" with a half-life of 4.16e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_85Kr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Kr" means the element "krypton" and "85Kr" is the isotope "krypton-85" with a half-life of 3.95e+03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_85mKr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Kr" means the element "krypton" and "85mKr" is the metastable state of the isotope "krypton-85" with a half-life of 1.83e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_86mRb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rb" means the element "rubidium" and "86mRb" is the metastable state of the isotope "rubidium-86" with a half-life of 7.04e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_86Rb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rb" means the element "rubidium" and "86Rb" is the isotope "rubidium-86" with a half-life of 1.87e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_87Kr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Kr" means the element "krypton" and "87Kr" is the isotope "krypton-87" with a half-life of 5.28e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_87Rb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rb" means the element "rubidium" and "87Rb" is the isotope "rubidium-87" with a half-life of 1.71e+13 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_88Kr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Kr" means the element "krypton" and "88Kr" is the isotope "krypton-88" with a half-life of 1.17e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_88Rb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rb" means the element "rubidium" and "88Rb" is the isotope "rubidium-88" with a half-life of 1.25e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_89Kr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Kr" means the element "krypton" and "89Kr" is the isotope "krypton-89" with a half-life of 2.20e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_89Rb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Rb" means the element "rubidium" and "89Rb" is the isotope "rubidium-89" with a half-life of 1.06e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_89Sr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sr" means the element "strontium" and "89Sr" is the isotope "strontium-89" with a half-life of 5.21e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_90mY_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Y" means the element "yttrium" and "90mY" is the metastable state of the isotope "yttrium-90" with a half-life of 1.33e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_90Sr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sr" means the element "strontium" and "90Sr" is the isotope "strontium-90" with a half-life of 1.02e+04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_90Y_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Y" means the element "yttrium" and "90Y" is the isotope "yttrium-90" with a half-life of 2.67e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_91mY_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Y" means the element "yttrium" and "91mY" is the metastable state of the isotope "yttrium-91" with a half-life of 3.46e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_91Sr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sr" means the element "strontium" and "91Sr" is the isotope "strontium-91" with a half-life of 3.95e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_91Y_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Y" means the element "yttrium" and "91Y" is the isotope "yttrium-91" with a half-life of 5.86e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_92Sr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Sr" means the element "strontium" and "92Sr" is the isotope "strontium-92" with a half-life of 1.13e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_92Y_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Y" means the element "yttrium" and "92Y" is the isotope "yttrium-92" with a half-life of 1.47e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_93Y_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Y" means the element "yttrium" and "93Y" is the isotope "yttrium-93" with a half-life of 4.24e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_93Zr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Zr" means the element "zirconium" and "93Zr" is the isotope "zirconium-93" with a half-life of 3.47e+08 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_94mNb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nb" means the element "niobium" and "94mNb" is the metastable state of the isotope "niobium-94" with a half-life of 4.34e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_94Nb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nb" means the element "niobium" and "94Nb" is the isotope "niobium-94" with a half-life of 7.29e+06 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_94Y_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Y" means the element "yttrium" and "94Y" is the isotope "yttrium-94" with a half-life of 1.32e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_95mNb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nb" means the element "niobium" and "95mNb" is the metastable state of the isotope "niobium-95" with a half-life of 3.61e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_95Nb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nb" means the element "niobium" and "95Nb" is the isotope "niobium-95" with a half-life of 3.52e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_95Y_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Y" means the element "yttrium" and "95Y" is the isotope "yttrium-95" with a half-life of 7.29e-03 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_95Zr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Zr" means the element "zirconium" and "95Zr" is the isotope "zirconium-95" with a half-life of 6.52e+01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_96Nb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nb" means the element "niobium" and "96Nb" is the isotope "niobium-96" with a half-life of 9.75e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_97mNb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nb" means the element "niobium" and "97mNb" is the metastable state of the isotope "niobium-97" with a half-life of 6.27e-04 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_97Nb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nb" means the element "niobium" and "97Nb" is the isotope "niobium-97" with a half-life of 5.11e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_97Zr_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Zr" means the element "zirconium" and "97Zr" is the isotope "zirconium-97" with a half-life of 6.98e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_98Nb_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Nb" means the element "niobium" and "98Nb" is the isotope "niobium-98" with a half-life of 3.53e-02 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_99Mo_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Mo" means the element "molybdenum" and "99Mo" is the isotope "molybdenum-99" with a half-life of 2.78e+00 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_99mTc_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tc" means the element "technetium" and "99mTc" is the metastable state of the isotope "technetium-99" with a half-life of 2.51e-01 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_radioactivity_concentration_of_99Tc_in_air',
canonical_units='Bq s m-3',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means "with respect to". "Radioactivity" means the number of radioactive decays of a material per second. "Radioactivity concentration" means radioactivity per unit volume of the medium. "Tc" means the element "technetium" and "99Tc" is the isotope "technetium-99" with a half-life of 7.79e+07 days.',
),
CFStandardNameDC(
name='integral_wrt_time_of_surface_downward_eastward_stress',
canonical_units='Pa s',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The abbreviation "wrt" means "with respect to". The surface called "surface" means the lower boundary of the atmosphere. "Surface stress" means the shear stress (force per unit area) exerted by the wind at the surface. A downward stress is a downward flux of momentum. Over large bodies of water, wind stress can drive near-surface currents. "Downward" indicates a vector component which is positive when directed downward (negative upward). "Eastward" indicates a vector component which is positive when directed eastward (negative westward). "Downward eastward" indicates the ZX component of a tensor. A downward eastward stress is a downward flux of eastward momentum, which accelerates the lower medium eastward and the upper medium westward.',
),
CFStandardNameDC(
name='integral_wrt_time_of_surface_downward_latent_heat_flux',
canonical_units='W s m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. "wrt" means with respect to. The surface called "surface" means the lower boundary of the atmosphere. "Downward" indicates a vector component which is positive when directed downward (negative upward). The surface latent heat flux is the exchange of heat between the surface and the air on account of evaporation (including sublimation). In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='integral_wrt_time_of_surface_downward_northward_stress',
canonical_units='Pa s',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The abbreviation "wrt" means "with respect to". The surface called "surface" means the lower boundary of the atmosphere. "Surface stress" means the shear stress (force per unit area) exerted by the wind at the surface. A downward stress is a downward flux of momentum. Over large bodies of water, wind stress can drive near-surface currents. "Downward" indicates a vector component which is positive when directed downward (negative upward). "Northward" indicates a vector component which is positive when directed northward (negative southward). "Downward northward" indicates the ZY component of a tensor. A downward northward stress is a downward flux of northward momentum, which accelerates the lower medium northward and the upper medium southward.',
),
CFStandardNameDC(
name='integral_wrt_time_of_surface_downward_sensible_heat_flux',
canonical_units='W s m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. "wrt" means with respect to. The surface called "surface" means the lower boundary of the atmosphere. "Downward" indicates a vector component which is positive when directed downward (negative upward). The surface sensible heat flux, also called "turbulent" heat flux, is the exchange of heat between the surface and the air by motion of air. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='integral_wrt_time_of_surface_downwelling_longwave_flux_in_air',
canonical_units='W s m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means with respect to. The surface called "surface" means the lower boundary of the atmosphere. Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "longwave" means longwave radiation. When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='integral_wrt_time_of_surface_downwelling_shortwave_flux_in_air',
canonical_units='W s m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. The phrase "wrt" means with respect to. The surface called "surface" means the lower boundary of the atmosphere. Downwelling radiation is radiation from above. It does not mean "net downward". The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. The term "shortwave" means shortwave radiation. Surface downwelling shortwave is the sum of direct and diffuse solar radiation incident on the surface, and is sometimes called "global radiation". When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='integral_wrt_time_of_surface_net_downward_longwave_flux',
canonical_units='W s m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. "wrt" means with respect to. The surface called "surface" means the lower boundary of the atmosphere. "Downward" indicates a vector component which is positive when directed downward (negative upward). Net downward radiation is the difference between radiation from above (downwelling) and radiation from below (upwelling). "longwave" means longwave radiation. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='integral_wrt_time_of_surface_net_downward_shortwave_flux',
canonical_units='W s m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. "wrt" means with respect to. The surface called "surface" means the lower boundary of the atmosphere. "Downward" indicates a vector component which is positive when directed downward (negative upward). Net downward radiation is the difference between radiation from above (downwelling) and radiation from below (upwelling). "Shortwave" means shortwave radiation. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='integral_wrt_time_of_toa_net_downward_shortwave_flux',
canonical_units='W s m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. "wrt" means with respect to. "toa" means top of atmosphere. "Downward" indicates a vector component which is positive when directed downward (negative upward). Net downward radiation is the difference between radiation from above (downwelling) and radiation from below (upwelling).  "Shortwave" means shortwave radiation. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='integral_wrt_time_of_toa_outgoing_longwave_flux',
canonical_units='W s m-2',
grib=None,
amip=None,
description='The phrase "integral_wrt_X_of_Y" means int Y dX. The data variable should have an axis for X specifying the limits of the integral as bounds. "wrt" means with respect to. "toa" means top of atmosphere. "Longwave" means longwave radiation. The TOA outgoing longwave flux is the upwelling thermal radiative flux, often called the "outgoing longwave radiation" or "OLR". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='iron_growth_limitation_of_calcareous_phytoplankton',
canonical_units='1',
grib=None,
amip=None,
description='"Calcareous phytoplankton" are phytoplankton that produce calcite. Calcite is a mineral that is a polymorph of calcium carbonate. The chemical formula of calcite is CaCO3. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. "Iron growth limitation" means the ratio of the growth rate of a species population in the environment (where there is a finite availability of iron) to the theoretical growth rate if there were no such limit on iron availability.',
),
CFStandardNameDC(
name='iron_growth_limitation_of_diatoms',
canonical_units='1',
grib=None,
amip=None,
description='Diatoms are phytoplankton with an external skeleton made of silica. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. "Iron growth limitation" means the ratio of the growth rate of a species population in the environment (where there is a finite availability of iron) to the theoretical growth rate if there were no such limit on iron availability.',
),
CFStandardNameDC(
name='iron_growth_limitation_of_diazotrophic_phytoplankton',
canonical_units='1',
grib=None,
amip=None,
description='"Iron growth limitation" means the ratio of the growth rate of a biological population in the environment (where there is a finite availability of iron) to the theoretical growth rate if there were no such limit on iron availability. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. Diazotrophic phytoplankton are phytoplankton (predominantly from Phylum Cyanobacteria) that are able to fix molecular nitrogen (gas or solute) in addition to nitrate and ammonium.',
),
CFStandardNameDC(
name='iron_growth_limitation_of_miscellaneous_phytoplankton',
canonical_units='1',
grib=None,
amip=None,
description='Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. "Miscellaneous phytoplankton" are all those phytoplankton that are not diatoms, diazotrophs, calcareous phytoplankton, picophytoplankton or other separately named components of the phytoplankton population. "Iron growth limitation" means the ratio of the growth rate of a species population in the environment (where there is a finite availability of iron) to the theoretical growth rate if there were no such limit on iron availability.',
),
CFStandardNameDC(
name='iron_growth_limitation_of_picophytoplankton',
canonical_units='1',
grib=None,
amip=None,
description='Picophytoplankton are phytoplankton of less than 2 micrometers in size. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. "Iron growth limitation" means the ratio of the growth rate of a species population in the environment (where there is a finite availability of iron) to the theoretical growth rate if there were no such limit on iron availability.',
),
CFStandardNameDC(
name='isccp_cloud_area_fraction',
canonical_units='1',
grib=None,
amip='clisccp',
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. The cloud area fraction is for the whole atmosphere column, as seen from the surface or the top of the atmosphere. For the cloud area fraction between specified levels in the atmosphere, standard names including "cloud_area_fraction_in_atmosphere_layer" are used. Standard names also exist for high, medium and low cloud types. The ISCCP cloud area fraction is diagnosed from atmosphere model output by the ISCCP simulator software in such a way as to be comparable with the observational diagnostics of ISCCP (the International Satellite Cloud Climatology Project). Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='isotope_ratio_of_17O_to_16O_in_sea_water_excluding_solutes_and_solids',
canonical_units='1',
grib=None,
amip=None,
description='The phrase "ratio_of_X_to_Y" means X/Y. The phrase "isotope_ratio" is used in the construction isotope_ratio_of_A_to_B where A and B are both named isotopes. It means the ratio of the number of atoms of A to the number of atoms of B present within a medium. "O" means the element "oxygen" and "17O" is the stable isotope "oxygen-17". "16O" is the stable isotope "oxygen-16". The phrase "in_sea_water_excluding_solutes_and_solids" means that the standard name refers only to the chemical compound water and does not include material that may be dissolved or suspended in the aqueous medium.',
),
CFStandardNameDC(
name='isotope_ratio_of_18O_to_16O_in_sea_water_excluding_solutes_and_solids',
canonical_units='1',
grib=None,
amip=None,
description='The phrase "ratio_of_X_to_Y" means X/Y. The phrase "isotope_ratio" is used in the construction isotope_ratio_of_A_to_B where A and B are both named isotopes. It means the ratio of the number of atoms of A to the number of atoms of B present within a medium. "O" means the element "oxygen" and "18O" is the stable isotope "oxygen-18". "16O" is the stable isotope "oxygen-16". The phrase "in_sea_water_excluding_solutes_and_solids" means that the standard name refers only to the chemical compound water and does not include material that may be dissolved or suspended in the aqueous medium.',
),
CFStandardNameDC(
name='isotropic_longwave_radiance_in_air',
canonical_units='W m-2 sr-1',
grib=None,
amip=None,
description='"longwave" means longwave radiation. Radiance is the radiative flux in a particular direction, per unit of solid angle. If radiation is isotropic, the radiance is independent of direction, so the direction should not be specified. If the radiation is directionally dependent, a standard name of upwelling or downwelling radiance should be chosen instead.',
),
CFStandardNameDC(
name='isotropic_radiance_per_unit_wavelength_in_air',
canonical_units='W m-2 m-1 sr-1',
grib=None,
amip=None,
description='Radiance is the radiative flux in a particular direction, per unit of solid angle. If radiation is isotropic, the radiance is independent of direction, so the direction should not be specified. If the radiation is directionally dependent, a standard name of upwelling or downwelling radiance should be chosen instead. A coordinate variable for radiation wavelength should be given the standard name radiation_wavelength.',
),
CFStandardNameDC(
name='isotropic_shortwave_radiance_in_air',
canonical_units='W m-2 sr-1',
grib=None,
amip=None,
description='"shortwave" means shortwave radiation. Radiance is the radiative flux in a particular direction, per unit of solid angle. If radiation is isotropic, the radiance is independent of direction, so the direction should not be specified. If the radiation is directionally dependent, a standard name of upwelling or downwelling radiance should be chosen instead.',
),
CFStandardNameDC(
name='kinetic_energy_content_of_atmosphere_layer',
canonical_units='J m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well.',
),
CFStandardNameDC(
name='kinetic_energy_dissipation_in_atmosphere_boundary_layer',
canonical_units='W m-2',
grib='E145',
amip=None,
description=None,
),
CFStandardNameDC(
name='lagrangian_tendency_of_air_pressure',
canonical_units='Pa s-1',
grib='39 E135',
amip='wap',
description='"tendency_of_X" means derivative of X with respect to time. The Lagrangian tendency of a quantity is its rate of change following the motion of the fluid, also called the "material derivative" or "convective derivative". The Lagrangian tendency of air pressure, often called "omega", plays the role of the upward component of air velocity when air pressure is being used as the vertical coordinate. If the vertical air velocity is upwards, it is negative when expressed as a tendency of air pressure; downwards is positive. Air pressure is the force per unit area which would be exerted when the moving gas molecules of which the air is composed strike a theoretical surface of any orientation.',
),
CFStandardNameDC(
name='lagrangian_tendency_of_atmosphere_sigma_coordinate',
canonical_units='s-1',
grib='38',
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The Lagrangian tendency of a quantity is its rate of change following the motion of the fluid, also called the "material derivative" or "convective derivative". The Lagrangian tendency of sigma plays the role of the upward component of air velocity when the atmosphere sigma coordinate (a dimensionless atmosphere vertical coordinate) is being used as the vertical coordinate. If the vertical air velocity is upwards, it is negative when expressed as a tendency of sigma; downwards is positive. See Appendix D of the CF convention for information about parametric vertical coordinates.',
),
CFStandardNameDC(
name='land_area_fraction',
canonical_units='1',
grib='81',
amip='sftlf',
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction.',
),
CFStandardNameDC(
name='land_binary_mask',
canonical_units='1',
grib='E172',
amip=None,
description='X_binary_mask has 1 where condition X is met, 0 elsewhere. 1 = land, 0 = sea.',
),
CFStandardNameDC(
name='land_cover_lccs',
canonical_units=None,
grib=None,
amip=None,
description='A variable with the standard name of land_cover_lccs contains strings which indicate the nature of the surface, e.g. cropland_..., tree_... . Each string should represent a land cover class constructed using the Land Cover Classification System (LCCS; Di Gregorio A., 2005, UN Land Cover Classification System (LCCS) - Classification concepts and user manual for Software version 2; available at www.fao.org/DOCREP/003/X0596E/X0596e00.htm). String values should represent the classifiers used to define each class.',
),
CFStandardNameDC(
name='land_ice_area_fraction',
canonical_units='1',
grib=None,
amip='sftgif',
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='land_ice_basal_drag',
canonical_units='Pa',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. Basal drag is a resistive stress opposing ice flow at the ice bedrock boundary.',
),
CFStandardNameDC(
name='land_ice_basal_melt_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.  The land ice basal melt rate is the rate at which ice is lost per unit area at the base of the ice.',
),
CFStandardNameDC(
name='land_ice_basal_specific_mass_balance_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Specific mass balance" means the net rate at which ice is added per unit area. A negative value means loss of ice. For an area-average, the cell_methods attribute should be used to specify whether the average is over the area of the whole grid cell or the area of land ice only. "Basal specific mass balance" means the net rate at which ice is added per unit area at the land ice base.',
),
CFStandardNameDC(
name='land_ice_basal_temperature',
canonical_units='K',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. The standard name land_ice_basal_temperature means the temperature of the land ice at its lower boundary.',
),
CFStandardNameDC(
name='land_ice_basal_upward_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. A velocity is a vector quantity. "Upward" indicates a vector component which is positive when directed upward (negative downward).',
),
CFStandardNameDC(
name='land_ice_basal_x_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "x" indicates a vector component along the grid x-axis, positive with increasing x. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='land_ice_basal_y_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "y" indicates a vector component along the grid y-axis, positive with increasing y. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='land_ice_calving_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. The land ice calving rate is the rate at which ice is lost per unit area through calving into the ocean.',
),
CFStandardNameDC(
name='land_ice_lwe_basal_melt_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"lwe" means liquid water equivalent. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. The land ice basal melt rate is the rate at which ice is lost per unit area at the base of the ice.',
),
CFStandardNameDC(
name='land_ice_lwe_calving_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"lwe" means liquid water equivalent. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. The land ice calving rate is the rate at which ice is lost per unit area through calving into the ocean.',
),
CFStandardNameDC(
name='land_ice_lwe_surface_specific_mass_balance_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. "lwe" means liquid water equivalent. Specific mass balance means the net rate at which ice is added per unit area at the land ice surface due to all processes of surface accumulation and ablation. A negative value means loss of ice.',
),
CFStandardNameDC(
name='land_ice_mass',
canonical_units='kg',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. The horizontal domain over which the quantity is calculated is described by the associated coordinate variables and coordinate bounds or by a coordinate variable or scalar coordinate variable with the standard name of "region" supplied according to section 6.1.1 of the CF conventions.',
),
CFStandardNameDC(
name='land_ice_mass_not_displacing_sea_water',
canonical_units='kg',
grib=None,
amip=None,
description='"Land ice not displacing sea water" means land ice that would not alter sea level if the ice were converted to water and added to the ocean. It excludes ice shelves (and any other sort of floating ice) and it excludes a fraction of grounded ice-sheet mass equivalent to the mass of any sea water it displaces. It includes glaciers and a portion of grounded ice-sheet mass exceeding the mass of any sea water displaced. The quantity with standard name land_ice_mass_not_displacing_sea_water is the total mass integrated over an area of land ice. The geographical extent of the ice over which the mass was calculated should be described by providing bounds on the horizontal coordinate variable or scalar with the standard name of "region" supplied according to section 6.1.1 of the CF convention.',
),
CFStandardNameDC(
name='land_ice_runoff_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. Runoff is the liquid water which drains from land. If not specified, "runoff" refers to the sum of surface runoff and subsurface drainage. Runoff flux over land ice is the difference between any available liquid water in the snowpack due to rainfall and melting minus any refreezing and liquid water retained in the snowpack. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='land_ice_sigma_coordinate',
canonical_units='1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='land_ice_specific_mass_flux_due_to_calving',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. "Specific mass flux due to calving" means the change in land ice mass per unit area resulting from iceberg calving. A negative value means loss of ice. For an area-average, the cell_methods attribute should be used to specify whether the average is over the area of the whole grid cell or the area of land ice only. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='land_ice_specific_mass_flux_due_to_calving_and_ice_front_melting',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Specific mass flux due to calving and ice front melting" means the change in land ice mass per unit area resulting from iceberg calving and melting on the vertical ice front. A negative value means loss of ice. For an area-average, the cell_methods attribute should be used to specify whether the average is over the area of the whole grid cell or the area of land ice only. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='land_ice_surface_melt_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The surface called "surface" means the lower boundary of the atmosphere. The land_ice_surface_melt_flux is the loss of ice mass resulting from surface melting. For an area-average, the cell_methods attribute should be used to specify whether the average is over the area of the whole grid cell or the area of land ice only. There is also a standard name for the quantity surface_snow_and_ice_melt_flux.',
),
CFStandardNameDC(
name='land_ice_surface_specific_mass_balance_flux',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Specific mass balance" means the net rate at which ice is added per unit area. A negative value means loss of ice. For an area-average, the cell_methods attribute should be used to specify whether the average is over the area of the whole grid cell or the area of land ice only. "Surface specific mass balance" means the net rate at which ice is added per unit area at the land ice surface due to all processes of surface accumulation and ablation.',
),
CFStandardNameDC(
name='land_ice_surface_specific_mass_balance_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. Specific mass balance means the net rate at which ice is added at the land ice surface due to all processes of surface accumulation and ablation. A negative value means loss of ice.',
),
CFStandardNameDC(
name='land_ice_surface_upward_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. A velocity is a vector quantity. "Upward" indicates a vector component which is positive when directed upward (negative downward). The surface called "surface" means the lower boundary of the atmosphere.',
),
CFStandardNameDC(
name='land_ice_surface_x_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. A velocity is a vector quantity. "x" indicates a vector component along the grid x-axis, positive with increasing x. The surface called "surface" means the lower boundary of the atmosphere.',
),
CFStandardNameDC(
name='land_ice_surface_y_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. A velocity is a vector quantity. "y" indicates a vector component along the grid y-axis, positive with increasing y. The surface called "surface" means the lower boundary of the atmosphere.',
),
CFStandardNameDC(
name='land_ice_temperature',
canonical_units='K',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='land_ice_thickness',
canonical_units='m',
grib=None,
amip=None,
description='"Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. "Thickness" means the vertical extent of a layer.',
),
CFStandardNameDC(
name='land_ice_vertical_mean_x_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "x" indicates a vector component along the grid x-axis, positive with increasing x. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. The vertical mean land ice velocity is the average from the bedrock to the surface of the ice.',
),
CFStandardNameDC(
name='land_ice_vertical_mean_y_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "y" indicates a vector component along the grid y-axis, positive with increasing y. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves. The vertical mean land ice velocity is the average from the bedrock to the surface of the ice.',
),
CFStandardNameDC(
name='land_ice_x_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "x" indicates a vector component along the grid x-axis, positive with increasing x. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='land_ice_y_velocity',
canonical_units='m s-1',
grib=None,
amip=None,
description='A velocity is a vector quantity. "y" indicates a vector component along the grid y-axis, positive with increasing y. "Land ice" means glaciers, ice-caps and ice-sheets resting on bedrock and also includes ice-shelves.',
),
CFStandardNameDC(
name='land_surface_liquid_water_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The surface called "surface" means the lower boundary of the atmosphere. "Amount" means mass per unit area. The quantity with standard name land_surface_liquid_water_amount includes water in rivers, wetlands, lakes, reservoirs and liquid precipitation intercepted by the vegetation canopy.',
),
CFStandardNameDC(
name='land_water_amount',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Amount" means mass per unit area. "Water" means water in all phases. The phrase "land_water_amount", often known as "Terrestrial Water Storage", includes: surface liquid water (water in rivers, wetlands, lakes, reservoirs, rainfall intercepted by the canopy); surface ice and snow (glaciers, ice caps, grounded ice sheets not displacing sea water, river and lake ice, other surface ice such as frozen flood water, snow lying on the surface and intercepted by the canopy); subsurface water (liquid and frozen soil water, groundwater).',
),
CFStandardNameDC(
name='latitude',
canonical_units='degree_north',
grib=None,
amip='latitude',
description='Latitude is positive northward; its units of degree_north (or equivalent) indicate this explicitly. In a latitude-longitude system defined with respect to a rotated North Pole, the standard name of grid_latitude should be used instead of latitude. Grid latitude is positive in the grid-northward direction, but its units should be plain degree.',
),
CFStandardNameDC(
name='leaf_area_index',
canonical_units='1',
grib=None,
amip=None,
description='"X_area" means the horizontal area occupied by X within the grid cell.',
),
CFStandardNameDC(
name='leaf_mass_content_of_carbon',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.',
),
CFStandardNameDC(
name='leaf_mass_content_of_nitrogen',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.',
),
CFStandardNameDC(
name='lightning_radiant_energy',
canonical_units='J',
grib=None,
amip=None,
description='The standard name "lightning radiant energy" means the energy emitted as electromagnetic radiation due to lightning. A coordinate variable of radiation_wavelength, radiation_frequency, or sensor_band_central_wavelength may be specified to indicate that the lightning_radiant_energy applies at specific wavelengths or frequencies. Bounds of the time and spatial coordinates may be specified to indicate the time interval and spatial extent over which the energy is emitted.',
),
CFStandardNameDC(
name='liquid_water_cloud_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. The cloud area fraction is for the whole atmosphere column, as seen from the surface or the top of the atmosphere. For the cloud area fraction between specified levels in the atmosphere, standard names including "cloud_area_fraction_in_atmosphere_layer" are used. Standard names also exist for high, medium and low cloud types. "Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='liquid_water_cloud_area_fraction_in_atmosphere_layer',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be "model_level_number", but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Standard names also exist for high, medium and low cloud types. Standard names referring only to "cloud_area_fraction" should be used for quantities for the whole atmosphere column. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='liquid_water_content_of_permafrost_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area.  Permafrost is soil or rock that has remained at a temperature at or below zero degrees Celsius throughout the seasonal cycle for two or more years.',
),
CFStandardNameDC(
name='liquid_water_content_of_soil_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Quantities defined for a soil layer must have a vertical coordinate variable with boundaries indicating the extent of the layer(s).',
),
CFStandardNameDC(
name='liquid_water_content_of_surface_snow',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. Surface snow refers to the snow on the solid ground or on surface ice cover, but excludes, for example, falling snowflakes and snow on plants.',
),
CFStandardNameDC(
name='liquid_water_mass_flux_into_soil_due_to_surface_snow_melt',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. Surface snow refers to the snow on the solid ground or on surface ice cover, but excludes, for example, falling snowflakes and snow on plants. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase.',
),
CFStandardNameDC(
name='litter_mass_content_of_13C',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Litter" is dead plant material in or above the soil. "C" means the element carbon and "13C" is the stable isotope "carbon-13", having six protons and seven neutrons.',
),
CFStandardNameDC(
name='litter_mass_content_of_14C',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Litter" is dead plant material in or above the soil. "C" means the element carbon and "14C" is the radioactive isotope "carbon-14", having six protons and eight neutrons and used in radiocarbon dating.',
),
CFStandardNameDC(
name='litter_mass_content_of_carbon',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Litter" is dead plant material in or above the soil. It is distinct from coarse wood debris. The precise distinction between "fine" and "coarse" is model dependent. "Content" indicates a quantity per unit area. The sum of the quantities with standard names surface_litter_mass_content_of_carbon and subsurface_litter_mass_content_of_carbon has the standard name litter_mass_content_of_carbon.',
),
CFStandardNameDC(
name='litter_mass_content_of_nitrogen',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Litter" is dead plant material in or above the soil. It is distinct from coarse wood debris. The precise distinction between "fine" and "coarse" is model dependent. The sum of the quantities with standard names surface_litter_mass_content_of_nitrogen and subsurface_litter_mass_content_of_nitrogen has the standard name litter_mass_content_of_nitrogen.',
),
CFStandardNameDC(
name='location_test_quality_flag',
canonical_units='1',
grib=None,
amip=None,
description='A quality flag that reports the result of the Location test, which checks that a location is within reasonable bounds. The linkage between the data variable and this variable is achieved using the ancillary_variables attribute. There are standard names for other specific quality tests which take the form of X_quality_flag. Quality information that does not match any of the specific quantities should be given the more general standard name of quality_flag.',
),
CFStandardNameDC(
name='log10_size_interval_based_number_size_distribution_of_cloud_condensation_nuclei_at_stp_in_air',
canonical_units='m-3',
grib=None,
amip=None,
description='The cloud condensation nuclei number size distribution is the number concentration of aerosol particles, normalised to the decadal logarithmic size interval the concentration applies to, as a function of particle diameter, where the particle acts as condensation nucleus for liquid-phase clouds. A coordinate variable with the standard name of relative_humidity should be specified to indicate that the property refers to a specific supersaturation with respect to liquid water. A coordinate variable with the standard name of electrical_mobility_particle_diameter should be specified to indicate that the property applies at specific mobility particle sizes. To specify the relative humidity at which the particle sizes were selected, provide a scalar coordinate variable with the standard name of relative_humidity_for_aerosol_particle_size_selection. The ability of a particle to act as a condensation nucleus is determined by its size, chemical composition, and morphology. "log10_X" means common logarithm (i.e. base 10) of X. "stp" means standard temperature (0 degC) and pressure (101325 Pa).',
),
CFStandardNameDC(
name='longitude',
canonical_units='degree_east',
grib=None,
amip='longitude',
description='Longitude is positive eastward; its units of degree_east (or equivalent) indicate this explicitly. In a latitude-longitude system defined with respect to a rotated North Pole, the standard name of grid_longitude should be used instead of longitude. Grid longitude is positive in the grid-eastward direction, but its units should be plain degree.',
),
CFStandardNameDC(
name='low_type_cloud_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. Low type clouds are: Stratus, Stratocumulus, Cumulus, Cumulonimbus. X_type_cloud_area_fraction is generally determined on the basis of cloud type, though Numerical Weather Prediction (NWP) models often calculate them based on the vertical location of the cloud. For the cloud area fraction between specified levels in the atmosphere, standard names including "cloud_area_fraction_in_atmosphere_layer" are used. Standard names referring only to "cloud_area_fraction" should be used for quantities for the whole atmosphere column. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='lwe_convective_precipitation_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='Convective precipitation is that produced by the convection schemes in an atmosphere model. "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases. The abbreviation "lwe" means liquid water equivalent. "Precipitation rate" means the depth or thickness of the layer formed by precipitation per unit time.',
),
CFStandardNameDC(
name='lwe_convective_snowfall_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"lwe" means liquid water equivalent.',
),
CFStandardNameDC(
name='lwe_precipitation_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"Precipitation" in the earth\'s atmosphere means precipitation of water in all phases. The abbreviation "lwe" means liquid water equivalent. "Precipitation rate" means the depth or thickness of the layer formed by precipitation per unit time.',
),
CFStandardNameDC(
name='lwe_snowfall_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"lwe" means liquid water equivalent.',
),
CFStandardNameDC(
name='lwe_stratiform_precipitation_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='Stratiform precipitation, whether liquid or frozen, is precipitation that formed in stratiform cloud. "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases. The abbreviation "lwe" means liquid water equivalent. "Precipitation rate" means the depth or thickness of the layer formed by precipitation per unit time.',
),
CFStandardNameDC(
name='lwe_stratiform_snowfall_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='Stratiform precipitation, whether liquid or frozen, is precipitation that formed in stratiform cloud.  "lwe" means liquid water equivalent.',
),
CFStandardNameDC(
name='lwe_thickness_of_atmosphere_mass_content_of_water_vapor',
canonical_units='m',
grib='E137',
amip=None,
description='"lwe" means liquid water equivalent. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including content_of_atmosphere_layer are used. Atmosphere water vapor content is sometimes referred to as "precipitable water", although this term does not imply the water could all be precipitated.',
),
CFStandardNameDC(
name='lwe_thickness_of_canopy_water_amount',
canonical_units='m',
grib=None,
amip=None,
description='The abbreviation "lwe" means liquid water equivalent. "Amount" means mass per unit area. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. "Water" means water in all phases, including frozen i.e. ice and snow. The canopy water is the water on the canopy. "Canopy" means the vegetative covering over a surface. The canopy is often considered to be the outer surfaces of the vegetation. Plant height and the distribution, orientation and shape of plant leaves within a canopy influence the atmospheric environment and many plant processes within the canopy. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Canopy.',
),
CFStandardNameDC(
name='lwe_thickness_of_convective_precipitation_amount',
canonical_units='m',
grib='E143',
amip=None,
description='The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. Convective precipitation is that produced by the convection schemes in an atmosphere model. "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases. The abbreviation "lwe" means liquid water equivalent.',
),
CFStandardNameDC(
name='lwe_thickness_of_convective_snowfall_amount',
canonical_units='m',
grib=None,
amip=None,
description='"lwe" means liquid water equivalent. "Amount" means mass per unit area. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area.',
),
CFStandardNameDC(
name='lwe_thickness_of_frozen_water_content_of_soil_layer',
canonical_units='m',
grib=None,
amip=None,
description='"frozen_water" means ice. "lwe" means liquid water equivalent. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. "Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Quantities defined for a soil layer must have a vertical coordinate variable with boundaries indicating the extent of the layer(s).',
),
CFStandardNameDC(
name='lwe_thickness_of_moisture_content_of_soil_layer',
canonical_units='m',
grib=None,
amip=None,
description='"lwe" means liquid water equivalent. "moisture" means water in all phases contained in soil. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. "Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Quantities defined for a soil layer must have a vertical coordinate variable with boundaries indicating the extent of the layer(s).',
),
CFStandardNameDC(
name='lwe_thickness_of_precipitation_amount',
canonical_units='m',
grib=None,
amip=None,
description='The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases. The abbreviation "lwe" means liquid water equivalent.',
),
CFStandardNameDC(
name='lwe_thickness_of_snowfall_amount',
canonical_units='m',
grib='E144',
amip=None,
description='"lwe" means liquid water equivalent. "Amount" means mass per unit area. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area.',
),
CFStandardNameDC(
name='lwe_thickness_of_soil_moisture_content',
canonical_units='m',
grib='E140',
amip=None,
description='"lwe" means liquid water equivalent. "moisture" means water in all phases contained in soil. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. "Content" indicates a quantity per unit area. The "soil content" of a quantity refers to the vertical integral from the surface down to the bottom of the soil model. For the content between specified levels in the soil, standard names including content_of_soil_layer are used.',
),
CFStandardNameDC(
name='lwe_thickness_of_stratiform_precipitation_amount',
canonical_units='m',
grib='E142',
amip=None,
description='The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. Stratiform precipitation, whether liquid or frozen, is precipitation that formed in stratiform cloud. "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases. The abbreviation "lwe" means liquid water equivalent.',
),
CFStandardNameDC(
name='lwe_thickness_of_stratiform_snowfall_amount',
canonical_units='m',
grib=None,
amip=None,
description='"Amount" means mass per unit area.  "lwe" means liquid water equivalent.  The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area.  Stratiform precipitation, whether liquid or frozen, is precipitation that formed in stratiform cloud.',
),
CFStandardNameDC(
name='lwe_thickness_of_surface_snow_amount',
canonical_units='m',
grib='E141',
amip=None,
description='The abbreviation "lwe" means liquid water equivalent. "Amount" means mass per unit area. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. Surface snow amount refers to the amount on the solid ground or on surface ice cover, but excludes, for example, falling snowflakes and snow on plants.',
),
CFStandardNameDC(
name='lwe_thickness_of_water_evaporation_amount',
canonical_units='m',
grib='E182',
amip=None,
description='"lwe" means liquid water equivalent. "Amount" means mass per unit area. The construction lwe_thickness_of_X_amount or _content means the vertical extent of a layer of liquid water having the same mass per unit area. "Water" means water in all phases. Evaporation is the conversion of liquid or solid into vapor. (The conversion of solid alone into vapor is called "sublimation".)',
),
CFStandardNameDC(
name='lwe_water_evaporation_rate',
canonical_units='m s-1',
grib=None,
amip=None,
description='"lwe" means liquid water equivalent. "Water" means water in all phases. Evaporation is the conversion of liquid or solid into vapor. (The conversion of solid alone into vapor is called "sublimation".)',
),
CFStandardNameDC(
name='magnitude_of_derivative_of_position_wrt_model_level_number',
canonical_units='m',
grib=None,
amip=None,
description='The quantity with standard name magnitude_of_derivative_of_position_wrt_model_level_number (known in differential geometry as a "scale factor") is | (dr/dk)ij|, where r(i,j,k) is the vector 3D position of the point with coordinate indices (i,j,k). It is a measure of the gridblock spacing in the z-direction.',
),
CFStandardNameDC(
name='magnitude_of_derivative_of_position_wrt_x_coordinate_index',
canonical_units='m',
grib=None,
amip=None,
description='The quantity with standard name magnitude_of_derivative_of_position_wrt_x_coordinate_index (known in differential geometry as a "scale factor") is | (dr/di)jk|, where r(i,j,k) is the vector 3D position of the point with coordinate indices (i,j,k). It is a measure of the gridblock spacing in the x-direction.',
),
CFStandardNameDC(
name='magnitude_of_derivative_of_position_wrt_y_coordinate_index',
canonical_units='m',
grib=None,
amip=None,
description='The quantity with standard name magnitude_of_derivative_of_position_wrt_y_coordinate_index (known in differential geometry as a "scale factor") is | (dr/dj)ik|, where r(i,j,k) is the vector 3D position of the point with coordinate indices (i,j,k). It is a measure of the gridblock spacing in the y-direction.',
),
CFStandardNameDC(
name='magnitude_of_heat_flux_in_sea_water_due_to_advection',
canonical_units='W m-2',
grib=None,
amip=None,
description='"magnitude_of_X" means magnitude of a vector X. The specification of a physical process by the phrase due_to_process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='magnitude_of_sea_ice_displacement',
canonical_units='m',
grib=None,
amip=None,
description='The phrase "magnitude_of_X" means magnitude of a vector X. "Displacement" means the change in geospatial position of an object that has moved over time. If possible, the time interval over which the motion took place should be specified using a bounds variable for the time coordinate variable. A displacement can be represented as a vector. Such a vector should however not be interpreted as describing a rectilinear, constant speed motion but merely as an indication that the start point of the vector is found at the tip of the vector after the time interval associated with the displacement variable. A displacement does not prescribe a trajectory. Sea ice displacement can be defined as a two-dimensional vector, with no vertical component. "Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs.',
),
CFStandardNameDC(
name='magnitude_of_surface_downward_stress',
canonical_units='Pa',
grib=None,
amip=None,
description='The phrase "magnitude_of_X" means magnitude of a vector X. The surface called "surface" means the lower boundary of the atmosphere. "Surface stress" means the shear stress (force per unit area) exerted by the wind at the surface. A downward stress is a downward flux of momentum. Over large bodies of water, wind stress can drive near-surface currents. "Downward" indicates a vector component which is positive when directed downward (negative upward).',
),
CFStandardNameDC(
name='mass_concentration_of_acetic_acid_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for acetic_acid is CH3COOH. The IUPAC name for acetic acid is ethanoic acid.",
),
CFStandardNameDC(
name='mass_concentration_of_aceto_nitrile_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for aceto-nitrile is CH3CN. The IUPAC name for aceto-nitrile is ethanenitrile.",
),
CFStandardNameDC(
name='mass_concentration_of_alkanes_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. Alkanes are saturated hydrocarbons, i.e. they do not contain any chemical double bonds.  Alkanes contain only hydrogen and carbon combined in the general proportions C(n)H(2n+2); "alkanes" is the term used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names exist for some individual alkane species, e.g., methane and ethane.',
),
CFStandardNameDC(
name='mass_concentration_of_alkenes_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. Alkenes are unsaturated hydrocarbons as they contain chemical double bonds between adjacent carbon atoms.  Alkenes contain only hydrogen and carbon combined in the general proportions C(n)H(2n); "alkenes" is the term used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names exist for some individual alkene species, e.g., ethene and propene.',
),
CFStandardNameDC(
name='mass_concentration_of_alpha_hexachlorocyclohexane_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for alpha_hexachlorocyclohexane is C6H6Cl6.",
),
CFStandardNameDC(
name='mass_concentration_of_alpha_pinene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for alpha_pinene is C10H16. The IUPAC name for alpha-pinene is (1S,5S)-2,6,6-trimethylbicyclo[3.1.1]hept-2-ene.",
),
CFStandardNameDC(
name='mass_concentration_of_ammonia_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for ammonia is NH3.",
),
CFStandardNameDC(
name='mass_concentration_of_ammonium_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for ammonium is NH4.',
),
CFStandardNameDC(
name='mass_concentration_of_anthropogenic_nmvoc_expressed_as_carbon_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Anthropogenic" means influenced, caused, or created by human activity.',
),
CFStandardNameDC(
name='mass_concentration_of_aromatic_compounds_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. Aromatic compounds in organic chemistry are compounds that contain at least one benzene ring of six carbon atoms joined by alternating single and double covalent bonds.  The simplest aromatic compound is benzene itself.  In standard names "aromatic_compounds" is the term used to describe the group of aromatic chemical species that  are represented within a given model.  The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.  Standard names exist for some individual aromatic species, e.g. benzene and xylene.',
),
CFStandardNameDC(
name='mass_concentration_of_atomic_bromine_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical symbol for atomic bromine is Br.",
),
CFStandardNameDC(
name='mass_concentration_of_atomic_chlorine_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical symbol for atomic chlorine is Cl.",
),
CFStandardNameDC(
name='mass_concentration_of_atomic_nitrogen_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical symbol for atomic nitrogen is N.",
),
CFStandardNameDC(
name='mass_concentration_of_benzene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for benzene is C6H6.  Benzene is the simplest aromatic hydrocarbon and has a ring structure consisting of six carbon atoms joined by alternating single and double chemical bonds. Each carbon atom is additionally bonded to one hydrogen atom. There are standard names that refer to aromatic_compounds as a group, as well as those for individual species.",
),
CFStandardNameDC(
name='mass_concentration_of_beta_pinene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for beta_pinene is C10H16.  The IUPAC name for beta-pinene is (1S,5S)-6,6-dimethyl-2-methylenebicyclo[3.1.1]heptane.",
),
CFStandardNameDC(
name='mass_concentration_of_biogenic_nmvoc_expressed_as_carbon_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Biogenic" means influenced, caused, or created by natural processes.',
),
CFStandardNameDC(
name='mass_concentration_of_biological_taxon_expressed_as_carbon_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction "A_expressed_as_B", where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Mass concentration of biota expressed as carbon is also referred to as "carbon biomass". "Biological taxon" is a name or other label identifying an organism or a group of organisms as belonging to a unit of classification in a hierarchical taxonomy. There must be an auxiliary coordinate variable with standard name biological_taxon_name to identify the taxon in human readable format and optionally an auxiliary coordinate variable with standard name biological_taxon_lsid to provide a machine-readable identifier. See Section 6.1.2 of the CF convention (version 1.8 or later) for information about biological taxon auxiliary coordinate variables.',
),
CFStandardNameDC(
name='mass_concentration_of_biological_taxon_expressed_as_chlorophyll_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction "A_expressed_as_B", where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Biological taxon" is a name or other label identifying an organism or a group of organisms as belonging to a unit of classification in a hierarchical taxonomy. There must be an auxiliary coordinate variable with standard name biological_taxon_name to identify the taxon in human readable format and optionally an auxiliary coordinate variable with standard name biological_taxon_lsid to provide a machine-readable identifier. See Section 6.1.2 of the CF convention (version 1.8 or later) for information about biological taxon auxiliary coordinate variables. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms.',
),
CFStandardNameDC(
name='mass_concentration_of_biological_taxon_expressed_as_nitrogen_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction "A_expressed_as_B", where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Mass concentration of biota expressed as nitrogen is also referred to as "nitrogen biomass". "Biological taxon" is a name or other label identifying an organism or a group of organisms as belonging to a unit of classification in a hierarchical taxonomy. There must be an auxiliary coordinate variable with standard name biological_taxon_name to identify the taxon in human readable format and optionally an auxiliary coordinate variable with standard name biological_taxon_lsid to provide a machine-readable identifier. See Section 6.1.2 of the CF convention (version 1.8 or later) for information about biological taxon auxiliary coordinate variables.',
),
CFStandardNameDC(
name='mass_concentration_of_biomass_burning_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_concentration_of_bromine_chloride_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for bromine chloride is BrCl.",
),
CFStandardNameDC(
name='mass_concentration_of_bromine_monoxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for bromine monoxide is BrO.",
),
CFStandardNameDC(
name='mass_concentration_of_bromine_nitrate_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for bromine nitrate is BrONO2.",
),
CFStandardNameDC(
name='mass_concentration_of_brox_expressed_as_bromine_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Brox" describes a family of chemical species consisting of inorganic bromine compounds with the exception of hydrogen bromide (HBr) and bromine nitrate (BrONO2). The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Brox" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity with a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Inorganic bromine", sometimes referred to as Bry, describes a family of chemical species which result from the degradation of source gases containing bromine (halons, methyl bromide, VSLS) and natural inorganic bromine sources such as volcanoes, sea salt and other aerosols. Standard names that use the term "inorganic_bromine" are used for quantities that contain all inorganic bromine species including HCl and ClONO2.',
),
CFStandardNameDC(
name='mass_concentration_of_butane_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for butane is C4H10. Butane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.",
),
CFStandardNameDC(
name='mass_concentration_of_calcareous_phytoplankton_expressed_as_chlorophyll_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms. "Calcareous phytoplankton" are phytoplankton that produce calcite. Calcite is a mineral that is a polymorph of calcium carbonate. The chemical formula of calcite is CaCO3. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis.',
),
CFStandardNameDC(
name='mass_concentration_of_carbon_dioxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for carbon dioxide is CO2.",
),
CFStandardNameDC(
name='mass_concentration_of_carbon_monoxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula of carbon monoxide is CO.",
),
CFStandardNameDC(
name='mass_concentration_of_carbon_tetrachloride_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula of carbon tetrachloride is CCl4. The IUPAC name for carbon tetrachloride is tetrachloromethane.",
),
CFStandardNameDC(
name='mass_concentration_of_cfc113a_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC113a is CCl3CF3. The IUPAC name for CFC113a is 1,1,1-trichloro-2,2,2-trifluoroethane.',
),
CFStandardNameDC(
name='mass_concentration_of_cfc113_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC113 is CCl2FCClF2. The IUPAC name for CFC113 is 1,1,2-trichloro-1,2,2-trifluoroethane.',
),
CFStandardNameDC(
name='mass_concentration_of_cfc114_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC114 is CClF2CClF2. The IUPAC name for CFC114 is 1,2-dichloro-1,1,2,2-tetrafluoroethane.',
),
CFStandardNameDC(
name='mass_concentration_of_cfc115_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC115 is CClF2CF3. The IUPAC name for CFC115 is 1-chloro-1,1,2,2,2-pentafluoroethane.',
),
CFStandardNameDC(
name='mass_concentration_of_cfc11_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC11 is CFCl3. The IUPAC name for CFC11 is trichloro(fluoro)methane.',
),
CFStandardNameDC(
name='mass_concentration_of_cfc12_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for CFC12 is CF2Cl2. The IUPAC name for CFC12 is dichloro(difluoro)methane.',
),
CFStandardNameDC(
name='mass_concentration_of_chlorine_dioxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for chlorine dioxide is OClO.",
),
CFStandardNameDC(
name='mass_concentration_of_chlorine_monoxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for chlorine monoxide is ClO.",
),
CFStandardNameDC(
name='mass_concentration_of_chlorine_nitrate_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for chlorine nitrate is ClONO2.",
),
CFStandardNameDC(
name='mass_concentration_of_chlorophyll_a_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description="'Mass concentration' means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical or biological species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms. Chlorophyll-a is the most commonly occurring form of natural chlorophyll. The chemical formula of chlorophyll-a is C55H72O5N4Mg.",
),
CFStandardNameDC(
name='mass_concentration_of_chlorophyll_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms.",
),
CFStandardNameDC(
name='mass_concentration_of_cloud_liquid_water_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='mass_concentration_of_clox_expressed_as_chlorine_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Clox" describes a family of chemical species consisting of inorganic chlorine compounds with the exception of hydrogen chloride (HCl) and chlorine nitrate (ClONO2). The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Clox" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity with a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Inorganic chlorine", sometimes referred to as Cly, describes a family of chemical species which result from the degradation of source gases containing chlorine (CFCs, HCFCs, VSLS) and natural inorganic chlorine sources such as sea salt and other aerosols. Standard names that use the term "inorganic_chlorine" are used for quantities that contain all inorganic chlorine species including HCl and ClONO2.',
),
CFStandardNameDC(
name='mass_concentration_of_coarse_mode_ambient_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. Coarse mode aerosol particles have a diameter of more than 1 micrometer.',
),
CFStandardNameDC(
name='mass_concentration_of_condensed_water_in_soil',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  Condensed water means liquid and ice.',
),
CFStandardNameDC(
name='mass_concentration_of_diatoms_expressed_as_carbon_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Diatoms are single-celled phytoplankton with an external skeleton made of silica. Phytoplankton are a algae that grow where there is sufficient light to support photosynthesis.',
),
CFStandardNameDC(
name='mass_concentration_of_diatoms_expressed_as_chlorophyll_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms. Diatoms are single-celled phytoplankton with an external skeleton made of silica. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis.',
),
CFStandardNameDC(
name='mass_concentration_of_diatoms_expressed_as_nitrogen_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Diatoms are single-celled phytoplankton with an external skeleton made of silica. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis.',
),
CFStandardNameDC(
name='mass_concentration_of_diazotrophic_phytoplankton_expressed_as_carbon_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. Diazotrophic phytoplankton are phytoplankton (predominantly from Phylum Cyanobacteria) that are able to fix molecular nitrogen (gas or solute) in addition to nitrate and ammonium.',
),
CFStandardNameDC(
name='mass_concentration_of_diazotrophic_phytoplankton_expressed_as_chlorophyll_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. Diazotrophic phytoplankton are phytoplankton (predominantly from Phylum Cyanobacteria) that are able to fix molecular nitrogen (gas or solute) in addition to nitrate and ammonium.',
),
CFStandardNameDC(
name='mass_concentration_of_dichlorine_peroxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for dichlorine peroxide is Cl2O2.",
),
CFStandardNameDC(
name='mass_concentration_of_dimethyl_sulfide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for dimethyl sulfide is (CH3)2S.  Dimethyl sulfide is sometimes referred to as DMS.",
),
CFStandardNameDC(
name='mass_concentration_of_dinitrogen_pentoxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for dinitrogen pentoxide is N2O5.",
),
CFStandardNameDC(
name='mass_concentration_of_drizzle_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Drizzle" means drops of water falling through the atmosphere that have a diameter typically in the range 0.2-0.5 mm.',
),
CFStandardNameDC(
name='mass_concentration_of_dust_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_concentration_of_elemental_carbon_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. Chemically, "elemental carbon" is the carbonaceous fraction of particulate matter that is thermally stable in an inert atmosphere to high temperatures near 4000K and can only be gasified by oxidation starting at temperatures above 340 C. It is assumed to be inert and non-volatile under atmospheric conditions and insoluble in any solvent (Ogren and Charlson, 1983).',
),
CFStandardNameDC(
name='mass_concentration_of_ethane_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for ethane is C2H6. Ethane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.",
),
CFStandardNameDC(
name='mass_concentration_of_ethanol_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for ethanol is C2H5OH.",
),
CFStandardNameDC(
name='mass_concentration_of_ethene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for ethene is C2H4. Ethene is a member of the group of hydrocarbons known as alkenes.  There are standard names for the alkene group as well as for some of the individual species.",
),
CFStandardNameDC(
name='mass_concentration_of_ethyne_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for ethyne is HC2H.  Ethyne is the IUPAC name for this species, which is also commonly known as acetylene.",
),
CFStandardNameDC(
name='mass_concentration_of_flagellates_expressed_as_carbon_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Flagellates" are a class of single celled organisms that use a flagellum (whip-like structure) for feeding and locomotion. Some flagellates can photosynthesize and others feed on bacteria, with a few flagellates capable of both.',
),
CFStandardNameDC(
name='mass_concentration_of_flagellates_expressed_as_nitrogen_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Flagellates" are a class of single celled organisms that use a flagellum (whip-like structure) for feeding and locomotion. Some flagellates can photosynthesize and others feed on bacteria, with a few flagellates capable of both.',
),
CFStandardNameDC(
name='mass_concentration_of_formaldehyde_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for formaldehyde is CH2O. The IUPAC name for formaldehyde is methanal.",
),
CFStandardNameDC(
name='mass_concentration_of_formic_acid_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for formic acid is HCOOH.  The IUPAC name for formic acid is methanoic acid.",
),
CFStandardNameDC(
name='mass_concentration_of_gaseous_divalent_mercury_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. "Divalent mercury" means all compounds in which the mercury has two binding sites to other ion(s) in a salt or to other atom(s) in a molecule.',
),
CFStandardNameDC(
name='mass_concentration_of_gaseous_elemental_mercury_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical symbol for mercury is Hg.",
),
CFStandardNameDC(
name='mass_concentration_of_halon1202_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for Halon1202 is CBr2F2. The IUPAC name for Halon1202 is dibromo(difluoro)methane.',
),
CFStandardNameDC(
name='mass_concentration_of_halon1211_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for Halon1211 is CBrClF2. The IUPAC name for Halon1211 is bromo-chloro-difluoromethane.',
),
CFStandardNameDC(
name='mass_concentration_of_halon1301_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for Halon1301 is CBrF3. The IUPAC name for Halon1301 is bromo(trifluoro)methane.',
),
CFStandardNameDC(
name='mass_concentration_of_halon2402_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for Halon2402 is C2Br2F4. The IUPAC name for Halon2402 is 1,2-dibromo-1,1,2,2-tetrafluoroethane.',
),
CFStandardNameDC(
name='mass_concentration_of_hcc140a_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for HCC140a, also called methyl chloroform, is CH3CCl3. The IUPAC name for HCC140a is 1,1,1-trichloroethane.',
),
CFStandardNameDC(
name='mass_concentration_of_hcfc141b_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for HCFC141b is CH3CCl2F. The IUPAC name for HCFC141b is 1,1-dichloro-1-fluoroethane.",
),
CFStandardNameDC(
name='mass_concentration_of_hcfc142b_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for HCFC142b is CH3CClF2. The IUPAC name for HCFC142b is 1-chloro-1,1-difluoroethane.",
),
CFStandardNameDC(
name='mass_concentration_of_hcfc22_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for HCFC22 is CHClF2. The IUPAC name for HCFC22 is chloro(difluoro)methane.',
),
CFStandardNameDC(
name='mass_concentration_of_hexachlorobiphenyl_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for hexachlorobiphenyl is C12H4Cl6.  This structure of this species consists of two linked benzene rings, each of which is additionally bonded to three chlorine atoms.",
),
CFStandardNameDC(
name='mass_concentration_of_hox_expressed_as_hydrogen_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. "HOx" means a combination of two radical species containing hydrogen and oxygen: OH and HO2. The phrase \'expressed_as\' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='mass_concentration_of_hydrogen_bromide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for hydrogen bromide is HBr.",
),
CFStandardNameDC(
name='mass_concentration_of_hydrogen_chloride_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for hydrogen chloride is HCl.",
),
CFStandardNameDC(
name='mass_concentration_of_hydrogen_cyanide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for hydrogen cyanide is HCN.",
),
CFStandardNameDC(
name='mass_concentration_of_hydrogen_peroxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for hydrogen peroxide is H2O2.",
),
CFStandardNameDC(
name='mass_concentration_of_hydroperoxyl_radical_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for the hydroperoxyl radical is HO2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_concentration_of_hydroxyl_radical_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for the hydroxyl radical is OH. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_concentration_of_hypobromous_acid_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for hypobromous acid is HOBr.",
),
CFStandardNameDC(
name='mass_concentration_of_hypochlorous_acid_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for hypochlorous acid is HOCl.",
),
CFStandardNameDC(
name='mass_concentration_of_inorganic_bromine_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Inorganic bromine", sometimes referred to as Bry, describes a family of chemical species which result from the degradation of source gases containing bromine (halons, methyl bromide, VSLS) and natural inorganic bromine sources such as volcanoes, sea salt and other aerosols. "Inorganic bromine" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names that use the term "brox" are used for quantities that contain all inorganic bromine species except HBr and BrONO2.',
),
CFStandardNameDC(
name='mass_concentration_of_inorganic_chlorine_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Inorganic chlorine", sometimes referred to as Cly, describes a family of chemical species which result from the degradation of source gases containing chlorine (CFCs, HCFCs, VSLS) and natural inorganic chlorine sources such as sea salt and other aerosols. "Inorganic chlorine" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names that use the term "clox" are used for quantities that contain all inorganic chlorine species except HCl and ClONO2.',
),
CFStandardNameDC(
name='mass_concentration_of_inorganic_nitrogen_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description="'Mass concentration' means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical or biological species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. 'Inorganic nitrogen' describes a family of chemical species which, in an ocean model, usually includes nitrite, nitrate and ammonium which act as nitrogen nutrients. 'Inorganic nitrogen' is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.",
),
CFStandardNameDC(
name='mass_concentration_of_isoprene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for isoprene is CH2=C(CH3)CH=CH2. The IUPAC name for isoprene is 2-methylbuta-1,3-diene. Isoprene is a member of the group of hydrocarbons known as terpenes. There are standard names for the terpene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_concentration_of_limonene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for limonene is C10H16. The IUPAC name for limonene is 1-methyl-4-prop-1-en-2-ylcyclohexene. Limonene is a member of the group of hydrocarbons known as terpenes. There are standard names for the terpene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_concentration_of_liquid_water_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The mass concentration of liquid water takes into account all cloud droplets and liquid precipitation regardless of drop size or fall speed.',
),
CFStandardNameDC(
name='mass_concentration_of_mercury_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_concentration_of_methane_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for methane is CH4. Methane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.",
),
CFStandardNameDC(
name='mass_concentration_of_methanol_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for methanol is CH3OH.",
),
CFStandardNameDC(
name='mass_concentration_of_methyl_bromide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for methyl bromide is CH3Br. The IUPAC name for methyl bromide is bromomethane.",
),
CFStandardNameDC(
name='mass_concentration_of_methyl_chloride_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for methyl chloride is CH3Cl. The IUPAC name for methyl chloride is chloromethane.",
),
CFStandardNameDC(
name='mass_concentration_of_methyl_hydroperoxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for methyl hydroperoxide is CH3OOH.",
),
CFStandardNameDC(
name='mass_concentration_of_methyl_peroxy_radical_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for methyl_peroxy_radical is CH3O2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_concentration_of_miscellaneous_phytoplankton_expressed_as_chlorophyll_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms. "Miscellaneous phytoplankton" are all those phytoplankton that are not diatoms, diazotrophs, calcareous phytoplankton, picophytoplankton or other separately named components of the phytoplankton population. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis.',
),
CFStandardNameDC(
name='mass_concentration_of_molecular_hydrogen_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for molecular hydrogen is H2.",
),
CFStandardNameDC(
name='mass_concentration_of_nitrate_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for the nitrate anion is NO3-.',
),
CFStandardNameDC(
name='mass_concentration_of_nitrate_radical_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_concentration_of_nitric_acid_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for nitric acid is HNO3.",
),
CFStandardNameDC(
name='mass_concentration_of_nitric_acid_trihydrate_ambient_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. The chemical formula for nitric acid is HNO3. Nitric acid trihydrate, sometimes referred to as NAT, is a stable crystalline substance consisting of three molecules of water to one molecule of nitric acid.',
),
CFStandardNameDC(
name='mass_concentration_of_nitrogen_dioxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for nitrogen dioxide is NO2.",
),
CFStandardNameDC(
name='mass_concentration_of_nitrogen_monoxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for nitrogen monoxide is NO.",
),
CFStandardNameDC(
name='mass_concentration_of_nitrous_acid_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for nitrous acid is HNO2.",
),
CFStandardNameDC(
name='mass_concentration_of_nitrous_oxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for nitrous oxide is N2O.",
),
CFStandardNameDC(
name='mass_concentration_of_nmvoc_expressed_as_carbon_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_concentration_of_nox_expressed_as_nitrogen_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. "Nox" means a combination of two radical species containing nitrogen and oxygen: NO+NO2. The phrase \'expressed_as\' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='mass_concentration_of_noy_expressed_as_nitrogen_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. "Noy" describes a family of chemical species. The family usually includes atomic nitrogen (N), nitrogen monoxide (NO), nitrogen dioxide (NO2), dinitrogen pentoxide (N2O5), nitric acid (HNO3), peroxynitric acid (HNO4), bromine nitrate (BrONO2) , chlorine nitrate (ClONO2) and organic nitrates (most notably peroxyacetyl nitrate, sometimes referred to as PAN, (CH3COO2NO2)). The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. The phrase \'expressed_as\' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A.',
),
CFStandardNameDC(
name='mass_concentration_of_organic_detritus_expressed_as_carbon_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The phrase 'expressed_as' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Organic detritus are particles of debris from decaying plants and animals.",
),
CFStandardNameDC(
name='mass_concentration_of_organic_detritus_expressed_as_nitrogen_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The phrase 'expressed_as' is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Organic detritus are particles of debris from decaying plants and animals.",
),
CFStandardNameDC(
name='mass_concentration_of_oxygenated_hydrocarbons_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'.  "Oxygenated" means containing oxygen. "Hydrocarbon" means a compound containing hydrogen and carbon.',
),
CFStandardNameDC(
name='mass_concentration_of_oxygen_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.',
),
CFStandardNameDC(
name='mass_concentration_of_ozone_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for ozone is O3.",
),
CFStandardNameDC(
name='mass_concentration_of_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. The term "particulate_organic_matter_dry_aerosol" means all particulate organic matter dry aerosol except elemental carbon. It is the sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_concentration_of_peroxyacetyl_nitrate_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for peroxyacetyl nitrate, sometimes referred to as PAN, is CH3COO2NO2.  The IUPAC name for peroxyacetyl_nitrate is nitroethaneperoxoate.",
),
CFStandardNameDC(
name='mass_concentration_of_peroxynitric_acid_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for peroxynitric acid, sometimes referred to as PNA, is HO2NO2.",
),
CFStandardNameDC(
name='mass_concentration_of_peroxy_radicals_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The term "peroxy_radicals" means all organic and inorganic peroxy radicals. This includes HO2 and all organic peroxy radicals, sometimes referred to as RO2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_concentration_of_petroleum_hydrocarbons_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". Petroleum hydrocarbons are compounds containing just carbon and hydrogen originating from the fossil fuel crude oil.',
),
CFStandardNameDC(
name='mass_concentration_of_phosphate_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'.",
),
CFStandardNameDC(
name='mass_concentration_of_phytoplankton_expressed_as_chlorophyll_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis. Standard names also exist for the mass concentration of a number of components that make up the total phytoplankton population, such as diatoms, diazotrophs, calcareous phytoplankton, picophytoplankton and miscellaneous phytoplankton. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms.',
),
CFStandardNameDC(
name='mass_concentration_of_picophytoplankton_expressed_as_chlorophyll_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms. Picophytoplankton are phytoplankton of less than 2 micrometers in size. Phytoplankton are algae that grow where there is sufficient light to support photosynthesis.',
),
CFStandardNameDC(
name='mass_concentration_of_pm10_ambient_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. To specify the relative humidity and temperature at which the particle size applies, provide scalar coordinate variables with the standard names of, respectively, "relative_humidity" and "air_temperature."',
),
CFStandardNameDC(
name='mass_concentration_of_pm10_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. The phrase "sea_salt_cation" is the term used in standard names to describe collectively the group of cationic species that occur in sea salt. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Sea salt cations are mainly sodium (Na+), but also include potassium (K+), magnesium (Mg2+), calcium (Ca2+) and rarer cations. Where possible, the data variable should be accompanied by a complete description of the ions represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_concentration_of_pm10_sea_salt_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers.',
),
CFStandardNameDC(
name='mass_concentration_of_pm1_ambient_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm1 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 1 micrometer. To specify the relative humidity and temperature at which the particle size applies, provide scalar coordinate variables with the standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='mass_concentration_of_pm2p5_ambient_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. To specify the relative humidity and temperature at which the particle size applies, provide scalar coordinate variables with the standard names of "relative_humidity" and "air_temperature."',
),
CFStandardNameDC(
name='mass_concentration_of_pm2p5_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. The phrase "sea_salt_cation" is the term used in standard names to describe collectively the group of cationic species that occur in sea salt. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Sea salt cations are mainly sodium (Na+), but also include potassium (K+), magnesium (Mg2+), calcium (Ca2+) and rarer cations. Where possible, the data variable should be accompanied by a complete description of the ions represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_concentration_of_pm2p5_sea_salt_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers.',
),
CFStandardNameDC(
name='mass_concentration_of_primary_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. "Primary particulate organic matter " means all organic matter emitted directly to the atmosphere as particles except elemental carbon. The sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol is particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_concentration_of_propane_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for propane is C3H8. Propane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.",
),
CFStandardNameDC(
name='mass_concentration_of_propene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for propene is C3H6. Propene is a member of the group of hydrocarbons known as alkenes.  There are standard names for the alkene group as well as for some of the individual species.",
),
CFStandardNameDC(
name='mass_concentration_of_radon_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical symbol for radon is Rn.",
),
CFStandardNameDC(
name='mass_concentration_of_rain_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Rain" means drops of water falling through the atmosphere that have a diameter greater than 0.5 mm.',
),
CFStandardNameDC(
name='mass_concentration_of_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The phrase "sea_salt_cation" is the term used in standard names to describe collectively the group of cationic species that occur in sea salt. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Sea salt cations are mainly sodium (Na+), but also include potassium (K+), magnesium (Mg2+), calcium (Ca2+) and rarer cations. Where possible, the data variable should be accompanied by a complete description of the ions represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_concentration_of_sea_salt_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_concentration_of_secondary_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Secondary particulate organic matter" means particulate organic matter formed within the atmosphere from gaseous precursors. The sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol is particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_concentration_of_silicate_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'.",
),
CFStandardNameDC(
name='mass_concentration_of_sulfate_ambient_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip='trsul',
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='mass_concentration_of_sulfate_dry_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for the sulfate anion is SO4(2-).',
),
CFStandardNameDC(
name='mass_concentration_of_sulfur_dioxide_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for sulfur dioxide is SO2.",
),
CFStandardNameDC(
name='mass_concentration_of_suspended_matter_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'.",
),
CFStandardNameDC(
name='mass_concentration_of_terpenes_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. Terpenes are hydrocarbons, that is, they contain only hydrogen and carbon combined in the general proportions (C5H8)n where n is an integer greater than on equal to one. The term "terpenes" is used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.  Standard names exist for some individual terpene species, e.g., isoprene and limonene.',
),
CFStandardNameDC(
name='mass_concentration_of_toluene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for toluene is C6H5CH3. Toluene has the same structure as benzene, except that one of the hydrogen atoms is replaced by a methyl group. The IUPAC name for toluene is methylbenzene.',
),
CFStandardNameDC(
name='mass_concentration_of_volcanic_ash_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. "Volcanic ash" means the fine-grained products of explosive volcanic eruptions, such as minerals or crystals, older fragmented rock (e.g. andesite) and glass. Particles within a volcanic ash cloud have diameters less than 2 mm. "Volcanic ash" does not include non-volcanic dust.',
),
CFStandardNameDC(
name='mass_concentration_of_water_in_ambient_aerosol_particles_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description='Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y. A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles.',
),
CFStandardNameDC(
name='mass_concentration_of_water_vapor_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'.",
),
CFStandardNameDC(
name='mass_concentration_of_xylene_in_air',
canonical_units='kg m-3',
grib=None,
amip=None,
description="Mass concentration means mass per unit volume and is used in the construction mass_concentration_of_X_in_Y, where X is a material constituent of Y.  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for xylene is C6H4C2H6. In chemistry, xylene is a generic term for a group of three isomers of dimethylbenzene. The IUPAC names for the isomers are 1,2-dimethylbenzene, 1,3-dimethylbenzene and 1,4-dimethylbenzene. Xylene is an aromatic hydrocarbon. There are standard names that refer to aromatic_compounds as a group, as well as those for individual species.",
),
CFStandardNameDC(
name='mass_concentration_of_zooplankton_expressed_as_carbon_in_sea_water',
canonical_units='kg m-3',
grib=None,
amip=None,
description='"Mass concentration" means mass per unit volume and is used in the construction "mass_concentration_of_X_in_Y", where X is a material constituent of Y. A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Zooplankton" means the total zooplankton population, with components such as mesozooplankton, microzooplankton and miscellaneous zooplankton.',
),
CFStandardNameDC(
name='mass_content_of_13C_in_vegetation_and_litter_and_soil_and_forestry_and_agricultural_products',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Vegetation" means any living plants e.g. trees, shrubs, grass. "Litter" is dead plant material in or above the soil. The "soil content" of a quantity refers to the vertical integral from the surface down to the bottom of the soil model. Examples of "forestry and agricultural products" are paper, cardboard, furniture, timber for construction, biofuels and food for both humans and livestock. Models that simulate land use changes have one or more pools of carbon that represent these products in order to conserve carbon and allow its eventual release into the atmosphere, for example, when the products decompose in landfill sites. "C" means the element carbon and "13C" is the stable isotope "carbon-13", having six protons and seven neutrons.',
),
CFStandardNameDC(
name='mass_content_of_14C_in_vegetation_and_litter_and_soil_and_forestry_and_agricultural_products',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Vegetation" means any living plants e.g. trees, shrubs, grass. "Litter" is dead plant material in or above the soil. The "soil content" of a quantity refers to the vertical integral from the surface down to the bottom of the soil model. Examples of "forestry and agricultural products" are paper, cardboard, furniture, timber for construction, biofuels and food for both humans and livestock. Models that simulate land use changes have one or more pools of carbon that represent these products in order to conserve carbon and allow its eventual release into the atmosphere, for example, when the products decompose in landfill sites. "C" means the element carbon and "14C" is the radioactive isotope "carbon-14", having six protons and eight neutrons and used in radiocarbon dating.',
),
CFStandardNameDC(
name='mass_content_of_carbon_in_vegetation_and_litter_and_soil_and_forestry_and_agricultural_products',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Vegetation" means any living plants e.g. trees, shrubs, grass. "Litter" is dead plant material in or above the soil. It is distinct from coarse wood debris. The precise distinction between "fine" and "coarse" is model dependent. The "soil content" of a quantity refers to the vertical integral from the surface down to the bottom of the soil model. For the content between specified levels in the soil, standard names including "content_of_soil_layer" are used. Examples of "forestry and agricultural products" are paper, cardboard, furniture, timber for construction, biofuels and food for both humans and livestock. Models that simulate land use changes have one or more pools of carbon that represent these products in order to conserve carbon and allow its eventual release into the atmosphere, for example, when the products decompose in landfill sites.',
),
CFStandardNameDC(
name='mass_content_of_cloud_condensed_water_in_atmosphere_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"condensed_water" means liquid and ice. "Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well.',
),
CFStandardNameDC(
name='mass_content_of_cloud_ice_in_atmosphere_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well.',
),
CFStandardNameDC(
name='mass_content_of_cloud_liquid_water_in_atmosphere_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='The "content_of_X_in_atmosphere_layer" refers to the vertical integral between two specified levels in the atmosphere. "Content" indicates a quantity per unit area. "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well.',
),
CFStandardNameDC(
name='mass_content_of_nitrogen_in_vegetation_and_litter_and_soil_and_forestry_and_agricultural_products',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Vegetation" means any living plants e.g. trees, shrubs, grass. "Litter" is dead plant material in or above the soil. It is distinct from coarse wood debris. The precise distinction between "fine" and "coarse" is model dependent. The "soil content" of a quantity refers to the vertical integral from the surface down to the bottom of the soil model. For the content between specified levels in the soil, standard names including "content_of_soil_layer" are used. Examples of "forestry and agricultural products" are paper, cardboard, furniture, timber for construction, biofuels and food for both humans and livestock. Models that simulate land use changes have one or more pools of carbon that represent these products in order to conserve carbon and allow its eventual release into the atmosphere, for example, when the products decompose in landfill sites.',
),
CFStandardNameDC(
name='mass_content_of_water_in_atmosphere_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. "Water" means water in all phases.',
),
CFStandardNameDC(
name='mass_content_of_water_in_soil',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Water" means water in all phases. "Content" indicates a quantity per unit area. The mass content of water in soil refers to the vertical integral from the surface down to the bottom of the soil model. For the content between specified levels in the soil, standard names including "content_of_soil_layer" are used.',
),
CFStandardNameDC(
name='mass_content_of_water_in_soil_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Water" means water in all phases. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be "model_level_number", but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. Quantities defined for a soil layer must have a vertical coordinate variable with boundaries indicating the extent of the layer(s).',
),
CFStandardNameDC(
name='mass_content_of_water_in_soil_layer_defined_by_root_depth',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The content of a soil layer is the vertical integral of the specified quantity within the layer. The quantity with standard name mass_content_of_water_in_soil_layer_defined_by_root_depth is the vertical integral between the surface and the depth to which plant roots penetrate. A coordinate variable or scalar coordinate variable with standard name root_depth can be used to specify the extent of the layer. "Water" means water in all phases.',
),
CFStandardNameDC(
name='mass_content_of_water_vapor_containing_17O_in_atmosphere_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be "model_level_number", but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. The "content_of_X_in_atmosphere_layer" refers to the vertical integral between two specified levels in the atmosphere. The chemical formula for water is H2O. "O" means the element "oxygen" and "17O" is the stable isotope "oxygen-17".',
),
CFStandardNameDC(
name='mass_content_of_water_vapor_containing_18O_in_atmosphere_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be "model_level_number", but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. The "content_of_X_in_atmosphere_layer" refers to the vertical integral between two specified levels in the atmosphere. The chemical formula for water is H2O. "O" means the element "oxygen" and "18O" is the stable isotope "oxygen-18".',
),
CFStandardNameDC(
name='mass_content_of_water_vapor_containing_single_2H_in_atmosphere_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be "model_level_number", but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well. The "content_of_X_in_atmosphere_layer" refers to the vertical integral between two specified levels in the atmosphere. The chemical formula for water is H2O. "H" means the element "hydrogen" and "2H" is the stable isotope "hydrogen-2", usually called "deuterium". The construction "X_containing_single_Y" means the standard name refers to only that part of X composed of molecules containing a single atom of isotope Y.',
),
CFStandardNameDC(
name='mass_content_of_water_vapor_in_atmosphere_layer',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. "Layer" means any layer with upper and lower boundaries that have constant values in some vertical coordinate. There must be a vertical coordinate variable indicating the extent of the layer(s). If the layers are model layers, the vertical coordinate can be model_level_number, but it is recommended to specify a physical coordinate (in a scalar or auxiliary coordinate variable) as well.',
),
CFStandardNameDC(
name='mass_flux_of_carbon_into_forestry_and_agricultural_products_due_to_crop_harvesting',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. Examples of "forestry and agricultural products" are paper, cardboard, furniture, timber for construction, biofuels and food for both humans and livestock. Models that simulate land use changes have one or more pools of carbon that represent these products in order to conserve carbon and allow its eventual release into the atmosphere, for example, when the products decompose in landfill sites. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. The definition of "crop" is model dependent, for example, some models may include fruit trees, trees grown for timber or other types of agricultural and forestry planting as crops. Crop harvesting means the human activity of collecting plant materials for the purpose of turning them into forestry or agricultural products.',
),
CFStandardNameDC(
name='mass_flux_of_carbon_into_litter_from_vegetation',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Vegetation" means any living plants e.g. trees, shrubs, grass. "Litter" is dead plant material in or above the soil. It is distinct from coarse wood debris. The precise distinction between "fine" and "coarse" is model dependent. The sum of the quantities with standard names mass_flux_of_carbon_into_litter_from_vegetation_due_to_mortality and mass_flux_of_carbon_into_litter_from_vegetation_due_to_senescence is mass_flux_of_carbon_into_litter_from_vegetation.',
),
CFStandardNameDC(
name='mass_flux_of_carbon_into_litter_from_vegetation_due_to_mortality',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Vegetation" means any living plants e.g. trees, shrubs, grass. "Litter" is dead plant material in or above the soil. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. The term "mortality" means the loss of living biomass due to plant death. It refers to the death of the whole plant, not only the leaves.',
),
CFStandardNameDC(
name='mass_flux_of_carbon_into_litter_from_vegetation_due_to_senescence',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Vegetation" means any living plants e.g. trees, shrubs, grass.  "Litter" is dead plant material in or above the soil. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. The term "senescence" means loss of living biomass excluding plant death, e.g. leaf drop and other seasonal effects. The term refers to changes in the whole plant and is not confined only to leaf drop.',
),
CFStandardNameDC(
name='mass_flux_of_carbon_into_sea_water_from_rivers',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "River" refers to water in the fluvial system (stream and floodplain).',
),
CFStandardNameDC(
name='mass_flux_of_carbon_into_soil_from_vegetation_due_to_mortality',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Vegetation" means any living plants e.g. trees, shrubs, grass. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. The term "mortality" means the loss of living biomass due to plant death. It refers to the death of the whole plant, not only the leaves.',
),
CFStandardNameDC(
name='mass_flux_of_carbon_into_soil_from_vegetation_due_to_senescence',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "Vegetation" means any living plants e.g. trees, shrubs, grass. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. The term "senescence" means loss of living biomass excluding plant death, e.g. leaf drop and other seasonal effects. The term refers to changes in the whole plant and is not confined only to leaf drop.',
),
CFStandardNameDC(
name='mass_flux_of_carbon_out_of_soil_due_to_leaching_and_runoff',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Leaching" means the loss of water soluble chemical species from soil. Runoff is the liquid water which drains from land. If not specified, "runoff" refers to the sum of surface runoff and subsurface drainage.',
),
CFStandardNameDC(
name='mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_into_sea_from_rivers',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Nitrogen compounds" summarizes all chemical species containing nitrogen atoms. The list of individual species that are included in this quantity can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "River" refers to water in the fluvial system (stream and floodplain).',
),
CFStandardNameDC(
name='mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_out_of_litter_and_soil_due_to_immobilisation_and_remineralization',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Nitrogen compounds" summarizes all chemical species containing nitrogen atoms. "Litter" is dead plant material in or above the soil. It is distinct from coarse wood debris. The precise distinction between "fine" and "coarse" is model dependent. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. Remineralization is the degradation of organic matter into inorganic forms of carbon, nitrogen, phosphorus and other micronutrients, which consumes oxygen and releases energy. Immobilisation of nitrogen refers to retention of nitrogen by micro-organisms under certain conditions, making it unavailable for plants.',
),
CFStandardNameDC(
name='mass_flux_of_nitrogen_compounds_expressed_as_nitrogen_out_of_vegetation_and_litter_and_soil_due_to_leaching_and_runoff',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Nitrogen compounds" summarizes all chemical species containing nitrogen atoms. "Vegetation" means any living plants e.g. trees, shrubs, grass. The term "plants" refers to the kingdom of plants in the modern classification which excludes fungi. Plants are autotrophs i.e. "producers" of biomass using carbon obtained from carbon dioxide. "Litter" is dead plant material in or above the soil. It is distinct from coarse wood debris. The precise distinction between "fine" and "coarse" is model dependent. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Leaching" means the loss of water soluble chemical species from soil. Runoff is the liquid water which drains from land. If not specified, "runoff" refers to the sum of surface runoff and subsurface drainage.',
),
CFStandardNameDC(
name='mass_fraction_of_acetic_acid_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for acetic_acid is CH3COOH. The IUPAC name for acetic acid is ethanoic acid.",
),
CFStandardNameDC(
name='mass_fraction_of_aceto_nitrile_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for aceto-nitrile is CH3CN. The IUPAC name for aceto-nitrile is ethanenitrile.",
),
CFStandardNameDC(
name='mass_fraction_of_alkanes_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. Alkanes are saturated hydrocarbons, i.e. they do not contain any chemical double bonds.  Alkanes contain only hydrogen and carbon combined in the general proportions C(n)H(2n+2); "alkanes" is the term used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names exist for some individual alkane species, e.g., methane and ethane.',
),
CFStandardNameDC(
name='mass_fraction_of_alkenes_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. Alkenes are unsaturated hydrocarbons as they contain chemical double bonds between adjacent carbon atoms.  Alkenes contain only hydrogen and carbon combined in the general proportions C(n)H(2n); "alkenes" is the term used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names exist for some individual alkene species, e.g., ethene and propene.',
),
CFStandardNameDC(
name='mass_fraction_of_alpha_hexachlorocyclohexane_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for alpha_hexachlorocyclohexane is C6H6Cl6.",
),
CFStandardNameDC(
name='mass_fraction_of_alpha_pinene_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for alpha_pinene is C10H16. The IUPAC name for alpha-pinene is (1S,5S)-2,6,6-trimethylbicyclo[3.1.1]hept-2-ene.",
),
CFStandardNameDC(
name='mass_fraction_of_ammonia_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for ammonia is NH3.",
),
CFStandardNameDC(
name='mass_fraction_of_ammonium_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  "Mass_fraction_of_ammonium" means that the mass is expressed as mass of NH4. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_fraction_of_anthropogenic_nmvoc_expressed_as_carbon_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Anthropogenic" means influenced, caused, or created by human activity.',
),
CFStandardNameDC(
name='mass_fraction_of_aromatic_compounds_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as \'nitrogen\' or a phrase such as \'nox_expressed_as_nitrogen\'. Aromatic compounds in organic chemistry are compounds that contain at least one benzene ring of six carbon atoms joined by alternating single and double covalent bonds.  The simplest aromatic compound is benzene itself.  In standard names "aromatic_compounds" is the term used to describe the group of aromatic chemical species that  are represented within a given model.  The list of individual species that are included in a quantity having a group chemical standard name can vary between models.  Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.  Standard names exist for some individual aromatic species, e.g. benzene and xylene.',
),
CFStandardNameDC(
name='mass_fraction_of_atomic_bromine_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical symbol for atomic bromine is Br.",
),
CFStandardNameDC(
name='mass_fraction_of_atomic_chlorine_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical symbol for atomic chlorine is Cl.",
),
CFStandardNameDC(
name='mass_fraction_of_atomic_nitrogen_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical symbol for atomic nitrogen is N.",
),
CFStandardNameDC(
name='mass_fraction_of_benzene_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for benzene is C6H6.  Benzene is the simplest aromatic hydrocarbon and has a ring structure consisting of six carbon atoms joined by alternating single and double chemical bonds. Each carbon atom is additionally bonded to one hydrogen atom. There are standard names that refer to aromatic_compounds as a group, as well as those for individual species.",
),
CFStandardNameDC(
name='mass_fraction_of_beta_pinene_in_air',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. The chemical formula for beta_pinene is C10H16.  The IUPAC name for beta-pinene is (1S,5S)-6,6-dimethyl-2-methylenebicyclo[3.1.1]heptane.",
),
CFStandardNameDC(
name='mass_fraction_of_biogenic_nmvoc_expressed_as_carbon_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Biogenic" means influenced, caused, or created by natural processes.',
),
CFStandardNameDC(
name='mass_fraction_of_bromine_chloride_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for bromine chloride is BrCl.',
),
CFStandardNameDC(
name='mass_fraction_of_bromine_monoxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for bromine monoxide is BrO.',
),
CFStandardNameDC(
name='mass_fraction_of_bromine_nitrate_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for bromine nitrate is BrONO2.',
),
CFStandardNameDC(
name='mass_fraction_of_brox_expressed_as_bromine_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Brox" describes a family of chemical species consisting of inorganic bromine compounds with the exception of hydrogen bromide (HBr) and bromine nitrate (BrONO2). "Brox" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity with a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Inorganic bromine", sometimes referred to as Bry, describes a family of chemical species which result from the degradation of source gases containing bromine (halons, methyl bromide, VSLS) and natural inorganic bromine sources such as volcanoes, sea salt and other aerosols. Standard names that use the term "inorganic_bromine" are used for quantities that contain all inorganic bromine species including HBr and BrONO2.',
),
CFStandardNameDC(
name='mass_fraction_of_butane_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for butane is C4H10. Butane is a member of the group of hydrocarbons known as alkanes.  There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_fraction_of_carbon_dioxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for carbon dioxide is CO2.',
),
CFStandardNameDC(
name='mass_fraction_of_carbon_dioxide_tracer_in_air',
canonical_units='1',
grib=None,
amip=None,
description='The chemical formula for carbon dioxide is CO2. Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". A "tracer" is a quantity advected by a model to facilitate analysis of flow patterns.',
),
CFStandardNameDC(
name='mass_fraction_of_carbon_monoxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of carbon monoxide is CO.',
),
CFStandardNameDC(
name='mass_fraction_of_carbon_tetrachloride_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of carbon tetrachloride is CCl4. The IUPAC name for carbon tetrachloride is tetrachloromethane.',
),
CFStandardNameDC(
name='mass_fraction_of_cfc113a_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC113a is CCl3CF3. The IUPAC name for CFC113a is 1,1,1-trichloro-2,2,2-trifluoroethane.',
),
CFStandardNameDC(
name='mass_fraction_of_cfc113_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC113 is CCl2FCClF2. The IUPAC name for CFC113 is 1,1,2-trichloro-1,2,2-trifluoroethane.',
),
CFStandardNameDC(
name='mass_fraction_of_cfc114_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC114 is CClF2CClF2. The IUPAC name for CFC114 is 1,2-dichloro-1,1,2,2-tetrafluoroethane.',
),
CFStandardNameDC(
name='mass_fraction_of_cfc115_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC115 is CClF2CF3. The IUPAC name for CFC115 is 1-chloro-1,1,2,2,2-pentafluoroethane.',
),
CFStandardNameDC(
name='mass_fraction_of_cfc11_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula of CFC11 is CFCl3. The IUPAC name for CFC11 is trichloro(fluoro)methane.',
),
CFStandardNameDC(
name='mass_fraction_of_cfc12_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for CFC12 is CF2Cl2. The IUPAC name for CFC12 is dichloro(difluoro)methane.',
),
CFStandardNameDC(
name='mass_fraction_of_chlorine_dioxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for chlorine dioxide is OClO.',
),
CFStandardNameDC(
name='mass_fraction_of_chlorine_monoxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for chlorine monoxide is ClO.',
),
CFStandardNameDC(
name='mass_fraction_of_chlorine_nitrate_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for chlorine nitrate is ClONO2.',
),
CFStandardNameDC(
name='mass_fraction_of_chlorophyll_a_in_sea_water',
canonical_units='1',
grib=None,
amip=None,
description="Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as 'nitrogen' or a phrase such as 'nox_expressed_as_nitrogen'. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally; all contain a chlorin ring which gives the green pigment and a side chain whose structure varies. Chlorophyll-a is the most commonly occurring form of natural chlorophyll.",
),
CFStandardNameDC(
name='mass_fraction_of_cloud_condensed_water_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"condensed_water" means liquid and ice. Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_cloud_ice_in_air',
canonical_units='1',
grib=None,
amip='cli',
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_cloud_liquid_water_in_air',
canonical_units='1',
grib=None,
amip='clw',
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='mass_fraction_of_clox_expressed_as_chlorine_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Clox" describes a family of chemical species consisting of inorganic chlorine compounds with the exception of hydrogen chloride (HCl) and chlorine nitrate (ClONO2). "Clox" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity with a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. "Inorganic chlorine", sometimes referred to as Cly, describes a family of chemical species which result from the degradation of source gases containing chlorine (CFCs, HCFCs, VSLS) and natural inorganic chlorine sources such as sea salt and other aerosols. Standard names that use the term "inorganic_chlorine" are used for quantities that contain all inorganic chlorine species including HCl and ClONO2.',
),
CFStandardNameDC(
name='mass_fraction_of_convective_cloud_condensed_water_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"condensed_water" means liquid and ice. Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_convective_cloud_ice_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). Convective cloud is that produced by the convection schemes in an atmosphere model.',
),
CFStandardNameDC(
name='mass_fraction_of_convective_cloud_liquid_water_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". Convective cloud is that produced by the convection schemes in an atmosphere model. "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='mass_fraction_of_dichlorine_peroxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for dichlorine peroxide is Cl2O2.',
),
CFStandardNameDC(
name='mass_fraction_of_dimethyl_sulfide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_dinitrogen_pentoxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for dinitrogen pentoxide is N2O5.',
),
CFStandardNameDC(
name='mass_fraction_of_dust_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_fraction_of_elemental_carbon_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. Chemically, "elemental carbon" is the carbonaceous fraction of particulate matter that is thermally stable in an inert atmosphere to high temperatures near 4000K and can only be gasified by oxidation starting at temperatures above 340 C. It is assumed to be inert and non-volatile under atmospheric conditions and insoluble in any solvent (Ogren and Charlson, 1983).',
),
CFStandardNameDC(
name='mass_fraction_of_ethane_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for ethane is C2H6. Ethane is a member of the group of hydrocarbons known as alkanes. There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_fraction_of_ethanol_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for ethanol is C2H5OH.',
),
CFStandardNameDC(
name='mass_fraction_of_ethene_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for ethene is C2H4. Ethene is a member of the group of hydrocarbons known as alkenes. There are standard names for the alkene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_fraction_of_ethyne_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for ethyne is HC2H. Ethyne is the IUPAC name for this species, which is also commonly known as acetylene.',
),
CFStandardNameDC(
name='mass_fraction_of_formaldehyde_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for formaldehyde is CH2O.',
),
CFStandardNameDC(
name='mass_fraction_of_formic_acid_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for formic acid is HCOOH. The IUPAC name for formic acid is methanoic acid.',
),
CFStandardNameDC(
name='mass_fraction_of_frozen_water_in_soil_moisture',
canonical_units='1',
grib=None,
amip=None,
description='"frozen_water" means ice. "moisture" means water in all phases contained in soil. Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_gaseous_divalent_mercury_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Divalent mercury" means all compounds in which the mercury has two binding sites to other ion(s) in a salt or to other atom(s) in a molecule.',
),
CFStandardNameDC(
name='mass_fraction_of_gaseous_elemental_mercury_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical symbol for mercury is Hg.',
),
CFStandardNameDC(
name='mass_fraction_of_graupel_and_hail_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). Graupel consists of heavily rimed snow particles, often called snow pellets; often indistinguishable from very small soft hail except when the size convention that hail must have a diameter greater than 5 mm is adopted. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Graupel. Hail is precipitation in the form of balls or irregular lumps of ice, often restricted by a size convention to diameters of 5 mm or more. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Hail. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel. For models that do distinguish between them, separate standard names for hail and graupel are available.',
),
CFStandardNameDC(
name='mass_fraction_of_graupel_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). Graupel consists of heavily rimed snow particles, often called snow pellets; often indistinguishable from very small soft hail except when the size convention that hail must have a diameter greater than 5 mm is adopted. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Graupel. There are also separate standard names for hail. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel.',
),
CFStandardNameDC(
name='mass_fraction_of_hail_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). Hail is precipitation in the form of balls or irregular lumps of ice, often restricted by a size convention to diameters of 5 mm or more. Reference: American Meteorological Society Glossary http://glossary.ametsoc.org/wiki/Hail. For diameters of less than 5 mm standard names for "graupel" should be used. Standard names for "graupel_and_hail" should be used to describe data produced by models that do not distinguish between hail and graupel.',
),
CFStandardNameDC(
name='mass_fraction_of_halon1202_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for Halon1202 is CBr2F2. The IUPAC name for Halon1202 is dibromo(difluoro)methane.',
),
CFStandardNameDC(
name='mass_fraction_of_halon1211_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for Halon1211 is CBrClF2. The IUPAC name for Halon1211 is bromo-chloro-difluoromethane.',
),
CFStandardNameDC(
name='mass_fraction_of_halon1301_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for Halon1301 is CBrF3. The IUPAC name for Halon1301 is bromo(trifluoro)methane.',
),
CFStandardNameDC(
name='mass_fraction_of_halon2402_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for Halon2402 is C2Br2F4. The IUPAC name for Halon2402 is 1,2-dibromo-1,1,2,2-tetrafluoroethane.',
),
CFStandardNameDC(
name='mass_fraction_of_hcc140a_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for HCC140a, also called methyl chloroform, is CH3CCl3. The IUPAC name for HCC140a is 1,1,1-trichloroethane.',
),
CFStandardNameDC(
name='mass_fraction_of_hcfc141b_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for HCFC141b is CH3CCl2F. The IUPAC name for HCFC141b is 1,1-dichloro-1-fluoroethane.',
),
CFStandardNameDC(
name='mass_fraction_of_hcfc142b_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for HCFC142b is CH3CClF2. The IUPAC name for HCFC142b is 1-chloro-1,1-difluoroethane.',
),
CFStandardNameDC(
name='mass_fraction_of_hcfc22_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for HCFC22 is CHClF2. The IUPAC name for HCFC22 is chloro(difluoro)methane.',
),
CFStandardNameDC(
name='mass_fraction_of_hexachlorobiphenyl_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for hexachlorobiphenyl is C12H4Cl6. The structure of this species consists of two linked benzene rings, each of which is additionally bonded to three chlorine atoms.',
),
CFStandardNameDC(
name='mass_fraction_of_hox_expressed_as_hydrogen_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "HOx" means a combination of two radical species containing hydrogen and oxygen, OH and HO2.',
),
CFStandardNameDC(
name='mass_fraction_of_hydrogen_bromide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for hydrogen bromide is HBr.',
),
CFStandardNameDC(
name='mass_fraction_of_hydrogen_chloride_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for hydrogen chloride is HCl.',
),
CFStandardNameDC(
name='mass_fraction_of_hydrogen_cyanide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for hydrogen cyanide is HCN.',
),
CFStandardNameDC(
name='mass_fraction_of_hydrogen_peroxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for hydrogen peroxide is H2O2.',
),
CFStandardNameDC(
name='mass_fraction_of_hydroperoxyl_radical_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for the hydroperoxyl radical is HO2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_fraction_of_hydroxyl_radical_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for the hydroxyl radical is OH. In chemistry, a "radical" is a highly reactive, and therefore short lived,species.',
),
CFStandardNameDC(
name='mass_fraction_of_hypobromous_acid_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for hypobromous acid is HOBr.',
),
CFStandardNameDC(
name='mass_fraction_of_hypochlorous_acid_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for hypochlorous acid is HOCl.',
),
CFStandardNameDC(
name='mass_fraction_of_inorganic_bromine_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Inorganic bromine", sometimes referred to as Bry, describes a family of chemical species which result from the degradation of source gases containing bromine (halons, methyl bromide, VSLS) and natural inorganic bromine sources such as volcanoes, sea salt and other aerosols. "Inorganic bromine" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names that use the term "brox" are used for quantities that contain all inorganic bromine species except HBr and BrONO2.',
),
CFStandardNameDC(
name='mass_fraction_of_inorganic_chlorine_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Inorganic chlorine", sometimes referred to as Cly, describes a family of chemical species which result from the degradation of source gases containing chlorine (CFCs, HCFCs, VSLS) and natural inorganic chlorine sources such as sea salt and other aerosols. "Inorganic chlorine" is the term used in standard names for all species belonging to the family that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names that use the term "clox" are used for quantities that contain all inorganic chlorine species except HCl and ClONO2.',
),
CFStandardNameDC(
name='mass_fraction_of_isoprene_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for isoprene is CH2=C(CH3)CH=CH2. The IUPAC name for isoprene is 2-methylbuta-1,3-diene. Isoprene is a member of the group of hydrocarbons known as terpenes. There are standard names for the terpene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_fraction_of_limonene_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for limonene is C10H16. The IUPAC name for limonene is 1-methyl-4-prop-1-en-2-ylcyclohexene. Limonene is a member of the group of hydrocarbons known as terpenes. There are standard names for the terpene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_fraction_of_liquid_precipitation_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Liquid_precipitation" includes both "rain" and "drizzle". "Rain" means drops of water falling through the atmosphere that have a diameter greater than 0.5 mm. "Drizzle" means drops of water falling through the atmosphere that have a diameter typically in the range 0.2-0.5 mm.',
),
CFStandardNameDC(
name='mass_fraction_of_mercury_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_fraction_of_methane_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for methane is CH4. Methane is a member of the group of hydrocarbons known as alkanes. There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_fraction_of_methanesulfonic_acid_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for methanesulfonic acid is CH3SO3H.',
),
CFStandardNameDC(
name='mass_fraction_of_methanol_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for ethanol is C2H5OH. The chemical formula for methanol is CH3OH.',
),
CFStandardNameDC(
name='mass_fraction_of_methyl_bromide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for methyl bromide is CH3Br. The IUPAC name for methyl bromide is bromomethane.',
),
CFStandardNameDC(
name='mass_fraction_of_methyl_chloride_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for methyl chloride is CH3Cl. The IUPAC name for methyl chloride is chloromethane.',
),
CFStandardNameDC(
name='mass_fraction_of_methyl_hydroperoxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for methyl hydroperoxide is CH3OOH.',
),
CFStandardNameDC(
name='mass_fraction_of_methyl_peroxy_radical_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for methyl_peroxy_radical is CH3O2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_fraction_of_molecular_hydrogen_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for molecular hydrogen is H2.',
),
CFStandardNameDC(
name='mass_fraction_of_nitrate_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Mass_fraction_of_nitrate" means that the mass is expressed as mass of NO3. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_fraction_of_nitrate_radical_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_fraction_of_nitric_acid_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for nitric acid is HNO3.',
),
CFStandardNameDC(
name='mass_fraction_of_nitric_acid_trihydrate_ambient_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. The chemical formula for nitric acid is HNO3. Nitric acid trihydrate, sometimes referred to as NAT, is a stable crystalline substance consisting of three molecules of water to one molecule of nitric acid.',
),
CFStandardNameDC(
name='mass_fraction_of_nitrogen_dioxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for nitrogen dioxide is NO2.',
),
CFStandardNameDC(
name='mass_fraction_of_nitrogen_monoxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for nitrogen monoxide is NO.',
),
CFStandardNameDC(
name='mass_fraction_of_nitrous_acid_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for nitrous acid is HNO2.',
),
CFStandardNameDC(
name='mass_fraction_of_nitrous_oxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for nitrous oxide is N2O.',
),
CFStandardNameDC(
name='mass_fraction_of_nmvoc_expressed_as_carbon_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "nmvoc" means non methane volatile organic compounds; "nmvoc" is the term used in standard names to describe the group of chemical species having this classification that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_fraction_of_nox_expressed_as_nitrogen_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The term "peroxy_radicals" means all organic and inorganic peroxy radicals. This includes HO2 and all organic peroxy radicals, sometimes referred to as RO2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_fraction_of_noy_expressed_as_nitrogen_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Noy" describes a family of chemical species. The family usually includes atomic nitrogen (N), nitrogen monoxide (NO), nitrogen dioxide (NO2), dinitrogen pentoxide (N2O5), nitric acid (HNO3), peroxynitric acid (HNO4), bromine nitrate (BrONO2) , chlorine nitrate (ClONO2) and organic nitrates (most notably peroxyacetyl nitrate, sometimes referred to as PAN, (CH3COO2NO2)). The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_fraction_of_oxygenated_hydrocarbons_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Oxygenated" means containing oxygen. "Hydrocarbon" means a compound containing hydrogen and carbon.',
),
CFStandardNameDC(
name='mass_fraction_of_ozone_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The term "particulate_organic_matter_dry_aerosol" means all particulate organic matter dry aerosol except elemental carbon. It is the sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. "particulate_organic_matter_dry_aerosol" means all particulate organic matter dry aerosol except elemental carbon.  It is the sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_peroxyacetyl_nitrate_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for peroxyacetyl nitrate, sometimes referred to as PAN, is CH3COO2NO2. The IUPAC name for peroxyacetyl nitrate is nitroethaneperoxoate.',
),
CFStandardNameDC(
name='mass_fraction_of_peroxynitric_acid_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for peroxynitric acid, sometimes referred to as PNA, is HO2NO2.',
),
CFStandardNameDC(
name='mass_fraction_of_peroxy_radicals_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The term "peroxy_radicals" means all organic and inorganic peroxy radicals. This includes HO2 and all organic peroxy radicals, sometimes referred to as RO2. In chemistry, a "radical" is a highly reactive, and therefore short lived, species.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_ambient_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. To specify the relative humidity and temperature at which the particle size applies, provide scalar coordinate variables with the standard names of "relative_humidity" and "air_temperature."',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_ammonium_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. The chemical formula for ammonium is NH4.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_dust_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_elemental_carbon_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. Chemically, "elemental carbon" is the carbonaceous fraction of particulate matter that is thermally stable in an inert atmosphere to high temperatures near 4000K and can only be gasified by oxidation starting at temperatures above 340 C. It is assumed to be inert and non-volatile under atmospheric conditions and insoluble in any solvent (Ogren and Charlson, 1983).',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_nitrate_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. The chemical formula for the nitrate anion is NO3-.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. The term "particulate_organic_matter_dry_aerosol" means all particulate organic matter dry aerosol except elemental carbon. It is the sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. The term "particulate_organic_matter_dry_aerosol" means all particulate organic matter dry aerosol except elemental carbon. It is the sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_primary_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. "Primary particulate organic matter" means all organic matter emitted directly to the atmosphere as particles except elemental carbon. The sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol is particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. The phrase "sea_salt_cation" is the term used in standard names to describe collectively the group of cationic species that occur in sea salt. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Sea salt cations are mainly sodium (Na+), but also include potassium (K+), magnesium (Mg2+), calcium (Ca2+) and rarer cations. Where possible, the data variable should be accompanied by a complete description of the ions represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_sea_salt_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers.',
),
CFStandardNameDC(
name='mass_fraction_of_pm10_sulfate_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. The chemical formula for the sulfate anion is SO4(2-).',
),
CFStandardNameDC(
name='mass_fraction_of_pm1_ambient_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm1 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 1 micrometer. To specify the relative humidity and temperature at which the particle size applies, provide scalar coordinate variables with the standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='mass_fraction_of_pm1_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm1 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 1 micrometer.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_ambient_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. To specify the relative humidity and temperature at which the particle size applies, provide scalar coordinate variables with the standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_ammonium_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. The chemical formula for ammonium is NH4.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_dust_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_elemental_carbon_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. Chemically, "elemental carbon" is the carbonaceous fraction of particulate matter that is thermally stable in an inert atmosphere to high temperatures near 4000K and can only be gasified by oxidation starting at temperatures above 340 C. It is assumed to be inert and non-volatile under atmospheric conditions and insoluble in any solvent (Ogren and Charlson, 1983).',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_nitrate_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. The chemical formula for the nitrate anion is NO3-.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_particulate_organic_matter_dry_aerosol_particles_expressed_as_carbon_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. The term "particulate_organic_matter_dry_aerosol" means all particulate organic matter dry aerosol except elemental carbon. It is the sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. The term "particulate_organic_matter_dry_aerosol" means all particulate organic matter dry aerosol except elemental carbon. It is the sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_primary_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. "Primary particulate organic matter" means all organic matter emitted directly to the atmosphere as particles except elemental carbon. The sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol is particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. The phrase "sea_salt_cation" is the term used in standard names to describe collectively the group of cationic species that occur in sea salt. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Sea salt cations are mainly sodium (Na+), but also include potassium (K+), magnesium (Mg2+), calcium (Ca2+) and rarer cations. Where possible, the data variable should be accompanied by a complete description of the ions represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_sea_salt_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers.',
),
CFStandardNameDC(
name='mass_fraction_of_pm2p5_sulfate_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. The chemical formula for the sulfate anion is SO4(2-).',
),
CFStandardNameDC(
name='mass_fraction_of_precipitation_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Precipitation" in the earth\'s atmosphere means precipitation of water in all phases.',
),
CFStandardNameDC(
name='mass_fraction_of_primary_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol takes up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the aerosol. "Dry aerosol particles" means aerosol particles without any water uptake. "Primary particulate organic matter " means all organic matter emitted directly to the atmosphere as particles except elemental carbon. The sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol is particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_propane_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for propane is C3H8. Propane is a member of the group of hydrocarbons known as alkanes. There are standard names for the alkane group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_fraction_of_propene_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for propene is C3H6. Propene is a member of the group of hydrocarbons known as alkenes. There are standard names for the alkene group as well as for some of the individual species.',
),
CFStandardNameDC(
name='mass_fraction_of_radon_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical symbol for radon is Rn.',
),
CFStandardNameDC(
name='mass_fraction_of_rainfall_falling_onto_surface_snow',
canonical_units='1',
grib=None,
amip=None,
description='The quantity with standard name mass_fraction_of_rainfall_falling_onto_surface_snow is the mass of rainfall falling onto snow as a fraction of the mass of rainfall falling within the area of interest. Surface snow refers to the snow on the solid ground or on surface ice cover, but excludes, for example, falling snowflakes and snow on plants. The surface called "surface" means the lower boundary of the atmosphere. Unless indicated in the cell_methods attribute, a quantity is assumed to apply to the whole area of each horizontal grid box.',
),
CFStandardNameDC(
name='mass_fraction_of_sea_salt_dry_aerosol_particles_expressed_as_cations_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The phrase "sea_salt_cation" is the term used in standard names to describe collectively the group of cationic species that occur in sea salt. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Sea salt cations are mainly sodium (Na+), but also include potassium (K+), magnesium (Mg2+), calcium (Ca2+) and rarer cations. Where possible, the data variable should be accompanied by a complete description of the ions represented, for example, by using a comment attribute.',
),
CFStandardNameDC(
name='mass_fraction_of_sea_salt_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_fraction_of_secondary_particulate_organic_matter_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. "Secondary particulate organic matter" means particulate organic matter formed within the atmosphere from gaseous precursors. The sum of primary_particulate_organic_matter_dry_aerosol and secondary_particulate_organic_matter_dry_aerosol is particulate_organic_matter_dry_aerosol.',
),
CFStandardNameDC(
name='mass_fraction_of_snow_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Snow" refers to the precipitating part of snow in the atmosphere – the cloud snow content is excluded.',
),
CFStandardNameDC(
name='mass_fraction_of_solid_precipitation_falling_onto_surface_snow',
canonical_units='1',
grib=None,
amip=None,
description='The quantity with standard name mass_fraction_of_solid_precipitation_falling_onto_surface_snow is the mass of solid precipitation falling onto snow as a fraction of the mass of solid precipitation falling within the area of interest. Solid precipitation refers to the precipitation of water in the solid phase. Water in the atmosphere exists in one of three phases: solid, liquid or vapor. The solid phase can exist as snow, hail, graupel, cloud ice, or as a component of aerosol. Surface snow refers to the snow on the solid ground or on surface ice cover, but excludes, for example, falling snowflakes and snow on plants. Unless indicated in the cell_methods attribute, a quantity is assumed to apply to the whole area of each horizontal grid box.',
),
CFStandardNameDC(
name='mass_fraction_of_stratiform_cloud_ice_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes).',
),
CFStandardNameDC(
name='mass_fraction_of_stratiform_cloud_liquid_water_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species or biological group denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". In an atmosphere model, stratiform cloud is that produced by large-scale convergence (not the convection schemes). "Cloud liquid water" refers to the liquid phase of cloud water. A diameter of 0.2 mm has been suggested as an upper limit to the size of drops that shall be regarded as cloud drops; larger drops fall rapidly enough so that only very strong updrafts can sustain them. Any such division is somewhat arbitrary, and active cumulus clouds sometimes contain cloud drops much larger than this. Reference: AMS Glossary http://glossary.ametsoc.org/wiki/Cloud_drop.',
),
CFStandardNameDC(
name='mass_fraction_of_sulfate_dry_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).  "Mass_fraction_of_sulfate" means that the mass is expressed as mass of SO4. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake.',
),
CFStandardNameDC(
name='mass_fraction_of_sulfur_dioxide_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_sulfuric_acid_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for sulfuric acid is H2SO4.',
),
CFStandardNameDC(
name='mass_fraction_of_terpenes_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". Terpenes are hydrocarbons, that is,they contain only hydrogen and carbon combined in the general proportions (C5H8)n where n is an integer greater than or equal to one. The term "terpenes" is used in standard names to describe the group of chemical species having this common structure that are represented within a given model. The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. Standard names exist for some individual terpene species, e.g., isoprene and limonene.',
),
CFStandardNameDC(
name='mass_fraction_of_toluene_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for toluene is C6H5CH3. Toluene has the same structure as benzene, except that one of the hydrogen atoms is replaced by a methyl group. The IUPAC name for toluene is methylbenzene.',
),
CFStandardNameDC(
name='mass_fraction_of_unfrozen_water_in_soil_moisture',
canonical_units='1',
grib=None,
amip=None,
description='"moisture" means water in all phases contained in soil. "unfrozen_water" means liquid and vapour. Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_water_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Water" means water in all phases. Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X).',
),
CFStandardNameDC(
name='mass_fraction_of_water_in_ambient_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction mass_fraction_of_X_in_Y, where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles.',
),
CFStandardNameDC(
name='mass_fraction_of_water_in_pm10_ambient_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm10 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 10 micrometers. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='mass_fraction_of_water_in_pm2p5_ambient_aerosol_particles_in_air',
canonical_units='1',
grib=None,
amip=None,
description='Mass fraction is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. "Ambient_aerosol" means that the aerosol is measured or modelled at the ambient state of pressure, temperature and relative humidity that exists in its immediate environment. "Ambient aerosol particles" are aerosol particles that have taken up ambient water through hygroscopic growth. The extent of hygroscopic growth depends on the relative humidity and the composition of the particles. "Pm2p5 aerosol" means atmospheric particulate compounds with an aerodynamic diameter of less than or equal to 2.5 micrometers. To specify the relative humidity and temperature at which the quantity described by the standard name applies, provide scalar coordinate variables with standard names of "relative_humidity" and "air_temperature".',
),
CFStandardNameDC(
name='mass_fraction_of_xylene_in_air',
canonical_units='1',
grib=None,
amip=None,
description='"Mass fraction" is used in the construction "mass_fraction_of_X_in_Y", where X is a material constituent of Y. It means the ratio of the mass of X to the mass of Y (including X). A chemical or biological species denoted by X may be described by a single term such as "nitrogen" or a phrase such as "nox_expressed_as_nitrogen". The chemical formula for xylene is C6H4C2H6. In chemistry, xylene is a generic term for a group of three isomers of dimethylbenzene. The IUPAC names for the isomers are 1,2-dimethylbenzene, 1,3-dimethylbenzene and 1,4-dimethylbenzene. Xylene is an aromatic hydrocarbon. There are standard names that refer to aromatic compounds as a group, as well as those for individual species.',
),
CFStandardNameDC(
name='maximum_over_coordinate_rotation_of_sea_ice_horizontal_shear_strain_rate',
canonical_units='s-1',
grib=None,
amip=None,
description='"Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs. Axial strain is the symmetric component of the tensor representing the gradient of internal forces (e.g. in ice). Strain rate refers to off-diagonal element(s) of the strain tensor (a single element for horizontal shear strain). "Horizontal" refers to the local horizontal in the location of the sea ice, i.e., perpendicular to the local gravity vector. Each of the strain components is defined with respect to a frame of reference. "Coordinate rotation" refers to the range of all possible orientations of the frame of reference. The shear strain has a maximum value relative to one of these orientations. The second invariant of strain rate, often referred to as the maximum shear strain [rate], is the maximum over coordinate rotations of the shear strain rate.',
),
CFStandardNameDC(
name='maximum_over_coordinate_rotation_of_sea_ice_horizontal_shear_stress',
canonical_units='N m-1',
grib=None,
amip=None,
description='"Sea ice" means all ice floating in the sea which has formed from freezing sea water, rather than by other processes such as calving of land ice to form icebergs. Axial stress is the symmetric component of the tensor representing the gradient of internal forces (e.g. in ice). Shear stress refers to off-diagonal element(s) of the stress tensor (a single element for horizontal shear stress). "Horizontal" refers to the local horizontal in the location of the sea ice, i.e., perpendicular to the local gravity vector. Each of the stress components is defined with respect to a frame of reference. "Coordinate rotation" refers to the range of all possible orientations of the frame of reference. The shear stress has a maximum value relative to one of these orientations. The second invariant of stress, often referred to as the maximum shear stress, is the maximum over coordinate rotations of the shear stress.',
),
CFStandardNameDC(
name='medium_soil_pool_mass_content_of_carbon',
canonical_units='kg m-2',
grib=None,
amip=None,
description='"Content" indicates a quantity per unit area. The "soil content" of a quantity refers to the vertical integral from the surface down to the bottom of the soil model. For the content between specified levels in the soil, standard names including content_of_soil_layer are used. Soil carbon is returned to the atmosphere as the organic matter decays. The decay process takes varying amounts of time depending on the composition of the organic matter, the temperature and the availability of moisture. A carbon "soil pool" means the carbon contained in organic matter which has a characteristic period over which it decays and releases carbon into the atmosphere. "Medium soil pool" refers to the decay of organic matter in soil with a characteristic period of between ten and one hundred years under reference climate conditions of a temperature of 20 degrees Celsius and no water limitations.',
),
CFStandardNameDC(
name='medium_type_cloud_area_fraction',
canonical_units='1',
grib=None,
amip=None,
description='"Area fraction" is the fraction of a grid cell\'s horizontal area that has some characteristic of interest. It is evaluated as the area of interest divided by the grid cell area. It may be expressed as a fraction, a percentage, or any other dimensionless representation of a fraction. Middle type clouds are: Altostratus, Altocumulus, Nimbostratus. X_type_cloud_area_fraction is generally determined on the basis of cloud type, though Numerical Weather Prediction (NWP) models often calculate them based on the vertical location of the cloud. For the cloud area fraction between specified levels in the atmosphere, standard names including "cloud_area_fraction_in_atmosphere_layer" are used. Standard names referring only to "cloud_area_fraction" should be used for quantities for the whole atmosphere column. Cloud area fraction is also called "cloud amount" and "cloud cover".',
),
CFStandardNameDC(
name='minimum_depth_of_aragonite_undersaturation_in_sea_water',
canonical_units='m',
grib=None,
amip=None,
description='Depth is the vertical distance below the surface.   \'Undersaturation\' means that a solution is unsaturated with respect to a solute. Aragonite is a mineral that is a polymorph of calcium carbonate. The chemical formula of aragonite is CaCO3. Standard names also exist for calcite, another polymorph of calcium carbonate. The "minimum depth of undersaturation", sometimes called the "saturation horizon", is the shallowest depth at which a body of water is an undersaturated solution of a named solute.',
),
CFStandardNameDC(
name='minimum_depth_of_calcite_undersaturation_in_sea_water',
canonical_units='m',
grib=None,
amip=None,
description='Depth is the vertical distance below the surface.   \'Undersaturation\' means that a solution is unsaturated with respect to a solute. Calcite is a mineral that is a  polymorph of calcium carbonate. The chemical formula of calcite is CaCO3. Standard names also exist for aragonite, another polymorph of calcium carbonate. The "minimum depth of undersaturation", sometimes called the "saturation horizon", is the shallowest depth at which a body of water is an undersaturated solution of a named solute.',
),
CFStandardNameDC(
name='minus_one_times_surface_upwelling_longwave_flux_in_air',
canonical_units='W m-2',
grib=None,
amip=None,
description='The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. "Minus one times" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. The surface called "surface" means the lower boundary of the atmosphere. The term "longwave" means longwave radiation. Upwelling radiation is radiation from below. It does not mean "net upward". When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='minus_one_times_surface_upwelling_shortwave_flux_in_air',
canonical_units='W m-2',
grib=None,
amip=None,
description='The sign convention is that "upwelling" is positive upwards and "downwelling" is positive downwards. "Minus one times" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. The surface called "surface" means the lower boundary of the atmosphere. The term "shortwave" means shortwave radiation. Upwelling radiation is radiation from below. It does not mean "net upward". When thought of as being incident on a surface, a radiative flux is sometimes called "irradiance". In addition, it is identical with the quantity measured by a cosine-collector light-meter and sometimes called "vector irradiance". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='minus_one_times_toa_outgoing_shortwave_flux',
canonical_units='W m-2',
grib=None,
amip=None,
description='"Minus one times" means that the quantity described takes the opposite sign convention  to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1.  Shortwave means shortwave radiation. "toa" means top of atmosphere. The TOA outgoing shortwave flux is the reflected and scattered solar radiative flux i.e. the "upwelling" TOA shortwave flux, sometimes called the "outgoing shortwave radiation" or "OSR". In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics.',
),
CFStandardNameDC(
name='minus_one_times_water_flux_into_sea_water_from_rivers',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The quantity minus_one_times_water_flux_into_sea_water_from_rivers is the quantity with standard name water_flux_into_sea_water_from_rivers multiplied by -1. "Water" means water in all phases. The water flux or volume transport into sea water from rivers is the inflow to the ocean, often applied to the surface in ocean models. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. "River" refers to water in the fluvial system (stream and floodplain).',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_ammonia_due_to_dry_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for ammonia is NH3. The mass is the total mass of the molecules. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Dry deposition" is the sum of turbulent deposition and gravitational settling.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_ammonia_due_to_wet_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for ammonia is NH3. The mass is the total mass of the molecules. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Wet deposition" means deposition by precipitation.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_ammonium_dry_aerosol_particles_due_to_dry_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for ammonium is NH4. The mass is the total mass of the particles. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Dry deposition" is the sum of turbulent deposition and gravitational settling.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_ammonium_dry_aerosol_particles_due_to_wet_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The chemical formula for ammonium is NH4. The mass is the total mass of the particles. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Wet deposition" means deposition by precipitation.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The mass is the total mass of the particles. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Deposition" is the sum of wet and dry deposition.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_dry_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The mass is the total mass of the particles. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Dry deposition" is the sum of turbulent deposition and gravitational settling.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_dust_dry_aerosol_particles_due_to_wet_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The mass is the total mass of the particles. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Wet deposition" means deposition by precipitation.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_dry_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. Chemically, "elemental carbon" is the carbonaceous fraction of particulate matter that is thermally stable in an inert atmosphere to high temperatures near 4000K and can only be gasified by oxidation starting at temperatures above 340 C. It is assumed to be inert and non-volatile under atmospheric conditions and insoluble in any solvent (Ogren and Charlson, 1983). The mass is the total mass of the particles. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Dry deposition" is the sum of turbulent deposition and gravitational settling.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_elemental_carbon_dry_aerosol_particles_due_to_wet_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. Chemically, "elemental carbon" is the carbonaceous fraction of particulate matter that is thermally stable in an inert atmosphere to high temperatures near 4000 K and can only be gasified by oxidation starting at temperatures above 340 degrees Celsius. It is assumed to be inert and non-volatile under atmospheric conditions and insoluble in any solvent (Ogren and Charlson, 1983). The mass is the total mass of the particles. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Wet deposition" means deposition by precipitation.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_insoluble_dust_dry_aerosol_particles_due_to_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. "Aerosol" means the system of suspended liquid or solid particles in air (except cloud droplets) and their carrier gas, the air itself. Aerosol particles take up ambient water (a process known as hygroscopic growth) depending on the relative humidity and the composition of the particles. "Dry aerosol particles" means aerosol particles without any water uptake. The mass is the total mass of the particles. "Insoluble aerosol" means aerosol which is not soluble in water, such as mineral dusts. At low temperatures such particles can be efficient nuclei for ice clouds. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Deposition" is the sum of wet and dry deposition.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_nitrogen_compounds_expressed_as_nitrogen_due_to_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Nitrogen compounds" summarizes all chemical species containing nitrogen atoms. Usually, particle bound and gaseous nitrogen compounds, such as atomic nitrogen (N), nitrogen monoxide (NO), nitrogen dioxide (NO2), dinitrogen pentoxide (N2O5), nitric acid (HNO3), nitrate (NO3-), peroxynitric acid (HNO4), ammonia (NH3), ammonium (NH4+), bromine nitrate (BrONO2), chlorine nitrate (ClONO2) and organic nitrates (most notably peroxyacetyl nitrate, sometimes referred to as PAN, (CH3COO2NO2)) are included. The list of individual species that are included in this quantity can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Deposition" is the sum of wet and dry deposition.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_noy_expressed_as_nitrogen_due_to_dry_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Noy" describes a family of chemical species. The family usually includes atomic nitrogen (N), nitrogen monoxide (NO), nitrogen dioxide (NO2), dinitrogen pentoxide (N2O5), nitric acid (HNO3), peroxynitric acid (HNO4), bromine nitrate (BrONO2), chlorine nitrate (ClONO2) and organic nitrates (most notably peroxyacetyl nitrate, sometimes referred to as PAN, (CH3COO2NO2)). The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Dry deposition" is the sum of turbulent deposition and gravitational settling.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_noy_expressed_as_nitrogen_due_to_wet_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The phrase "expressed_as" is used in the construction A_expressed_as_B, where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A, neglecting all other chemical constituents of A. "Noy" describes a family of chemical species. The family usually includes atomic nitrogen (N), nitrogen monoxide (NO), nitrogen dioxide (NO2), dinitrogen pentoxide (N2O5), nitric acid (HNO3), peroxynitric acid (HNO4), bromine nitrate (BrONO2), chlorine nitrate (ClONO2) and organic nitrates (most notably peroxyacetyl nitrate, sometimes referred to as PAN, (CH3COO2NO2)). The list of individual species that are included in a quantity having a group chemical standard name can vary between models. Where possible, the data variable should be accompanied by a complete description of the species represented, for example, by using a comment attribute. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Wet deposition" means deposition by precipitation.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_ozone_due_to_dry_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The phrase "minus_tendency" means that the quantity described takes the opposite sign convention to that for the quantity which has the same standard name apart from this phrase, i.e. the two quantities differ from one another by a factor of -1. Thus a "minus_tendency" in the atmosphere means a positive deposition rate onto the underlying surface. "Content" indicates a quantity per unit area. The "atmosphere content" of a quantity refers to the vertical integral from the surface to the top of the atmosphere. For the content between specified levels in the atmosphere, standard names including "content_of_atmosphere_layer" are used. The chemical formula for ozone is O3. The IUPAC name for ozone is trioxygen. The mass is the total mass of the molecules. The specification of a physical process by the phrase "due_to_" process means that the quantity named is a single term in a sum of terms which together compose the general quantity named by omitting the phrase. "Dry deposition" is the sum of turbulent deposition and gravitational settling.',
),
CFStandardNameDC(
name='minus_tendency_of_atmosphere_mass_content_of_particulate_organic_matter_dry_aerosol_particles_due_to_dry_deposition',
canonical_units='kg m-2 s-1',
grib=None,
amip=None,
description='The phrase "tendency_of_X" means derivative of X with respect to time. The p