# pylint: skip-file
# auto generated, do not modify
from cchdo.params import WHPName as WHPNameDC
whp_names = dict()
names = [
WHPNameDC(
whp_name='EXPOCODE',
dtype='string',
whp_unit=None,
nc_name='expocode',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='The expedition code, assigned by the CCHDO or generated by the user. Used as the unique identifier for the cruise. Usual generation formula is ICES 4 character platform code then the cruise departure date in YYYYMMDD format. The underscore ``_`` character may also be present.',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=1.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SECT_ID',
dtype='string',
whp_unit=None,
nc_name='section_id',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='If a repeat of a WOCE section, this is the WHP section identifier. Examples include: ``A12``, ``A13.5``, ``P02``.',
note='There may be inconsistency in the how line numbers are represented. For example, ``P02`` might be present as ``P2``, these represent the same SECT_ID. Two digit zero padded line numbers are the canonical representation, please inform the CCHDO if non zero padded line numbers are encountered.',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=2.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='STNNBR',
dtype='string',
whp_unit=None,
nc_name='station',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=8,
description="The originator's station identifier. Allowed characters are U+0030 to U+0039, U+0041 to U+005A, U+0061 to U+007A, and U+005F (``0-9``, ``a-z``, ``A-Z``, and ``_``)",
note='Numeric-only station identifiers are preferred by many data users, but provision for non numeric station identifiers is retained to maintain compatibility with WOCE records.',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=3.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CASTNO',
dtype='integer',
whp_unit=None,
nc_name='cast',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=3,
description="The originator's cast number.",
note='Where cast number is unknown a default value of 1 MAY be inserted by data processors.',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=4.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BIOS_CASTID',
dtype='integer',
whp_unit=None,
nc_name='bios_castid',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=8,
description='BIOS cast number. Used by the Bermuda Institute of Ocean Sciences in the BATS and Hydrostation S timeseries.',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=5.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SAMPNO',
dtype='string',
whp_unit=None,
nc_name='sample',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='The sample number. Often it is the rosette position, however, groups may use their own sampling identification scheme. Allowed characters are U+0030 to U+0039, U+0041 to U+005A, U+0061 to U+007A, and U+005F (``0-9``, ``a-z``, ``A-Z``, and ``_``)',
note=None,
warning='The value may not be numeric, ensure that any software reading the file can handle UTF-8 data of the specified allowed code points.',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=6.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='GEOTR_EVENT',
dtype='integer',
whp_unit=None,
nc_name='geotraces_event',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=8,
description='The GEOTRACES Event number. Along with the GEOTRACES sample number, it is used by the GEOTRACES community for sample identification.',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=7.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='GEOTR_SAMPNO',
dtype='integer',
whp_unit=None,
nc_name='geotraces_sample',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=8,
description='The GEOTRACES Sample number. Along with the GEOTRACES Event number, it is used by the GEOTRACES community for sample identification.',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=8.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BIONBR',
dtype='string',
whp_unit=None,
nc_name='bionbr',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='Sample identification number used by the Bedford Institute of Oceanography (BIO)',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=9.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BTLNBR',
dtype='string',
whp_unit=None,
nc_name='bottle_number',
flag_w='woce_bottle',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='The bottle identification number. This is intended to be a permanent, unique serial number fixed to the sampling device. It may also be the an identifier fixed for the duration of a single expedition. Allowed characters are U+0030 to U+0039, U+0041 to U+005A, U+0061 to U+007A, and U+005F (``0-9``, ``a-z``, ``A-Z``, and ``_``)',
note='The bottle number MAY have quality flags.',
warning='Despite the name, the value IS NOT numeric, ensure that any software reading the file can handle UTF-8 data of the specified allowed code points. The CF/netCDF files force the data type to be char, but for historic reasons, the variable name is maintained as bottle_number.',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=10.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DATE',
dtype='string',
whp_unit=None,
nc_name='date',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=8,
description='The UTC date in zero padded YYYYMMDD format. The date reported is usually cast bottom for Bottle files and cast start for CTD files. Valid range for YYYY: 0001-9999. Valid range for MM: 01-12. Valid range for DD: 01-31 (depends on month and year). The format of dates corresponds to the C-strftime format of ``%Y%m%d``.\n\nThe date should be read as a string, but be able to be cast unambiguously to an integer. To convert from integer representation, left pad zeros to match the date format description. For example, the integer ``8020202`` is the date ``08020202`` or Feb 2nd, 802. This is a very unlikely situation.',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=11.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TIME',
dtype='string',
whp_unit=None,
nc_name='time',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=4,
description='The UTC time in zero padded hhmm format. A single time should be reported for each cast, usually the time at cast bottom (deepest) is used. The order of preference for the reported time is: cast bottom, cast start, cast end (i.e if cast bottom is not available, the cast start time should be used).\n\nValid range for hh: 00-24 Valid range for mm: 00-59 The format of times corresponds to the C-strftime format of ``%H%M``.\n\nThe time should be read as a string, but be able to be cast unambiguously into an integer. To convert from an integer, left pad zeros to match the time format description.',
note='Times represented as integers will be present in whp COARDS netcdf files. Times in netcdf files will be anywhere from 1 to 4 digits. E.g. a time of 6 as in integer represents 6 minutes after midnight or 0006\n\nMidnight is a special case in that it has two valid representations: ``0000`` and ``2400``. The date ``20140202`` at time ``0000`` is the same instant as the date ``20140201`` at time ``2400``. This corresponds to times allowed by ISO 8601.\n\nUse `BTL_TIME`_ to report the time of individual bottle closures.\n\nCF netCDF files will use the standard Time Coordinate as specified in the conventions',
warning='Time is not a required parameter! If time is not present, then the temporal resolution of the data is reduced to a 24 hour period. It is the responsibility of the user of the data to omit files/casts which do not meet their temporal resolution requirements.',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=12.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='LATITUDE',
dtype='decimal',
whp_unit=None,
nc_name='latitude',
flag_w='no_flags',
cf_name='latitude',
numeric_min=-90.0,
numeric_max=90.0,
numeric_precision=4,
field_width=9,
description='The latitude as a signed decimal number. By convention, is positive in the northern hemisphere and negative in the southern hemisphere. Positive values do not include a ``+`` character (U+002B), negative values are prefixed with a ``-`` character (U+002D).',
note='Only one latitude SHOULD be reported for a cast, typically this is the ship position when the cast is at the bottom (deepest), but this is not guaranteed.\n\nUse `BTL_LAT`_ to include positions of individual bottle closures.',
warning='Since this parameter has no units, the positive in the northern hemisphere and negative in the southern hemisphere MUST be strictly adhered to.\n\nThe geographic coordinate system is not currently reported.',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=13.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='LONGITUDE',
dtype='decimal',
whp_unit=None,
nc_name='longitude',
flag_w='no_flags',
cf_name='longitude',
numeric_min=-180.0,
numeric_max=180.0,
numeric_precision=4,
field_width=9,
description='The longitude as a signed decimal number. By convention, is positive in the eastern hemisphere and negative in the western hemisphere. Positive values do not include a ``+`` character (U+002B), negative values are prefixed with a ``-`` character (U+002D).',
note='Only one longitude SHOULD be reported for a cast, typically this is the ship position when the cast is at the bottom (deepest), but this is not guaranteed.\n\nUse `BTL_LON`_ to include positions of individual bottle closures.\n\nThe longitudes of -180 and 180 describe the same meridian.',
warning='Since this parameter has no units, the positive in the eastern hemisphere and negative in the western hemisphere convention MUST be strictly adhered to.\n\nThe geographic coordinate system is not currently reported.',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=14.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DEPTH',
dtype='decimal',
whp_unit='METERS',
nc_name='btm_depth',
flag_w='no_flags',
cf_name='sea_floor_depth_below_sea_surface',
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='The reported depth to the bottom. Corrected depths are preferred to uncorrected depths.',
note='Documentation should be provided describing how the depth was calculated/corrected, typically in the comment fields.',
warning='This is NOT the depth of bottle closures.',
error_name=None,
cf_unit='meters',
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=15.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDPRS',
dtype='decimal',
whp_unit='DBAR',
nc_name='pressure',
flag_w='woce_ctd',
cf_name='sea_water_pressure',
numeric_min=0.0,
numeric_max=10000.0,
numeric_precision=1,
field_width=9,
description='The corrected pressure as measured by the CTD.',
note='Typically does not have quality flags.',
warning=None,
error_name=None,
cf_unit='dbar',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=16.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDRAW',
dtype='decimal',
whp_unit='DBAR',
nc_name='ctd_pressure_raw',
flag_w='woce_ctd',
cf_name='sea_water_pressure',
numeric_min=0.0,
numeric_max=10000.0,
numeric_precision=1,
field_width=9,
description='The uncorrected pressure as measured by the CTD. Uncorrected means that no processing has been done (e.g. deck pressure offsets) other than manufacturer calibrations applied.',
note='Typically does not have quality flags.',
warning=None,
error_name=None,
cf_unit='dbar',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=17.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDTMP',
dtype='decimal',
whp_unit='ITS-90',
nc_name='ctd_temperature',
flag_w='woce_ctd',
cf_name='sea_water_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=4,
field_width=9,
description='The corrected temperature as measured by the CTD.',
note='Typically does not have quality flags.',
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='ITS-90',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=18.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDTMP',
dtype='decimal',
whp_unit='IPTS-68',
nc_name='ctd_temperature_68',
flag_w='woce_ctd',
cf_name='sea_water_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=4,
field_width=9,
description='The corrected temperature as measured by the CTD.',
note='Typically does not have quality flags.',
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='IPTS-68',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=18.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDTMP',
dtype='decimal',
whp_unit='DEG C',
nc_name='ctd_temperature_unk',
flag_w='woce_ctd',
cf_name='sea_water_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=4,
field_width=9,
description='The corrected temperature as measured by the CTD.',
note='Typically does not have quality flags.',
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='unknown',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=18.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDSAL',
dtype='decimal',
whp_unit='PSS-78',
nc_name='ctd_salinity',
flag_w='woce_ctd',
cf_name='sea_water_practical_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='The corrected practical salinity as measured (calculated) by the CTD.',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale='PSS-78',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=19.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SALNTY',
dtype='decimal',
whp_unit='PSS-78',
nc_name='bottle_salinity',
flag_w='woce_discrete',
cf_name='sea_water_practical_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='The practical salinity measured from a bottle sample.',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale='PSS-78',
whp_number=1,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=20.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DNSSAL',
dtype='decimal',
whp_unit='G/KG',
nc_name='density_salinity',
flag_w='woce_discrete',
cf_name='sea_water_absolute_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='Absolute salinity calculated from direct density measurements, also called absolute salinity.',
note=None,
warning=None,
error_name=None,
cf_unit='g/kg',
reference_scale=None,
whp_number=92,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=21.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDSVLSAL',
dtype='decimal',
whp_unit='G/KG',
nc_name='ctd_sound_velocity_salinity',
flag_w='woce_ctd',
cf_name='sea_water_absolute_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='Absolute salinity calculated from sound velocity and temperature, also called absolute salinity.',
note=None,
warning=None,
error_name=None,
cf_unit='g/kg',
reference_scale=None,
whp_number=92,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=22.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDOXY',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='ctd_oxygen',
flag_w='woce_ctd',
cf_name='moles_of_oxygen_per_unit_mass_in_sea_water',
numeric_min=0.0,
numeric_max=500.0,
numeric_precision=1,
field_width=9,
description='The corrected oxygen measured by the CTD.',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=23.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDOXY',
dtype='decimal',
whp_unit='ML/L',
nc_name='ctd_oxygen_ml_l',
flag_w='woce_ctd',
cf_name='volume_fraction_of_oxygen_in_sea_water',
numeric_min=0.0,
numeric_max=500.0,
numeric_precision=1,
field_width=9,
description='The corrected oxygen measured by the CTD.',
note=None,
warning=None,
error_name=None,
cf_unit='ml/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=23.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='OXYGEN',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='oxygen',
flag_w='woce_discrete',
cf_name='moles_of_oxygen_per_unit_mass_in_sea_water',
numeric_min=0.0,
numeric_max=500.0,
numeric_precision=1,
field_width=9,
description='The dissolved oxygen measured in a discrete sample, typically using the Winkler test for dissolved oxygen.',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=2,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=24.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SILCAT',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='silicate',
flag_w='woce_discrete',
cf_name='moles_of_silicate_per_unit_mass_in_sea_water',
numeric_min=0.0,
numeric_max=250.0,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved silicate in sea water.',
note=None,
warning=None,
error_name='SILUNC',
cf_unit='umol/kg',
reference_scale=None,
whp_number=3,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=25.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NH4',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='ammonium',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved ammonium in sea water.',
note=None,
warning=None,
error_name='NH4UNC',
cf_unit='umol/kg',
reference_scale=None,
whp_number=30,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=26.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NITRAT',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='nitrate',
flag_w='woce_discrete',
cf_name='moles_of_nitrate_per_unit_mass_in_sea_water',
numeric_min=-0.1,
numeric_max=47.0,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved nitrate in sea water. The chemical formula for the nitrate anion is NO3-.',
note=None,
warning=None,
error_name='NRAUNC',
cf_unit='umol/kg',
reference_scale=None,
whp_number=4,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=27.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NITRIT',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='nitrite',
flag_w='woce_discrete',
cf_name='moles_of_nitrite_per_unit_mass_in_sea_water',
numeric_min=-0.1,
numeric_max=15.0,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved nitrite in sea water. The chemical formula for the nitrite anion is NO2-.',
note=None,
warning=None,
error_name='NRIUNC',
cf_unit='umol/kg',
reference_scale=None,
whp_number=5,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=28.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PHSPHT',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='phosphate',
flag_w='woce_discrete',
cf_name='moles_of_phosphate_per_unit_mass_in_sea_water',
numeric_min=0.0,
numeric_max=5.0,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved phosphate in sea water. The chemical formula for the phosphate anion is PO4.',
note=None,
warning=None,
error_name='PHPUNC',
cf_unit='umol/kg',
reference_scale=None,
whp_number=6,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=29.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NO2+NO3',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='nitrite_nitrate',
flag_w='woce_discrete',
cf_name='moles_of_nitrate_and_nitrite_per_unit_mass_in_sea_water',
numeric_min=0.0,
numeric_max=5.0,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved nitrate plus nitrite in sea water. The chemical formula for the nitrite anion is NO2-.',
note='Most modern techniques for determining dissolved nitrate return a value of nitrate (NO3) plus nitrite (NO2). A separate determination is then done for nitrite and the result subtracted by the data originator to obtain nitrate. If no separate nitrite determination was carried out - or in rare cases the nitrite number was not subtracted - data providers should list the result as NO2+NO3. Because nitrite values are in most regions small compared to nitrate, most data users will not adversely affect their results by relabeling NO2+NO3 as NITRAT.',
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=30.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CFC-11',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='cfc_11',
flag_w='woce_discrete',
cf_name='moles_of_cfc11_per_unit_mass_in_sea_water',
numeric_min=-0.1,
numeric_max=15.0,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved CFC11 in sea water. The chemical formula of CFC11 is CFCl3. The IUPAC name for CFC11 is trichloro(fluoro)methane.',
note=None,
warning=None,
error_name='CF11ER',
cf_unit='pmol/kg',
reference_scale=None,
whp_number=7,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=31.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CFC-12',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='cfc_12',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-0.1,
numeric_max=15.0,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved CFC12 in sea water. The chemical formula for CFC12 is CF2Cl2. The IUPAC name for CFC12 is dichloro(difluoro)methane.',
note=None,
warning=None,
error_name='CF12ER',
cf_unit='pmol/kg',
reference_scale=None,
whp_number=8,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=32.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CFC113',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='cfc_113',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-0.1,
numeric_max=1.5,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved CFC113 in sea water. The chemical formula of CFC113 is CCl2FCClF2. The IUPAC name for CFC113 is 1,1,2-trichloro-1,2,2-trifluoroethane.',
note=None,
warning=None,
error_name='CF113ER',
cf_unit='pmol/kg',
reference_scale=None,
whp_number=27,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=33.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SF6',
dtype='decimal',
whp_unit='FMOL/KG',
nc_name='sulfur_hexifluoride',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='The concentration of SF6 (Sulfur hexafluoride) in sea water.',
note=None,
warning=None,
error_name=None,
cf_unit='fmol/kg',
reference_scale=None,
whp_number=63,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=34.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TCARBN',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='total_carbon',
flag_w='woce_discrete',
cf_name='moles_of_dissolved_inorganic_carbon_per_unit_mass_in_sea_water',
numeric_min=1100.0,
numeric_max=2600.0,
numeric_precision=1,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=23,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=35.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ALKALI',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='total_alkalinity',
flag_w='woce_discrete',
cf_name=None,
numeric_min=100.0,
numeric_max=2800.0,
numeric_precision=1,
field_width=9,
description='The total alkalinity equivalent concentration (including carbonate, nitrogen, silicate, and borate components).',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=24,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=36.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='FCO2',
dtype='decimal',
whp_unit='UATM',
nc_name='fco2',
flag_w='woce_discrete',
cf_name='fugacity_of_carbon_dioxide_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='The fugacity is the measured pressure (or partial pressure) of a real gas corrected for the intermolecular forces of that gas, which allows that corrected quantity to be treated like the pressure of an ideal gas in the ideal gas equation PV = nRT. The partial pressure of a dissolved gas in sea water is the partial pressure in air with which it would be in equilibrium. The partial pressure of a gaseous constituent of air is the pressure that it would exert if all other gaseous constituents were removed, assuming the volume, the temperature, and its number of moles remain unchanged. The chemical formula for carbon dioxide is CO2.',
note=None,
warning=None,
error_name=None,
cf_unit='uatm',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name='FCO2TMP',
analytical_temperature_units='DEG C',
rank=37.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='FCO2TMP',
dtype='decimal',
whp_unit='DEG C',
nc_name='fco2_temperature',
flag_w='woce_discrete',
cf_name='temperature_of_analysis_of_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='unknown',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=38.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PCO2',
dtype='decimal',
whp_unit='UATM',
nc_name='partial_pressure_of_co2',
flag_w='woce_discrete',
cf_name='partial_pressure_of_carbon_dioxide_in_sea_water',
numeric_min=50.0,
numeric_max=2000.0,
numeric_precision=1,
field_width=9,
description='The partial pressure of a dissolved gas in sea water is the partial pressure in air with which it would be in equilibrium. The partial pressure of a gaseous constituent of air is the pressure that it would exert if all other gaseous constituents were removed, assuming the volume, the temperature, and its number of moles remain unchanged. The chemical formula for carbon dioxide is CO2.',
note=None,
warning=None,
error_name=None,
cf_unit='uatm',
reference_scale=None,
whp_number=25,
scope='sample',
analytical_temperature_name='PCO2TMP',
analytical_temperature_units='DEG C',
rank=39.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PCO2TMP',
dtype='decimal',
whp_unit='DEG C',
nc_name='partial_co2_temperature',
flag_w='woce_discrete',
cf_name='temperature_of_analysis_of_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='unknown',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=40.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PH_TOT',
dtype='decimal',
whp_unit=None,
nc_name='ph_total_h_scale',
flag_w='woce_discrete',
cf_name='sea_water_ph_reported_on_total_scale',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='The measure of acidity of seawater, defined as the negative logarithm of the concentration of dissolved hydrogen ions plus bisulfate ions in a sea water medium; when measured the scale is defined according to a series of buffers prepared in artificial seawater containing bisulfate. The quantity may be written as pH(total) = -log([H+](free) + [HSO4-]).',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=26,
scope='sample',
analytical_temperature_name='PH_TMP',
analytical_temperature_units='DEG C',
rank=41.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PH_SWS',
dtype='decimal',
whp_unit=None,
nc_name='ph_sws',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=26,
scope='sample',
analytical_temperature_name='PH_TMP',
analytical_temperature_units='DEG C',
rank=42.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PH_TMP',
dtype='decimal',
whp_unit='DEG C',
nc_name='ph_temperature',
flag_w='woce_discrete',
cf_name='temperature_of_analysis_of_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='unknown',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=43.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DOC',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='dissolved_organic_carbon',
flag_w='woce_discrete',
cf_name=None,
numeric_min=30.0,
numeric_max=80.0,
numeric_precision=1,
field_width=9,
description='Dissolved organic carbon',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=43,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=44.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TRITUM',
dtype='decimal',
whp_unit='TU',
nc_name='tritium',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-1.0,
numeric_max=100.0,
numeric_precision=3,
field_width=9,
description=None,
note='1 TU is 1 tritium atom per 10\\ :sup:`18` hydrogen atoms',
warning=None,
error_name='TRITER',
cf_unit='1e-18',
reference_scale=None,
whp_number=9,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=45.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HELIUM',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='helium',
flag_w='woce_discrete',
cf_name=None,
numeric_min=1.0,
numeric_max=3.0,
numeric_precision=4,
field_width=9,
description=None,
note=None,
warning=None,
error_name='HELIER',
cf_unit='nmol/kg',
reference_scale=None,
whp_number=10,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=46.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DELHE3',
dtype='decimal',
whp_unit='PERCNT',
nc_name='delta_helium_3',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-10.0,
numeric_max=100.0,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name='DELHER',
cf_unit='percent',
reference_scale=None,
whp_number=11,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=47.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='REFTMP',
dtype='decimal',
whp_unit='ITS-90',
nc_name='ref_temperature',
flag_w='woce_discrete',
cf_name='sea_water_temperature',
numeric_min=-3.0,
numeric_max=35.0,
numeric_precision=4,
field_width=9,
description='Sea water temperature as measured by a reference thermometer, such as an SBE35. These typically only measure when a bottle is triggered and are part of the discrete data stream rather than the CTD one.',
note=None,
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='ITS-90',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=48.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='REFTMP',
dtype='decimal',
whp_unit='DEG C',
nc_name='ref_temperature_c',
flag_w='woce_discrete',
cf_name='sea_water_temperature',
numeric_min=-3.0,
numeric_max=35.0,
numeric_precision=4,
field_width=9,
description='Sea water temperature as measured by a reference thermometer, such as an SBE35. These typically only measure when a bottle is triggered and are part of the discrete data stream rather than the CTD one.',
note=None,
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='unknown',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=48.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='REVPRS',
dtype='decimal',
whp_unit='DBAR',
nc_name='rev_pressure',
flag_w='woce_discrete',
cf_name='sea_water_pressure',
numeric_min=0.0,
numeric_max=11000.0,
numeric_precision=1,
field_width=9,
description='Sea water pressure as determined via a pair of reversing thermometers.',
note=None,
warning=None,
error_name=None,
cf_unit='dbar',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=49.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='REVTMP',
dtype='decimal',
whp_unit='ITS-90',
nc_name='rev_temperature_90',
flag_w='woce_discrete',
cf_name='sea_water_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=3,
field_width=9,
description='Sea water temperature as determined via a reversing thermometer.',
note=None,
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='ITS-90',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=50.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='REVTMP',
dtype='decimal',
whp_unit='IPTS-68',
nc_name='rev_temperature',
flag_w='woce_discrete',
cf_name='sea_water_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=3,
field_width=9,
description='Sea water temperature as determined via a reversing thermometer.',
note=None,
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='IPTS-68',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=50.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='REVTMP',
dtype='decimal',
whp_unit='DEG C',
nc_name='rev_temperature_c',
flag_w='woce_discrete',
cf_name='sea_water_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=3,
field_width=9,
description='Sea water temperature as determined via a reversing thermometer.',
note=None,
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='unknown',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=50.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DELC13',
dtype='decimal',
whp_unit='/MILLE',
nc_name='del_carbon_13_dic',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-5.0,
numeric_max=5.0,
numeric_precision=1,
field_width=9,
description='Enrichment of :sup:`13`\\ C vs :sup:`12`\\ C in dissolved inorganic carbon (DIC or TCARBN) compared to a reference standard usually VPDB. This is usually written as lower case delta δ\\ :sup:`13`\\ C.',
note=None,
warning=None,
error_name='C13ERR',
cf_unit='1e-3',
reference_scale=None,
whp_number=13,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=51.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DELC14',
dtype='decimal',
whp_unit='/MILLE',
nc_name='del_carbon_14_dic',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-300.0,
numeric_max=250.0,
numeric_precision=1,
field_width=9,
description='Enrichment of :sup:`14`\\ C vs :sup:`12`\\ C in dissolved inorganic carbon (DIC or TCARBN) compared to a reference standard usually VPDB. This ratio has been corrected for isotopic fractionation and is usually written as upper case delta Δ\\ :sup:`14`\\ C.',
note=None,
warning=None,
error_name='C14ERR',
cf_unit='1e-3',
reference_scale=None,
whp_number=12,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=52.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DON',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='dissolved_organic_nitrogen',
flag_w='woce_discrete',
cf_name=None,
numeric_min=200.0,
numeric_max=900.0,
numeric_precision=1,
field_width=9,
description="Dissolved organic nitrogen in sea water.  'Dissolved organic nitrogen' describes the nitrogen held in carbon compounds in solution. These are mostly generated by plankton excretion and decay.",
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=32,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=53.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TOC',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='total_organic_carbon',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=54.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='POC',
dtype='decimal',
whp_unit='UG/KG',
nc_name='particulate_organic_carbon',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Particulate organic carbon',
note=None,
warning=None,
error_name=None,
cf_unit='ug/kg',
reference_scale=None,
whp_number=40,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=55.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PON',
dtype='decimal',
whp_unit='UG/KG',
nc_name='particulate_organic_nitrogen',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Particulate organic nitrogen',
note=None,
warning=None,
error_name=None,
cf_unit='ug/kg',
reference_scale=None,
whp_number=41,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TDN',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='total_dissolved_nitrogen',
flag_w='woce_discrete',
cf_name=None,
numeric_min=3.0,
numeric_max=20.0,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=57.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TON',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='total_organic_nitrogen',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=58.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NEON',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='neon',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.0,
numeric_max=10.0,
numeric_precision=3,
field_width=9,
description=None,
note=None,
warning=None,
error_name='NEONER',
cf_unit='nmol/kg',
reference_scale=None,
whp_number=17,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=59.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DELO18',
dtype='decimal',
whp_unit='/MILLE',
nc_name='del_oxygen_18',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-6.0,
numeric_max=5.0,
numeric_precision=2,
field_width=9,
description='Enrichment of the 18O/16O isotopic ratio of the sea water itself compared to VSMOW (Vienna Standard Mean Ocean Water).',
note=None,
warning=None,
error_name='O18ERR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=60.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CCL4',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='carbon_tetrachloride',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-0.1,
numeric_max=20.0,
numeric_precision=3,
field_width=9,
description='Dissolved carbon tetrachloride',
note=None,
warning=None,
error_name='CCL4ER',
cf_unit='pmol/kg',
reference_scale=None,
whp_number=28,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=61.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NI',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='nickel',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=62.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ALUMIN',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='dissolved_aluminum',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.3,
numeric_max=25.0,
numeric_precision=1,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=63.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BARIUM',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='barium',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=39,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=64.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CU',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='copper',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=65.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='FE',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='iron',
flag_w='woce_discrete',
cf_name='mole_concentration_of_dissolved_iron_in_sea_water',
numeric_min=0.02,
numeric_max=2.0,
numeric_precision=1,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=66.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='MN',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='manganese',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.0,
numeric_max=5.0,
numeric_precision=1,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=67.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDFLUOR',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='ctd_fluor',
flag_w='woce_ctd',
cf_name='mass_concentration_of_chlorophyll_in_sea_water',
numeric_min=0.0,
numeric_max=50.0,
numeric_precision=4,
field_width=9,
description='In situ chlorophyll measured by a fluorometer',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=68.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=470.0,
emission_wavelength=695.0,
nc_group=None,
),
WHPNameDC(
whp_name='CTDFLUOR',
dtype='decimal',
whp_unit='VOLTS',
nc_name='ctd_fluor_raw',
flag_w='woce_ctd',
cf_name=None,
numeric_min=0.0,
numeric_max=5.0,
numeric_precision=4,
field_width=9,
description='In situ chlorophyll measured by a fluorometer',
note=None,
warning=None,
error_name=None,
cf_unit='volts',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=68.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=470.0,
emission_wavelength=695.0,
nc_group=None,
),
WHPNameDC(
whp_name='CTDFLUOR',
dtype='decimal',
whp_unit=None,
nc_name='ctd_fluor_arbitrary',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='In situ chlorophyll measured by a fluorometer',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=68.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=470.0,
emission_wavelength=695.0,
nc_group=None,
),
WHPNameDC(
whp_name='PAR',
dtype='decimal',
whp_unit='UMOL/M^2/SEC',
nc_name='par',
flag_w='woce_ctd',
cf_name='downwelling_photosynthetic_photon_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Photosynthetically active radiation. The downwelling photon flux of photons with a wavelength between 400nm and 700nm.',
note=None,
warning=None,
error_name=None,
cf_unit='umol m-2 s-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='I-129',
dtype='decimal',
whp_unit='BQ/M^3',
nc_name='iodine_129',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name='I129ER',
cf_unit='Bq m-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=70.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='RA-226',
dtype='decimal',
whp_unit='DM/.1MG',
nc_name='radium_226',
flag_w='woce_discrete',
cf_name=None,
numeric_min=3.0,
numeric_max=80.0,
numeric_precision=2,
field_width=9,
description=None,
note='units are disintegrations per minute per 100kg',
warning=None,
error_name='RA-226E',
cf_unit='0.000166 Bq/kg',
reference_scale=None,
whp_number=19,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=71.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='RA-228',
dtype='decimal',
whp_unit='DM/.1MG',
nc_name='radium_228',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-1.0,
numeric_max=10.0,
numeric_precision=2,
field_width=9,
description=None,
note='units are disintegrations per minute per 100kg',
warning=None,
error_name='RA-228E',
cf_unit='0.000166 Bq/kg',
reference_scale=None,
whp_number=18,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=72.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDXMISS',
dtype='decimal',
whp_unit='%TRANS',
nc_name='ctd_transmissometer',
flag_w='woce_ctd',
cf_name=None,
numeric_min=0.0,
numeric_max=100.0,
numeric_precision=2,
field_width=9,
description='Transmissivity of light in sea water, has path length and wavelength dependencies',
note='Standard rosette mounted transmissometers have a path length of 25cm and operate in the "red" wavelengths of around 640 to 660nm. These wavelengths provide a good estimate of the attenuation due to particles.',
warning=None,
error_name=None,
cf_unit='1e-2',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=73.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDXMISS',
dtype='decimal',
whp_unit='VOLTS',
nc_name='ctd_transmissometer_raw',
flag_w='woce_ctd',
cf_name=None,
numeric_min=0.0,
numeric_max=5.0,
numeric_precision=4,
field_width=9,
description='Transmissivity of light in sea water, has path length and wavelength dependencies',
note='Standard rosette mounted transmissometers have a path length of 25cm and operate in the "red" wavelengths of around 640 to 660nm. These wavelengths provide a good estimate of the attenuation due to particles.',
warning=None,
error_name=None,
cf_unit='volts',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=73.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDBEAMCP',
dtype='decimal',
whp_unit='/METER',
nc_name='ctd_beamcp',
flag_w='woce_ctd',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water_corrected_for_pure_water_attenuance',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Radiative flux is the sum of shortwave and longwave radiative fluxes. In accordance with common usage in geophysical disciplines, "flux" implies per unit area, called "flux density" in physics. The volume scattering/absorption/attenuation coefficient is the fractional change of radiative flux per unit path length due to the stated process. Coefficients with canonical units of m2 s-1 i.e. multiplied by density have standard names with specific\\ _ instead of volume\\ _. The scattering/absorption/attenuation coefficient is assumed to be an integral over all wavelengths, unless a coordinate of radiation_wavelength is included to specify the wavelength. Attenuation is the sum of absorption and scattering. Attenuation is sometimes called "extinction". Beam attenuation refers to the decrease of radiative flux along the direction of the incident path. It is distinguished from attenuation of the downwelling component of radiative flux from any incident direction, also called "diffuse" attenuation. Corrected for pure water attendance means the attenuation coefficient has been adjusted/calibrated to remove the influence of absorption/scattering from the water itself.',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.0,
radiation_wavelength=650.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='AR-39',
dtype='decimal',
whp_unit='PCTMOD',
nc_name='argon_39',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.0,
numeric_max=100.0,
numeric_precision=1,
field_width=9,
description=None,
note="The units mean '% modern'",
warning=None,
error_name=None,
cf_unit='1e-2',
reference_scale=None,
whp_number=16,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=75.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CS-137',
dtype='decimal',
whp_unit='DM/.1MG',
nc_name='cesium_137',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.0,
numeric_max=100.0,
numeric_precision=2,
field_width=9,
description='Activity of 137Cs in seawater',
note='units are disintegrations per minute per 100kg',
warning=None,
error_name=None,
cf_unit='0.000166 Bq/kg',
reference_scale=None,
whp_number=22,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=76.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='KR-85',
dtype='decimal',
whp_unit='DM/MG',
nc_name='krypton_85',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.0,
numeric_max=5.0,
numeric_precision=2,
field_width=9,
description=None,
note='units are disintegrations per minute per 1000kg',
warning=None,
error_name=None,
cf_unit='0.0000166 Bq/kg',
reference_scale=None,
whp_number=14,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=77.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SR-90',
dtype='decimal',
whp_unit='DM/.1MG',
nc_name='strontium_90',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.0,
numeric_max=100.0,
numeric_precision=2,
field_width=9,
description=None,
note='units are disintegrations per minute per 100kg',
warning=None,
error_name=None,
cf_unit='0.000166 Bq/kg',
reference_scale=None,
whp_number=21,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=78.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='N2O',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='nitrous_oxide',
flag_w='woce_discrete',
cf_name=None,
numeric_min=1.0,
numeric_max=200.0,
numeric_precision=1,
field_width=9,
description='Nitrous oxide',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=33,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=79.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='RA-8/6',
dtype='decimal',
whp_unit=None,
nc_name='radium_228_226',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name='RA-8/6E',
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=80.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='QUALT1',
dtype='string',
whp_unit=None,
nc_name='quality_word_one',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='Quality code 1, this is not used in exchange files. In WOCE SEA and CTD files it represents the quality code assigned by the investigator responsible for the measurement. The quality code from QUALT1 is used as the FLAG_W in exchange files if `QUALT2`_ is not available',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=81.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='QUALT2',
dtype='string',
whp_unit=None,
nc_name='quality_word_two',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='Quality code 2, this is not used in exchange files. In WOCE SEA and CTD files it represents the quality code assigned by an independent data quality evaluator (DQE). When available this is the code used in exchange file FLAG_W columns.',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=82.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='MCHFRM',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='methyl_chloroform',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved methyl chloroform in sea water. The IUPAC name for methyl chloroform is 1,1,1-Trichloroethane.',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=83.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='IODATE',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='iodate',
flag_w='woce_discrete',
cf_name=None,
numeric_min=200.0,
numeric_max=600.0,
numeric_precision=3,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=29,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=84.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='IODIDE',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='iodide',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.0,
numeric_max=300.0,
numeric_precision=3,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=29,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=85.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CHLORA',
dtype='decimal',
whp_unit='UG/KG',
nc_name='chlorophyll_a_ug_kg',
flag_w='woce_discrete',
cf_name='mass_fraction_of_chlorophyll_a_in_sea_water',
numeric_min=0.0,
numeric_max=9.0,
numeric_precision=2,
field_width=9,
description='chlorophyll-a. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms. Chlorophyll-a is the most commonly occurring form of natural chlorophyll. The chemical formula of chlorophyll-a is C55H72O5N4Mg.',
note=None,
warning=None,
error_name=None,
cf_unit='ug/kg',
reference_scale=None,
whp_number=34,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=86.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CHLORA',
dtype='decimal',
whp_unit='UG/L',
nc_name='chlorophyll_a',
flag_w='woce_discrete',
cf_name='mass_concentration_of_chlorophyll_a_in_sea_water',
numeric_min=0.0,
numeric_max=9.0,
numeric_precision=2,
field_width=9,
description='chlorophyll-a. Chlorophylls are the green pigments found in most plants, algae and cyanobacteria; their presence is essential for photosynthesis to take place. There are several different forms of chlorophyll that occur naturally. All contain a chlorin ring (chemical formula C20H16N4) which gives the green pigment and a side chain whose structure varies. The naturally occurring forms of chlorophyll contain between 35 and 55 carbon atoms. Chlorophyll-a is the most commonly occurring form of natural chlorophyll. The chemical formula of chlorophyll-a is C55H72O5N4Mg.',
note=None,
warning=None,
error_name=None,
cf_unit='ug/l',
reference_scale=None,
whp_number=34,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=86.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PPHYTN',
dtype='decimal',
whp_unit='UG/KG',
nc_name='phaeophytin',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Phaeophytin',
note=None,
warning=None,
error_name=None,
cf_unit='ug/kg',
reference_scale=None,
whp_number=35,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=87.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CH3CL',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='methyl_chloride',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Concentration of Methyl Chloride',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=88.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CH4',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='methane',
flag_w='woce_discrete',
cf_name=None,
numeric_min=1.0,
numeric_max=20.0,
numeric_precision=2,
field_width=9,
description='Methane',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=31,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=89.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DMS',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='dimethyl_sulfide',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='The chemical formula for dimethyl sulfide is (CH3)2S. Dimethyl sulfide is sometimes referred to as DMS.',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=90.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='N2',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='nitrogen',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved elemental nitrogen gas (N2) in sea water.',
note=None,
warning=None,
error_name='N2_ERROR',
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=91.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CALCIUM',
dtype='decimal',
whp_unit='MMOL/KG',
nc_name='calcium',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=5,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='mmol kg-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=92.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ARGON',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='argon',
flag_w='woce_discrete',
cf_name=None,
numeric_min=5.0,
numeric_max=25.0,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name='ARGONER',
cf_unit='umol/kg',
reference_scale=None,
whp_number=15,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=93.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='14C-DOC',
dtype='decimal',
whp_unit='/MILLE',
nc_name='dissolved_organic_carbon_14',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-1000.0,
numeric_max=100.0,
numeric_precision=1,
field_width=9,
description='Enrichment of :sup:`14`\\ C vs :sup:`12`\\ C in DOC compared to a reference standard usually VPDB. This ratio has been corrected for isotopic fractionation and is usually written as upper case delta Δ\\ :sup:`14`\\ C.',
note=None,
warning=None,
error_name='14C-DOCERR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=94.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D15N_NO3',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d15n_no3',
flag_w='woce_discrete',
cf_name=None,
numeric_min=-5.0,
numeric_max=30.0,
numeric_precision=1,
field_width=9,
description='Enrichment of the 15N/14N isotopic ratio of dissolved nitrate',
note=None,
warning=None,
error_name='D15N_NO3_ERROR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='UREA',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='urea',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Urea has the chemical formula CO(NH\\ :sub:`2`)\\ :sub:`2`',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=96.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TOT_CHL_A',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_tot_chl_a',
flag_w='woce_discrete',
cf_name='mass_concentration_of_chlorophyll_a_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Total chlorophyll a measured using HPLC\n\nSeaBass Description:HPLC  DV_Chl_a + MV_Chl_a + Chlide_a + Chl_a_allom + Chl_a_prime',
note='A different measurement than `CHLORA`_',
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=97.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TOT_CHL_B',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_tot_chl_b',
flag_w='woce_discrete',
cf_name='mass_concentration_of_chlorophyll_b_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC  DV_Chl_b + MV_Chl_b',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=98.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TOT_CHL_C',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_tot_chl_c',
flag_w='woce_discrete',
cf_name='mass_concentration_of_chlorophyll_c_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC chl_c1 + chl_c2 (chl_c1c2) + chl_c3',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=99.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ALPHA-BETA-CAR',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_alpha_beta_carotenes',
flag_w='woce_discrete',
cf_name='mass_concentration_of_carotene_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Alpha (Beta,epsilon) + Beta (Beta,beta) Carotenes',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=100.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BUT-FUCO',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_19butanoyloxyfucoxanthin',
flag_w='woce_discrete',
cf_name='mass_concentration_of_19_butanoyloxyfucoxanthin_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description="HPLC 19'-Butanoyloxyfucoxanthin",
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=101.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HEX-FUCO',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_19_hexanoyloxyfucoxanthin',
flag_w='woce_discrete',
cf_name='mass_concentration_of_19_hexanoyloxyfucoxanthin_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description="HPLC 19'-Hexanoyloxyfucoxanthin",
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=102.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ALLO',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_alloxanthin',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Alloxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=103.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DIADINO',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_diadinoxanthin',
flag_w='woce_discrete',
cf_name='mass_concentration_of_diadinoxanthin_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Diadinoxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=104.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DIATO',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_diatoxanthin',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Diatoxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=105.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HFUCO',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_fucoxanthin',
flag_w='woce_discrete',
cf_name='mass_concentration_of_fucoxanthin_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Fucoxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=106.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PERID',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_peridinin',
flag_w='woce_discrete',
cf_name='mass_concentration_of_peridinin_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Peridinin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=107.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ZEA',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_zeaxanthin',
flag_w='woce_discrete',
cf_name='mass_concentration_of_zeaxanthin_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Zeaxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=108.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='MV_CHL_A',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_monovinyl_chlorophyll_a',
flag_w='woce_discrete',
cf_name='mass_concentration_of_monovinyl_chlorophyll_a_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Monovinyl Chlorophyll a',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=109.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DV_CHL_A',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_divinyl_chlorophyll_a',
flag_w='woce_discrete',
cf_name='mass_concentration_of_divinyl_chlorophyll_a_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Divinyl Chlorophyll a',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=110.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CHLIDE_A',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_chlorophyllide_a',
flag_w='woce_discrete',
cf_name='mass_concentration_of_chlorophyllide_a_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Chlorophyllide a',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=111.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='MV_CHL_B',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_monovinyl_chlorophyll_b',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Monovinyl Chlorophyll b',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=112.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DV_CHL_B',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_divinyl_chlorophyll_b',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Divinyl Chlorophyll B',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=113.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CHL_C1C2',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_chlorophyll_c1_c2',
flag_w='woce_discrete',
cf_name='mass_concentration_of_chlorophyll_c1_and_chlorophyll_c2_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Chlorophyll c1 + c2',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=114.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CHL_C3',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_chlorophyll_c3',
flag_w='woce_discrete',
cf_name='mass_concentration_of_chlorophyll_c3_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Chlorophyll c3',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=115.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='LUT',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_lutein',
flag_w='woce_discrete',
cf_name='mass_concentration_of_lutein_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Lutein',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=116.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NEO',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_neoxanthin',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Neoxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=117.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='VIOLA',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_violaxanthin',
flag_w='woce_discrete',
cf_name='mass_concentration_of_violaxanthin_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Violaxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=118.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PHYTIN_A',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_pheophytin_a',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Pheophytin a',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=119.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PHIDE_A',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_pheophorbide_a',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Pheophorbide a',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=120.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PRAS',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_prasinoxanthin',
flag_w='woce_discrete',
cf_name='mass_concentration_of_prasinoxanthin_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Prasinoxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=121.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='GYRO',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_gyroxanthin_diester',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Gyroxanthin-Diester',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=122.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BTL_DATE',
dtype='string',
whp_unit=None,
nc_name='bottle_date',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=8,
description='Date of an individual bottle closure in the same format as `DATE`_, for the canonical reported station date, use `DATE`_',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=123.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BTL_TIME',
dtype='string',
whp_unit=None,
nc_name='bottle_time',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=4,
description='Time of an individual bottle closure in the same format as `TIME`_, for the canonical reported station time, use `TIME`_',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=124.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BTL_LAT',
dtype='decimal',
whp_unit=None,
nc_name='bottle_latitude',
flag_w='no_flags',
cf_name='latitude',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Latitude (ship position) of an individual bottle closure in the same format as `LATITUDE`_, for the canonical reported station latitude, use `LATITUDE`_',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=125.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BTL_LON',
dtype='decimal',
whp_unit=None,
nc_name='bottle_longitude',
flag_w='no_flags',
cf_name='longitude',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Longitude (ship position) of an individual bottle closure in the same format as `LONGITUDE`_, for the canonical reported station longitude, use `LONGITUDE`_',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=126.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDNOBS',
dtype='integer',
whp_unit=None,
nc_name='ctd_number_of_observations',
flag_w='no_flags',
cf_name='number_of_observations',
numeric_min=0.0,
numeric_max=10000.0,
numeric_precision=0,
field_width=9,
description='The number of discrete observations from which the values of another data variable have been derived',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=127.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDETIME',
dtype='decimal',
whp_unit='SECONDS',
nc_name='ctd_elapsed_time',
flag_w='no_flags',
cf_name=None,
numeric_min=0.0,
numeric_max=10000.0,
numeric_precision=4,
field_width=9,
description='The elapsed time of CTD pressure bin',
note=None,
warning=None,
error_name=None,
cf_unit='seconds',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=128.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='INSTRUMENT_ID',
dtype='string',
whp_unit=None,
nc_name='instrument_id',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=9,
description='The serial number of the CTD. In the case of SBE9plus, this is the serial number of the main housing, not the sensors.',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=129.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='THETA',
dtype='decimal',
whp_unit='DEG C',
nc_name='potential_temperature_c',
flag_w='woce_ctd',
cf_name='sea_water_potential_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=4,
field_width=9,
description='Sea water potential temperature is the temperature a parcel of sea water would have if moved adiabatically to sea level pressure.',
note='Typically does not have quality flags.',
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='unknown',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=130.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='THETA',
dtype='decimal',
whp_unit='ITS-90',
nc_name='potential_temperature',
flag_w='woce_ctd',
cf_name='sea_water_potential_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=4,
field_width=9,
description='Sea water potential temperature is the temperature a parcel of sea water would have if moved adiabatically to sea level pressure.',
note='Typically does not have quality flags.',
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='ITS-90',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=130.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='THETA',
dtype='decimal',
whp_unit='IPTS-68',
nc_name='potential_temperature_68',
flag_w='woce_ctd',
cf_name='sea_water_potential_temperature',
numeric_min=-2.0,
numeric_max=35.0,
numeric_precision=4,
field_width=9,
description='Sea water potential temperature is the temperature a parcel of sea water would have if moved adiabatically to sea level pressure.',
note='Typically does not have quality flags.',
warning=None,
error_name=None,
cf_unit='degC',
reference_scale='IPTS-68',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=130.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='OXYGEN',
dtype='decimal',
whp_unit='ML/L',
nc_name='oxygen_ml_l',
flag_w='woce_discrete',
cf_name='volume_fraction_of_oxygen_in_sea_water',
numeric_min=0.0,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='The dissolved oxygen measured in a discrete sample, typically using the Winkler test for dissolved oxygen.',
note=None,
warning=None,
error_name=None,
cf_unit='ml/l',
reference_scale=None,
whp_number=2,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=24.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PPHYTN',
dtype='decimal',
whp_unit='UG/L',
nc_name='phaeophytin_ug_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Phaeophytin',
note=None,
warning=None,
error_name=None,
cf_unit='ug/l',
reference_scale=None,
whp_number=35,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=87.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='AOU',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='apparent_oxygen_utilization',
flag_w='woce_discrete',
cf_name='apparent_oxygen_utilization',
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Apparent Oxygen Utilization (AOU) is the difference between measured dissolved oxygen concentration in water, and the equilibrium saturation concentration of dissolved oxygen in water with the same physical and chemical properties.',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=131.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ARABI',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='arabinose',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Concentration of Arabanose after hydrolysis',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=132.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BACT',
dtype='decimal',
whp_unit='E8/L',
nc_name='bacterial_cell_count',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Cell count of non pigmented heterotrophic bacterioplankton through FCM',
note=None,
warning=None,
error_name=None,
cf_unit='1e8 l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=133.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SYN',
dtype='decimal',
whp_unit='E6/L',
nc_name='synechococcus_cell_count',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Synechococcus Cell Count',
note=None,
warning=None,
error_name=None,
cf_unit='1e6 l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=134.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PEUK',
dtype='decimal',
whp_unit='E6/L',
nc_name='picoeukaryote_cell_counts',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Pigmented Picoeukaryotes cell count',
note=None,
warning=None,
error_name=None,
cf_unit='1e6 l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=135.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PROC',
dtype='decimal',
whp_unit='E7/L',
nc_name='prochlorophyte_cell_count',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Prochlorophyte Cell Count',
note=None,
warning=None,
error_name=None,
cf_unit='1e7 l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=136.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BLACKC',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='black_carbon',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Black carbon (e.g. soot) concentration',
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=137.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BRDU',
dtype='decimal',
whp_unit='PMOL/L/H',
nc_name='brdu_uptake',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Bacterial Production via BrdU (Bromodeoxyuridine\n) uptake Method',
note=None,
warning=None,
error_name=None,
cf_unit='pmol l-1 h-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=138.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CH3BR',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='methyl_bromide',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Concentration of Methyl Bromide',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=139.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CH3I',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='methyl_iodide',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Concentration of Methyl Iodide',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=140.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DCNS',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='dcns',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='Dissolved Combined Neutral Sugars',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=141.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DELO17',
dtype='decimal',
whp_unit='/MILLE',
nc_name='del_oxygen_17',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Enrichment of the 17O/16O isotopic ratio of the sea water itself compared to VSMOW (Vienna Standard Mean Ocean Water).',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=60.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='FCO2IN',
dtype='decimal',
whp_unit='UATM',
nc_name='fco2_in_situ',
flag_w='woce_discrete',
cf_name='fugacity_of_carbon_dioxide_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='In situ fugacity of CO2 gas',
note='Usually calcualted',
warning=None,
error_name=None,
cf_unit='uatm',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=37.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='FUCO',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='fucose',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Concentration of Fucose after hydrolyses',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=143.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='GALA',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='galactose',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Concentration of Galactose after hydrolysis',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=144.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='GLUC',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='glucose',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Concentration of Glucose after hydrolysis',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=145.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='LAB_DEN',
dtype='decimal',
whp_unit='KG/M^3',
nc_name='density',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Density measured in a lab, not calcualted from temperature, salinity, and pressure',
note=None,
warning=None,
error_name=None,
cf_unit='kg m-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=146.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='MAN',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='mannose',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Concentration of Mannose after hydrolysis',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=145.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PIGMENTS',
dtype='decimal',
whp_unit=None,
nc_name='pigments',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='Phytoplankton pigments',
note='This is almost always a placeholder for samples collected for HPLC analysis later, the results of which are published at NASA SeaBASS',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=147.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='RHAM',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='rhamnose',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Concetration of Rhamnose after hydrolysis',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=145.7,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SALTREF',
dtype='decimal',
whp_unit='G/KG',
nc_name='reference_salinity',
flag_w='woce_discrete',
cf_name='sea_water_reference_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='Salinity reported on the Reference-Composition Salinity Scale, reported in units of "absolute salinity" (g/kg). If a sea water sample has the Reference Composition (defined in Millero et al., 2008), then its Reference Salinity is the best available estimate of its Absolute Salinity. For general purposes, Reference Salinity is (35.16504 g kg-1)/35 times Practical Salinity. Reference: www.teos-10.org; Millero et al., 2008 doi: 10.1016/j.dsr.2007.10.001. ',
note='See "The composition of Standard Seawater and the definition of the Reference-Composition Salinity Scale" by Millero et. al (2007) 10.1016/j.dsr.2007.10.001',
warning=None,
error_name=None,
cf_unit='g/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=148.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SF5CF3',
dtype='decimal',
whp_unit='FMOL/KG',
nc_name='trifluoromethylsulfur_pentafluoride',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Concentration of Trifluoromethyl Sulfur Pentafluoride',
note=None,
warning=None,
error_name=None,
cf_unit='fmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=149.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DWNPRS',
dtype='decimal',
whp_unit='DBAR',
nc_name='downcast_pressure',
flag_w='woce_ctd',
cf_name='sea_water_pressure',
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Pressure on the downcast for the same isopycnal as the upcast',
note=None,
warning=None,
error_name=None,
cf_unit='dbar',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=150.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SIG0',
dtype='decimal',
whp_unit='KG/M^3',
nc_name='sigma0',
flag_w='woce_ctd',
cf_name='sea_water_sigma_theta',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Potential density anomaly referenced to 0 dbar (ocean surface)',
note=None,
warning=None,
error_name=None,
cf_unit='kg m-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=152.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SOMSAL',
dtype='decimal',
whp_unit='PSS-78',
nc_name='somma_salinity',
flag_w='woce_discrete',
cf_name='sea_water_practical_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='Salinity measured by a Single-Operator Multiparameter Metabolic Analyzer (SOMMA), used in sea water CO2 analysis',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale='PSS-78',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=153.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DWNOXY',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='downcast_oxygen',
flag_w='woce_ctd',
cf_name='moles_of_oxygen_per_unit_mass_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='CTD Oxygen on the downcast for the same isopycnal as the upcast',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=151.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDCT',
dtype='decimal',
whp_unit='ITS-90',
nc_name='ctd_conservative_temperature',
flag_w='woce_ctd',
cf_name='sea_water_conservative_temperature',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Conservative temperature calcualted using TEOS-10',
note=None,
warning='This is provided as a convienence, the TEOS-10 manual strongly recomends against including this in observational data.',
error_name=None,
cf_unit='degC',
reference_scale='ITS-90',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=19.6,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDSA',
dtype='decimal',
whp_unit='G/KG',
nc_name='ctd_absolute_salinity',
flag_w='woce_ctd',
cf_name='sea_water_absolute_salinity',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Absolute salinity calculated using TEOS-10',
note=None,
warning='This is provided as a convienence, the TEOS-10 manual strongly recomends against including this in observational data.',
error_name=None,
cf_unit='g/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=19.3,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HPLC',
dtype='string',
whp_unit=None,
nc_name='hplc_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='High-performance liquid chromatography',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning='These data do not get submitted to CCHDO, most are sent to NASA SeaBASS',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D15N_NO2+NO3',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d15n_nitrite_nitrate',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Ratio of 15N to 14N of nitrite+nitrate in the sample vs the ratio of 15N to 14N in a reference standard (VMSOW)',
note=None,
warning=None,
error_name='D15N_NO2+NO3_ERROR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D18O_NO2+NO3',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d18o_nitrite_nitrate',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Ratio of 18O to 16O of nitrite+nitrate in the sample vs the ratio of 18O to 16O of a reference standard (VMSOW)',
note=None,
warning=None,
error_name='D18O_NO2+NO3_ERROR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.75,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='MICROGELS',
dtype='decimal',
whp_unit='1E6 GELS/L',
nc_name='microgel_abundance',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Count of microgels per liter (abundance). Microgels are small organic particles formed by self-assembly and ionic bridging between organic macromolecules.',
note=None,
warning=None,
error_name=None,
cf_unit='1e6 l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=155.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CS-137',
dtype='decimal',
whp_unit='BQ/M^3',
nc_name='cesium_137_bq',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Activity of 137Cs in seawater',
note='units are disintegrations per minute per 100kg',
warning=None,
error_name='CS137ER',
cf_unit='Bq m-3',
reference_scale=None,
whp_number=22,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=76.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PLUTO',
dtype='decimal',
whp_unit='MBQ/M^3',
nc_name='plutonium',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Plutonium decay rate from all isotopes',
note=None,
warning=None,
error_name='PLUTOER',
cf_unit='mBq m-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=70.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='N2/ARGON',
dtype='decimal',
whp_unit=None,
nc_name='n2_argon_ratio',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Ratio of dissolved elemental nitrogen to dissolved argon',
note=None,
warning=None,
error_name='N2/ARGON_ERROR',
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=156.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='N2/ARGON_UNSTRIPPED',
dtype='decimal',
whp_unit=None,
nc_name='n2_argon_ratio_unstripped',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Ratio of dissolved elemental nitrogen to dissolved argon that has not been stripped of dissolved oxygen',
note='This is still fundamentally an N2/ARGON measurement and is a variation on an analytical technique. If following the corrections described in Charoenpong et al 2014 (DOI: 10.4319/lom.2014.12.323) then this should be comparable with any other N2/ARGON measurement but have a slightly larger uncertainty.',
warning=None,
error_name='N2/ARGON_UNSTRIPPED_ERROR',
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=156.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D15N_N2',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d15n_n2',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Enrichment of the 15N/14N isotopic ratio of dissolved elemental nitrogen. The usual reference material is the atmosphere of Earth (AIR).',
note=None,
warning=None,
error_name='D15N_N2_ERROR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=157.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='13C-DOC',
dtype='decimal',
whp_unit='/MILLE',
nc_name='dissolved_organic_carbon_13',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Enrichment of :sup:`13`\\ C vs :sup:`12`\\ C in DOC compared to a reference standard usually VPDB. This is usually written as lower case delta δ\\ :sup:`13`\\ C.',
note=None,
warning=None,
error_name='13C-DOCERR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=94.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D18O_NO3',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d18o_nitrate',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Ratio of 18O to 16O of nitrate in the sample vs the ratio of 18O to 16O of a reference standard (VMSOW)',
note=None,
warning=None,
error_name='D18O_NO3_ERROR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.76,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDOXY',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='ctd_oxygen_umol_l',
flag_w='woce_ctd',
cf_name='mole_concentration_of_dissolved_molecular_oxygen_in_sea_water',
numeric_min=0.0,
numeric_max=500.0,
numeric_precision=1,
field_width=9,
description='The corrected oxygen measured by the CTD.',
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=23.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SAMPLING_RATE',
dtype='decimal',
whp_unit='HZ',
nc_name='ctd_sampling_rate',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='The sampling rate of the CTD',
note=None,
warning=None,
error_name=None,
cf_unit='1/s',
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=129.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='EVENT_NUMBER',
dtype='decimal',
whp_unit=None,
nc_name='event_number',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='Non program specific event number. Some cruises or programs keep track of sequential events that occur on a cruise or across multiple cruises of the same program. There exists program specific event number names of GEOTR_EVENT, BIONBR, and BIOS_CASTID that should be used if they are more appropriate.',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=9.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDNITRATE',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='ctd_nitrate',
flag_w='woce_ctd',
cf_name='moles_of_nitrate_per_unit_mass_in_sea_water',
numeric_min=9.0,
numeric_max=47.0,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved nitrate in sea water measured by an in situ sensor. The chemical formula for the nitrate anion is NO3-.',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=4,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=27.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PAR',
dtype='decimal',
whp_unit='VOLTS',
nc_name='par_raw',
flag_w='woce_ctd',
cf_name=None,
numeric_min=0.0,
numeric_max=5.0,
numeric_precision=4,
field_width=9,
description='Photosynthetically active radiation. The downwelling photon flux of photons with a wavelength between 400nm and 700nm.',
note=None,
warning=None,
error_name=None,
cf_unit='volts',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDTURB',
dtype='decimal',
whp_unit='FTU',
nc_name='ctd_turbidity_ftu',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Turbidity describes the light scattered back (or passed though depending on units) depending on particle loading in the water. It is a dimensionless quantity.',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDTURB',
dtype='decimal',
whp_unit='NTU',
nc_name='ctd_turbidity_ntu',
flag_w='woce_ctd',
cf_name='sea_water_turbidity',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Turbidity describes the light scattered back (or passed though depending on units) depending on particle loading in the water. It is a dimensionless quantity.',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='POC',
dtype='decimal',
whp_unit='UG/L',
nc_name='particulate_organic_carbon_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Particulate organic carbon',
note=None,
warning=None,
error_name=None,
cf_unit='ug/l',
reference_scale=None,
whp_number=40,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=55.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PON',
dtype='decimal',
whp_unit='UG/L',
nc_name='particulate_organic_nitrogen_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Particulate organic nitrogen',
note=None,
warning=None,
error_name=None,
cf_unit='ug/l',
reference_scale=None,
whp_number=41,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DNA',
dtype='string',
whp_unit=None,
nc_name='dna_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='Genetic analysis',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning='These data to not get submitted to CCHDO',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='POP',
dtype='decimal',
whp_unit='UG/L',
nc_name='particulate_organic_phosphorus_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Particulate organic phosphorus',
note=None,
warning=None,
error_name=None,
cf_unit='ug/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PCOD',
dtype='decimal',
whp_unit='UG/L',
nc_name='particulate_chemical_oxygen_demand_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Patriculate chemical oxygen demand',
note=None,
warning=None,
error_name=None,
cf_unit='ug/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='FCM',
dtype='string',
whp_unit=None,
nc_name='flow_cytometry_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='Flow Cytometry',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning='These data to not get submitted to CCHDO',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='O2/AR',
dtype='decimal',
whp_unit=None,
nc_name='o2_ar',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Oxygen to Argon radtio',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=158.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SIP',
dtype='string',
whp_unit=None,
nc_name='stable_isotope_probing_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='Stable isotope probing.\n\nThis describes samples taken for an uptake analysis which introduces stable isotopes and measures their uptake over a period of time.',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.3,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TOC',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='total_organic_carbon_l',
flag_w='woce_discrete',
cf_name='mole_concentration_of_dissolved_organic_carbon_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=54.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NO2+NO3',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='nitrite_nitrate_l',
flag_w='woce_discrete',
cf_name='mole_concentration_of_nitrate_and_nitrite_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved nitrate plus nitrite in sea water. The chemical formula for the nitrite anion is NO2-.',
note='Most modern techniques for determining dissolved nitrate return a value of nitrate (NO3) plus nitrite (NO2). A separate determination is then done for nitrite and the result subtracted by the data originator to obtain nitrate. If no separate nitrite determination was carried out - or in rare cases the nitrite number was not subtracted - data providers should list the result as NO2+NO3. Because nitrite values are in most regions small compared to nitrate, most data users will not adversely affect their results by relabeling NO2+NO3 as NITRAT.',
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=30.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PHSPHT',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='phosphate_l',
flag_w='woce_discrete',
cf_name='mole_concentration_of_phosphate_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved phosphate in sea water. The chemical formula for the phosphate anion is PO4.',
note=None,
warning=None,
error_name='PHPUNC',
cf_unit='umol l-1',
reference_scale=None,
whp_number=6,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=29.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PH',
dtype='decimal',
whp_unit=None,
nc_name='ph_unknown_scale',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='The measure of acidity of seawater reported on an unknown scale',
note=None,
warning='The reporting scale is not known. Use caution when comparing this pH to any other pH',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=26,
scope='sample',
analytical_temperature_name='PH_TMP',
analytical_temperature_units='DEG C',
rank=41.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='XCO2',
dtype='decimal',
whp_unit='PPM',
nc_name='co2_mole_fraction',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='The mole fraction of CO2 in air, wet or dry is unknown.',
note=None,
warning='This parameter was added because we found several cruises with "PCO2" reported as ppm. The only notes that could we could find where questioning if the values were "wet" or "dry", which is wondering if pH2O was taken into account. XCO2 as a name was taken from the definition of CO2 expressed as PPM in CO2SYS V25.\n\nUse caution if you are trying to compare this parameter to other (p/f/x)CO2 data',
error_name=None,
cf_unit='1e-6',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=39.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SMDEPTH',
dtype='decimal',
whp_unit='METERS',
nc_name='sm_depth',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Depth calculated from pressure using the Saunders-Mantyla method. \n\nIn the ODF software this is cited as follows:\n\nSaunders, P. M., 1981. Practical Conversion of Pressure to Depth. Journal of Physical Oceanography 11, 573-574.\nMantyla, A. W., 1982-1983. Private correspondence.\n',
note=None,
warning=None,
error_name=None,
cf_unit='meters',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=159.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='FMDEPTH',
dtype='decimal',
whp_unit='METERS',
nc_name='fm_depth',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Depth calculated from pressure using the Fofonoff and Millard method, also known as the UNESCO 1983 formula',
note=None,
warning=None,
error_name=None,
cf_unit='meters',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=159.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDCDOM',
dtype='decimal',
whp_unit='QSU',
nc_name='ctd_cdom',
flag_w='woce_ctd',
cf_name='concentration_of_colored_dissolved_organic_matter_in_sea_water_expressed_as_equivalent_mass_fraction_of_quinine_sulfate_dihydrate',
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='In situ CDOM measured via a uv fluorometer',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.6,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDCDOM',
dtype='decimal',
whp_unit='VOLTS',
nc_name='ctd_cdom_raw',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='In situ CDOM measured via a uv fluorometer',
note=None,
warning=None,
error_name=None,
cf_unit='volts',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.6,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='KRYPTON',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='krypton',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved krypton gas in seawater',
note=None,
warning=None,
error_name='KRYPTONER',
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=146.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='KRYPTON',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='krypton_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved krypton gas in seawater',
note=None,
warning=None,
error_name='KRYPTONER',
cf_unit='nmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=146.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='XENON',
dtype='decimal',
whp_unit='NMOL/KG',
nc_name='xenon',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved xenon gas in sea water',
note=None,
warning=None,
error_name='XENONER',
cf_unit='nmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=146.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='XENON',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='xenon_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved xenon gas in sea water',
note=None,
warning=None,
error_name='XENONER',
cf_unit='nmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=146.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BTLNBR_U',
dtype='integer',
whp_unit=None,
nc_name='user_bottle_number',
flag_w='woce_bottle',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='User convienence bottle number, unlike the canonical BTLNBR param, this one must be an integer (so the NBR part of the name makse sense)',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=1001.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='STNNBR_U',
dtype='integer',
whp_unit=None,
nc_name='user_station_number',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='User convienence statio number, unlike the canonical STNNBT param, this one must be an integer (so the NBR part of the name makse sense)',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=999.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SILCAT',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='silicate_l',
flag_w='woce_discrete',
cf_name='mole_concentration_of_silicate_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='The concentration of dissolved silicate in sea water.',
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=3,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=25.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDDEPTH',
dtype='decimal',
whp_unit='METERS',
nc_name='package_depth',
flag_w='woce_ctd',
cf_name='depth',
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='The calcualted depth of the CTD itself for this pressure level',
note=None,
warning='DEPTH without the CTD prefix is the distance to the sea floor.',
error_name=None,
cf_unit='meters',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=124.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ODF_CTDPRS',
dtype='decimal',
whp_unit='DBAR',
nc_name='odf_pressure',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='The pressure as corrected by ODF acquisition software. It will often be equivalent to the reported CTDPRS value. When ODF_CTDPRS is present in a datafile, the CTDPRS value came from the instrument manufacturers acquisition software.',
note=None,
warning=None,
error_name=None,
cf_unit='dbar',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=124.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SAMPNO_U',
dtype='integer',
whp_unit=None,
nc_name='user_sample_number',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='User convienence sample number, unlike the canonical SAMPNO param, this one must be an integer (so the NO part of the name makse sense)',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=1000.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CDOMSL',
dtype='decimal',
whp_unit='1/NM',
nc_name='cdomsl',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.01,
numeric_max=0.04,
numeric_precision=4,
field_width=9,
description='Log spectral slope of absorption spectrum (320-400 nm) computed by linear regression of log-transformed data',
note=None,
warning=None,
error_name=None,
cf_unit='1/nm',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.98,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CDOMSN',
dtype='decimal',
whp_unit='1/NM',
nc_name='cdomsn',
flag_w='woce_discrete',
cf_name=None,
numeric_min=0.01,
numeric_max=0.04,
numeric_precision=4,
field_width=9,
description='Log spectral slope if absorption spectrum (320-400 nm) computed by non-linear curve fit',
note=None,
warning=None,
error_name=None,
cf_unit='1/nm',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.99,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CDOM325',
dtype='decimal',
whp_unit='/METER',
nc_name='cdom325',
flag_w='woce_discrete',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Attenuation coefficient of the sample at 325nm',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.01,
radiation_wavelength=325.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group='cdom',
),
WHPNameDC(
whp_name='CDOM340',
dtype='decimal',
whp_unit='/METER',
nc_name='cdom340',
flag_w='woce_discrete',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Attenuation coefficient of the sample at 340nm',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.02,
radiation_wavelength=340.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group='cdom',
),
WHPNameDC(
whp_name='CDOM380',
dtype='decimal',
whp_unit='/METER',
nc_name='cdom380',
flag_w='woce_discrete',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Attenuation coefficient of the sample at 380nm',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.03,
radiation_wavelength=380.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group='cdom',
),
WHPNameDC(
whp_name='CDOM412',
dtype='decimal',
whp_unit='/METER',
nc_name='cdom412',
flag_w='woce_discrete',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Attenuation coefficient of the sample at 412nm',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.04,
radiation_wavelength=412.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group='cdom',
),
WHPNameDC(
whp_name='CDOM443',
dtype='decimal',
whp_unit='/METER',
nc_name='cdom443',
flag_w='woce_discrete',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Attenuation coefficient of the sample at 442nm',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.05,
radiation_wavelength=443.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group='cdom',
),
WHPNameDC(
whp_name='CDOM490',
dtype='decimal',
whp_unit='/METER',
nc_name='cdom490',
flag_w='woce_discrete',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Attenuation coefficient of the sample at 490nm',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.06,
radiation_wavelength=490.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group='cdom',
),
WHPNameDC(
whp_name='CDOM555',
dtype='decimal',
whp_unit='/METER',
nc_name='cdom555',
flag_w='woce_discrete',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Attenuation coefficient of the sample at 555nm',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.07,
radiation_wavelength=555.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group='cdom',
),
WHPNameDC(
whp_name='DELSI30',
dtype='decimal',
whp_unit='/MILLE',
nc_name='delsi30',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Enrichment of the 30Si/28Si isotopic ratio in silica relative to NBS28',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=60.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='IMAGES',
dtype='string',
whp_unit=None,
nc_name='image_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='Imaging; for example a FlowCam',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.4,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='VIRAL_ABUNDANCE',
dtype='string',
whp_unit=None,
nc_name='viral_abundance_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='Placeholder parameter for a viral abundance analysis',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.5,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDOPTOXY',
dtype='decimal',
whp_unit='VOLTS',
nc_name='ctd_optode_oxygen_raw',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='In situ oxygen from an oxygen optode',
note='This parameter was common when optodes were newer. Today this is often just reported as CTDOXY.',
warning=None,
error_name=None,
cf_unit='volts',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=23.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDOPTOXY',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='ctd_optode_oxygen',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='In situ oxygen from an oxygen optode',
note='This parameter was common when optodes were newer. Today this is often just reported as CTDOXY.',
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=23.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDBETA700',
dtype='decimal',
whp_unit='VOLTS',
nc_name='ctd_beta700_raw',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Volume scattering function at 700nm. Depends on scattering angle.\n\n\nBoss, E.B. and N. Haëntjens, 2016. Primer regarding measurements of \r\nchlorophyll fluorescence and the backscattering coefficient with WETLabs FLBB \r\non profiling floats. SOCCOM Tech. Rep. 2016-1. \r\nhttps://soccom.princeton.edu/sites/default/files/files/SOCCOM_2016-1_Bio-optics-primer.pdf\n',
note=None,
warning='This paramter is the bacscattering function (Beta) it is NOT the backscattering coefficient due to particles commonly called Bbp',
error_name=None,
cf_unit='volts',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.1,
radiation_wavelength=700.0,
scattering_angle=140.0,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDBETA700',
dtype='decimal',
whp_unit='M^-1/SR',
nc_name='ctd_beta700',
flag_w='woce_ctd',
cf_name='volume_scattering_function_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Volume scattering function at 700nm. Depends on scattering angle.\n\n\nBoss, E.B. and N. Haëntjens, 2016. Primer regarding measurements of \r\nchlorophyll fluorescence and the backscattering coefficient with WETLabs FLBB \r\non profiling floats. SOCCOM Tech. Rep. 2016-1. \r\nhttps://soccom.princeton.edu/sites/default/files/files/SOCCOM_2016-1_Bio-optics-primer.pdf\n',
note=None,
warning='This paramter is the bacscattering function (Beta) it is NOT the backscattering coefficient due to particles commonly called Bbp',
error_name=None,
cf_unit='m-1 sr-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.1,
radiation_wavelength=700.0,
scattering_angle=140.0,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CTDBBP700',
dtype='decimal',
whp_unit='/METER',
nc_name='ctd_bbp700',
flag_w='woce_ctd',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Volume scattering coefficient due to particles at 700nm.\n\n\nBoss, E.B. and N. Haëntjens, 2016. Primer regarding measurements of \r\nchlorophyll fluorescence and the backscattering coefficient with WETLabs FLBB \r\non profiling floats. SOCCOM Tech. Rep. 2016-1. \r\nhttp://soccom.princeton.edu/sites/default/files/files/SOCCOM_2016-1_Bio-optics\x02primer.pdf.\n',
note=None,
warning='This paramter is the bacscattering coefficient due to particles (Bbp) it is NOT the backscattering function called Beta',
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.2,
radiation_wavelength=700.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CCL4',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='carbon_tetrachloride_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Dissolved carbon tetrachloride',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=28,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=61.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HCFC-141b',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='dichlorofluoroethane',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved HCFC-141b in sea water. The chemical formula of HCFC-141b is C2H3Cl2F. The IUPAC name for HCFC-141b is 1,1-Dichloro-1-fluoroethane.',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=33.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HCFC-142b',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='chlorodifluoroethane',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved HCFC-142b in sea water. The chemical formula of HCFC-142b is  CH3CClF2. The IUPAC name for HCFC-142b is 1-Chloro-1,1-difluoroethane.',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=33.3,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HCFC-22',
dtype='decimal',
whp_unit='PMOL/KG',
nc_name='chlorodifluoromethane',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved HCFC-22 in sea water. The chemical formula of HCFC-22 is CHClF2. The IUPAC name for HCFC-22 is Chloro(difluoro)methane.',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=33.4,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CH4',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='methane_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Methane',
note=None,
warning=None,
error_name=None,
cf_unit='nmol/l',
reference_scale=None,
whp_number=31,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=89.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CS-137',
dtype='decimal',
whp_unit='MBQ/KG',
nc_name='cesium_137_bq_kg',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Activity of 137Cs in seawater',
note='units are disintegrations per minute per 100kg',
warning=None,
error_name='CS137ER',
cf_unit='mBq kg-1',
reference_scale=None,
whp_number=22,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=76.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CS-134',
dtype='decimal',
whp_unit='BQ/M^3',
nc_name='cesium_134_bq',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Activity of 134Cs in seawater',
note=None,
warning=None,
error_name='CS134ER',
cf_unit='Bq m-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=76.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CS-134',
dtype='decimal',
whp_unit='MBQ/KG',
nc_name='cesium_134_bq_kg',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Activity of 134Cs in seawater',
note=None,
warning=None,
error_name='CS134ER',
cf_unit='mBq kg-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=76.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='LINE',
dtype='string',
whp_unit=None,
nc_name='line_id',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='A transect line identifier, examples include CalCOFI Lines or an id assigned to the lines of a cruise doing grid type work',
note=None,
warning='Use the SECT_ID parameter for WOCE/GO-SHIP section ids',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='profile',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=2.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PH_NBS',
dtype='decimal',
whp_unit=None,
nc_name='ph_nbs',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='The measure of acidity of seawater on the NBS standard pH scale',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=26,
scope='sample',
analytical_temperature_name='PH_TMP',
analytical_temperature_units='DEG C',
rank=41.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PHYTOP',
dtype='decimal',
whp_unit='1/ML',
nc_name='phytoplankton_cell_count',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='Count of phytoplankton',
note=None,
warning=None,
error_name=None,
cf_unit='ml-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=161.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CYANB',
dtype='decimal',
whp_unit='1/ML',
nc_name='cyanobacteria_cell_count',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='Count of cyanobacteria',
note=None,
warning=None,
error_name=None,
cf_unit='ml-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=160.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DELD',
dtype='decimal',
whp_unit='/MILLE',
nc_name='del_deuterium',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Enrichment of deuterium of the sea water itself compared to VSMOW',
note=None,
warning=None,
error_name='DELDERR',
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=60.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BEAMAP',
dtype='decimal',
whp_unit='/METER',
nc_name='beamap',
flag_w='woce_discrete',
cf_name='volume_absorption_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Volume beam absorption in sea water',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=74.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='LDEO_SAMPNO',
dtype='integer',
whp_unit=None,
nc_name='ldeo_sample_number',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='Sample number used internally by LDEO',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=1001.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='FDOM',
dtype='decimal',
whp_unit='RFU',
nc_name='fdom',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='In lab measured Fluorescent dissolved organic matter',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=44.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CDOM300',
dtype='decimal',
whp_unit='/METER',
nc_name='cdom300',
flag_w='woce_discrete',
cf_name='volume_beam_attenuation_coefficient_of_radiative_flux_in_sea_water',
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='Attenuation coefficient of the sample at 300nm',
note=None,
warning=None,
error_name=None,
cf_unit='m^-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.001,
radiation_wavelength=300.0,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group='cdom',
),
WHPNameDC(
whp_name='RIANOMALY',
dtype='decimal',
whp_unit='ND',
nc_name='refractive_index_anomaly',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Refractive indxe anomanly from pure water. Typically reported at the sodium D lines of 589.6 nm and 589.0nm',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=21.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DELN15',
dtype='decimal',
whp_unit='/MILLE',
nc_name='del_nitrogen_15',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Enrichment of the N15/N14 isotopic ratio when compared to the atmosphere',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=60.3,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BNLID',
dtype='integer',
whp_unit=None,
nc_name='bnlid',
flag_w='no_flags',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=11,
description='Brookhaven National Laboratory Identification bottle number',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=1002.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='BARIUM',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='barium_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/l',
reference_scale=None,
whp_number=39,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=64.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HELIUM',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='helium_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/l',
reference_scale=None,
whp_number=10,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=46.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='NEON',
dtype='decimal',
whp_unit='NMOL/L',
nc_name='neon_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='nmol/l',
reference_scale=None,
whp_number=17,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=59.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ARGON',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='argon_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=15,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=93.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='HE3_HE4_RATIO',
dtype='decimal',
whp_unit=None,
nc_name='he3_he4_ratio',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Ratio of the stable isotopes of Helium-3 to Helium-4 that are dissolved in seawater',
note=None,
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=900.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Nd_143_D_EPSILON_BOTTLE',
dtype='decimal',
whp_unit='10000',
nc_name='nd_143_d_epsilon_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Atom ratio of dissolved Nd isotopes expressed in conventional notation',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='1e4',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=901.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='La_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='la_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Lanthanum in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=902.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Ce_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='ce_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Cerium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=903.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Pr_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='pr_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Praseodymium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=904.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Sm_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='sm_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Samarium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=905.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Eu_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='eu_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Europium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=906.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Gd_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='gd_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Gadolinium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=907.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Tb_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='tb_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Terbium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=908.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Dy_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='dy_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Dysprosium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=909.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Ho_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='ho_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Holmium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=910.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Er_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='er_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Erbium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=911.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Tm_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='tm_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Thulium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=912.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Yb_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='yb_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved Ytterbium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=913.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='Lu_D_CONC_BOTTLE',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='lu_d_conc_bottle',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissovled Lutetium in a discrete bottle sample',
note='For maximum data reusability, we decided to use GEOTRACES naming conventions',
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=914.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PON',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='particulate_organic_nitrogen_mol',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='Particulate organic nitrogen',
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=41,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DOP',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='dissolved_organic_phosphorus',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissolved organic phosphorus',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TDP',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='total_dissolved_phosphorus_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Total dissolved phosphorus, includes organic and inorganic',
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='POP',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='particulate_organic_phosphorus',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Particulate organic phosphorus',
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DATP',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='dissolved_atp',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Dissovled adenosine triphosphate',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.3,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='PATP',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='particulate_atp',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='particulate adenosine triphosphate',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.4,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CELLCOUNT',
dtype='decimal',
whp_unit='/L',
nc_name='cellcount',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='Count of all organic cells in a discerete sample',
note=None,
warning=None,
error_name=None,
cf_unit='l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=133.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DOC_NASA',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='dissolved_organic_carbon_nasa',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Disolved organic carbon as measured by the NASA group and not the normal GO-SHIP one',
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=44.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ANTH',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hpld_antheraxanthin',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Antheraxanthin',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=103.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CHL_C2',
dtype='decimal',
whp_unit='MG/M^3',
nc_name='hplc_chlorophyll_c2',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='HPLC Chlorophyll c2',
note=None,
warning=None,
error_name=None,
cf_unit='mg/m^3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=114.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SPAR',
dtype='decimal',
whp_unit='VOLTS',
nc_name='spar_raw',
flag_w='woce_ctd',
cf_name=None,
numeric_min=0.0,
numeric_max=5.0,
numeric_precision=4,
field_width=9,
description='Surfance reference for PAR, usually mounted on the top of the ship with a shield to block upwelling light. The downwelling photon flux of photons with a wavelength between 400nm and 700nm.',
note=None,
warning=None,
error_name=None,
cf_unit='volts',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D15N_NO2',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d15n_no2',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Enrichment of the 15N/14N isotopic ratio of dissolved nitrite',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D15N_NH4',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d15n_nh4',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Enrichment of the 15N/14N isotopic ratio of dissolved ammonium',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D15N_N2O',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d15n_n2o',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Enrichment of the 15N/14N isotopic ratio of dissolved nitrus oxide',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.3,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D15N_PON',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d15n_pon',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=1,
field_width=9,
description='Enrichment of the 15N/14N isotopic ratio of particualte organic nitrogen',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.6,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D18O_NO2',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d18o_nitrite',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Ratio of 18O to 16O of nitrite in the sample vs the ratio of 18O to 16O of a reference standard (VMSOW)',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.77,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D18O_N2O',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d18o_nitrust_oxide',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Ratio of 18O to 16O of nitrus oxide in the sample vs the ratio of 18O to 16O of a reference standard (VMSOW)',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=95.78,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TDP',
dtype='decimal',
whp_unit='UMOL/KG',
nc_name='total_dissolved_phosphorus',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Total dissolved phosphorus, includes organic and inorganic',
note=None,
warning=None,
error_name=None,
cf_unit='umol/kg',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=56.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='D13C_POC',
dtype='decimal',
whp_unit='/MILLE',
nc_name='d13c_poc',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Enrichment of :sup:`13`\\ C vs :sup:`12`\\ C in particulate organic carbon (POC) compared to a reference standard usually VPDB. This is usually written as lower case delta δ\\ :sup:`13`\\ C.',
note=None,
warning=None,
error_name=None,
cf_unit='1e-3',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=55.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='UPTAKE',
dtype='string',
whp_unit=None,
nc_name='update_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='Measures of uptake in incubation experiments',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning='',
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='ABUNDANCE',
dtype='string',
whp_unit=None,
nc_name='abundance_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='Placeholder for cell counts of species',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='QUOTA',
dtype='string',
whp_unit=None,
nc_name='quota_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=14,
description='Placehodler for cell-quota model measurements',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.3,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CDOM2C',
dtype='decimal',
whp_unit=None,
nc_name='cdom2c',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='CDOM2 (carbohydrate and neutral sugar) charicterization',
note="So far CCHDO doesn't have any data or references on how these data are report, they might go to NASA SeaBASS",
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.95,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CDOM3C',
dtype='decimal',
whp_unit=None,
nc_name='cdom3c',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=0,
field_width=9,
description='CDOM3 (photolysis) charicterization',
note="So far CCHDO doesn't have any data or references on how these data are report, they might go to NASA SeaBASS",
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=69.96,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CFC-11',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='cfc_11_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved CFC11 in sea water. The chemical formula of CFC11 is CFCl3. The IUPAC name for CFC11 is trichloro(fluoro)methane.',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=7,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=31.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CFC-12',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='cfc_12_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved CFC12 in sea water. The chemical formula for CFC12 is CF2Cl2. The IUPAC name for CFC12 is dichloro(difluoro)methane.',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=8,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=32.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CFC113',
dtype='decimal',
whp_unit='PMOL/L',
nc_name='cfc_113_',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description='The concentration of dissolved CFC113 in sea water. The chemical formula of CFC113 is CCl2FCClF2. The IUPAC name for CFC113 is 1,1,2-trichloro-1,2,2-trifluoroethane.',
note=None,
warning=None,
error_name=None,
cf_unit='pmol/l',
reference_scale=None,
whp_number=27,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=33.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TRITUM',
dtype='decimal',
whp_unit='KBQ/M^3',
nc_name='tritium_activity',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=3,
field_width=9,
description=None,
note='1 TU is 1 tritium atom per 10\\ :sup:`18` hydrogen atoms',
warning=None,
error_name='TRITER',
cf_unit='kBq m-3',
reference_scale=None,
whp_number=9,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=45.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CDOM_NASA',
dtype='string',
whp_unit=None,
nc_name='cdom_nasa_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=4,
description='Placholder for CDOM spectral absoptions performed by a group from NASA',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.6,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='CDOM_UCSB',
dtype='string',
whp_unit=None,
nc_name='cdom_ucsb_placeholder',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=None,
field_width=4,
description='Placholder for CDOM spectral absoptions performed by a group from UCSB',
note='This is a placeholder parameter which indicates water collected from a bottle for analysis',
warning=None,
error_name=None,
cf_unit=None,
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=154.7,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SF6',
dtype='decimal',
whp_unit='FMOL/L',
nc_name='sulfur_hexifluoride_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=4,
field_width=9,
description='The concentration of SF6 (Sulfur hexafluoride) in sea water.',
note=None,
warning=None,
error_name=None,
cf_unit='fmol/l',
reference_scale=None,
whp_number=63,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=34.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SF5CF3',
dtype='decimal',
whp_unit='FMOL/L',
nc_name='trifluoromethylsulfur_pentafluoride_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description='Concentration of Trifluoromethyl Sulfur Pentafluoride',
note=None,
warning=None,
error_name=None,
cf_unit='fmol/l',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=149.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='TON',
dtype='decimal',
whp_unit='UMOL/L',
nc_name='total_organic_nitrogen_l',
flag_w='woce_discrete',
cf_name=None,
numeric_min=None,
numeric_max=None,
numeric_precision=2,
field_width=9,
description=None,
note=None,
warning=None,
error_name=None,
cf_unit='umol l-1',
reference_scale=None,
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=58.0,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='DNSSAL2',
dtype='decimal',
whp_unit='G/KG',
nc_name='density_salinity2',
flag_w='woce_discrete',
cf_name='sea_water_absolute_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='Replicate measuremnet of DNSSAL, used in TEOS-10 verification work',
note=None,
warning=None,
error_name=None,
cf_unit='g/kg',
reference_scale=None,
whp_number=92,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=21.1,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SALNTY_DNSSAL',
dtype='decimal',
whp_unit='PSS-78',
nc_name='density_salinity_practical_salinity',
flag_w='woce_discrete',
cf_name='sea_water_practical_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='A practical salinity measurement in the lab of the same water sample as DNSSAL, used in TEOS-10 verification work',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale='PSS-78',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=21.2,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
WHPNameDC(
whp_name='SALNTY_DNSSAL2',
dtype='decimal',
whp_unit='PSS-78',
nc_name='density_salinity_practical_salinity2',
flag_w='woce_discrete',
cf_name='sea_water_practical_salinity',
numeric_min=0.0,
numeric_max=42.0,
numeric_precision=4,
field_width=9,
description='Replicate of SALNTY_DNSSAL',
note=None,
warning=None,
error_name=None,
cf_unit='1',
reference_scale='PSS-78',
whp_number=None,
scope='sample',
analytical_temperature_name=None,
analytical_temperature_units=None,
rank=21.3,
radiation_wavelength=None,
scattering_angle=None,
excitation_wavelength=None,
emission_wavelength=None,
nc_group=None,
),
]
for name in names:
    whp_names[name.key] = name
whp_names[('LATITUDE', 'DEG')] = whp_names[('LATITUDE', None)]
whp_names[('LONGITUDE', 'DEG')] = whp_names[('LONGITUDE', None)]
whp_names[('DEPTH', None)] = whp_names[('DEPTH', 'METERS')]
whp_names[('CTDPRS', 'DBARS')] = whp_names[('CTDPRS', 'DBAR')]
whp_names[('CTDPRS', 'DBR')] = whp_names[('CTDPRS', 'DBAR')]
whp_names[('CTDTMP', 'ITS90')] = whp_names[('CTDTMP', 'ITS-90')]
whp_names[('CTDTMP', 'IPTS-90')] = whp_names[('CTDTMP', 'ITS-90')]
whp_names[('CTDTMP', 'IT-90')] = whp_names[('CTDTMP', 'ITS-90')]
whp_names[('CTDTMP', 'ITS_90')] = whp_names[('CTDTMP', 'ITS-90')]
whp_names[('CTDTMP', 'ITS-68')] = whp_names[('CTDTMP', 'IPTS-68')]
whp_names[('CTDTMP', 'ITS_68')] = whp_names[('CTDTMP', 'IPTS-68')]
whp_names[('CTDTMP', 'IPTS68')] = whp_names[('CTDTMP', 'IPTS-68')]
whp_names[('CTDTMP', 'DEG-C')] = whp_names[('CTDTMP', 'DEG C')]
whp_names[('PH_TEMP', 'DEGC')] = whp_names[('PH_TMP', 'DEG C')]
whp_names[('TIME', 'UTC')] = whp_names[('TIME', None)]
whp_names[('THETA', 'DEGC')] = whp_names[('THETA', 'DEG C')]
whp_names[('THETA', 'DEC C')] = whp_names[('THETA', 'DEG C')]
whp_names[('THETA', 'DEC-C')] = whp_names[('THETA', 'DEG C')]
whp_names[('THETA', 'DEC_C')] = whp_names[('THETA', 'DEG C')]
whp_names[('AMMONI', 'UMOL/KG')] = whp_names[('NH4', 'UMOL/KG')]
whp_names[('DELC13', 'O/OO')] = whp_names[('DELC13', '/MILLE')]
whp_names[('DELO18', 'O/OO')] = whp_names[('DELO18', '/MILLE')]
whp_names[('DELC14', 'O/OO')] = whp_names[('DELC14', '/MILLE')]
whp_names[('SALNTY', 'PSU')] = whp_names[('SALNTY', 'PSS-78')]
whp_names[('SALNTY', 'PSS78')] = whp_names[('SALNTY', 'PSS-78')]
whp_names[('CTDSAL', 'PSU')] = whp_names[('CTDSAL', 'PSS-78')]
whp_names[('CTDRAW', None)] = whp_names[('CTDRAW', 'DBAR')]
whp_names[('REVTMP', None)] = whp_names[('REVTMP', 'DEG C')]
whp_names[('REVTMP', 'ITS-68')] = whp_names[('REVTMP', 'IPTS-68')]
whp_names[('CTDTMP', 'ITST90')] = whp_names[('CTDTMP', 'ITS-90')]
whp_names[('CTDTMP', 'DEGC')] = whp_names[('CTDTMP', 'DEG C')]
whp_names[('CTDTMP', 'DEG_C')] = whp_names[('CTDTMP', 'DEG C')]
whp_names[('CTDSAL', 'PSS78')] = whp_names[('CTDSAL', 'PSS-78')]
whp_names[('SBE35', 'ITS-90')] = whp_names[('REFTMP', 'ITS-90')]
whp_names[('XMISS', '%TRANS')] = whp_names[('CTDXMISS', '%TRANS')]
whp_names[('XMISS', '0-5VDC')] = whp_names[('CTDXMISS', 'VOLTS')]
whp_names[('CFC-12', 'PM/KG')] = whp_names[('CFC-12', 'PMOL/KG')]
whp_names[('CFC-11', 'PM/KG')] = whp_names[('CFC-11', 'PMOL/KG')]
whp_names[('RA-226', 'DPM/100KG')] = whp_names[('RA-226', 'DM/.1MG')]
whp_names[('PCO2TMP', 'DEG_C')] = whp_names[('PCO2TMP', 'DEG C')]
whp_names[('NO3+NO2', 'UMOL/KG')] = whp_names[('NO2+NO3', 'UMOL/KG')]
whp_names[('CTDOXY', 'uMOL/KG')] = whp_names[('CTDOXY', 'UMOL/KG')]
whp_names[('CTDETIME', None)] = whp_names[('CTDETIME', 'SECONDS')]
whp_names[('SECT', None)] = whp_names[('SECT_ID', None)]
whp_names[('NUMBER', 'OBS.')] = whp_names[('CTDNOBS', None)]
whp_names[('CTDPAR', 'uE/m^2/sec')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('CTDPAR', 'UEINSTEINS/M2.SEC')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('CTDPAR', 'UMOL/M^2/S')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('PAR', 'UEINSTEINS/M2.SEC')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('PAR', 'uE/m^2/sec')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('CTDNOBS', 'ARBITRARY')] = whp_names[('CTDNOBS', None)]
whp_names[('TCO2', 'UMOL/KG')] = whp_names[('TCARBN', 'UMOL/KG')]
whp_names[('BTLNBR', 'ID')] = whp_names[('BTLNBR', None)]
whp_names[('PHAEO', 'UG/L')] = whp_names[('PPHYTN', 'UG/L')]
whp_names[('LAB_DEN', None)] = whp_names[('LAB_DEN', 'KG/M^3')]
whp_names[('THETA', 'DEG')] = whp_names[('THETA', 'DEG C')]
whp_names[('O18O16', 'MILLE')] = whp_names[('DELO18', '/MILLE')]
whp_names[('O18O16', '/MILLE')] = whp_names[('DELO18', '/MILLE')]
whp_names[('POC', 'uG/KG')] = whp_names[('POC', 'UG/KG')]
whp_names[('FCO2_TMP', 'DEG C')] = whp_names[('FCO2TMP', 'DEG C')]
whp_names[('FLUOR', None)] = whp_names[('CTDFLUOR', None)]
whp_names[('FLUOR', 'MG/M^3')] = whp_names[('CTDFLUOR', 'MG/M^3')]
whp_names[('FLUORO', '0-5VDC')] = whp_names[('CTDFLUOR', 'VOLTS')]
whp_names[('POC', 'ug/kg')] = whp_names[('POC', 'UG/KG')]
whp_names[('CTDXMISSCP', '/METER')] = whp_names[('CTDBEAMCP', '/METER')]
whp_names[('PON', 'ug/kg')] = whp_names[('PON', 'UG/KG')]
whp_names[('BLACKC', None)] = whp_names[('BLACKC', 'UMOL/L')]
whp_names[('XMISSCP', '/METER')] = whp_names[('CTDBEAMCP', '/METER')]
whp_names[('PAR', 'UE/SQM/S')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('TRANSM', 'VDC')] = whp_names[('CTDXMISS', 'VOLTS')]
whp_names[('FLUORM', 'VDC')] = whp_names[('CTDFLUOR', 'VOLTS')]
whp_names[('FLUOR', 'MG/CUM')] = whp_names[('CTDFLUOR', 'MG/M^3')]
whp_names[('AZOTE', 'UMOL/KG')] = whp_names[('N2', 'UMOL/KG')]
whp_names[('CHLORA', 'MG/CUM')] = whp_names[('CHLORA', 'UG/L')]
whp_names[('CHLORA', 'MG/M^3')] = whp_names[('CHLORA', 'UG/L')]
whp_names[('CTDFLUOR', '0-5VDC')] = whp_names[('CTDFLUOR', 'VOLTS')]
whp_names[('CTDXMISS', '0-5VDC')] = whp_names[('CTDXMISS', 'VOLTS')]
whp_names[('_INSTRUMENT_NO', None)] = whp_names[('INSTRUMENT_ID', None)]
whp_names[('_SAMPLING_RATE', None)] = whp_names[('SAMPLING_RATE', 'HZ')]
whp_names[('PAR', 'UE/m^2/sec')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('CTDPAR', 'UE/SQM/S')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('CTDOXY', 'ml/l')] = whp_names[('CTDOXY', 'ML/L')]
whp_names[('CTDDOXY', 'UMOL/KG')] = whp_names[('CTDOXY', 'UMOL/KG')]
whp_names[('CHLORA', 'MG/M3')] = whp_names[('CHLORA', 'UG/L')]
whp_names[('PAR', 'uE/M^2/S')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('CTDPAR', '0-5VDC')] = whp_names[('PAR', 'VOLTS')]
whp_names[('PAR', '0-5VDC')] = whp_names[('PAR', 'VOLTS')]
whp_names[('FLUOR', '0-5VDC')] = whp_names[('CTDFLUOR', 'VOLTS')]
whp_names[('FLUOR', 'UG/L')] = whp_names[('CTDFLUOR', 'MG/M^3')]
whp_names[('FLUORM', 'MG/M^3')] = whp_names[('CTDFLUOR', 'MG/M^3')]
whp_names[('GEOTRC_EVENT', None)] = whp_names[('GEOTR_EVENT', None)]
whp_names[('O2-AR', None)] = whp_names[('O2/AR', None)]
whp_names[('FLUOR', 'VOLTS')] = whp_names[('CTDFLUOR', 'VOLTS')]
whp_names[('SIG0', 'KG/CUM')] = whp_names[('SIG0', 'KG/M^3')]
whp_names[('PHTEMP', 'DEC C')] = whp_names[('PH_TMP', 'DEG C')]
whp_names[('FLUORO', 'VOLTS')] = whp_names[('CTDFLUOR', 'VOLTS')]
whp_names[('PHTEMP', 'DEG C')] = whp_names[('PH_TMP', 'DEG C')]
whp_names[('CHLORA', 'MG/M**3')] = whp_names[('CHLORA', 'UG/L')]
whp_names[('PPHYTN', 'MG/M**3')] = whp_names[('PPHYTN', 'UG/L')]
whp_names[('PCO2_TMP', 'DEG C')] = whp_names[('PCO2TMP', 'DEG C')]
whp_names[('PPHYTN', 'MG/M^3')] = whp_names[('PPHYTN', 'UG/L')]
whp_names[('DELHE3', '%')] = whp_names[('DELHE3', 'PERCNT')]
whp_names[('BEDFORT', 'NUM')] = whp_names[('BIONBR', None)]
whp_names[('XMISS', '%TRANCE')] = whp_names[('CTDXMISS', '%TRANS')]
whp_names[('XMISSCP', '1/M')] = whp_names[('CTDBEAMCP', '/METER')]
whp_names[('PCO2', 'PPM')] = whp_names[('XCO2', 'PPM')]
whp_names[('CTDTRBDTY', 'NTU')] = whp_names[('CTDTURB', 'NTU')]
whp_names[('CTDTURBTY', 'FTU')] = whp_names[('CTDTURB', 'FTU')]
whp_names[('CTDBEAMCP', '1/M')] = whp_names[('CTDBEAMCP', '/METER')]
whp_names[('CTDFLUOR', 'MG/CUM')] = whp_names[('CTDFLUOR', 'MG/M^3')]
whp_names[('CTDPAR', 'UPHOTMS')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('CTDSAL', 'PSS_78')] = whp_names[('CTDSAL', 'PSS-78')]
whp_names[('CTDSAL', 'PSS-68')] = whp_names[('CTDSAL', 'PSS-78')]
whp_names[('CTDTHETA', 'DEG C')] = whp_names[('THETA', 'DEG C')]
whp_names[('CTDCDOMFRAW', '0-5VDC')] = whp_names[('CTDCDOM', 'VOLTS')]
whp_names[('CTDCDOMFRAW', 'VDC')] = whp_names[('CTDCDOM', 'VOLTS')]
whp_names[('CTDCDOMFRAW', 'V')] = whp_names[('CTDCDOM', 'VOLTS')]
whp_names[('SALNTY', 'ISS78')] = whp_names[('SALNTY', 'PSS-78')]
whp_names[('CTDSAL', 'ISS78')] = whp_names[('CTDSAL', 'PSS-78')]
whp_names[('O18_O16', '/MILLE')] = whp_names[('DELO18', '/MILLE')]
whp_names[('BTMDEPTH', 'METERS')] = whp_names[('DEPTH', 'METERS')]
whp_names[('ODF_CTDPRS', 'DBARS')] = whp_names[('ODF_CTDPRS', 'DBAR')]
whp_names[('PCO2TMP', 'DEC C')] = whp_names[('PCO2TMP', 'DEG C')]
whp_names[('THETA', 'DEG_C')] = whp_names[('THETA', 'DEG C')]
whp_names[('ID', None)] = whp_names[('SAMPNO_U', None)]
whp_names[('INDEX', None)] = whp_names[('SAMPNO_U', None)]
whp_names[('CDOM325', '1/M')] = whp_names[('CDOM325', '/METER')]
whp_names[('CDOM340', '1/M')] = whp_names[('CDOM340', '/METER')]
whp_names[('CDOM380', '1/M')] = whp_names[('CDOM380', '/METER')]
whp_names[('CDOM412', '1/M')] = whp_names[('CDOM412', '/METER')]
whp_names[('CDOM443', '1/M')] = whp_names[('CDOM443', '/METER')]
whp_names[('CDOM490', '1/M')] = whp_names[('CDOM490', '/METER')]
whp_names[('CDOM555', '1/M')] = whp_names[('CDOM555', '/METER')]
whp_names[('CTDPAR', 'VOLTS')] = whp_names[('PAR', 'VOLTS')]
whp_names[('IMAGE_COUNT', None)] = whp_names[('IMAGES', None)]
whp_names[('CTDRINKO', 'VOLTS')] = whp_names[('CTDOPTOXY', 'VOLTS')]
whp_names[('CTDRINKO', 'UMOL/KG')] = whp_names[('CTDOPTOXY', 'UMOL/KG')]
whp_names[('OPTOXY', 'UMOL/KG')] = whp_names[('CTDOPTOXY', 'UMOL/KG')]
whp_names[('CTDRINKO', '0-5VDC')] = whp_names[('CTDOPTOXY', 'VOLTS')]
whp_names[('CTDBBP700RAW', '0-5VDC')] = whp_names[('CTDBETA700', 'VOLTS')]
whp_names[('CTDFLBBFLUORRAW', '0-5VDC')] = whp_names[('CTDFLUOR', 'VOLTS')]
whp_names[('CTDXMISS', '%')] = whp_names[('CTDXMISS', '%TRANS')]
whp_names[('CTDFLUOR', 'MG/M3')] = whp_names[('CTDFLUOR', 'MG/M^3')]
whp_names[('CTDPAR', 'UMOL/M^2/SEC')] = whp_names[('PAR', 'UMOL/M^2/SEC')]
whp_names[('CTDFLUOR', 'UG/L')] = whp_names[('CTDFLUOR', 'MG/M^3')]
whp_names[('CTDBACKSCATTER', 'VOLTS')] = whp_names[('CTDBETA700', 'VOLTS')]
whp_names[('PH_TMP', 'DEGC')] = whp_names[('PH_TMP', 'DEG C')]
whp_names[('FLUOR', 'MG/K^3')] = whp_names[('CTDFLUOR', 'MG/M^3')]
whp_names[('METHANE', 'NMOL/L')] = whp_names[('CH4', 'NMOL/L')]
whp_names[('METHAN', 'NMOL/KG')] = whp_names[('CH4', 'NMOL/KG')]
whp_names[('CHLA', 'UG/L')] = whp_names[('CHLORA', 'UG/L')]
whp_names[('OXYNIT', 'NMOL/KG')] = whp_names[('N2O', 'NMOL/KG')]
whp_names[('ARABA', 'NMOL/KG')] = whp_names[('ARABI', 'NMOL/KG')]
whp_names[('CS-137', 'BQ/CUM')] = whp_names[('CS-137', 'BQ/M^3')]
whp_names[('CS-134', 'BQ/CUM')] = whp_names[('CS-134', 'BQ/M^3')]
whp_names[('REVTMP', 'ITS90')] = whp_names[('REVTMP', 'ITS-90')]
whp_names[('REVPRS', 'DBR')] = whp_names[('REVPRS', 'DBAR')]
whp_names[('CTDBACKSCATTER', '0-5VDC')] = whp_names[('CTDBETA700', 'VOLTS')]
whp_names[('Trans_Red_25cm', '%')] = whp_names[('CTDXMISS', '%TRANS')]
whp_names[('Trans_Red_25cm', 'PERCNT')] = whp_names[('CTDXMISS', '%TRANS')]
whp_names[('Atten_red', '/M')] = whp_names[('CTDBEAMCP', '/METER')]
whp_names[('FLUORM', '0-5VDC')] = whp_names[('CTDFLUOR', 'VOLTS')]
whp_names[('THETA', 'its-90')] = whp_names[('THETA', 'ITS-90')]
whp_names[('CTDTMP', 'IPS-90')] = whp_names[('CTDTMP', 'ITS-90')]
whp_names[('CTDTMP', 'IST-90')] = whp_names[('CTDTMP', 'ITS-90')]
whp_names[('CTDTMP', 'ITP-90')] = whp_names[('CTDTMP', 'ITS-90')]
whp_names[('PHYTOP', 'NB/ML')] = whp_names[('PHYTOP', '1/ML')]
whp_names[('CYANB', 'NB/ML')] = whp_names[('CYANB', '1/ML')]
whp_names[('ABSORBTION', None)] = whp_names[('BEAMAP', '/METER')]
whp_names[('CYTO_COUNT', None)] = whp_names[('FCM', None)]
whp_names[('CDOM-300', '/METER')] = whp_names[('CDOM300', '/METER')]
whp_names[('CDOM-325', '/METER')] = whp_names[('CDOM325', '/METER')]
whp_names[('CDOM-443', '/METER')] = whp_names[('CDOM443', '/METER')]
whp_names[('DELN15', 'O/OO')] = whp_names[('DELN15', '/MILLE')]
whp_names[('BARIUM', 'nM/L')] = whp_names[('BARIUM', 'NMOL/L')]
whp_names[('CELLCOUNT', '/LITER')] = whp_names[('CELLCOUNT', '/L')]
whp_names[('CHL_B', 'MG/M^3')] = whp_names[('TOT_CHL_B', 'MG/M^3')]
whp_names[('TRITUM', 'KBQ/CUM')] = whp_names[('TRITUM', 'KBQ/M^3')]
whp_names[('D15N_NO3+NO2', '/MILLE')] = whp_names[('D15N_NO2+NO3', '/MILLE')]
whp_names[('D18O_NO3+NO2', '/MILLE')] = whp_names[('D18O_NO2+NO3', '/MILLE')]
whp_names[('DSI30', '/MILLE')] = whp_names[('DELSI30', '/MILLE')]
whp_names[('D14C-DOC', '/MILLE')] = whp_names[('14C-DOC', '/MILLE')]
whp_names[('D13C-DOC', '/MILLE')] = whp_names[('13C-DOC', '/MILLE')]
whp_names[('THETA', 'DEG-C')] = whp_names[('THETA', 'DEG C')]
