# Generated by Django 2.1.5 on 2019-12-17 21:55

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import sign_manager.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='SignManagerSignature',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField()),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='Дата и время создания')),
                ('is_detached', models.BooleanField(verbose_name='Подпись открепленная (оборачивающая)')),
                ('object_serialized', models.TextField(verbose_name='Сериализованный объект')),
                ('signature', models.FileField(upload_to=sign_manager.models.get_signature_file_path, verbose_name='Подпись')),
                ('signed_object_type', models.CharField(choices=[('xml', 'xml'), ('base64', 'base64'), ('base64_hash', 'base64_hash')], max_length=20, verbose_name='Тип подписанного объекта')),
                ('cert_version', models.CharField(max_length=200, null=True, verbose_name='Версия сертификата')),
                ('cert_key_algorithm', models.CharField(max_length=200, null=True, verbose_name='Алгоритм ключа сертификата')),
                ('cert_serial_number', models.CharField(max_length=200, null=True, verbose_name='Серийный номер сертификата')),
                ('cert_subject_name', models.TextField(null=True, verbose_name='Информация о сертификате')),
                ('cert_issuer_name', models.TextField(null=True, verbose_name='Информация об издателе сертификата')),
                ('cert_valid_from_date', models.DateTimeField(null=True, verbose_name='Сертификат действителен от')),
                ('cert_valid_to_date', models.DateTimeField(null=True, verbose_name='Сертификат действителен до')),
                ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='sign_manager_signatures', to=settings.AUTH_USER_MODEL, verbose_name='Автор')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'Подпись объекта',
                'verbose_name_plural': 'Подписи объектов',
                'ordering': ('-created',),
            },
        ),
    ]
