from utilities.testing import ViewTestCases, create_tags

from nb_risk.tests.custom import ModelViewTestCase
from nb_risk.models import Vulnerability
from nb_risk import choices


class ControlViewTestCase(
    ModelViewTestCase,
    ViewTestCases.GetObjectViewTestCase,
    ViewTestCases.CreateObjectViewTestCase,
    ViewTestCases.EditObjectViewTestCase,
    ViewTestCases.DeleteObjectViewTestCase,
    ViewTestCases.ListObjectsViewTestCase,
    ViewTestCases.GetObjectChangelogViewTestCase,
    ViewTestCases.BulkImportObjectsViewTestCase,
    ViewTestCases.BulkDeleteObjectsViewTestCase,
):
    model = Vulnerability

    @classmethod
    def setUpTestData(cls):

        vulnerabilities = (
            Vulnerability(
                name="Vulnerability 1",
                cve="CVE-2021-1234",
                description="A test vulnerability",
            ),
            Vulnerability(
                name="Vulnerability 2",
                cve="CVE-2021-1235",
                description="Another test vulnerability",
            ),
            Vulnerability(
                name="Vulnerability 3",
                cve="CVE-2021-1236",
                description="Yet another test vulnerability",
            ),
        )
        Vulnerability.objects.bulk_create(vulnerabilities)

        cls.form_data = {
            "name": "Vulnerability X",
            "cve": "CVE-2021-1237",
            "description": "A new vulnerability",
        }

        cls.csv_data = (
            "name,cve,description,cvssbaseScore",
            "Vulnerability 4,CVE-2021-1238,Test Profile 1,7.8",
            "Vulnerability 5,CVE-2021-1239,Test Profile 2,8.1",
            "Vulnerability 6,CVE-2021-1240,Test Profile 3,9.2",
        )

        cls.csv_update_data = (
            "id,name,description",
            f"{vulnerabilities[0].pk},New Vuln 1,Updated description 1",
            f"{vulnerabilities[1].pk},New Vuln 2,Updated description 2",
        )

        maxDiff = None
