"""
GeoSun 日志库
"""

from setuptools import setup
import os

setup(
    name="geosun-logger",
    version="0.0.3",
    description="GeoSun 日志库",
    author="wenxi.da",
    author_email="wenxi.da007@qq.com",
    python_requires=">=3.9",
    license="MIT",
    classifiers=['Development Status :: 3 - Alpha', 'Intended Audience :: Developers', 'License :: OSI Approved :: MIT License', 'Programming Language :: Python :: 3', 'Programming Language :: Python :: 3.9', 'Programming Language :: Python :: 3.10', 'Programming Language :: Python :: 3.11', 'Programming Language :: Python :: 3.12', 'Operating System :: Microsoft :: Windows', 'Topic :: Software Development :: Libraries'],
    # 使用明确的包名，而不是find_packages()，避免因目录名包含连字符导致找不到包
    packages=['geosun_logger'],
    # 指定包目录映射：模块名 -> 当前目录（因为.pyd文件直接放在package_dir中）
    package_dir={'geosun_logger': '.'},
    # 确保.pyd、.pyi和py.typed文件被包含
    package_data={
        'geosun_logger': ['*.pyd', '*.pyi', 'py.typed']
    },
    include_package_data=True,
)
