"Main interface for kinesisvideo service type defs"
from datetime import datetime
import sys
from typing import Dict, List

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal
if sys.version_info >= (3, 8):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict


ChannelNameConditionTypeDef = TypedDict(
    "ChannelNameConditionTypeDef",
    {"ComparisonOperator": Literal["BEGINS_WITH"], "ComparisonValue": str},
    total=False,
)

CreateSignalingChannelOutputTypeDef = TypedDict(
    "CreateSignalingChannelOutputTypeDef", {"ChannelARN": str}, total=False
)

CreateStreamOutputTypeDef = TypedDict("CreateStreamOutputTypeDef", {"StreamARN": str}, total=False)

SingleMasterConfigurationTypeDef = TypedDict(
    "SingleMasterConfigurationTypeDef", {"MessageTtlSeconds": int}, total=False
)

ChannelInfoTypeDef = TypedDict(
    "ChannelInfoTypeDef",
    {
        "ChannelName": str,
        "ChannelARN": str,
        "ChannelType": Literal["SINGLE_MASTER"],
        "ChannelStatus": Literal["CREATING", "ACTIVE", "UPDATING", "DELETING"],
        "CreationTime": datetime,
        "SingleMasterConfiguration": SingleMasterConfigurationTypeDef,
        "Version": str,
    },
    total=False,
)

DescribeSignalingChannelOutputTypeDef = TypedDict(
    "DescribeSignalingChannelOutputTypeDef", {"ChannelInfo": ChannelInfoTypeDef}, total=False
)

StreamInfoTypeDef = TypedDict(
    "StreamInfoTypeDef",
    {
        "DeviceName": str,
        "StreamName": str,
        "StreamARN": str,
        "MediaType": str,
        "KmsKeyId": str,
        "Version": str,
        "Status": Literal["CREATING", "ACTIVE", "UPDATING", "DELETING"],
        "CreationTime": datetime,
        "DataRetentionInHours": int,
    },
    total=False,
)

DescribeStreamOutputTypeDef = TypedDict(
    "DescribeStreamOutputTypeDef", {"StreamInfo": StreamInfoTypeDef}, total=False
)

GetDataEndpointOutputTypeDef = TypedDict(
    "GetDataEndpointOutputTypeDef", {"DataEndpoint": str}, total=False
)

ResourceEndpointListItemTypeDef = TypedDict(
    "ResourceEndpointListItemTypeDef",
    {"Protocol": Literal["WSS", "HTTPS"], "ResourceEndpoint": str},
    total=False,
)

GetSignalingChannelEndpointOutputTypeDef = TypedDict(
    "GetSignalingChannelEndpointOutputTypeDef",
    {"ResourceEndpointList": List[ResourceEndpointListItemTypeDef]},
    total=False,
)

ListSignalingChannelsOutputTypeDef = TypedDict(
    "ListSignalingChannelsOutputTypeDef",
    {"ChannelInfoList": List[ChannelInfoTypeDef], "NextToken": str},
    total=False,
)

ListStreamsOutputTypeDef = TypedDict(
    "ListStreamsOutputTypeDef",
    {"StreamInfoList": List[StreamInfoTypeDef], "NextToken": str},
    total=False,
)

ListTagsForResourceOutputTypeDef = TypedDict(
    "ListTagsForResourceOutputTypeDef", {"NextToken": str, "Tags": Dict[str, str]}, total=False
)

ListTagsForStreamOutputTypeDef = TypedDict(
    "ListTagsForStreamOutputTypeDef", {"NextToken": str, "Tags": Dict[str, str]}, total=False
)

PaginatorConfigTypeDef = TypedDict(
    "PaginatorConfigTypeDef", {"MaxItems": int, "PageSize": int, "StartingToken": str}, total=False
)

SingleMasterChannelEndpointConfigurationTypeDef = TypedDict(
    "SingleMasterChannelEndpointConfigurationTypeDef",
    {"Protocols": List[Literal["WSS", "HTTPS"]], "Role": Literal["MASTER", "VIEWER"]},
    total=False,
)

StreamNameConditionTypeDef = TypedDict(
    "StreamNameConditionTypeDef",
    {"ComparisonOperator": Literal["BEGINS_WITH"], "ComparisonValue": str},
    total=False,
)

TagTypeDef = TypedDict("TagTypeDef", {"Key": str, "Value": str})
