<h1 align="center">Exasol Toolbox</h1>

<p align="center">
Your one-stop solution for managing all standard tasks and core workflows of your Python project.
</p>

<p align="center">

<a href="https://github.com/exasol/python-toolbox/actions/workflows/ci.yml">
    <img src="https://github.com/exasol/python-toolbox/actions/workflows/ci.yml/badge.svg?branch=main" alt="Checks Main">
</a>
<a href="https://opensource.org/licenses/MIT">
    <img src="https://img.shields.io/pypi/l/exasol-toolbox" alt="License">
</a>
<a href="https://pypi.org/project/exasol-toolbox/">
    <img src="https://img.shields.io/pypi/dm/exasol-toolbox" alt="Downloads">
</a>
<a href="https://pypi.org/project/exasol-toolbox/">
    <img src="https://img.shields.io/pypi/pyversions/exasol-toolbox" alt="Supported Python Versions">
</a>
<a href="https://pypi.org/project/exasol-toolbox/">
    <img src="https://img.shields.io/pypi/v/exasol-toolbox" alt="PyPi Package">
</a>
</p>

## 🚀 Features

- Centrally managed standard tasks
  - code formatting & upgrading
  - linting
  - type-checking
  - unit-tests
  - integration-tests
  - coverage
  - documentation

- Centrally manged core workflows
  - workspace/project verification
  - build and publish releases
  - build and publish documentation

- Configurable & Extensible
  - Project configuration
  - Event hooks

## 🔌️ Prerequisites

- [Python](https://www.python.org/) >= 3.8

## 💾 Installation

```shell
pip install exasol-toolbox
```

## 📚 Documentation

For futher details, checkout the latest [documentation](https://exasol.github.io/python-toolbox/).

