# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Argument(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auto': 'str',
        'default': 'bool',
        'default_value': 'str',
        'deprecated': 'bool',
        'description': 'str',
        'is_array': 'bool',
        'name': 'str',
        'predefined': 'list[str]',
        'required': 'bool',
        'secret': 'bool'
    }

    attribute_map = {
        'auto': 'auto',
        'default': 'default',
        'default_value': 'defaultValue',
        'deprecated': 'deprecated',
        'description': 'description',
        'is_array': 'isArray',
        'name': 'name',
        'predefined': 'predefined',
        'required': 'required',
        'secret': 'secret'
    }

    def __init__(self, auto=None, default=None, default_value=None, deprecated=None, description=None, is_array=None, name=None, predefined=None, required=None, secret=None):  # noqa: E501
        """Argument - a model defined in Swagger"""  # noqa: E501

        self._auto = None
        self._default = None
        self._default_value = None
        self._deprecated = None
        self._description = None
        self._is_array = None
        self._name = None
        self._predefined = None
        self._required = None
        self._secret = None
        self.discriminator = None

        if auto is not None:
            self.auto = auto
        if default is not None:
            self.default = default
        if default_value is not None:
            self.default_value = default_value
        if deprecated is not None:
            self.deprecated = deprecated
        if description is not None:
            self.description = description
        if is_array is not None:
            self.is_array = is_array
        if name is not None:
            self.name = name
        if predefined is not None:
            self.predefined = predefined
        if required is not None:
            self.required = required
        if secret is not None:
            self.secret = secret

    @property
    def auto(self):
        """Gets the auto of this Argument.  # noqa: E501


        :return: The auto of this Argument.  # noqa: E501
        :rtype: str
        """
        return self._auto

    @auto.setter
    def auto(self, auto):
        """Sets the auto of this Argument.


        :param auto: The auto of this Argument.  # noqa: E501
        :type: str
        """

        self._auto = auto

    @property
    def default(self):
        """Gets the default of this Argument.  # noqa: E501


        :return: The default of this Argument.  # noqa: E501
        :rtype: bool
        """
        return self._default

    @default.setter
    def default(self, default):
        """Sets the default of this Argument.


        :param default: The default of this Argument.  # noqa: E501
        :type: bool
        """

        self._default = default

    @property
    def default_value(self):
        """Gets the default_value of this Argument.  # noqa: E501


        :return: The default_value of this Argument.  # noqa: E501
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """Sets the default_value of this Argument.


        :param default_value: The default_value of this Argument.  # noqa: E501
        :type: str
        """

        self._default_value = default_value

    @property
    def deprecated(self):
        """Gets the deprecated of this Argument.  # noqa: E501


        :return: The deprecated of this Argument.  # noqa: E501
        :rtype: bool
        """
        return self._deprecated

    @deprecated.setter
    def deprecated(self, deprecated):
        """Sets the deprecated of this Argument.


        :param deprecated: The deprecated of this Argument.  # noqa: E501
        :type: bool
        """

        self._deprecated = deprecated

    @property
    def description(self):
        """Gets the description of this Argument.  # noqa: E501


        :return: The description of this Argument.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Argument.


        :param description: The description of this Argument.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def is_array(self):
        """Gets the is_array of this Argument.  # noqa: E501


        :return: The is_array of this Argument.  # noqa: E501
        :rtype: bool
        """
        return self._is_array

    @is_array.setter
    def is_array(self, is_array):
        """Sets the is_array of this Argument.


        :param is_array: The is_array of this Argument.  # noqa: E501
        :type: bool
        """

        self._is_array = is_array

    @property
    def name(self):
        """Gets the name of this Argument.  # noqa: E501


        :return: The name of this Argument.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Argument.


        :param name: The name of this Argument.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def predefined(self):
        """Gets the predefined of this Argument.  # noqa: E501


        :return: The predefined of this Argument.  # noqa: E501
        :rtype: list[str]
        """
        return self._predefined

    @predefined.setter
    def predefined(self, predefined):
        """Sets the predefined of this Argument.


        :param predefined: The predefined of this Argument.  # noqa: E501
        :type: list[str]
        """

        self._predefined = predefined

    @property
    def required(self):
        """Gets the required of this Argument.  # noqa: E501


        :return: The required of this Argument.  # noqa: E501
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this Argument.


        :param required: The required of this Argument.  # noqa: E501
        :type: bool
        """

        self._required = required

    @property
    def secret(self):
        """Gets the secret of this Argument.  # noqa: E501


        :return: The secret of this Argument.  # noqa: E501
        :rtype: bool
        """
        return self._secret

    @secret.setter
    def secret(self, secret):
        """Sets the secret of this Argument.


        :param secret: The secret of this Argument.  # noqa: E501
        :type: bool
        """

        self._secret = secret

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Argument, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Argument):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
