# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.order import Order  # noqa: F401,E501


class AutomationScriptFilter(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cache': 'dict(str, list[str])',
        'page': 'int',
        'query': 'str',
        'search_after': 'list[str]',
        'search_before': 'list[str]',
        'size': 'int',
        'sort': 'list[Order]',
        'strip_context': 'bool'
    }

    attribute_map = {
        'cache': 'Cache',
        'page': 'page',
        'query': 'query',
        'search_after': 'searchAfter',
        'search_before': 'searchBefore',
        'size': 'size',
        'sort': 'sort',
        'strip_context': 'stripContext'
    }

    def __init__(self, cache=None, page=None, query=None, search_after=None, search_before=None, size=None, sort=None, strip_context=None):  # noqa: E501
        """AutomationScriptFilter - a model defined in Swagger"""  # noqa: E501

        self._cache = None
        self._page = None
        self._query = None
        self._search_after = None
        self._search_before = None
        self._size = None
        self._sort = None
        self._strip_context = None
        self.discriminator = None

        if cache is not None:
            self.cache = cache
        if page is not None:
            self.page = page
        if query is not None:
            self.query = query
        if search_after is not None:
            self.search_after = search_after
        if search_before is not None:
            self.search_before = search_before
        if size is not None:
            self.size = size
        if sort is not None:
            self.sort = sort
        if strip_context is not None:
            self.strip_context = strip_context

    @property
    def cache(self):
        """Gets the cache of this AutomationScriptFilter.  # noqa: E501

        Cache of join functions  # noqa: E501

        :return: The cache of this AutomationScriptFilter.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._cache

    @cache.setter
    def cache(self, cache):
        """Sets the cache of this AutomationScriptFilter.

        Cache of join functions  # noqa: E501

        :param cache: The cache of this AutomationScriptFilter.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._cache = cache

    @property
    def page(self):
        """Gets the page of this AutomationScriptFilter.  # noqa: E501

        0-based page  # noqa: E501

        :return: The page of this AutomationScriptFilter.  # noqa: E501
        :rtype: int
        """
        return self._page

    @page.setter
    def page(self, page):
        """Sets the page of this AutomationScriptFilter.

        0-based page  # noqa: E501

        :param page: The page of this AutomationScriptFilter.  # noqa: E501
        :type: int
        """

        self._page = page

    @property
    def query(self):
        """Gets the query of this AutomationScriptFilter.  # noqa: E501


        :return: The query of this AutomationScriptFilter.  # noqa: E501
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """Sets the query of this AutomationScriptFilter.


        :param query: The query of this AutomationScriptFilter.  # noqa: E501
        :type: str
        """

        self._query = query

    @property
    def search_after(self):
        """Gets the search_after of this AutomationScriptFilter.  # noqa: E501

        Efficient next page, pass max sort value from previous page  # noqa: E501

        :return: The search_after of this AutomationScriptFilter.  # noqa: E501
        :rtype: list[str]
        """
        return self._search_after

    @search_after.setter
    def search_after(self, search_after):
        """Sets the search_after of this AutomationScriptFilter.

        Efficient next page, pass max sort value from previous page  # noqa: E501

        :param search_after: The search_after of this AutomationScriptFilter.  # noqa: E501
        :type: list[str]
        """

        self._search_after = search_after

    @property
    def search_before(self):
        """Gets the search_before of this AutomationScriptFilter.  # noqa: E501

        Efficient prev page, pass min sort value from next page  # noqa: E501

        :return: The search_before of this AutomationScriptFilter.  # noqa: E501
        :rtype: list[str]
        """
        return self._search_before

    @search_before.setter
    def search_before(self, search_before):
        """Sets the search_before of this AutomationScriptFilter.

        Efficient prev page, pass min sort value from next page  # noqa: E501

        :param search_before: The search_before of this AutomationScriptFilter.  # noqa: E501
        :type: list[str]
        """

        self._search_before = search_before

    @property
    def size(self):
        """Gets the size of this AutomationScriptFilter.  # noqa: E501

        Size is limited to 1000, if not passed it defaults to 0, and no results will return  # noqa: E501

        :return: The size of this AutomationScriptFilter.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this AutomationScriptFilter.

        Size is limited to 1000, if not passed it defaults to 0, and no results will return  # noqa: E501

        :param size: The size of this AutomationScriptFilter.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def sort(self):
        """Gets the sort of this AutomationScriptFilter.  # noqa: E501

        The sort order  # noqa: E501

        :return: The sort of this AutomationScriptFilter.  # noqa: E501
        :rtype: list[Order]
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this AutomationScriptFilter.

        The sort order  # noqa: E501

        :param sort: The sort of this AutomationScriptFilter.  # noqa: E501
        :type: list[Order]
        """

        self._sort = sort

    @property
    def strip_context(self):
        """Gets the strip_context of this AutomationScriptFilter.  # noqa: E501


        :return: The strip_context of this AutomationScriptFilter.  # noqa: E501
        :rtype: bool
        """
        return self._strip_context

    @strip_context.setter
    def strip_context(self, strip_context):
        """Sets the strip_context of this AutomationScriptFilter.


        :param strip_context: The strip_context of this AutomationScriptFilter.  # noqa: E501
        :type: bool
        """

        self._strip_context = strip_context

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AutomationScriptFilter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AutomationScriptFilter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
