# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.advance_arg import AdvanceArg  # noqa: F401,E501
from demisto_client.demisto_api.models.data_collection_form import DataCollectionForm  # noqa: F401,E501
from demisto_client.demisto_api.models.evidence_data import EvidenceData  # noqa: F401,E501
from demisto_client.demisto_api.models.field_mapping import FieldMapping  # noqa: F401,E501
from demisto_client.demisto_api.models.inv_playbook_task_complete_data import InvPlaybookTaskCompleteData  # noqa: F401,E501
# from demisto_client.demisto_api.models.investigation_playbook import InvestigationPlaybook  # noqa: F401,E501
from demisto_client.demisto_api.models.notifiable_item import NotifiableItem  # noqa: F401,E501
from demisto_client.demisto_api.models.reputation_calc_alg import ReputationCalcAlg  # noqa: F401,E501
from demisto_client.demisto_api.models.sla import SLA  # noqa: F401,E501
from demisto_client.demisto_api.models.task import Task  # noqa: F401,E501
from demisto_client.demisto_api.models.task_condition import TaskCondition  # noqa: F401,E501
from demisto_client.demisto_api.models.task_loop import TaskLoop  # noqa: F401,E501
from demisto_client.demisto_api.models.task_state import TaskState  # noqa: F401,E501
from demisto_client.demisto_api.models.task_type import TaskType  # noqa: F401,E501
from demisto_client.demisto_api.models.task_view import TaskView  # noqa: F401,E501
from demisto_client.demisto_api.models.timer_trigger import TimerTrigger  # noqa: F401,E501


class InvestigationPlaybookTask(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'arguments': 'dict(str, object)',
        'assignee': 'str',
        'assignee_set': 'bool',
        'blocking_tasks': 'list[str]',
        'comments': 'bool',
        'completed_by': 'str',
        'completed_count': 'int',
        'completed_date': 'datetime',
        'conditions': 'list[TaskCondition]',
        'continue_on_error': 'bool',
        'default_assignee': 'str',
        'default_assignee_complex': 'AdvanceArg',
        'default_reminder': 'int',
        'due_date': 'datetime',
        'due_date_set': 'bool',
        'entries': 'list[str]',
        'evidence_data': 'EvidenceData',
        'execution_count': 'int',
        'field_mapping': 'list[FieldMapping]',
        'for_each_index': 'int',
        'for_each_inputs': 'dict(str, list[object])',
        'form': 'DataCollectionForm',
        'id': 'str',
        'ignore_worker': 'bool',
        'indent': 'int',
        'input': 'str',
        'loop': 'TaskLoop',
        'message': 'NotifiableItem',
        'next_tasks': 'dict(str, list[str])',
        'note': 'bool',
        'outputs': 'dict(str, object)',
        'parent_block_count': 'int',
        'parent_playbook_id': 'str',
        'patched': 'bool',
        'playbook_inputs': 'dict(str, object)',
        'previous_tasks': 'dict(str, list[str])',
        'reminder': 'int',
        'reputation_calc': 'ReputationCalcAlg',
        'restricted_completion': 'bool',
        'script_arguments': 'dict(str, AdvanceArg)',
        'separate_context': 'bool',
        'sla': 'SLA',
        'sla_reminder': 'SLA',
        'start_date': 'datetime',
        'state': 'TaskState',
        'sub_playbook': 'InvestigationPlaybook',
        'task': 'Task',
        'task_complete_data': 'list[InvPlaybookTaskCompleteData]',
        'task_id': 'str',
        'timer_triggers': 'list[TimerTrigger]',
        'type': 'TaskType',
        'view': 'TaskView',
        'will_not_execute_count': 'int'
    }

    attribute_map = {
        'arguments': 'arguments',
        'assignee': 'assignee',
        'assignee_set': 'assigneeSet',
        'blocking_tasks': 'blockingTasks',
        'comments': 'comments',
        'completed_by': 'completedBy',
        'completed_count': 'completedCount',
        'completed_date': 'completedDate',
        'conditions': 'conditions',
        'continue_on_error': 'continueOnError',
        'default_assignee': 'defaultAssignee',
        'default_assignee_complex': 'defaultAssigneeComplex',
        'default_reminder': 'defaultReminder',
        'due_date': 'dueDate',
        'due_date_set': 'dueDateSet',
        'entries': 'entries',
        'evidence_data': 'evidenceData',
        'execution_count': 'executionCount',
        'field_mapping': 'fieldMapping',
        'for_each_index': 'forEachIndex',
        'for_each_inputs': 'forEachInputs',
        'form': 'form',
        'id': 'id',
        'ignore_worker': 'ignoreWorker',
        'indent': 'indent',
        'input': 'input',
        'loop': 'loop',
        'message': 'message',
        'next_tasks': 'nextTasks',
        'note': 'note',
        'outputs': 'outputs',
        'parent_block_count': 'parentBlockCount',
        'parent_playbook_id': 'parentPlaybookID',
        'patched': 'patched',
        'playbook_inputs': 'playbookInputs',
        'previous_tasks': 'previousTasks',
        'reminder': 'reminder',
        'reputation_calc': 'reputationCalc',
        'restricted_completion': 'restrictedCompletion',
        'script_arguments': 'scriptArguments',
        'separate_context': 'separateContext',
        'sla': 'sla',
        'sla_reminder': 'slaReminder',
        'start_date': 'startDate',
        'state': 'state',
        'sub_playbook': 'subPlaybook',
        'task': 'task',
        'task_complete_data': 'taskCompleteData',
        'task_id': 'taskId',
        'timer_triggers': 'timerTriggers',
        'type': 'type',
        'view': 'view',
        'will_not_execute_count': 'willNotExecuteCount'
    }

    def __init__(self, arguments=None, assignee=None, assignee_set=None, blocking_tasks=None, comments=None, completed_by=None, completed_count=None, completed_date=None, conditions=None, continue_on_error=None, default_assignee=None, default_assignee_complex=None, default_reminder=None, due_date=None, due_date_set=None, entries=None, evidence_data=None, execution_count=None, field_mapping=None, for_each_index=None, for_each_inputs=None, form=None, id=None, ignore_worker=None, indent=None, input=None, loop=None, message=None, next_tasks=None, note=None, outputs=None, parent_block_count=None, parent_playbook_id=None, patched=None, playbook_inputs=None, previous_tasks=None, reminder=None, reputation_calc=None, restricted_completion=None, script_arguments=None, separate_context=None, sla=None, sla_reminder=None, start_date=None, state=None, sub_playbook=None, task=None, task_complete_data=None, task_id=None, timer_triggers=None, type=None, view=None, will_not_execute_count=None):  # noqa: E501
        """InvestigationPlaybookTask - a model defined in Swagger"""  # noqa: E501

        self._arguments = None
        self._assignee = None
        self._assignee_set = None
        self._blocking_tasks = None
        self._comments = None
        self._completed_by = None
        self._completed_count = None
        self._completed_date = None
        self._conditions = None
        self._continue_on_error = None
        self._default_assignee = None
        self._default_assignee_complex = None
        self._default_reminder = None
        self._due_date = None
        self._due_date_set = None
        self._entries = None
        self._evidence_data = None
        self._execution_count = None
        self._field_mapping = None
        self._for_each_index = None
        self._for_each_inputs = None
        self._form = None
        self._id = None
        self._ignore_worker = None
        self._indent = None
        self._input = None
        self._loop = None
        self._message = None
        self._next_tasks = None
        self._note = None
        self._outputs = None
        self._parent_block_count = None
        self._parent_playbook_id = None
        self._patched = None
        self._playbook_inputs = None
        self._previous_tasks = None
        self._reminder = None
        self._reputation_calc = None
        self._restricted_completion = None
        self._script_arguments = None
        self._separate_context = None
        self._sla = None
        self._sla_reminder = None
        self._start_date = None
        self._state = None
        self._sub_playbook = None
        self._task = None
        self._task_complete_data = None
        self._task_id = None
        self._timer_triggers = None
        self._type = None
        self._view = None
        self._will_not_execute_count = None
        self.discriminator = None

        if arguments is not None:
            self.arguments = arguments
        if assignee is not None:
            self.assignee = assignee
        if assignee_set is not None:
            self.assignee_set = assignee_set
        if blocking_tasks is not None:
            self.blocking_tasks = blocking_tasks
        if comments is not None:
            self.comments = comments
        if completed_by is not None:
            self.completed_by = completed_by
        if completed_count is not None:
            self.completed_count = completed_count
        if completed_date is not None:
            self.completed_date = completed_date
        if conditions is not None:
            self.conditions = conditions
        if continue_on_error is not None:
            self.continue_on_error = continue_on_error
        if default_assignee is not None:
            self.default_assignee = default_assignee
        if default_assignee_complex is not None:
            self.default_assignee_complex = default_assignee_complex
        if default_reminder is not None:
            self.default_reminder = default_reminder
        if due_date is not None:
            self.due_date = due_date
        if due_date_set is not None:
            self.due_date_set = due_date_set
        if entries is not None:
            self.entries = entries
        if evidence_data is not None:
            self.evidence_data = evidence_data
        if execution_count is not None:
            self.execution_count = execution_count
        if field_mapping is not None:
            self.field_mapping = field_mapping
        if for_each_index is not None:
            self.for_each_index = for_each_index
        if for_each_inputs is not None:
            self.for_each_inputs = for_each_inputs
        if form is not None:
            self.form = form
        if id is not None:
            self.id = id
        if ignore_worker is not None:
            self.ignore_worker = ignore_worker
        if indent is not None:
            self.indent = indent
        if input is not None:
            self.input = input
        if loop is not None:
            self.loop = loop
        if message is not None:
            self.message = message
        if next_tasks is not None:
            self.next_tasks = next_tasks
        if note is not None:
            self.note = note
        if outputs is not None:
            self.outputs = outputs
        if parent_block_count is not None:
            self.parent_block_count = parent_block_count
        if parent_playbook_id is not None:
            self.parent_playbook_id = parent_playbook_id
        if patched is not None:
            self.patched = patched
        if playbook_inputs is not None:
            self.playbook_inputs = playbook_inputs
        if previous_tasks is not None:
            self.previous_tasks = previous_tasks
        if reminder is not None:
            self.reminder = reminder
        if reputation_calc is not None:
            self.reputation_calc = reputation_calc
        if restricted_completion is not None:
            self.restricted_completion = restricted_completion
        if script_arguments is not None:
            self.script_arguments = script_arguments
        if separate_context is not None:
            self.separate_context = separate_context
        if sla is not None:
            self.sla = sla
        if sla_reminder is not None:
            self.sla_reminder = sla_reminder
        if start_date is not None:
            self.start_date = start_date
        if state is not None:
            self.state = state
        if sub_playbook is not None:
            self.sub_playbook = sub_playbook
        if task is not None:
            self.task = task
        if task_complete_data is not None:
            self.task_complete_data = task_complete_data
        if task_id is not None:
            self.task_id = task_id
        if timer_triggers is not None:
            self.timer_triggers = timer_triggers
        if type is not None:
            self.type = type
        if view is not None:
            self.view = view
        if will_not_execute_count is not None:
            self.will_not_execute_count = will_not_execute_count

    @property
    def arguments(self):
        """Gets the arguments of this InvestigationPlaybookTask.  # noqa: E501


        :return: The arguments of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """Sets the arguments of this InvestigationPlaybookTask.


        :param arguments: The arguments of this InvestigationPlaybookTask.  # noqa: E501
        :type: dict(str, object)
        """

        self._arguments = arguments

    @property
    def assignee(self):
        """Gets the assignee of this InvestigationPlaybookTask.  # noqa: E501


        :return: The assignee of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: str
        """
        return self._assignee

    @assignee.setter
    def assignee(self, assignee):
        """Sets the assignee of this InvestigationPlaybookTask.


        :param assignee: The assignee of this InvestigationPlaybookTask.  # noqa: E501
        :type: str
        """

        self._assignee = assignee

    @property
    def assignee_set(self):
        """Gets the assignee_set of this InvestigationPlaybookTask.  # noqa: E501


        :return: The assignee_set of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._assignee_set

    @assignee_set.setter
    def assignee_set(self, assignee_set):
        """Sets the assignee_set of this InvestigationPlaybookTask.


        :param assignee_set: The assignee_set of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._assignee_set = assignee_set

    @property
    def blocking_tasks(self):
        """Gets the blocking_tasks of this InvestigationPlaybookTask.  # noqa: E501


        :return: The blocking_tasks of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: list[str]
        """
        return self._blocking_tasks

    @blocking_tasks.setter
    def blocking_tasks(self, blocking_tasks):
        """Sets the blocking_tasks of this InvestigationPlaybookTask.


        :param blocking_tasks: The blocking_tasks of this InvestigationPlaybookTask.  # noqa: E501
        :type: list[str]
        """

        self._blocking_tasks = blocking_tasks

    @property
    def comments(self):
        """Gets the comments of this InvestigationPlaybookTask.  # noqa: E501

        Whether this task had any comments or not  # noqa: E501

        :return: The comments of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """Sets the comments of this InvestigationPlaybookTask.

        Whether this task had any comments or not  # noqa: E501

        :param comments: The comments of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._comments = comments

    @property
    def completed_by(self):
        """Gets the completed_by of this InvestigationPlaybookTask.  # noqa: E501


        :return: The completed_by of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: str
        """
        return self._completed_by

    @completed_by.setter
    def completed_by(self, completed_by):
        """Sets the completed_by of this InvestigationPlaybookTask.


        :param completed_by: The completed_by of this InvestigationPlaybookTask.  # noqa: E501
        :type: str
        """

        self._completed_by = completed_by

    @property
    def completed_count(self):
        """Gets the completed_count of this InvestigationPlaybookTask.  # noqa: E501


        :return: The completed_count of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: int
        """
        return self._completed_count

    @completed_count.setter
    def completed_count(self, completed_count):
        """Sets the completed_count of this InvestigationPlaybookTask.


        :param completed_count: The completed_count of this InvestigationPlaybookTask.  # noqa: E501
        :type: int
        """

        self._completed_count = completed_count

    @property
    def completed_date(self):
        """Gets the completed_date of this InvestigationPlaybookTask.  # noqa: E501


        :return: The completed_date of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: datetime
        """
        return self._completed_date

    @completed_date.setter
    def completed_date(self, completed_date):
        """Sets the completed_date of this InvestigationPlaybookTask.


        :param completed_date: The completed_date of this InvestigationPlaybookTask.  # noqa: E501
        :type: datetime
        """

        self._completed_date = completed_date

    @property
    def conditions(self):
        """Gets the conditions of this InvestigationPlaybookTask.  # noqa: E501

        Conditions - optional list of conditions to run when task is conditional. we check conditions by their order (e.i. - considering the first one that satisfied)  # noqa: E501

        :return: The conditions of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: list[TaskCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """Sets the conditions of this InvestigationPlaybookTask.

        Conditions - optional list of conditions to run when task is conditional. we check conditions by their order (e.i. - considering the first one that satisfied)  # noqa: E501

        :param conditions: The conditions of this InvestigationPlaybookTask.  # noqa: E501
        :type: list[TaskCondition]
        """

        self._conditions = conditions

    @property
    def continue_on_error(self):
        """Gets the continue_on_error of this InvestigationPlaybookTask.  # noqa: E501


        :return: The continue_on_error of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._continue_on_error

    @continue_on_error.setter
    def continue_on_error(self, continue_on_error):
        """Sets the continue_on_error of this InvestigationPlaybookTask.


        :param continue_on_error: The continue_on_error of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._continue_on_error = continue_on_error

    @property
    def default_assignee(self):
        """Gets the default_assignee of this InvestigationPlaybookTask.  # noqa: E501


        :return: The default_assignee of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: str
        """
        return self._default_assignee

    @default_assignee.setter
    def default_assignee(self, default_assignee):
        """Sets the default_assignee of this InvestigationPlaybookTask.


        :param default_assignee: The default_assignee of this InvestigationPlaybookTask.  # noqa: E501
        :type: str
        """

        self._default_assignee = default_assignee

    @property
    def default_assignee_complex(self):
        """Gets the default_assignee_complex of this InvestigationPlaybookTask.  # noqa: E501


        :return: The default_assignee_complex of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: AdvanceArg
        """
        return self._default_assignee_complex

    @default_assignee_complex.setter
    def default_assignee_complex(self, default_assignee_complex):
        """Sets the default_assignee_complex of this InvestigationPlaybookTask.


        :param default_assignee_complex: The default_assignee_complex of this InvestigationPlaybookTask.  # noqa: E501
        :type: AdvanceArg
        """

        self._default_assignee_complex = default_assignee_complex

    @property
    def default_reminder(self):
        """Gets the default_reminder of this InvestigationPlaybookTask.  # noqa: E501


        :return: The default_reminder of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: int
        """
        return self._default_reminder

    @default_reminder.setter
    def default_reminder(self, default_reminder):
        """Sets the default_reminder of this InvestigationPlaybookTask.


        :param default_reminder: The default_reminder of this InvestigationPlaybookTask.  # noqa: E501
        :type: int
        """

        self._default_reminder = default_reminder

    @property
    def due_date(self):
        """Gets the due_date of this InvestigationPlaybookTask.  # noqa: E501


        :return: The due_date of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: datetime
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this InvestigationPlaybookTask.


        :param due_date: The due_date of this InvestigationPlaybookTask.  # noqa: E501
        :type: datetime
        """

        self._due_date = due_date

    @property
    def due_date_set(self):
        """Gets the due_date_set of this InvestigationPlaybookTask.  # noqa: E501


        :return: The due_date_set of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._due_date_set

    @due_date_set.setter
    def due_date_set(self, due_date_set):
        """Sets the due_date_set of this InvestigationPlaybookTask.


        :param due_date_set: The due_date_set of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._due_date_set = due_date_set

    @property
    def entries(self):
        """Gets the entries of this InvestigationPlaybookTask.  # noqa: E501


        :return: The entries of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: list[str]
        """
        return self._entries

    @entries.setter
    def entries(self, entries):
        """Sets the entries of this InvestigationPlaybookTask.


        :param entries: The entries of this InvestigationPlaybookTask.  # noqa: E501
        :type: list[str]
        """

        self._entries = entries

    @property
    def evidence_data(self):
        """Gets the evidence_data of this InvestigationPlaybookTask.  # noqa: E501


        :return: The evidence_data of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: EvidenceData
        """
        return self._evidence_data

    @evidence_data.setter
    def evidence_data(self, evidence_data):
        """Sets the evidence_data of this InvestigationPlaybookTask.


        :param evidence_data: The evidence_data of this InvestigationPlaybookTask.  # noqa: E501
        :type: EvidenceData
        """

        self._evidence_data = evidence_data

    @property
    def execution_count(self):
        """Gets the execution_count of this InvestigationPlaybookTask.  # noqa: E501


        :return: The execution_count of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: int
        """
        return self._execution_count

    @execution_count.setter
    def execution_count(self, execution_count):
        """Sets the execution_count of this InvestigationPlaybookTask.


        :param execution_count: The execution_count of this InvestigationPlaybookTask.  # noqa: E501
        :type: int
        """

        self._execution_count = execution_count

    @property
    def field_mapping(self):
        """Gets the field_mapping of this InvestigationPlaybookTask.  # noqa: E501


        :return: The field_mapping of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: list[FieldMapping]
        """
        return self._field_mapping

    @field_mapping.setter
    def field_mapping(self, field_mapping):
        """Sets the field_mapping of this InvestigationPlaybookTask.


        :param field_mapping: The field_mapping of this InvestigationPlaybookTask.  # noqa: E501
        :type: list[FieldMapping]
        """

        self._field_mapping = field_mapping

    @property
    def for_each_index(self):
        """Gets the for_each_index of this InvestigationPlaybookTask.  # noqa: E501

        Parameters needed for loops  # noqa: E501

        :return: The for_each_index of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: int
        """
        return self._for_each_index

    @for_each_index.setter
    def for_each_index(self, for_each_index):
        """Sets the for_each_index of this InvestigationPlaybookTask.

        Parameters needed for loops  # noqa: E501

        :param for_each_index: The for_each_index of this InvestigationPlaybookTask.  # noqa: E501
        :type: int
        """

        self._for_each_index = for_each_index

    @property
    def for_each_inputs(self):
        """Gets the for_each_inputs of this InvestigationPlaybookTask.  # noqa: E501


        :return: The for_each_inputs of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: dict(str, list[object])
        """
        return self._for_each_inputs

    @for_each_inputs.setter
    def for_each_inputs(self, for_each_inputs):
        """Sets the for_each_inputs of this InvestigationPlaybookTask.


        :param for_each_inputs: The for_each_inputs of this InvestigationPlaybookTask.  # noqa: E501
        :type: dict(str, list[object])
        """

        self._for_each_inputs = for_each_inputs

    @property
    def form(self):
        """Gets the form of this InvestigationPlaybookTask.  # noqa: E501


        :return: The form of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: DataCollectionForm
        """
        return self._form

    @form.setter
    def form(self, form):
        """Sets the form of this InvestigationPlaybookTask.


        :param form: The form of this InvestigationPlaybookTask.  # noqa: E501
        :type: DataCollectionForm
        """

        self._form = form

    @property
    def id(self):
        """Gets the id of this InvestigationPlaybookTask.  # noqa: E501


        :return: The id of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this InvestigationPlaybookTask.


        :param id: The id of this InvestigationPlaybookTask.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def ignore_worker(self):
        """Gets the ignore_worker of this InvestigationPlaybookTask.  # noqa: E501

        Do not run this task in a worker  # noqa: E501

        :return: The ignore_worker of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._ignore_worker

    @ignore_worker.setter
    def ignore_worker(self, ignore_worker):
        """Sets the ignore_worker of this InvestigationPlaybookTask.

        Do not run this task in a worker  # noqa: E501

        :param ignore_worker: The ignore_worker of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._ignore_worker = ignore_worker

    @property
    def indent(self):
        """Gets the indent of this InvestigationPlaybookTask.  # noqa: E501


        :return: The indent of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: int
        """
        return self._indent

    @indent.setter
    def indent(self, indent):
        """Sets the indent of this InvestigationPlaybookTask.


        :param indent: The indent of this InvestigationPlaybookTask.  # noqa: E501
        :type: int
        """

        self._indent = indent

    @property
    def input(self):
        """Gets the input of this InvestigationPlaybookTask.  # noqa: E501


        :return: The input of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: str
        """
        return self._input

    @input.setter
    def input(self, input):
        """Sets the input of this InvestigationPlaybookTask.


        :param input: The input of this InvestigationPlaybookTask.  # noqa: E501
        :type: str
        """

        self._input = input

    @property
    def loop(self):
        """Gets the loop of this InvestigationPlaybookTask.  # noqa: E501


        :return: The loop of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: TaskLoop
        """
        return self._loop

    @loop.setter
    def loop(self, loop):
        """Sets the loop of this InvestigationPlaybookTask.


        :param loop: The loop of this InvestigationPlaybookTask.  # noqa: E501
        :type: TaskLoop
        """

        self._loop = loop

    @property
    def message(self):
        """Gets the message of this InvestigationPlaybookTask.  # noqa: E501


        :return: The message of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: NotifiableItem
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this InvestigationPlaybookTask.


        :param message: The message of this InvestigationPlaybookTask.  # noqa: E501
        :type: NotifiableItem
        """

        self._message = message

    @property
    def next_tasks(self):
        """Gets the next_tasks of this InvestigationPlaybookTask.  # noqa: E501


        :return: The next_tasks of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._next_tasks

    @next_tasks.setter
    def next_tasks(self, next_tasks):
        """Sets the next_tasks of this InvestigationPlaybookTask.


        :param next_tasks: The next_tasks of this InvestigationPlaybookTask.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._next_tasks = next_tasks

    @property
    def note(self):
        """Gets the note of this InvestigationPlaybookTask.  # noqa: E501


        :return: The note of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this InvestigationPlaybookTask.


        :param note: The note of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._note = note

    @property
    def outputs(self):
        """Gets the outputs of this InvestigationPlaybookTask.  # noqa: E501


        :return: The outputs of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """Sets the outputs of this InvestigationPlaybookTask.


        :param outputs: The outputs of this InvestigationPlaybookTask.  # noqa: E501
        :type: dict(str, object)
        """

        self._outputs = outputs

    @property
    def parent_block_count(self):
        """Gets the parent_block_count of this InvestigationPlaybookTask.  # noqa: E501

        the number of tasks that are waiting on blocked in subplaybooks of this task  # noqa: E501

        :return: The parent_block_count of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: int
        """
        return self._parent_block_count

    @parent_block_count.setter
    def parent_block_count(self, parent_block_count):
        """Sets the parent_block_count of this InvestigationPlaybookTask.

        the number of tasks that are waiting on blocked in subplaybooks of this task  # noqa: E501

        :param parent_block_count: The parent_block_count of this InvestigationPlaybookTask.  # noqa: E501
        :type: int
        """

        self._parent_block_count = parent_block_count

    @property
    def parent_playbook_id(self):
        """Gets the parent_playbook_id of this InvestigationPlaybookTask.  # noqa: E501


        :return: The parent_playbook_id of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: str
        """
        return self._parent_playbook_id

    @parent_playbook_id.setter
    def parent_playbook_id(self, parent_playbook_id):
        """Sets the parent_playbook_id of this InvestigationPlaybookTask.


        :param parent_playbook_id: The parent_playbook_id of this InvestigationPlaybookTask.  # noqa: E501
        :type: str
        """

        self._parent_playbook_id = parent_playbook_id

    @property
    def patched(self):
        """Gets the patched of this InvestigationPlaybookTask.  # noqa: E501

        Indicates whether this task was patched to InvPB and did not originally belong to the playbook  # noqa: E501

        :return: The patched of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._patched

    @patched.setter
    def patched(self, patched):
        """Sets the patched of this InvestigationPlaybookTask.

        Indicates whether this task was patched to InvPB and did not originally belong to the playbook  # noqa: E501

        :param patched: The patched of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._patched = patched

    @property
    def playbook_inputs(self):
        """Gets the playbook_inputs of this InvestigationPlaybookTask.  # noqa: E501


        :return: The playbook_inputs of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._playbook_inputs

    @playbook_inputs.setter
    def playbook_inputs(self, playbook_inputs):
        """Sets the playbook_inputs of this InvestigationPlaybookTask.


        :param playbook_inputs: The playbook_inputs of this InvestigationPlaybookTask.  # noqa: E501
        :type: dict(str, object)
        """

        self._playbook_inputs = playbook_inputs

    @property
    def previous_tasks(self):
        """Gets the previous_tasks of this InvestigationPlaybookTask.  # noqa: E501


        :return: The previous_tasks of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._previous_tasks

    @previous_tasks.setter
    def previous_tasks(self, previous_tasks):
        """Sets the previous_tasks of this InvestigationPlaybookTask.


        :param previous_tasks: The previous_tasks of this InvestigationPlaybookTask.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._previous_tasks = previous_tasks

    @property
    def reminder(self):
        """Gets the reminder of this InvestigationPlaybookTask.  # noqa: E501

        Duration in minutes, this field is not persisted here  # noqa: E501

        :return: The reminder of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: int
        """
        return self._reminder

    @reminder.setter
    def reminder(self, reminder):
        """Sets the reminder of this InvestigationPlaybookTask.

        Duration in minutes, this field is not persisted here  # noqa: E501

        :param reminder: The reminder of this InvestigationPlaybookTask.  # noqa: E501
        :type: int
        """

        self._reminder = reminder

    @property
    def reputation_calc(self):
        """Gets the reputation_calc of this InvestigationPlaybookTask.  # noqa: E501


        :return: The reputation_calc of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: ReputationCalcAlg
        """
        return self._reputation_calc

    @reputation_calc.setter
    def reputation_calc(self, reputation_calc):
        """Sets the reputation_calc of this InvestigationPlaybookTask.


        :param reputation_calc: The reputation_calc of this InvestigationPlaybookTask.  # noqa: E501
        :type: ReputationCalcAlg
        """

        self._reputation_calc = reputation_calc

    @property
    def restricted_completion(self):
        """Gets the restricted_completion of this InvestigationPlaybookTask.  # noqa: E501


        :return: The restricted_completion of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._restricted_completion

    @restricted_completion.setter
    def restricted_completion(self, restricted_completion):
        """Sets the restricted_completion of this InvestigationPlaybookTask.


        :param restricted_completion: The restricted_completion of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._restricted_completion = restricted_completion

    @property
    def script_arguments(self):
        """Gets the script_arguments of this InvestigationPlaybookTask.  # noqa: E501


        :return: The script_arguments of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: dict(str, AdvanceArg)
        """
        return self._script_arguments

    @script_arguments.setter
    def script_arguments(self, script_arguments):
        """Sets the script_arguments of this InvestigationPlaybookTask.


        :param script_arguments: The script_arguments of this InvestigationPlaybookTask.  # noqa: E501
        :type: dict(str, AdvanceArg)
        """

        self._script_arguments = script_arguments

    @property
    def separate_context(self):
        """Gets the separate_context of this InvestigationPlaybookTask.  # noqa: E501


        :return: The separate_context of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: bool
        """
        return self._separate_context

    @separate_context.setter
    def separate_context(self, separate_context):
        """Sets the separate_context of this InvestigationPlaybookTask.


        :param separate_context: The separate_context of this InvestigationPlaybookTask.  # noqa: E501
        :type: bool
        """

        self._separate_context = separate_context

    @property
    def sla(self):
        """Gets the sla of this InvestigationPlaybookTask.  # noqa: E501


        :return: The sla of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: SLA
        """
        return self._sla

    @sla.setter
    def sla(self, sla):
        """Sets the sla of this InvestigationPlaybookTask.


        :param sla: The sla of this InvestigationPlaybookTask.  # noqa: E501
        :type: SLA
        """

        self._sla = sla

    @property
    def sla_reminder(self):
        """Gets the sla_reminder of this InvestigationPlaybookTask.  # noqa: E501


        :return: The sla_reminder of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: SLA
        """
        return self._sla_reminder

    @sla_reminder.setter
    def sla_reminder(self, sla_reminder):
        """Sets the sla_reminder of this InvestigationPlaybookTask.


        :param sla_reminder: The sla_reminder of this InvestigationPlaybookTask.  # noqa: E501
        :type: SLA
        """

        self._sla_reminder = sla_reminder

    @property
    def start_date(self):
        """Gets the start_date of this InvestigationPlaybookTask.  # noqa: E501


        :return: The start_date of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this InvestigationPlaybookTask.


        :param start_date: The start_date of this InvestigationPlaybookTask.  # noqa: E501
        :type: datetime
        """

        self._start_date = start_date

    @property
    def state(self):
        """Gets the state of this InvestigationPlaybookTask.  # noqa: E501


        :return: The state of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: TaskState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this InvestigationPlaybookTask.


        :param state: The state of this InvestigationPlaybookTask.  # noqa: E501
        :type: TaskState
        """

        self._state = state

    @property
    def sub_playbook(self):
        """Gets the sub_playbook of this InvestigationPlaybookTask.  # noqa: E501


        :return: The sub_playbook of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: InvestigationPlaybook
        """
        return self._sub_playbook

    @sub_playbook.setter
    def sub_playbook(self, sub_playbook):
        """Sets the sub_playbook of this InvestigationPlaybookTask.


        :param sub_playbook: The sub_playbook of this InvestigationPlaybookTask.  # noqa: E501
        :type: InvestigationPlaybook
        """

        self._sub_playbook = sub_playbook

    @property
    def task(self):
        """Gets the task of this InvestigationPlaybookTask.  # noqa: E501


        :return: The task of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: Task
        """
        return self._task

    @task.setter
    def task(self, task):
        """Sets the task of this InvestigationPlaybookTask.


        :param task: The task of this InvestigationPlaybookTask.  # noqa: E501
        :type: Task
        """

        self._task = task

    @property
    def task_complete_data(self):
        """Gets the task_complete_data of this InvestigationPlaybookTask.  # noqa: E501

        History complete data  # noqa: E501

        :return: The task_complete_data of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: list[InvPlaybookTaskCompleteData]
        """
        return self._task_complete_data

    @task_complete_data.setter
    def task_complete_data(self, task_complete_data):
        """Sets the task_complete_data of this InvestigationPlaybookTask.

        History complete data  # noqa: E501

        :param task_complete_data: The task_complete_data of this InvestigationPlaybookTask.  # noqa: E501
        :type: list[InvPlaybookTaskCompleteData]
        """

        self._task_complete_data = task_complete_data

    @property
    def task_id(self):
        """Gets the task_id of this InvestigationPlaybookTask.  # noqa: E501


        :return: The task_id of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this InvestigationPlaybookTask.


        :param task_id: The task_id of this InvestigationPlaybookTask.  # noqa: E501
        :type: str
        """

        self._task_id = task_id

    @property
    def timer_triggers(self):
        """Gets the timer_triggers of this InvestigationPlaybookTask.  # noqa: E501

        SLA fields  # noqa: E501

        :return: The timer_triggers of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: list[TimerTrigger]
        """
        return self._timer_triggers

    @timer_triggers.setter
    def timer_triggers(self, timer_triggers):
        """Sets the timer_triggers of this InvestigationPlaybookTask.

        SLA fields  # noqa: E501

        :param timer_triggers: The timer_triggers of this InvestigationPlaybookTask.  # noqa: E501
        :type: list[TimerTrigger]
        """

        self._timer_triggers = timer_triggers

    @property
    def type(self):
        """Gets the type of this InvestigationPlaybookTask.  # noqa: E501


        :return: The type of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: TaskType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this InvestigationPlaybookTask.


        :param type: The type of this InvestigationPlaybookTask.  # noqa: E501
        :type: TaskType
        """

        self._type = type

    @property
    def view(self):
        """Gets the view of this InvestigationPlaybookTask.  # noqa: E501


        :return: The view of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: TaskView
        """
        return self._view

    @view.setter
    def view(self, view):
        """Sets the view of this InvestigationPlaybookTask.


        :param view: The view of this InvestigationPlaybookTask.  # noqa: E501
        :type: TaskView
        """

        self._view = view

    @property
    def will_not_execute_count(self):
        """Gets the will_not_execute_count of this InvestigationPlaybookTask.  # noqa: E501


        :return: The will_not_execute_count of this InvestigationPlaybookTask.  # noqa: E501
        :rtype: int
        """
        return self._will_not_execute_count

    @will_not_execute_count.setter
    def will_not_execute_count(self, will_not_execute_count):
        """Sets the will_not_execute_count of this InvestigationPlaybookTask.


        :param will_not_execute_count: The will_not_execute_count of this InvestigationPlaybookTask.  # noqa: E501
        :type: int
        """

        self._will_not_execute_count = will_not_execute_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(InvestigationPlaybookTask, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InvestigationPlaybookTask):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
