# coding: utf-8

"""
    Demisto API

    This is the public REST API to integrate with the demisto server. HTTP request can be sent using any HTTP-client.  For an example dedicated client take a look at: https://github.com/demisto/demisto-py.  Requests must include API-key that can be generated in the Demisto web client under 'Settings' -> 'Integrations' -> 'API keys'   Optimistic Locking and Versioning\\:  When using Demisto REST API, you will need to make sure to work on the latest version of the item (incident, entry, etc.), otherwise, you will get a DB version error (which not allow you to override a newer item). In addition, you can pass 'version\\: -1' to force data override (make sure that other users data might be lost).  Assume that Alice and Bob both read the same data from Demisto server, then they both changed the data, and then both tried to write the new versions back to the server. Whose changes should be saved? Alice’s? Bob’s? To solve this, each data item in Demisto has a numeric incremental version. If Alice saved an item with version 4 and Bob trying to save the same item with version 3, Demisto will rollback Bob request and returns a DB version conflict error. Bob will need to get the latest item and work on it so Alice work will not get lost.  Example request using 'curl'\\:  ``` curl 'https://hostname:443/incidents/search' -H 'content-type: application/json' -H 'accept: application/json' -H 'Authorization: <API Key goes here>' --data-binary '{\"filter\":{\"query\":\"-status:closed -category:job\",\"period\":{\"by\":\"day\",\"fromValue\":7}}}' --compressed ```  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from demisto_client.demisto_api.models.advance_arg import AdvanceArg  # noqa: F401,E501
from demisto_client.demisto_api.models.arg_filter import ArgFilter  # noqa: F401,E501


class TaskLoop(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'brand': 'str',
        'builtin_condition': 'list[ArgFilter]',
        'exit_condition': 'str',
        'for_each': 'bool',
        'is_command': 'bool',
        'script_arguments': 'dict(str, AdvanceArg)',
        'script_id': 'str',
        'wait': 'int'
    }

    attribute_map = {
        'brand': 'brand',
        'builtin_condition': 'builtinCondition',
        'exit_condition': 'exitCondition',
        'for_each': 'forEach',
        'is_command': 'isCommand',
        'script_arguments': 'scriptArguments',
        'script_id': 'scriptId',
        'wait': 'wait'
    }

    def __init__(self, brand=None, builtin_condition=None, exit_condition=None, for_each=None, is_command=None, script_arguments=None, script_id=None, wait=None):  # noqa: E501
        """TaskLoop - a model defined in Swagger"""  # noqa: E501

        self._brand = None
        self._builtin_condition = None
        self._exit_condition = None
        self._for_each = None
        self._is_command = None
        self._script_arguments = None
        self._script_id = None
        self._wait = None
        self.discriminator = None

        if brand is not None:
            self.brand = brand
        if builtin_condition is not None:
            self.builtin_condition = builtin_condition
        if exit_condition is not None:
            self.exit_condition = exit_condition
        if for_each is not None:
            self.for_each = for_each
        if is_command is not None:
            self.is_command = is_command
        if script_arguments is not None:
            self.script_arguments = script_arguments
        if script_id is not None:
            self.script_id = script_id
        if wait is not None:
            self.wait = wait

    @property
    def brand(self):
        """Gets the brand of this TaskLoop.  # noqa: E501


        :return: The brand of this TaskLoop.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this TaskLoop.


        :param brand: The brand of this TaskLoop.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def builtin_condition(self):
        """Gets the builtin_condition of this TaskLoop.  # noqa: E501


        :return: The builtin_condition of this TaskLoop.  # noqa: E501
        :rtype: list[ArgFilter]
        """
        return self._builtin_condition

    @builtin_condition.setter
    def builtin_condition(self, builtin_condition):
        """Sets the builtin_condition of this TaskLoop.


        :param builtin_condition: The builtin_condition of this TaskLoop.  # noqa: E501
        :type: list[ArgFilter]
        """

        self._builtin_condition = builtin_condition

    @property
    def exit_condition(self):
        """Gets the exit_condition of this TaskLoop.  # noqa: E501


        :return: The exit_condition of this TaskLoop.  # noqa: E501
        :rtype: str
        """
        return self._exit_condition

    @exit_condition.setter
    def exit_condition(self, exit_condition):
        """Sets the exit_condition of this TaskLoop.


        :param exit_condition: The exit_condition of this TaskLoop.  # noqa: E501
        :type: str
        """

        self._exit_condition = exit_condition

    @property
    def for_each(self):
        """Gets the for_each of this TaskLoop.  # noqa: E501


        :return: The for_each of this TaskLoop.  # noqa: E501
        :rtype: bool
        """
        return self._for_each

    @for_each.setter
    def for_each(self, for_each):
        """Sets the for_each of this TaskLoop.


        :param for_each: The for_each of this TaskLoop.  # noqa: E501
        :type: bool
        """

        self._for_each = for_each

    @property
    def is_command(self):
        """Gets the is_command of this TaskLoop.  # noqa: E501


        :return: The is_command of this TaskLoop.  # noqa: E501
        :rtype: bool
        """
        return self._is_command

    @is_command.setter
    def is_command(self, is_command):
        """Sets the is_command of this TaskLoop.


        :param is_command: The is_command of this TaskLoop.  # noqa: E501
        :type: bool
        """

        self._is_command = is_command

    @property
    def script_arguments(self):
        """Gets the script_arguments of this TaskLoop.  # noqa: E501


        :return: The script_arguments of this TaskLoop.  # noqa: E501
        :rtype: dict(str, AdvanceArg)
        """
        return self._script_arguments

    @script_arguments.setter
    def script_arguments(self, script_arguments):
        """Sets the script_arguments of this TaskLoop.


        :param script_arguments: The script_arguments of this TaskLoop.  # noqa: E501
        :type: dict(str, AdvanceArg)
        """

        self._script_arguments = script_arguments

    @property
    def script_id(self):
        """Gets the script_id of this TaskLoop.  # noqa: E501


        :return: The script_id of this TaskLoop.  # noqa: E501
        :rtype: str
        """
        return self._script_id

    @script_id.setter
    def script_id(self, script_id):
        """Sets the script_id of this TaskLoop.


        :param script_id: The script_id of this TaskLoop.  # noqa: E501
        :type: str
        """

        self._script_id = script_id

    @property
    def wait(self):
        """Gets the wait of this TaskLoop.  # noqa: E501


        :return: The wait of this TaskLoop.  # noqa: E501
        :rtype: int
        """
        return self._wait

    @wait.setter
    def wait(self, wait):
        """Sets the wait of this TaskLoop.


        :param wait: The wait of this TaskLoop.  # noqa: E501
        :type: int
        """

        self._wait = wait

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TaskLoop, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TaskLoop):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
