---
search:
  exclude: true
---
# コード例

[repo](https://github.com/openai/openai-agents-python/tree/main/examples) の examples セクションには、SDK のさまざまなサンプル実装が用意されています。これらのコード例は、異なるパターンや機能を示す複数のカテゴリーに整理されています。


## カテゴリー

- **[agent_patterns](https://github.com/openai/openai-agents-python/tree/main/examples/agent_patterns):**  
  このカテゴリーのコード例では、一般的なエージェント設計パターンを紹介しています。  
    - 決定論的ワークフロー  
    - ツールとしてのエージェント  
    - エージェントの並列実行  

- **[basic](https://github.com/openai/openai-agents-python/tree/main/examples/basic):**  
  SDK の基礎的な機能を示すコード例です。  
    - 動的な system prompt  
    - ストリーミング出力  
    - ライフサイクルイベント  

- **[tool examples](https://github.com/openai/openai-agents-python/tree/main/examples/tools):**  
  Web 検索やファイル検索といった OpenAI がホストするツールの実装方法と、それらをエージェントに統合する方法を学べます。

- **[model providers](https://github.com/openai/openai-agents-python/tree/main/examples/model_providers):**  
  OpenAI 以外のモデルを SDK で利用する方法を探究できます。

- **[handoffs](https://github.com/openai/openai-agents-python/tree/main/examples/handoffs):**  
  エージェントのハンドオフを実践的に示すコード例です。

- **[mcp](https://github.com/openai/openai-agents-python/tree/main/examples/mcp):**  
  MCP でエージェントを構築する方法を学べます。

- **[customer_service](https://github.com/openai/openai-agents-python/tree/main/examples/customer_service)** と **[research_bot](https://github.com/openai/openai-agents-python/tree/main/examples/research_bot):**  
  実際のユースケースを想定した、より発展的な 2 つのコード例です。  
    - **customer_service**: 航空会社向けカスタマーサービスシステムの例。  
    - **research_bot**: シンプルなディープリサーチクローン。  

- **[voice](https://github.com/openai/openai-agents-python/tree/main/examples/voice):**  
  TTS と STT モデルを用いた音声エージェントのコード例です。

- **[realtime](https://github.com/openai/openai-agents-python/tree/main/examples/realtime):**  
  SDK を使用してリアルタイム体験を構築する方法を示すコード例です。